/*
 * luxi.c
 *
 * by Gary Wong, 2002
 *
 * This file contains TrueType representations of the digit glyphs
 * extracted from the Luxi fonts for use with GNU Backgammon.  The
 * fonts themselves were created by Bigelow and Holmes, and are
 * distributed in accordance with the original license:
 *
 * Luxi fonts copyright (c) 2001 by Bigelow & Holmes Inc. Luxi font
 * instruction code copyright (c) 2001 by URW++ GmbH. All Rights
 * Reserved. Luxi is a registered trademark of Bigelow & Holmes Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of these Fonts and associated documentation files (the "Font
 * Software"), to deal in the Font Software, including without limitation
 * the rights to use, copy, merge, publish, distribute, sublicense,
 * and/or sell copies of the Font Software, and to permit persons to whom
 * the Font Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright and trademark notices and this permission notice
 * shall be included in all copies of one or more of the Font Software.
 * 
 * The Font Software may not be modified, altered, or added to, and in
 * particular the designs of glyphs or characters in the Fonts may not be
 * modified nor may additional glyphs or characters be added to the
 * Fonts. This License becomes null and void when the Fonts or Font
 * Software have been modified.
 * 
 * THE FONT SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF COPYRIGHT, PATENT, TRADEMARK, OR OTHER RIGHT. IN NO EVENT SHALL
 * BIGELOW & HOLMES INC. OR URW++ GMBH. BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, INCLUDING ANY GENERAL, SPECIAL, INDIRECT,
 * INCIDENTAL, OR CONSEQUENTIAL DAMAGES, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF THE USE OR INABILITY
 * TO USE THE FONT SOFTWARE OR FROM OTHER DEALINGS IN THE FONT SOFTWARE.
 * 
 * Except as contained in this notice, the names of Bigelow & Holmes
 * Inc. and URW++ GmbH. shall not be used in advertising or otherwise to
 * promote the sale, use or other dealings in this Font Software without
 * prior written authorization from Bigelow & Holmes Inc. and URW++ GmbH.
 * 
 * For further information, contact:
 * 
 * info@urwpp.de or design@bigelowandholmes.com
 *
 */

unsigned char auchLuxiRB[] = {
    0x00, 0x01, 0x00, 0x00, 0x00, 0x11, 0x01, 0x00, 0x00, 0x04, 0x00, 0x10, 
    0x4F, 0x53, 0x2F, 0x32, 0x6C, 0x8D, 0x58, 0xFB, 0x00, 0x00, 0x01, 0x1C, 
    0x00, 0x00, 0x00, 0x60, 0x63, 0x6D, 0x61, 0x70, 0x0A, 0x70, 0x11, 0x51, 
    0x00, 0x00, 0x01, 0x7C, 0x00, 0x00, 0x01, 0x3A, 0x63, 0x76, 0x74, 0x20, 
    0x1A, 0x6C, 0x16, 0xE2, 0x00, 0x00, 0x02, 0xB8, 0x00, 0x00, 0x00, 0x76, 
    0x66, 0x70, 0x67, 0x6D, 0x99, 0x2A, 0xAF, 0x5A, 0x00, 0x00, 0x03, 0x30, 
    0x00, 0x00, 0x00, 0x68, 0x67, 0x61, 0x73, 0x70, 0x00, 0x17, 0x00, 0x09, 
    0x00, 0x00, 0x03, 0x98, 0x00, 0x00, 0x00, 0x10, 0x67, 0x6C, 0x79, 0x66, 
    0xFB, 0xA1, 0x6A, 0x1B, 0x00, 0x00, 0x03, 0xA8, 0x00, 0x00, 0x08, 0x20, 
    0x68, 0x65, 0x61, 0x64, 0xD5, 0x22, 0x40, 0xD6, 0x00, 0x00, 0x0C, 0x00, 
    0x00, 0x00, 0x00, 0x36, 0x68, 0x68, 0x65, 0x61, 0x0C, 0x0F, 0x02, 0x78, 
    0x00, 0x00, 0x0C, 0x54, 0x00, 0x00, 0x00, 0x24, 0x68, 0x6D, 0x74, 0x78, 
    0x07, 0xB9, 0x01, 0x05, 0x00, 0x00, 0x0C, 0x38, 0x00, 0x00, 0x00, 0x1A, 
    0x6B, 0x65, 0x72, 0x6E, 0xFF, 0x79, 0x00, 0x6A, 0x00, 0x00, 0x0C, 0x78, 
    0x00, 0x00, 0x01, 0x0E, 0x6C, 0x6F, 0x63, 0x61, 0x0A, 0x16, 0x0C, 0x12, 
    0x00, 0x00, 0x0B, 0xE8, 0x00, 0x00, 0x00, 0x18, 0x6D, 0x61, 0x78, 0x70, 
    0x08, 0x24, 0x01, 0x12, 0x00, 0x00, 0x0B, 0xC8, 0x00, 0x00, 0x00, 0x20, 
    0x6E, 0x61, 0x6D, 0x65, 0xF0, 0x9B, 0x46, 0x41, 0x00, 0x00, 0x0D, 0x88, 
    0x00, 0x00, 0x04, 0xEF, 0x70, 0x6F, 0x73, 0x74, 0x00, 0x80, 0x00, 0x78, 
    0x00, 0x00, 0x12, 0x78, 0x00, 0x00, 0x00, 0x38, 0x70, 0x72, 0x65, 0x70, 
    0x3F, 0x96, 0x1A, 0x3D, 0x00, 0x00, 0x12, 0xB0, 0x00, 0x00, 0x00, 0x0A, 
    0x76, 0x68, 0x65, 0x61, 0x12, 0x84, 0x0D, 0x05, 0x00, 0x00, 0x12, 0xD4, 
    0x00, 0x00, 0x00, 0x24, 0x76, 0x6D, 0x74, 0x78, 0x14, 0xB6, 0x0D, 0x8E, 
    0x00, 0x00, 0x12, 0xBC, 0x00, 0x00, 0x00, 0x18, 0x00, 0x02, 0x03, 0x6A, 
    0x02, 0xBC, 0x00, 0x05, 0x00, 0x00, 0x05, 0x9A, 0x05, 0x33, 0x00, 0x00, 
    0x01, 0x1B, 0x05, 0x9A, 0x05, 0x33, 0x00, 0x00, 0x03, 0xD1, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x05, 0x02, 0x02, 0x07, 0x03, 0x07, 0x00, 0x00, 0x00, 
    0x00, 0x04, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x26, 0x48, 0x20, 0x00, 0x20, 
    0x00, 0x20, 0xFB, 0x02, 0x06, 0x44, 0xFE, 0x5C, 0x00, 0xA7, 0x07, 0xAC, 
    0x01, 0xB0, 0x00, 0x00, 0x00, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 
    0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x03, 0x00, 0x01, 
    0x00, 0x00, 0x01, 0x1A, 0x00, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 
    0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x04, 0x00, 0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 
    0x00, 0x01, 0x00, 0x00, 0x00, 0x39, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x30, 
    0xFF, 0xFF, 0xFF, 0xD1, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x05, 0xC8, 0x04, 0x4A, 0x00, 0x00, 0xFE, 0x00, 0x00, 0xE1, 0x01, 0x2C, 
    0x00, 0x6D, 0x00, 0x6F, 0x00, 0x95, 0x00, 0xF9, 0x00, 0xF7, 0x01, 0x42, 
    0x01, 0x2B, 0x01, 0x38, 0x00, 0x60, 0x00, 0x9D, 0x00, 0x7D, 0x01, 0x29, 
    0x00, 0x5E, 0x01, 0x16, 0x00, 0x8C, 0x00, 0xEC, 0x00, 0xB0, 0x00, 0xC4, 
    0x00, 0xD5, 0x00, 0x57, 0x00, 0x66, 0x00, 0xA4, 0x00, 0xBA, 0x00, 0x3C, 
    0x00, 0xBE, 0x00, 0x50, 0x00, 0xE0, 0x00, 0x7B, 0x01, 0x02, 0x01, 0x0F, 
    0x00, 0x9F, 0x00, 0xC1, 0x01, 0x1D, 0x00, 0xB7, 0x00, 0xCB, 0x00, 0xB0, 
    0x01, 0x05, 0x00, 0x1D, 0x01, 0x49, 0x01, 0x35, 0x01, 0x0C, 0x01, 0x4B, 
    0x00, 0xB1, 0x00, 0x65, 0x00, 0x61, 0x00, 0x79, 0x00, 0x6C, 0x01, 0x3C, 
    0x00, 0xA2, 0x00, 0xC8, 0x00, 0x91, 0x00, 0x46, 0x01, 0x00, 0x00, 0x00, 
    0x40, 0x0F, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 
    0x04, 0x03, 0x02, 0x01, 0x00, 0x2C, 0x17, 0x2F, 0x3C, 0x2D, 0x2C, 0x2F, 
    0x3C, 0x2D, 0x2C, 0x11, 0x12, 0x39, 0x2D, 0x2C, 0x11, 0x12, 0x17, 0x39, 
    0x2D, 0x2C, 0x10, 0x17, 0xFD, 0x3C, 0x2D, 0x2C, 0x10, 0x17, 0xF4, 0x3C, 
    0x2D, 0x2C, 0x10, 0x17, 0xDD, 0x3C, 0x2D, 0x2C, 0x10, 0x17, 0xD4, 0x3C, 
    0x2D, 0x2C, 0x10, 0xFD, 0x2D, 0x2C, 0x10, 0xF4, 0x2D, 0x2C, 0x10, 0xDD, 
    0x2D, 0x2C, 0x10, 0xD4, 0x2D, 0x2C, 0xC4, 0x2D, 0x2C, 0xC0, 0x2D, 0x2C, 
    0x00, 0x40, 0x0A, 0x01, 0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x03, 0x03, 
    0x00, 0x16, 0x3F, 0x3F, 0x3F, 0x3F, 0x16, 0x2D, 0x00, 0x00, 0x00, 0x03, 
    0x00, 0x08, 0x00, 0x02, 0x00, 0x10, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x03, 
    0x00, 0x02, 0x00, 0x33, 0x00, 0x00, 0x01, 0xCD, 0x05, 0xC8, 0x00, 0x03, 
    0x00, 0x07, 0x00, 0x23, 0x40, 0x10, 0x05, 0x06, 0x02, 0x01, 0x04, 0x07, 
    0x03, 0x00, 0x05, 0x04, 0x02, 0x03, 0x06, 0x07, 0x01, 0x00, 0x2F, 0x3C, 
    0xDC, 0x3C, 0x2F, 0x3C, 0xDC, 0x3C, 0x00, 0x2F, 0x3C, 0xDC, 0x3C, 0x2F, 
    0x3C, 0xDC, 0x3C, 0x33, 0x11, 0x21, 0x11, 0x27, 0x11, 0x21, 0x11, 0x33, 
    0x01, 0x9A, 0x33, 0xFE, 0xCC, 0x05, 0xC8, 0xFA, 0x38, 0x33, 0x05, 0x62, 
    0xFA, 0x9E, 0x00, 0x00, 0x00, 0x02, 0x00, 0x31, 0xFF, 0xDB, 0x03, 0xCE, 
    0x05, 0xED, 0x00, 0x0F, 0x00, 0x1F, 0x00, 0x27, 0x40, 0x15, 0x18, 0x02, 
    0x10, 0x00, 0x08, 0x00, 0x01, 0x01, 0x08, 0x00, 0x02, 0x00, 0x02, 0x03, 
    0x00, 0x00, 0x0E, 0x1C, 0x14, 0x0C, 0x04, 0x2F, 0x2F, 0x2F, 0x2F, 0x2B, 
    0x13, 0x14, 0x2B, 0x13, 0x14, 0x2F, 0x2F, 0x3F, 0x3F, 0x31, 0x30, 0x01, 
    0x22, 0x07, 0x06, 0x11, 0x10, 0x17, 0x16, 0x33, 0x32, 0x37, 0x36, 0x11, 
    0x10, 0x27, 0x26, 0x27, 0x32, 0x17, 0x16, 0x11, 0x10, 0x07, 0x06, 0x23, 
    0x22, 0x27, 0x26, 0x11, 0x10, 0x37, 0x36, 0x02, 0x00, 0x65, 0x1A, 0x15, 
    0x29, 0x22, 0x4B, 0x5E, 0x1B, 0x19, 0x1F, 0x1F, 0x56, 0xDA, 0x7A, 0x7A, 
    0x7A, 0x7A, 0xE1, 0xC0, 0x75, 0x93, 0x7A, 0x7A, 0x05, 0x91, 0xC3, 0x9A, 
    0xFE, 0xAE, 0xFE, 0x32, 0x79, 0x64, 0xA9, 0x9D, 0x01, 0x7C, 0x01, 0x81, 
    0x8D, 0x8A, 0x5C, 0xCB, 0xCB, 0xFE, 0x91, 0xFE, 0x88, 0xCA, 0xCB, 0xA5, 
    0xD0, 0x01, 0x96, 0x01, 0x70, 0xCB, 0xCC, 0x00, 0x00, 0x01, 0x00, 0x77, 
    0x00, 0x00, 0x03, 0xA5, 0x05, 0xD5, 0x00, 0x1A, 0x00, 0x44, 0x40, 0x29, 
    0x19, 0x15, 0x13, 0x12, 0x11, 0x10, 0x0A, 0x09, 0x01, 0x09, 0x0D, 0x0D, 
    0x00, 0x1A, 0x00, 0x01, 0x00, 0x0E, 0x1A, 0x19, 0x15, 0x03, 0x0D, 0x12, 
    0x11, 0x10, 0x01, 0x00, 0x04, 0x0D, 0x09, 0x00, 0x00, 0x13, 0x12, 0x05, 
    0x01, 0x09, 0x01, 0x04, 0x30, 0xB8, 0x01, 0x2C, 0xB3, 0x0A, 0x09, 0x01, 
    0x00, 0x2B, 0x1F, 0x1E, 0x2A, 0x1F, 0x1E, 0x10, 0x2A, 0x10, 0x2A, 0x2B, 
    0x2B, 0x10, 0xC4, 0x2A, 0x31, 0x30, 0x33, 0x35, 0x37, 0x37, 0x36, 0x37, 
    0x36, 0x37, 0x36, 0x35, 0x11, 0x27, 0x26, 0x23, 0x22, 0x07, 0x07, 0x35, 
    0x25, 0x11, 0x14, 0x17, 0x16, 0x1F, 0x02, 0x15, 0x77, 0x13, 0x71, 0x48, 
    0x12, 0x10, 0x09, 0x0C, 0x06, 0x04, 0x26, 0x1E, 0x6B, 0x4A, 0x02, 0x2B, 
    0x1E, 0x1B, 0x4B, 0x6D, 0x12, 0x5D, 0x01, 0x0A, 0x06, 0x09, 0x0B, 0x2D, 
    0x3D, 0x36, 0x03, 0x3A, 0x65, 0x48, 0x14, 0x0E, 0x63, 0x8B, 0xFB, 0x4D, 
    0x96, 0x0F, 0x13, 0x04, 0x08, 0x01, 0x5D, 0x00, 0x00, 0x01, 0x00, 0x26, 
    0x00, 0x00, 0x03, 0xBD, 0x05, 0xED, 0x00, 0x1F, 0x00, 0x67, 0x40, 0x2C, 
    0x00, 0x00, 0x0A, 0x0E, 0x12, 0x30, 0x66, 0x12, 0x00, 0x01, 0x10, 0x0F, 
    0x0E, 0x03, 0x00, 0x1D, 0x03, 0x00, 0x01, 0x1D, 0x00, 0x02, 0x00, 0x00, 
    0x1E, 0x1D, 0x0A, 0x01, 0x00, 0x01, 0x04, 0x30, 0x66, 0x1F, 0x00, 0x01, 
    0x00, 0x0E, 0x00, 0x00, 0x08, 0x0D, 0x14, 0x30, 0xB8, 0x01, 0x2C, 0x40, 
    0x13, 0x1D, 0x0E, 0x02, 0x1E, 0x0F, 0x03, 0x14, 0x1E, 0x01, 0x00, 0x0F, 
    0x1F, 0x1E, 0x01, 0x10, 0x0F, 0x01, 0x02, 0x00, 0x2A, 0x10, 0xC0, 0xC0, 
    0x10, 0xC4, 0x2B, 0x1F, 0x1E, 0x10, 0xED, 0x1F, 0x1E, 0x2B, 0x2B, 0x1F, 
    0x1E, 0x2A, 0x1F, 0x1E, 0x2B, 0x14, 0x2B, 0x14, 0x3F, 0x1F, 0x1E, 0x10, 
    0xED, 0x1F, 0x1E, 0x31, 0x30, 0x33, 0x35, 0x36, 0x3F, 0x03, 0x36, 0x35, 
    0x10, 0x23, 0x22, 0x0F, 0x02, 0x23, 0x11, 0x36, 0x33, 0x20, 0x11, 0x14, 
    0x07, 0x06, 0x07, 0x06, 0x07, 0x07, 0x06, 0x07, 0x21, 0x15, 0x26, 0x40, 
    0x83, 0x61, 0x36, 0x86, 0x7F, 0xEB, 0xBE, 0x04, 0x02, 0x01, 0x88, 0xE5, 
    0xC9, 0x01, 0xC2, 0x4B, 0x3D, 0x98, 0x67, 0x27, 0x48, 0x7A, 0x09, 0x02, 
    0x74, 0x63, 0xB2, 0x9B, 0x71, 0x40, 0xA2, 0x99, 0xC6, 0x01, 0x29, 0x9E, 
    0x53, 0x12, 0x01, 0x14, 0x51, 0xFE, 0x82, 0x8C, 0x5F, 0x4C, 0x74, 0x4E, 
    0x29, 0x4B, 0x80, 0x8B, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x4A, 
    0xFF, 0xDB, 0x03, 0xC7, 0x05, 0xEE, 0x00, 0x2E, 0x00, 0x6C, 0x40, 0x30, 
    0x00, 0x00, 0x15, 0x0E, 0x1D, 0x08, 0x0E, 0x2D, 0x30, 0x66, 0x2D, 0x02, 
    0x1D, 0x00, 0x01, 0x1B, 0x00, 0x19, 0x02, 0x00, 0x01, 0x25, 0x11, 0x10, 
    0x0F, 0x0E, 0x02, 0x01, 0x00, 0x08, 0x19, 0x02, 0x03, 0x00, 0x1A, 0x19, 
    0x01, 0x00, 0x0E, 0x00, 0x00, 0x13, 0x11, 0x21, 0x0A, 0x0D, 0x29, 0x30, 
    0xB8, 0x01, 0x2C, 0x40, 0x14, 0x25, 0x19, 0x11, 0x10, 0x0F, 0x0E, 0x02, 
    0x07, 0x0D, 0x29, 0x21, 0x1A, 0x1B, 0x1A, 0x01, 0x01, 0x00, 0x01, 0x02, 
    0x00, 0x2A, 0x10, 0xC4, 0xC4, 0x2A, 0x1F, 0x1E, 0x10, 0xED, 0x10, 0xED, 
    0x1F, 0x1E, 0x2B, 0x2B, 0x13, 0x2B, 0x13, 0x14, 0x2B, 0x14, 0x3F, 0x3F, 
    0x1F, 0x1E, 0x10, 0xED, 0x10, 0xED, 0x1F, 0x1E, 0x31, 0x30, 0x37, 0x11, 
    0x33, 0x17, 0x17, 0x16, 0x17, 0x16, 0x33, 0x20, 0x11, 0x34, 0x27, 0x26, 
    0x23, 0x23, 0x35, 0x33, 0x20, 0x11, 0x10, 0x23, 0x22, 0x0F, 0x02, 0x23, 
    0x11, 0x36, 0x33, 0x32, 0x17, 0x16, 0x15, 0x14, 0x07, 0x06, 0x07, 0x16, 
    0x17, 0x16, 0x15, 0x14, 0x07, 0x06, 0x23, 0x22, 0x4A, 0x87, 0x02, 0x01, 
    0x04, 0x18, 0x2D, 0x76, 0x01, 0x02, 0x5C, 0x5D, 0xA6, 0x65, 0x56, 0x01, 
    0x45, 0xDE, 0xA1, 0x06, 0x04, 0x01, 0x8E, 0xCD, 0xA6, 0xDC, 0x79, 0x79, 
    0x79, 0x49, 0x8B, 0x7A, 0x3F, 0xC6, 0x8D, 0x8D, 0xF1, 0xC7, 0x11, 0x01, 
    0x17, 0x12, 0x0F, 0x65, 0x25, 0x46, 0x01, 0x4D, 0xA9, 0x5B, 0x5B, 0x5C, 
    0x01, 0x3F, 0x01, 0x13, 0x8A, 0x5A, 0x13, 0x01, 0x12, 0x42, 0x5C, 0x5B, 
    0xA7, 0xA5, 0x65, 0x3D, 0x2C, 0x1D, 0x23, 0x6E, 0xEB, 0xC0, 0x74, 0x75, 
    0x00, 0x02, 0x00, 0x19, 0x00, 0x00, 0x03, 0xDB, 0x05, 0xDB, 0x00, 0x18, 
    0x00, 0x1B, 0x00, 0x71, 0x40, 0x48, 0x1B, 0x02, 0x04, 0x02, 0x01, 0x04, 
    0x00, 0x02, 0x17, 0x11, 0x0E, 0x08, 0x04, 0x00, 0x0F, 0x03, 0x00, 0x00, 
    0x1A, 0x19, 0x05, 0x04, 0x18, 0x03, 0x00, 0x01, 0x04, 0x30, 0x66, 0x03, 
    0x02, 0x01, 0x18, 0x07, 0x06, 0x00, 0x03, 0x10, 0x0F, 0x01, 0x03, 0x00, 
    0x0E, 0x0F, 0x0E, 0x02, 0x05, 0x03, 0x03, 0x02, 0x03, 0x17, 0x02, 0x19, 
    0x11, 0x10, 0x03, 0x17, 0x00, 0x03, 0x00, 0x00, 0x1B, 0x1A, 0x18, 0x17, 
    0x09, 0x03, 0x03, 0x01, 0x04, 0x30, 0xB8, 0x01, 0x2C, 0x40, 0x0D, 0x06, 
    0x05, 0x01, 0x08, 0x07, 0x04, 0x03, 0x03, 0x01, 0x00, 0x01, 0x03, 0x00, 
    0x2A, 0x1F, 0x1E, 0x2A, 0x1F, 0x1E, 0x2B, 0x2B, 0x2B, 0x2B, 0x2A, 0x1F, 
    0x1E, 0x2A, 0x1F, 0x1E, 0x2B, 0x2B, 0x2B, 0x31, 0x30, 0x13, 0x35, 0x01, 
    0x33, 0x11, 0x33, 0x15, 0x23, 0x15, 0x17, 0x16, 0x17, 0x16, 0x17, 0x17, 
    0x15, 0x21, 0x35, 0x37, 0x36, 0x37, 0x36, 0x37, 0x37, 0x35, 0x25, 0x21, 
    0x11, 0x19, 0x02, 0x54, 0xDA, 0x94, 0x94, 0x05, 0x02, 0x15, 0x17, 0x42, 
    0x13, 0xFD, 0xE1, 0x12, 0x72, 0x0A, 0x0C, 0x01, 0x05, 0xFE, 0x5F, 0x01, 
    0xA1, 0x01, 0x91, 0xA7, 0x03, 0xA3, 0xFC, 0x88, 0xD2, 0x6F, 0x63, 0x34, 
    0x15, 0x14, 0x04, 0x01, 0x5D, 0x5D, 0x01, 0x07, 0x15, 0x14, 0x31, 0x63, 
    0x6F, 0xD2, 0x02, 0x8C, 0x00, 0x01, 0x00, 0x75, 0xFF, 0xDB, 0x03, 0xA3, 
    0x05, 0xC8, 0x00, 0x1D, 0x00, 0x65, 0x40, 0x2B, 0x00, 0x00, 0x08, 0x0E, 
    0x1C, 0x30, 0x66, 0x1C, 0x02, 0x0C, 0x01, 0x13, 0x0E, 0x0C, 0x02, 0x01, 
    0x00, 0x06, 0x11, 0x02, 0x03, 0x00, 0x00, 0x00, 0x12, 0x11, 0x04, 0x01, 
    0x0F, 0x01, 0x04, 0x30, 0x66, 0x10, 0x0F, 0x00, 0x0E, 0x00, 0x00, 0x0A, 
    0x0D, 0x18, 0x30, 0xB8, 0x01, 0x2C, 0x40, 0x14, 0x13, 0x12, 0x02, 0x03, 
    0x10, 0x0E, 0x03, 0x18, 0x10, 0x11, 0x10, 0x01, 0x0F, 0x0E, 0x01, 0x01, 
    0x00, 0x01, 0x03, 0x00, 0x2A, 0x10, 0xC4, 0x2B, 0x1F, 0x1E, 0x10, 0xED, 
    0x1F, 0x1E, 0x2B, 0x3F, 0x3C, 0x1F, 0x1E, 0x2A, 0x1F, 0x1E, 0x13, 0x2B, 
    0x13, 0x2F, 0x3F, 0x1F, 0x1E, 0x10, 0xED, 0x1F, 0x1E, 0x31, 0x30, 0x37, 
    0x11, 0x33, 0x17, 0x17, 0x16, 0x17, 0x16, 0x33, 0x32, 0x11, 0x10, 0x21, 
    0x22, 0x07, 0x11, 0x21, 0x15, 0x21, 0x03, 0x37, 0x36, 0x17, 0x16, 0x15, 
    0x14, 0x07, 0x06, 0x23, 0x22, 0x75, 0x87, 0x02, 0x04, 0x06, 0x1E, 0x21, 
    0x48, 0xDA, 0xFE, 0x97, 0x2E, 0x42, 0x02, 0xF7, 0xFD, 0x82, 0x19, 0x4E, 
    0xFE, 0xA3, 0xC4, 0x91, 0x91, 0xE2, 0x68, 0x0A, 0x01, 0x12, 0x13, 0x3D, 
    0x53, 0x20, 0x22, 0x01, 0x54, 0x01, 0x8E, 0x07, 0x02, 0xB6, 0xE4, 0xFE, 
    0x93, 0x01, 0x03, 0x6A, 0x7E, 0xEF, 0xCB, 0x7F, 0x7F, 0x00, 0x00, 0x00, 
    0x00, 0x02, 0x00, 0x31, 0xFF, 0xDB, 0x03, 0xCF, 0x05, 0xED, 0x00, 0x24, 
    0x00, 0x2C, 0x00, 0x60, 0x40, 0x28, 0x00, 0x00, 0x29, 0x0E, 0x1B, 0x25, 
    0x21, 0x13, 0x0C, 0x0E, 0x23, 0x30, 0x66, 0x23, 0x00, 0x1B, 0x02, 0x13, 
    0x01, 0x01, 0x13, 0x11, 0x06, 0x05, 0x02, 0x01, 0x00, 0x07, 0x00, 0x02, 
    0x03, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x2B, 0x11, 0x17, 0x30, 0xB8, 0x01, 
    0x2C, 0x40, 0x0F, 0x17, 0x00, 0x11, 0x06, 0x05, 0x02, 0x04, 0x0D, 0x27, 
    0x1F, 0x00, 0x01, 0x00, 0x01, 0x00, 0x2B, 0x10, 0xC4, 0xC4, 0x2A, 0x10, 
    0xC4, 0x1F, 0x1E, 0x10, 0xED, 0x1F, 0x1E, 0x2B, 0x13, 0x14, 0x2B, 0x13, 
    0x14, 0x2F, 0x3F, 0x3F, 0x1F, 0x1E, 0x10, 0xED, 0x10, 0xED, 0x10, 0xED, 
    0x1F, 0x1E, 0x31, 0x30, 0x01, 0x11, 0x23, 0x27, 0x26, 0x27, 0x35, 0x26, 
    0x35, 0x34, 0x27, 0x26, 0x23, 0x22, 0x07, 0x06, 0x17, 0x17, 0x36, 0x33, 
    0x32, 0x17, 0x16, 0x15, 0x14, 0x07, 0x06, 0x23, 0x22, 0x27, 0x26, 0x11, 
    0x10, 0x37, 0x36, 0x21, 0x32, 0x01, 0x22, 0x11, 0x10, 0x33, 0x32, 0x11, 
    0x10, 0x03, 0x8A, 0x88, 0x01, 0x02, 0x01, 0x01, 0x18, 0x1A, 0x51, 0x8E, 
    0x4F, 0x3C, 0x04, 0x01, 0x72, 0x9C, 0x9A, 0x60, 0x61, 0x80, 0x80, 0xC4, 
    0xD6, 0x82, 0x82, 0x9C, 0x9C, 0x01, 0x10, 0x97, 0xFE, 0xFB, 0x9D, 0xA7, 
    0x91, 0x05, 0xB2, 0xFE, 0xF5, 0x12, 0x1E, 0x0D, 0x0C, 0x0A, 0x0A, 0x49, 
    0x20, 0x24, 0xD7, 0xA6, 0xD2, 0x33, 0xAB, 0x7A, 0x7A, 0xCA, 0xEB, 0x9B, 
    0x9B, 0xC7, 0xC6, 0x01, 0x48, 0x01, 0x7A, 0xE1, 0xE2, 0xFD, 0x50, 0xFE, 
    0xA4, 0xFE, 0x56, 0x01, 0x81, 0x01, 0x85, 0x00, 0x00, 0x01, 0x00, 0x52, 
    0x00, 0x00, 0x03, 0xD0, 0x05, 0xC8, 0x00, 0x0B, 0x00, 0x36, 0x40, 0x26, 
    0x09, 0x07, 0x05, 0x02, 0x00, 0x00, 0x06, 0x05, 0x0A, 0x01, 0x07, 0x01, 
    0x04, 0x30, 0x66, 0x0B, 0x00, 0x01, 0x00, 0x08, 0x07, 0x00, 0x0E, 0x0B, 
    0x05, 0x00, 0x03, 0x08, 0x06, 0x03, 0x09, 0x08, 0x01, 0x07, 0x06, 0x01, 
    0x02, 0x00, 0x2A, 0x2B, 0x2B, 0x3F, 0x3C, 0x2B, 0x1F, 0x1E, 0x2A, 0x1F, 
    0x1E, 0x2B, 0x31, 0x30, 0x33, 0x36, 0x37, 0x36, 0x01, 0x37, 0x21, 0x35, 
    0x21, 0x15, 0x00, 0x03, 0x93, 0x27, 0x64, 0x64, 0x01, 0x2C, 0x75, 0xFD, 
    0x2F, 0x03, 0x7E, 0xFE, 0x30, 0x2C, 0xDF, 0xC5, 0xC4, 0x01, 0xBD, 0xAD, 
    0xF6, 0xBC, 0xFD, 0xB4, 0xFD, 0x40, 0x00, 0x00, 0x00, 0x03, 0x00, 0x31, 
    0xFF, 0xDB, 0x03, 0xCF, 0x05, 0xEE, 0x00, 0x22, 0x00, 0x2D, 0x00, 0x3A, 
    0x00, 0x5E, 0x40, 0x2A, 0x00, 0x00, 0x33, 0x0E, 0x1B, 0x27, 0x0E, 0x07, 
    0x30, 0x66, 0x1B, 0x02, 0x07, 0x00, 0x01, 0x01, 0x2E, 0x23, 0x0F, 0x00, 
    0x04, 0x00, 0x02, 0x03, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x37, 0x3A, 0x17, 
    0x31, 0x13, 0x1F, 0x29, 0x0A, 0x03, 0x25, 0x3A, 0x0B, 0x30, 0xB8, 0x01, 
    0x2C, 0xB7, 0x2E, 0x23, 0x1F, 0x17, 0x0F, 0x0B, 0x03, 0x00, 0x2E, 0x2F, 
    0x2F, 0x2E, 0x2F, 0x2F, 0x2E, 0x2E, 0x1F, 0x1E, 0x10, 0xED, 0x10, 0xED, 
    0x10, 0xED, 0x10, 0xED, 0x1F, 0x1E, 0x2B, 0x13, 0x14, 0x2B, 0x13, 0x14, 
    0x3F, 0x3F, 0x1F, 0x1E, 0x10, 0xED, 0x10, 0xED, 0x1F, 0x1E, 0x31, 0x30, 
    0x01, 0x27, 0x26, 0x35, 0x34, 0x37, 0x36, 0x33, 0x32, 0x17, 0x16, 0x15, 
    0x14, 0x07, 0x06, 0x07, 0x16, 0x1F, 0x02, 0x16, 0x17, 0x16, 0x15, 0x14, 
    0x07, 0x06, 0x23, 0x22, 0x27, 0x26, 0x35, 0x34, 0x37, 0x36, 0x25, 0x36, 
    0x35, 0x34, 0x23, 0x22, 0x15, 0x14, 0x17, 0x16, 0x17, 0x07, 0x07, 0x06, 
    0x15, 0x10, 0x33, 0x32, 0x37, 0x36, 0x35, 0x34, 0x27, 0x27, 0x01, 0x64, 
    0x2A, 0xB9, 0x6D, 0x6D, 0xBA, 0xAC, 0x65, 0x65, 0x64, 0x3C, 0x73, 0x0E, 
    0x15, 0x0D, 0x0B, 0xC1, 0x28, 0x33, 0x86, 0x86, 0xCF, 0xCD, 0x7B, 0x7B, 
    0x6F, 0x44, 0x01, 0x4D, 0x5B, 0x8F, 0x84, 0x1E, 0x1B, 0x5C, 0x63, 0x0A, 
    0x5A, 0xD1, 0x52, 0x30, 0x30, 0x78, 0x66, 0x03, 0x08, 0x25, 0xA3, 0xB9, 
    0xA1, 0x62, 0x62, 0x58, 0x58, 0x93, 0x88, 0x68, 0x40, 0x3F, 0x0D, 0x12, 
    0x0B, 0x0A, 0xAA, 0x3C, 0x4B, 0x6D, 0xAE, 0x70, 0x71, 0x69, 0x6A, 0xAD, 
    0x9D, 0x7A, 0x4B, 0xBE, 0x7F, 0xA1, 0xF6, 0xB5, 0x5D, 0x40, 0x3A, 0x64, 
    0xCF, 0x11, 0x97, 0xAF, 0xFE, 0xBC, 0x3E, 0x3F, 0x64, 0x8F, 0x7C, 0x69, 
    0x00, 0x02, 0x00, 0x31, 0xFF, 0xDB, 0x03, 0xD0, 0x05, 0xED, 0x00, 0x24, 
    0x00, 0x2C, 0x00, 0x61, 0x40, 0x2A, 0x00, 0x00, 0x29, 0x21, 0x13, 0x25, 
    0x0E, 0x1B, 0x0C, 0x0E, 0x23, 0x30, 0x66, 0x23, 0x02, 0x1B, 0x00, 0x13, 
    0x01, 0x01, 0x13, 0x11, 0x10, 0x02, 0x01, 0x00, 0x06, 0x00, 0x02, 0x03, 
    0x00, 0x00, 0x0E, 0x00, 0x00, 0x2B, 0x0D, 0x1F, 0x27, 0x11, 0x17, 0x30, 
    0xB8, 0x01, 0x2C, 0x40, 0x0D, 0x11, 0x10, 0x02, 0x03, 0x0D, 0x1F, 0x00, 
    0x17, 0x00, 0x01, 0x00, 0x01, 0x00, 0x2B, 0x10, 0xC4, 0x10, 0xC4, 0x2A, 
    0x1F, 0x1E, 0x10, 0xED, 0x10, 0xED, 0x1F, 0x1E, 0x2B, 0x13, 0x14, 0x2B, 
    0x13, 0x14, 0x2F, 0x3F, 0x3F, 0x1F, 0x1E, 0x10, 0xED, 0x10, 0xED, 0x10, 
    0xED, 0x1F, 0x1E, 0x31, 0x30, 0x37, 0x11, 0x33, 0x17, 0x30, 0x17, 0x16, 
    0x15, 0x17, 0x14, 0x17, 0x16, 0x33, 0x32, 0x37, 0x36, 0x11, 0x35, 0x06, 
    0x23, 0x22, 0x27, 0x26, 0x35, 0x34, 0x37, 0x36, 0x33, 0x32, 0x17, 0x16, 
    0x11, 0x10, 0x07, 0x06, 0x21, 0x22, 0x13, 0x22, 0x11, 0x10, 0x33, 0x32, 
    0x11, 0x10, 0x77, 0x87, 0x01, 0x02, 0x01, 0x01, 0x12, 0x18, 0x59, 0x7C, 
    0x4C, 0x4D, 0x73, 0x9B, 0x9A, 0x61, 0x61, 0x81, 0x80, 0xC3, 0xD6, 0x82, 
    0x83, 0x9D, 0x9C, 0xFE, 0xF1, 0x98, 0xFC, 0x92, 0x9B, 0x9D, 0x16, 0x01, 
    0x0C, 0x13, 0x18, 0x0E, 0x11, 0x0A, 0x46, 0x23, 0x2E, 0xA6, 0xA6, 0x01, 
    0x03, 0x33, 0xAA, 0x7A, 0x7A, 0xC9, 0xEC, 0x9A, 0x9B, 0xC7, 0xC7, 0xFE, 
    0xB9, 0xFE, 0x87, 0xE2, 0xE2, 0x05, 0xB6, 0xFE, 0x80, 0xFE, 0x7A, 0x01, 
    0x5C, 0x01, 0xAA, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x3B, 
    0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 
    0x00, 0x0F, 0x00, 0x00, 0x08, 0x00, 0x00, 0xD5, 0x00, 0x02, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x26, 0x00, 0x70, 0x00, 0xBE, 0x01, 0x24, 0x01, 0x9E, 
    0x02, 0x06, 0x02, 0x6A, 0x02, 0xE0, 0x03, 0x16, 0x03, 0x9C, 0x04, 0x10, 
    0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x33, 0x33, 0xB9, 0xEF, 0x19, 0x58, 
    0x5F, 0x0F, 0x3C, 0xF5, 0x00, 0x0F, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xB7, 0xEC, 0xA9, 0x5B, 0x00, 0x00, 0x00, 0x00, 0xBA, 0x1D, 0x19, 0x7E, 
    0x00, 0x19, 0xFF, 0xDB, 0x03, 0xDB, 0x05, 0xEE, 0x00, 0x01, 0x00, 0x0C, 
    0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x33, 
    0x04, 0x00, 0x00, 0x31, 0x00, 0x77, 0x00, 0x26, 0x00, 0x4A, 0x00, 0x19, 
    0x00, 0x75, 0x00, 0x31, 0x00, 0x52, 0x00, 0x31, 0x00, 0x31, 0x00, 0x00, 
    0x00, 0x01, 0x00, 0x00, 0x08, 0x19, 0xFE, 0x50, 0x00, 0x00, 0x04, 0x00, 
    0x00, 0x19, 0x00, 0x25, 0x03, 0xDB, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x0A, 0x00, 0x01, 0x00, 0x2A, 
    0x00, 0xC0, 0x00, 0x05, 0x00, 0x3C, 0x00, 0x01, 0x00, 0x02, 0xFF, 0xCA, 
    0x00, 0x01, 0x00, 0x05, 0x00, 0x1E, 0x00, 0x01, 0x00, 0x08, 0xFF, 0xE1, 
    0x00, 0x02, 0x00, 0x01, 0xFF, 0xBA, 0x00, 0x02, 0x00, 0x02, 0xFF, 0xDF, 
    0x00, 0x02, 0x00, 0x03, 0x00, 0x07, 0x00, 0x02, 0x00, 0x04, 0xFF, 0xF6, 
    0x00, 0x02, 0x00, 0x05, 0xFF, 0x8D, 0x00, 0x02, 0x00, 0x06, 0xFF, 0xE0, 
    0x00, 0x02, 0x00, 0x07, 0xFF, 0xB3, 0x00, 0x02, 0x00, 0x08, 0xFF, 0xD0, 
    0x00, 0x02, 0x00, 0x09, 0xFF, 0xD0, 0x00, 0x02, 0x00, 0x0A, 0xFF, 0xE0, 
    0x00, 0x03, 0x00, 0x02, 0xFF, 0xE9, 0x00, 0x03, 0x00, 0x05, 0xFF, 0xCF, 
    0x00, 0x03, 0x00, 0x08, 0xFF, 0xFB, 0x00, 0x04, 0x00, 0x02, 0xFF, 0xD5, 
    0x00, 0x04, 0x00, 0x05, 0x00, 0x1F, 0x00, 0x04, 0x00, 0x08, 0xFF, 0xE9, 
    0x00, 0x05, 0x00, 0x02, 0xFF, 0xF5, 0x00, 0x05, 0x00, 0x05, 0x00, 0x29, 
    0x00, 0x05, 0x00, 0x08, 0xFF, 0xE5, 0x00, 0x06, 0x00, 0x02, 0xFF, 0xD1, 
    0x00, 0x06, 0x00, 0x05, 0x00, 0x0C, 0x00, 0x06, 0x00, 0x08, 0xFF, 0xE4, 
    0x00, 0x07, 0x00, 0x02, 0xFF, 0xD2, 0x00, 0x07, 0x00, 0x05, 0x00, 0x23, 
    0x00, 0x07, 0x00, 0x08, 0xFF, 0xE4, 0x00, 0x08, 0x00, 0x02, 0xFF, 0xF5, 
    0x00, 0x08, 0x00, 0x03, 0x00, 0x09, 0x00, 0x08, 0x00, 0x04, 0x00, 0x05, 
    0x00, 0x08, 0x00, 0x05, 0xFF, 0x70, 0x00, 0x08, 0x00, 0x06, 0xFF, 0xE8, 
    0x00, 0x08, 0x00, 0x07, 0xFF, 0xD2, 0x00, 0x08, 0x00, 0x08, 0x00, 0x06, 
    0x00, 0x08, 0x00, 0x09, 0xFF, 0xE9, 0x00, 0x09, 0x00, 0x02, 0xFF, 0xD2, 
    0x00, 0x09, 0x00, 0x05, 0x00, 0x21, 0x00, 0x09, 0x00, 0x08, 0xFF, 0xE5, 
    0x00, 0x0A, 0x00, 0x02, 0xFF, 0xCA, 0x00, 0x0A, 0x00, 0x05, 0x00, 0x1B, 
    0x00, 0x0A, 0x00, 0x08, 0xFF, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 
    0x01, 0x26, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0A, 
    0x00, 0x55, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x04, 
    0x00, 0x5F, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x14, 
    0x00, 0x63, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0F, 
    0x00, 0x77, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x16, 
    0x00, 0x86, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x0E, 
    0x00, 0x9C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x37, 
    0x00, 0xAA, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x15, 
    0x00, 0xE1, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x1F, 
    0x00, 0xF6, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x13, 
    0x01, 0x15, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x1B, 
    0x01, 0x28, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x00, 0x00, 0xAA, 
    0x01, 0x43, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x01, 0x00, 0x14, 
    0x01, 0xED, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x02, 0x00, 0x08, 
    0x02, 0x01, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x03, 0x00, 0x28, 
    0x02, 0x09, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x04, 0x00, 0x1E, 
    0x02, 0x31, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x05, 0x00, 0x2C, 
    0x02, 0x4F, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x06, 0x00, 0x1C, 
    0x02, 0x7B, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x07, 0x00, 0x6E, 
    0x02, 0x97, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x08, 0x00, 0x2A, 
    0x03, 0x05, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x09, 0x00, 0x3E, 
    0x03, 0x2F, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x0B, 0x00, 0x26, 
    0x03, 0x6D, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x0C, 0x00, 0x36, 
    0x03, 0x93, 0x43, 0x6F, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x20, 
    0x28, 0x63, 0x29, 0x20, 0x32, 0x30, 0x30, 0x31, 0x20, 0x62, 0x79, 0x20, 
    0x42, 0x69, 0x67, 0x65, 0x6C, 0x6F, 0x77, 0x20, 0x26, 0x20, 0x48, 0x6F, 
    0x6C, 0x6D, 0x65, 0x73, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x20, 0x49, 0x6E, 
    0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6F, 0x6E, 0x73, 0x20, 0x63, 
    0x6F, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x20, 0x28, 0x63, 0x29, 
    0x20, 0x32, 0x30, 0x30, 0x31, 0x20, 0x62, 0x79, 0x20, 0x55, 0x52, 0x57, 
    0x2B, 0x2B, 0x2E, 0x4C, 0x75, 0x78, 0x69, 0x20, 0x53, 0x65, 0x72, 0x69, 
    0x66, 0x42, 0x6F, 0x6C, 0x64, 0x4C, 0x75, 0x78, 0x69, 0x20, 0x53, 0x65, 
    0x72, 0x69, 0x66, 0x20, 0x42, 0x6F, 0x6C, 0x64, 0x3A, 0x20, 0x42, 0x26, 
    0x48, 0x4C, 0x75, 0x78, 0x69, 0x20, 0x53, 0x65, 0x72, 0x69, 0x66, 0x20, 
    0x42, 0x6F, 0x6C, 0x64, 0x31, 0x2E, 0x32, 0x20, 0x3A, 0x20, 0x4F, 0x63, 
    0x74, 0x6F, 0x62, 0x65, 0x72, 0x20, 0x31, 0x32, 0x2C, 0x20, 0x32, 0x30, 
    0x30, 0x31, 0x4C, 0x75, 0x78, 0x69, 0x53, 0x65, 0x72, 0x69, 0x66, 0x2D, 
    0x42, 0x6F, 0x6C, 0x64, 0x4C, 0x75, 0x78, 0x69, 0x20, 0x69, 0x73, 0x20, 
    0x61, 0x20, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x65, 0x64, 
    0x20, 0x74, 0x72, 0x61, 0x64, 0x65, 0x6D, 0x61, 0x72, 0x6B, 0x20, 0x6F, 
    0x66, 0x20, 0x42, 0x69, 0x67, 0x65, 0x6C, 0x6F, 0x77, 0x20, 0x26, 0x20, 
    0x48, 0x6F, 0x6C, 0x6D, 0x65, 0x73, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x42, 
    0x69, 0x67, 0x65, 0x6C, 0x6F, 0x77, 0x20, 0x26, 0x20, 0x48, 0x6F, 0x6C, 
    0x6D, 0x65, 0x73, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x4B, 0x72, 0x69, 0x73, 
    0x20, 0x48, 0x6F, 0x6C, 0x6D, 0x65, 0x73, 0x20, 0x61, 0x6E, 0x64, 0x20, 
    0x43, 0x68, 0x61, 0x72, 0x6C, 0x65, 0x73, 0x20, 0x42, 0x69, 0x67, 0x65, 
    0x6C, 0x6F, 0x77, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x77, 0x77, 
    0x77, 0x2E, 0x75, 0x72, 0x77, 0x70, 0x70, 0x2E, 0x64, 0x65, 0x64, 0x65, 
    0x73, 0x69, 0x67, 0x6E, 0x40, 0x62, 0x69, 0x67, 0x65, 0x6C, 0x6F, 0x77, 
    0x61, 0x6E, 0x64, 0x68, 0x6F, 0x6C, 0x6D, 0x65, 0x73, 0x2E, 0x63, 0x6F, 
    0x6D, 0x00, 0x43, 0x00, 0x6F, 0x00, 0x70, 0x00, 0x79, 0x00, 0x72, 0x00, 
    0x69, 0x00, 0x67, 0x00, 0x68, 0x00, 0x74, 0x00, 0x20, 0x00, 0x28, 0x00, 
    0x63, 0x00, 0x29, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 
    0x31, 0x00, 0x20, 0x00, 0x62, 0x00, 0x79, 0x00, 0x20, 0x00, 0x42, 0x00, 
    0x69, 0x00, 0x67, 0x00, 0x65, 0x00, 0x6C, 0x00, 0x6F, 0x00, 0x77, 0x00, 
    0x20, 0x00, 0x26, 0x00, 0x20, 0x00, 0x48, 0x00, 0x6F, 0x00, 0x6C, 0x00, 
    0x6D, 0x00, 0x65, 0x00, 0x73, 0x00, 0x20, 0x00, 0x49, 0x00, 0x6E, 0x00, 
    0x63, 0x00, 0x2E, 0x00, 0x20, 0x00, 0x49, 0x00, 0x6E, 0x00, 0x73, 0x00, 
    0x74, 0x00, 0x72, 0x00, 0x75, 0x00, 0x63, 0x00, 0x74, 0x00, 0x69, 0x00, 
    0x6F, 0x00, 0x6E, 0x00, 0x73, 0x00, 0x20, 0x00, 0x63, 0x00, 0x6F, 0x00, 
    0x70, 0x00, 0x79, 0x00, 0x72, 0x00, 0x69, 0x00, 0x67, 0x00, 0x68, 0x00, 
    0x74, 0x00, 0x20, 0x00, 0x28, 0x00, 0x63, 0x00, 0x29, 0x00, 0x20, 0x00, 
    0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x31, 0x00, 0x20, 0x00, 0x62, 0x00, 
    0x79, 0x00, 0x20, 0x00, 0x55, 0x00, 0x52, 0x00, 0x57, 0x00, 0x2B, 0x00, 
    0x2B, 0x00, 0x2E, 0x00, 0x4C, 0x00, 0x75, 0x00, 0x78, 0x00, 0x69, 0x00, 
    0x20, 0x00, 0x53, 0x00, 0x65, 0x00, 0x72, 0x00, 0x69, 0x00, 0x66, 0x00, 
    0x42, 0x00, 0x6F, 0x00, 0x6C, 0x00, 0x64, 0x00, 0x4C, 0x00, 0x75, 0x00, 
    0x78, 0x00, 0x69, 0x00, 0x20, 0x00, 0x53, 0x00, 0x65, 0x00, 0x72, 0x00, 
    0x69, 0x00, 0x66, 0x00, 0x20, 0x00, 0x42, 0x00, 0x6F, 0x00, 0x6C, 0x00, 
    0x64, 0x00, 0x3A, 0x00, 0x20, 0x00, 0x42, 0x00, 0x26, 0x00, 0x48, 0x00, 
    0x4C, 0x00, 0x75, 0x00, 0x78, 0x00, 0x69, 0x00, 0x20, 0x00, 0x53, 0x00, 
    0x65, 0x00, 0x72, 0x00, 0x69, 0x00, 0x66, 0x00, 0x20, 0x00, 0x42, 0x00, 
    0x6F, 0x00, 0x6C, 0x00, 0x64, 0x00, 0x31, 0x00, 0x2E, 0x00, 0x32, 0x00, 
    0x20, 0x00, 0x3A, 0x00, 0x20, 0x00, 0x4F, 0x00, 0x63, 0x00, 0x74, 0x00, 
    0x6F, 0x00, 0x62, 0x00, 0x65, 0x00, 0x72, 0x00, 0x20, 0x00, 0x31, 0x00, 
    0x32, 0x00, 0x2C, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 
    0x31, 0x00, 0x4C, 0x00, 0x75, 0x00, 0x78, 0x00, 0x69, 0x00, 0x53, 0x00, 
    0x65, 0x00, 0x72, 0x00, 0x69, 0x00, 0x66, 0x00, 0x2D, 0x00, 0x42, 0x00, 
    0x6F, 0x00, 0x6C, 0x00, 0x64, 0x00, 0x4C, 0x00, 0x75, 0x00, 0x78, 0x00, 
    0x69, 0x00, 0x20, 0x00, 0x69, 0x00, 0x73, 0x00, 0x20, 0x00, 0x61, 0x00, 
    0x20, 0x00, 0x72, 0x00, 0x65, 0x00, 0x67, 0x00, 0x69, 0x00, 0x73, 0x00, 
    0x74, 0x00, 0x65, 0x00, 0x72, 0x00, 0x65, 0x00, 0x64, 0x00, 0x20, 0x00, 
    0x74, 0x00, 0x72, 0x00, 0x61, 0x00, 0x64, 0x00, 0x65, 0x00, 0x6D, 0x00, 
    0x61, 0x00, 0x72, 0x00, 0x6B, 0x00, 0x20, 0x00, 0x6F, 0x00, 0x66, 0x00, 
    0x20, 0x00, 0x42, 0x00, 0x69, 0x00, 0x67, 0x00, 0x65, 0x00, 0x6C, 0x00, 
    0x6F, 0x00, 0x77, 0x00, 0x20, 0x00, 0x26, 0x00, 0x20, 0x00, 0x48, 0x00, 
    0x6F, 0x00, 0x6C, 0x00, 0x6D, 0x00, 0x65, 0x00, 0x73, 0x00, 0x20, 0x00, 
    0x49, 0x00, 0x6E, 0x00, 0x63, 0x00, 0x2E, 0x00, 0x42, 0x00, 0x69, 0x00, 
    0x67, 0x00, 0x65, 0x00, 0x6C, 0x00, 0x6F, 0x00, 0x77, 0x00, 0x20, 0x00, 
    0x26, 0x00, 0x20, 0x00, 0x48, 0x00, 0x6F, 0x00, 0x6C, 0x00, 0x6D, 0x00, 
    0x65, 0x00, 0x73, 0x00, 0x20, 0x00, 0x49, 0x00, 0x6E, 0x00, 0x63, 0x00, 
    0x2E, 0x00, 0x4B, 0x00, 0x72, 0x00, 0x69, 0x00, 0x73, 0x00, 0x20, 0x00, 
    0x48, 0x00, 0x6F, 0x00, 0x6C, 0x00, 0x6D, 0x00, 0x65, 0x00, 0x73, 0x00, 
    0x20, 0x00, 0x61, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x20, 0x00, 0x43, 0x00, 
    0x68, 0x00, 0x61, 0x00, 0x72, 0x00, 0x6C, 0x00, 0x65, 0x00, 0x73, 0x00, 
    0x20, 0x00, 0x42, 0x00, 0x69, 0x00, 0x67, 0x00, 0x65, 0x00, 0x6C, 0x00, 
    0x6F, 0x00, 0x77, 0x00, 0x68, 0x00, 0x74, 0x00, 0x74, 0x00, 0x70, 0x00, 
    0x3A, 0x00, 0x2F, 0x00, 0x2F, 0x00, 0x77, 0x00, 0x77, 0x00, 0x77, 0x00, 
    0x2E, 0x00, 0x75, 0x00, 0x72, 0x00, 0x77, 0x00, 0x70, 0x00, 0x70, 0x00, 
    0x2E, 0x00, 0x64, 0x00, 0x65, 0x00, 0x64, 0x00, 0x65, 0x00, 0x73, 0x00, 
    0x69, 0x00, 0x67, 0x00, 0x6E, 0x00, 0x40, 0x00, 0x62, 0x00, 0x69, 0x00, 
    0x67, 0x00, 0x65, 0x00, 0x6C, 0x00, 0x6F, 0x00, 0x77, 0x00, 0x61, 0x00, 
    0x6E, 0x00, 0x64, 0x00, 0x68, 0x00, 0x6F, 0x00, 0x6C, 0x00, 0x6D, 0x00, 
    0x65, 0x00, 0x73, 0x00, 0x2E, 0x00, 0x63, 0x00, 0x6F, 0x00, 0x6D, 0x00, 
    0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 
    0x00, 0x13, 0x00, 0x14, 0x00, 0x15, 0x00, 0x16, 0x00, 0x17, 0x00, 0x18, 
    0x00, 0x19, 0x00, 0x1A, 0x00, 0x1B, 0x00, 0x1C, 0xB1, 0x30, 0x01, 0xB8, 
    0x01, 0x49, 0x18, 0x85, 0x8D, 0x1D, 0x00, 0x00, 0x09, 0xC9, 0x02, 0x51, 
    0x02, 0x2C, 0x02, 0x44, 0x02, 0x2C, 0x02, 0x2B, 0x02, 0x3E, 0x02, 0x51, 
    0x02, 0x2C, 0x02, 0x51, 0x02, 0x2B, 0x02, 0x2C, 0x00, 0x01, 0x00, 0x00, 
    0x08, 0x19, 0x01, 0xB0, 0x00, 0x00, 0x09, 0xC9, 0x02, 0x2B, 0x01, 0x8B, 
    0x08, 0x3E, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 };

unsigned char auchLuxiSB[] = {
    0x00, 0x01, 0x00, 0x00, 0x00, 0x11, 0x01, 0x00, 0x00, 0x04, 0x00, 0x10, 
    0x4F, 0x53, 0x2F, 0x32, 0x6A, 0x96, 0x61, 0x52, 0x00, 0x00, 0x01, 0x1C, 
    0x00, 0x00, 0x00, 0x60, 0x63, 0x6D, 0x61, 0x70, 0x0A, 0x70, 0x11, 0x51, 
    0x00, 0x00, 0x01, 0x7C, 0x00, 0x00, 0x01, 0x3A, 0x63, 0x76, 0x74, 0x20, 
    0x1B, 0x94, 0x18, 0xC3, 0x00, 0x00, 0x02, 0xB8, 0x00, 0x00, 0x00, 0x74, 
    0x66, 0x70, 0x67, 0x6D, 0x99, 0x2A, 0xAF, 0x5A, 0x00, 0x00, 0x03, 0x2C, 
    0x00, 0x00, 0x00, 0x68, 0x67, 0x61, 0x73, 0x70, 0x00, 0x17, 0x00, 0x09, 
    0x00, 0x00, 0x03, 0x94, 0x00, 0x00, 0x00, 0x10, 0x67, 0x6C, 0x79, 0x66, 
    0x45, 0xDF, 0xC6, 0x03, 0x00, 0x00, 0x03, 0xA4, 0x00, 0x00, 0x07, 0x84, 
    0x68, 0x65, 0x61, 0x64, 0xD5, 0x8D, 0x42, 0x54, 0x00, 0x00, 0x0B, 0x60, 
    0x00, 0x00, 0x00, 0x36, 0x68, 0x68, 0x65, 0x61, 0x0C, 0x7A, 0x02, 0xF9, 
    0x00, 0x00, 0x0B, 0xB4, 0x00, 0x00, 0x00, 0x24, 0x68, 0x6D, 0x74, 0x78, 
    0x09, 0x63, 0x01, 0x7F, 0x00, 0x00, 0x0B, 0x98, 0x00, 0x00, 0x00, 0x1A, 
    0x6B, 0x65, 0x72, 0x6E, 0xFD, 0xF6, 0xFE, 0x53, 0x00, 0x00, 0x0B, 0xD8, 
    0x00, 0x00, 0x01, 0x0E, 0x6C, 0x6F, 0x63, 0x61, 0x09, 0x3C, 0x0B, 0x0E, 
    0x00, 0x00, 0x0B, 0x48, 0x00, 0x00, 0x00, 0x18, 0x6D, 0x61, 0x78, 0x70, 
    0x08, 0x24, 0x01, 0x08, 0x00, 0x00, 0x0B, 0x28, 0x00, 0x00, 0x00, 0x20, 
    0x6E, 0x61, 0x6D, 0x65, 0x3B, 0xAF, 0xAD, 0xC1, 0x00, 0x00, 0x0C, 0xE8, 
    0x00, 0x00, 0x04, 0xE3, 0x70, 0x6F, 0x73, 0x74, 0x00, 0x80, 0x00, 0x78, 
    0x00, 0x00, 0x11, 0xCC, 0x00, 0x00, 0x00, 0x38, 0x70, 0x72, 0x65, 0x70, 
    0x3F, 0x96, 0x1A, 0x3D, 0x00, 0x00, 0x12, 0x04, 0x00, 0x00, 0x00, 0x0A, 
    0x76, 0x68, 0x65, 0x61, 0x12, 0x85, 0x0D, 0x05, 0x00, 0x00, 0x12, 0x28, 
    0x00, 0x00, 0x00, 0x24, 0x76, 0x6D, 0x74, 0x78, 0x14, 0xCA, 0x0D, 0x77, 
    0x00, 0x00, 0x12, 0x10, 0x00, 0x00, 0x00, 0x18, 0x00, 0x02, 0x03, 0xD4, 
    0x02, 0xBC, 0x00, 0x05, 0x00, 0x00, 0x05, 0x9A, 0x05, 0x33, 0x00, 0x00, 
    0x01, 0x1B, 0x05, 0x9A, 0x05, 0x33, 0x00, 0x00, 0x03, 0xD1, 0x00, 0x00, 
    0x00, 0x00, 0x08, 0x00, 0x02, 0x0B, 0x07, 0x03, 0x05, 0x00, 0x00, 0x00, 
    0x00, 0x04, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x26, 0x48, 0x20, 0x00, 0x20, 
    0x00, 0x20, 0xFB, 0x02, 0x06, 0x44, 0xFE, 0x5C, 0x00, 0xA7, 0x07, 0x9E, 
    0x01, 0xB0, 0x00, 0x00, 0x00, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 
    0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x03, 0x00, 0x01, 
    0x00, 0x00, 0x01, 0x1A, 0x00, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 
    0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x04, 0x00, 0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 
    0x00, 0x01, 0x00, 0x00, 0x00, 0x39, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x30, 
    0xFF, 0xFF, 0xFF, 0xD1, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x05, 0xC8, 0x04, 0x4A, 0x00, 0x00, 0xFE, 0x00, 0x01, 0x42, 0x01, 0x2B, 
    0x00, 0x96, 0x00, 0x95, 0x00, 0xF4, 0x00, 0xF7, 0x00, 0xAB, 0x01, 0x44, 
    0x00, 0xC4, 0x00, 0xBC, 0x00, 0xA2, 0x00, 0x7D, 0x01, 0x11, 0x01, 0x1B, 
    0x00, 0xBE, 0x00, 0xC8, 0x00, 0xD2, 0x00, 0x8E, 0x00, 0x7E, 0x00, 0x7D, 
    0x00, 0xB3, 0x00, 0xB0, 0x00, 0x9F, 0x00, 0x8A, 0x00, 0xE0, 0x00, 0xDC, 
    0x00, 0x6D, 0x00, 0xA5, 0x01, 0x38, 0x00, 0xB5, 0x01, 0x32, 0x01, 0x29, 
    0x00, 0xFE, 0x01, 0x05, 0x00, 0xED, 0x01, 0x02, 0x00, 0x83, 0x01, 0x1F, 
    0x00, 0xCB, 0x00, 0xEA, 0x00, 0xC9, 0x00, 0x6F, 0x00, 0x61, 0x00, 0xD5, 
    0x01, 0x35, 0x01, 0x0C, 0x00, 0xBA, 0x01, 0x3C, 0x01, 0x49, 0x00, 0x6C, 
    0x00, 0xA9, 0x00, 0xE8, 0x00, 0x82, 0x00, 0xCE, 0x40, 0x0F, 0x0E, 0x0D, 
    0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 
    0x00, 0x2C, 0x17, 0x2F, 0x3C, 0x2D, 0x2C, 0x2F, 0x3C, 0x2D, 0x2C, 0x11, 
    0x12, 0x39, 0x2D, 0x2C, 0x11, 0x12, 0x17, 0x39, 0x2D, 0x2C, 0x10, 0x17, 
    0xFD, 0x3C, 0x2D, 0x2C, 0x10, 0x17, 0xF4, 0x3C, 0x2D, 0x2C, 0x10, 0x17, 
    0xDD, 0x3C, 0x2D, 0x2C, 0x10, 0x17, 0xD4, 0x3C, 0x2D, 0x2C, 0x10, 0xFD, 
    0x2D, 0x2C, 0x10, 0xF4, 0x2D, 0x2C, 0x10, 0xDD, 0x2D, 0x2C, 0x10, 0xD4, 
    0x2D, 0x2C, 0xC4, 0x2D, 0x2C, 0xC0, 0x2D, 0x2C, 0x00, 0x40, 0x0A, 0x01, 
    0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x03, 0x03, 0x00, 0x16, 0x3F, 0x3F, 
    0x3F, 0x3F, 0x16, 0x2D, 0x00, 0x00, 0x00, 0x03, 0x00, 0x08, 0x00, 0x02, 
    0x00, 0x10, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x03, 0x00, 0x02, 0x00, 0x39, 
    0x00, 0x00, 0x02, 0x00, 0x05, 0xC8, 0x00, 0x03, 0x00, 0x07, 0x00, 0x23, 
    0x40, 0x10, 0x05, 0x06, 0x02, 0x01, 0x04, 0x07, 0x03, 0x00, 0x05, 0x04, 
    0x02, 0x03, 0x06, 0x07, 0x01, 0x00, 0x2F, 0x3C, 0xDC, 0x3C, 0x2F, 0x3C, 
    0xDC, 0x3C, 0x00, 0x2F, 0x3C, 0xDC, 0x3C, 0x2F, 0x3C, 0xDC, 0x3C, 0x33, 
    0x11, 0x21, 0x11, 0x27, 0x11, 0x21, 0x11, 0x39, 0x01, 0xC7, 0x39, 0xFE, 
    0xAB, 0x05, 0xC8, 0xFA, 0x38, 0x39, 0x05, 0x56, 0xFA, 0xAA, 0x00, 0x00, 
    0x00, 0x02, 0x00, 0x50, 0xFF, 0xDB, 0x04, 0x23, 0x05, 0xED, 0x00, 0x0F, 
    0x00, 0x1B, 0x00, 0x3B, 0x40, 0x09, 0x00, 0x00, 0x14, 0x21, 0x08, 0x10, 
    0x21, 0x00, 0x30, 0xB8, 0x01, 0x2B, 0x40, 0x0E, 0x08, 0x02, 0x00, 0x00, 
    0x0E, 0x00, 0x00, 0x16, 0x20, 0x04, 0x12, 0x20, 0x0C, 0x30, 0xB8, 0x01, 
    0x2B, 0xB1, 0x0C, 0x04, 0x2F, 0x2F, 0x1F, 0x1E, 0x10, 0xED, 0x10, 0xED, 
    0x1F, 0x1E, 0x2B, 0x3F, 0x3F, 0x1F, 0x1E, 0x10, 0xED, 0x10, 0xED, 0x1F, 
    0x1E, 0x31, 0x30, 0x01, 0x32, 0x17, 0x16, 0x11, 0x10, 0x07, 0x06, 0x23, 
    0x22, 0x27, 0x26, 0x11, 0x10, 0x37, 0x36, 0x17, 0x22, 0x11, 0x10, 0x33, 
    0x32, 0x11, 0x34, 0x27, 0x26, 0x27, 0x26, 0x02, 0x3A, 0xDC, 0x86, 0x87, 
    0x86, 0x86, 0xE3, 0xC2, 0x7F, 0xA3, 0x86, 0x87, 0xDD, 0xAF, 0xAE, 0xAF, 
    0x27, 0x11, 0x2E, 0x20, 0x05, 0xED, 0xD4, 0xD3, 0xFE, 0xA2, 0xFE, 0x9A, 
    0xD3, 0xD4, 0xAC, 0xDB, 0x01, 0x82, 0x01, 0x61, 0xD4, 0xD4, 0xB9, 0xFD, 
    0xAE, 0xFD, 0xB2, 0x02, 0x5E, 0xE6, 0xBA, 0x53, 0x2F, 0x20, 0x00, 0x00, 
    0x00, 0x01, 0x00, 0xB6, 0x00, 0x00, 0x04, 0x2E, 0x05, 0xED, 0x00, 0x09, 
    0x00, 0x4C, 0x40, 0x13, 0x06, 0x05, 0x04, 0x03, 0x04, 0x0D, 0x01, 0x00, 
    0x00, 0x08, 0x07, 0x02, 0x01, 0x0A, 0x03, 0x00, 0x01, 0x04, 0x30, 0xB8, 
    0x01, 0x2B, 0x40, 0x0F, 0x09, 0x00, 0x01, 0x00, 0x0E, 0x00, 0x00, 0x07, 
    0x06, 0x05, 0x01, 0x02, 0x01, 0x04, 0x30, 0xB8, 0x01, 0x2B, 0x40, 0x0D, 
    0x09, 0x08, 0x01, 0x03, 0x02, 0x01, 0x05, 0x04, 0x01, 0x00, 0x03, 0x03, 
    0x00, 0x2A, 0x1F, 0x1E, 0x2A, 0x1F, 0x1E, 0x2B, 0x2B, 0x1F, 0x1E, 0x2A, 
    0x1F, 0x1E, 0x10, 0x2A, 0x31, 0x30, 0x33, 0x35, 0x21, 0x11, 0x05, 0x35, 
    0x25, 0x11, 0x21, 0x15, 0xB6, 0x01, 0x28, 0xFE, 0xD8, 0x02, 0x50, 0x01, 
    0x28, 0xAD, 0x04, 0x44, 0x4A, 0xB2, 0x94, 0xFA, 0xC0, 0xAD, 0x00, 0x00, 
    0x00, 0x01, 0x00, 0x4D, 0x00, 0x00, 0x03, 0xF2, 0x05, 0xED, 0x00, 0x1D, 
    0x00, 0x63, 0xB5, 0x00, 0x00, 0x0B, 0x12, 0x10, 0x30, 0xB8, 0x01, 0x2B, 
    0x40, 0x14, 0x10, 0x00, 0x01, 0x0E, 0x0D, 0x02, 0x00, 0x01, 0x03, 0x00, 
    0x00, 0x00, 0x1C, 0x1B, 0x01, 0x02, 0x00, 0x01, 0x06, 0x30, 0xB8, 0x01, 
    0x2B, 0x40, 0x0B, 0x1D, 0x00, 0x01, 0x00, 0x0E, 0x00, 0x00, 0x09, 0x20, 
    0x14, 0x30, 0xB8, 0x01, 0x2B, 0x40, 0x11, 0x1B, 0x1C, 0x0D, 0x02, 0x14, 
    0x1C, 0x1D, 0x1C, 0x01, 0x0E, 0x0D, 0x01, 0x01, 0x00, 0x01, 0x03, 0x00, 
    0x2A, 0x10, 0xC4, 0x2B, 0x1F, 0x1E, 0x10, 0xED, 0x1F, 0x1E, 0x2B, 0x2B, 
    0x1F, 0x1E, 0x2A, 0x1F, 0x1E, 0x14, 0x2B, 0x14, 0x3F, 0x1F, 0x1E, 0x10, 
    0xED, 0x1F, 0x1E, 0x31, 0x30, 0x33, 0x35, 0x36, 0x3F, 0x02, 0x36, 0x37, 
    0x36, 0x35, 0x34, 0x23, 0x22, 0x07, 0x35, 0x36, 0x33, 0x32, 0x17, 0x16, 
    0x15, 0x14, 0x07, 0x06, 0x07, 0x07, 0x06, 0x07, 0x21, 0x15, 0x4D, 0x51, 
    0x76, 0x66, 0x76, 0x7B, 0x26, 0x26, 0xDA, 0x8A, 0xE0, 0xE8, 0xB3, 0xE1, 
    0x81, 0x82, 0x3E, 0x42, 0x9F, 0x63, 0xC0, 0x14, 0x02, 0x51, 0xEA, 0x8F, 
    0x79, 0x69, 0x78, 0x7D, 0x47, 0x46, 0x69, 0xE8, 0x6E, 0xD9, 0x54, 0x70, 
    0x6F, 0xC2, 0x82, 0x66, 0x6C, 0x85, 0x53, 0xA3, 0x93, 0xEA, 0x00, 0x00, 
    0x00, 0x01, 0x00, 0x89, 0xFF, 0xDB, 0x03, 0xFD, 0x05, 0xED, 0x00, 0x27, 
    0x00, 0x64, 0x40, 0x09, 0x00, 0x00, 0x11, 0x21, 0x16, 0x03, 0x21, 0x26, 
    0x30, 0xB8, 0x01, 0x2B, 0x40, 0x1E, 0x26, 0x02, 0x16, 0x00, 0x01, 0x01, 
    0x1E, 0x14, 0x13, 0x0B, 0x0A, 0x09, 0x01, 0x00, 0x08, 0x00, 0x02, 0x03, 
    0x00, 0x00, 0x0E, 0x00, 0x00, 0x0F, 0x23, 0x1A, 0x05, 0x22, 0x22, 0x30, 
    0xB8, 0x01, 0x2B, 0x40, 0x12, 0x1E, 0x09, 0x02, 0x0D, 0x22, 0x1A, 0x0A, 
    0x0B, 0x0A, 0x01, 0x14, 0x13, 0x01, 0x01, 0x00, 0x01, 0x03, 0x00, 0x2A, 
    0x10, 0xC4, 0xC4, 0x2A, 0x1F, 0x1E, 0x10, 0xED, 0x10, 0xED, 0x1F, 0x1E, 
    0x2B, 0x13, 0x14, 0x2B, 0x13, 0x14, 0x3F, 0x3F, 0x1F, 0x1E, 0x10, 0xED, 
    0x10, 0xED, 0x1F, 0x1E, 0x31, 0x30, 0x37, 0x35, 0x16, 0x33, 0x32, 0x35, 
    0x34, 0x27, 0x26, 0x23, 0x23, 0x35, 0x36, 0x37, 0x36, 0x35, 0x34, 0x23, 
    0x22, 0x07, 0x35, 0x36, 0x33, 0x32, 0x17, 0x16, 0x15, 0x14, 0x07, 0x06, 
    0x07, 0x16, 0x17, 0x16, 0x15, 0x14, 0x07, 0x06, 0x23, 0x22, 0x89, 0xE3, 
    0x6B, 0xF2, 0x57, 0x56, 0xD7, 0x33, 0xD2, 0x55, 0x67, 0xDB, 0x95, 0x93, 
    0xAD, 0xBA, 0xDB, 0x77, 0x78, 0x77, 0x47, 0x89, 0x78, 0x3F, 0xBF, 0x93, 
    0x93, 0xF3, 0x9F, 0x0B, 0xDE, 0x55, 0xF5, 0xA3, 0x43, 0x43, 0xB1, 0x02, 
    0x2D, 0x36, 0x99, 0xD4, 0x54, 0xCA, 0x42, 0x5D, 0x5D, 0xA7, 0x9F, 0x65, 
    0x3D, 0x31, 0x1F, 0x24, 0x6F, 0xDD, 0xC2, 0x77, 0x77, 0x00, 0x00, 0x00, 
    0x00, 0x02, 0x00, 0x1F, 0x00, 0x00, 0x04, 0x2C, 0x05, 0xC8, 0x00, 0x0A, 
    0x00, 0x0D, 0x00, 0x60, 0x40, 0x11, 0x0D, 0x02, 0x01, 0x02, 0x00, 0x00, 
    0x0C, 0x0B, 0x05, 0x04, 0x01, 0x1C, 0x04, 0x00, 0x01, 0x04, 0x30, 0xB8, 
    0x01, 0x2B, 0x40, 0x23, 0x0A, 0x07, 0x06, 0x00, 0x03, 0x09, 0x08, 0x01, 
    0x02, 0x00, 0x03, 0x02, 0x00, 0x0E, 0x0B, 0x02, 0x02, 0x09, 0x00, 0x03, 
    0x00, 0x00, 0x0A, 0x09, 0x25, 0x01, 0x03, 0x0D, 0x0C, 0x24, 0x01, 0x03, 
    0x02, 0x04, 0x30, 0xB8, 0x01, 0x2B, 0x40, 0x0D, 0x06, 0x05, 0x01, 0x08, 
    0x07, 0x04, 0x03, 0x03, 0x01, 0x00, 0x01, 0x03, 0x00, 0x2A, 0x1F, 0x1E, 
    0x2A, 0x1F, 0x1E, 0x2B, 0x2B, 0x3F, 0x3C, 0x2A, 0x1F, 0x1E, 0x2A, 0x1F, 
    0x1E, 0x2B, 0x31, 0x30, 0x13, 0x35, 0x01, 0x21, 0x11, 0x33, 0x15, 0x23, 
    0x11, 0x21, 0x11, 0x25, 0x21, 0x11, 0x1F, 0x02, 0x76, 0x01, 0x0F, 0x88, 
    0x88, 0xFE, 0xFD, 0xFE, 0x6C, 0x01, 0x9A, 0x01, 0x8B, 0xDE, 0x03, 0x5F, 
    0xFC, 0xA1, 0xDE, 0xFE, 0x75, 0x01, 0x8B, 0xDE, 0x02, 0x44, 0x00, 0x00, 
    0x00, 0x01, 0x00, 0xB8, 0xFF, 0xDB, 0x03, 0xF8, 0x05, 0xC8, 0x00, 0x19, 
    0x00, 0x69, 0xB5, 0x00, 0x00, 0x03, 0x21, 0x18, 0x30, 0xB8, 0x01, 0x2B, 
    0x40, 0x17, 0x18, 0x02, 0x09, 0x01, 0x10, 0x0B, 0x09, 0x01, 0x00, 0x05, 
    0x0E, 0x02, 0x03, 0x00, 0x00, 0x00, 0x0F, 0x0E, 0x01, 0x0C, 0x01, 0x06, 
    0x30, 0xB8, 0x01, 0x2B, 0x40, 0x0A, 0x0D, 0x0C, 0x00, 0x0E, 0x00, 0x00, 
    0x07, 0x20, 0x14, 0x30, 0xB8, 0x01, 0x2B, 0x40, 0x13, 0x10, 0x0F, 0x02, 
    0x0D, 0x0B, 0x03, 0x14, 0x0D, 0x0E, 0x0D, 0x01, 0x0C, 0x0B, 0x01, 0x01, 
    0x00, 0x01, 0x03, 0x00, 0x2A, 0x10, 0xC4, 0x2B, 0x1F, 0x1E, 0x10, 0xED, 
    0x1F, 0x1E, 0x2B, 0x3F, 0x3C, 0x1F, 0x1E, 0x2A, 0x1F, 0x1E, 0x13, 0x2B, 
    0x13, 0x2F, 0x3F, 0x1F, 0x1E, 0x10, 0xED, 0x1F, 0x1E, 0x31, 0x30, 0x37, 
    0x35, 0x16, 0x33, 0x32, 0x37, 0x36, 0x35, 0x10, 0x21, 0x22, 0x07, 0x11, 
    0x21, 0x15, 0x21, 0x03, 0x04, 0x17, 0x16, 0x15, 0x14, 0x07, 0x06, 0x23, 
    0x22, 0xB8, 0x99, 0x71, 0x71, 0x45, 0x45, 0xFE, 0x87, 0x39, 0x39, 0x03, 
    0x08, 0xFD, 0xD0, 0x0F, 0x01, 0x03, 0x97, 0xC3, 0x95, 0x95, 0xE7, 0x5F, 
    0x06, 0xD6, 0x48, 0x4B, 0x4B, 0x7D, 0x01, 0x44, 0x0A, 0x02, 0xE7, 0xEA, 
    0xFE, 0xC2, 0x04, 0x67, 0x84, 0xF7, 0xD5, 0x85, 0x85, 0x00, 0x00, 0x00, 
    0x00, 0x02, 0x00, 0x34, 0xFF, 0xDB, 0x04, 0x25, 0x05, 0xED, 0x00, 0x1D, 
    0x00, 0x29, 0x00, 0x5C, 0x40, 0x0C, 0x00, 0x00, 0x26, 0x21, 0x14, 0x1E, 
    0x21, 0x0C, 0x03, 0x21, 0x1C, 0x30, 0xB8, 0x01, 0x2B, 0x40, 0x18, 0x1C, 
    0x00, 0x14, 0x02, 0x0C, 0x01, 0x01, 0x0C, 0x0A, 0x01, 0x00, 0x04, 0x00, 
    0x02, 0x03, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x28, 0x10, 0x10, 0x30, 0xB8, 
    0x01, 0x2B, 0x40, 0x0A, 0x10, 0x00, 0x0A, 0x22, 0x18, 0x00, 0x01, 0x00, 
    0x01, 0x00, 0x2B, 0x10, 0xC4, 0xC4, 0xC0, 0x10, 0xC4, 0x1F, 0x1E, 0x10, 
    0xED, 0x1F, 0x1E, 0x2B, 0x13, 0x14, 0x2B, 0x13, 0x14, 0x2F, 0x3F, 0x3F, 
    0x1F, 0x1E, 0x10, 0xED, 0x10, 0xED, 0x10, 0xED, 0x1F, 0x1E, 0x31, 0x30, 
    0x01, 0x15, 0x26, 0x23, 0x22, 0x07, 0x06, 0x07, 0x06, 0x17, 0x17, 0x36, 
    0x33, 0x32, 0x17, 0x16, 0x15, 0x14, 0x07, 0x06, 0x23, 0x22, 0x27, 0x26, 
    0x11, 0x10, 0x37, 0x36, 0x21, 0x32, 0x03, 0x22, 0x07, 0x06, 0x15, 0x14, 
    0x17, 0x16, 0x33, 0x32, 0x11, 0x10, 0x03, 0xDD, 0xC3, 0x5F, 0xB4, 0x5B, 
    0x28, 0x10, 0x0C, 0x02, 0x01, 0x81, 0xA6, 0xB7, 0x6E, 0x6E, 0x80, 0x7F, 
    0xDB, 0xFB, 0x8E, 0x8E, 0xAC, 0xAB, 0x01, 0x23, 0x7B, 0xD6, 0x62, 0x3C, 
    0x3C, 0x3B, 0x3B, 0x62, 0xC4, 0x05, 0xBF, 0xD8, 0x4E, 0xAC, 0x4E, 0x6D, 
    0x53, 0x3B, 0x18, 0x91, 0x7C, 0x7C, 0xD5, 0xF2, 0x90, 0x8F, 0xC2, 0xC1, 
    0x01, 0x59, 0x01, 0x79, 0xDE, 0xDF, 0xFD, 0x16, 0x54, 0x54, 0x8D, 0x90, 
    0x55, 0x55, 0x01, 0x3A, 0x01, 0x35, 0x00, 0x00, 0x00, 0x01, 0x00, 0x71, 
    0x00, 0x00, 0x04, 0x1B, 0x05, 0xC8, 0x00, 0x0B, 0x00, 0x36, 0x40, 0x0B, 
    0x00, 0x00, 0x09, 0x06, 0x05, 0x26, 0x02, 0x07, 0x01, 0x04, 0x30, 0xB8, 
    0x01, 0x2B, 0x40, 0x17, 0x0B, 0x00, 0x01, 0x00, 0x08, 0x07, 0x00, 0x0E, 
    0x0B, 0x05, 0x00, 0x03, 0x08, 0x06, 0x03, 0x09, 0x08, 0x01, 0x07, 0x06, 
    0x01, 0x02, 0x00, 0x2A, 0x2B, 0x2B, 0x3F, 0x3C, 0x2B, 0x1F, 0x1E, 0x2A, 
    0x1F, 0x1E, 0x31, 0x30, 0x33, 0x36, 0x37, 0x36, 0x13, 0x13, 0x21, 0x35, 
    0x21, 0x15, 0x00, 0x03, 0xB0, 0x15, 0x50, 0x51, 0xD9, 0xEA, 0xFD, 0x48, 
    0x03, 0xAA, 0xFD, 0xF6, 0x18, 0xA2, 0xAC, 0xB1, 0x01, 0x5E, 0x01, 0x7B, 
    0xF0, 0xF0, 0xFD, 0x1F, 0xFE, 0x09, 0x00, 0x00, 0x00, 0x03, 0x00, 0x56, 
    0xFF, 0xDB, 0x04, 0x36, 0x05, 0xED, 0x00, 0x1D, 0x00, 0x2A, 0x00, 0x37, 
    0x00, 0x61, 0x40, 0x09, 0x00, 0x00, 0x2F, 0x21, 0x16, 0x22, 0x21, 0x08, 
    0x30, 0xB8, 0x01, 0x2B, 0x40, 0x1F, 0x16, 0x02, 0x08, 0x00, 0x01, 0x01, 
    0x2B, 0x1E, 0x0E, 0x00, 0x04, 0x00, 0x02, 0x03, 0x00, 0x00, 0x0E, 0x00, 
    0x00, 0x33, 0x12, 0x2D, 0x11, 0x1A, 0x24, 0x27, 0x04, 0x20, 0x27, 0x0C, 
    0x30, 0xB8, 0x01, 0x2B, 0xB7, 0x2B, 0x1E, 0x1A, 0x12, 0x0E, 0x0C, 0x04, 
    0x00, 0x2E, 0x2F, 0x2F, 0x2E, 0x2F, 0x2F, 0x2E, 0x2E, 0x1F, 0x1E, 0x10, 
    0xED, 0x10, 0xED, 0x10, 0xED, 0x10, 0xCD, 0x1F, 0x1E, 0x2B, 0x13, 0x14, 
    0x2B, 0x13, 0x14, 0x3F, 0x3F, 0x1F, 0x1E, 0x10, 0xED, 0x10, 0xED, 0x1F, 
    0x1E, 0x31, 0x30, 0x01, 0x26, 0x27, 0x26, 0x35, 0x34, 0x37, 0x36, 0x33, 
    0x32, 0x17, 0x16, 0x15, 0x14, 0x07, 0x16, 0x17, 0x16, 0x15, 0x14, 0x07, 
    0x06, 0x23, 0x22, 0x27, 0x26, 0x35, 0x34, 0x37, 0x36, 0x25, 0x36, 0x35, 
    0x34, 0x23, 0x22, 0x15, 0x14, 0x17, 0x16, 0x17, 0x16, 0x17, 0x07, 0x06, 
    0x15, 0x14, 0x33, 0x32, 0x37, 0x36, 0x35, 0x34, 0x27, 0x26, 0x27, 0x01, 
    0x69, 0x6A, 0x29, 0x2E, 0x74, 0x74, 0xCB, 0xBB, 0x6E, 0x6F, 0xE1, 0x9B, 
    0x3F, 0x4A, 0x8F, 0x8E, 0xE4, 0xDC, 0x81, 0x82, 0x4F, 0x3D, 0x01, 0x96, 
    0x7B, 0xA5, 0xA6, 0x9B, 0x04, 0x09, 0x0C, 0x14, 0x73, 0x8E, 0xE3, 0x60, 
    0x3C, 0x3C, 0x2F, 0x28, 0x6A, 0x03, 0x1D, 0x58, 0x40, 0x47, 0x77, 0xB0, 
    0x65, 0x65, 0x5B, 0x5C, 0x98, 0xCE, 0xA3, 0x66, 0x4E, 0x5C, 0x87, 0xC4, 
    0x7B, 0x7C, 0x6C, 0x6C, 0xBA, 0x94, 0x68, 0x52, 0xC6, 0x63, 0x96, 0xBA, 
    0x9E, 0x70, 0x7A, 0x03, 0x07, 0x0A, 0x10, 0xCD, 0x8B, 0xAA, 0xF5, 0x39, 
    0x39, 0x5A, 0x59, 0x34, 0x2D, 0x51, 0x00, 0x00, 0x00, 0x02, 0x00, 0x4F, 
    0xFF, 0xDB, 0x04, 0x40, 0x05, 0xED, 0x00, 0x1B, 0x00, 0x27, 0x00, 0x63, 
    0x40, 0x0C, 0x00, 0x00, 0x20, 0x21, 0x0A, 0x1C, 0x21, 0x12, 0x03, 0x21, 
    0x1A, 0x30, 0xB8, 0x01, 0x2B, 0x40, 0x1C, 0x1A, 0x02, 0x12, 0x00, 0x0A, 
    0x01, 0x01, 0x0A, 0x08, 0x07, 0x01, 0x00, 0x05, 0x00, 0x02, 0x03, 0x00, 
    0x00, 0x0E, 0x00, 0x00, 0x24, 0x0B, 0x16, 0x1E, 0x10, 0x0E, 0x30, 0xB8, 
    0x01, 0x2B, 0x40, 0x0C, 0x08, 0x07, 0x02, 0x0D, 0x16, 0x00, 0x0E, 0x00, 
    0x01, 0x00, 0x01, 0x00, 0x2B, 0x10, 0xC4, 0x10, 0xC4, 0x2A, 0x1F, 0x1E, 
    0x10, 0xED, 0x10, 0xED, 0x1F, 0x1E, 0x2B, 0x13, 0x14, 0x2B, 0x13, 0x14, 
    0x2F, 0x3F, 0x3F, 0x1F, 0x1E, 0x10, 0xED, 0x10, 0xED, 0x10, 0xED, 0x1F, 
    0x1E, 0x31, 0x30, 0x37, 0x35, 0x16, 0x33, 0x32, 0x37, 0x36, 0x35, 0x35, 
    0x06, 0x23, 0x22, 0x27, 0x26, 0x35, 0x34, 0x37, 0x36, 0x33, 0x32, 0x17, 
    0x16, 0x11, 0x10, 0x07, 0x06, 0x21, 0x22, 0x13, 0x22, 0x11, 0x10, 0x33, 
    0x32, 0x37, 0x36, 0x35, 0x34, 0x27, 0x26, 0x97, 0xC4, 0x5E, 0x9E, 0x59, 
    0x5A, 0x82, 0xA6, 0xB7, 0x6E, 0x6E, 0x80, 0x80, 0xDA, 0xFC, 0x8D, 0x8E, 
    0xAC, 0xAB, 0xFE, 0xDE, 0x7B, 0xD7, 0xC4, 0xC2, 0x62, 0x3D, 0x3C, 0x3B, 
    0x3B, 0x09, 0xD9, 0x4E, 0x84, 0x83, 0xED, 0x18, 0x91, 0x7C, 0x7C, 0xD6, 
    0xF2, 0x8F, 0x8F, 0xC2, 0xC1, 0xFE, 0xA8, 0xFE, 0x87, 0xDF, 0xDF, 0x05, 
    0x5A, 0xFE, 0xC6, 0xFE, 0xCA, 0x55, 0x54, 0x8C, 0x90, 0x55, 0x56, 0x00, 
    0x00, 0x01, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x38, 0x00, 0x03, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 
    0x08, 0x00, 0x00, 0xCE, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 
    0x00, 0x74, 0x00, 0xB0, 0x01, 0x10, 0x01, 0x7C, 0x01, 0xCA, 0x02, 0x2A, 
    0x02, 0x9A, 0x02, 0xD0, 0x03, 0x54, 0x03, 0xC2, 0x00, 0x01, 0x00, 0x00, 
    0x00, 0x01, 0x33, 0x33, 0x90, 0x75, 0x87, 0x64, 0x5F, 0x0F, 0x3C, 0xF5, 
    0x00, 0x0F, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB7, 0xEC, 0xA9, 0x4B, 
    0x00, 0x00, 0x00, 0x00, 0xBA, 0x1D, 0x1B, 0x0D, 0x00, 0x1F, 0xFF, 0xDB, 
    0x04, 0x40, 0x05, 0xED, 0x00, 0x01, 0x00, 0x0C, 0x00, 0x02, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x02, 0x39, 0x00, 0x39, 0x04, 0x73, 0x00, 0x50, 
    0x00, 0xB6, 0x00, 0x4D, 0x00, 0x89, 0x00, 0x1F, 0x00, 0xB8, 0x00, 0x34, 
    0x00, 0x71, 0x00, 0x56, 0x00, 0x4F, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 
    0x08, 0x19, 0xFE, 0x50, 0x00, 0x00, 0x04, 0x73, 0x00, 0x1F, 0x00, 0x33, 
    0x04, 0x40, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 
    0x00, 0x00, 0x01, 0x0A, 0x00, 0x01, 0x00, 0x2A, 0x00, 0xC0, 0x00, 0x05, 
    0x00, 0x3C, 0x00, 0x01, 0x00, 0x02, 0xFF, 0xAA, 0x00, 0x01, 0x00, 0x05, 
    0x00, 0x14, 0x00, 0x01, 0x00, 0x08, 0xFF, 0xBF, 0x00, 0x02, 0x00, 0x01, 
    0xFF, 0xBF, 0x00, 0x02, 0x00, 0x02, 0xFF, 0xD1, 0x00, 0x02, 0x00, 0x03, 
    0x00, 0x04, 0x00, 0x02, 0x00, 0x04, 0xFF, 0xE7, 0x00, 0x02, 0x00, 0x05, 
    0xFF, 0xB8, 0x00, 0x02, 0x00, 0x06, 0xFF, 0xD0, 0x00, 0x02, 0x00, 0x07, 
    0xFF, 0xCF, 0x00, 0x02, 0x00, 0x08, 0xFF, 0xD3, 0x00, 0x02, 0x00, 0x09, 
    0xFF, 0xE9, 0x00, 0x02, 0x00, 0x0A, 0xFF, 0xE0, 0x00, 0x03, 0x00, 0x02, 
    0xFF, 0xB1, 0x00, 0x03, 0x00, 0x05, 0xFF, 0xB3, 0x00, 0x03, 0x00, 0x08, 
    0xFF, 0xCC, 0x00, 0x04, 0x00, 0x02, 0xFF, 0xA1, 0x00, 0x04, 0x00, 0x05, 
    0x00, 0x03, 0x00, 0x04, 0x00, 0x08, 0xFF, 0xC1, 0x00, 0x05, 0x00, 0x02, 
    0xFF, 0x96, 0x00, 0x05, 0x00, 0x05, 0x00, 0x1A, 0x00, 0x05, 0x00, 0x08, 
    0xFF, 0xAF, 0x00, 0x06, 0x00, 0x02, 0xFF, 0xA7, 0x00, 0x06, 0x00, 0x05, 
    0x00, 0x01, 0x00, 0x06, 0x00, 0x08, 0xFF, 0xC9, 0x00, 0x07, 0x00, 0x02, 
    0xFF, 0xA8, 0x00, 0x07, 0x00, 0x05, 0x00, 0x17, 0x00, 0x07, 0x00, 0x08, 
    0xFF, 0xCA, 0x00, 0x08, 0x00, 0x02, 0xFF, 0xC8, 0x00, 0x08, 0x00, 0x03, 
    0xFF, 0xE9, 0x00, 0x08, 0x00, 0x04, 0xFF, 0xD4, 0x00, 0x08, 0x00, 0x05, 
    0xFF, 0x60, 0x00, 0x08, 0x00, 0x06, 0xFF, 0xB9, 0x00, 0x08, 0x00, 0x07, 
    0xFF, 0xCD, 0x00, 0x08, 0x00, 0x08, 0xFF, 0xEA, 0x00, 0x08, 0x00, 0x09, 
    0xFF, 0xCC, 0x00, 0x09, 0x00, 0x02, 0xFF, 0xB4, 0x00, 0x09, 0x00, 0x05, 
    0x00, 0x1F, 0x00, 0x09, 0x00, 0x08, 0xFF, 0xD4, 0x00, 0x0A, 0x00, 0x02, 
    0xFF, 0xBA, 0x00, 0x0A, 0x00, 0x05, 0x00, 0x20, 0x00, 0x0A, 0x00, 0x08, 
    0xFF, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x01, 0x26, 0x00, 0x01, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x01, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x09, 0x00, 0x55, 0x00, 0x01, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x5E, 0x00, 0x01, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x13, 0x00, 0x62, 0x00, 0x01, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0E, 0x00, 0x75, 0x00, 0x01, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x16, 0x00, 0x83, 0x00, 0x01, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x0D, 0x00, 0x99, 0x00, 0x01, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x37, 0x00, 0xA6, 0x00, 0x01, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x15, 0x00, 0xDD, 0x00, 0x01, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x1F, 0x00, 0xF2, 0x00, 0x01, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x13, 0x01, 0x11, 0x00, 0x01, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x1B, 0x01, 0x24, 0x00, 0x03, 
    0x00, 0x01, 0x04, 0x09, 0x00, 0x00, 0x00, 0xAA, 0x01, 0x3F, 0x00, 0x03, 
    0x00, 0x01, 0x04, 0x09, 0x00, 0x01, 0x00, 0x12, 0x01, 0xE9, 0x00, 0x03, 
    0x00, 0x01, 0x04, 0x09, 0x00, 0x02, 0x00, 0x08, 0x01, 0xFB, 0x00, 0x03, 
    0x00, 0x01, 0x04, 0x09, 0x00, 0x03, 0x00, 0x26, 0x02, 0x03, 0x00, 0x03, 
    0x00, 0x01, 0x04, 0x09, 0x00, 0x04, 0x00, 0x1C, 0x02, 0x29, 0x00, 0x03, 
    0x00, 0x01, 0x04, 0x09, 0x00, 0x05, 0x00, 0x2C, 0x02, 0x45, 0x00, 0x03, 
    0x00, 0x01, 0x04, 0x09, 0x00, 0x06, 0x00, 0x1A, 0x02, 0x71, 0x00, 0x03, 
    0x00, 0x01, 0x04, 0x09, 0x00, 0x07, 0x00, 0x6E, 0x02, 0x8B, 0x00, 0x03, 
    0x00, 0x01, 0x04, 0x09, 0x00, 0x08, 0x00, 0x2A, 0x02, 0xF9, 0x00, 0x03, 
    0x00, 0x01, 0x04, 0x09, 0x00, 0x09, 0x00, 0x3E, 0x03, 0x23, 0x00, 0x03, 
    0x00, 0x01, 0x04, 0x09, 0x00, 0x0B, 0x00, 0x26, 0x03, 0x61, 0x00, 0x03, 
    0x00, 0x01, 0x04, 0x09, 0x00, 0x0C, 0x00, 0x36, 0x03, 0x87, 0x43, 0x6F, 
    0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x20, 0x28, 0x63, 0x29, 0x20, 
    0x32, 0x30, 0x30, 0x31, 0x20, 0x62, 0x79, 0x20, 0x42, 0x69, 0x67, 0x65, 
    0x6C, 0x6F, 0x77, 0x20, 0x26, 0x20, 0x48, 0x6F, 0x6C, 0x6D, 0x65, 0x73, 
    0x20, 0x49, 0x6E, 0x63, 0x2E, 0x20, 0x49, 0x6E, 0x73, 0x74, 0x72, 0x75, 
    0x63, 0x74, 0x69, 0x6F, 0x6E, 0x73, 0x20, 0x63, 0x6F, 0x70, 0x79, 0x72, 
    0x69, 0x67, 0x68, 0x74, 0x20, 0x28, 0x63, 0x29, 0x20, 0x32, 0x30, 0x30, 
    0x31, 0x20, 0x62, 0x79, 0x20, 0x55, 0x52, 0x57, 0x2B, 0x2B, 0x2E, 0x4C, 
    0x75, 0x78, 0x69, 0x20, 0x53, 0x61, 0x6E, 0x73, 0x42, 0x6F, 0x6C, 0x64, 
    0x4C, 0x75, 0x78, 0x69, 0x20, 0x53, 0x61, 0x6E, 0x73, 0x20, 0x42, 0x6F, 
    0x6C, 0x64, 0x3A, 0x20, 0x42, 0x26, 0x48, 0x4C, 0x75, 0x78, 0x69, 0x20, 
    0x53, 0x61, 0x6E, 0x73, 0x20, 0x42, 0x6F, 0x6C, 0x64, 0x31, 0x2E, 0x32, 
    0x20, 0x3A, 0x20, 0x4F, 0x63, 0x74, 0x6F, 0x62, 0x65, 0x72, 0x20, 0x31, 
    0x32, 0x2C, 0x20, 0x32, 0x30, 0x30, 0x31, 0x4C, 0x75, 0x78, 0x69, 0x53, 
    0x61, 0x6E, 0x73, 0x2D, 0x42, 0x6F, 0x6C, 0x64, 0x4C, 0x75, 0x78, 0x69, 
    0x20, 0x69, 0x73, 0x20, 0x61, 0x20, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 
    0x65, 0x72, 0x65, 0x64, 0x20, 0x74, 0x72, 0x61, 0x64, 0x65, 0x6D, 0x61, 
    0x72, 0x6B, 0x20, 0x6F, 0x66, 0x20, 0x42, 0x69, 0x67, 0x65, 0x6C, 0x6F, 
    0x77, 0x20, 0x26, 0x20, 0x48, 0x6F, 0x6C, 0x6D, 0x65, 0x73, 0x20, 0x49, 
    0x6E, 0x63, 0x2E, 0x42, 0x69, 0x67, 0x65, 0x6C, 0x6F, 0x77, 0x20, 0x26, 
    0x20, 0x48, 0x6F, 0x6C, 0x6D, 0x65, 0x73, 0x20, 0x49, 0x6E, 0x63, 0x2E, 
    0x4B, 0x72, 0x69, 0x73, 0x20, 0x48, 0x6F, 0x6C, 0x6D, 0x65, 0x73, 0x20, 
    0x61, 0x6E, 0x64, 0x20, 0x43, 0x68, 0x61, 0x72, 0x6C, 0x65, 0x73, 0x20, 
    0x42, 0x69, 0x67, 0x65, 0x6C, 0x6F, 0x77, 0x68, 0x74, 0x74, 0x70, 0x3A, 
    0x2F, 0x2F, 0x77, 0x77, 0x77, 0x2E, 0x75, 0x72, 0x77, 0x70, 0x70, 0x2E, 
    0x64, 0x65, 0x64, 0x65, 0x73, 0x69, 0x67, 0x6E, 0x40, 0x62, 0x69, 0x67, 
    0x65, 0x6C, 0x6F, 0x77, 0x61, 0x6E, 0x64, 0x68, 0x6F, 0x6C, 0x6D, 0x65, 
    0x73, 0x2E, 0x63, 0x6F, 0x6D, 0x00, 0x43, 0x00, 0x6F, 0x00, 0x70, 0x00, 
    0x79, 0x00, 0x72, 0x00, 0x69, 0x00, 0x67, 0x00, 0x68, 0x00, 0x74, 0x00, 
    0x20, 0x00, 0x28, 0x00, 0x63, 0x00, 0x29, 0x00, 0x20, 0x00, 0x32, 0x00, 
    0x30, 0x00, 0x30, 0x00, 0x31, 0x00, 0x20, 0x00, 0x62, 0x00, 0x79, 0x00, 
    0x20, 0x00, 0x42, 0x00, 0x69, 0x00, 0x67, 0x00, 0x65, 0x00, 0x6C, 0x00, 
    0x6F, 0x00, 0x77, 0x00, 0x20, 0x00, 0x26, 0x00, 0x20, 0x00, 0x48, 0x00, 
    0x6F, 0x00, 0x6C, 0x00, 0x6D, 0x00, 0x65, 0x00, 0x73, 0x00, 0x20, 0x00, 
    0x49, 0x00, 0x6E, 0x00, 0x63, 0x00, 0x2E, 0x00, 0x20, 0x00, 0x49, 0x00, 
    0x6E, 0x00, 0x73, 0x00, 0x74, 0x00, 0x72, 0x00, 0x75, 0x00, 0x63, 0x00, 
    0x74, 0x00, 0x69, 0x00, 0x6F, 0x00, 0x6E, 0x00, 0x73, 0x00, 0x20, 0x00, 
    0x63, 0x00, 0x6F, 0x00, 0x70, 0x00, 0x79, 0x00, 0x72, 0x00, 0x69, 0x00, 
    0x67, 0x00, 0x68, 0x00, 0x74, 0x00, 0x20, 0x00, 0x28, 0x00, 0x63, 0x00, 
    0x29, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x31, 0x00, 
    0x20, 0x00, 0x62, 0x00, 0x79, 0x00, 0x20, 0x00, 0x55, 0x00, 0x52, 0x00, 
    0x57, 0x00, 0x2B, 0x00, 0x2B, 0x00, 0x2E, 0x00, 0x4C, 0x00, 0x75, 0x00, 
    0x78, 0x00, 0x69, 0x00, 0x20, 0x00, 0x53, 0x00, 0x61, 0x00, 0x6E, 0x00, 
    0x73, 0x00, 0x42, 0x00, 0x6F, 0x00, 0x6C, 0x00, 0x64, 0x00, 0x4C, 0x00, 
    0x75, 0x00, 0x78, 0x00, 0x69, 0x00, 0x20, 0x00, 0x53, 0x00, 0x61, 0x00, 
    0x6E, 0x00, 0x73, 0x00, 0x20, 0x00, 0x42, 0x00, 0x6F, 0x00, 0x6C, 0x00, 
    0x64, 0x00, 0x3A, 0x00, 0x20, 0x00, 0x42, 0x00, 0x26, 0x00, 0x48, 0x00, 
    0x4C, 0x00, 0x75, 0x00, 0x78, 0x00, 0x69, 0x00, 0x20, 0x00, 0x53, 0x00, 
    0x61, 0x00, 0x6E, 0x00, 0x73, 0x00, 0x20, 0x00, 0x42, 0x00, 0x6F, 0x00, 
    0x6C, 0x00, 0x64, 0x00, 0x31, 0x00, 0x2E, 0x00, 0x32, 0x00, 0x20, 0x00, 
    0x3A, 0x00, 0x20, 0x00, 0x4F, 0x00, 0x63, 0x00, 0x74, 0x00, 0x6F, 0x00, 
    0x62, 0x00, 0x65, 0x00, 0x72, 0x00, 0x20, 0x00, 0x31, 0x00, 0x32, 0x00, 
    0x2C, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x31, 0x00, 
    0x4C, 0x00, 0x75, 0x00, 0x78, 0x00, 0x69, 0x00, 0x53, 0x00, 0x61, 0x00, 
    0x6E, 0x00, 0x73, 0x00, 0x2D, 0x00, 0x42, 0x00, 0x6F, 0x00, 0x6C, 0x00, 
    0x64, 0x00, 0x4C, 0x00, 0x75, 0x00, 0x78, 0x00, 0x69, 0x00, 0x20, 0x00, 
    0x69, 0x00, 0x73, 0x00, 0x20, 0x00, 0x61, 0x00, 0x20, 0x00, 0x72, 0x00, 
    0x65, 0x00, 0x67, 0x00, 0x69, 0x00, 0x73, 0x00, 0x74, 0x00, 0x65, 0x00, 
    0x72, 0x00, 0x65, 0x00, 0x64, 0x00, 0x20, 0x00, 0x74, 0x00, 0x72, 0x00, 
    0x61, 0x00, 0x64, 0x00, 0x65, 0x00, 0x6D, 0x00, 0x61, 0x00, 0x72, 0x00, 
    0x6B, 0x00, 0x20, 0x00, 0x6F, 0x00, 0x66, 0x00, 0x20, 0x00, 0x42, 0x00, 
    0x69, 0x00, 0x67, 0x00, 0x65, 0x00, 0x6C, 0x00, 0x6F, 0x00, 0x77, 0x00, 
    0x20, 0x00, 0x26, 0x00, 0x20, 0x00, 0x48, 0x00, 0x6F, 0x00, 0x6C, 0x00, 
    0x6D, 0x00, 0x65, 0x00, 0x73, 0x00, 0x20, 0x00, 0x49, 0x00, 0x6E, 0x00, 
    0x63, 0x00, 0x2E, 0x00, 0x42, 0x00, 0x69, 0x00, 0x67, 0x00, 0x65, 0x00, 
    0x6C, 0x00, 0x6F, 0x00, 0x77, 0x00, 0x20, 0x00, 0x26, 0x00, 0x20, 0x00, 
    0x48, 0x00, 0x6F, 0x00, 0x6C, 0x00, 0x6D, 0x00, 0x65, 0x00, 0x73, 0x00, 
    0x20, 0x00, 0x49, 0x00, 0x6E, 0x00, 0x63, 0x00, 0x2E, 0x00, 0x4B, 0x00, 
    0x72, 0x00, 0x69, 0x00, 0x73, 0x00, 0x20, 0x00, 0x48, 0x00, 0x6F, 0x00, 
    0x6C, 0x00, 0x6D, 0x00, 0x65, 0x00, 0x73, 0x00, 0x20, 0x00, 0x61, 0x00, 
    0x6E, 0x00, 0x64, 0x00, 0x20, 0x00, 0x43, 0x00, 0x68, 0x00, 0x61, 0x00, 
    0x72, 0x00, 0x6C, 0x00, 0x65, 0x00, 0x73, 0x00, 0x20, 0x00, 0x42, 0x00, 
    0x69, 0x00, 0x67, 0x00, 0x65, 0x00, 0x6C, 0x00, 0x6F, 0x00, 0x77, 0x00, 
    0x68, 0x00, 0x74, 0x00, 0x74, 0x00, 0x70, 0x00, 0x3A, 0x00, 0x2F, 0x00, 
    0x2F, 0x00, 0x77, 0x00, 0x77, 0x00, 0x77, 0x00, 0x2E, 0x00, 0x75, 0x00, 
    0x72, 0x00, 0x77, 0x00, 0x70, 0x00, 0x70, 0x00, 0x2E, 0x00, 0x64, 0x00, 
    0x65, 0x00, 0x64, 0x00, 0x65, 0x00, 0x73, 0x00, 0x69, 0x00, 0x67, 0x00, 
    0x6E, 0x00, 0x40, 0x00, 0x62, 0x00, 0x69, 0x00, 0x67, 0x00, 0x65, 0x00, 
    0x6C, 0x00, 0x6F, 0x00, 0x77, 0x00, 0x61, 0x00, 0x6E, 0x00, 0x64, 0x00, 
    0x68, 0x00, 0x6F, 0x00, 0x6C, 0x00, 0x6D, 0x00, 0x65, 0x00, 0x73, 0x00, 
    0x2E, 0x00, 0x63, 0x00, 0x6F, 0x00, 0x6D, 0x00, 0x00, 0x02, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x13, 0x00, 0x14, 
    0x00, 0x15, 0x00, 0x16, 0x00, 0x17, 0x00, 0x18, 0x00, 0x19, 0x00, 0x1A, 
    0x00, 0x1B, 0x00, 0x1C, 0xB1, 0x30, 0x01, 0xB8, 0x01, 0x49, 0x18, 0x85, 
    0x8D, 0x1D, 0x00, 0x00, 0x09, 0xC9, 0x02, 0x51, 0x02, 0x2C, 0x02, 0x2C, 
    0x02, 0x2C, 0x02, 0x2C, 0x02, 0x51, 0x02, 0x51, 0x02, 0x2C, 0x02, 0x51, 
    0x02, 0x2C, 0x02, 0x2C, 0x00, 0x01, 0x00, 0x00, 0x08, 0x19, 0x01, 0xB0, 
    0x00, 0x00, 0x09, 0xC9, 0x02, 0x2C, 0x01, 0x8B, 0x08, 0x3E, 0x00, 0x00, 
    0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x01 };

unsigned char auchLuxiSR[] = {
    0x00, 0x01, 0x00, 0x00, 0x00, 0x11, 0x01, 0x00, 0x00, 0x04, 0x00, 0x10, 
    0x4F, 0x53, 0x2F, 0x32, 0x64, 0x66, 0x60, 0x14, 0x00, 0x00, 0x01, 0x1C, 
    0x00, 0x00, 0x00, 0x60, 0x63, 0x6D, 0x61, 0x70, 0x0A, 0x70, 0x11, 0x51, 
    0x00, 0x00, 0x01, 0x7C, 0x00, 0x00, 0x01, 0x3A, 0x63, 0x76, 0x74, 0x20, 
    0x12, 0xD7, 0x0E, 0xC1, 0x00, 0x00, 0x02, 0xB8, 0x00, 0x00, 0x00, 0x5C, 
    0x66, 0x70, 0x67, 0x6D, 0x99, 0x2A, 0xAF, 0x5A, 0x00, 0x00, 0x03, 0x14, 
    0x00, 0x00, 0x00, 0x68, 0x67, 0x61, 0x73, 0x70, 0x00, 0x17, 0x00, 0x09, 
    0x00, 0x00, 0x03, 0x7C, 0x00, 0x00, 0x00, 0x10, 0x67, 0x6C, 0x79, 0x66, 
    0xD8, 0x4A, 0xB8, 0x66, 0x00, 0x00, 0x03, 0x8C, 0x00, 0x00, 0x07, 0x88, 
    0x68, 0x65, 0x61, 0x64, 0xD5, 0x8D, 0x3E, 0x5A, 0x00, 0x00, 0x0B, 0x4C, 
    0x00, 0x00, 0x00, 0x36, 0x68, 0x68, 0x65, 0x61, 0x0C, 0x53, 0x02, 0xF8, 
    0x00, 0x00, 0x0B, 0xA0, 0x00, 0x00, 0x00, 0x24, 0x68, 0x6D, 0x74, 0x78, 
    0x09, 0xAA, 0x01, 0xC5, 0x00, 0x00, 0x0B, 0x84, 0x00, 0x00, 0x00, 0x1A, 
    0x6B, 0x65, 0x72, 0x6E, 0xFC, 0x68, 0xFD, 0x4F, 0x00, 0x00, 0x0B, 0xC4, 
    0x00, 0x00, 0x01, 0x0E, 0x6C, 0x6F, 0x63, 0x61, 0x09, 0x38, 0x0B, 0x10, 
    0x00, 0x00, 0x0B, 0x34, 0x00, 0x00, 0x00, 0x18, 0x6D, 0x61, 0x78, 0x70, 
    0x08, 0x24, 0x00, 0xF8, 0x00, 0x00, 0x0B, 0x14, 0x00, 0x00, 0x00, 0x20, 
    0x6E, 0x61, 0x6D, 0x65, 0x9E, 0xC6, 0x16, 0x36, 0x00, 0x00, 0x0C, 0xD4, 
    0x00, 0x00, 0x04, 0xEF, 0x70, 0x6F, 0x73, 0x74, 0x00, 0x80, 0x00, 0x78, 
    0x00, 0x00, 0x11, 0xC4, 0x00, 0x00, 0x00, 0x38, 0x70, 0x72, 0x65, 0x70, 
    0x3F, 0x96, 0x1A, 0x3D, 0x00, 0x00, 0x11, 0xFC, 0x00, 0x00, 0x00, 0x0A, 
    0x76, 0x68, 0x65, 0x61, 0x12, 0x0D, 0x0C, 0xDC, 0x00, 0x00, 0x12, 0x20, 
    0x00, 0x00, 0x00, 0x24, 0x76, 0x6D, 0x74, 0x78, 0x13, 0xD9, 0x0C, 0x86, 
    0x00, 0x00, 0x12, 0x08, 0x00, 0x00, 0x00, 0x18, 0x00, 0x02, 0x03, 0x88, 
    0x01, 0x90, 0x00, 0x05, 0x00, 0x00, 0x05, 0x9A, 0x05, 0x33, 0x00, 0x00, 
    0x01, 0x1B, 0x05, 0x9A, 0x05, 0x33, 0x00, 0x00, 0x03, 0xD1, 0x00, 0x00, 
    0x00, 0x00, 0x08, 0x00, 0x02, 0x0B, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x26, 0x48, 0x20, 0x00, 0x40, 
    0x00, 0x20, 0xFB, 0x02, 0x06, 0x44, 0xFE, 0x5C, 0x00, 0xA7, 0x07, 0x8F, 
    0x01, 0xB0, 0x00, 0x00, 0x00, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 
    0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x03, 0x00, 0x01, 
    0x00, 0x00, 0x01, 0x1A, 0x00, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 
    0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x04, 0x00, 0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 
    0x00, 0x01, 0x00, 0x00, 0x00, 0x39, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x30, 
    0xFF, 0xFF, 0xFF, 0xD1, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x05, 0xC8, 0x04, 0x3E, 0x00, 0x00, 0xFE, 0x00, 0x00, 0xC4, 0x00, 0xC8, 
    0x00, 0x7D, 0x00, 0x95, 0x00, 0xF7, 0x00, 0xD5, 0x00, 0x96, 0x00, 0x65, 
    0x00, 0xC4, 0x00, 0xAC, 0x00, 0xB5, 0x00, 0x9D, 0x00, 0x71, 0x00, 0x6D, 
    0x00, 0x85, 0x00, 0x79, 0x00, 0x68, 0x00, 0x61, 0x00, 0x8A, 0x00, 0x16, 
    0x00, 0xB7, 0x00, 0x8C, 0x00, 0xE0, 0x00, 0xBA, 0x00, 0xCE, 0x00, 0xA0, 
    0x00, 0xAB, 0x00, 0x87, 0x00, 0x57, 0x00, 0xD2, 0x00, 0xA7, 0x00, 0x9B, 
    0x00, 0xE3, 0x00, 0x9F, 0x00, 0x77, 0x00, 0x98, 0x00, 0x95, 0x00, 0xC3, 
    0x00, 0x89, 0x00, 0xCD, 0x00, 0x59, 0x00, 0xA5, 0x40, 0x0F, 0x0E, 0x0D, 
    0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 
    0x00, 0x2C, 0x17, 0x2F, 0x3C, 0x2D, 0x2C, 0x2F, 0x3C, 0x2D, 0x2C, 0x11, 
    0x12, 0x39, 0x2D, 0x2C, 0x11, 0x12, 0x17, 0x39, 0x2D, 0x2C, 0x10, 0x17, 
    0xFD, 0x3C, 0x2D, 0x2C, 0x10, 0x17, 0xF4, 0x3C, 0x2D, 0x2C, 0x10, 0x17, 
    0xDD, 0x3C, 0x2D, 0x2C, 0x10, 0x17, 0xD4, 0x3C, 0x2D, 0x2C, 0x10, 0xFD, 
    0x2D, 0x2C, 0x10, 0xF4, 0x2D, 0x2C, 0x10, 0xDD, 0x2D, 0x2C, 0x10, 0xD4, 
    0x2D, 0x2C, 0xC4, 0x2D, 0x2C, 0xC0, 0x2D, 0x2C, 0x00, 0x40, 0x0A, 0x01, 
    0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x03, 0x03, 0x00, 0x16, 0x3F, 0x3F, 
    0x3F, 0x3F, 0x16, 0x2D, 0x00, 0x00, 0x00, 0x03, 0x00, 0x08, 0x00, 0x02, 
    0x00, 0x10, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x03, 0x00, 0x02, 0x00, 0x39, 
    0x00, 0x00, 0x02, 0x00, 0x05, 0xC8, 0x00, 0x03, 0x00, 0x07, 0x00, 0x23, 
    0x40, 0x10, 0x05, 0x06, 0x02, 0x01, 0x04, 0x07, 0x03, 0x00, 0x05, 0x04, 
    0x02, 0x03, 0x06, 0x07, 0x01, 0x00, 0x2F, 0x3C, 0xDC, 0x3C, 0x2F, 0x3C, 
    0xDC, 0x3C, 0x00, 0x2F, 0x3C, 0xDC, 0x3C, 0x2F, 0x3C, 0xDC, 0x3C, 0x33, 
    0x11, 0x21, 0x11, 0x27, 0x11, 0x21, 0x11, 0x39, 0x01, 0xC7, 0x39, 0xFE, 
    0xAB, 0x05, 0xC8, 0xFA, 0x38, 0x39, 0x05, 0x56, 0xFA, 0xAA, 0x00, 0x00, 
    0x00, 0x02, 0x00, 0x50, 0xFF, 0xDB, 0x04, 0x22, 0x05, 0xED, 0x00, 0x0F, 
    0x00, 0x1F, 0x00, 0x34, 0x40, 0x1B, 0x00, 0x00, 0x18, 0x28, 0x08, 0x10, 
    0x28, 0x00, 0x30, 0xC4, 0x08, 0x02, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x1C, 
    0x2B, 0x04, 0x14, 0x09, 0x0C, 0x30, 0xC4, 0x0C, 0x04, 0x2F, 0x2F, 0x1F, 
    0x1E, 0x10, 0xED, 0x10, 0xED, 0x1F, 0x1E, 0x2B, 0x3F, 0x3F, 0x1F, 0x1E, 
    0x10, 0xED, 0x10, 0xED, 0x1F, 0x1E, 0x31, 0x30, 0x01, 0x32, 0x17, 0x16, 
    0x11, 0x10, 0x07, 0x06, 0x23, 0x22, 0x27, 0x26, 0x11, 0x10, 0x37, 0x36, 
    0x17, 0x22, 0x07, 0x06, 0x11, 0x10, 0x17, 0x16, 0x33, 0x32, 0x37, 0x36, 
    0x11, 0x10, 0x27, 0x26, 0x02, 0x39, 0xE1, 0x84, 0x84, 0x84, 0x84, 0xE7, 
    0xC6, 0x7D, 0xA0, 0x84, 0x84, 0xE1, 0x86, 0x48, 0x49, 0x49, 0x48, 0x87, 
    0x7A, 0x43, 0x5A, 0x49, 0x4B, 0x05, 0xED, 0xD0, 0xD0, 0xFE, 0x9B, 0xFE, 
    0x92, 0xCF, 0xD0, 0xA9, 0xD6, 0x01, 0x8C, 0x01, 0x67, 0xCF, 0xD1, 0x94, 
    0xA4, 0xA5, 0xFE, 0xD5, 0xFE, 0xD7, 0xA7, 0xA6, 0x7A, 0xA2, 0x01, 0x5C, 
    0x01, 0x2E, 0xA1, 0xA3, 0x00, 0x01, 0x00, 0xE6, 0x00, 0x00, 0x03, 0xFC, 
    0x05, 0xED, 0x00, 0x09, 0x00, 0x44, 0x40, 0x31, 0x06, 0x05, 0x04, 0x03, 
    0x04, 0x0D, 0x01, 0x00, 0x00, 0x08, 0x07, 0x02, 0x01, 0x07, 0x03, 0x00, 
    0x01, 0x04, 0x30, 0xC4, 0x09, 0x00, 0x01, 0x00, 0x0E, 0x00, 0x00, 0x07, 
    0x06, 0x04, 0x01, 0x02, 0x01, 0x04, 0x30, 0xC4, 0x09, 0x08, 0x01, 0x03, 
    0x02, 0x01, 0x05, 0x04, 0x01, 0x00, 0x03, 0x03, 0x00, 0x2A, 0x1F, 0x1E, 
    0x2A, 0x1F, 0x1E, 0x2B, 0x2B, 0x1F, 0x1E, 0x2A, 0x1F, 0x1E, 0x10, 0x2A, 
    0x31, 0x30, 0x33, 0x35, 0x21, 0x11, 0x05, 0x35, 0x25, 0x11, 0x21, 0x15, 
    0xE6, 0x01, 0x28, 0xFE, 0xD8, 0x01, 0xEE, 0x01, 0x28, 0x94, 0x04, 0x90, 
    0x4A, 0x98, 0x7B, 0xFA, 0xA7, 0x94, 0x00, 0x00, 0x00, 0x01, 0x00, 0x66, 
    0x00, 0x00, 0x03, 0xAD, 0x05, 0xED, 0x00, 0x1D, 0x00, 0x59, 0x40, 0x3A, 
    0x00, 0x00, 0x0B, 0x28, 0x10, 0x30, 0xC4, 0x10, 0x00, 0x01, 0x0E, 0x0D, 
    0x02, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x1C, 0x1B, 0x01, 0x0D, 0x02, 
    0x00, 0x01, 0x04, 0x30, 0xC4, 0x1D, 0x00, 0x01, 0x00, 0x0E, 0x00, 0x00, 
    0x07, 0x09, 0x14, 0x30, 0xC4, 0x1B, 0x1C, 0x0D, 0x02, 0x14, 0x1C, 0x1D, 
    0x1C, 0x01, 0x0E, 0x0D, 0x01, 0x01, 0x00, 0x01, 0x03, 0x00, 0x2A, 0x10, 
    0xC4, 0x2B, 0x1F, 0x1E, 0x10, 0xED, 0x1F, 0x1E, 0x2B, 0x2B, 0x1F, 0x1E, 
    0x2A, 0x1F, 0x1E, 0x14, 0x2B, 0x14, 0x3F, 0x1F, 0x1E, 0x10, 0xED, 0x1F, 
    0x1E, 0x31, 0x30, 0x33, 0x35, 0x36, 0x3F, 0x02, 0x36, 0x35, 0x34, 0x27, 
    0x26, 0x23, 0x22, 0x07, 0x35, 0x36, 0x33, 0x32, 0x17, 0x16, 0x15, 0x14, 
    0x07, 0x06, 0x07, 0x07, 0x06, 0x07, 0x21, 0x15, 0x66, 0x44, 0xA2, 0x6C, 
    0x62, 0xC1, 0x4A, 0x3C, 0x6A, 0x8A, 0xD6, 0xCB, 0xAF, 0xC2, 0x73, 0x73, 
    0x3B, 0x3E, 0xA2, 0x45, 0xCF, 0x2A, 0x02, 0x51, 0xAD, 0xA0, 0xA9, 0x6E, 
    0x64, 0xC5, 0xC6, 0x8D, 0x43, 0x37, 0x78, 0xAE, 0x5D, 0x71, 0x70, 0xBE, 
    0x83, 0x65, 0x68, 0x92, 0x3E, 0xBC, 0xC5, 0xAD, 0x00, 0x01, 0x00, 0x99, 
    0xFF, 0xDB, 0x03, 0xC6, 0x05, 0xED, 0x00, 0x2F, 0x00, 0x67, 0x40, 0x41, 
    0x00, 0x00, 0x19, 0x28, 0x1E, 0x08, 0x28, 0x2E, 0x30, 0xC4, 0x2E, 0x02, 
    0x1E, 0x00, 0x01, 0x01, 0x26, 0x1C, 0x1B, 0x12, 0x11, 0x10, 0x01, 0x00, 
    0x08, 0x00, 0x02, 0x03, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x17, 0x29, 0x22, 
    0x0C, 0x09, 0x2A, 0x30, 0xC4, 0x26, 0x12, 0x11, 0x10, 0x04, 0x0D, 0x2A, 
    0x22, 0x1B, 0x00, 0x00, 0x1C, 0x1B, 0x17, 0x01, 0x00, 0x01, 0x05, 0x30, 
    0xC4, 0x01, 0x00, 0x01, 0x00, 0x2B, 0x1F, 0x1E, 0x2A, 0x1F, 0x1E, 0x10, 
    0xC4, 0xC4, 0x2A, 0x1F, 0x1E, 0x10, 0xED, 0x10, 0xED, 0x1F, 0x1E, 0x2B, 
    0x13, 0x14, 0x2B, 0x13, 0x14, 0x3F, 0x3F, 0x1F, 0x1E, 0x10, 0xED, 0x10, 
    0xED, 0x1F, 0x1E, 0x31, 0x30, 0x37, 0x35, 0x17, 0x16, 0x17, 0x16, 0x17, 
    0x16, 0x33, 0x32, 0x37, 0x36, 0x35, 0x34, 0x27, 0x26, 0x23, 0x23, 0x35, 
    0x37, 0x36, 0x37, 0x36, 0x35, 0x34, 0x23, 0x22, 0x07, 0x35, 0x36, 0x33, 
    0x32, 0x17, 0x16, 0x15, 0x14, 0x07, 0x06, 0x07, 0x16, 0x17, 0x16, 0x15, 
    0x14, 0x07, 0x06, 0x23, 0x22, 0x99, 0x07, 0x1A, 0x0B, 0x6D, 0x27, 0x41, 
    0x35, 0x97, 0x4B, 0x42, 0x65, 0x64, 0xBA, 0x4E, 0x44, 0xAC, 0x5D, 0x61, 
    0xEF, 0x7B, 0xB9, 0xB5, 0x8B, 0xF1, 0x69, 0x4E, 0x70, 0x42, 0x82, 0x72, 
    0x3A, 0xB9, 0x85, 0x85, 0xD9, 0x75, 0x0B, 0xB8, 0x03, 0x0B, 0x03, 0x28, 
    0x0A, 0x11, 0x54, 0x48, 0x85, 0x9B, 0x52, 0x52, 0x85, 0x01, 0x03, 0x4C, 
    0x4E, 0x89, 0xDE, 0x53, 0xAC, 0x3B, 0x73, 0x55, 0x8D, 0x9F, 0x67, 0x3D, 
    0x33, 0x1E, 0x22, 0x6B, 0xDF, 0xCA, 0x79, 0x7A, 0x00, 0x02, 0x00, 0x1F, 
    0x00, 0x00, 0x04, 0x2F, 0x05, 0xC8, 0x00, 0x0A, 0x00, 0x0D, 0x00, 0x5B, 
    0x40, 0x45, 0x0D, 0x04, 0x06, 0x02, 0x03, 0x06, 0x01, 0x02, 0x00, 0x00, 
    0x0C, 0x0B, 0x07, 0x06, 0x0F, 0x03, 0x01, 0x01, 0x04, 0x30, 0xC4, 0x09, 
    0x08, 0x02, 0x01, 0x03, 0x0A, 0x00, 0x01, 0x02, 0x00, 0x05, 0x04, 0x00, 
    0x0E, 0x0B, 0x00, 0x02, 0x02, 0x00, 0x00, 0x04, 0x01, 0x00, 0x18, 0x02, 
    0x05, 0x0D, 0x0C, 0x0D, 0x01, 0x05, 0x02, 0x04, 0x30, 0xC4, 0x08, 0x07, 
    0x01, 0x0A, 0x09, 0x06, 0x05, 0x03, 0x03, 0x02, 0x01, 0x03, 0x00, 0x2A, 
    0x1F, 0x1E, 0x2A, 0x1F, 0x1E, 0x2B, 0x2B, 0x3F, 0x3C, 0x2A, 0x1F, 0x1E, 
    0x2A, 0x1F, 0x1E, 0x2B, 0x2B, 0x31, 0x30, 0x21, 0x11, 0x21, 0x35, 0x01, 
    0x33, 0x11, 0x33, 0x15, 0x23, 0x11, 0x01, 0x21, 0x11, 0x02, 0xB0, 0xFD, 
    0x6F, 0x02, 0x91, 0xB9, 0xC6, 0xC6, 0xFD, 0x77, 0x01, 0xDD, 0x01, 0xA3, 
    0x95, 0x03, 0x90, 0xFC, 0x7C, 0xA1, 0xFE, 0x5D, 0x02, 0x44, 0x02, 0x92, 
    0x00, 0x01, 0x00, 0xA3, 0xFF, 0xDB, 0x03, 0xC6, 0x05, 0xC8, 0x00, 0x19, 
    0x00, 0x6F, 0x40, 0x46, 0x00, 0x00, 0x03, 0x28, 0x18, 0x30, 0xC4, 0x18, 
    0x02, 0x09, 0x01, 0x10, 0x0B, 0x09, 0x01, 0x04, 0x0E, 0x02, 0x03, 0x00, 
    0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x0F, 0x0E, 0x0D, 0x01, 0x0C, 0x01, 
    0x04, 0x30, 0xC4, 0x0D, 0x0C, 0x00, 0x0E, 0x00, 0x00, 0x07, 0x09, 0x14, 
    0x30, 0xC4, 0x14, 0x0D, 0x00, 0x00, 0x10, 0x0F, 0x0D, 0x01, 0x0B, 0x01, 
    0x04, 0x30, 0xC4, 0x0E, 0x0D, 0x01, 0x0C, 0x0B, 0x01, 0x01, 0x00, 0x01, 
    0x03, 0x00, 0x2A, 0x1F, 0x1E, 0x2A, 0x1F, 0x1E, 0x10, 0xC4, 0x1F, 0x1E, 
    0x10, 0xED, 0x1F, 0x1E, 0x2B, 0x3F, 0x3C, 0x1F, 0x1E, 0x2A, 0x1F, 0x1E, 
    0x13, 0x10, 0xC0, 0x13, 0x13, 0x2B, 0x13, 0x2F, 0x3F, 0x1F, 0x1E, 0x10, 
    0xED, 0x1F, 0x1E, 0x31, 0x30, 0x17, 0x35, 0x16, 0x33, 0x32, 0x37, 0x36, 
    0x35, 0x10, 0x21, 0x22, 0x07, 0x11, 0x21, 0x15, 0x21, 0x11, 0x04, 0x17, 
    0x16, 0x15, 0x14, 0x07, 0x06, 0x23, 0x22, 0xA3, 0x98, 0x7F, 0x93, 0x53, 
    0x54, 0xFE, 0x38, 0x37, 0x39, 0x02, 0xEC, 0xFD, 0xC1, 0x01, 0x08, 0x96, 
    0xBF, 0x91, 0x92, 0xFF, 0x6E, 0x06, 0xB0, 0x3B, 0x56, 0x57, 0x93, 0x01, 
    0x50, 0x07, 0x02, 0xD0, 0xAC, 0xFE, 0x7A, 0x04, 0x67, 0x84, 0xFF, 0xD8, 
    0x7A, 0x7B, 0x00, 0x00, 0x00, 0x02, 0x00, 0x54, 0xFF, 0xDB, 0x04, 0x03, 
    0x05, 0xEE, 0x00, 0x1C, 0x00, 0x28, 0x00, 0x57, 0x40, 0x32, 0x00, 0x00, 
    0x25, 0x28, 0x0A, 0x1D, 0x28, 0x02, 0x17, 0x28, 0x12, 0x30, 0xC4, 0x12, 
    0x00, 0x0A, 0x02, 0x02, 0x01, 0x01, 0x15, 0x14, 0x02, 0x00, 0x04, 0x00, 
    0x02, 0x03, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x27, 0x29, 0x06, 0x21, 0x1A, 
    0x0E, 0x30, 0xC4, 0x06, 0x14, 0x00, 0x0E, 0x14, 0x15, 0x14, 0x01, 0x00, 
    0x2B, 0x10, 0xC4, 0xC0, 0x10, 0xC4, 0x1F, 0x1E, 0x10, 0xED, 0x10, 0xED, 
    0x1F, 0x1E, 0x2B, 0x13, 0x14, 0x2B, 0x13, 0x14, 0x2F, 0x3F, 0x3F, 0x1F, 
    0x1E, 0x10, 0xED, 0x10, 0xED, 0x10, 0xED, 0x1F, 0x1E, 0x31, 0x30, 0x01, 
    0x36, 0x33, 0x32, 0x17, 0x16, 0x15, 0x14, 0x07, 0x06, 0x23, 0x22, 0x27, 
    0x26, 0x11, 0x10, 0x37, 0x36, 0x21, 0x32, 0x17, 0x15, 0x26, 0x23, 0x22, 
    0x07, 0x06, 0x07, 0x06, 0x05, 0x22, 0x07, 0x06, 0x15, 0x14, 0x17, 0x16, 
    0x33, 0x32, 0x11, 0x10, 0x01, 0x2A, 0x8A, 0xC7, 0xB6, 0x69, 0x69, 0x7C, 
    0x7C, 0xD0, 0xE3, 0x82, 0x82, 0x9B, 0x9B, 0x01, 0x12, 0x7E, 0x99, 0xB5, 
    0x66, 0xDD, 0x59, 0x23, 0x0C, 0x07, 0x01, 0x1A, 0x7C, 0x4C, 0x4D, 0x4F, 
    0x4F, 0x7E, 0xF4, 0x03, 0x0A, 0xAC, 0x7C, 0x7B, 0xD9, 0xF1, 0x8D, 0x8D, 
    0xC3, 0xC2, 0x01, 0x55, 0x01, 0x83, 0xDB, 0xDB, 0x38, 0xAC, 0x50, 0xDE, 
    0x58, 0x6D, 0x3A, 0x55, 0x56, 0x56, 0x93, 0xA4, 0x6B, 0x6B, 0x01, 0x4E, 
    0x01, 0x6B, 0x00, 0x00, 0x00, 0x01, 0x00, 0x88, 0x00, 0x00, 0x04, 0x3E, 
    0x05, 0xC8, 0x00, 0x0B, 0x00, 0x32, 0x40, 0x23, 0x00, 0x00, 0x09, 0x06, 
    0x05, 0x1B, 0x02, 0x07, 0x01, 0x04, 0x30, 0xC4, 0x0B, 0x00, 0x01, 0x00, 
    0x08, 0x07, 0x00, 0x0E, 0x0B, 0x05, 0x00, 0x03, 0x08, 0x06, 0x03, 0x09, 
    0x08, 0x01, 0x07, 0x06, 0x01, 0x02, 0x00, 0x2A, 0x2B, 0x2B, 0x3F, 0x3C, 
    0x2B, 0x1F, 0x1E, 0x2A, 0x1F, 0x1E, 0x31, 0x30, 0x33, 0x36, 0x37, 0x36, 
    0x37, 0x01, 0x21, 0x35, 0x21, 0x15, 0x00, 0x03, 0xDE, 0x1D, 0x35, 0x35, 
    0x89, 0x01, 0x94, 0xFD, 0x06, 0x03, 0xB6, 0xFD, 0xC7, 0x44, 0xAD, 0x7E, 
    0x7D, 0xDD, 0x02, 0x8A, 0xB9, 0xB9, 0xFC, 0xB9, 0xFE, 0x38, 0x00, 0x00, 
    0x00, 0x03, 0x00, 0x63, 0xFF, 0xDB, 0x04, 0x41, 0x05, 0xED, 0x00, 0x1F, 
    0x00, 0x2D, 0x00, 0x3E, 0x00, 0x5B, 0x40, 0x33, 0x00, 0x00, 0x36, 0x28, 
    0x18, 0x26, 0x28, 0x08, 0x30, 0xC4, 0x18, 0x02, 0x08, 0x00, 0x01, 0x01, 
    0x2E, 0x20, 0x10, 0x00, 0x04, 0x00, 0x02, 0x03, 0x00, 0x00, 0x0E, 0x00, 
    0x00, 0x3A, 0x2B, 0x14, 0x32, 0x29, 0x1C, 0x2A, 0x0E, 0x04, 0x22, 0x0E, 
    0x0C, 0x30, 0xC4, 0x2E, 0x20, 0x1C, 0x14, 0x10, 0x0C, 0x04, 0x00, 0x2E, 
    0x2F, 0x2F, 0x2E, 0x2F, 0x2F, 0x2E, 0x2E, 0x1F, 0x1E, 0x10, 0xED, 0x10, 
    0xED, 0x10, 0xED, 0x10, 0xED, 0x1F, 0x1E, 0x2B, 0x13, 0x14, 0x2B, 0x13, 
    0x14, 0x3F, 0x3F, 0x1F, 0x1E, 0x10, 0xED, 0x10, 0xED, 0x1F, 0x1E, 0x31, 
    0x30, 0x01, 0x26, 0x27, 0x26, 0x35, 0x34, 0x37, 0x36, 0x33, 0x32, 0x17, 
    0x16, 0x15, 0x14, 0x07, 0x06, 0x07, 0x16, 0x17, 0x16, 0x15, 0x14, 0x07, 
    0x06, 0x23, 0x22, 0x27, 0x26, 0x35, 0x34, 0x37, 0x36, 0x25, 0x36, 0x35, 
    0x34, 0x27, 0x26, 0x23, 0x22, 0x07, 0x06, 0x15, 0x14, 0x17, 0x16, 0x07, 
    0x06, 0x07, 0x06, 0x15, 0x14, 0x17, 0x16, 0x33, 0x32, 0x37, 0x36, 0x35, 
    0x34, 0x27, 0x26, 0x27, 0x01, 0x89, 0x62, 0x31, 0x46, 0x7B, 0x7B, 0xC6, 
    0xB8, 0x71, 0x71, 0x64, 0x3D, 0x73, 0x96, 0x4D, 0x6C, 0x8D, 0x8C, 0xDF, 
    0xDB, 0x85, 0x86, 0x6C, 0x40, 0x01, 0x75, 0xCF, 0x44, 0x44, 0x74, 0x6E, 
    0x43, 0x43, 0x71, 0x3A, 0x1A, 0x6E, 0x2C, 0x32, 0x52, 0x52, 0x87, 0x80, 
    0x51, 0x52, 0x3F, 0x35, 0x82, 0x03, 0x26, 0x47, 0x41, 0x5E, 0x6D, 0xA3, 
    0x68, 0x69, 0x59, 0x58, 0x90, 0x81, 0x73, 0x45, 0x4D, 0x4D, 0x52, 0x74, 
    0x97, 0xB7, 0x75, 0x75, 0x6F, 0x6F, 0xB7, 0xA0, 0x7E, 0x4C, 0x8A, 0x8E, 
    0x9A, 0x5E, 0x37, 0x38, 0x35, 0x34, 0x58, 0x69, 0x59, 0x2E, 0xD2, 0x56, 
    0x3F, 0x48, 0x6C, 0x81, 0x4E, 0x4F, 0x43, 0x43, 0x6B, 0x5F, 0x41, 0x36, 
    0x4D, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x54, 0xFF, 0xDA, 0x04, 0x03, 
    0x05, 0xEE, 0x00, 0x1C, 0x00, 0x28, 0x00, 0x57, 0x40, 0x32, 0x00, 0x00, 
    0x21, 0x28, 0x02, 0x1D, 0x28, 0x0A, 0x17, 0x28, 0x12, 0x30, 0xC4, 0x12, 
    0x02, 0x0A, 0x00, 0x02, 0x01, 0x01, 0x15, 0x14, 0x02, 0x00, 0x04, 0x00, 
    0x02, 0x03, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x25, 0x1A, 0x0E, 0x1F, 0x29, 
    0x06, 0x30, 0xC4, 0x00, 0x0E, 0x14, 0x06, 0x14, 0x15, 0x14, 0x01, 0x00, 
    0x2B, 0x10, 0xC4, 0x10, 0xC4, 0xC0, 0x1F, 0x1E, 0x10, 0xED, 0x10, 0xED, 
    0x1F, 0x1E, 0x2B, 0x13, 0x14, 0x2B, 0x13, 0x14, 0x2F, 0x3F, 0x3F, 0x1F, 
    0x1E, 0x10, 0xED, 0x10, 0xED, 0x10, 0xED, 0x1F, 0x1E, 0x31, 0x30, 0x01, 
    0x06, 0x23, 0x22, 0x27, 0x26, 0x35, 0x34, 0x37, 0x36, 0x33, 0x32, 0x17, 
    0x16, 0x11, 0x10, 0x07, 0x06, 0x21, 0x22, 0x27, 0x35, 0x16, 0x33, 0x32, 
    0x37, 0x36, 0x37, 0x36, 0x01, 0x22, 0x11, 0x10, 0x33, 0x32, 0x37, 0x36, 
    0x35, 0x34, 0x27, 0x26, 0x03, 0x2D, 0x8A, 0xC7, 0xB6, 0x69, 0x69, 0x7C, 
    0x7B, 0xD0, 0xE4, 0x82, 0x82, 0x9B, 0x9B, 0xFE, 0xEE, 0x80, 0x98, 0xB7, 
    0x65, 0xDD, 0x59, 0x23, 0x0C, 0x07, 0xFE, 0xDF, 0xF4, 0xFB, 0x7C, 0x4C, 
    0x4D, 0x4F, 0x50, 0x02, 0xBE, 0xAC, 0x7C, 0x7C, 0xD9, 0xF0, 0x8D, 0x8E, 
    0xC3, 0xC3, 0xFE, 0xAC, 0xFE, 0x7C, 0xDB, 0xDB, 0x38, 0xAC, 0x4F, 0xDE, 
    0x57, 0x6D, 0x3A, 0x03, 0x0E, 0xFE, 0xB3, 0xFE, 0x94, 0x56, 0x57, 0x93, 
    0xA3, 0x6B, 0x6B, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x3F, 
    0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 
    0x00, 0x0F, 0x00, 0x00, 0x08, 0x00, 0x00, 0xB7, 0x00, 0x02, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x26, 0x00, 0x76, 0x00, 0xAE, 0x01, 0x08, 0x01, 0x80, 
    0x01, 0xCA, 0x02, 0x2C, 0x02, 0x98, 0x02, 0xCC, 0x03, 0x58, 0x03, 0xC4, 
    0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x33, 0x33, 0xC9, 0x02, 0xF4, 0xF2, 
    0x5F, 0x0F, 0x3C, 0xF5, 0x00, 0x0F, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xB7, 0xEC, 0xA9, 0x54, 0x00, 0x00, 0x00, 0x00, 0xBA, 0x1D, 0x17, 0x0A, 
    0x00, 0x1F, 0xFF, 0xDA, 0x04, 0x41, 0x05, 0xEE, 0x00, 0x00, 0x00, 0x0C, 
    0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x39, 0x00, 0x39, 
    0x04, 0x73, 0x00, 0x50, 0x00, 0xE6, 0x00, 0x66, 0x00, 0x99, 0x00, 0x1F, 
    0x00, 0xA3, 0x00, 0x54, 0x00, 0x88, 0x00, 0x63, 0x00, 0x54, 0x00, 0x00, 
    0x00, 0x01, 0x00, 0x00, 0x07, 0xF1, 0xFE, 0x50, 0x00, 0x00, 0x04, 0x73, 
    0x00, 0x1F, 0x00, 0x32, 0x04, 0x41, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x0A, 0x00, 0x01, 0x00, 0x2A, 
    0x00, 0xC0, 0x00, 0x05, 0x00, 0x3C, 0x00, 0x01, 0x00, 0x02, 0xFF, 0x91, 
    0x00, 0x01, 0x00, 0x05, 0x00, 0x1E, 0x00, 0x01, 0x00, 0x08, 0xFF, 0xB7, 
    0x00, 0x02, 0x00, 0x01, 0xFF, 0xAF, 0x00, 0x02, 0x00, 0x02, 0xFF, 0xAD, 
    0x00, 0x02, 0x00, 0x03, 0xFF, 0xED, 0x00, 0x02, 0x00, 0x04, 0xFF, 0xD4, 
    0x00, 0x02, 0x00, 0x05, 0xFF, 0x91, 0x00, 0x02, 0x00, 0x06, 0xFF, 0xCF, 
    0x00, 0x02, 0x00, 0x07, 0xFF, 0xB4, 0x00, 0x02, 0x00, 0x08, 0xFF, 0xB0, 
    0x00, 0x02, 0x00, 0x09, 0xFF, 0xCE, 0x00, 0x02, 0x00, 0x0A, 0xFF, 0xCE, 
    0x00, 0x03, 0x00, 0x02, 0xFF, 0x82, 0x00, 0x03, 0x00, 0x05, 0xFF, 0x6F, 
    0x00, 0x03, 0x00, 0x08, 0xFF, 0xA5, 0x00, 0x04, 0x00, 0x02, 0xFF, 0x77, 
    0x00, 0x04, 0x00, 0x05, 0xFF, 0xF5, 0x00, 0x04, 0x00, 0x08, 0xFF, 0xA2, 
    0x00, 0x05, 0x00, 0x02, 0xFF, 0x63, 0x00, 0x05, 0x00, 0x05, 0x00, 0x29, 
    0x00, 0x05, 0x00, 0x08, 0xFF, 0x92, 0x00, 0x06, 0x00, 0x02, 0xFF, 0x83, 
    0x00, 0x06, 0x00, 0x05, 0xFF, 0xF5, 0x00, 0x06, 0x00, 0x08, 0xFF, 0xB1, 
    0x00, 0x07, 0x00, 0x02, 0xFF, 0x88, 0x00, 0x07, 0x00, 0x05, 0x00, 0x12, 
    0x00, 0x07, 0x00, 0x08, 0xFF, 0xB7, 0x00, 0x08, 0x00, 0x02, 0xFF, 0xCE, 
    0x00, 0x08, 0x00, 0x03, 0xFF, 0xFB, 0x00, 0x08, 0x00, 0x04, 0xFF, 0xEA, 
    0x00, 0x08, 0x00, 0x05, 0xFF, 0x5C, 0x00, 0x08, 0x00, 0x06, 0xFF, 0xE3, 
    0x00, 0x08, 0x00, 0x07, 0xFF, 0xD2, 0x00, 0x08, 0x00, 0x08, 0xFF, 0xFD, 
    0x00, 0x08, 0x00, 0x09, 0xFF, 0xDE, 0x00, 0x09, 0x00, 0x02, 0xFF, 0xB0, 
    0x00, 0x09, 0x00, 0x05, 0x00, 0x30, 0x00, 0x09, 0x00, 0x08, 0xFF, 0xDC, 
    0x00, 0x0A, 0x00, 0x02, 0xFF, 0x87, 0x00, 0x0A, 0x00, 0x05, 0x00, 0x0C, 
    0x00, 0x0A, 0x00, 0x08, 0xFF, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 
    0x01, 0x26, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x09, 
    0x00, 0x55, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x07, 
    0x00, 0x5E, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x16, 
    0x00, 0x65, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x11, 
    0x00, 0x7B, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x16, 
    0x00, 0x8C, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x08, 
    0x00, 0xA2, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x37, 
    0x00, 0xAA, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x15, 
    0x00, 0xE1, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x1F, 
    0x00, 0xF6, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x13, 
    0x01, 0x15, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x1B, 
    0x01, 0x28, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x00, 0x00, 0xAA, 
    0x01, 0x43, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x01, 0x00, 0x12, 
    0x01, 0xED, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x02, 0x00, 0x0E, 
    0x01, 0xFF, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x03, 0x00, 0x2C, 
    0x02, 0x0D, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x04, 0x00, 0x22, 
    0x02, 0x39, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x05, 0x00, 0x2C, 
    0x02, 0x5B, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x06, 0x00, 0x10, 
    0x02, 0x87, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x07, 0x00, 0x6E, 
    0x02, 0x97, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x08, 0x00, 0x2A, 
    0x03, 0x05, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x09, 0x00, 0x3E, 
    0x03, 0x2F, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x0B, 0x00, 0x26, 
    0x03, 0x6D, 0x00, 0x03, 0x00, 0x01, 0x04, 0x09, 0x00, 0x0C, 0x00, 0x36, 
    0x03, 0x93, 0x43, 0x6F, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x20, 
    0x28, 0x63, 0x29, 0x20, 0x32, 0x30, 0x30, 0x31, 0x20, 0x62, 0x79, 0x20, 
    0x42, 0x69, 0x67, 0x65, 0x6C, 0x6F, 0x77, 0x20, 0x26, 0x20, 0x48, 0x6F, 
    0x6C, 0x6D, 0x65, 0x73, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x20, 0x49, 0x6E, 
    0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6F, 0x6E, 0x73, 0x20, 0x63, 
    0x6F, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x20, 0x28, 0x63, 0x29, 
    0x20, 0x32, 0x30, 0x30, 0x31, 0x20, 0x62, 0x79, 0x20, 0x55, 0x52, 0x57, 
    0x2B, 0x2B, 0x2E, 0x4C, 0x75, 0x78, 0x69, 0x20, 0x53, 0x61, 0x6E, 0x73, 
    0x52, 0x65, 0x67, 0x75, 0x6C, 0x61, 0x72, 0x4C, 0x75, 0x78, 0x69, 0x20, 
    0x53, 0x61, 0x6E, 0x73, 0x20, 0x52, 0x65, 0x67, 0x75, 0x6C, 0x61, 0x72, 
    0x3A, 0x20, 0x42, 0x26, 0x48, 0x4C, 0x75, 0x78, 0x69, 0x20, 0x53, 0x61, 
    0x6E, 0x73, 0x20, 0x52, 0x65, 0x67, 0x75, 0x6C, 0x61, 0x72, 0x31, 0x2E, 
    0x32, 0x20, 0x3A, 0x20, 0x4F, 0x63, 0x74, 0x6F, 0x62, 0x65, 0x72, 0x20, 
    0x31, 0x32, 0x2C, 0x20, 0x32, 0x30, 0x30, 0x31, 0x4C, 0x75, 0x78, 0x69, 
    0x53, 0x61, 0x6E, 0x73, 0x4C, 0x75, 0x78, 0x69, 0x20, 0x69, 0x73, 0x20, 
    0x61, 0x20, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x65, 0x64, 
    0x20, 0x74, 0x72, 0x61, 0x64, 0x65, 0x6D, 0x61, 0x72, 0x6B, 0x20, 0x6F, 
    0x66, 0x20, 0x42, 0x69, 0x67, 0x65, 0x6C, 0x6F, 0x77, 0x20, 0x26, 0x20, 
    0x48, 0x6F, 0x6C, 0x6D, 0x65, 0x73, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x42, 
    0x69, 0x67, 0x65, 0x6C, 0x6F, 0x77, 0x20, 0x26, 0x20, 0x48, 0x6F, 0x6C, 
    0x6D, 0x65, 0x73, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x4B, 0x72, 0x69, 0x73, 
    0x20, 0x48, 0x6F, 0x6C, 0x6D, 0x65, 0x73, 0x20, 0x61, 0x6E, 0x64, 0x20, 
    0x43, 0x68, 0x61, 0x72, 0x6C, 0x65, 0x73, 0x20, 0x42, 0x69, 0x67, 0x65, 
    0x6C, 0x6F, 0x77, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x77, 0x77, 
    0x77, 0x2E, 0x75, 0x72, 0x77, 0x70, 0x70, 0x2E, 0x64, 0x65, 0x64, 0x65, 
    0x73, 0x69, 0x67, 0x6E, 0x40, 0x62, 0x69, 0x67, 0x65, 0x6C, 0x6F, 0x77, 
    0x61, 0x6E, 0x64, 0x68, 0x6F, 0x6C, 0x6D, 0x65, 0x73, 0x2E, 0x63, 0x6F, 
    0x6D, 0x00, 0x43, 0x00, 0x6F, 0x00, 0x70, 0x00, 0x79, 0x00, 0x72, 0x00, 
    0x69, 0x00, 0x67, 0x00, 0x68, 0x00, 0x74, 0x00, 0x20, 0x00, 0x28, 0x00, 
    0x63, 0x00, 0x29, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 
    0x31, 0x00, 0x20, 0x00, 0x62, 0x00, 0x79, 0x00, 0x20, 0x00, 0x42, 0x00, 
    0x69, 0x00, 0x67, 0x00, 0x65, 0x00, 0x6C, 0x00, 0x6F, 0x00, 0x77, 0x00, 
    0x20, 0x00, 0x26, 0x00, 0x20, 0x00, 0x48, 0x00, 0x6F, 0x00, 0x6C, 0x00, 
    0x6D, 0x00, 0x65, 0x00, 0x73, 0x00, 0x20, 0x00, 0x49, 0x00, 0x6E, 0x00, 
    0x63, 0x00, 0x2E, 0x00, 0x20, 0x00, 0x49, 0x00, 0x6E, 0x00, 0x73, 0x00, 
    0x74, 0x00, 0x72, 0x00, 0x75, 0x00, 0x63, 0x00, 0x74, 0x00, 0x69, 0x00, 
    0x6F, 0x00, 0x6E, 0x00, 0x73, 0x00, 0x20, 0x00, 0x63, 0x00, 0x6F, 0x00, 
    0x70, 0x00, 0x79, 0x00, 0x72, 0x00, 0x69, 0x00, 0x67, 0x00, 0x68, 0x00, 
    0x74, 0x00, 0x20, 0x00, 0x28, 0x00, 0x63, 0x00, 0x29, 0x00, 0x20, 0x00, 
    0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x31, 0x00, 0x20, 0x00, 0x62, 0x00, 
    0x79, 0x00, 0x20, 0x00, 0x55, 0x00, 0x52, 0x00, 0x57, 0x00, 0x2B, 0x00, 
    0x2B, 0x00, 0x2E, 0x00, 0x4C, 0x00, 0x75, 0x00, 0x78, 0x00, 0x69, 0x00, 
    0x20, 0x00, 0x53, 0x00, 0x61, 0x00, 0x6E, 0x00, 0x73, 0x00, 0x52, 0x00, 
    0x65, 0x00, 0x67, 0x00, 0x75, 0x00, 0x6C, 0x00, 0x61, 0x00, 0x72, 0x00, 
    0x4C, 0x00, 0x75, 0x00, 0x78, 0x00, 0x69, 0x00, 0x20, 0x00, 0x53, 0x00, 
    0x61, 0x00, 0x6E, 0x00, 0x73, 0x00, 0x20, 0x00, 0x52, 0x00, 0x65, 0x00, 
    0x67, 0x00, 0x75, 0x00, 0x6C, 0x00, 0x61, 0x00, 0x72, 0x00, 0x3A, 0x00, 
    0x20, 0x00, 0x42, 0x00, 0x26, 0x00, 0x48, 0x00, 0x4C, 0x00, 0x75, 0x00, 
    0x78, 0x00, 0x69, 0x00, 0x20, 0x00, 0x53, 0x00, 0x61, 0x00, 0x6E, 0x00, 
    0x73, 0x00, 0x20, 0x00, 0x52, 0x00, 0x65, 0x00, 0x67, 0x00, 0x75, 0x00, 
    0x6C, 0x00, 0x61, 0x00, 0x72, 0x00, 0x31, 0x00, 0x2E, 0x00, 0x32, 0x00, 
    0x20, 0x00, 0x3A, 0x00, 0x20, 0x00, 0x4F, 0x00, 0x63, 0x00, 0x74, 0x00, 
    0x6F, 0x00, 0x62, 0x00, 0x65, 0x00, 0x72, 0x00, 0x20, 0x00, 0x31, 0x00, 
    0x32, 0x00, 0x2C, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 
    0x31, 0x00, 0x4C, 0x00, 0x75, 0x00, 0x78, 0x00, 0x69, 0x00, 0x53, 0x00, 
    0x61, 0x00, 0x6E, 0x00, 0x73, 0x00, 0x4C, 0x00, 0x75, 0x00, 0x78, 0x00, 
    0x69, 0x00, 0x20, 0x00, 0x69, 0x00, 0x73, 0x00, 0x20, 0x00, 0x61, 0x00, 
    0x20, 0x00, 0x72, 0x00, 0x65, 0x00, 0x67, 0x00, 0x69, 0x00, 0x73, 0x00, 
    0x74, 0x00, 0x65, 0x00, 0x72, 0x00, 0x65, 0x00, 0x64, 0x00, 0x20, 0x00, 
    0x74, 0x00, 0x72, 0x00, 0x61, 0x00, 0x64, 0x00, 0x65, 0x00, 0x6D, 0x00, 
    0x61, 0x00, 0x72, 0x00, 0x6B, 0x00, 0x20, 0x00, 0x6F, 0x00, 0x66, 0x00, 
    0x20, 0x00, 0x42, 0x00, 0x69, 0x00, 0x67, 0x00, 0x65, 0x00, 0x6C, 0x00, 
    0x6F, 0x00, 0x77, 0x00, 0x20, 0x00, 0x26, 0x00, 0x20, 0x00, 0x48, 0x00, 
    0x6F, 0x00, 0x6C, 0x00, 0x6D, 0x00, 0x65, 0x00, 0x73, 0x00, 0x20, 0x00, 
    0x49, 0x00, 0x6E, 0x00, 0x63, 0x00, 0x2E, 0x00, 0x42, 0x00, 0x69, 0x00, 
    0x67, 0x00, 0x65, 0x00, 0x6C, 0x00, 0x6F, 0x00, 0x77, 0x00, 0x20, 0x00, 
    0x26, 0x00, 0x20, 0x00, 0x48, 0x00, 0x6F, 0x00, 0x6C, 0x00, 0x6D, 0x00, 
    0x65, 0x00, 0x73, 0x00, 0x20, 0x00, 0x49, 0x00, 0x6E, 0x00, 0x63, 0x00, 
    0x2E, 0x00, 0x4B, 0x00, 0x72, 0x00, 0x69, 0x00, 0x73, 0x00, 0x20, 0x00, 
    0x48, 0x00, 0x6F, 0x00, 0x6C, 0x00, 0x6D, 0x00, 0x65, 0x00, 0x73, 0x00, 
    0x20, 0x00, 0x61, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x20, 0x00, 0x43, 0x00, 
    0x68, 0x00, 0x61, 0x00, 0x72, 0x00, 0x6C, 0x00, 0x65, 0x00, 0x73, 0x00, 
    0x20, 0x00, 0x42, 0x00, 0x69, 0x00, 0x67, 0x00, 0x65, 0x00, 0x6C, 0x00, 
    0x6F, 0x00, 0x77, 0x00, 0x68, 0x00, 0x74, 0x00, 0x74, 0x00, 0x70, 0x00, 
    0x3A, 0x00, 0x2F, 0x00, 0x2F, 0x00, 0x77, 0x00, 0x77, 0x00, 0x77, 0x00, 
    0x2E, 0x00, 0x75, 0x00, 0x72, 0x00, 0x77, 0x00, 0x70, 0x00, 0x70, 0x00, 
    0x2E, 0x00, 0x64, 0x00, 0x65, 0x00, 0x64, 0x00, 0x65, 0x00, 0x73, 0x00, 
    0x69, 0x00, 0x67, 0x00, 0x6E, 0x00, 0x40, 0x00, 0x62, 0x00, 0x69, 0x00, 
    0x67, 0x00, 0x65, 0x00, 0x6C, 0x00, 0x6F, 0x00, 0x77, 0x00, 0x61, 0x00, 
    0x6E, 0x00, 0x64, 0x00, 0x68, 0x00, 0x6F, 0x00, 0x6C, 0x00, 0x6D, 0x00, 
    0x65, 0x00, 0x73, 0x00, 0x2E, 0x00, 0x63, 0x00, 0x6F, 0x00, 0x6D, 0x00, 
    0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 
    0x00, 0x13, 0x00, 0x14, 0x00, 0x15, 0x00, 0x16, 0x00, 0x17, 0x00, 0x18, 
    0x00, 0x19, 0x00, 0x1A, 0x00, 0x1B, 0x00, 0x1C, 0xB1, 0x30, 0x01, 0xB8, 
    0x01, 0x49, 0x18, 0x85, 0x8D, 0x1D, 0x00, 0x00, 0x09, 0xA1, 0x02, 0x29, 
    0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x29, 0x02, 0x29, 
    0x02, 0x03, 0x02, 0x29, 0x02, 0x04, 0x02, 0x03, 0x00, 0x01, 0x00, 0x00, 
    0x07, 0xF1, 0x01, 0xB0, 0x00, 0x00, 0x09, 0xA1, 0x02, 0x03, 0x01, 0x8A, 
    0x08, 0x17, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 };

unsigned int cbLuxiRB = sizeof( auchLuxiRB ),
    cbLuxiSB = sizeof( auchLuxiSB ),
    cbLuxiSR = sizeof( auchLuxiSR );
