// file      : xsd/cxx/tree/generator.cxx
// copyright : Copyright (c) 2005-2014 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <vector>
#include <algorithm>
#include <iostream>
#include <fstream>

#include <cutl/re.hxx>
#include <cutl/shared-ptr.hxx>

#include <cutl/compiler/code-stream.hxx>
#include <cutl/compiler/cxx-indenter.hxx>
#include <cutl/compiler/sloc-counter.hxx>

#include <xsd-frontend/semantic-graph.hxx>
#include <xsd-frontend/generators/dependencies.hxx>

#include <cxx/tree/generator.hxx>

#include <cxx/tree/elements.hxx>

#include <cxx/tree/counter.hxx>
#include <cxx/tree/validator.hxx>
#include <cxx/tree/name-processor.hxx>
#include <cxx/tree/order-processor.hxx>
#include <cxx/tree/polymorphism-processor.hxx>

#include <cxx/tree/tree-forward.hxx>
#include <cxx/tree/tree-header.hxx>
#include <cxx/tree/tree-inline.hxx>
#include <cxx/tree/tree-source.hxx>

#include <cxx/tree/parser-header.hxx>
#include <cxx/tree/parser-source.hxx>

#include <cxx/tree/stream-header.hxx>
#include <cxx/tree/stream-source.hxx>

#include <cxx/tree/serialization-header.hxx>
#include <cxx/tree/serialization-source.hxx>

#include <cxx/tree/stream-insertion-header.hxx>
#include <cxx/tree/stream-insertion-source.hxx>
#include <cxx/tree/stream-extraction-source.hxx>

#include <cxx/tree/options.hxx>

#include "../../../libxsd/xsd/cxx/version.hxx"

using namespace std;
using namespace cutl;
using namespace XSDFrontend::SemanticGraph;

//
//
typedef std::wifstream WideInputFileStream;
typedef std::wofstream WideOutputFileStream;

namespace CXX
{
  namespace
  {
    char const copyright_gpl[] =
    "// Copyright (c) 2005-2014 Code Synthesis Tools CC\n"
    "//\n"
    "// This program was generated by CodeSynthesis XSD, an XML Schema to\n"
    "// C++ data binding compiler.\n"
    "//\n"
    "// This program is free software; you can redistribute it and/or modify\n"
    "// it under the terms of the GNU General Public License version 2 as\n"
    "// published by the Free Software Foundation.\n"
    "//\n"
    "// This program is distributed in the hope that it will be useful,\n"
    "// but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
    "// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
    "// GNU General Public License for more details.\n"
    "//\n"
    "// You should have received a copy of the GNU General Public License\n"
    "// along with this program; if not, write to the Free Software\n"
    "// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
    "//\n"
    "// In addition, as a special exception, Code Synthesis Tools CC gives\n"
    "// permission to link this program with the Xerces-C++ library (or with\n"
    "// modified versions of Xerces-C++ that use the same license as Xerces-C++),\n"
    "// and distribute linked combinations including the two. You must obey\n"
    "// the GNU General Public License version 2 in all respects for all of\n"
    "// the code used other than Xerces-C++. If you modify this copy of the\n"
    "// program, you may extend this exception to your version of the program,\n"
    "// but you are not obligated to do so. If you do not wish to do so, delete\n"
    "// this exception statement from your version.\n"
    "//\n"
    "// Furthermore, Code Synthesis Tools CC makes a special exception for\n"
    "// the Free/Libre and Open Source Software (FLOSS) which is described\n"
    "// in the accompanying FLOSSE file.\n"
    "//\n\n";

    char const copyright_proprietary[] =
    "// Copyright (c) 2005-2014 Code Synthesis Tools CC\n"
    "//\n"
    "// This program was generated by CodeSynthesis XSD, an XML Schema\n"
    "// to C++ data binding compiler, in the Proprietary License mode.\n"
    "// You should have received a proprietary license from Code Synthesis\n"
    "// Tools CC prior to generating this code. See the license text for\n"
    "// conditions.\n"
    "//\n\n";
  }
