#!/usr/bin/perl -w

# $Id: 06unicode.t,v 1.1 2004/06/29 14:58:40 jv Exp $

use strict;
use warnings;
use Test::More tests => 7;

BEGIN { use_ok('Data::Hexify'); }

my $data = (chr(400).chr(401).chr(402)) x 80;
is(Hexify(\$data, { length => 48 }),
   <<'EOD', "length");
  0000: c6 90 c6 91 c6 92 c6 90 c6 91 c6 92 c6 90 c6 91  ................
  0010: c6 92 c6 90 c6 91 c6 92 c6 90 c6 91 c6 92 c6 90  ................
  0020: c6 91 c6 92 c6 90 c6 91 c6 92 c6 90 c6 91 c6 92  ................
EOD

is(Hexify(\$data, { start => 16, length => 48 }),
   <<'EOD', "start, length");
  0010: c6 92 c6 90 c6 91 c6 92 c6 90 c6 91 c6 92 c6 90  ................
  0020: c6 91 c6 92 c6 90 c6 91 c6 92 c6 90 c6 91 c6 92  ................
  0030: c6 90 c6 91 c6 92 c6 90 c6 91 c6 92 c6 90 c6 91  ................
EOD

is(Hexify(\$data, { start => 21, length => 48 }),
   <<'EOD', "start, length, lead");
  0010:                91 c6 92 c6 90 c6 91 c6 92 c6 90       ...........
  0020: c6 91 c6 92 c6 90 c6 91 c6 92 c6 90 c6 91 c6 92  ................
  0030: c6 90 c6 91 c6 92 c6 90 c6 91 c6 92 c6 90 c6 91  ................
  0040: c6 92 c6 90 c6                                   .....           
EOD

is(Hexify(\$data, { start => 16, first => 32, length => 48 }),
   <<'EOD', "start, length, first");
  0020: c6 92 c6 90 c6 91 c6 92 c6 90 c6 91 c6 92 c6 90  ................
  0030: c6 91 c6 92 c6 90 c6 91 c6 92 c6 90 c6 91 c6 92  ................
  0040: c6 90 c6 91 c6 92 c6 90 c6 91 c6 92 c6 90 c6 91  ................
EOD

is(Hexify(\$data, { start => 16, first => 40, length => 48 }),
   <<'EOD', "start, length, first, lead");
  0020:                         c6 92 c6 90 c6 91 c6 92          ........
  0030: c6 90 c6 91 c6 92 c6 90 c6 91 c6 92 c6 90 c6 91  ................
  0040: c6 92 c6 90 c6 91 c6 92 c6 90 c6 91 c6 92 c6 90  ................
  0050: c6 91 c6 92 c6 90 c6 91                          ........        
EOD

is(Hexify(\$data, { start => 3, length => 4 }),
   <<'EOD', "short");
  0000:          91 c6 92 c6                                ....         
EOD

