# Generated by default/object.tt
package Paws::Kendra::CapacityUnitsConfiguration;
  use Moose;
  has QueryCapacityUnits => (is => 'ro', isa => 'Int', required => 1);
  has StorageCapacityUnits => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::CapacityUnitsConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::CapacityUnitsConfiguration object:

  $service_obj->Method(Att1 => { QueryCapacityUnits => $value, ..., StorageCapacityUnits => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::CapacityUnitsConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->QueryCapacityUnits

=head1 DESCRIPTION

Specifies capacity units configured for your enterprise edition index.
You can add and remove capacity units to tune an index to your
requirements.

=head1 ATTRIBUTES


=head2 B<REQUIRED> QueryCapacityUnits => Int

The amount of extra query capacity for an index and GetQuerySuggestions
(https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html)
capacity.

A single extra capacity unit for an index provides 0.1 queries per
second or approximately 8,000 queries per day.

C<GetQuerySuggestions> capacity is five times the provisioned query
capacity for an index, or the base capacity of 2.5 calls per second,
whichever is higher. For example, the base capacity for an index is 0.1
queries per second, and C<GetQuerySuggestions> capacity has a base of
2.5 calls per second. If you add another 0.1 queries per second to
total 0.2 queries per second for an index, the C<GetQuerySuggestions>
capacity is 2.5 calls per second (higher than five times 0.2 queries
per second).


=head2 B<REQUIRED> StorageCapacityUnits => Int

The amount of extra storage capacity for an index. A single capacity
unit provides 30 GB of storage space or 100,000 documents, whichever is
reached first.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

