/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.ocsp;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x509.X509Extensions;

public class ResponseData
extends ASN1Encodable {
    private static final DERInteger V1 = new DERInteger(0);
    private boolean versionPresent;
    private DERInteger version;
    private ResponderID responderID;
    private DERGeneralizedTime producedAt;
    private ASN1Sequence responses;
    private X509Extensions responseExtensions;

    public ResponseData(DERInteger dERInteger, ResponderID responderID, DERGeneralizedTime dERGeneralizedTime, ASN1Sequence aSN1Sequence, X509Extensions x509Extensions) {
        this.version = dERInteger;
        this.responderID = responderID;
        this.producedAt = dERGeneralizedTime;
        this.responses = aSN1Sequence;
        this.responseExtensions = x509Extensions;
    }

    public ResponseData(ResponderID responderID, DERGeneralizedTime dERGeneralizedTime, ASN1Sequence aSN1Sequence, X509Extensions x509Extensions) {
        this(V1, responderID, dERGeneralizedTime, aSN1Sequence, x509Extensions);
    }

    public ResponseData(ASN1Sequence aSN1Sequence) {
        int n = 0;
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(0);
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.versionPresent = true;
                this.version = DERInteger.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(0), true);
            } else {
                this.version = V1;
            }
        } else {
            this.version = V1;
        }
        int n2 = ++n;
        this.responderID = ResponderID.getInstance(aSN1Sequence.getObjectAt(n2));
        int n3 = ++n;
        this.producedAt = (DERGeneralizedTime)aSN1Sequence.getObjectAt(n3);
        int n4 = ++n;
        this.responses = (ASN1Sequence)aSN1Sequence.getObjectAt(n4);
        if (aSN1Sequence.size() > ++n) {
            this.responseExtensions = X509Extensions.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n), true);
        }
    }

    public static ResponseData getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ResponseData.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static ResponseData getInstance(Object object) {
        if (object == null || object instanceof ResponseData) {
            return (ResponseData)object;
        }
        if (object instanceof ASN1Sequence) {
            return new ResponseData((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public ResponderID getResponderID() {
        return this.responderID;
    }

    public DERGeneralizedTime getProducedAt() {
        return this.producedAt;
    }

    public ASN1Sequence getResponses() {
        return this.responses;
    }

    public X509Extensions getResponseExtensions() {
        return this.responseExtensions;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.versionPresent || !this.version.equals(V1)) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.version));
        }
        aSN1EncodableVector.add(this.responderID);
        aSN1EncodableVector.add(this.producedAt);
        aSN1EncodableVector.add(this.responses);
        if (this.responseExtensions != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.responseExtensions));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

