/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.util.Format;
import ucar.unidata.util.Parameter;

public class AlbersEqualArea
extends ProjectionImpl {
    private double n;
    private double C;
    private double rho0;
    private double lat0;
    private double lon0;
    private double par1;
    private double par2;
    private double lon0Degrees;
    private LatLonPointImpl origin;
    private double falseEasting;
    private double falseNorthing;
    private double earth_radius;

    @Override
    public ProjectionImpl constructCopy() {
        return new AlbersEqualArea(this.getOriginLat(), this.getOriginLon(), this.getParallelOne(), this.getParallelTwo(), this.getFalseEasting(), this.getFalseNorthing(), this.getEarthRadius());
    }

    public AlbersEqualArea() {
        this(23.0, -96.0, 29.5, 45.5);
    }

    public AlbersEqualArea(double lat0, double lon0, double par1, double par2) {
        this(lat0, lon0, par1, par2, 0.0, 0.0, Earth.getRadius() * 0.001);
    }

    public AlbersEqualArea(double lat0, double lon0, double par1, double par2, double falseEasting, double falseNorthing) {
        this(lat0, lon0, par1, par2, falseEasting, falseNorthing, Earth.getRadius() * 0.001);
    }

    public AlbersEqualArea(double lat0, double lon0, double par1, double par2, double falseEasting, double falseNorthing, double earth_radius) {
        this.name = "AlbersEqualArea";
        this.lat0 = Math.toRadians(lat0);
        this.lon0Degrees = lon0;
        this.lon0 = Math.toRadians(lon0);
        this.par1 = par1;
        this.par2 = par2;
        this.falseEasting = falseEasting;
        this.falseNorthing = falseNorthing;
        this.earth_radius = earth_radius;
        this.origin = new LatLonPointImpl(lat0, lon0);
        this.precalculate();
        this.addParameter("grid_mapping_name", "albers_conical_equal_area");
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_central_meridian", lon0);
        if (par2 == par1) {
            this.addParameter("standard_parallel", par1);
        } else {
            double[] data = new double[]{par1, par2};
            this.addParameter(new Parameter("standard_parallel", data));
        }
        if (falseEasting != 0.0 || falseNorthing != 0.0) {
            this.addParameter("false_easting", falseEasting);
            this.addParameter("false_northing", falseNorthing);
            this.addParameter("units", "km");
        }
        this.addParameter("earth_radius", earth_radius);
    }

    private void precalculate() {
        double par1r = Math.toRadians(this.par1);
        double par2r = Math.toRadians(this.par2);
        this.n = Math.abs(this.par2 - this.par1) < 1.0E-6 ? Math.sin(par1r) : (Math.sin(par1r) + Math.sin(par2r)) / 2.0;
        double c2 = Math.pow(Math.cos(par1r), 2.0);
        this.C = c2 + 2.0 * this.n * Math.sin(par1r);
        this.rho0 = this.computeRho(this.lat0);
    }

    private double computeRho(double lat) {
        return this.earth_radius * Math.sqrt(this.C - 2.0 * this.n * Math.sin(lat)) / this.n;
    }

    private double computeTheta(double lon) {
        double dlon = LatLonPointImpl.lonNormal(Math.toDegrees(lon) - this.lon0Degrees);
        return this.n * Math.toRadians(dlon);
    }

    @Override
    public Object clone() {
        AlbersEqualArea cl = (AlbersEqualArea)super.clone();
        cl.origin = new LatLonPointImpl(this.getOriginLat(), this.getOriginLon());
        return cl;
    }

    @Override
    public boolean equals(Object proj) {
        if (!(proj instanceof AlbersEqualArea)) {
            return false;
        }
        AlbersEqualArea oo = (AlbersEqualArea)proj;
        return this.getParallelOne() == oo.getParallelOne() && this.getParallelTwo() == oo.getParallelTwo() && this.getOriginLat() == oo.getOriginLat() && this.getOriginLon() == oo.getOriginLon() && this.defaultMapArea.equals(oo.defaultMapArea);
    }

    public double getParallelTwo() {
        return this.par2;
    }

    public void setParallelTwo(double par) {
        this.par2 = par;
        this.precalculate();
    }

    public double getParallelOne() {
        return this.par1;
    }

    public void setParallelOne(double par) {
        this.par1 = par;
        this.precalculate();
    }

    public double getOriginLon() {
        return this.origin.getLongitude();
    }

    public void setOriginLon(double lon) {
        this.origin.setLongitude(lon);
        this.lon0 = Math.toRadians(lon);
        this.precalculate();
    }

    public double getOriginLat() {
        return this.origin.getLatitude();
    }

    public void setOriginLat(double lat) {
        this.origin.setLatitude(lat);
        this.lat0 = Math.toRadians(lat);
        this.precalculate();
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public void setFalseEasting(double falseEasting) {
        this.falseEasting = falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public void setFalseNorthing(double falseNorthing) {
        this.falseNorthing = falseNorthing;
    }

    public double getEarthRadius() {
        return this.earth_radius;
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Albers Equal Area";
    }

    @Override
    public String paramsToString() {
        return " origin " + this.origin.toString() + " parallels: " + Format.d(this.par1, 3) + " " + Format.d(this.par2, 3);
    }

    public double getScale(double lat) {
        lat = Math.toRadians(lat);
        double n = Math.cos(lat);
        double d = Math.sqrt(this.C - 2.0 * n * Math.sin(lat));
        return n / d;
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (ProjectionPointImpl.isInfinite(pt1) || ProjectionPointImpl.isInfinite(pt2)) {
            return true;
        }
        return pt1.getX() * pt2.getX() < 0.0 && Math.abs(pt1.getX() - pt2.getX()) > 5000.0;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        fromLat = Math.toRadians(fromLat);
        fromLon = Math.toRadians(fromLon);
        double rho = this.computeRho(fromLat);
        double theta = this.computeTheta(fromLon);
        double toX = rho * Math.sin(theta) + this.falseEasting;
        double toY = this.rho0 - rho * Math.cos(theta) + this.falseNorthing;
        result.setLocation(toX, toY);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double fromX = world.getX() - this.falseEasting;
        double fromY = world.getY() - this.falseNorthing;
        double rrho0 = this.rho0;
        if (this.n < 0.0) {
            rrho0 *= -1.0;
            fromX *= -1.0;
            fromY *= -1.0;
        }
        double yd = rrho0 - fromY;
        double rho = Math.sqrt(fromX * fromX + yd * yd);
        double theta = Math.atan2(fromX, yd);
        if (this.n < 0.0) {
            rho *= -1.0;
        }
        double toLat = Math.toDegrees(Math.asin((this.C - Math.pow(rho * this.n / this.earth_radius, 2.0)) / (2.0 * this.n)));
        double toLon = Math.toDegrees(theta / this.n + this.lon0);
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }

    @Override
    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        float[] fromLatA = from[latIndex];
        float[] fromLonA = from[lonIndex];
        float[] resultXA = to[0];
        float[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            fromLat = Math.toRadians(fromLat);
            fromLon = Math.toRadians(fromLon);
            double rho = this.computeRho(fromLat);
            double theta = this.computeTheta(fromLon);
            double toX = rho * Math.sin(theta);
            double toY = this.rho0 - rho * Math.cos(theta);
            resultXA[i] = (float)(toX + this.falseEasting);
            resultYA[i] = (float)(toY + this.falseNorthing);
        }
        return to;
    }

    @Override
    public float[][] projToLatLon(float[][] from, float[][] to) {
        int cnt = from[0].length;
        float[] fromXA = from[0];
        float[] fromYA = from[1];
        float[] toLatA = to[0];
        float[] toLonA = to[1];
        double rrho0 = this.rho0;
        for (int i = 0; i < cnt; ++i) {
            double fromX = (double)fromXA[i] - this.falseEasting;
            double fromY = (double)fromYA[i] - this.falseNorthing;
            if (this.n < 0.0) {
                rrho0 *= -1.0;
                fromX *= -1.0;
                fromY *= -1.0;
            }
            double yd = rrho0 - fromY;
            double rho = Math.sqrt(fromX * fromX + yd * yd);
            double theta = Math.atan2(fromX, yd);
            if (this.n < 0.0) {
                rho *= -1.0;
            }
            double toLat = Math.toDegrees(Math.asin((this.C - Math.pow(rho * this.n / this.earth_radius, 2.0)) / (2.0 * this.n)));
            double toLon = Math.toDegrees(theta / this.n + this.lon0);
            toLatA[i] = (float)toLat;
            toLonA[i] = (float)toLon;
        }
        return to;
    }

    @Override
    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        double[] fromLatA = from[latIndex];
        double[] fromLonA = from[lonIndex];
        double[] resultXA = to[0];
        double[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            fromLat = Math.toRadians(fromLat);
            fromLon = Math.toRadians(fromLon);
            double rho = this.computeRho(fromLat);
            double theta = this.computeTheta(fromLon);
            double toX = rho * Math.sin(theta);
            double toY = this.rho0 - rho * Math.cos(theta);
            resultXA[i] = toX + this.falseEasting;
            resultYA[i] = toY + this.falseNorthing;
        }
        return to;
    }

    @Override
    public double[][] projToLatLon(double[][] from, double[][] to) {
        int cnt = from[0].length;
        double[] fromXA = from[0];
        double[] fromYA = from[1];
        double[] toLatA = to[0];
        double[] toLonA = to[1];
        double rrho0 = this.rho0;
        for (int i = 0; i < cnt; ++i) {
            double fromX = fromXA[i] - this.falseEasting;
            double fromY = fromYA[i] - this.falseNorthing;
            if (this.n < 0.0) {
                rrho0 *= -1.0;
                fromX *= -1.0;
                fromY *= -1.0;
            }
            double yd = rrho0 - fromY;
            double rho = Math.sqrt(fromX * fromX + yd * yd);
            double theta = Math.atan2(fromX, yd);
            if (this.n < 0.0) {
                rho *= -1.0;
            }
            double toLat = Math.toDegrees(Math.asin((this.C - Math.pow(rho * this.n / this.earth_radius, 2.0)) / (2.0 * this.n)));
            double toLon = Math.toDegrees(theta / this.n + this.lon0);
            toLatA[i] = toLat;
            toLonA[i] = toLon;
        }
        return to;
    }

    public static void main(String[] args) {
        AlbersEqualArea a = new AlbersEqualArea(23.0, -96.0, 29.5, 45.5);
        System.out.printf("name=%s%n", a.getName());
        System.out.println("ll = 35N 75W");
        ProjectionPointImpl p = a.latLonToProj(35.0, -75.0);
        System.out.println("proj point = " + p);
        LatLonPoint ll = a.projToLatLon(p);
        System.out.println("ll = " + ll);
    }
}

