/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.jdk8.Predicate;
import org.apache.sis.internal.util.EmptyQueue;
import org.apache.sis.internal.util.EmptySortedSet;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.CodeListSet;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.InvalidParameterCardinalityException;
import org.opengis.util.CodeList;

public final class CollectionsExt
extends Static {
    private CollectionsExt() {
    }

    public static Collection<?> empty(Class<?> clazz) {
        if (clazz.isAssignableFrom(List.class)) {
            return Collections.EMPTY_LIST;
        }
        if (clazz.isAssignableFrom(Set.class)) {
            return Collections.EMPTY_SET;
        }
        if (clazz.isAssignableFrom(SortedSet.class)) {
            return CollectionsExt.emptySortedSet();
        }
        if (clazz.isAssignableFrom(Queue.class)) {
            return CollectionsExt.emptyQueue();
        }
        return null;
    }

    public static <T> T first(Iterable<T> iterable) {
        Iterator<T> iterator;
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> T singletonOrNull(Iterable<T> iterable) {
        Iterator<T> iterator;
        if (iterable != null && (iterator = iterable.iterator()) != null) {
            T t = null;
            while (iterator.hasNext()) {
                T t2 = iterator.next();
                if (t2 == null) continue;
                if (t != null) {
                    return null;
                }
                t = t2;
            }
            return t;
        }
        return null;
    }

    public static <E> Queue<E> emptyQueue() {
        return EmptyQueue.INSTANCE;
    }

    public static <E> SortedSet<E> emptySortedSet() {
        return EmptySortedSet.INSTANCE;
    }

    public static <E> Set<E> singletonOrEmpty(E e) {
        return e != null ? Collections.singleton(e) : Collections.emptySet();
    }

    @SafeVarargs
    public static <T> Set<T> nonEmptySet(T ... TArray) {
        Set<T> set = CollectionsExt.immutableSet(true, TArray);
        return set != null && set.isEmpty() ? null : set;
    }

    public static <E> E[] nonEmpty(E[] EArray) {
        return EArray != null && EArray.length == 0 ? null : EArray;
    }

    public static <T extends Collection<E>, E> T nonEmpty(T t) {
        return (T)(t != null && t.isEmpty() ? null : t);
    }

    public static <E> Collection<E> nonNull(Collection<E> collection) {
        return collection != null ? collection : Collections.emptySet();
    }

    public static <E> Set<E> nonNull(Set<E> set) {
        return set != null ? set : Collections.emptySet();
    }

    public static <E> E[] nonNullArraySet(String string, Object object, E[] EArray) throws IllegalArgumentException {
        assert (EArray.length == 0);
        if (object == null) {
            return EArray;
        }
        Class<?> clazz = EArray.getClass();
        Class<?> clazz2 = object.getClass();
        if (clazz2.isArray()) {
            if (clazz.isAssignableFrom(clazz2)) {
                LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>(Arrays.asList((Object[])object));
                linkedHashSet.remove(null);
                return linkedHashSet.toArray(EArray);
            }
        } else if ((clazz = clazz.getComponentType()).isAssignableFrom(clazz2)) {
            Object[] objectArray = (Object[])Array.newInstance(clazz, 1);
            objectArray[0] = object;
            return objectArray;
        }
        throw new IllegalArgumentException(Errors.format((short)58, string, clazz2));
    }

    public static <E> Set<E> createSetForType(Class<E> clazz, int n) {
        if (CodeList.class.isAssignableFrom(clazz)) {
            return new CodeListSet<E>(clazz);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return EnumSet.noneOf(clazz);
        }
        return new LinkedHashSet(Containers.hashMapCapacity(n));
    }

    @SafeVarargs
    public static <E> Set<E> immutableSet(boolean bl, E ... EArray) {
        if (EArray == null) {
            return null;
        }
        switch (EArray.length) {
            case 1: {
                E e = EArray[0];
                if (e != null || !bl) {
                    return Collections.singleton(e);
                }
            }
            case 0: {
                return Collections.emptySet();
            }
        }
        LinkedHashSet<E> linkedHashSet = new LinkedHashSet<E>(Arrays.asList(EArray));
        if (bl) {
            linkedHashSet.remove(null);
        }
        return CollectionsExt.unmodifiableOrCopy(linkedHashSet);
    }

    public static <E> Set<E> unmodifiableOrCopy(Set<E> set) {
        if (set != null) {
            switch (set.size()) {
                case 0: {
                    set = Collections.emptySet();
                    break;
                }
                case 1: {
                    set = Collections.singleton(set.iterator().next());
                    break;
                }
                default: {
                    set = Collections.unmodifiableSet(set);
                }
            }
        }
        return set;
    }

    public static <K, V> Map<K, V> unmodifiableOrCopy(Map<K, V> map) {
        if (map != null) {
            switch (map.size()) {
                case 0: {
                    map = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<K, V> entry = map.entrySet().iterator().next();
                    map = Collections.singletonMap(entry.getKey(), entry.getValue());
                    break;
                }
                default: {
                    map = Collections.unmodifiableMap(map);
                }
            }
        }
        return map;
    }

    public static <E> Collection<E> unmodifiableOrCopy(Collection<E> collection) {
        if (collection != null) {
            if (collection instanceof Set) {
                return CollectionsExt.unmodifiableOrCopy((Set)collection);
            }
            int n = collection.size();
            switch (n) {
                case 0: {
                    collection = Collections.emptyList();
                    break;
                }
                case 1: {
                    collection = Collections.singletonList(collection.iterator().next());
                    break;
                }
                default: {
                    if (collection instanceof UnmodifiableArrayList) break;
                    if (collection instanceof CheckedContainer) {
                        Object[] objectArray = (Object[])Array.newInstance(((CheckedContainer)((Object)collection)).getElementType(), n);
                        collection = UnmodifiableArrayList.wrap(collection.toArray(objectArray));
                        break;
                    }
                    collection = collection instanceof List ? Collections.unmodifiableList((List)collection) : Collections.unmodifiableCollection(collection);
                }
            }
        }
        return collection;
    }

    public static <E> Collection<E> modifiableCopy(Collection<E> collection) {
        if (collection == null) {
            return null;
        }
        Class<?> clazz = collection.getClass();
        if (collection instanceof Set) {
            if (collection instanceof SortedSet) {
                if (clazz == TreeSet.class) {
                    return (Collection)((TreeSet)collection).clone();
                }
                return new TreeSet<E>(collection);
            }
            if (clazz == HashSet.class || clazz == LinkedHashSet.class) {
                return (Collection)((HashSet)collection).clone();
            }
            if (collection instanceof EnumSet) {
                return ((EnumSet)collection).clone();
            }
            if (collection instanceof CodeListSet) {
                return ((CodeListSet)collection).clone();
            }
            return new LinkedHashSet<E>(collection);
        }
        if (collection instanceof Queue) {
            if (clazz == LinkedList.class) {
                return (Collection)((LinkedList)collection).clone();
            }
            return new LinkedList<E>(collection);
        }
        if (clazz == ArrayList.class) {
            return (Collection)((ArrayList)collection).clone();
        }
        return new ArrayList<E>(collection);
    }

    public static <K, V> Map<K, V> modifiableCopy(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        Class<?> clazz = map.getClass();
        if (map instanceof SortedMap) {
            if (clazz == TreeMap.class) {
                return (Map)((TreeMap)map).clone();
            }
            return new TreeMap<K, V>(map);
        }
        if (clazz == HashMap.class || clazz == LinkedHashMap.class) {
            return (Map)((HashMap)map).clone();
        }
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> compact(Map<K, V> map) {
        if (map != null) {
            switch (map.size()) {
                case 0: {
                    return Collections.emptyMap();
                }
                case 1: {
                    Map.Entry<K, V> entry = map.entrySet().iterator().next();
                    return Collections.singletonMap(entry.getKey(), entry.getValue());
                }
            }
        }
        return map;
    }

    public static <E> List<E> snapshot(List<E> list) {
        if (list != null && !(list instanceof UnmodifiableArrayList)) {
            switch (list.size()) {
                case 0: {
                    return Collections.emptyList();
                }
                case 1: {
                    return Collections.singletonList(list.get(0));
                }
            }
            return Arrays.asList(list.toArray());
        }
        return list;
    }

    public static Collection<?> toCollection(final Object object) {
        if (object == null) {
            return Collections.emptyList();
        }
        if (object instanceof Collection) {
            return (Collection)object;
        }
        if (object.getClass().isArray()) {
            if (object instanceof Object[]) {
                return Arrays.asList((Object[])object);
            }
            return new AbstractList<Object>(){

                @Override
                public int size() {
                    return Array.getLength(object);
                }

                @Override
                public Object get(int n) {
                    return Array.get(object, n);
                }

                @Override
                public Object set(int n, Object object3) {
                    Object object2 = Array.get(object3, n);
                    Array.set(object3, n, object3);
                    return object2;
                }
            };
        }
        if (object instanceof Iterable) {
            ArrayList arrayList = new ArrayList();
            for (Object t : (Iterable)object) {
                arrayList.add(t);
            }
            return arrayList;
        }
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList;
        }
        if (object instanceof Enumeration) {
            return Collections.list((Enumeration)object);
        }
        return Collections.singletonList(object);
    }

    public static <T> List<T> toList(Collection<T> collection) {
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<T>(collection);
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> clazz) {
        assert (Numbers.primitiveToWrapper(clazz) == clazz) : clazz;
        if (collection != null) {
            return collection.toArray((Object[])Array.newInstance(clazz, collection.size()));
        }
        return null;
    }

    public static <K, V> List<V> addToMultiValuesMap(Map<K, List<V>> map, K k, V v) {
        List<V> list = Collections.singletonList(v);
        List<V> list2 = map.put(k, list);
        if (list2 == null) {
            return list;
        }
        if (list2.size() <= 1) {
            list2 = new ArrayList<V>(list2);
        }
        if (map.put(k, list2) != list) {
            throw new ConcurrentModificationException();
        }
        list2.add(v);
        return list2;
    }

    public static <K, V> List<V> removeFromMultiValuesMap(Map<K, List<V>> map, K k, V v) {
        List<Object> list = map.get(k);
        if (list != null) {
            boolean bl;
            switch (list.size()) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1: {
                    bl = Objects.equals(v, list.get(0));
                    break;
                }
                default: {
                    boolean bl2 = bl = list.remove(v) && list.isEmpty();
                }
            }
            if (bl) {
                if (map.remove(k) != list) {
                    throw new ConcurrentModificationException();
                }
                list = Collections.emptyList();
            }
        }
        return list;
    }

    public static <E> Map<String, E> toCaseInsensitiveNameMap(Collection<Map.Entry<String, E>> collection, Locale locale) {
        if (collection == null) {
            return Collections.emptyMap();
        }
        HashMap<String, E> hashMap = new HashMap<String, E>(Containers.hashMapCapacity(collection.size()));
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, E> entry : collection) {
            E e;
            String string = entry.getKey();
            E e2 = hashMap.put(string, e = entry.getValue());
            if (e2 != null && !hashSet.remove(string)) {
                throw new InvalidParameterCardinalityException(Errors.format((short)164, string), string);
            }
            String string2 = string.toLowerCase(locale);
            if (string.equals(string2)) continue;
            if (hashSet.add(string2)) {
                JDK8.putIfAbsent(hashMap, string2, e);
                continue;
            }
            hashMap.remove(string2);
        }
        return hashMap;
    }

    public static <E> Iterator<E> filter(final Iterator<E> iterator, final Predicate<? super E> predicate) {
        return new Iterator<E>(){
            private boolean valid;
            private E next;

            @Override
            public boolean hasNext() {
                if (!this.valid) {
                    do {
                        if (!iterator.hasNext()) {
                            return false;
                        }
                        this.next = iterator.next();
                    } while (!predicate.test(this.next));
                    this.valid = true;
                }
                return true;
            }

            @Override
            public E next() {
                if (!this.valid) {
                    do {
                        this.next = iterator.next();
                    } while (!predicate.test(this.next));
                }
                this.valid = false;
                return this.next;
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static boolean identityEquals(Iterator<?> iterator, Iterator<?> iterator2) {
        while (iterator.hasNext()) {
            if (iterator2.hasNext() && iterator.next() == iterator2.next()) continue;
            return false;
        }
        return !iterator2.hasNext();
    }
}

