/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import javax.xml.bind.JAXBContext;

enum Implementation {
    INTERNAL("com.sun.xml.internal.bind.indentString", "com.sun.xml.internal.bind.namespacePrefixMapper", "org.apache.sis.xml.OGCNamespacePrefixMapper"),
    ENDORSED("com.sun.xml.bind.indentString", "com.sun.xml.bind.namespacePrefixMapper", "org.apache.sis.xml.OGCNamespacePrefixMapper_Endorsed"),
    OTHER(null, null, null);

    private static final String ENDORSED_PREFIX = "com.sun.xml.bind.";
    private static final String INTERNAL_PREFIX = "com.sun.xml.internal.bind.";
    final String indentKey;
    final String mapperKey;
    final String mapper;

    private Implementation(String string2, String string3, String string4) {
        this.indentKey = string2;
        this.mapperKey = string3;
        this.mapper = string4;
    }

    public static Implementation detect(JAXBContext jAXBContext) {
        if (jAXBContext != null) {
            String string = jAXBContext.getClass().getName();
            if (string.startsWith(INTERNAL_PREFIX)) {
                return INTERNAL;
            }
            if (string.startsWith(ENDORSED_PREFIX)) {
                return ENDORSED;
            }
        }
        return OTHER;
    }

    boolean filterProperty(String string) {
        return this.mapper != null || !string.startsWith(ENDORSED_PREFIX);
    }

    static String toInternal(String string) {
        if (string.startsWith(ENDORSED_PREFIX)) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + 10);
            string = stringBuilder.append(INTERNAL_PREFIX).append(string, ENDORSED_PREFIX.length(), string.length()).toString();
        }
        return string;
    }
}

