/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.io.Serializable;
import java.net.URI;
import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.util.Classes;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.InternationalString;

@XmlTransient
public class XLink
implements Serializable {
    private static final long serialVersionUID = 4046720871882443681L;
    private Type type;
    private URI href;
    private URI role;
    private URI arcrole;
    private InternationalString title;
    private Show show;
    private Actuate actuate;
    private String label;
    private String from;
    private String to;
    private int hashCode;

    public XLink() {
    }

    public XLink(XLink xLink) {
        if (xLink != null) {
            this.type = xLink.type;
            this.href = xLink.href;
            this.role = xLink.role;
            this.arcrole = xLink.arcrole;
            this.title = xLink.title;
            this.show = xLink.show;
            this.actuate = xLink.actuate;
            this.label = xLink.label;
            this.from = xLink.from;
            this.to = xLink.to;
        }
    }

    private int fieldMask() {
        int n = 0;
        if (this.type != null) {
            n |= 1;
        }
        if (this.href != null) {
            n |= 2;
        }
        if (this.role != null) {
            n |= 4;
        }
        if (this.arcrole != null) {
            n |= 8;
        }
        if (this.title != null) {
            n |= 0x10;
        }
        if (this.show != null) {
            n |= 0x20;
        }
        if (this.actuate != null) {
            n |= 0x40;
        }
        if (this.label != null) {
            n |= 0x80;
        }
        if (this.from != null) {
            n |= 0x100;
        }
        if (this.to != null) {
            n |= 0x200;
        }
        return n;
    }

    @XmlAttribute(name="type", namespace="http://www.w3.org/1999/xlink", required=true)
    public Type getType() {
        if (this.type != Type.AUTO) {
            return this.type;
        }
        Type type = null;
        int n = 32;
        int n2 = this.fieldMask();
        int n3 = ~(n2 | 1);
        for (Type type2 : Type.values()) {
            int n4;
            int n5 = ~type2.fieldMask;
            if (n5 == 0 || (n2 & n5) != 0 || (n3 & type2.mandatory) != 0 || (n4 = Integer.bitCount(n3 & type2.fieldMask)) >= n) continue;
            n = n4;
            type = type2;
        }
        return type;
    }

    public void setType(Type type) {
        this.canWrite(1, "type", "type");
        if (type != null && (this.fieldMask() & ~type.fieldMask) != 0) {
            throw new IllegalStateException(Errors.format((short)67, "type", type.identifier()));
        }
        this.type = type;
    }

    private void canWrite(int n, String string, Object object) throws IllegalStateException {
        if (this.hashCode != 0) {
            throw new UnsupportedOperationException(Errors.format((short)153, "XLink"));
        }
        Type type = this.type;
        if (type != null) {
            if (object != null) {
                if ((type.fieldMask & n) == 0) {
                    throw new IllegalStateException(Errors.format((short)40, string, type.identifier()));
                }
            } else if ((type.mandatory & n) != 0) {
                throw new IllegalStateException(Errors.format((short)76, string, type.identifier()));
            }
        }
    }

    @XmlSchemaType(name="anyURI")
    @XmlAttribute(name="href", namespace="http://www.w3.org/1999/xlink")
    public URI getHRef() {
        return this.href;
    }

    public void setHRef(URI uRI) throws IllegalStateException {
        this.canWrite(2, "href", uRI);
        this.href = uRI;
    }

    @XmlSchemaType(name="anyURI")
    @XmlAttribute(name="role", namespace="http://www.w3.org/1999/xlink")
    public URI getRole() {
        return this.role;
    }

    public void setRole(URI uRI) throws IllegalStateException {
        this.canWrite(4, "role", uRI);
        this.role = uRI;
    }

    @XmlSchemaType(name="anyURI")
    @XmlAttribute(name="arcrole", namespace="http://www.w3.org/1999/xlink")
    public URI getArcRole() {
        return this.arcrole;
    }

    public void setArcRole(URI uRI) throws IllegalStateException {
        this.canWrite(8, "arcrole", uRI);
        this.arcrole = uRI;
    }

    @XmlAttribute(name="title", namespace="http://www.w3.org/1999/xlink")
    public InternationalString getTitle() {
        return this.title;
    }

    public void setTitle(InternationalString internationalString) throws IllegalStateException {
        this.canWrite(16, "title", internationalString);
        this.title = internationalString;
    }

    @XmlAttribute(name="show", namespace="http://www.w3.org/1999/xlink")
    public Show getShow() {
        return this.show;
    }

    public void setShow(Show show) throws IllegalStateException {
        this.canWrite(32, "show", (Object)show);
        this.show = show;
    }

    @XmlAttribute(name="actuate", namespace="http://www.w3.org/1999/xlink")
    public Actuate getActuate() {
        return this.actuate;
    }

    public void setActuate(Actuate actuate) throws IllegalStateException {
        this.canWrite(64, "actuate", (Object)actuate);
        this.actuate = actuate;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) throws IllegalStateException {
        this.canWrite(128, "label", string);
        this.label = string;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String string) throws IllegalStateException {
        this.canWrite(256, "from", string);
        this.from = string;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String string) throws IllegalStateException {
        this.canWrite(512, "to", string);
        this.to = string;
    }

    public void freeze() {
        if (this.hashCode == 0) {
            this.hashCode = this.hash();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            int n;
            XLink xLink = (XLink)object;
            int n2 = this.hashCode;
            if (n2 != 0 && (n = xLink.hashCode) != 0 && n2 != n) {
                return false;
            }
            return Objects.equals((Object)this.type, (Object)xLink.type) && Objects.equals(this.href, xLink.href) && Objects.equals(this.role, xLink.role) && Objects.equals(this.arcrole, xLink.arcrole) && Objects.equals(this.title, xLink.title) && Objects.equals((Object)this.show, (Object)xLink.show) && Objects.equals((Object)this.actuate, (Object)xLink.actuate) && Objects.equals(this.label, xLink.label) && Objects.equals(this.from, xLink.from) && Objects.equals(this.to, xLink.to);
        }
        return false;
    }

    public int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = this.hash();
        }
        return n;
    }

    private int hash() {
        int n = Objects.hash(new Object[]{this.href, this.role, this.arcrole, this.title, this.show, this.actuate, this.label, this.from, this.to, this.type}) ^ 0x49B64BA1;
        if (n == 0) {
            n = -1;
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(Classes.getShortClassName(this)).append('[');
        XLink.append(stringBuilder, "type", (Object)this.getType());
        XLink.append(stringBuilder, "href", this.getHRef());
        XLink.append(stringBuilder, "role", this.getRole());
        XLink.append(stringBuilder, "arcrole", this.getArcRole());
        XLink.append(stringBuilder, "title", this.getTitle());
        XLink.append(stringBuilder, "show", (Object)this.getShow());
        XLink.append(stringBuilder, "actuate", (Object)this.getActuate());
        XLink.append(stringBuilder, "label", this.getLabel());
        XLink.append(stringBuilder, "from", this.getFrom());
        XLink.append(stringBuilder, "to", this.getTo());
        return stringBuilder.append(']').toString();
    }

    private static void append(StringBuilder stringBuilder, String string, Object object) {
        if (object != null) {
            if (stringBuilder.charAt(stringBuilder.length() - 1) != '[') {
                stringBuilder.append(", ");
            }
            if (object instanceof Enum) {
                try {
                    XmlEnumValue xmlEnumValue = object.getClass().getField(((Enum)object).name()).getAnnotation(XmlEnumValue.class);
                    if (xmlEnumValue != null) {
                        object = xmlEnumValue.value();
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Logging.unexpectedException(Logging.getLogger("org.apache.sis.xml"), XLink.class, "toString", noSuchFieldException);
                }
            }
            stringBuilder.append(string).append("=\"").append(object).append('\"');
        }
    }

    @XmlEnum
    public static enum Actuate {
        ON_LOAD,
        ON_REQUEST,
        OTHER,
        NONE;

    }

    @XmlEnum
    public static enum Show {
        NEW,
        REPLACE,
        EMBED,
        OTHER,
        NONE;

    }

    @XmlEnum
    public static enum Type {
        SIMPLE(127, 1),
        EXTENDED(21, 1),
        LOCATOR(151, 3),
        RESOURCE(149, 1),
        ARC(889, 1),
        TITLE(1, 1),
        AUTO(-1, 0);

        final int fieldMask;
        final int mandatory;

        private Type(int n2, int n3) {
            this.fieldMask = n2;
            this.mandatory = n3;
        }

        final String identifier() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

