/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html;

import java.util.Locale;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class XHTMLDowngradeHandler
extends ContentHandlerDecorator {
    public XHTMLDowngradeHandler(ContentHandler handler) {
        super(handler);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        String upper = localName.toUpperCase(Locale.ENGLISH);
        AttributesImpl attributes = new AttributesImpl();
        for (int i = 0; i < atts.getLength(); ++i) {
            String auri = atts.getURI(i);
            String local = atts.getLocalName(i);
            String qname = atts.getQName(i);
            if (!"".equals(auri) || local.equals("xmlns") || qname.startsWith("xmlns:")) continue;
            attributes.addAttribute(auri, local, qname, atts.getType(i), atts.getValue(i));
        }
        super.startElement("", upper, upper, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        String upper = localName.toUpperCase(Locale.ENGLISH);
        super.endElement("", upper, upper);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }
}

