/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.beans.PropertyEditor;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomEditorConfigurer
implements BeanFactoryPostProcessor,
BeanClassLoaderAware,
Ordered {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private PropertyEditorRegistrar[] propertyEditorRegistrars;
    private Map<String, ?> customEditors;
    private boolean ignoreUnresolvableEditors = false;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setPropertyEditorRegistrars(PropertyEditorRegistrar[] propertyEditorRegistrars) {
        this.propertyEditorRegistrars = propertyEditorRegistrars;
    }

    public void setCustomEditors(Map<String, ?> customEditors) {
        this.customEditors = customEditors;
    }

    public void setIgnoreUnresolvableEditors(boolean ignoreUnresolvableEditors) {
        this.ignoreUnresolvableEditors = ignoreUnresolvableEditors;
    }

    @Override
    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.propertyEditorRegistrars != null) {
            for (PropertyEditorRegistrar propertyEditorRegistrar : this.propertyEditorRegistrars) {
                beanFactory.addPropertyEditorRegistrar(propertyEditorRegistrar);
            }
        }
        if (this.customEditors != null) {
            for (Map.Entry<String, ?> entry : this.customEditors.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                Class<?> requiredType = null;
                try {
                    requiredType = ClassUtils.forName(key, this.beanClassLoader);
                    if (value instanceof PropertyEditor) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Passing PropertyEditor instances into CustomEditorConfigurer is deprecated: use PropertyEditorRegistrars or PropertyEditor class names instead. Offending key [" + key + "; offending editor instance: " + value);
                        }
                        beanFactory.addPropertyEditorRegistrar(new SharedPropertyEditorRegistrar(requiredType, (PropertyEditor)value));
                        continue;
                    }
                    if (value instanceof Class) {
                        beanFactory.registerCustomEditor(requiredType, (Class)value);
                        continue;
                    }
                    if (value instanceof String) {
                        Class<?> editorClass = ClassUtils.forName((String)value, this.beanClassLoader);
                        Assert.isAssignable(PropertyEditor.class, editorClass);
                        beanFactory.registerCustomEditor(requiredType, editorClass);
                        continue;
                    }
                    throw new IllegalArgumentException("Mapped value [" + value + "] for custom editor key [" + key + "] is not of required type [" + PropertyEditor.class.getName() + "] or a corresponding Class or String value indicating a PropertyEditor implementation");
                }
                catch (ClassNotFoundException ex) {
                    if (this.ignoreUnresolvableEditors) {
                        this.logger.info("Skipping editor [" + value + "] for required type [" + key + "]: " + (requiredType != null ? "editor" : "required type") + " class not found.");
                        continue;
                    }
                    throw new FatalBeanException((requiredType != null ? "Editor" : "Required type") + " class not found", ex);
                }
            }
        }
    }

    private static class SharedPropertyEditorRegistrar
    implements PropertyEditorRegistrar {
        private final Class requiredType;
        private final PropertyEditor sharedEditor;

        public SharedPropertyEditorRegistrar(Class requiredType, PropertyEditor sharedEditor) {
            this.requiredType = requiredType;
            this.sharedEditor = sharedEditor;
        }

        public void registerCustomEditors(PropertyEditorRegistry registry) {
            if (!(registry instanceof PropertyEditorRegistrySupport)) {
                throw new IllegalArgumentException("Cannot registered shared editor on non-PropertyEditorRegistrySupport registry: " + registry);
            }
            ((PropertyEditorRegistrySupport)registry).registerSharedEditor(this.requiredType, this.sharedEditor);
        }
    }
}

