/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.AbstractSingletonProxyFactoryBean;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.cache.interceptor.CacheInterceptor;
import org.springframework.cache.interceptor.CacheOperationSource;

public class CacheProxyFactoryBean
extends AbstractSingletonProxyFactoryBean {
    private final CacheInterceptor cachingInterceptor = new CacheInterceptor();
    private Pointcut pointcut;

    public void setPointcut(Pointcut pointcut) {
        this.pointcut = pointcut;
    }

    protected Object createMainInterceptor() {
        this.cachingInterceptor.afterPropertiesSet();
        if (this.pointcut != null) {
            return new DefaultPointcutAdvisor(this.pointcut, this.cachingInterceptor);
        }
        throw new UnsupportedOperationException();
    }

    public void setCacheOperationSources(CacheOperationSource ... cacheOperationSources) {
        this.cachingInterceptor.setCacheOperationSources(cacheOperationSources);
    }
}

