#!/usr/bin/perl

package eBay::API::XML::DataType::SellingManagerProductDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SellingManagerProductDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SellingManagerProductDetailsType

=head1 DESCRIPTION

Returned if the user is a Selling Manager
Pro user.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SellingManagerProductDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;


my @gaProperties = ( [ 'CustomLabel', 'xs:string', '', '', '' ]
	, [ 'PartNumber', 'xs:int', '', '', '' ]
	, [ 'ProductID', 'xs:string', '', '', '' ]
	, [ 'ProductName', 'xs:string', '', '', '' ]
	, [ 'ProductPartNumber', 'xs:string', '', '', '' ]
	, [ 'QuantityAvailable', 'xs:int', '', '', '' ]
	, [ 'UnitCost', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCustomLabel()

Custom label of this product.

#    Argument: 'xs:string'

=cut

sub setCustomLabel {
  my $self = shift;
  $self->{'CustomLabel'} = shift
}

=head2 getCustomLabel()

#    Returns: 'xs:string'

=cut

sub getCustomLabel {
  my $self = shift;
  return $self->{'CustomLabel'};
}


=head2 setPartNumber()

The numeric part number of an item.

#    Argument: 'xs:int'

=cut

sub setPartNumber {
  my $self = shift;
  $self->{'PartNumber'} = shift
}

=head2 getPartNumber()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:int'

=cut

sub getPartNumber {
  my $self = shift;
  return $self->{'PartNumber'};
}


=head2 setProductID()

ID of this product.

#    Argument: 'xs:string'

=cut

sub setProductID {
  my $self = shift;
  $self->{'ProductID'} = shift
}

=head2 getProductID()

#    Returns: 'xs:string'

=cut

sub getProductID {
  my $self = shift;
  return $self->{'ProductID'};
}


=head2 setProductName()

The exact product name of an item.

#    Argument: 'xs:string'

=cut

sub setProductName {
  my $self = shift;
  $self->{'ProductName'} = shift
}

=head2 getProductName()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getProductName {
  my $self = shift;
  return $self->{'ProductName'};
}


=head2 setProductPartNumber()

The alphanumeric part number of an item.

#    Argument: 'xs:string'

=cut

sub setProductPartNumber {
  my $self = shift;
  $self->{'ProductPartNumber'} = shift
}

=head2 getProductPartNumber()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getProductPartNumber {
  my $self = shift;
  return $self->{'ProductPartNumber'};
}


=head2 setQuantityAvailable()

Quantity of items in the inventory for this product.

#    Argument: 'xs:int'

=cut

sub setQuantityAvailable {
  my $self = shift;
  $self->{'QuantityAvailable'} = shift
}

=head2 getQuantityAvailable()

#    Returns: 'xs:int'

=cut

sub getQuantityAvailable {
  my $self = shift;
  return $self->{'QuantityAvailable'};
}


=head2 setUnitCost()

Cost of each item of this product.

#    Argument: 'ns:AmountType'

=cut

sub setUnitCost {
  my $self = shift;
  $self->{'UnitCost'} = shift
}

=head2 getUnitCost()

#    Returns: 'ns:AmountType'

=cut

sub getUnitCost {
  my $self = shift;
  return $self->_getDataTypeInstance( 'UnitCost'
		,'eBay::API::XML::DataType::AmountType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
