/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#ifndef CSLARTS_H
#define CSLARTS_H

#include "common.h"

// includes of other idl definitions
#include "artsflow.h"

namespace CSL {
enum Direction {dirInput = 0, dirOutput = 1};
enum StreamFormat {sf_size_8 = 8, sf_size_16 = 16, sf_size_32 = 32, sf_size_mask = 255, sf_endian_le = 256, sf_endian_be = 512, sf_endian_mask = 3840, sf_encoding_linear_signed = 4096, sf_encoding_linear_unsigned = 8192, sf_encoding_float = 12288, sf_encoding_mask = 61440, sf_u8 = 8200, sf_s16_le = 4368, sf_s16_be = 4624, sf_float_le = 12576, sf_float_be = 12832};
};
namespace CSL {
class StreamParams : public Arts::Type {
public:
	StreamParams();
	StreamParams(long _a_rate, long _a_channels, CSL::StreamFormat _a_format);
	StreamParams(Arts::Buffer& stream);
	StreamParams(const StreamParams& copyType);
	StreamParams& operator=(const StreamParams& assignType);
	long rate;
	long channels;
	CSL::StreamFormat format;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

class StreamStatus : public Arts::Type {
public:
	StreamStatus();
	StreamStatus(long _a_streamID, const CSL::StreamParams& _a_streamParams, long _a_streamBufferUsed, long _a_streamBufferSize, const CSL::StreamParams& _a_artsParams, long _a_artsBufferUsed, long _a_artsBufferSize);
	StreamStatus(Arts::Buffer& stream);
	StreamStatus(const StreamStatus& copyType);
	StreamStatus& operator=(const StreamStatus& assignType);
	long streamID;
	CSL::StreamParams streamParams;
	long streamBufferUsed;
	long streamBufferSize;
	CSL::StreamParams artsParams;
	long artsBufferUsed;
	long artsBufferSize;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
};

};
namespace CSL {
class Adapter;
class Stream;
class PlayStream;
class RecordStream;
class PlaySample;

class Adapter_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static Adapter_base *_create(const std::string& subClass = "CSL::Adapter");
	static Adapter_base *_fromString(std::string objectref);
	static Adapter_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Adapter_base *_fromDynamicCast(const Arts::Object& object);
	inline Adapter_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long open(const std::string& role, CSL::Direction dir) = 0;
	virtual bool setParams(long streamID, const CSL::StreamParams& params) = 0;
	virtual void setTitle(long streamID, const std::string& title) = 0;
	virtual void close(long streamID) = 0;
	virtual void write(long streamID, const std::vector<Arts::mcopbyte>& bytes) = 0;
	virtual std::vector<Arts::mcopbyte> * read(long streamID, long len) = 0;
	virtual void activate(long streamID) = 0;
	virtual void suspend(long streamID) = 0;
	virtual bool active(long streamID) = 0;
	virtual CSL::StreamStatus status(long streamID) = 0;
	virtual void clearBuffer(long streamID) = 0;
	virtual long waitBufferLevel(long streamID, long bufferUsed) = 0;
	virtual void waitPlayed(long streamID) = 0;
	virtual std::vector<std::string> * channelMaps(long streamID) = 0;
	virtual bool setChannelMapping(long streamID, long channel, const std::string& mapping) = 0;
	virtual std::string getChannelMapping(long streamID, long channel) = 0;
	virtual long sampleNew(const std::string& name, const std::string& role, const std::string& title) = 0;
	virtual void sampleRelease(long sampleID) = 0;
	virtual void sampleWrite(long sampleID, const std::vector<Arts::mcopbyte>& bytes) = 0;
	virtual void sampleWriteDone(long sampleID) = 0;
	virtual bool samplePlay(long sampleID) = 0;
	virtual bool sampleIsPlaying(long sampleID) = 0;
	virtual void sampleStop(long sampleID) = 0;
	virtual void sampleWaitDone(long sampleID) = 0;
	virtual void sampleCacheAdd(long sampleID) = 0;
	virtual long sampleCacheFind(const std::string& name, const std::string& role, const std::string& title) = 0;
	virtual void sampleCacheRemove(long sampleID) = 0;
};

class Adapter_stub : virtual public Adapter_base, virtual public Arts::Object_stub {
protected:
	Adapter_stub();

public:
	Adapter_stub(Arts::Connection *connection, long objectID);

	long open(const std::string& role, CSL::Direction dir);
	bool setParams(long streamID, const CSL::StreamParams& params);
	void setTitle(long streamID, const std::string& title);
	void close(long streamID);
	void write(long streamID, const std::vector<Arts::mcopbyte>& bytes);
	std::vector<Arts::mcopbyte> * read(long streamID, long len);
	void activate(long streamID);
	void suspend(long streamID);
	bool active(long streamID);
	CSL::StreamStatus status(long streamID);
	void clearBuffer(long streamID);
	long waitBufferLevel(long streamID, long bufferUsed);
	void waitPlayed(long streamID);
	std::vector<std::string> * channelMaps(long streamID);
	bool setChannelMapping(long streamID, long channel, const std::string& mapping);
	std::string getChannelMapping(long streamID, long channel);
	long sampleNew(const std::string& name, const std::string& role, const std::string& title);
	void sampleRelease(long sampleID);
	void sampleWrite(long sampleID, const std::vector<Arts::mcopbyte>& bytes);
	void sampleWriteDone(long sampleID);
	bool samplePlay(long sampleID);
	bool sampleIsPlaying(long sampleID);
	void sampleStop(long sampleID);
	void sampleWaitDone(long sampleID);
	void sampleCacheAdd(long sampleID);
	long sampleCacheFind(const std::string& name, const std::string& role, const std::string& title);
	void sampleCacheRemove(long sampleID);
};

class Adapter_skel : virtual public Adapter_base, virtual public Arts::Object_skel {
public:
	Adapter_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace CSL {
class Adapter : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Adapter_base *_cache;
	inline Adapter_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Adapter_base *)_pool->base->_cast(Adapter_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Adapter(Adapter_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Adapter_base _base_class;

	inline Adapter() : Arts::Object(_Creator), _cache(0) {}
	inline Adapter(const Arts::SubClass& s) :
		Arts::Object(Adapter_base::_create(s.string())), _cache(0) {}
	inline Adapter(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Adapter_base::_fromString(r.string())):(Adapter_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Adapter(const Arts::DynamicCast& c) : Arts::Object(Adapter_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Adapter(const Adapter& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Adapter(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Adapter null() {return Adapter((Adapter_base*)0);}
	inline static Adapter _from_base(Adapter_base* b) {return Adapter(b);}
	inline Adapter& operator=(const Adapter& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline Adapter_base* _base() {return _cache?_cache:_method_call();}

	inline long open(const std::string& role, CSL::Direction dir);
	inline bool setParams(long streamID, const CSL::StreamParams& params);
	inline void setTitle(long streamID, const std::string& title);
	inline void close(long streamID);
	inline void write(long streamID, const std::vector<Arts::mcopbyte>& bytes);
	inline std::vector<Arts::mcopbyte> * read(long streamID, long len);
	inline void activate(long streamID);
	inline void suspend(long streamID);
	inline bool active(long streamID);
	inline CSL::StreamStatus status(long streamID);
	inline void clearBuffer(long streamID);
	inline long waitBufferLevel(long streamID, long bufferUsed);
	inline void waitPlayed(long streamID);
	inline std::vector<std::string> * channelMaps(long streamID);
	inline bool setChannelMapping(long streamID, long channel, const std::string& mapping);
	inline std::string getChannelMapping(long streamID, long channel);
	inline long sampleNew(const std::string& name, const std::string& role, const std::string& title);
	inline void sampleRelease(long sampleID);
	inline void sampleWrite(long sampleID, const std::vector<Arts::mcopbyte>& bytes);
	inline void sampleWriteDone(long sampleID);
	inline bool samplePlay(long sampleID);
	inline bool sampleIsPlaying(long sampleID);
	inline void sampleStop(long sampleID);
	inline void sampleWaitDone(long sampleID);
	inline void sampleCacheAdd(long sampleID);
	inline long sampleCacheFind(const std::string& name, const std::string& role, const std::string& title);
	inline void sampleCacheRemove(long sampleID);
};

class Stream_base : virtual public Arts::SynthModule_base {
public:
	static unsigned long _IID; // interface ID

	static Stream_base *_create(const std::string& subClass = "CSL::Stream");
	static Stream_base *_fromString(std::string objectref);
	static Stream_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Stream_base *_fromDynamicCast(const Arts::Object& object);
	inline Stream_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long ID() = 0;
	virtual CSL::Direction direction() = 0;
	virtual std::string role() = 0;
	virtual std::string title() = 0;
	virtual void title(const std::string& newValue) = 0;
	virtual long bufferUsed() = 0;
	virtual long bufferSize() = 0;
	virtual void bufferSize(long newValue) = 0;
	virtual CSL::StreamParams params() = 0;
	virtual void params(const CSL::StreamParams& newValue) = 0;
	virtual bool active() = 0;
	virtual void active(bool newValue) = 0;
	virtual void clearBuffer() = 0;
	virtual void close() = 0;
};

class Stream_stub : virtual public Stream_base, virtual public Arts::SynthModule_stub {
protected:
	Stream_stub();

public:
	Stream_stub(Arts::Connection *connection, long objectID);

	long ID();
	CSL::Direction direction();
	std::string role();
	std::string title();
	void title(const std::string& newValue);
	long bufferUsed();
	long bufferSize();
	void bufferSize(long newValue);
	CSL::StreamParams params();
	void params(const CSL::StreamParams& newValue);
	bool active();
	void active(bool newValue);
	void clearBuffer();
	void close();
};

class Stream_skel : virtual public Stream_base, virtual public Arts::SynthModule_skel {
protected:
	// emitters for change notifications
	inline void ID_changed(long newValue) {
		_emit_changed("ID_changed",newValue);
	}
	inline void role_changed(const std::string& newValue) {
		_emit_changed("role_changed",newValue);
	}
	inline void title_changed(const std::string& newValue) {
		_emit_changed("title_changed",newValue);
	}
	inline void bufferUsed_changed(long newValue) {
		_emit_changed("bufferUsed_changed",newValue);
	}
	inline void bufferSize_changed(long newValue) {
		_emit_changed("bufferSize_changed",newValue);
	}
	inline void active_changed(bool newValue) {
		_emit_changed("active_changed",newValue);
	}

public:
	Stream_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace CSL {
class Stream : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Stream_base *_cache;
	inline Stream_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Stream_base *)_pool->base->_cast(Stream_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Stream(Stream_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Stream_base _base_class;

	inline Stream() : Arts::Object(_Creator), _cache(0) {}
	inline Stream(const Arts::SubClass& s) :
		Arts::Object(Stream_base::_create(s.string())), _cache(0) {}
	inline Stream(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Stream_base::_fromString(r.string())):(Stream_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Stream(const Arts::DynamicCast& c) : Arts::Object(Stream_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Stream(const Stream& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Stream(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Stream null() {return Stream((Stream_base*)0);}
	inline static Stream _from_base(Stream_base* b) {return Stream(b);}
	inline Stream& operator=(const Stream& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline Stream_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline long ID();
	inline CSL::Direction direction();
	inline std::string role();
	inline std::string title();
	inline void title(const std::string& _newValue);
	inline long bufferUsed();
	inline long bufferSize();
	inline void bufferSize(long _newValue);
	inline CSL::StreamParams params();
	inline void params(const CSL::StreamParams& _newValue);
	inline bool active();
	inline void active(bool _newValue);
	inline void clearBuffer();
	inline void close();
};

class PlayStream_base : virtual public CSL::Stream_base {
public:
	static unsigned long _IID; // interface ID

	static PlayStream_base *_create(const std::string& subClass = "CSL::PlayStream");
	static PlayStream_base *_fromString(std::string objectref);
	static PlayStream_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static PlayStream_base *_fromDynamicCast(const Arts::Object& object);
	inline PlayStream_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual void write(const std::vector<Arts::mcopbyte>& bytes) = 0;
};

class PlayStream_stub : virtual public PlayStream_base, virtual public CSL::Stream_stub {
protected:
	PlayStream_stub();

public:
	PlayStream_stub(Arts::Connection *connection, long objectID);

	void write(const std::vector<Arts::mcopbyte>& bytes);
};

class PlayStream_skel : virtual public PlayStream_base, virtual public CSL::Stream_skel {
protected:
	// variables for streams
	float *left;                              // outgoing stream
	float *right;                             // outgoing stream

public:
	PlayStream_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace CSL {
class PlayStream : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	PlayStream_base *_cache;
	inline PlayStream_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(PlayStream_base *)_pool->base->_cast(PlayStream_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline PlayStream(PlayStream_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef PlayStream_base _base_class;

	inline PlayStream() : Arts::Object(_Creator), _cache(0) {}
	inline PlayStream(const Arts::SubClass& s) :
		Arts::Object(PlayStream_base::_create(s.string())), _cache(0) {}
	inline PlayStream(const Arts::Reference &r) :
		Arts::Object(r.isString()?(PlayStream_base::_fromString(r.string())):(PlayStream_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline PlayStream(const Arts::DynamicCast& c) : Arts::Object(PlayStream_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline PlayStream(const PlayStream& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline PlayStream(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static PlayStream null() {return PlayStream((PlayStream_base*)0);}
	inline static PlayStream _from_base(PlayStream_base* b) {return PlayStream(b);}
	inline PlayStream& operator=(const PlayStream& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator CSL::Stream() const { return CSL::Stream(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline PlayStream_base* _base() {return _cache?_cache:_method_call();}

	inline long ID();
	inline CSL::Direction direction();
	inline std::string role();
	inline std::string title();
	inline void title(const std::string& _newValue);
	inline long bufferUsed();
	inline long bufferSize();
	inline void bufferSize(long _newValue);
	inline CSL::StreamParams params();
	inline void params(const CSL::StreamParams& _newValue);
	inline bool active();
	inline void active(bool _newValue);
	inline void clearBuffer();
	inline void close();
	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline void write(const std::vector<Arts::mcopbyte>& bytes);
};

class RecordStream_base : virtual public CSL::Stream_base {
public:
	static unsigned long _IID; // interface ID

	static RecordStream_base *_create(const std::string& subClass = "CSL::RecordStream");
	static RecordStream_base *_fromString(std::string objectref);
	static RecordStream_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static RecordStream_base *_fromDynamicCast(const Arts::Object& object);
	inline RecordStream_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::vector<Arts::mcopbyte> * read(long len) = 0;
};

class RecordStream_stub : virtual public RecordStream_base, virtual public CSL::Stream_stub {
protected:
	RecordStream_stub();

public:
	RecordStream_stub(Arts::Connection *connection, long objectID);

	std::vector<Arts::mcopbyte> * read(long len);
};

class RecordStream_skel : virtual public RecordStream_base, virtual public CSL::Stream_skel {
protected:
	// variables for streams
	float *left;                              // incoming stream
	float *right;                             // incoming stream

public:
	RecordStream_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace CSL {
class RecordStream : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	RecordStream_base *_cache;
	inline RecordStream_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(RecordStream_base *)_pool->base->_cast(RecordStream_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline RecordStream(RecordStream_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef RecordStream_base _base_class;

	inline RecordStream() : Arts::Object(_Creator), _cache(0) {}
	inline RecordStream(const Arts::SubClass& s) :
		Arts::Object(RecordStream_base::_create(s.string())), _cache(0) {}
	inline RecordStream(const Arts::Reference &r) :
		Arts::Object(r.isString()?(RecordStream_base::_fromString(r.string())):(RecordStream_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline RecordStream(const Arts::DynamicCast& c) : Arts::Object(RecordStream_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline RecordStream(const RecordStream& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline RecordStream(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static RecordStream null() {return RecordStream((RecordStream_base*)0);}
	inline static RecordStream _from_base(RecordStream_base* b) {return RecordStream(b);}
	inline RecordStream& operator=(const RecordStream& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator CSL::Stream() const { return CSL::Stream(*_pool); }
	inline operator Arts::SynthModule() const { return Arts::SynthModule(*_pool); }
	inline RecordStream_base* _base() {return _cache?_cache:_method_call();}

	inline long ID();
	inline CSL::Direction direction();
	inline std::string role();
	inline std::string title();
	inline void title(const std::string& _newValue);
	inline long bufferUsed();
	inline long bufferSize();
	inline void bufferSize(long _newValue);
	inline CSL::StreamParams params();
	inline void params(const CSL::StreamParams& _newValue);
	inline bool active();
	inline void active(bool _newValue);
	inline void clearBuffer();
	inline void close();
	inline Arts::AutoSuspendState autoSuspend();
	inline void start();
	inline void stop();
	inline void streamInit();
	inline void streamStart();
	inline void streamEnd();
	inline std::vector<Arts::mcopbyte> * read(long len);
};

class PlaySample_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static PlaySample_base *_create(const std::string& subClass = "CSL::PlaySample");
	static PlaySample_base *_fromString(std::string objectref);
	static PlaySample_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static PlaySample_base *_fromDynamicCast(const Arts::Object& object);
	inline PlaySample_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long ID() = 0;
	virtual bool finished() = 0;
	virtual void finished(bool newValue) = 0;
};

class PlaySample_stub : virtual public PlaySample_base, virtual public Arts::Object_stub {
protected:
	PlaySample_stub();

public:
	PlaySample_stub(Arts::Connection *connection, long objectID);

	long ID();
	bool finished();
	void finished(bool newValue);
};

class PlaySample_skel : virtual public PlaySample_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void ID_changed(long newValue) {
		_emit_changed("ID_changed",newValue);
	}
	inline void finished_changed(bool newValue) {
		_emit_changed("finished_changed",newValue);
	}

public:
	PlaySample_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

};
#include "reference.h"
namespace CSL {
class PlaySample : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	PlaySample_base *_cache;
	inline PlaySample_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(PlaySample_base *)_pool->base->_cast(PlaySample_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline PlaySample(PlaySample_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef PlaySample_base _base_class;

	inline PlaySample() : Arts::Object(_Creator), _cache(0) {}
	inline PlaySample(const Arts::SubClass& s) :
		Arts::Object(PlaySample_base::_create(s.string())), _cache(0) {}
	inline PlaySample(const Arts::Reference &r) :
		Arts::Object(r.isString()?(PlaySample_base::_fromString(r.string())):(PlaySample_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline PlaySample(const Arts::DynamicCast& c) : Arts::Object(PlaySample_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline PlaySample(const PlaySample& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline PlaySample(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static PlaySample null() {return PlaySample((PlaySample_base*)0);}
	inline static PlaySample _from_base(PlaySample_base* b) {return PlaySample(b);}
	inline PlaySample& operator=(const PlaySample& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline PlaySample_base* _base() {return _cache?_cache:_method_call();}

	inline long ID();
	inline bool finished();
	inline void finished(bool _newValue);
};

// Forward wrapper calls to _base classes:

inline long CSL::Adapter::open(const std::string& role, CSL::Direction dir)
{
	return _cache?static_cast<CSL::Adapter_base*>(_cache)->open(role, dir):static_cast<CSL::Adapter_base*>(_method_call())->open(role, dir);
}

inline bool CSL::Adapter::setParams(long streamID, const CSL::StreamParams& params)
{
	return _cache?static_cast<CSL::Adapter_base*>(_cache)->setParams(streamID, params):static_cast<CSL::Adapter_base*>(_method_call())->setParams(streamID, params);
}

inline void CSL::Adapter::setTitle(long streamID, const std::string& title)
{
	 _cache?static_cast<CSL::Adapter_base*>(_cache)->setTitle(streamID, title):static_cast<CSL::Adapter_base*>(_method_call())->setTitle(streamID, title);
}

inline void CSL::Adapter::close(long streamID)
{
	 _cache?static_cast<CSL::Adapter_base*>(_cache)->close(streamID):static_cast<CSL::Adapter_base*>(_method_call())->close(streamID);
}

inline void CSL::Adapter::write(long streamID, const std::vector<Arts::mcopbyte>& bytes)
{
	 _cache?static_cast<CSL::Adapter_base*>(_cache)->write(streamID, bytes):static_cast<CSL::Adapter_base*>(_method_call())->write(streamID, bytes);
}

inline std::vector<Arts::mcopbyte> * CSL::Adapter::read(long streamID, long len)
{
	return _cache?static_cast<CSL::Adapter_base*>(_cache)->read(streamID, len):static_cast<CSL::Adapter_base*>(_method_call())->read(streamID, len);
}

inline void CSL::Adapter::activate(long streamID)
{
	 _cache?static_cast<CSL::Adapter_base*>(_cache)->activate(streamID):static_cast<CSL::Adapter_base*>(_method_call())->activate(streamID);
}

inline void CSL::Adapter::suspend(long streamID)
{
	 _cache?static_cast<CSL::Adapter_base*>(_cache)->suspend(streamID):static_cast<CSL::Adapter_base*>(_method_call())->suspend(streamID);
}

inline bool CSL::Adapter::active(long streamID)
{
	return _cache?static_cast<CSL::Adapter_base*>(_cache)->active(streamID):static_cast<CSL::Adapter_base*>(_method_call())->active(streamID);
}

inline CSL::StreamStatus CSL::Adapter::status(long streamID)
{
	return _cache?static_cast<CSL::Adapter_base*>(_cache)->status(streamID):static_cast<CSL::Adapter_base*>(_method_call())->status(streamID);
}

inline void CSL::Adapter::clearBuffer(long streamID)
{
	 _cache?static_cast<CSL::Adapter_base*>(_cache)->clearBuffer(streamID):static_cast<CSL::Adapter_base*>(_method_call())->clearBuffer(streamID);
}

inline long CSL::Adapter::waitBufferLevel(long streamID, long bufferUsed)
{
	return _cache?static_cast<CSL::Adapter_base*>(_cache)->waitBufferLevel(streamID, bufferUsed):static_cast<CSL::Adapter_base*>(_method_call())->waitBufferLevel(streamID, bufferUsed);
}

inline void CSL::Adapter::waitPlayed(long streamID)
{
	 _cache?static_cast<CSL::Adapter_base*>(_cache)->waitPlayed(streamID):static_cast<CSL::Adapter_base*>(_method_call())->waitPlayed(streamID);
}

inline std::vector<std::string> * CSL::Adapter::channelMaps(long streamID)
{
	return _cache?static_cast<CSL::Adapter_base*>(_cache)->channelMaps(streamID):static_cast<CSL::Adapter_base*>(_method_call())->channelMaps(streamID);
}

inline bool CSL::Adapter::setChannelMapping(long streamID, long channel, const std::string& mapping)
{
	return _cache?static_cast<CSL::Adapter_base*>(_cache)->setChannelMapping(streamID, channel, mapping):static_cast<CSL::Adapter_base*>(_method_call())->setChannelMapping(streamID, channel, mapping);
}

inline std::string CSL::Adapter::getChannelMapping(long streamID, long channel)
{
	return _cache?static_cast<CSL::Adapter_base*>(_cache)->getChannelMapping(streamID, channel):static_cast<CSL::Adapter_base*>(_method_call())->getChannelMapping(streamID, channel);
}

inline long CSL::Adapter::sampleNew(const std::string& name, const std::string& role, const std::string& title)
{
	return _cache?static_cast<CSL::Adapter_base*>(_cache)->sampleNew(name, role, title):static_cast<CSL::Adapter_base*>(_method_call())->sampleNew(name, role, title);
}

inline void CSL::Adapter::sampleRelease(long sampleID)
{
	 _cache?static_cast<CSL::Adapter_base*>(_cache)->sampleRelease(sampleID):static_cast<CSL::Adapter_base*>(_method_call())->sampleRelease(sampleID);
}

inline void CSL::Adapter::sampleWrite(long sampleID, const std::vector<Arts::mcopbyte>& bytes)
{
	 _cache?static_cast<CSL::Adapter_base*>(_cache)->sampleWrite(sampleID, bytes):static_cast<CSL::Adapter_base*>(_method_call())->sampleWrite(sampleID, bytes);
}

inline void CSL::Adapter::sampleWriteDone(long sampleID)
{
	 _cache?static_cast<CSL::Adapter_base*>(_cache)->sampleWriteDone(sampleID):static_cast<CSL::Adapter_base*>(_method_call())->sampleWriteDone(sampleID);
}

inline bool CSL::Adapter::samplePlay(long sampleID)
{
	return _cache?static_cast<CSL::Adapter_base*>(_cache)->samplePlay(sampleID):static_cast<CSL::Adapter_base*>(_method_call())->samplePlay(sampleID);
}

inline bool CSL::Adapter::sampleIsPlaying(long sampleID)
{
	return _cache?static_cast<CSL::Adapter_base*>(_cache)->sampleIsPlaying(sampleID):static_cast<CSL::Adapter_base*>(_method_call())->sampleIsPlaying(sampleID);
}

inline void CSL::Adapter::sampleStop(long sampleID)
{
	 _cache?static_cast<CSL::Adapter_base*>(_cache)->sampleStop(sampleID):static_cast<CSL::Adapter_base*>(_method_call())->sampleStop(sampleID);
}

inline void CSL::Adapter::sampleWaitDone(long sampleID)
{
	 _cache?static_cast<CSL::Adapter_base*>(_cache)->sampleWaitDone(sampleID):static_cast<CSL::Adapter_base*>(_method_call())->sampleWaitDone(sampleID);
}

inline void CSL::Adapter::sampleCacheAdd(long sampleID)
{
	 _cache?static_cast<CSL::Adapter_base*>(_cache)->sampleCacheAdd(sampleID):static_cast<CSL::Adapter_base*>(_method_call())->sampleCacheAdd(sampleID);
}

inline long CSL::Adapter::sampleCacheFind(const std::string& name, const std::string& role, const std::string& title)
{
	return _cache?static_cast<CSL::Adapter_base*>(_cache)->sampleCacheFind(name, role, title):static_cast<CSL::Adapter_base*>(_method_call())->sampleCacheFind(name, role, title);
}

inline void CSL::Adapter::sampleCacheRemove(long sampleID)
{
	 _cache?static_cast<CSL::Adapter_base*>(_cache)->sampleCacheRemove(sampleID):static_cast<CSL::Adapter_base*>(_method_call())->sampleCacheRemove(sampleID);
}

inline Arts::AutoSuspendState CSL::Stream::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void CSL::Stream::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void CSL::Stream::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void CSL::Stream::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void CSL::Stream::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void CSL::Stream::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline long CSL::Stream::ID()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->ID():static_cast<CSL::Stream_base*>(_method_call())->ID();
}

inline CSL::Direction CSL::Stream::direction()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->direction():static_cast<CSL::Stream_base*>(_method_call())->direction();
}

inline std::string CSL::Stream::role()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->role():static_cast<CSL::Stream_base*>(_method_call())->role();
}

inline std::string CSL::Stream::title()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->title():static_cast<CSL::Stream_base*>(_method_call())->title();
}

inline void CSL::Stream::title(const std::string& _newValue)
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->title(_newValue):static_cast<CSL::Stream_base*>(_method_call())->title(_newValue);
}

inline long CSL::Stream::bufferUsed()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->bufferUsed():static_cast<CSL::Stream_base*>(_method_call())->bufferUsed();
}

inline long CSL::Stream::bufferSize()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->bufferSize():static_cast<CSL::Stream_base*>(_method_call())->bufferSize();
}

inline void CSL::Stream::bufferSize(long _newValue)
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->bufferSize(_newValue):static_cast<CSL::Stream_base*>(_method_call())->bufferSize(_newValue);
}

inline CSL::StreamParams CSL::Stream::params()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->params():static_cast<CSL::Stream_base*>(_method_call())->params();
}

inline void CSL::Stream::params(const CSL::StreamParams& _newValue)
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->params(_newValue):static_cast<CSL::Stream_base*>(_method_call())->params(_newValue);
}

inline bool CSL::Stream::active()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->active():static_cast<CSL::Stream_base*>(_method_call())->active();
}

inline void CSL::Stream::active(bool _newValue)
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->active(_newValue):static_cast<CSL::Stream_base*>(_method_call())->active(_newValue);
}

inline void CSL::Stream::clearBuffer()
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->clearBuffer():static_cast<CSL::Stream_base*>(_method_call())->clearBuffer();
}

inline void CSL::Stream::close()
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->close():static_cast<CSL::Stream_base*>(_method_call())->close();
}

inline long CSL::PlayStream::ID()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->ID():static_cast<CSL::Stream_base*>(_method_call())->ID();
}

inline CSL::Direction CSL::PlayStream::direction()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->direction():static_cast<CSL::Stream_base*>(_method_call())->direction();
}

inline std::string CSL::PlayStream::role()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->role():static_cast<CSL::Stream_base*>(_method_call())->role();
}

inline std::string CSL::PlayStream::title()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->title():static_cast<CSL::Stream_base*>(_method_call())->title();
}

inline void CSL::PlayStream::title(const std::string& _newValue)
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->title(_newValue):static_cast<CSL::Stream_base*>(_method_call())->title(_newValue);
}

inline long CSL::PlayStream::bufferUsed()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->bufferUsed():static_cast<CSL::Stream_base*>(_method_call())->bufferUsed();
}

inline long CSL::PlayStream::bufferSize()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->bufferSize():static_cast<CSL::Stream_base*>(_method_call())->bufferSize();
}

inline void CSL::PlayStream::bufferSize(long _newValue)
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->bufferSize(_newValue):static_cast<CSL::Stream_base*>(_method_call())->bufferSize(_newValue);
}

inline CSL::StreamParams CSL::PlayStream::params()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->params():static_cast<CSL::Stream_base*>(_method_call())->params();
}

inline void CSL::PlayStream::params(const CSL::StreamParams& _newValue)
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->params(_newValue):static_cast<CSL::Stream_base*>(_method_call())->params(_newValue);
}

inline bool CSL::PlayStream::active()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->active():static_cast<CSL::Stream_base*>(_method_call())->active();
}

inline void CSL::PlayStream::active(bool _newValue)
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->active(_newValue):static_cast<CSL::Stream_base*>(_method_call())->active(_newValue);
}

inline void CSL::PlayStream::clearBuffer()
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->clearBuffer():static_cast<CSL::Stream_base*>(_method_call())->clearBuffer();
}

inline void CSL::PlayStream::close()
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->close():static_cast<CSL::Stream_base*>(_method_call())->close();
}

inline Arts::AutoSuspendState CSL::PlayStream::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void CSL::PlayStream::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void CSL::PlayStream::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void CSL::PlayStream::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void CSL::PlayStream::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void CSL::PlayStream::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline void CSL::PlayStream::write(const std::vector<Arts::mcopbyte>& bytes)
{
	 _cache?static_cast<CSL::PlayStream_base*>(_cache)->write(bytes):static_cast<CSL::PlayStream_base*>(_method_call())->write(bytes);
}

inline long CSL::RecordStream::ID()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->ID():static_cast<CSL::Stream_base*>(_method_call())->ID();
}

inline CSL::Direction CSL::RecordStream::direction()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->direction():static_cast<CSL::Stream_base*>(_method_call())->direction();
}

inline std::string CSL::RecordStream::role()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->role():static_cast<CSL::Stream_base*>(_method_call())->role();
}

inline std::string CSL::RecordStream::title()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->title():static_cast<CSL::Stream_base*>(_method_call())->title();
}

inline void CSL::RecordStream::title(const std::string& _newValue)
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->title(_newValue):static_cast<CSL::Stream_base*>(_method_call())->title(_newValue);
}

inline long CSL::RecordStream::bufferUsed()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->bufferUsed():static_cast<CSL::Stream_base*>(_method_call())->bufferUsed();
}

inline long CSL::RecordStream::bufferSize()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->bufferSize():static_cast<CSL::Stream_base*>(_method_call())->bufferSize();
}

inline void CSL::RecordStream::bufferSize(long _newValue)
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->bufferSize(_newValue):static_cast<CSL::Stream_base*>(_method_call())->bufferSize(_newValue);
}

inline CSL::StreamParams CSL::RecordStream::params()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->params():static_cast<CSL::Stream_base*>(_method_call())->params();
}

inline void CSL::RecordStream::params(const CSL::StreamParams& _newValue)
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->params(_newValue):static_cast<CSL::Stream_base*>(_method_call())->params(_newValue);
}

inline bool CSL::RecordStream::active()
{
	return _cache?static_cast<CSL::Stream_base*>(_cache)->active():static_cast<CSL::Stream_base*>(_method_call())->active();
}

inline void CSL::RecordStream::active(bool _newValue)
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->active(_newValue):static_cast<CSL::Stream_base*>(_method_call())->active(_newValue);
}

inline void CSL::RecordStream::clearBuffer()
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->clearBuffer():static_cast<CSL::Stream_base*>(_method_call())->clearBuffer();
}

inline void CSL::RecordStream::close()
{
	 _cache?static_cast<CSL::Stream_base*>(_cache)->close():static_cast<CSL::Stream_base*>(_method_call())->close();
}

inline Arts::AutoSuspendState CSL::RecordStream::autoSuspend()
{
	return _cache?static_cast<Arts::SynthModule_base*>(_cache)->autoSuspend():static_cast<Arts::SynthModule_base*>(_method_call())->autoSuspend();
}

inline void CSL::RecordStream::start()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->start():static_cast<Arts::SynthModule_base*>(_method_call())->start();
}

inline void CSL::RecordStream::stop()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->stop():static_cast<Arts::SynthModule_base*>(_method_call())->stop();
}

inline void CSL::RecordStream::streamInit()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamInit():static_cast<Arts::SynthModule_base*>(_method_call())->streamInit();
}

inline void CSL::RecordStream::streamStart()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamStart():static_cast<Arts::SynthModule_base*>(_method_call())->streamStart();
}

inline void CSL::RecordStream::streamEnd()
{
	 _cache?static_cast<Arts::SynthModule_base*>(_cache)->streamEnd():static_cast<Arts::SynthModule_base*>(_method_call())->streamEnd();
}

inline std::vector<Arts::mcopbyte> * CSL::RecordStream::read(long len)
{
	return _cache?static_cast<CSL::RecordStream_base*>(_cache)->read(len):static_cast<CSL::RecordStream_base*>(_method_call())->read(len);
}

inline long CSL::PlaySample::ID()
{
	return _cache?static_cast<CSL::PlaySample_base*>(_cache)->ID():static_cast<CSL::PlaySample_base*>(_method_call())->ID();
}

inline bool CSL::PlaySample::finished()
{
	return _cache?static_cast<CSL::PlaySample_base*>(_cache)->finished():static_cast<CSL::PlaySample_base*>(_method_call())->finished();
}

inline void CSL::PlaySample::finished(bool _newValue)
{
	 _cache?static_cast<CSL::PlaySample_base*>(_cache)->finished(_newValue):static_cast<CSL::PlaySample_base*>(_method_call())->finished(_newValue);
}

};
#endif /* CSLARTS_H */
