/* CSL - Common Sound Layer
 * Copyright (C) 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include        <csl/cslsample.h>
#include        <stdio.h>

int
main (int   argc,
      char *argv[])
{
  CslErrorType error;
  CslDriver *driver;
  CslSample *sample;
  unsigned int i;

  if (argc < 2)
    csl_error("usage: %s <filenames...>\n", argv[0]);

  error = csl_driver_init_mutex	(NULL, CSL_DRIVER_CAP_PCM|CSL_DRIVER_CAP_SAMPLE, NULL, &driver);
  if (error)
    csl_error ("unable to initialize driver: %s", csl_strerror (error));

  for (i = 1; i < argc; i++)
    {
      error = csl_sample_new_from_file (driver, argv[i], "cslplay", NULL, &sample);
      if (error)
	csl_warning ("unable to create sample from file '%s': %s", argv[i], csl_strerror (error));
      csl_sample_play (sample);
      csl_sample_wait_done(sample);
      csl_sample_release (sample);
    }

  csl_driver_shutdown (driver);
  
  return 0;
}
/* vim:ts=8:sw=2:sts=2
 */
