/* CSL - Common Sound Layer
 * Copyright (C) 2001 Jeff Tranter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * This example illustrates PCM channel mappings.
 */

#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <csl/csl.h>

int main (int argc, char **argv)
{
	CslErrorType error;
	CslDriver *driver;
	CslPcmStream *stream;
	CslOptions options;
	int i;
	int nmaps;
	char **mappings;

	csl_options_parse (&options, &argc, &argv);
	csl_set_debug_mask (options.debug_flags);

	/* init driver */
	error = csl_driver_init (NULL, &driver);
	if (error)
		csl_error ("unable to initialize driver: %s", csl_strerror (error));
	
	/* open PCM output stream */
	error = csl_pcm_open_output (driver, "cslchanmap", options.rate, options.n_channels, options.pcm_format, &stream);
	if (error)
		csl_error ("failed to open output device: %s", csl_strerror (error));

	/* display initial channel mappings */
	mappings = csl_pcm_list_channel_mappings(driver, &nmaps);
	for (i = 0; i < nmaps; i++)
	{
		printf("Channel %d is %s\n", i, mappings[i]);
	}


/*
 * Setting channel mappings has not yet been implemented and will
 * produce an error.
*/
#if 0	
	/* set a channel mapping */
	error = csl_pcm_set_channel_mapping(stream, 0,CSL_PCM_CHANNEL_FRONT_LEFT); 
	if (error)
		csl_error ("failed to set channel mapping: %s", csl_strerror (error));
	error = csl_pcm_set_channel_mapping(stream, 1,CSL_PCM_CHANNEL_FRONT_RIGHT); 
	if (error)
		csl_error ("failed to set channel mapping: %s", csl_strerror (error));
#endif

	/* clean up */
	csl_pcm_close (stream);
	csl_driver_shutdown (driver);
	
	return 0;
}
