/* CSL - Common Sound Layer
 * Copyright (C) 2001 Jeff Tranter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * This small example illustrates how to initialize CSL to use a
 * specific backend driver or to allow CSL to autoselect a driver.
 *
 * If you are running aRst, you might want to do "artsshell suspend"
 * before running this program so that the sound server will be
 * suspended, otherwise the OSS driver initialization will fail.
 */

#include <stdio.h>
#include <csl/csl.h>

static void init(char *name)
{
	CslDriver *driver;
	CslErrorType err;

	if (name != NULL)	
		printf("Trying to init with `%s' driver: ", name);
	else
		printf("Trying to init with auto-selected driver: ");
	err = csl_driver_init(name, &driver);
	if (err == 0)
	{
		printf("succeeded\n");
	} else {
		printf("failed, error was \"%s\" (%d)\n", csl_strerror(err), err);
	}
	if (driver != NULL)
		csl_driver_shutdown(driver);
}

int main()
{
	init("oss");  /* OSS */
	init("arts"); /* aRts */
	init("foo");  /* non-existent driver */
	init(NULL);   /* auto-select */
	return 0;
}
