/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include "stamp-pdbgen.h"

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimpdrawable.h"
#include "core/gimpimage-crop.h"
#include "core/gimpimage-resize.h"
#include "core/gimpimage-undo.h"
#include "core/gimpimage.h"
#include "core/gimpparamspecs.h"
#include "core/gimppickable-auto-shrink.h"
#include "core/gimppickable.h"

#include "gimppdb.h"
#include "gimppdb-utils.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GimpValueArray *
plug_in_autocrop_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  GimpDrawable *drawable;

  image = g_value_get_object (gimp_value_array_index (args, 1));
  drawable = g_value_get_object (gimp_value_array_index (args, 2));

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error))
        {
          gint x, y, width, height;
          gint off_x, off_y;

          gimp_pickable_auto_shrink (GIMP_PICKABLE (drawable),
                                     0, 0,
                                     gimp_item_get_width  (GIMP_ITEM (drawable)),
                                     gimp_item_get_height (GIMP_ITEM (drawable)),
                                     &x, &y, &width, &height);

          gimp_item_get_offset (GIMP_ITEM (drawable), &off_x, &off_y);
          x += off_x;
          y += off_y;

          gimp_image_undo_group_start (image, GIMP_UNDO_GROUP_ITEM_RESIZE,
                                       _("Autocrop image"));

          if (x          < 0                             ||
              y          < 0                             ||
              x + width  > gimp_image_get_width  (image) ||
              y + height > gimp_image_get_height (image))
            {
              /*
               * partially outside the image area, we need to
               * resize the image to be able to crop properly.
               */
              gimp_image_resize (image, context, width, height, -x, -y, NULL);

              x = y = 0;
            }

          gimp_image_crop (image, context, GIMP_FILL_TRANSPARENT,
                           x, y, width, height, TRUE);

          gimp_image_undo_group_end (image);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
plug_in_autocrop_layer_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  GimpDrawable *drawable;

  image = g_value_get_object (gimp_value_array_index (args, 1));
  drawable = g_value_get_object (gimp_value_array_index (args, 2));

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error))
        {
          GList *layers = gimp_image_get_selected_layers (image);
          GList *iter;
          gint   x, y, width, height;

          if (layers)
            {
              switch (gimp_pickable_auto_shrink (GIMP_PICKABLE (drawable),
                                                 0, 0,
                                                 gimp_item_get_width  (GIMP_ITEM (drawable)),
                                                 gimp_item_get_height (GIMP_ITEM (drawable)),
                                                 &x, &y, &width, &height))
                {
                case GIMP_AUTO_SHRINK_SHRINK:
                  gimp_image_undo_group_start (image, GIMP_UNDO_GROUP_ITEM_RESIZE,
                                               _("Autocrop layer"));

                  for (iter = layers; iter; iter = iter->next)
                      gimp_item_resize (GIMP_ITEM (iter->data),
                                        context, GIMP_FILL_TRANSPARENT,
                                        width, height, -x, -y);

                  gimp_image_undo_group_end (image);
                  break;

                default:
                  break;
                }
            }
          else
            {
              success = FALSE;
            }
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_plug_in_compat_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-plug-in-autocrop
   */
  procedure = gimp_procedure_new (plug_in_autocrop_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "plug-in-autocrop");
  gimp_procedure_set_static_help (procedure,
                                  "Remove empty borders from the image",
                                  "Remove empty borders from the image.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1997");
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("run-mode",
                                                  "run mode",
                                                  "The run mode",
                                                  GIMP_TYPE_RUN_MODE,
                                                  GIMP_RUN_INTERACTIVE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "Input image)",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "Input drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-plug-in-autocrop-layer
   */
  procedure = gimp_procedure_new (plug_in_autocrop_layer_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "plug-in-autocrop-layer");
  gimp_procedure_set_static_help (procedure,
                                  "Crop the selected layers based on empty borders of the input drawable",
                                  "Crop the selected layers of the input \"image\" based on empty borders of the input \"drawable\". \n\nThe input drawable serves as a base for detecting cropping extents (transparency or background color), and is not necessarily among the cropped layers (the current selected layers).",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1997");
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("run-mode",
                                                  "run mode",
                                                  "The run mode",
                                                  GIMP_TYPE_RUN_MODE,
                                                  GIMP_RUN_INTERACTIVE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "Input image)",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "Input drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
