/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball, Josh MacDonald, 
 *                         and Jay Painter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GTK_CLIST_H__
#define __GTK_CLIST_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtk/gtkscrollbar.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_CLIST(obj)          GTK_CHECK_CAST (obj, gtk_clist_get_type (), GtkCList)
#define GTK_CLIST_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_clist_get_type (), GtkCListClass)
#define GTK_IS_CLIST(obj)       GTK_CHECK_TYPE (obj, gtk_clist_get_type ())


typedef struct _GtkCList        GtkCList;
typedef struct _GtkCListClass   GtkCListClass;
typedef struct _GtkCListColumn  GtkCListColumn;
typedef struct _GtkCListRow     GtkCListRow;
typedef struct _GtkCListRowItem GtkCListRowItem;

struct _GtkCList
{
  GtkContainer container;

  gint rows;
  gint row_center_offset;
  gint row_height;
  GList *row_list;
  GList *row_list_end;

  gint columns;             
  GdkRectangle column_title_area;   
  GList *column_list;

  GdkWindow *clist_window;
  gint clist_window_width;
  gint clist_window_height;
  gint clist_window_offset;

  gint shadow_type;

  GtkWidget *scrollbar;
  guint8 scrollbar_policy;

  GdkGC *border_gc;

  /*
   * column-drag data
   */
  GdkCursor *cursor_drag;
  GdkGC *xor_gc;
  gint x_drag;
  gint in_drag : 1;
  gint left_drag : 1;  


  guint selection_mode : 2;
  gint frozen : 1;
};

struct _GtkCListClass
{
  GtkContainerClass parent_class;

  void (* select_row)        (GtkCList       *clist,
                              gint            row,
			      gint            column,
			      GdkEventButton *event);
  void (* unselect_row)      (GtkCList       *clist,
                              gint            row,
			      gint            column,
			      GdkEventButton *event);
  void (* click_column)      (GtkCList       *clist,
			      gint            column);
};

struct _GtkCListColumn
{
  gchar *title;
  GdkRectangle area;
  GtkWidget *button;
  gint width;
  gint width_max;
  GtkJustification justification;
};

struct _GtkCListRow
{
  GList *row_item_list;
  GtkStateType state;
  gpointer data;
};

struct _GtkCListRowItem
{
  gchar *text;
  GdkPixmap *pixmap;
};


guint          gtk_clist_get_type        (void);

/*
 * create a new GtkCList
 */
GtkWidget*     gtk_clist_new  (int      columns,
			       gchar   *titles[]);

/*
 * set policy on the scrollbards, to either show them all the time
 * or show them only when they are needed, ie., when there is more than one page
 * of information
 */
void           gtk_clist_set_policy      (GtkCList         *clist,
					  GtkPolicyType     scrollbar_policy);
/*
 * freeze all visual updates of the list, and then thaw the list after you have made
 * a number of changes and the updates wil occure in a more efficent mannor than if
 * you made them on a unfrozen list
 */
void           gtk_clist_freeze          (GtkCList         *clist);
void           gtk_clist_thaw            (GtkCList         *clist);

/*
 * COLUMN Operations
 */
void           gtk_clist_set_column_title         (GtkCList         *clist,
						   gint              column,
						   gchar            *title);
void           gtk_clist_set_column_widget        (GtkCList         *clist,
						   gint              column,
						   GtkWidget        *widget);
void           gtk_clist_set_column_justification (GtkCList         *clist,
						   gint              column,
						   GtkJustification  justification);
void           gtk_clist_set_column_width         (GtkCList         *clist,
						   gint              column,
						   gint              width);

/*
 * ROW Operatons: append, insert and remove
 */
void           gtk_clist_append          (GtkCList         *clist, 
					  gchar            *text[]);
void           gtk_clist_insert          (GtkCList         *clist,
					  gint              row,
					  gchar            *text[]);
void           gtk_clist_remove          (GtkCList         *clist,
					  gint              row);


void           gtk_clist_set_row_data    (GtkCList         *clist,
					  gint              row,
					  gpointer          data);
gpointer       gtk_clist_get_row_data    (GtkCList         *clist,
					  gint              row);

void           gtk_clist_select_row      (GtkCList         *clist,
					  gint              row,
					  gint              column);
void           gtk_clist_unselect_row    (GtkCList         *clist,
					  gint              row,
					  gint              column);

/*
 * clear the entire list -- this is much faster than removing each item 
 * with gtk_clist_remove
 */
void           gtk_clist_clear           (GtkCList         *clist);




#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_CLIST_H__ */
