/* store testing, for remote folders */

#include "camel-test.h"
#include "camel-test-provider.h"
#include "folders.h"
#include "session.h"

#include <camel/camel-exception.h>
#include <camel/camel-service.h>
#include <camel/camel-store.h>

#define ARRAY_LEN(x) (sizeof(x)/sizeof(x[0]))

static const gchar *imap_drivers[] = { "imap4" };

static gchar *remote_providers[] = {
	"IMAP_TEST_URL",
};

gint main(gint argc, gchar **argv)
{
	CamelSession *session;
	CamelException *ex;
	gint i;
	gchar *path;

	camel_test_init(argc, argv);
	camel_test_provider_init(1, imap_drivers);

	ex = camel_exception_new();

	/* clear out any camel-test data */
	system("/bin/rm -rf /tmp/camel-test");

	session = camel_test_session_new ("/tmp/camel-test");

	/* todo: cross-check everything with folder_info checks as well */
	/* todo: subscriptions? */
	for (i=0;i<ARRAY_LEN(remote_providers);i++) {
		path = getenv(remote_providers[i]);

		if (path == NULL) {
			printf("Aborted (ignored).\n");
			printf("Set '%s', to re-run test.\n", remote_providers[i]);
			/* tells make check to ignore us in the total count */
			_exit(77);
		}
		/*camel_test_nonfatal("The IMAP code is just rooted");*/
		test_folder_basic(session, path, FALSE, FALSE);
		/*camel_test_fatal();*/
	}

	camel_object_unref((CamelObject *)session);
	camel_exception_free(ex);

	return 0;
}
