/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.util.TextUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class SpiceOut
extends Input<Stimuli> {
    private static final String CELLNAME_HEADER = "*** SPICE deck for cell ";

    SpiceOut() {
        super(null);
    }

    @Override
    protected Stimuli processInput(URL fileURL, Cell cell, Stimuli sd) throws IOException {
        if (this.openTextInput(fileURL)) {
            return sd;
        }
        System.out.println("Reading Spice/GNUCap output file: " + fileURL.getFile());
        SpiceOut.startProgressDialog("Spice output", fileURL.getFile());
        this.readSpiceFile(cell, sd);
        SpiceOut.stopProgressDialog();
        this.closeInput();
        return sd;
    }

    private void readSpiceFile(Cell cell, Stimuli sd) throws IOException {
        String line;
        boolean dataMode = false;
        boolean first = true;
        boolean pastEnd = false;
        String cellName = null;
        int mostSignals = 0;
        ArrayList allNumbers = new ArrayList();
        while ((line = this.getLine()) != null) {
            int len;
            if (first) {
                String hsFormat;
                first = false;
                if (line.length() >= 20 && ((hsFormat = line.substring(16, 20)).equals("9007") || hsFormat.equals("9601"))) {
                    System.out.println("This is an HSPICE file, not a SPICE2 file");
                    System.out.println("Change the SPICE format (in Preferences) and reread");
                    return;
                }
            }
            if ((len = line.length()) < 2) continue;
            if (cellName == null && line.startsWith(CELLNAME_HEADER)) {
                cellName = line.substring(CELLNAME_HEADER.length());
            }
            if (line.startsWith(".END") && !line.startsWith(".ENDS")) {
                pastEnd = true;
                continue;
            }
            if (line.startsWith("#Time")) {
                pastEnd = true;
                continue;
            }
            if (pastEnd && !dataMode && (Character.isWhitespace(line.charAt(0)) || line.charAt(0) == '-') && TextUtils.isDigit(line.charAt(1))) {
                dataMode = true;
            }
            if (pastEnd && dataMode && (!Character.isWhitespace(line.charAt(0)) && line.charAt(0) != '-' || !TextUtils.isDigit(line.charAt(1)))) {
                dataMode = false;
                pastEnd = false;
            }
            if (!dataMode) continue;
            ArrayList<Double> numbers = new ArrayList<Double>();
            for (int ptr = 0; ptr < len; ++ptr) {
                while (ptr < len && Character.isWhitespace(line.charAt(ptr))) {
                    ++ptr;
                }
                int start = ptr;
                while (ptr < len && !Character.isWhitespace(line.charAt(ptr))) {
                    ++ptr;
                }
                numbers.add(TextUtils.atof(line.substring(start, ptr)));
            }
            if (numbers.size() > mostSignals) {
                mostSignals = numbers.size();
            }
            allNumbers.add(numbers);
        }
        if (--mostSignals <= 0) {
            System.out.println("No data found in the file");
            return;
        }
        SignalCollection sc = Stimuli.newSignalCollection(sd, "SIGNALS");
        sd.setCell(cell);
        int numEvents = allNumbers.size();
        double[] time = new double[numEvents];
        for (int i = 0; i < numEvents; ++i) {
            time[i] = (Double)((List)allNumbers.get(i)).get(0);
        }
        for (int j = 0; j < mostSignals; ++j) {
            double[] values = new double[numEvents];
            for (int i = 0; i < numEvents; ++i) {
                List row = (List)allNumbers.get(i);
                values[i] = (Double)row.get(j + 1);
            }
            ScalarSample.createSignal(sc, sd, "Signal " + (j + 1), null, time, values);
        }
    }
}

