/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2013, 2014 (c)
 * 
 *    file: defs.h
 *    This file is part of Prime.
 *
 *    Prime is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    Prime is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with Prime.  If not, see <http://www.gnu.org/licenses/>.
 */    
/**********************************************
  This file contains definitions for constants 
  and functions used by the Prime program.
 **********************************************/
#include <stdio.h>

#ifndef __Prime_H
#define __Prime_H

#include "../corelib/dialogs.h"

/*
int SCREEN_W;
int SCREEN_H;

//Definitions for box-drawing characters//
#define ULC	0x6C//201	//Upper Left Corner of Double-box
#define LLC	0x6D//200	//Lower Left Corner of Double-box
#define URC	0x6B//187	//Upper Right Corner of Double-box
#define LRC	0x6A//188	//Lower Right Corner of Double-box
#define HB	0x71//205	//Horizontal bar of Double-box
#define VB	0x78//186	//Vertical bar of Double-box
#define RFT	0x74//204	//Right-facing T of Double-box
#define LFT	0x75//185	//Left-facing T of Double-box
#define DFT	0x77//203	//Down-facing T of Double-box
#define UFT	0x76//202	//Up-facing T of Double-box
#define MC	0x7E//206	//Middle-Cross of Double-box

//Definitions for colors//
#define BLACK      30      //set black foreground
#define RED        31      //set red foreground
#define GREEN      32      //set green foreground
#define BROWN      33      //set brown foreground
#define BLUE       34      //set blue foreground
#define MAGENTA    35      //set magenta foreground
#define CYAN       36      //set cyan foreground
#define WHITE      37      //set white foreground
#define BGBLACK    40      //set black background
#define BGRED      41      //set red background
#define BGGREEN    42      //set green background
#define BGBROWN    43      //set brown background
#define BGBLUE     44      //set blue background
#define BGMAGENTA  45      //set magenta background
#define BGCYAN     46      //set cyan background
#define BGWHITE    47      //set white background
#define BGDEFAULT  49      //set default background color

//Definitions for keyboard keys//
#define UP_KEY		1
#define DOWN_KEY	2
#define LEFT_KEY	3
#define RIGHT_KEY	4
#define HOME_KEY	5
#define END_KEY		6
#define ENTER_KEY	7
#define TAB_KEY		8
#define BACKSPACE_KEY	9
#define ESC_KEY		10
#define SPACE_KEY	32
#define DEL_KEY		12
#define ALT_F_KEY	13
#define ALT_E_KEY	14
#define ALT_H_KEY	15
#define CTRL_X_KEY	16
#define CTRL_V_KEY	17
#define CTRL_O_KEY	18
#define CTRL_P_KEY	19
#define CTRL_F_KEY	20
#define CTRL_A_KEY	21
#define CTRL_Q_KEY	22
#define CTRL_E_KEY	23
#define CTRL_C_KEY	24
#define CTRL_Z_KEY	25
#define CTRL_W_KEY	26
#define CTRL_N_KEY	28

//buttons used in message boxes//
#define OK	1	//00000001
#define YES	2	//00000010
#define CANCEL	4	//00000100
#define NO	8	//00001000
#define ALL	16	//00010000
#define ABORT	32	//00100000
//button combinations-->  00000101	OK/CANCEL = 5
			//00001010	YES/NO = 10
			//00011010	YES/ALL/NO = 26

//types of message displayed in message boxes//
typedef enum msgT { INFO, ERROR, CONFIRM } msgType;
*/
#define MAXDIRS		255
#define	MAXFILES	255
int MAX_DIR_NAME_LEN;
int MAX_FILE_NAME_LEN;
int MAX_MSG_BOX_W;
int MAX_MSG_BOX_H;
#define MAX_INPUT_MSG_LEN 100

//Function prototypes//
//clearArea is a flag to indicate whether to clear the window with spaces
void drawMenuBar(int x, int y, int w);
void init();
void scanDir(char *dir);
/*
void setScreenColors(int FG, int BG);
void getScreenSize();
void clearScreen();
int msgBox(char *msg, int Buttons, msgType tmsg);
char* inputBox(char *msg, char *title);
char input[MAX_INPUT_MSG_LEN+1];	//input string returned by inputBox() function
void drawBox(int x1, int y1, int x2, int y2, char *title, int clearArea);   
*/
void refreshDirView();
void refreshFileView();
void refreshBottomView();
void showFileMenu(int visible);
void showEditMenu(int visible);
void showHelpMenu(int visible);
void toggleSelected();
void showReadMe();	//called from help menu to show README file

//Menu items//
typedef struct menu_item_s 
{
  char *mtext;
  char *shortCutKeys;
} menu_item_struct;
//Main menu items//
typedef struct menu_s 
{
  char *text;
  int children;
  //struct menu_item_s childMenu[];
  char *child[];
} mainMenu;

//struct menu_s menu[3];
char *menu[3];
#define totalMainMenus	3	//total items in main menu bar
#define fTotal		5	//total items in file menu
#define eTotal		7	//total items in edit menu
#define hTotal		3	//total items in help menu
char *fileMenu[6];
char *editMenu[8];
char *helpMenu[4];

char *dirs[MAXDIRS];
char *files[MAXFILES];
int numVisDirs, firstVisDir, selectedDir, totalDirs;
int numVisFiles, firstVisFile, selectedFile, totalFiles;
char *dirHighLight;	//the hightlight bar to delineate the selected dir
char *fileHighLight;	//the hightlight bar to delineate the selected file
char dirStar[MAXDIRS];	//we need a byte-length declaration, so use char
char fileStar[MAXFILES];//both of these indicate which dir/file is starred 
			//(selected) in the view
			//value 42 is '*' and value 32 is ' '
int activeWindow;	//int value indicating which window is active

//values used in the activeWindow variable//
#define DIR_WIN		1
#define FILE_WIN	2
#define FILE_MENU	3
#define EDIT_MENU	4
#define HELP_MENU	5

//variables used in editing of dirs and files//
int numStarred;		//number of items starred (marked)
int numCut;		//number of items set to be cut
int numCopy;		//number of items selected for copy
//optional -- ask user for file name to export to
void exportTree(int showFileNameDialogBox); 
void exportTreeFromCommandLine(char *d, char *f);

//function called by exportTree() function
void scanThisDir(char tmp[], int level, int showProgress);

/*//terminal control functions//
void initTerminal();
void restoreTerminal();
*/
char *cwd;	//the current working directory
char *log_file_name;//string holding the name of the log file
FILE *log_file;

//int getKey();
//void sighandler(int signo);

char *config_file_name;//string holding the name of the config file
FILE *config_file;
int GNU_DOS_LEVEL;
#endif