/**********************************/
/* This file is part of QtC 0.0.2 */
/* (c) 1997 Roberto Alsina        */
/* Licensed under the GPL v2      */
/* Read file COPYING for details  */
/**********************************/
#ifndef QT_QIMAGE
#define QT_QIMAGE
#include <qimage.h>
extern "C" {
#include "qtc_types.h"


enum { IgnoreEndian, BigEndian, LittleEndian };

qt_QImage *qt_new_QImage();
qt_QImage *qt_new_QImage1(int width,int height,int depth,int numColors,int bitOrder);
qt_QImage *qt_new_QImage2(qt_QSize * arg1,int depth,int numColors,int bitOrder);
qt_QImage *qt_new_QImage3(char* fileName,char* format);
qt_QImage *qt_new_QImage4(char* xpm[]);
qt_QImage *qt_new_QImage5(qt_QImage * arg1);

void qt_QImage_detach( qt_QImage *instPointer);
qt_QImage * qt_QImage_copy( qt_QImage *instPointer);
int qt_QImage_isNull( qt_QImage *instPointer);
int qt_QImage_width( qt_QImage *instPointer);
int qt_QImage_height( qt_QImage *instPointer);
qt_QSize * qt_QImage_size( qt_QImage *instPointer);
qt_QRect * qt_QImage_rect( qt_QImage *instPointer);
int qt_QImage_depth( qt_QImage *instPointer);
int qt_QImage_numColors( qt_QImage *instPointer);
int qt_QImage_bitOrder( qt_QImage *instPointer);
unsigned int qt_QImage_color( qt_QImage *instPointer,int i);
void qt_QImage_setColor( qt_QImage *instPointer,int i,unsigned int c);
void qt_QImage_setNumColors( qt_QImage *instPointer,int arg1);
int qt_QImage_hasAlphaBuffer( qt_QImage *instPointer);
void qt_QImage_setAlphaBuffer( qt_QImage *instPointer,int arg1);
unsigned char* qt_QImage_bits( qt_QImage *instPointer);
unsigned char* qt_QImage_scanLine( qt_QImage *instPointer,int arg1);
unsigned char** qt_QImage_jumpTable( qt_QImage *instPointer);
unsigned int * qt_QImage_colorTable( qt_QImage *instPointer);
int qt_QImage_numBytes( qt_QImage *instPointer);
int qt_QImage_bytesPerLine( qt_QImage *instPointer);
int qt_QImage_create( qt_QImage *instPointer,int width,int height,int depth,int numColors,int bitOrder);
int qt_QImage_create1( qt_QImage *instPointer,qt_QSize * arg1,int depth,int numColors,int bitOrder);
void qt_QImage_reset( qt_QImage *instPointer);
void qt_QImage_fill( qt_QImage *instPointer,unsigned int pixel);
qt_QImage * qt_QImage_convertDepth( qt_QImage *instPointer,int arg1);
qt_QImage * qt_QImage_convertDepth1( qt_QImage *instPointer,int arg1,int conversion_flags);
qt_QImage * qt_QImage_convertBitOrder( qt_QImage *instPointer,int arg1);
qt_QImage * qt_QImage_createAlphaMask( qt_QImage *instPointer);
qt_QImage * qt_QImage_createAlphaMask1( qt_QImage *instPointer,int conversion_flags);
qt_QImage * qt_QImage_createHeuristicMask( qt_QImage *instPointer,int clipTight);
int qt_QImage_systemBitOrder();
int qt_QImage_systemByteOrder();
char* qt_QImage_imageFormat( char* fileName);
qt_QStrList * qt_QImage_inputFormats();
qt_QStrList * qt_QImage_outputFormats();
int qt_QImage_load( qt_QImage *instPointer,char* fileName,char* format);
int qt_QImage_loadFromData( qt_QImage *instPointer,unsigned char* buf,unsigned int len,char* format);
int qt_QImage_save( qt_QImage *instPointer,char* fileName,char* format);
int qt_QImage_valid( qt_QImage *instPointer,int x,int y);
int qt_QImage_pixelIndex( qt_QImage *instPointer,int x,int y);
unsigned int qt_QImage_pixel( qt_QImage *instPointer,int x,int y);
void qt_QImage_setPixel( qt_QImage *instPointer,int x,int y,unsigned int index_or_rgb);

}
#endif