/* -*- linux-c -*-
 *
 * spawn.c
 *
 *  Fork-and-wait routine
 *
 */

#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/wait.h>

#include "automount.h"

int spawnl(char *prog, ...) {
	va_list arg;
	pid_t f;
	int status;
	int argc;
	char **argv, **p;
	
	va_start(arg,prog);
	for ( argc = 1 ; va_arg(arg,char *) ; argc++ ); 
	va_end(arg);

	if ( !(argv = alloca(sizeof(char *) * argc)) )
		return -1;

	va_start(arg,prog);
	p = argv;
	while ((*p++ = va_arg(arg,char *)));
	va_end(arg);

	f = fork();
	if ( f < 0 ) {
		return -1;	/* fork() failed */
	} else if ( f == 0 ) {
		execv(prog, argv);
		_exit(255);	/* execv() failed */
	} else {
		if ( waitpid(f, &status, 0) != f )
			return -1; /* waitpid() failed */
		return status;
	}
}
