/*******************************************************************
 * This file is part of the Emulex Linux Device Driver for         *
 * Enterprise Fibre Channel Host Bus Adapters.                     *
 * Refer to the README file included with this package for         *
 * driver version and adapter support.                             *
 * Copyright (C) 2003 Emulex Corporation.                          *
 * www.emulex.com                                                  *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2  *
 * of the License, or (at your option) any later version.          *
 *                                                                 *
 * This program is distributed in the hope that it will be useful, *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   *
 * GNU General Public License for more details, a copy of which    *
 * can be found in the file COPYING included with this package.    *
 *******************************************************************/

/* Module fcxmitb.c External Routine Declarations */
_forward_ int       fc_create_xri(FC_BRD_INFO *binfo, RING *rp, NODELIST *nlp);
_forward_ void      fc_restartio(fc_dev_ctl_t *p_dev_ctl, NODELIST *nlp);
_forward_ IOCBQ    *fc_ringtx_drain(RING *rp);
_forward_ IOCBQ    *fc_ringtx_get(RING *rp);
_forward_ void      fc_ringtx_put(RING *rp, IOCBQ *iocbq);
_forward_ IOCBQ    *fc_ringtxp_get(RING *rp, ushort iotag);
_forward_ void      fc_ringtxp_put(RING *rp, IOCBQ *iocbq);
_forward_ int       fc_xmit(fc_dev_ctl_t *p_dev_ctl, fcipbuf_t *p_mbuf);
_forward_ int       handle_create_xri(fc_dev_ctl_t *p_dev_ctl, RING *rp,IOCBQ *tmp);
_forward_ int       handle_xmit_cmpl(fc_dev_ctl_t *p_dev_ctl, RING *rp, IOCBQ *tmp);



/* Module fcelsb.c External Routine Declarations */
_forward_ int       fc_chkpadisc(FC_BRD_INFO *binfo, NODELIST *nlp,
                      volatile NAME_TYPE *nn, volatile NAME_TYPE *pn);
_forward_ int       fc_els_cmd(FC_BRD_INFO *binfo, uint32 type, void *arg,
                      uint32 class, ushort iotag, NODELIST *nlp);
_forward_ int       fc_els_rsp(FC_BRD_INFO *binfo, uint32 type, uint32 Xri,
                      uint32 class, void *iocbp, uint32 flag, NODELIST *nlp);
_forward_ void      fc_snd_flogi(fc_dev_ctl_t *p_dev_ctl, void *a1, void *a2);
_forward_ int       fc_initial_flogi(fc_dev_ctl_t * p_dev_ctl);
_forward_ int       handle_els_event(fc_dev_ctl_t *p_dev_ctl, RING *rp, IOCBQ *temp);
_forward_ int       handle_rcv_els_req(fc_dev_ctl_t *p_dev_ctl, RING *rp, IOCBQ *temp);
_forward_ int       fc_process_rscn(fc_dev_ctl_t *p_dev_ctl, IOCBQ *temp, MATCHMAP *mp);
_forward_ int       fc_handle_rscn(fc_dev_ctl_t *p_dev_ctl, D_ID *didp);
_forward_ int       fc_issue_ct_req(FC_BRD_INFO *binfo, uint32 portid, MATCHMAP *bmp, DMATCHMAP *inmp, DMATCHMAP *outmp, uint32 tmo);
_forward_ int       fc_gen_req(FC_BRD_INFO *binfo, MATCHMAP *bmp, MATCHMAP *inmp, MATCHMAP *outmp, uint32 rpi, uint32 flag, uint32 cnt, uint32 tmo);
_forward_ int       fc_issue_ct_rsp(FC_BRD_INFO *binfo, uint32 tag, MATCHMAP *bmp, DMATCHMAP *inp);
_forward_ int       fc_rnid_req(FC_BRD_INFO *binfo, DMATCHMAP *inp, DMATCHMAP *outp,
                    MATCHMAP **bmp, uint32 rpi);
_forward_ void      fc_issue_ns_query(fc_dev_ctl_t *p, void *a1, void *a2);
_forward_ int       fc_flush_rscn_defer(fc_dev_ctl_t *p_dev_ctl);
_forward_ int       fc_abort_discovery( fc_dev_ctl_t *p_dev_ctl);
/* FDMI */
_forward_ int       fc_fdmi_cmd(fc_dev_ctl_t *p_dev_ctl, NODELIST *ndlp, int cmdcode);
_forward_ void      fc_fdmi_rsp(fc_dev_ctl_t *p_dev_ctl, MATCHMAP *mp, MATCHMAP *rsp_mp);
_forward_ void      fc_plogi_put(FC_BRD_INFO *binfo, IOCBQ *iocbq);
_forward_ IOCBQ   * fc_plogi_get(FC_BRD_INFO *binfo);



/* Module fcmboxb.c External Routine Declarations */
_forward_ void      fc_clear_la(FC_BRD_INFO *binfo, MAILBOX *mb);
_forward_ void      fc_read_status(FC_BRD_INFO *binfo, MAILBOX *mb);
_forward_ void      fc_read_lnk_stat(FC_BRD_INFO *binfo, MAILBOX *mb);
_forward_ void      fc_config_link(fc_dev_ctl_t *p_dev_ctl, MAILBOX *mb);
_forward_ int       fc_config_port(FC_BRD_INFO *binfo, MAILBOX *mb, uint32 *hbainit);
_forward_ void      fc_config_ring(FC_BRD_INFO *binfo, int ring, int profile,
                    MAILBOX *mb);
_forward_ void      fc_init_link(FC_BRD_INFO *binfo, MAILBOX *mb, 
                    uint32 topology, uint32 linkspeed);
_forward_ MAILBOXQ *fc_mbox_get(FC_BRD_INFO *binfo);
_forward_ int       fc_read_la(fc_dev_ctl_t *p_dev_ctl, MAILBOX *mb);
_forward_ void      fc_mbox_put(FC_BRD_INFO *binfo, MAILBOXQ *mbq);
_forward_ void      fc_read_rev(FC_BRD_INFO *binfo, MAILBOX *mb);
_forward_ int       fc_read_rpi(FC_BRD_INFO *binfo, uint32 rpi,MAILBOX *mb,uint32 flg);
_forward_ int       fc_read_sparam(fc_dev_ctl_t *p_dev_ctl, MAILBOX *mb);
_forward_ int       fc_reg_login(FC_BRD_INFO *binfo, uint32 did, uchar *param,
                      MAILBOX *mb, uint32 flag);
_forward_ void      fc_set_slim(FC_BRD_INFO *binfo, MAILBOX *mb, uint32 addr,
                      uint32 value);
_forward_ void      fc_unreg_login(FC_BRD_INFO *binfo, uint32 rpi, MAILBOX *mb);
_forward_ void      fc_unreg_did(FC_BRD_INFO *binfo, uint32 did, MAILBOX *mb);
_forward_ void      fc_dump_mem(FC_BRD_INFO *binfo, MAILBOX *mb);

_forward_ void      fc_config_farp(FC_BRD_INFO *binfo, MAILBOX *mb);
_forward_ void      fc_read_config(FC_BRD_INFO *binfo, MAILBOX *mb);

/* Module fcmemb.c External Routine Declarations */
_forward_ void      fc_disable_tc(FC_BRD_INFO *binfo, MAILBOX *mb);
_forward_ MATCHMAP *fc_getvaddr(fc_dev_ctl_t *p_dev_ctl, RING *rp, uchar *mapbp);
_forward_ uchar    *fc_mem_get(FC_BRD_INFO *binfo, uint32 seg);
_forward_ uchar    *fc_mem_put(FC_BRD_INFO *binfo, uint32 seg, uchar *bp);
_forward_ int       fc_free_buffer(fc_dev_ctl_t *p_dev_ctl);
_forward_ int       fc_malloc_buffer(fc_dev_ctl_t *p_dev_ctl);
_forward_ void      fc_mapvaddr(FC_BRD_INFO *binfo, RING *rp, MATCHMAP *mp,
                      uint32 *haddr, uint32 *laddr);
_forward_ int       fc_runBIUdiag(FC_BRD_INFO *binfo, MAILBOX *mb, uchar *in,
                      uchar *out);


/* Module fcclockb.c External Routine Declarations */
_forward_ void  fc_clkrelb(fc_dev_ctl_t *p_dev_ctl, FCCLOCK *cb);
_forward_ int   fc_clk_can(fc_dev_ctl_t *p_dev_ctl, FCCLOCK *cb);
_forward_ FCCLOCK  *fc_clk_set(fc_dev_ctl_t *p_dev_ctl, ulong tix,
                void (*func)(fc_dev_ctl_t*, void*, void*), void *arg1, void *arg2);
_forward_ ulong fc_clk_res(fc_dev_ctl_t *p_dev_ctl, ulong tix, FCCLOCK *cb);
_forward_ void  fc_timer(void *);
_forward_ void  fc_clock_deque(FCCLOCK *cb);
_forward_ void  fc_clock_init(void);
_forward_ void  fc_flush_clk_set(fc_dev_ctl_t *p_dev_ctl,
                void (*func)(fc_dev_ctl_t*, void*, void*));
_forward_ int   fc_abort_clk_blk(fc_dev_ctl_t *p_dev_ctl,
                void (*func)(fc_dev_ctl_t*, void*, void*), void *a1, void *a2);
_forward_ int   fc_abort_delay_els_cmd( fc_dev_ctl_t *p_dev_ctl, uint32 did);
_forward_ void  fc_q_depth_up(fc_dev_ctl_t *p_dev_ctl, void *, void *);
_forward_ void  fc_establish_link_tmo(fc_dev_ctl_t *p_dev_ctl, void *, void *);
/* QFULL_RETRY */
_forward_ void  fc_qfull_retry(void *);
_forward_ void  fc_reset_timer(void);

/* Module fcrpib.c External Routine Declarations */
_forward_ int       fc_discovery(fc_dev_ctl_t *p_dev_ctl);
_forward_ ushort    fc_emac_lookup(FC_BRD_INFO *binfo, uchar *addr,
                      NODELIST **nlpp);
_forward_ int       fc_fanovery(fc_dev_ctl_t *p_dev_ctl);
_forward_ NODELIST *fc_findnode_rpi(FC_BRD_INFO *binfo, uint32 rpi);
_forward_ int       fc_free_rpilist(fc_dev_ctl_t *p_dev_ctl, int keeprpi);
_forward_ void      fc_freebufq(fc_dev_ctl_t *p_dev_ctl, RING *rp, IOCBQ *xmitiq);
_forward_ int       fc_freenode(FC_BRD_INFO *binfo, NODELIST *nlp, int rm);
_forward_ int       fc_freenode_did(FC_BRD_INFO *binfo, uint32 did, int rm);
_forward_ int       fc_nlpadjust(FC_BRD_INFO *binfo);
_forward_ int       fc_rpi_abortxri(FC_BRD_INFO *binfo, ushort xri);
_forward_ int       fc_nlp_bind(FC_BRD_INFO *binfo, NODELIST *nlp);
_forward_ int       fc_nlp_unmap(FC_BRD_INFO *binfo, NODELIST *nlp);
_forward_ int       fc_nlp_map(FC_BRD_INFO *binfo, NODELIST *nlp);
_forward_ NODELIST *fc_findnode_odid(FC_BRD_INFO *binfo, uint32 order, uint32 did);
_forward_ NODELIST *fc_findnode_scsid(FC_BRD_INFO *binfo, uint32 order, uint32 scid);
_forward_ NODELIST *fc_findnode_wwpn(FC_BRD_INFO *binfo, uint32 odr, NAME_TYPE *wwp);
_forward_ NODELIST *fc_findnode_wwnn(FC_BRD_INFO *binfo, uint32 odr, NAME_TYPE *wwn);
_forward_ NODELIST *fc_findnode_oxri(FC_BRD_INFO *binfo, uint32 order, uint32 xri);
_forward_ int       fc_nlp_logi(FC_BRD_INFO *binfo, NODELIST *nlp, NAME_TYPE *wwpnp,
                      NAME_TYPE *wwnnp);
_forward_ int       fc_nlp_swapinfo(FC_BRD_INFO *binfo, NODELIST *onlp, NODELIST *nnlp);


/* Module fcstratb.c External Routine Declarations */
_forward_ dvi_t    *fc_fcp_abort(fc_dev_ctl_t *p, int flg, int tgt, int lun);
_forward_ int       fc_assign_scsid(fc_dev_ctl_t *ap, NODELIST *nlp);
_forward_ fc_buf_t *fc_deq_fcbuf_active(RING *rp, ushort iotag);
_forward_ fc_buf_t *fc_deq_fcbuf(dvi_t *di);
_forward_ void      fc_enq_abort_bdr(dvi_t *dev_ptr);
_forward_ void      fc_enq_fcbuf(fc_buf_t *fcptr);
_forward_ void      fc_enq_fcbuf_active(RING *rp, fc_buf_t *fcptr);
_forward_ int       issue_fcp_cmd(fc_dev_ctl_t *p_dev_ctl, dvi_t *dev_ptr,
                     T_SCSIBUF *sbp, int pend);
_forward_ void      fc_enq_wait(dvi_t *dev_ptr);
_forward_ void      fc_fail_cmd(dvi_t *dev_ptr, char error, uint32 statistic);
_forward_ void      fc_fail_pendq(dvi_t *dev_ptr, char error, uint32 statistic);
_forward_ int       fc_failio(fc_dev_ctl_t  * p_dev_ctl);
_forward_ dvi_t    *fc_find_lun( FC_BRD_INFO * binfo, int hash_index, fc_lun_t lun);
_forward_ void      fc_issue_cmd(fc_dev_ctl_t *ap);
_forward_ int       fc_reset_dev_q_depth( fc_dev_ctl_t * p_dev_ctl);
_forward_ int       fc_restart_all_devices(fc_dev_ctl_t * p_dev_ctl);
_forward_ int       fc_restart_device(dvi_t * dev_ptr);
_forward_ void      fc_return_standby_queue(dvi_t *dev_ptr, uchar status,
                        uint32 statistic);
_forward_ void      re_issue_fcp_cmd(dvi_t *dev_ptr);
_forward_ void      fc_polling(FC_BRD_INFO *binfo, uint32 att_bit);
_forward_ void      fc_fcp_fix_txq(fc_dev_ctl_t *p_dev_ctl);



/* Module fcscsib.c External Routine Declarations */
_forward_ int       fc_abort_fcp_txpq(FC_BRD_INFO *binfo, dvi_t *dev_ptr);
_forward_ int       fc_abort_xri(FC_BRD_INFO *binfo, dvi_t *dev_ptr, ushort iotag, int flag);
_forward_ int       fc_abort_ixri_cx(FC_BRD_INFO *binfo, ushort xri, uint32 cmd, RING *rp);
_forward_ int       fc_attach(int index, uint32 *p_uio);
_forward_ int       fc_cfg_init(fc_dev_ctl_t *p_dev_ctl);
_forward_ void      fc_cfg_remove(fc_dev_ctl_t *p_dev_ctl);
_forward_ void      fc_cmdring_timeout(fc_dev_ctl_t *p, void *a1, void *a2);
_forward_ int       fc_delay_iodone(fc_dev_ctl_t *p_dev_ctl, 
                      T_SCSIBUF * sbp);
_forward_ void      fc_delay_timeout(fc_dev_ctl_t *p, void *l1, void *l2);
_forward_ void      fc_nodev_timeout(fc_dev_ctl_t *p, void *l1, void *l2);
_forward_ int       fc_detach(int index);
_forward_ void      fc_ffcleanup(fc_dev_ctl_t *p_dev_ctl);
_forward_ void      fc_free_clearq(dvi_t *dev_ptr);
_forward_ int       fc_geportname(NAME_TYPE *pn1, NAME_TYPE *pn2);
_forward_ int       fc_linkdown(fc_dev_ctl_t *p_dev_ctl);
_forward_ void      fc_linkdown_timeout(fc_dev_ctl_t *p, void *a1, void *a2);
_forward_ void      fc_mbox_timeout(fc_dev_ctl_t *p, void *a1, void *a2);
_forward_ void      fc_fabric_timeout(fc_dev_ctl_t *p, void *a1, void *a2);
_forward_ int       fc_nextauth(fc_dev_ctl_t *p_dev_ctl, int sndcnt);
_forward_ int       fc_nextdisc(fc_dev_ctl_t *p_dev_ctl, int sndcnt);
_forward_ int       fc_nextnode(fc_dev_ctl_t *p_dev_ctl, NODELIST *nlp);
_forward_ int       fc_nextrscn(fc_dev_ctl_t *p_dev_ctl, int sndcnt);
_forward_ int       fc_free_ct_rsp(fc_dev_ctl_t *p_dev_ctl, MATCHMAP *mlist);
_forward_ int       fc_ns_cmd(fc_dev_ctl_t *p_dev_ctl, NODELIST *nlp, int cc);
_forward_ int       fc_ns_rsp(fc_dev_ctl_t *p_dev_ctl, NODELIST *nslp, MATCHMAP *mp, uint32 sz);
_forward_ int       fc_ct_cmd(fc_dev_ctl_t *p_dev_ctl, MATCHMAP *mp,
                    MATCHMAP *bmp, NODELIST *nlp);
_forward_ int       fc_offline(fc_dev_ctl_t *p_dev_ctl);
_forward_ int       fc_online(fc_dev_ctl_t *p_dev_ctl);
_forward_ void      fc_pcimem_bcopy(uint32 *src, uint32 *dest, uint32 cnt);
_forward_ int       fc_post_buffer(fc_dev_ctl_t *p_dev_ctl, RING *rp, int cnt);
_forward_ int       fc_post_mbuf(fc_dev_ctl_t *p_dev_ctl, RING *rp, int cnt);
_forward_ int       fc_rlip(fc_dev_ctl_t *p_dev_ctl);
_forward_ void      fc_scsi_timeout(fc_dev_ctl_t *p, void *l1, void *l2);
_forward_ void      fc_start(fc_dev_ctl_t *p_dev_ctl);
_forward_ void      handle_fcp_event(fc_dev_ctl_t *p_dev_ctl, RING *rp,IOCBQ *temp);
_forward_ int       handle_mb_cmd(fc_dev_ctl_t *p_dev_ctl, MAILBOX *mb, uint32 cmd);
_forward_ int       fc_free_iocb_buf(fc_dev_ctl_t *p_dev_ctl, RING *rp, IOCBQ *tmp);
_forward_ int       handle_iprcv_seq(fc_dev_ctl_t *p_dev_ctl, RING *rp, IOCBQ *temp);
_forward_ int       handle_elsrcv_seq(fc_dev_ctl_t *p_dev_ctl, RING *rp, IOCBQ *temp);
_forward_ void      fc_process_reglogin(fc_dev_ctl_t *p_dev_ctl, NODELIST *nlp);
_forward_ int       fc_snd_scsi_req(fc_dev_ctl_t *p_dev_ctl, NAME_TYPE *wwn,
                    MATCHMAP *bmp, DMATCHMAP *fcpmp, DMATCHMAP *omatp,
                    uint32 cnt, struct dev_info *devp);
_forward_ void      issue_report_lun(fc_dev_ctl_t *p_dev_ctl, void *l1, void *l2);
_forward_ int       fc_parse_binding_entry( fc_dev_ctl_t *p_dev_ctl, uchar *inbuf,
                    uchar *outbuf, int in_size, int out_size, int bind_type,
                    unsigned int *sum, int entry, int *lpfc_num);

/*
 * External Routine Declarations for local print statement formatting
 */ 

_forward_ int       fc_asc_seq_to_hex( fc_dev_ctl_t *p_dev_ctl, 
                      int input_bc, int output_bc, char *inp, char *outp);
_forward_ int       fc_asc_to_hex( uchar c);
_forward_ int       fc_is_digit( int chr);
_forward_ int       fc_log_printf_msg_vargs(
                      int brdno, msgLogDef *msg,
                      void *control, ...);
_forward_ int       fc_check_this_log_msg_disabled( 
                      int brdno, msgLogDef *msg, int *log_only);

_forward_ void      fc_brdreset(fc_dev_ctl_t *p_dev_ctl);
_forward_ int       fc_ffinit(fc_dev_ctl_t *p_dev_ctl);
_forward_ int       issue_mb_cmd(FC_BRD_INFO *binfo, MAILBOX *mb, int flag);
_forward_ uint32    issue_iocb_cmd(FC_BRD_INFO *binfo, RING *rp, IOCBQ *iocb_cmd);
_forward_ char     *decode_firmware_rev(FC_BRD_INFO *binfo, fc_vpd_t *vp);
_forward_ int       dfc_fmw_rev( fc_dev_ctl_t * p_dev_ctl);
_forward_ int       dfc_hba_put_event( fc_dev_ctl_t * p_dev_ctl, uint32 evcode,
                    uint32 evdata1, uint32 evdata2, uint32 evdata3, uint32 evdata4);
_forward_ int       dfc_put_event( fc_dev_ctl_t * p_dev_ctl, uint32 evcode,
                    uint32 evdata0, void *evdata1, void *evdata2);
_forward_ void      handle_ff_error(fc_dev_ctl_t *p_dev_ctl);
_forward_ int       handle_mb_event(fc_dev_ctl_t *p_dev_ctl);
_forward_ void      handle_link_event(fc_dev_ctl_t *p_dev_ctl);
_forward_ void      handle_ring_event(fc_dev_ctl_t *p_dev_ctl, int ring,uint32 reg);
