/*********************************/
/* Rule Set Based Access Control */
/* Author and (c) 1999-2001:     */
/*   Amon Ott <ao@rsbac.org>     */
/* Data structures for Role      */
/* Compatibility module          */
/* Last modified: 10/Dec/2001    */
/*********************************/


#ifndef __RSBAC_RC_DATA_STRUC_H
#define __RSBAC_RC_DATA_STRUC_H

#ifdef __KERNEL__   /* only include in kernel code */
#include <linux/types.h>
#include <rsbac/types.h>
#endif /* __KERNEL__ */

/* First of all we define dirname and filenames for saving the roles to disk. */
/* The path must be a valid single dir name! Each mounted device gets its    */
/* own file set, residing in 'DEVICE_ROOT/RSBAC_ACI_PATH/'.                  */
/* All user access to these files will be denied.                            */
/* Backups are kept in FILENAMEb.                                            */

#ifdef __KERNEL__
#define RSBAC_RC_LIST_KEY 77788855

/* roles */
#define RSBAC_RC_ROLE_FILENAME "rc_r"

/* roles we are compatible with ( = we can change to) */
#define RSBAC_RC_ROLE_RC_FILENAME "rc_rc"

/* roles we may administrate (replaces admin_type) */
#define RSBAC_RC_ROLE_ADR_FILENAME "rc_adr"

/* roles we may read and assign to users, if they were in one of these before. */
#define RSBAC_RC_ROLE_ASR_FILENAME "rc_asr"

/* file/dir/fifo/symlink types and requests we are compatible with */
#define RSBAC_RC_ROLE_TCFD_FILENAME "rc_tcfd"

/* dev types and requests we are compatible with */
#define RSBAC_RC_ROLE_TCDV_FILENAME "rc_tcdv"

/* process types and requests we are compatible with */
#define RSBAC_RC_ROLE_TCPR_FILENAME "rc_tcpr"

/* IPC types and requests we are compatible with */
#define RSBAC_RC_ROLE_TCIP_FILENAME "rc_tcip"

/* SCD types and requests we are compatible with */
#define RSBAC_RC_ROLE_TCSC_FILENAME "rc_tcsc"

/* NETDEV types and requests we are compatible with */
#define RSBAC_RC_ROLE_TCND_FILENAME "rc_tcnd"

/* NETTEMP types and requests we are compatible with */
#define RSBAC_RC_ROLE_TCNT_FILENAME "rc_tcnt"

/* NETOBJ types and requests we are compatible with */
#define RSBAC_RC_ROLE_TCNO_FILENAME "rc_tcno"

#define RSBAC_RC_ROLE_LIST_VERSION 1
#define RSBAC_RC_ROLE_RC_LIST_VERSION 1
#define RSBAC_RC_ROLE_ADR_LIST_VERSION 1
#define RSBAC_RC_ROLE_ASR_LIST_VERSION 1
#define RSBAC_RC_ROLE_TCFD_LIST_VERSION 1
#define RSBAC_RC_ROLE_TCDV_LIST_VERSION 1
#define RSBAC_RC_ROLE_TCPR_LIST_VERSION 1
#define RSBAC_RC_ROLE_TCIP_LIST_VERSION 1
#define RSBAC_RC_ROLE_TCSC_LIST_VERSION 1
#define RSBAC_RC_ROLE_TCND_LIST_VERSION 1
#define RSBAC_RC_ROLE_TCNT_LIST_VERSION 1
#define RSBAC_RC_ROLE_TCNO_LIST_VERSION 1

#define RSBAC_RC_TYPE_FD_FILENAME "rc_tfd"
#define RSBAC_RC_TYPE_DEV_FILENAME "rc_tdv"
#define RSBAC_RC_TYPE_IPC_FILENAME "rc_tip"
#define RSBAC_RC_TYPE_PROCESS_FILENAME "rc_tpr"
#define RSBAC_RC_TYPE_NETDEV_FILENAME "rc_tnd"
#define RSBAC_RC_TYPE_NETTEMP_FILENAME "rc_tnt"
#define RSBAC_RC_TYPE_NETOBJ_FILENAME "rc_tno"

#define RSBAC_RC_TYPE_FD_LIST_VERSION 1
#define RSBAC_RC_TYPE_DEV_LIST_VERSION 1
#define RSBAC_RC_TYPE_IPC_LIST_VERSION 1
#define RSBAC_RC_TYPE_PROCESS_LIST_VERSION 1
#define RSBAC_RC_TYPE_NETDEV_LIST_VERSION 1
#define RSBAC_RC_TYPE_NETTEMP_LIST_VERSION 1
#define RSBAC_RC_TYPE_NETOBJ_LIST_VERSION 1
#endif /* __KERNEL__ */

/*
 * The following structures provide the role model data structures.
 * All RSBAC_RC_NR_ROLES roles and RSBAC_RC_NR_TYPES x target-no. types
 * and SCD-type definitions are kept in arrays and saved to disk as such.
 */

/***************************************
 *               Roles                 *
 ***************************************/

/* Caution: whenever role struct changes, version and old_version must be increased! */

struct rsbac_rc_role_entry_t            
    {
      rsbac_enum_t           admin_type; /* role admin: none, system or role admin? */
      char                   name[RSBAC_RC_NAME_LEN];
      rsbac_rc_type_id_t     def_fd_create_type;
      rsbac_rc_type_id_t     def_process_create_type;
      rsbac_rc_type_id_t     def_process_chown_type;
      rsbac_rc_type_id_t     def_process_execute_type;
      rsbac_rc_type_id_t     def_ipc_create_type;
    };

#define RSBAC_RC_NR_ROLE_ENTRY_ITEMS 18
#define RSBAC_RC_ROLE_ENTRY_ITEM_LIST { \
      RI_role_comp, \
      RI_admin_roles, \
      RI_assign_roles, \
      RI_type_comp_fd, \
      RI_type_comp_dev, \
      RI_type_comp_process, \
      RI_type_comp_ipc, \
      RI_type_comp_scd, \
      RI_type_comp_netdev, \
      RI_type_comp_nettemp, \
      RI_type_comp_netobj, \
      RI_admin_type, \
      RI_name, \
      RI_def_fd_create_type, \
      RI_def_process_create_type, \
      RI_def_process_chown_type, \
      RI_def_process_execute_type, \
      RI_def_ipc_create_type \
      }

/***************************************
 *             Type names              *
 ***************************************/

/* Caution: whenever role struct changes, version and old_version must be increased! */

/* #define RSBAC_RC_OLD_TYPE_VERSION 1 */
#define RSBAC_RC_TYPE_VERSION 1

struct rsbac_rc_type_fd_entry_t            
    {
      char                   name[RSBAC_RC_NAME_LEN];
      __u8                   need_secdel;  /* boolean */
    };

#define RSBAC_RC_NR_TYPE_ENTRY_ITEMS 9
#define RSBAC_RC_TYPE_ENTRY_ITEM_LIST { \
      RI_type_fd_name, \
      RI_type_dev_name, \
      RI_type_ipc_name, \
      RI_type_scd_name, \
      RI_type_process_name, \
      RI_type_netdev_name, \
      RI_type_nettemp_name, \
      RI_type_netobj_name, \
      RI_type_fd_need_secdel \
      }

/**********************************************/
/*              Default values                */
/**********************************************/

#define RSBAC_RC_GENERAL_ROLE_ENTRY \
    { \
      RC_no_admin,                /* admin_type */ \
      "General User",             /* name */ \
      RC_type_inherit_parent,     /* def_fd_create_type */ \
      RC_type_inherit_parent,     /* def_process_create_type */ \
      RC_type_use_new_role_def_create, /* def_process_chown_type */ \
      RC_type_inherit_process,    /* def_process_execute_type */ \
      RSBAC_RC_GENERAL_TYPE       /* def_ipc_create_type */ \
    }

#define RSBAC_RC_ROLE_ADMIN_ROLE_ENTRY \
    { \
      RC_role_admin,              /* admin_type */ \
      "Role Admin",               /* name */ \
      RC_type_inherit_parent,     /* def_fd_create_type */ \
      RC_type_inherit_parent,     /* def_process_create_type */ \
      RC_type_use_new_role_def_create, /* def_process_chown_type */ \
      RC_type_inherit_process,    /* def_process_execute_type */ \
      RSBAC_RC_GENERAL_TYPE       /* def_ipc_create_type */ \
    }

#define RSBAC_RC_SYSTEM_ADMIN_ROLE_ENTRY \
    { \
      RC_system_admin,            /* admin_type */ \
      "System Admin",             /* name */ \
      RC_type_inherit_parent,     /* def_fd_create_type */ \
      RC_type_inherit_parent,     /* def_process_create_type */ \
      RC_type_use_new_role_def_create, /* def_process_chown_type */ \
      RC_type_inherit_process,    /* def_process_execute_type */ \
      RSBAC_RC_GENERAL_TYPE       /* def_ipc_create_type */ \
    }

#define RSBAC_RC_AUDITOR_ROLE_ENTRY \
    { \
      RC_no_admin,                /* admin_type */ \
      "Auditor",                  /* name */ \
      RC_type_inherit_parent,     /* def_fd_create_type */ \
      RC_type_inherit_parent,     /* def_process_create_type */ \
      RC_type_use_new_role_def_create, /* def_process_chown_type */ \
      RC_type_inherit_process,    /* def_process_execute_type */ \
      RSBAC_RC_GENERAL_TYPE       /* def_ipc_create_type */ \
    }

/**********************************************/
/*              Declarations                  */
/**********************************************/

#ifdef __KERNEL__
#endif /* __KERNEL__ */

#endif /* __RSBAC_RC_DATA_STRUC_H */
