/* $Id: linux_logo.h,v 1.1 1997/04/16 17:51:37 jj Exp $
 * include/asm-sparc64/linux_logo.h: This is a linux logo
 *                                   to be displayed on boot.
 *
 * Copyright (C) 1996 Larry Ewing (lewing@isc.tamu.edu)
 * Copyright (C) 1997 Jakub Jelinek (jj@sunsite.mff.cuni.cz)
 *
 * You can put anything here, but:
 * LINUX_LOGO_COLORS has to be less than 224
 * image size has to be 80x80
 * values have to start from 0x20
 * (i.e. RGB(linux_logo_red[0],
 *	     linux_logo_green[0],
 *	     linux_logo_blue[0]) is color 0x20)
 * BW image has to be 80x80 as well, with MS bit
 * on the left
 * Serial_console ascii image can be any size,
 * but should contain %s to display the version
 */
 
#include <linux/init.h>
#include <linux/version.h>

#define linux_logo_banner "Linux/UltraSPARC version " UTS_RELEASE

#define LINUX_LOGO_COLORS 215

unsigned char linux_logo_red[] __initdata = {
  0x99, 0x95, 0x92, 0x8E, 0x8A, 0x86, 0x02, 0x00,
  0xA5, 0xA9, 0xA2, 0x9E, 0xAD, 0x1B, 0x3B, 0x25,
  0x71, 0x65, 0x2C, 0x82, 0x5B, 0x33, 0x13, 0xB0,
  0x0C, 0xB1, 0xD4, 0xCE, 0x04, 0x06, 0x16, 0xB6,
  0xCD, 0xB2, 0x42, 0x46, 0x4B, 0xA8, 0xF3, 0xCA,
  0xC5, 0x1C, 0xDC, 0xA0, 0xD4, 0xE6, 0xED, 0xF3,
  0xC2, 0x8E, 0xCC, 0xA5, 0x7E, 0x52, 0xF7, 0xE3,
  0x56, 0x79, 0x68, 0x8D, 0xAF, 0xFC, 0x8E, 0x3E,
  0x6B, 0x11, 0x37, 0x79, 0x5C, 0x3C, 0x3F, 0x3C,
  0x48, 0x47, 0x3D, 0xB9, 0x62, 0xE1, 0x4D, 0x57,
  0x84, 0x78, 0xA6, 0x58, 0x99, 0xCD, 0xB7, 0xE3,
  0x6D, 0x5A, 0xAF, 0x79, 0x79, 0xF2, 0x42, 0x46,
  0xDD, 0x89, 0xC3, 0xF2, 0xF0, 0xE0, 0xD1, 0x90,
  0x76, 0x6B, 0x4A, 0xBE, 0xBD, 0xE3, 0xF6, 0xE9,
  0xEC, 0xE8, 0xEC, 0xC0, 0x66, 0x63, 0xCB, 0xAB,
  0x49, 0x5C, 0xAD, 0xD6, 0xEE, 0xF5, 0xF5, 0xE9,
  0x6E, 0x00, 0x69, 0x6A, 0xA1, 0x7A, 0xB4, 0xDE,
  0xF1, 0xF6, 0xDD, 0x00, 0x73, 0xDB, 0x4C, 0x53,
  0x6A, 0xF5, 0xF5, 0xD6, 0xC3, 0x6A, 0x4B, 0x4B,
  0x60, 0xF8, 0x9B, 0xD7, 0xD7, 0x71, 0xB3, 0xA4,
  0xCA, 0xAB, 0xB4, 0xB2, 0x76, 0xBA, 0x8B, 0xA0,
  0xA5, 0xEE, 0xE7, 0x67, 0x5F, 0x08, 0x94, 0xDB,
  0xE5, 0x4F, 0x00, 0x34, 0xEE, 0xEC, 0xE2, 0x48,
  0xF3, 0xEB, 0xF4, 0xF4, 0xEF, 0xD6, 0xB6, 0xE6,
  0xE6, 0xED, 0xE7, 0xE6, 0x3D, 0xE7, 0xCD, 0x44,
  0xEF, 0xEC, 0xF5, 0x66, 0xF3, 0xA9, 0x77, 0x58,
  0x75, 0x6C, 0x53, 0x24, 0xAC, 0x0D, 0x3C
};

unsigned char linux_logo_green[] __initdata = {
  0x99, 0x95, 0x92, 0x8E, 0x8A, 0x86, 0x02, 0x00,
  0xA5, 0xA9, 0xA2, 0x9E, 0xAD, 0x1B, 0x3B, 0x25,
  0x71, 0x65, 0x2C, 0x82, 0x5B, 0x33, 0x13, 0xAD,
  0x0C, 0xB1, 0x92, 0xAB, 0x03, 0x06, 0x16, 0xB6,
  0xCD, 0x88, 0x42, 0x46, 0x4B, 0x94, 0xBB, 0xCA,
  0xC5, 0x1C, 0xAB, 0xA0, 0xD4, 0xE6, 0xED, 0xF3,
  0xC2, 0x73, 0xCA, 0x91, 0x7E, 0x52, 0xF7, 0xE3,
  0x56, 0x5A, 0x49, 0x56, 0x6E, 0xFC, 0x6B, 0x3E,
  0x6B, 0x0D, 0x37, 0x79, 0x51, 0x44, 0x3F, 0x43,
  0x38, 0x3D, 0x48, 0xB9, 0x62, 0xA5, 0x47, 0x48,
  0x49, 0x4A, 0x97, 0x48, 0x81, 0x95, 0x8E, 0xE3,
  0x6D, 0x57, 0x51, 0x51, 0x47, 0xB2, 0x42, 0x46,
  0xDD, 0x5B, 0x87, 0xBE, 0xC7, 0xC8, 0x56, 0x75,
  0x5D, 0x4B, 0x4D, 0xBE, 0x85, 0xA6, 0xBC, 0xC7,
  0xCA, 0xCD, 0xCC, 0xA4, 0x53, 0x4D, 0x9F, 0x55,
  0x52, 0x5E, 0x75, 0x9C, 0xB6, 0xC3, 0xD7, 0xCC,
  0x55, 0x00, 0x6A, 0x59, 0x7D, 0x55, 0x7C, 0xA3,
  0xB7, 0xBF, 0xA5, 0x00, 0x67, 0xC6, 0x47, 0x54,
  0x46, 0xB8, 0xBE, 0xB2, 0x87, 0x52, 0x4B, 0x43,
  0x41, 0xF8, 0x69, 0x96, 0x9B, 0x66, 0xB0, 0x6C,
  0x8E, 0x81, 0xB4, 0x76, 0x76, 0xB9, 0x65, 0x77,
  0x6D, 0xED, 0xE7, 0x67, 0x5F, 0x06, 0x54, 0x6C,
  0xCB, 0x4F, 0x00, 0x2F, 0xC2, 0xB5, 0xB6, 0x30,
  0xC3, 0xAE, 0xC4, 0xCA, 0xC6, 0xB4, 0x7B, 0xAD,
  0xAD, 0xB6, 0xB6, 0xAD, 0x29, 0xAB, 0x93, 0x2E,
  0xBC, 0xBC, 0xC9, 0x53, 0xBF, 0x77, 0x54, 0x3B,
  0x4B, 0x3F, 0x39, 0x19, 0x76, 0x08, 0x2C
};

unsigned char linux_logo_blue[] __initdata = {
  0x99, 0x95, 0x92, 0x8E, 0x8A, 0x86, 0xD6, 0x00,
  0xA5, 0xA9, 0xA2, 0x9E, 0xAD, 0x1B, 0x39, 0x25,
  0x71, 0x65, 0x2C, 0x82, 0x5B, 0x33, 0x13, 0xA7,
  0x0C, 0xB1, 0x58, 0x8A, 0x03, 0x07, 0x16, 0xB6,
  0xCD, 0x5A, 0x42, 0x46, 0x4F, 0x6F, 0x77, 0xCA,
  0xC5, 0x1C, 0x6F, 0xA5, 0xD4, 0xE6, 0xF5, 0xF3,
  0xC2, 0x4D, 0xD1, 0x64, 0x7E, 0x52, 0xF7, 0xE3,
  0x56, 0x49, 0x3C, 0x47, 0x45, 0xFE, 0x3B, 0x41,
  0x6B, 0x09, 0x37, 0x79, 0x39, 0x39, 0x3F, 0x42,
  0x3A, 0x42, 0x5F, 0xB9, 0x62, 0x4C, 0x39, 0x44,
  0x3B, 0x3A, 0xA0, 0x3D, 0x08, 0x08, 0x09, 0xDE,
  0x6D, 0x48, 0x3B, 0x3F, 0x42, 0xF3, 0x36, 0x3C,
  0xDD, 0x06, 0x16, 0x08, 0x13, 0x0A, 0x4B, 0x71,
  0x5D, 0x44, 0x47, 0xBE, 0x08, 0x0C, 0x0D, 0x0C,
  0x19, 0x29, 0x36, 0x06, 0x43, 0x44, 0xBA, 0x45,
  0x50, 0x58, 0x07, 0x07, 0x0D, 0x0E, 0x10, 0x50,
  0x06, 0x42, 0x40, 0x44, 0x79, 0x06, 0x06, 0x0C,
  0x08, 0x08, 0x07, 0x36, 0x4C, 0xE5, 0x42, 0x55,
  0x03, 0x0F, 0x12, 0x06, 0x07, 0x3C, 0x4B, 0x3D,
  0x01, 0xF8, 0x08, 0x0E, 0x0A, 0x69, 0xAC, 0x0C,
  0x0A, 0x27, 0xBB, 0x36, 0x76, 0xC0, 0x04, 0x08,
  0x08, 0xED, 0xEE, 0x68, 0x5F, 0xB2, 0x3B, 0x52,
  0xAC, 0x4F, 0x6F, 0x2D, 0x16, 0x08, 0x59, 0x04,
  0x13, 0x0E, 0x14, 0x17, 0x16, 0x2E, 0x08, 0x0D,
  0x11, 0x14, 0x0D, 0x06, 0x04, 0x08, 0x25, 0x8E,
  0x0E, 0x14, 0x25, 0x9B, 0x1C, 0x16, 0x78, 0x06,
  0x04, 0x03, 0x79, 0x8C, 0x0B, 0xC8, 0x48
};

unsigned char linux_logo[] __initdata = {
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x21, 0x21, 0x22, 0x23, 0x24, 0x24,
  0x25, 0x24, 0x24, 0x25, 0x25, 0x25, 0x25, 0x25,
  0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x23, 0x23,
  0x23, 0x22, 0x22, 0x22, 0x22, 0x21, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x26, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x26, 0x28,
  0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29,
  0x29, 0x28, 0x28, 0x28, 0x2A, 0x2A, 0x2B, 0x2B,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x2B, 0x2B, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x28, 0x28, 0x28, 0x29, 0x29, 0x29, 0x29, 0x29,
  0x29, 0x29, 0x29, 0x2C, 0x29, 0x29, 0x29, 0x28,
  0x28, 0x2A, 0x2B, 0x2B, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x2B, 0x2B, 0x2A, 0x2A,
  0x2A, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x2D, 0x2E, 0x2F, 0x27,
  0x27, 0x26, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x28,
  0x28, 0x29, 0x29, 0x29, 0x29, 0x2C, 0x2C, 0x29,
  0x29, 0x29, 0x28, 0x28, 0x2A, 0x2B, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x2B, 0x2B, 0x2B, 0x2A, 0x2A, 0x2A,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x2F, 0x30, 0x31, 0x32,
  0x27, 0x27, 0x22, 0x22, 0x22, 0x22, 0x21, 0x20,
  0x20, 0x20, 0x2B, 0x2A, 0x28, 0x29, 0x29, 0x29,
  0x2C, 0x2C, 0x2C, 0x29, 0x29, 0x28, 0x2A, 0x2B,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x2B, 0x2B, 0x2A, 0x2A, 0x2A, 0x2A, 0x2B,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x32, 0x33, 0x34, 0x35,
  0x36, 0x27, 0x27, 0x33, 0x25, 0x25, 0x24, 0x24,
  0x24, 0x24, 0x23, 0x21, 0x20, 0x20, 0x2B, 0x2A,
  0x28, 0x29, 0x29, 0x37, 0x2C, 0x2C, 0x29, 0x28,
  0x2A, 0x2B, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2B, 0x2B,
  0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2A, 0x2B, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x2F, 0x32, 0x36, 0x27,
  0x27, 0x27, 0x27, 0x33, 0x33, 0x33, 0x33, 0x33,
  0x33, 0x33, 0x33, 0x25, 0x25, 0x24, 0x23, 0x21,
  0x20, 0x2B, 0x2A, 0x29, 0x29, 0x2C, 0x2C, 0x2C,
  0x29, 0x28, 0x2A, 0x2B, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2B, 0x2B,
  0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x20, 0x21, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x38, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x23, 0x23, 0x24, 0x24,
  0x25, 0x25, 0x33, 0x33, 0x33, 0x33, 0x33, 0x25,
  0x24, 0x22, 0x20, 0x20, 0x2A, 0x28, 0x29, 0x2C,
  0x2C, 0x2C, 0x29, 0x28, 0x2A, 0x2B, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x2B, 0x2B, 0x2B, 0x2B,
  0x2B, 0x2B, 0x2B, 0x20, 0x21, 0x22, 0x23, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x2A, 0x2A, 0x2B, 0x2B,
  0x20, 0x21, 0x22, 0x24, 0x20, 0x39, 0x39, 0x39,
  0x39, 0x39, 0x3A, 0x3B, 0x22, 0x20, 0x2A, 0x28,
  0x29, 0x2C, 0x2C, 0x2C, 0x29, 0x28, 0x2B, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
  0x2B, 0x20, 0x21, 0x22, 0x22, 0x23, 0x24, 0x27,
  0x27, 0x27, 0x3C, 0x36, 0x3C, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x3D, 0x3E, 0x32, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x3D, 0x39, 0x3F, 0x3F,
  0x39, 0x2C, 0x20, 0x20, 0x39, 0x39, 0x39, 0x39,
  0x39, 0x39, 0x39, 0x40, 0x40, 0x41, 0x22, 0x20,
  0x2A, 0x28, 0x2C, 0x2C, 0x2C, 0x29, 0x29, 0x2A,
  0x2B, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x2B, 0x2B, 0x2B, 0x2B, 0x20, 0x20,
  0x21, 0x22, 0x22, 0x22, 0x23, 0x23, 0x22, 0x27,
  0x27, 0x3C, 0x3C, 0x3D, 0x42, 0x3C, 0x27, 0x27,
  0x3C, 0x27, 0x3C, 0x43, 0x44, 0x36, 0x42, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x3D, 0x28, 0x29, 0x2C,
  0x2C, 0x45, 0x20, 0x39, 0x39, 0x39, 0x39, 0x39,
  0x39, 0x46, 0x40, 0x47, 0x40, 0x47, 0x3A, 0x40,
  0x22, 0x20, 0x2A, 0x29, 0x2C, 0x2C, 0x2C, 0x29,
  0x28, 0x2B, 0x2B, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x2B, 0x2B, 0x2B, 0x2B, 0x20, 0x20, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x22, 0x21, 0x20, 0x27,
  0x27, 0x44, 0x28, 0x24, 0x27, 0x2F, 0x3C, 0x27,
  0x27, 0x38, 0x24, 0x2C, 0x2C, 0x48, 0x49, 0x36,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x28, 0x29, 0x29,
  0x4A, 0x20, 0x3A, 0x40, 0x47, 0x40, 0x47, 0x40,
  0x40, 0x47, 0x40, 0x40, 0x39, 0x39, 0x39, 0x4A,
  0x25, 0x24, 0x22, 0x2B, 0x28, 0x29, 0x2C, 0x2C,
  0x29, 0x28, 0x2A, 0x2B, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x2B, 0x2B, 0x20, 0x20, 0x20, 0x21, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x21, 0x20, 0x2B, 0x2A, 0x27,
  0x3D, 0x4B, 0x48, 0x4C, 0x2B, 0x3C, 0x27, 0x3C,
  0x3C, 0x23, 0x4D, 0x4E, 0x4F, 0x50, 0x33, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x39, 0x3F, 0x39,
  0x51, 0x20, 0x39, 0x39, 0x47, 0x40, 0x4D, 0x4D,
  0x40, 0x52, 0x4D, 0x40, 0x47, 0x40, 0x39, 0x39,
  0x53, 0x54, 0x25, 0x24, 0x20, 0x2A, 0x29, 0x2C,
  0x2C, 0x2C, 0x29, 0x2A, 0x2B, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x21, 0x21, 0x22, 0x22,
  0x22, 0x21, 0x20, 0x2B, 0x28, 0x2A, 0x20, 0x27,
  0x36, 0x4F, 0x55, 0x48, 0x56, 0x3D, 0x3C, 0x3C,
  0x32, 0x57, 0x56, 0x58, 0x49, 0x56, 0x56, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x22, 0x20, 0x20,
  0x41, 0x39, 0x39, 0x3A, 0x59, 0x5A, 0x59, 0x5B,
  0x5C, 0x3A, 0x4D, 0x5D, 0x57, 0x39, 0x39, 0x4A,
  0x5E, 0x33, 0x54, 0x33, 0x24, 0x22, 0x2B, 0x28,
  0x2C, 0x2C, 0x2C, 0x29, 0x28, 0x2B, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x21, 0x21, 0x21, 0x22, 0x22, 0x21,
  0x20, 0x2B, 0x2A, 0x2A, 0x20, 0x22, 0x22, 0x27,
  0x5F, 0x2D, 0x3C, 0x60, 0x56, 0x54, 0x61, 0x49,
  0x35, 0x56, 0x34, 0x27, 0x62, 0x27, 0x56, 0x39,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x30, 0x63, 0x54,
  0x40, 0x64, 0x65, 0x66, 0x67, 0x67, 0x68, 0x5F,
  0x2E, 0x69, 0x6A, 0x67, 0x5F, 0x3A, 0x39, 0x2C,
  0x53, 0x23, 0x25, 0x54, 0x33, 0x25, 0x23, 0x20,
  0x2A, 0x29, 0x2C, 0x2C, 0x29, 0x28, 0x2B, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x20, 0x20,
  0x2B, 0x2A, 0x20, 0x22, 0x22, 0x21, 0x2B, 0x27,
  0x62, 0x36, 0x27, 0x33, 0x6B, 0x54, 0x3D, 0x3C,
  0x49, 0x57, 0x27, 0x27, 0x27, 0x27, 0x56, 0x57,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x6C, 0x31, 0x6D,
  0x64, 0x51, 0x6E, 0x2E, 0x2E, 0x6F, 0x5A, 0x70,
  0x70, 0x71, 0x72, 0x67, 0x67, 0x69, 0x73, 0x46,
  0x4A, 0x2A, 0x21, 0x25, 0x33, 0x54, 0x33, 0x24,
  0x20, 0x2A, 0x29, 0x2C, 0x2C, 0x29, 0x28, 0x2B,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x21, 0x21, 0x21, 0x21, 0x20, 0x20, 0x2B,
  0x2B, 0x22, 0x22, 0x22, 0x2B, 0x28, 0x2A, 0x27,
  0x27, 0x39, 0x3C, 0x3D, 0x45, 0x74, 0x75, 0x76,
  0x76, 0x45, 0x27, 0x27, 0x27, 0x27, 0x56, 0x77,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x78, 0x78, 0x5E,
  0x79, 0x7A, 0x7B, 0x6E, 0x5A, 0x5A, 0x70, 0x7C,
  0x70, 0x5B, 0x7D, 0x5A, 0x66, 0x7E, 0x7F, 0x79,
  0x48, 0x6B, 0x2C, 0x20, 0x24, 0x33, 0x54, 0x33,
  0x24, 0x21, 0x2A, 0x29, 0x2C, 0x2C, 0x29, 0x28,
  0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x21, 0x21, 0x20, 0x20, 0x2B, 0x2B, 0x21,
  0x22, 0x22, 0x20, 0x28, 0x2B, 0x20, 0x22, 0x27,
  0x27, 0x80, 0x27, 0x81, 0x82, 0x83, 0x84, 0x85,
  0x74, 0x85, 0x84, 0x27, 0x3C, 0x4F, 0x4F, 0x66,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x22, 0x23, 0x5E,
  0x64, 0x86, 0x79, 0x73, 0x87, 0x88, 0x7C, 0x5A,
  0x5A, 0x71, 0x7D, 0x71, 0x89, 0x79, 0x8A, 0x8A,
  0x51, 0x8B, 0x48, 0x39, 0x2A, 0x22, 0x33, 0x54,
  0x33, 0x25, 0x22, 0x2B, 0x29, 0x2C, 0x2C, 0x29,
  0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x21, 0x20, 0x20, 0x2B, 0x2B, 0x22, 0x23,
  0x21, 0x2A, 0x2A, 0x20, 0x21, 0x23, 0x25, 0x27,
  0x27, 0x55, 0x8C, 0x8D, 0x8E, 0x83, 0x8F, 0x90,
  0x91, 0x92, 0x92, 0x85, 0x85, 0x93, 0x51, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x2A, 0x29, 0x51,
  0x79, 0x79, 0x94, 0x89, 0x89, 0x89, 0x5A, 0x95,
  0x64, 0x88, 0x96, 0x97, 0x7A, 0x73, 0x98, 0x98,
  0x99, 0x50, 0x50, 0x48, 0x6B, 0x28, 0x21, 0x25,
  0x54, 0x54, 0x25, 0x22, 0x2B, 0x29, 0x2C, 0x29,
  0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x2B, 0x20, 0x22, 0x22, 0x20,
  0x2B, 0x2B, 0x20, 0x22, 0x24, 0x25, 0x33, 0x27,
  0x27, 0x9A, 0x9B, 0x9C, 0x9D, 0x83, 0x9E, 0x85,
  0x9F, 0x92, 0x85, 0x85, 0x85, 0x85, 0x92, 0xA0,
  0x27, 0x27, 0x27, 0x27, 0x27, 0xA1, 0x47, 0xA2,
  0xA2, 0x94, 0xA3, 0x94, 0x95, 0x95, 0x73, 0x73,
  0x95, 0x87, 0xA4, 0x5B, 0x97, 0x7B, 0x88, 0x98,
  0xA2, 0x50, 0x48, 0x48, 0x48, 0x8B, 0x29, 0x20,
  0x25, 0x54, 0x54, 0x25, 0x22, 0x2B, 0x29, 0x29,
  0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x21, 0x22, 0x22, 0x2B, 0x2B,
  0x20, 0x21, 0x23, 0x24, 0x25, 0x25, 0x33, 0x27,
  0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0x8F, 0x90, 0x90,
  0x9F, 0x90, 0x85, 0x90, 0x85, 0x74, 0xAA, 0x81,
  0x27, 0x27, 0x27, 0x27, 0x27, 0xAB, 0x40, 0xAC,
  0x79, 0xA3, 0x89, 0xAD, 0x95, 0x6F, 0xAE, 0xAE,
  0xAE, 0x5B, 0x59, 0x88, 0x7B, 0x89, 0x79, 0xAF,
  0xA2, 0x6B, 0x48, 0x48, 0x48, 0x48, 0x50, 0x2C,
  0x20, 0x24, 0x33, 0x54, 0x25, 0x22, 0x2A, 0x2A,
  0x21, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x21, 0x23, 0x22, 0x2B, 0x20, 0x20,
  0x22, 0x23, 0x24, 0x25, 0x24, 0x24, 0x22, 0x27,
  0xB0, 0x8C, 0xAA, 0xB1, 0xB2, 0x84, 0x85, 0x9F,
  0x85, 0x85, 0x85, 0xB3, 0xB4, 0xAA, 0xAA, 0xA0,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x2A, 0xB5,
  0xA3, 0xA3, 0xAC, 0x5D, 0xB6, 0xAE, 0xB7, 0x69,
  0x73, 0x5B, 0x88, 0x89, 0x95, 0x73, 0x99, 0x99,
  0x59, 0x2A, 0x39, 0x48, 0x48, 0x50, 0x48, 0x50,
  0x2C, 0x20, 0x24, 0x33, 0x54, 0x25, 0x21, 0x20,
  0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x21, 0x23, 0x21, 0x2B, 0x20, 0x20, 0x22,
  0x22, 0x24, 0x24, 0x23, 0x22, 0x20, 0x2A, 0x27,
  0x27, 0xB0, 0x8C, 0xA9, 0xB2, 0x9E, 0x91, 0x85,
  0x85, 0x93, 0xB8, 0x75, 0xAA, 0xA7, 0x8C, 0x27,
  0x27, 0x27, 0x33, 0x3C, 0x27, 0x27, 0x2C, 0x7B,
  0x55, 0x79, 0xA3, 0x5D, 0xB9, 0x43, 0x7F, 0x7E,
  0x5F, 0x5A, 0x5A, 0x95, 0x64, 0x73, 0x58, 0x64,
  0x5C, 0x25, 0x2B, 0x3F, 0x48, 0x48, 0x8B, 0x48,
  0x48, 0x2C, 0x20, 0x25, 0x54, 0x33, 0x24, 0x22,
  0x2B, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x23, 0x21, 0x20, 0x20, 0x20, 0x21, 0x22,
  0x24, 0x23, 0x22, 0x21, 0x2B, 0x20, 0x54, 0x27,
  0x27, 0x8B, 0x81, 0xA5, 0x93, 0x93, 0x74, 0xA5,
  0xBA, 0x75, 0xBB, 0xBC, 0xB4, 0x6D, 0x50, 0x6B,
  0x27, 0x27, 0x30, 0x33, 0x49, 0x27, 0x27, 0x5E,
  0x6F, 0x73, 0x94, 0xBD, 0x4E, 0x5D, 0x7F, 0x7F,
  0xB7, 0x68, 0x73, 0x6E, 0xB7, 0x7F, 0x95, 0x97,
  0x47, 0x63, 0x25, 0x20, 0x3F, 0x48, 0x8B, 0x8B,
  0x48, 0x48, 0x2C, 0x20, 0x25, 0x54, 0x33, 0x25,
  0x2B, 0x2B, 0x2B, 0x20, 0x20, 0x20, 0x21, 0x21,
  0x23, 0x21, 0x20, 0x20, 0x20, 0x20, 0x24, 0x24,
  0x22, 0x21, 0x20, 0x2A, 0x33, 0x30, 0x30, 0x27,
  0x27, 0x50, 0xBE, 0xBF, 0x9A, 0xB3, 0x9B, 0xBB,
  0xBB, 0xC0, 0x8C, 0xC1, 0x8B, 0xC2, 0x47, 0x8B,
  0x27, 0x27, 0x38, 0x63, 0x63, 0x27, 0x27, 0xC3,
  0xB5, 0x95, 0x72, 0x95, 0x6F, 0x69, 0x7E, 0x66,
  0x7E, 0x7F, 0x6E, 0x7E, 0x95, 0x95, 0x73, 0x70,
  0x30, 0x30, 0x30, 0x33, 0x20, 0x3F, 0x48, 0x8B,
  0x6B, 0x48, 0x50, 0x29, 0x21, 0x33, 0x54, 0x33,
  0x2A, 0x2B, 0x2B, 0x20, 0x20, 0x21, 0x21, 0x23,
  0x21, 0x20, 0x20, 0x20, 0x20, 0x24, 0x24, 0x22,
  0x20, 0x2B, 0x21, 0xC4, 0x30, 0x60, 0x30, 0x27,
  0x27, 0xC5, 0x8B, 0x39, 0xC6, 0xC7, 0xA6, 0xA6,
  0xC8, 0x9A, 0x3B, 0x39, 0x50, 0x56, 0x56, 0x4F,
  0x33, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x48,
  0x59, 0x94, 0x73, 0xAE, 0xB7, 0xB7, 0x7E, 0x7E,
  0x7E, 0x7E, 0x7E, 0x5A, 0x70, 0x7C, 0x71, 0xC3,
  0x63, 0x30, 0x60, 0x78, 0x54, 0x20, 0x6B, 0x48,
  0x6B, 0x6B, 0x50, 0x50, 0x29, 0x22, 0x33, 0x33,
  0x2A, 0x2B, 0x20, 0x20, 0x21, 0x22, 0x22, 0x22,
  0x21, 0x20, 0x20, 0x20, 0x24, 0x24, 0x20, 0x20,
  0x2B, 0x24, 0x30, 0x60, 0x60, 0x30, 0xAB, 0x27,
  0x27, 0x40, 0x4C, 0x50, 0x39, 0x87, 0xC3, 0x53,
  0x37, 0x48, 0x37, 0x48, 0xC9, 0x56, 0xB9, 0x56,
  0xCA, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x3C,
  0x51, 0x5A, 0x6E, 0xB7, 0xB7, 0x7E, 0x7E, 0x7E,
  0x7E, 0x7E, 0x7F, 0xB7, 0x5A, 0x7C, 0x5B, 0x37,
  0x23, 0x63, 0x31, 0x6C, 0xCB, 0x63, 0x20, 0x6B,
  0x50, 0x3F, 0x39, 0x50, 0x8B, 0x28, 0x24, 0x24,
  0x2B, 0x2B, 0x20, 0x21, 0x22, 0x22, 0x22, 0x21,
  0x20, 0x20, 0x20, 0x23, 0x23, 0x20, 0x20, 0x2B,
  0x33, 0x78, 0xCB, 0x60, 0x30, 0x22, 0x3D, 0x27,
  0x2F, 0x56, 0x4E, 0x8B, 0x6B, 0x39, 0x48, 0x8B,
  0x6B, 0x8B, 0x80, 0xC9, 0xB9, 0xB9, 0x56, 0xB9,
  0x56, 0x34, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x48, 0xB5, 0xB7, 0xB7, 0x7E, 0x7E, 0x2E, 0x7E,
  0x7E, 0x7E, 0x7F, 0x7C, 0x65, 0x71, 0x3A, 0x48,
  0x2C, 0x24, 0x30, 0x6C, 0x34, 0x6C, 0xC4, 0x20,
  0x8B, 0x50, 0x39, 0x39, 0x48, 0x6B, 0x2B, 0x22,
  0x2B, 0x20, 0x21, 0x22, 0x23, 0x23, 0x22, 0x21,
  0x20, 0x2B, 0x23, 0x22, 0x20, 0x2B, 0x2B, 0x54,
  0x60, 0x31, 0xCB, 0x54, 0x20, 0x3D, 0x36, 0x27,
  0x4E, 0xB9, 0x56, 0x56, 0x8B, 0x6B, 0x50, 0x6B,
  0x40, 0x56, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9,
  0x56, 0x56, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x7B, 0x6E, 0xB7, 0xB7, 0xB7, 0x7E, 0x7F,
  0xB7, 0xB7, 0x7F, 0x7E, 0x6F, 0x5B, 0x29, 0x2C,
  0x48, 0x39, 0x24, 0x60, 0x58, 0xAF, 0xCC, 0x63,
  0x20, 0x8B, 0x8B, 0x39, 0x39, 0x48, 0x3F, 0x28,
  0x20, 0x20, 0x22, 0x23, 0x23, 0x23, 0x22, 0x20,
  0x2B, 0x22, 0x22, 0x2B, 0x2B, 0x20, 0x54, 0xCB,
  0x31, 0xCB, 0x25, 0x20, 0x27, 0x27, 0x27, 0x48,
  0xB9, 0x56, 0xB9, 0x56, 0x4F, 0x48, 0x47, 0x57,
  0x56, 0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56,
  0xB9, 0x56, 0x62, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x48, 0x6F, 0x69, 0xB7, 0xB7, 0xB7, 0x7F,
  0xB7, 0xB7, 0xB7, 0x73, 0x59, 0x50, 0x29, 0x2B,
  0x28, 0x8B, 0x39, 0x25, 0x31, 0x55, 0xB6, 0x34,
  0x63, 0x2B, 0x48, 0x6B, 0x2C, 0x39, 0x47, 0x6B,
  0x22, 0x22, 0x23, 0x24, 0x23, 0x22, 0x20, 0x2B,
  0x20, 0x22, 0x2A, 0x2B, 0x20, 0x33, 0xCB, 0x31,
  0x78, 0x24, 0x21, 0xCD, 0x27, 0x27, 0x27, 0x56,
  0x56, 0xB9, 0x56, 0xB9, 0x56, 0x56, 0x56, 0xB9,
  0x56, 0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56,
  0xB9, 0x56, 0xC9, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x41, 0x64, 0xB7, 0xB7, 0xB7, 0x7F,
  0x68, 0xB7, 0xAE, 0xA3, 0x23, 0x39, 0x8B, 0x2A,
  0x20, 0x20, 0x39, 0x6B, 0x25, 0xCC, 0x43, 0x43,
  0x34, 0x63, 0x2A, 0x48, 0x3F, 0x39, 0x6B, 0x6B,
  0x24, 0x23, 0x24, 0x24, 0x23, 0x21, 0x2B, 0x2B,
  0x22, 0x2B, 0x2B, 0x20, 0x24, 0x78, 0x31, 0x30,
  0x23, 0x21, 0x21, 0x27, 0x27, 0x27, 0x80, 0x56,
  0x56, 0xB9, 0x56, 0xB9, 0x56, 0xB9, 0x56, 0xB9,
  0x56, 0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0xB9,
  0x56, 0xB9, 0x56, 0x3C, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0xCE, 0x8A, 0xAE, 0x6F, 0xB7,
  0x6F, 0x89, 0x71, 0x78, 0x63, 0x23, 0x39, 0x6B,
  0x2B, 0x20, 0x20, 0x2C, 0x6B, 0x25, 0x34, 0x42,
  0x42, 0x34, 0x54, 0x29, 0x48, 0x3F, 0x39, 0x3F,
  0x25, 0x24, 0x25, 0x24, 0x22, 0x20, 0x2A, 0x21,
  0x2B, 0x2A, 0x20, 0x22, 0x30, 0x60, 0x30, 0x22,
  0x21, 0x22, 0x27, 0x27, 0x27, 0x2D, 0x4C, 0x56,
  0x56, 0xB9, 0xB9, 0x56, 0xB9, 0xB9, 0x56, 0x56,
  0xB9, 0xB9, 0xB9, 0x56, 0x56, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0x56, 0x2E, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x40, 0x97, 0x95, 0x5A, 0x71,
  0x7C, 0xCE, 0x40, 0x60, 0x31, 0x30, 0x23, 0x3F,
  0x3F, 0x20, 0x20, 0x20, 0x29, 0x8B, 0x33, 0x58,
  0x66, 0x43, 0xCC, 0x25, 0x39, 0x50, 0x6B, 0x2C,
  0x33, 0x25, 0x25, 0x23, 0x20, 0x2A, 0x2B, 0x20,
  0x2A, 0x2B, 0x22, 0x54, 0x30, 0x30, 0x24, 0x22,
  0x21, 0x27, 0x27, 0x27, 0x27, 0xAF, 0x29, 0x4E,
  0x4F, 0xB9, 0x56, 0xB9, 0x4D, 0x4D, 0x77, 0xC9,
  0xB9, 0xB9, 0xB9, 0x56, 0xC9, 0x4D, 0x4D, 0x80,
  0x4C, 0x40, 0xC9, 0x4D, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x27, 0xCF, 0x97, 0x97, 0xCE,
  0x86, 0xD0, 0x54, 0x6C, 0x58, 0x34, 0x60, 0x23,
  0x6B, 0x39, 0x20, 0x20, 0x20, 0x28, 0x6B, 0x54,
  0xD1, 0x66, 0xB6, 0x60, 0x22, 0x6B, 0x8B, 0x2C,
  0x54, 0x33, 0x24, 0x22, 0x2B, 0x28, 0x20, 0x28,
  0x2B, 0x20, 0x25, 0xC4, 0x30, 0x25, 0x22, 0x21,
  0x26, 0x27, 0x27, 0x27, 0x27, 0x20, 0x4B, 0x52,
  0x80, 0x4F, 0xB9, 0x56, 0xB9, 0x80, 0x56, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0x4D, 0x80, 0x50, 0x48,
  0x50, 0x50, 0x50, 0x56, 0x3D, 0x27, 0x36, 0x27,
  0x27, 0x27, 0x27, 0x3C, 0x46, 0xC3, 0x86, 0x86,
  0xD0, 0x39, 0x24, 0x6C, 0xD1, 0x43, 0x43, 0x6C,
  0x24, 0x6B, 0x2C, 0x20, 0x20, 0x20, 0x29, 0x39,
  0x63, 0xD1, 0x42, 0x55, 0xC4, 0x2B, 0x8B, 0x39,
  0x54, 0x25, 0x24, 0x20, 0x2A, 0x2A, 0x28, 0x28,
  0x20, 0x22, 0x54, 0x63, 0x25, 0x24, 0x22, 0x22,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x28, 0x77, 0x56,
  0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0xC9, 0x56, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x4F,
  0x77, 0x47, 0x8B, 0x40, 0x56, 0x27, 0x27, 0x49,
  0x2D, 0x27, 0x27, 0x27, 0x39, 0x40, 0x39, 0x39,
  0x28, 0x3F, 0x39, 0x33, 0x58, 0x66, 0x35, 0x2E,
  0x58, 0x24, 0x8B, 0x29, 0x20, 0x20, 0x20, 0x39,
  0x29, 0x30, 0x55, 0xB6, 0xCC, 0x25, 0x29, 0x39,
  0x54, 0x25, 0x22, 0x2B, 0x29, 0x2A, 0x29, 0x2B,
  0x22, 0x24, 0x54, 0x33, 0x25, 0x22, 0x2B, 0x54,
  0x27, 0x27, 0x62, 0x27, 0x30, 0x80, 0xB9, 0x56,
  0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0x56, 0x4D, 0x8B, 0x77, 0x36, 0x27, 0x27,
  0x3C, 0x2F, 0x27, 0x27, 0x39, 0x39, 0x39, 0x47,
  0x20, 0x2B, 0x2C, 0x39, 0x33, 0xB6, 0x35, 0x35,
  0x35, 0xAF, 0x24, 0x48, 0x2A, 0x20, 0x20, 0x20,
  0x8B, 0x2B, 0x78, 0xAF, 0x58, 0x30, 0x21, 0x28,
  0x33, 0x25, 0x21, 0x28, 0x29, 0x29, 0x28, 0x20,
  0x24, 0x33, 0x54, 0x33, 0x23, 0x20, 0x24, 0xD2,
  0x27, 0x49, 0x27, 0x27, 0x56, 0xB9, 0xB9, 0x56,
  0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0x56, 0xC9, 0x50, 0x56, 0x27, 0x27,
  0x3D, 0x38, 0x3D, 0x27, 0x27, 0x47, 0x39, 0x39,
  0x28, 0x20, 0x20, 0x2A, 0x39, 0x54, 0x43, 0x35,
  0x35, 0x35, 0xAF, 0x23, 0x48, 0x2B, 0x20, 0x20,
  0x2B, 0x48, 0x22, 0x60, 0x34, 0xCB, 0x25, 0x21,
  0x33, 0x24, 0x2B, 0x29, 0x29, 0x29, 0x2B, 0x22,
  0x25, 0x54, 0x54, 0x25, 0x22, 0x2B, 0x33, 0x27,
  0x27, 0x32, 0x27, 0x30, 0x56, 0xB9, 0xB9, 0x56,
  0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0x56, 0x56, 0xC9, 0x4C, 0x36, 0x3C,
  0x62, 0x2F, 0x2E, 0x27, 0x27, 0x54, 0x47, 0x47,
  0x8B, 0x2B, 0x20, 0x20, 0x20, 0x3F, 0x54, 0x2E,
  0x35, 0x35, 0x35, 0x34, 0x21, 0x8B, 0x2A, 0x20,
  0x20, 0x2C, 0x6B, 0x25, 0x60, 0x60, 0x54, 0x23,
  0x25, 0x22, 0x2A, 0x2C, 0x29, 0x28, 0x20, 0x24,
  0x54, 0x63, 0x54, 0x24, 0x2B, 0x22, 0x24, 0x27,
  0x36, 0x27, 0x27, 0x56, 0x56, 0xB9, 0xB9, 0x56,
  0xB9, 0xB9, 0xB9, 0x56, 0x56, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56, 0x4C, 0x36,
  0x66, 0xD3, 0x27, 0x2F, 0x27, 0x54, 0x54, 0x27,
  0x26, 0x6B, 0x20, 0x20, 0x20, 0x20, 0x6B, 0x63,
  0x35, 0x35, 0x35, 0x62, 0xCB, 0x2A, 0x3F, 0x28,
  0x2B, 0x2A, 0x50, 0x29, 0x33, 0x30, 0x54, 0x25,
  0x24, 0x20, 0x29, 0x2C, 0x2C, 0x2A, 0x21, 0x33,
  0xC4, 0xC4, 0x33, 0x21, 0x29, 0x22, 0x27, 0x27,
  0x99, 0x27, 0x31, 0xB9, 0xB9, 0xB9, 0xB9, 0x56,
  0xB9, 0xB9, 0xB9, 0x56, 0x56, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56, 0x56, 0x3D,
  0x3D, 0x3C, 0x3C, 0x55, 0x54, 0x54, 0x54, 0x20,
  0x27, 0x2C, 0x39, 0x20, 0x20, 0x20, 0x20, 0x48,
  0x30, 0x62, 0x35, 0x35, 0x42, 0x54, 0x39, 0x39,
  0x2C, 0x28, 0x3F, 0x8B, 0x20, 0x33, 0x54, 0x24,
  0x22, 0x2B, 0x2C, 0x2C, 0x2C, 0x2B, 0x24, 0x54,
  0x30, 0xC4, 0x25, 0x2B, 0x28, 0x2B, 0x27, 0x3D,
  0x27, 0x27, 0x56, 0xB9, 0xB9, 0xB9, 0xB9, 0x56,
  0xB9, 0xB9, 0x56, 0x56, 0x4F, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0x56, 0x56, 0x27,
  0x20, 0x20, 0x20, 0x54, 0x54, 0x54, 0x54, 0x20,
  0x20, 0x2D, 0x2D, 0x29, 0x20, 0x20, 0x20, 0x20,
  0x48, 0x60, 0x66, 0x35, 0x62, 0x34, 0x22, 0x2C,
  0x2C, 0x3F, 0x6B, 0x48, 0x2C, 0x22, 0x23, 0x23,
  0x20, 0x2A, 0x2C, 0x29, 0x29, 0x20, 0x25, 0xC4,
  0x30, 0x54, 0x22, 0x29, 0x28, 0xD2, 0x27, 0x35,
  0x27, 0x49, 0x56, 0xB9, 0xB9, 0xB9, 0xB9, 0x56,
  0xB9, 0xB9, 0x56, 0x4F, 0x56, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0xB9, 0x56, 0x56, 0x56, 0x40, 0x20,
  0x20, 0x54, 0x54, 0x54, 0x20, 0x20, 0x20, 0x20,
  0x2D, 0x2D, 0x2D, 0x49, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x6B, 0x6C, 0x42, 0x2E, 0xB6, 0x54, 0x28,
  0x29, 0x2C, 0x6B, 0x48, 0x3F, 0x2A, 0x20, 0x22,
  0x2B, 0x28, 0x2C, 0x28, 0x29, 0x20, 0x33, 0x30,
  0x30, 0x54, 0x20, 0x2C, 0x29, 0x27, 0x27, 0x3D,
  0x27, 0x40, 0x56, 0xB9, 0x56, 0x56, 0xB9, 0x56,
  0xB9, 0x56, 0x56, 0x4D, 0x56, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0x56, 0x56, 0x63, 0x56, 0x54, 0x54,
  0x54, 0x54, 0x20, 0xD3, 0x45, 0x51, 0x51, 0x49,
  0x7C, 0x2D, 0x2D, 0x49, 0x49, 0x20, 0x20, 0x20,
  0x20, 0x2A, 0x2A, 0xCC, 0xB6, 0x8A, 0x60, 0x22,
  0x28, 0x29, 0x3F, 0x6B, 0x39, 0x29, 0x2B, 0x20,
  0x28, 0x2C, 0x28, 0x2A, 0x2A, 0x24, 0xC4, 0x30,
  0xC4, 0x33, 0x2B, 0x39, 0xCD, 0x27, 0x3C, 0x27,
  0x27, 0x56, 0xB9, 0x56, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0x56, 0x56, 0x4D, 0x56, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0x56, 0x63, 0x63, 0x49, 0x2D, 0x20,
  0x20, 0x2D, 0xD3, 0x49, 0x66, 0x2D, 0x49, 0x49,
  0x49, 0x49, 0x49, 0x49, 0x49, 0x8B, 0x2B, 0x20,
  0x20, 0x20, 0x39, 0x23, 0x6C, 0xAF, 0xCB, 0x23,
  0x28, 0x28, 0x29, 0x2A, 0x2A, 0x2A, 0x2A, 0x20,
  0x29, 0x39, 0x2B, 0x2B, 0x2B, 0x25, 0x78, 0xC4,
  0x63, 0x23, 0x29, 0x39, 0x27, 0x27, 0x3D, 0x27,
  0x27, 0x56, 0xB9, 0x56, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0x56, 0x56, 0x80, 0x4F, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0xB9, 0xB9, 0x2D, 0x49, 0x2D, 0x49,
  0x49, 0x2D, 0x49, 0x2D, 0x49, 0x2D, 0x2D, 0x2D,
  0x49, 0x49, 0x35, 0x49, 0x2D, 0x2D, 0x39, 0x28,
  0x20, 0x20, 0x2A, 0x28, 0x33, 0x60, 0xC4, 0x22,
  0x2C, 0x2A, 0x2A, 0x22, 0x23, 0x22, 0x20, 0x21,
  0x2C, 0x29, 0x20, 0x2B, 0x2B, 0x54, 0x30, 0xC4,
  0x63, 0x22, 0x2C, 0x27, 0x27, 0x27, 0x3D, 0x27,
  0x27, 0x56, 0x56, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0x56, 0x56, 0x80, 0x56, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0xB9, 0xB9, 0x2D, 0x49, 0x2D, 0x49,
  0x61, 0x49, 0x2D, 0x49, 0x49, 0x2D, 0x2D, 0x49,
  0x49, 0x49, 0x2F, 0x49, 0x2D, 0x78, 0x29, 0x28,
  0x2C, 0x2A, 0x2B, 0x39, 0x2B, 0x25, 0x33, 0x20,
  0x2C, 0x20, 0x2A, 0x24, 0x54, 0x54, 0x23, 0x23,
  0x2C, 0x2A, 0x22, 0x2B, 0x20, 0x63, 0x30, 0x63,
  0xC4, 0x21, 0x39, 0x27, 0x27, 0x27, 0x35, 0x36,
  0x27, 0x56, 0x56, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0x56, 0x80, 0x56, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0xB9, 0x56, 0x2D, 0x49, 0x49, 0x49,
  0x49, 0x27, 0x27, 0x2D, 0x38, 0x27, 0x36, 0x36,
  0x49, 0x27, 0x49, 0x2D, 0x2D, 0x44, 0x24, 0x2B,
  0x20, 0x2C, 0x3F, 0x6B, 0x2A, 0x20, 0x21, 0x28,
  0x2C, 0x20, 0x2B, 0x24, 0x30, 0xCB, 0x63, 0x54,
  0x28, 0x20, 0x24, 0x2B, 0x23, 0x78, 0xC4, 0x63,
  0x63, 0x2B, 0x3F, 0x27, 0x27, 0x27, 0x38, 0x33,
  0x3D, 0xB9, 0x56, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0x56, 0x80, 0x56, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0xB9, 0x56, 0x63, 0x49, 0x49, 0x49,
  0x49, 0x49, 0x3D, 0x3D, 0x27, 0x27, 0x27, 0x2D,
  0x49, 0x49, 0x49, 0x2D, 0x62, 0x5F, 0xC4, 0x20,
  0x22, 0x2A, 0x6B, 0x8B, 0x2C, 0x2B, 0x2A, 0x3F,
  0x3F, 0x2A, 0x21, 0x21, 0xCB, 0x58, 0x6C, 0x60,
  0x20, 0x23, 0x24, 0x2A, 0x25, 0x78, 0x63, 0x63,
  0x54, 0x2A, 0x28, 0x27, 0x27, 0x27, 0x27, 0x62,
  0x3C, 0xB9, 0x56, 0x56, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0x56, 0x56, 0x80, 0x56, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0x49, 0x2D, 0x2D,
  0x2D, 0x3D, 0x2F, 0x3C, 0x2D, 0x3C, 0x27, 0x38,
  0x2D, 0x49, 0x2D, 0x2D, 0xD1, 0x43, 0x30, 0x20,
  0x24, 0x21, 0x21, 0x21, 0x2B, 0x2A, 0x29, 0x8B,
  0x6B, 0x29, 0x2B, 0x2A, 0x30, 0x55, 0x55, 0x34,
  0x22, 0x23, 0x24, 0x29, 0x54, 0x30, 0x63, 0x63,
  0x25, 0x29, 0x22, 0x3C, 0xA5, 0xD4, 0xD5, 0x27,
  0x31, 0x56, 0x56, 0x56, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0x56, 0x56, 0x80, 0xB9, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0x56, 0x2D, 0x2E,
  0x3E, 0x27, 0x27, 0x27, 0x27, 0x27, 0x36, 0x44,
  0x3C, 0x27, 0x2D, 0xC4, 0x78, 0xCC, 0x54, 0x2B,
  0x25, 0x24, 0x63, 0x60, 0x63, 0x24, 0x2A, 0x6B,
  0x3F, 0x39, 0x28, 0x21, 0x33, 0xB6, 0x44, 0x58,
  0x22, 0x23, 0x24, 0x2A, 0x30, 0x30, 0x63, 0x63,
  0x24, 0x39, 0x22, 0xBB, 0x9C, 0xB2, 0x9D, 0xA8,
  0x27, 0x8B, 0x56, 0x56, 0xB9, 0x56, 0xB9, 0xB9,
  0x56, 0xB9, 0x56, 0x80, 0xB9, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0xB9, 0x56, 0x56, 0xD6, 0xD6, 0xD7,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x32,
  0x3D, 0x27, 0x39, 0x33, 0xC4, 0xC4, 0x22, 0x28,
  0x25, 0x54, 0x30, 0xD1, 0xD1, 0x60, 0x23, 0x6B,
  0x3F, 0x39, 0x2C, 0x2B, 0x20, 0x58, 0x8A, 0x58,
  0x22, 0x23, 0x23, 0x2B, 0x78, 0x30, 0xC4, 0xC4,
  0x23, 0x29, 0xBB, 0xBB, 0xD8, 0xB2, 0x9D, 0xA9,
  0xA9, 0x3C, 0x60, 0xB9, 0xB9, 0xB9, 0xB9, 0xB9,
  0x56, 0xB9, 0x56, 0x80, 0xB9, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0xB9, 0x56, 0xD9, 0x85, 0x85, 0x85,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x2D,
  0xA0, 0x83, 0x2C, 0x21, 0x30, 0x33, 0x29, 0x29,
  0x21, 0x33, 0x54, 0x42, 0x66, 0x55, 0xC4, 0x29,
  0x8B, 0x2C, 0x39, 0x28, 0x29, 0x31, 0x44, 0x58,
  0x23, 0x23, 0x21, 0x20, 0x30, 0xC4, 0xC4, 0x30,
  0x21, 0x20, 0xBB, 0xBC, 0xDA, 0xDB, 0xDC, 0xB2,
  0x83, 0xB4, 0x3C, 0x2F, 0xB9, 0x56, 0x56, 0xB9,
  0x56, 0xB9, 0x56, 0x80, 0x56, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0x56, 0x56, 0x56, 0xA7, 0xD4, 0x85, 0x82,
  0x3C, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x61,
  0x9E, 0x90, 0xDD, 0x21, 0x33, 0x25, 0x2C, 0x39,
  0x2A, 0x24, 0x24, 0x42, 0x62, 0x43, 0x34, 0x22,
  0x50, 0x39, 0x2C, 0x2C, 0x2A, 0x54, 0xD1, 0x58,
  0x22, 0x22, 0x2B, 0x22, 0x30, 0xC4, 0x30, 0x60,
  0x20, 0xDE, 0xBB, 0xD9, 0x84, 0x84, 0xDF, 0xA9,
  0xDB, 0xDB, 0x61, 0x27, 0x38, 0x4D, 0x56, 0x56,
  0x56, 0xB9, 0x56, 0xB9, 0x56, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0x56, 0x56, 0x56, 0x8D, 0xD9, 0xD5, 0xA6,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0xBB,
  0x85, 0xDB, 0xDD, 0x21, 0x22, 0x22, 0x3F, 0x39,
  0x2C, 0x2B, 0x25, 0x34, 0x62, 0x66, 0xD1, 0xC4,
  0x6B, 0x39, 0x2C, 0x39, 0x29, 0x21, 0x58, 0xCC,
  0x22, 0x21, 0x29, 0x23, 0x30, 0x30, 0x30, 0x5E,
  0x82, 0xBB, 0xE0, 0xB1, 0xE1, 0x9C, 0xD4, 0xDC,
  0x9D, 0xA9, 0xE2, 0x27, 0x27, 0x27, 0x4D, 0x56,
  0x56, 0xB9, 0x56, 0xB9, 0x56, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0x56, 0x4C, 0x48, 0xA8, 0xA8, 0xE3, 0x8C,
  0xC6, 0x3C, 0x27, 0x27, 0x27, 0xE4, 0xA6, 0xE5,
  0x83, 0xA9, 0xE6, 0xAF, 0x54, 0x2B, 0x8B, 0x39,
  0x39, 0x29, 0x20, 0x54, 0x42, 0x42, 0xB6, 0xCC,
  0x2A, 0x29, 0x39, 0x39, 0x2C, 0x2C, 0xCC, 0xCC,
  0x22, 0x20, 0x39, 0xE7, 0xC0, 0xD9, 0xA7, 0xBC,
  0x8D, 0xAA, 0x9C, 0xE8, 0x9C, 0x9D, 0xD4, 0xD4,
  0xD8, 0xA9, 0x84, 0xC7, 0x27, 0x27, 0x27, 0x2A,
  0x56, 0x56, 0x56, 0xB9, 0x56, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0x56, 0x56, 0x48, 0x50, 0xAA, 0xE3, 0xE3, 0xC0,
  0xA6, 0x9A, 0xBA, 0xC8, 0x9A, 0xDE, 0x9B, 0xD5,
  0xE8, 0xD8, 0xD5, 0x2E, 0x58, 0x33, 0x6B, 0x39,
  0x2C, 0x39, 0x29, 0x28, 0xD1, 0x43, 0xB6, 0xAF,
  0x23, 0x28, 0x2C, 0x39, 0x39, 0x8B, 0x30, 0x31,
  0x21, 0x20, 0x3F, 0xBB, 0xDF, 0xDF, 0xD5, 0xA8,
  0xD5, 0x9C, 0x8E, 0xB2, 0x9D, 0xE9, 0xD4, 0xD8,
  0x90, 0xB2, 0xA9, 0x8F, 0x27, 0x27, 0x27, 0x27,
  0x2F, 0x56, 0x56, 0xB9, 0x56, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0x56, 0xB9, 0x48, 0x48, 0x75, 0xE3, 0xAA, 0xAA,
  0xC0, 0xB4, 0xB4, 0xB4, 0x75, 0x9B, 0xD9, 0x83,
  0x9D, 0x90, 0xDF, 0xDD, 0x8A, 0x31, 0x4B, 0x2C,
  0x2C, 0x29, 0x2C, 0x3F, 0x6C, 0x55, 0xD1, 0x55,
  0x54, 0x29, 0x28, 0x39, 0x39, 0x6B, 0x24, 0x60,
  0x20, 0x2B, 0x3F, 0xA7, 0xB1, 0x9D, 0xA9, 0x8E,
  0xE5, 0xE5, 0xDF, 0xE0, 0xA9, 0x9D, 0xDF, 0xDF,
  0xEA, 0x9D, 0xB2, 0x84, 0xAA, 0x27, 0x27, 0x27,
  0x27, 0x35, 0x56, 0x56, 0x56, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0xB9, 0x48, 0x48, 0xA6, 0x9B, 0xE3, 0xAA,
  0xAA, 0x9B, 0x9B, 0x9B, 0xAA, 0xE3, 0xD5, 0xD4,
  0x9D, 0xA9, 0xA9, 0x9D, 0xEB, 0xAF, 0x23, 0x28,
  0x2C, 0x29, 0x28, 0x39, 0x54, 0xCC, 0xAF, 0x55,
  0x30, 0x29, 0x2B, 0x2C, 0x39, 0x39, 0x2B, 0xC4,
  0x2B, 0x29, 0x39, 0xA7, 0x8E, 0x9D, 0x83, 0xE5,
  0xB1, 0xDB, 0xDC, 0xE0, 0xDC, 0x84, 0xE9, 0x84,
  0x83, 0xD4, 0xEC, 0x83, 0x8F, 0xE4, 0x27, 0x27,
  0x27, 0x27, 0x56, 0x56, 0x56, 0x56, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0xB9, 0x56, 0x40, 0x50, 0x9A, 0x75, 0xE3, 0xE3,
  0xE3, 0xD9, 0x8D, 0xAA, 0xD9, 0xA8, 0xB2, 0xDC,
  0xB2, 0x8D, 0x84, 0xEA, 0xB1, 0xEB, 0x54, 0x29,
  0x28, 0x2C, 0x2A, 0x28, 0x2B, 0x78, 0xCC, 0x58,
  0xCB, 0x20, 0x20, 0x29, 0x39, 0x39, 0x2C, 0x25,
  0x29, 0x2C, 0x39, 0xBB, 0xD9, 0xD9, 0x9D, 0x9D,
  0xB2, 0xB1, 0xD4, 0xDB, 0xB1, 0x9D, 0xD4, 0xEA,
  0xB1, 0x8D, 0xD8, 0x8E, 0x8F, 0xAA, 0x27, 0x27,
  0x27, 0x3D, 0x56, 0xB9, 0x56, 0xB9, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0x56,
  0x56, 0x56, 0x47, 0xE4, 0xA6, 0x75, 0xAA, 0xA8,
  0x9C, 0x9C, 0xE1, 0x9C, 0x9C, 0x8E, 0xD8, 0x9D,
  0xA9, 0xDB, 0xA9, 0xDC, 0xD8, 0xDA, 0xD4, 0x2B,
  0x20, 0x2C, 0x28, 0x2A, 0x28, 0x63, 0x31, 0x58,
  0xCB, 0x24, 0x20, 0x2B, 0x2C, 0x39, 0x6B, 0x21,
  0x39, 0x6B, 0x2C, 0xC0, 0xE0, 0xB1, 0xB2, 0x9D,
  0x8E, 0xD8, 0xE0, 0xD9, 0x84, 0xDB, 0xD8, 0xB1,
  0x8E, 0xB2, 0xE2, 0x9C, 0x83, 0x9E, 0xBC, 0x3D,
  0xD3, 0x56, 0x56, 0xB9, 0x56, 0xB9, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0xB9, 0xB9,
  0x56, 0x4F, 0x27, 0x61, 0xA6, 0x9B, 0xE3, 0xA9,
  0xE9, 0xD4, 0xDA, 0xDB, 0x8E, 0xE1, 0xE9, 0x8E,
  0xD4, 0xA8, 0xE0, 0x84, 0xE8, 0xB1, 0xDC, 0x9D,
  0x20, 0x29, 0x29, 0x2B, 0x2C, 0x54, 0x78, 0xCC,
  0x78, 0x33, 0x2A, 0x20, 0x29, 0x39, 0x50, 0x2A,
  0x6B, 0x8B, 0x39, 0xC0, 0x8D, 0xB1, 0xE9, 0xA9,
  0xB2, 0xDC, 0x8E, 0xDC, 0xE1, 0xDA, 0xA9, 0x8E,
  0xEA, 0xE2, 0x83, 0xE8, 0x8E, 0x83, 0xE2, 0xED,
  0xB9, 0xB9, 0x56, 0xB9, 0x56, 0xB9, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0x56, 0x56, 0xB9,
  0xC9, 0x27, 0x27, 0xE4, 0xA6, 0x9B, 0xD5, 0xA8,
  0xD4, 0xB2, 0xD8, 0xDA, 0xD9, 0xE8, 0xE9, 0xE8,
  0xD8, 0xB1, 0xDA, 0xB2, 0xE9, 0x8E, 0xEC, 0xDA,
  0x22, 0x20, 0x39, 0x2B, 0x39, 0x24, 0xC4, 0x30,
  0x30, 0x54, 0x22, 0x29, 0x29, 0x39, 0x48, 0x2C,
  0x39, 0x6B, 0x39, 0xC0, 0x8D, 0xB1, 0xE9, 0xB2,
  0xB2, 0x8E, 0xA9, 0xD8, 0xDA, 0xB1, 0xA9, 0xDA,
  0x9C, 0xDC, 0x8E, 0xD4, 0xE8, 0xE8, 0x8F, 0x9B,
  0x4F, 0xB9, 0x56, 0xB9, 0x56, 0xB9, 0xB9, 0xB9,
  0xB9, 0xB9, 0xB9, 0xB9, 0x56, 0x56, 0x4F, 0x6B,
  0x27, 0x27, 0x27, 0xD7, 0xDE, 0xAA, 0xE3, 0xA8,
  0xB2, 0xD5, 0xE5, 0x90, 0xE2, 0xA9, 0xE9, 0xB2,
  0xDA, 0xB2, 0xE1, 0xB2, 0xE9, 0x8E, 0xDA, 0xDF,
  0x78, 0x2A, 0x2C, 0x2A, 0x6B, 0x28, 0x23, 0x54,
  0x63, 0xC4, 0x33, 0x28, 0x2C, 0x39, 0x47, 0x39,
  0x28, 0x2C, 0x29, 0xBB, 0x8D, 0x83, 0xE9, 0xD4,
  0xB2, 0xE9, 0xE9, 0xE8, 0xD4, 0xD8, 0xD4, 0xA9,
  0xDA, 0xB2, 0xE9, 0xA8, 0xB2, 0xA8, 0xD5, 0xAA,
  0xC6, 0x56, 0x56, 0x56, 0x56, 0x56, 0xB9, 0x56,
  0x56, 0x56, 0x56, 0x56, 0x56, 0xC9, 0x27, 0x27,
  0x27, 0x27, 0x27, 0xB8, 0xB4, 0x9B, 0xE3, 0x8E,
  0x9D, 0x8E, 0xB2, 0xE8, 0xE8, 0x8E, 0xB2, 0xDA,
  0xB2, 0x8E, 0xEC, 0xB2, 0x8E, 0xB2, 0xBB, 0x58,
  0xAF, 0x33, 0x50, 0x39, 0x6B, 0x39, 0x29, 0x20,
  0x33, 0x30, 0x78, 0x23, 0x6B, 0x6B, 0x48, 0x6B,
  0x2B, 0x2A, 0x29, 0xBB, 0xE5, 0x9C, 0xB1, 0xB2,
  0xE5, 0x84, 0x8E, 0x9C, 0x84, 0xB2, 0xB2, 0x9D,
  0x84, 0xDF, 0xA9, 0x84, 0x8E, 0xA8, 0xE3, 0x9B,
  0xA6, 0xD7, 0x80, 0x4F, 0x56, 0x56, 0x56, 0x4F,
  0x4F, 0x4F, 0x4F, 0x2A, 0x2D, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0xB8, 0xB4, 0xAA, 0xD5, 0xA9,
  0x9D, 0xB2, 0x90, 0xEA, 0xE9, 0xE2, 0xE1, 0x8E,
  0xB2, 0x9D, 0x8E, 0xB1, 0xA7, 0xEE, 0x63, 0xD1,
  0x2E, 0xCC, 0x28, 0x48, 0x8B, 0x47, 0x6B, 0x28,
  0x23, 0x78, 0x6C, 0x54, 0x29, 0x50, 0x50, 0x6B,
  0x23, 0x20, 0xBB, 0xBC, 0xBB, 0x8D, 0xE3, 0xDF,
  0x9C, 0xA9, 0x8D, 0xA8, 0xD9, 0x90, 0x9D, 0xA9,
  0xDC, 0xA9, 0x83, 0xB2, 0xA9, 0xD4, 0xE3, 0x9B,
  0x8C, 0xEF, 0x27, 0x27, 0x27, 0x3C, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0xF0, 0xB4, 0x9B, 0xE3, 0x84,
  0x9D, 0x84, 0x90, 0xB1, 0xA9, 0x9C, 0xD9, 0xB1,
  0xB2, 0xEA, 0xBB, 0x51, 0x24, 0x30, 0x30, 0x42,
  0x66, 0x58, 0x24, 0x48, 0x50, 0x3F, 0x20, 0x25,
  0x22, 0x60, 0x34, 0x30, 0x20, 0x8B, 0x8B, 0x39,
  0x54, 0x24, 0x2B, 0xC0, 0xC0, 0xC0, 0xBB, 0x9B,
  0xBC, 0xAA, 0xAA, 0xE3, 0xE3, 0x9C, 0xB2, 0xD4,
  0x83, 0xD8, 0xE8, 0x83, 0x84, 0xE8, 0xE5, 0x75,
  0x9A, 0xF0, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0xF0, 0xB4, 0x9B, 0xE3, 0xA8,
  0xA9, 0xD8, 0x8E, 0xEA, 0xA8, 0x9C, 0xD9, 0xE0,
  0xC0, 0x5E, 0x2C, 0x20, 0x54, 0x60, 0x30, 0x66,
  0xB6, 0xCC, 0x63, 0x3F, 0x8B, 0x28, 0x22, 0x33,
  0x23, 0x31, 0xAF, 0x31, 0x22, 0x6B, 0x6B, 0x29,
  0x30, 0x54, 0x22, 0x89, 0xBA, 0xED, 0xA6, 0x8C,
  0xB4, 0xC0, 0xB4, 0x75, 0x75, 0x9B, 0x9B, 0xE5,
  0xA9, 0xD5, 0x8E, 0x8E, 0x9C, 0xE3, 0x75, 0x8C,
  0xC8, 0xF1, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0xF1, 0x9A, 0xB4, 0x9B, 0xE3,
  0xE3, 0xA8, 0xE3, 0xE5, 0xAA, 0xBC, 0xC0, 0x9A,
  0x26, 0x29, 0x20, 0x24, 0x63, 0x60, 0x54, 0x43,
  0x34, 0xCB, 0x30, 0x39, 0x2C, 0x20, 0x24, 0x54,
  0x22, 0x34, 0x34, 0x31, 0x24, 0x3F, 0x2C, 0x2B,
  0x31, 0x30, 0x25, 0x2A, 0x6B, 0x29, 0x20, 0xF2,
  0xBA, 0xBF, 0xC8, 0x9A, 0xA6, 0xA6, 0x8C, 0xB4,
  0x9B, 0xAA, 0xAA, 0xAA, 0x9B, 0x75, 0xDE, 0xBF,
  0x81, 0xEF, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0x27, 0x27, 0xEF, 0xBA, 0x9A, 0xB4, 0x75,
  0x9B, 0x9B, 0x9B, 0xC0, 0xB4, 0x9A, 0xA5, 0xC4,
  0x30, 0x28, 0x22, 0x33, 0x30, 0x30, 0x23, 0x34,
  0x31, 0x30, 0xC4, 0x2C, 0x2B, 0x22, 0x33, 0x63,
  0x21, 0x58, 0x6C, 0x60, 0x25, 0x39, 0x28, 0x2B,
  0xCC, 0x6C, 0x63, 0x20, 0x6B, 0x28, 0x2B, 0x20,
  0x63, 0x43, 0xF3, 0xEF, 0xF0, 0x81, 0xBA, 0xF4,
  0xF4, 0xA6, 0xDE, 0x8C, 0xA6, 0x9A, 0xBA, 0x81,
  0xB0, 0xE4, 0xA1, 0x20, 0x20, 0x23, 0x31, 0xC4,
  0x30, 0x24, 0x33, 0x31, 0x31, 0x60, 0x43, 0x35,
  0x35, 0x55, 0x6C, 0xEF, 0x81, 0xC8, 0x9A, 0xA6,
  0xB4, 0xB4, 0x8C, 0xA6, 0xBA, 0x68, 0x30, 0x30,
  0x30, 0x2B, 0x25, 0x54, 0xC4, 0x54, 0x24, 0x78,
  0x63, 0x63, 0x30, 0x29, 0x21, 0x24, 0x54, 0x63,
  0x23, 0x34, 0xCB, 0x30, 0x25, 0x39, 0x20, 0x20,
  0x58, 0x34, 0x60, 0x23, 0x6B, 0x29, 0x28, 0x20,
  0x22, 0xB6, 0x42, 0xB6, 0x58, 0x54, 0xF5, 0xD7,
  0xA5, 0xBA, 0xBA, 0xBA, 0xBA, 0x81, 0xA5, 0xF1,
  0xE4, 0x2A, 0x39, 0x20, 0x20, 0x20, 0x31, 0x60,
  0x54, 0x28, 0x2B, 0x22, 0x33, 0x30, 0x43, 0x35,
  0x66, 0xD1, 0x34, 0xE4, 0xEF, 0x81, 0xC8, 0x9A,
  0x9A, 0xC8, 0xC8, 0x81, 0xF6, 0x31, 0x63, 0x31,
  0x78, 0x2B, 0x54, 0x63, 0x54, 0x24, 0x23, 0x54,
  0x63, 0x54, 0x63, 0x2C, 0x23, 0x33, 0x63, 0x54,
  0x25, 0x31, 0x78, 0x30, 0x25, 0x3F, 0x20, 0x20,
  0xAF, 0x58, 0xCC, 0x33, 0x39, 0x29, 0x29, 0x2A,
  0x29, 0x58, 0x43, 0x42, 0xD1, 0xCB, 0x2C, 0x2C,
  0x37, 0xCD, 0xEF, 0xB0, 0xF0, 0xB0, 0xEF, 0xE4,
  0x63, 0x20, 0x20, 0x2C, 0x2C, 0x21, 0xCB, 0x78,
  0x54, 0x39, 0x39, 0x28, 0x2B, 0x28, 0x2B, 0xCB,
  0x55, 0xB6, 0xD1, 0x28, 0xE4, 0xD7, 0xB8, 0xF0,
  0xA5, 0xB0, 0xEF, 0x26, 0x23, 0x54, 0x31, 0x58,
  0xCB, 0x20, 0x63, 0x63, 0x25, 0x2B, 0x54, 0x78,
  0x30, 0x63, 0x54, 0x28, 0x33, 0x63, 0x63, 0x33,
  0x54, 0x78, 0xC4, 0x30, 0x24, 0x2C, 0x22, 0x22,
  0x55, 0x55, 0x34, 0x30, 0x28, 0x2C, 0x29, 0x29,
  0x28, 0x30, 0xB6, 0x42, 0x43, 0x55, 0x22, 0x29,
  0x2C, 0x2B, 0x2B, 0x3F, 0xE4, 0xE4, 0x43, 0x66,
  0x30, 0x23, 0x24, 0x2A, 0x28, 0x2B, 0x54, 0x63,
  0x33, 0x39, 0x28, 0x20, 0x20, 0x20, 0x2B, 0x31,
  0x30, 0xD1, 0x43, 0x30, 0x39, 0x28, 0xE4, 0xE4,
  0xD7, 0xF5, 0x2B, 0x6B, 0x20, 0x30, 0x34, 0xD1,
  0x60, 0x23, 0x63, 0x54, 0x22, 0x47, 0x60, 0xCB,
  0xC4, 0xC4, 0x25, 0x22, 0x54, 0xC4, 0x63, 0x23,
  0xC4, 0xC4, 0x63, 0xC4, 0x23, 0x2A, 0x24, 0x22,
  0x55, 0x55, 0xAF, 0x6C, 0x22, 0x39, 0x2C, 0x39,
  0x28, 0x23, 0xD1, 0x43, 0x42, 0x8A, 0x63, 0x39,
  0x39, 0x2A, 0x20, 0x6B, 0x33, 0xCC, 0xD1, 0xB6,
  0x30, 0x24, 0x54, 0x63, 0x31, 0xCC, 0xCC, 0xCB,
  0xC4, 0x2A, 0x39, 0x20, 0x20, 0x20, 0x39, 0x30,
  0x30, 0x6C, 0x43, 0x43, 0x6C, 0x63, 0x25, 0x24,
  0x63, 0x63, 0x63, 0x25, 0x63, 0xCC, 0xD1, 0x34,
  0x63, 0x25, 0x54, 0x25, 0x2A, 0x28, 0x31, 0xCB,
  0x63, 0x78, 0x24, 0x33, 0xC4, 0xC4, 0x33, 0x2C,
  0xC4, 0x54, 0x54, 0x30, 0x21, 0x22, 0x25, 0x23,
  0x55, 0x55, 0xD1, 0x58, 0x33, 0x6B, 0x2C, 0x39,
  0x39, 0x39, 0x34, 0x43, 0x42, 0x43, 0xCC, 0x2B,
  0x28, 0x29, 0x20, 0x28, 0x21, 0x30, 0xCC, 0xAF,
  0x54, 0x23, 0xC4, 0x54, 0x58, 0x2E, 0x35, 0x42,
  0x55, 0x54, 0x8B, 0x2A, 0x20, 0x20, 0x28, 0x22,
  0x78, 0x30, 0xD1, 0x43, 0x44, 0x6C, 0xC4, 0xC4,
  0x60, 0x31, 0x31, 0x63, 0x6C, 0xAF, 0xCC, 0xCB,
  0x24, 0x25, 0x33, 0x23, 0x2C, 0x24, 0x31, 0x30,
  0x63, 0xC4, 0x21, 0x54, 0x30, 0x63, 0x24, 0x2A,
  0x54, 0x63, 0x54, 0xC4, 0x2B, 0x24, 0x33, 0x24,
  0x34, 0x55, 0xD1, 0x55, 0x30, 0x28, 0x29, 0x39,
  0x39, 0x8B, 0x63, 0x55, 0x42, 0x66, 0xB6, 0x25,
  0x29, 0x29, 0x29, 0x28, 0x2A, 0x54, 0x78, 0x6C,
  0x23, 0x20, 0x25, 0x30, 0xCB, 0x62, 0x35, 0x35,
  0x35, 0x44, 0x24, 0x6B, 0x29, 0x20, 0x2A, 0x39,
  0x28, 0x63, 0x34, 0xB6, 0x34, 0xCB, 0x63, 0x30,
  0x31, 0x31, 0x30, 0x30, 0xCC, 0x60, 0x63, 0xC4,
  0x20, 0x33, 0x25, 0x20, 0x48, 0x33, 0x30, 0x54,
  0x78, 0x54, 0x2B, 0x63, 0x30, 0x63, 0x23, 0x22,
  0x63, 0x63, 0x63, 0x33, 0x28, 0x25, 0x54, 0x24,
  0x78, 0xAF, 0xD1, 0xD1, 0xCC, 0x22, 0x39, 0x39,
  0x2C, 0x3F, 0x2B, 0x34, 0xB6, 0x43, 0x43, 0xC4,
  0x2B, 0x28, 0x39, 0x50, 0x2C, 0x24, 0x63, 0x78,
  0x21, 0x2C, 0x2A, 0x23, 0x54, 0xD1, 0x35, 0x35,
  0x35, 0x35, 0x55, 0x22, 0x39, 0x2C, 0x2C, 0x2C,
  0x20, 0x30, 0xCC, 0x6C, 0xCB, 0x30, 0x54, 0x30,
  0x78, 0x63, 0x78, 0x30, 0x54, 0x78, 0x30, 0x23,
  0x2B, 0x33, 0x24, 0x28, 0x39, 0x24, 0x54, 0x30,
  0x78, 0x33, 0x25, 0xC4, 0xC4, 0x33, 0x39, 0x25,
  0xC4, 0x63, 0xC4, 0x24, 0x20, 0x54, 0x54, 0x25,
  0x63, 0xCC, 0xD1, 0xB6, 0x55, 0x54, 0x39, 0x29,
  0x39, 0x2C, 0x6B, 0x30, 0xAF, 0xB6, 0xB6, 0x60,
  0x22, 0x2A, 0x2C, 0x39, 0x2C, 0x21, 0x54, 0x63,
  0x21, 0x50, 0x2C, 0x2C, 0x2B, 0x25, 0x62, 0x35,
  0x35, 0x35, 0x35, 0xCC, 0x2B, 0x29, 0x2B, 0x20,
  0x23, 0x25, 0xC4, 0x30, 0xC4, 0x63, 0x63, 0x63,
  0x63, 0x33, 0x24, 0x31, 0x31, 0x31, 0x54, 0x28,
  0x24, 0x25, 0x22, 0x6B, 0x28, 0x24, 0xC4, 0x78,
  0x30, 0x24, 0x63, 0xC4, 0x54, 0x23, 0x29, 0x63,
  0xC4, 0x54, 0xC4, 0x21, 0x24, 0x54, 0x54, 0x25,
  0x30, 0xCB, 0xD1, 0xB6, 0x55, 0x63, 0x28, 0x29,
  0x39, 0x39, 0x48, 0x33, 0x58, 0x44, 0xB6, 0x60,
  0x24, 0x20, 0x2B, 0x28, 0x2A, 0x22, 0x54, 0x63,
  0x21, 0x48, 0x2A, 0x2B, 0x39, 0x21, 0xB6, 0x35,
  0x35, 0x35, 0x35, 0x42, 0x23, 0x29, 0x2A, 0x2B,
  0x23, 0x25, 0x54, 0x54, 0x54, 0x63, 0x63, 0x30,
  0x25, 0x2B, 0x31, 0x31, 0x31, 0x31, 0x21, 0x2C,
  0x33, 0x25, 0x21, 0x39, 0x20, 0x25, 0x30, 0x78,
  0xC4, 0x23, 0xC4, 0x30, 0x54, 0x20, 0x28, 0x63,
  0x63, 0x63, 0x63, 0x20, 0x25, 0x54, 0x54, 0x20,
};

unsigned char linux_logo_bw[] __initdata = {
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x3F,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F,
  0xFE, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFE, 0x3F, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xC7, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xC3,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF,
  0xFB, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFD, 0xFF, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xF1, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xF1,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF,
  0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF9, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xF9, 0xCF, 0xC3, 0xF8, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x87, 0x81, 0xF9,
  0xF8, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xA7,
  0x99, 0xF9, 0xC2, 0x40, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF9, 0xF3, 0xBC, 0xF9, 0x90, 0x00, 0x1F, 0xFF,
  0xFF, 0xFF, 0xF9, 0xE3, 0xBC, 0xF9, 0xA0, 0x00,
  0x8F, 0xFF, 0xFF, 0xFF, 0xF9, 0xB0, 0x3C, 0xF9,
  0x83, 0xE0, 0x2F, 0xFF, 0xFF, 0xFF, 0xF9, 0xB0,
  0x19, 0xF0, 0x1F, 0xFE, 0x0F, 0xFF, 0xFF, 0xFF,
  0xF9, 0xC0, 0x03, 0xF0, 0x3F, 0xF7, 0x8F, 0xFF,
  0xFF, 0xFF, 0xF9, 0x80, 0x01, 0xF8, 0x7F, 0xF7,
  0xC7, 0xFF, 0xFF, 0xFF, 0xF9, 0x80, 0x01, 0xF8,
  0x6F, 0xF7, 0xE7, 0xFF, 0xFF, 0xFF, 0xF9, 0x80,
  0x01, 0xF8, 0x7F, 0xF7, 0xE7, 0xFF, 0xFF, 0xFF,
  0xF9, 0xC0, 0x21, 0xD8, 0x7F, 0xE7, 0xEF, 0xFF,
  0xFF, 0xFF, 0xF9, 0xB1, 0x80, 0xEC, 0x7B, 0xFF,
  0xEF, 0xFF, 0xFF, 0xFF, 0xF1, 0x90, 0x00, 0xE4,
  0x7B, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xF1, 0x8C,
  0xC0, 0x7C, 0x79, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF,
  0xE3, 0x80, 0x00, 0x7C, 0x7C, 0xFF, 0xCF, 0xFF,
  0xFF, 0xFF, 0xE3, 0x80, 0x00, 0x7F, 0x77, 0xFF,
  0xDF, 0xFF, 0xFF, 0xFF, 0x87, 0x00, 0x00, 0x3F,
  0x3F, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0x0E, 0x00,
  0x00, 0x3F, 0xBF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF,
  0x1E, 0x00, 0x00, 0x1F, 0x9F, 0xFF, 0x3F, 0xFF,
  0xFF, 0xFE, 0x1C, 0x00, 0x00, 0x1F, 0x9F, 0xFF,
  0x7F, 0xFF, 0xFF, 0xFE, 0x3C, 0x00, 0x00, 0x1F,
  0x8F, 0xFE, 0x7F, 0xFF, 0xFF, 0xFC, 0x7C, 0x00,
  0x00, 0x0F, 0xC7, 0xFC, 0xFF, 0xFF, 0xFF, 0xFC,
  0xF8, 0x00, 0x00, 0x0F, 0xF7, 0xF9, 0xFF, 0xFF,
  0xFF, 0xFC, 0xF8, 0x00, 0x00, 0x07, 0xFB, 0xF3,
  0xFF, 0xFF, 0xFF, 0xF8, 0xF8, 0x00, 0x00, 0x07,
  0xFD, 0xE7, 0xFF, 0xFF, 0xFF, 0xF9, 0xF0, 0x00,
  0x00, 0x03, 0xFE, 0x8F, 0xFF, 0xFF, 0xFF, 0xF1,
  0xF0, 0x00, 0x00, 0x03, 0xFE, 0x1F, 0xFF, 0xFF,
  0xFF, 0xF1, 0xE0, 0x00, 0x00, 0x00, 0xFF, 0xBF,
  0xFF, 0xFF, 0xFF, 0xE3, 0xE0, 0x00, 0x00, 0x00,
  0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xE3, 0xC0, 0x00,
  0x00, 0x00, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xC7,
  0xC0, 0x00, 0x00, 0x01, 0xFE, 0xBF, 0xFF, 0xFF,
  0xFF, 0xC7, 0x80, 0x00, 0x00, 0x01, 0xFE, 0x9F,
  0xFF, 0xFF, 0xFF, 0x8F, 0x80, 0x00, 0x00, 0x01,
  0xFE, 0x07, 0xFF, 0xFF, 0xFF, 0x8F, 0x80, 0x00,
  0x00, 0x01, 0xFE, 0x87, 0xFF, 0xFF, 0xFF, 0x9F,
  0x80, 0x00, 0x00, 0x01, 0xFD, 0x33, 0xFF, 0xFF,
  0xFF, 0x9F, 0x80, 0x00, 0x00, 0x01, 0x80, 0xF3,
  0xFF, 0xFF, 0xFF, 0x9E, 0x80, 0x00, 0x00, 0x03,
  0x8B, 0xF9, 0xFF, 0xFF, 0xFF, 0x9F, 0x80, 0x00,
  0x00, 0x02, 0x27, 0xF8, 0xFF, 0xFF, 0xFF, 0x99,
  0x80, 0x00, 0x00, 0x00, 0x07, 0xF8, 0xFF, 0xFF,
  0xFF, 0x00, 0x80, 0x00, 0x00, 0x01, 0x8F, 0xF8,
  0xFF, 0xFF, 0xFE, 0x20, 0x60, 0x00, 0x00, 0x00,
  0xE3, 0xF8, 0xFF, 0xFF, 0xF8, 0x00, 0x30, 0x00,
  0x00, 0x00, 0xF8, 0x78, 0xFF, 0xFF, 0xC0, 0x40,
  0x38, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x7F, 0xFF,
  0x81, 0x00, 0x1C, 0x00, 0x00, 0x00, 0xFC, 0x20,
  0x7F, 0xFF, 0x90, 0x00, 0x1E, 0x00, 0x00, 0x00,
  0x78, 0x10, 0xFF, 0xFF, 0x80, 0x00, 0x0F, 0x80,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x80, 0x00,
  0x07, 0xC0, 0x00, 0x00, 0x00, 0x08, 0xFF, 0xFF,
  0xC0, 0x00, 0x07, 0xC0, 0x00, 0x00, 0x00, 0x04,
  0x7F, 0xFF, 0x80, 0x00, 0x03, 0xC0, 0x00, 0x10,
  0x00, 0x00, 0x1F, 0xFF, 0x80, 0x00, 0x01, 0x80,
  0x00, 0x30, 0x00, 0x00, 0x0F, 0xFF, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x70, 0x00, 0x01, 0x4F, 0xFF,
  0x80, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00,
  0x0F, 0xFF, 0xC0, 0x00, 0x00, 0x80, 0x03, 0xF0,
  0x00, 0x00, 0x8F, 0xFF, 0x80, 0x00, 0x00, 0x40,
  0x0F, 0xF0, 0x00, 0x04, 0x1F, 0xFF, 0x80, 0x00,
  0x00, 0x7F, 0xFF, 0xF0, 0x00, 0x10, 0x1F, 0xFF,
  0xC0, 0x00, 0x00, 0x7F, 0xFF, 0xF0, 0x00, 0x40,
  0xFF, 0xFF, 0x98, 0x00, 0x00, 0xFF, 0xFF, 0xF0,
  0x00, 0x83, 0xFF, 0xFF, 0x81, 0xE0, 0x01, 0xFF,
  0xFF, 0xF8, 0x02, 0x07, 0xFF, 0xFF, 0x80, 0x3F,
  0x07, 0xE0, 0x00, 0x1C, 0x0C, 0x1F, 0xFF, 0xFF,
  0xF8, 0x03, 0xFF, 0x80, 0x00, 0x1F, 0x78, 0x1F,
  0xFF, 0xFF, 0xFF, 0x80, 0x7F, 0x00, 0x07, 0x0F,
  0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0x0C, 0x07,
  0xFF, 0x83, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x1F, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x07, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
};

/* Painted by Johnny Stenback <jst@uwasa.fi> */

unsigned char *linux_serial_image __initdata = "\n"
"         .u$e.\n"
"       .$$$$$:S\n"
"       $\"*$/\"*$$\n"
"       $.`$ . ^F\n"
"       4k+#+T.$F\n"
"       4P+++\"$\"$\n"
"       :R\"+  t$$B\n"
"    ___#       $$$\n"
"    |  |       R$$k\n"
"   dd. | Linux  $!$\n"
"   ddd |  Sparc $9$F\n"
" '!!!!!$       !!#!`\n"
"  !!!!!*     .!!!!!`\n"
"'!!!!!!!W..e$$!!!!!!`    %s\n"
" \"~^^~         ^~~^\n"
"\n";
