/*
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (c) 2001 Silicon Graphics, Inc.  All rights reserved.
 */


#ifndef _ASM_IA64_SN_SN2_SHUB_MMR_H
#define _ASM_IA64_SN_SN2_SHUB_MMR_H

/* ==================================================================== */
/*                   Register "SH_FSB_BINIT_CONTROL"                    */
/*                          FSB BINIT# Control                          */
/* ==================================================================== */

#define SH_FSB_BINIT_CONTROL                     0x0000000120010000
#define SH_FSB_BINIT_CONTROL_MASK                0x0000000000000001
#define SH_FSB_BINIT_CONTROL_INIT                0x0000000000000000

/*   SH_FSB_BINIT_CONTROL_BINIT                                         */
/*   Description:  Assert the FSB's BINIT# Signal                       */
#define SH_FSB_BINIT_CONTROL_BINIT_SHFT          0
#define SH_FSB_BINIT_CONTROL_BINIT_MASK          0x0000000000000001

/* ==================================================================== */
/*                   Register "SH_FSB_RESET_CONTROL"                    */
/*                          FSB Reset Control                           */
/* ==================================================================== */

#define SH_FSB_RESET_CONTROL                     0x0000000120010080
#define SH_FSB_RESET_CONTROL_MASK                0x0000000000000001
#define SH_FSB_RESET_CONTROL_INIT                0x0000000000000000

/*   SH_FSB_RESET_CONTROL_RESET                                         */
/*   Description:  Assert the FSB's RESET# Signal                       */
#define SH_FSB_RESET_CONTROL_RESET_SHFT          0
#define SH_FSB_RESET_CONTROL_RESET_MASK          0x0000000000000001

/* ==================================================================== */
/*                Register "SH_FSB_SYSTEM_AGENT_CONFIG"                 */
/*                    FSB System Agent Configuration                    */
/* ==================================================================== */

#define SH_FSB_SYSTEM_AGENT_CONFIG               0x0000000120010100
#define SH_FSB_SYSTEM_AGENT_CONFIG_MASK          0x00003fff0187fff9
#define SH_FSB_SYSTEM_AGENT_CONFIG_INIT          0x0000000000000000

/*   SH_FSB_SYSTEM_AGENT_CONFIG_RCNT_SCNT_EN                            */
/*   Description:  RCNT/SCNT Assertion Enabled                          */
#define SH_FSB_SYSTEM_AGENT_CONFIG_RCNT_SCNT_EN_SHFT 0
#define SH_FSB_SYSTEM_AGENT_CONFIG_RCNT_SCNT_EN_MASK 0x0000000000000001

/*   SH_FSB_SYSTEM_AGENT_CONFIG_BERR_ASSERT_EN                          */
/*   Description:  BERR Assertion Enabled for Bus Errors                */
#define SH_FSB_SYSTEM_AGENT_CONFIG_BERR_ASSERT_EN_SHFT 3
#define SH_FSB_SYSTEM_AGENT_CONFIG_BERR_ASSERT_EN_MASK 0x0000000000000008

/*   SH_FSB_SYSTEM_AGENT_CONFIG_BERR_SAMPLING_EN                        */
/*   Description:  BERR Sampling Enabled                                */
#define SH_FSB_SYSTEM_AGENT_CONFIG_BERR_SAMPLING_EN_SHFT 4
#define SH_FSB_SYSTEM_AGENT_CONFIG_BERR_SAMPLING_EN_MASK 0x0000000000000010

/*   SH_FSB_SYSTEM_AGENT_CONFIG_BINIT_ASSERT_EN                         */
/*   Description:  BINIT Assertion Enabled                              */
#define SH_FSB_SYSTEM_AGENT_CONFIG_BINIT_ASSERT_EN_SHFT 5
#define SH_FSB_SYSTEM_AGENT_CONFIG_BINIT_ASSERT_EN_MASK 0x0000000000000020

/*   SH_FSB_SYSTEM_AGENT_CONFIG_BNR_THROTTLING_EN                       */
/*   Description:  stutter FSB request assertion                        */
#define SH_FSB_SYSTEM_AGENT_CONFIG_BNR_THROTTLING_EN_SHFT 6
#define SH_FSB_SYSTEM_AGENT_CONFIG_BNR_THROTTLING_EN_MASK 0x0000000000000040

/*   SH_FSB_SYSTEM_AGENT_CONFIG_SHORT_HANG_EN                           */
/*   Description:  use short duration hang timeout                      */
#define SH_FSB_SYSTEM_AGENT_CONFIG_SHORT_HANG_EN_SHFT 7
#define SH_FSB_SYSTEM_AGENT_CONFIG_SHORT_HANG_EN_MASK 0x0000000000000080

/*   SH_FSB_SYSTEM_AGENT_CONFIG_INTA_RSP_DATA                           */
/*   Description:  Interrupt Acknowledge Response Data                  */
#define SH_FSB_SYSTEM_AGENT_CONFIG_INTA_RSP_DATA_SHFT 8
#define SH_FSB_SYSTEM_AGENT_CONFIG_INTA_RSP_DATA_MASK 0x000000000000ff00

/*   SH_FSB_SYSTEM_AGENT_CONFIG_IO_TRANS_RSP                            */
/*   Description:  IO Transaction Response                              */
#define SH_FSB_SYSTEM_AGENT_CONFIG_IO_TRANS_RSP_SHFT 16
#define SH_FSB_SYSTEM_AGENT_CONFIG_IO_TRANS_RSP_MASK 0x0000000000010000

/*   SH_FSB_SYSTEM_AGENT_CONFIG_XTPR_TRANS_RSP                          */
/*   Description:  External Task Priority Register (xTPR) Transaction   */
/*  Response                                                            */
#define SH_FSB_SYSTEM_AGENT_CONFIG_XTPR_TRANS_RSP_SHFT 17
#define SH_FSB_SYSTEM_AGENT_CONFIG_XTPR_TRANS_RSP_MASK 0x0000000000020000

/*   SH_FSB_SYSTEM_AGENT_CONFIG_INTA_TRANS_RSP                          */
/*   Description:  Interrupt Acknowledge Transaction Response           */
#define SH_FSB_SYSTEM_AGENT_CONFIG_INTA_TRANS_RSP_SHFT 18
#define SH_FSB_SYSTEM_AGENT_CONFIG_INTA_TRANS_RSP_MASK 0x0000000000040000

/*   SH_FSB_SYSTEM_AGENT_CONFIG_TDOT                                    */
/*   Description:  Throttle Data-bus Ownership Transitions              */
#define SH_FSB_SYSTEM_AGENT_CONFIG_TDOT_SHFT     23
#define SH_FSB_SYSTEM_AGENT_CONFIG_TDOT_MASK     0x0000000000800000

/*   SH_FSB_SYSTEM_AGENT_CONFIG_SERIALIZE_FSB_EN                        */
/*   Description:  serialize processor transactions                     */
#define SH_FSB_SYSTEM_AGENT_CONFIG_SERIALIZE_FSB_EN_SHFT 24
#define SH_FSB_SYSTEM_AGENT_CONFIG_SERIALIZE_FSB_EN_MASK 0x0000000001000000

/*   SH_FSB_SYSTEM_AGENT_CONFIG_BINIT_EVENT_ENABLES                     */
/*   Description:  FSB error binit enables                              */
#define SH_FSB_SYSTEM_AGENT_CONFIG_BINIT_EVENT_ENABLES_SHFT 32
#define SH_FSB_SYSTEM_AGENT_CONFIG_BINIT_EVENT_ENABLES_MASK 0x00003fff00000000

/* ==================================================================== */
/*                     Register "SH_FSB_VGA_REMAP"                      */
/*                     FSB VGA Address Space Remap                      */
/* ==================================================================== */

#define SH_FSB_VGA_REMAP                         0x0000000120010180
#define SH_FSB_VGA_REMAP_MASK                    0x4001fffffffe0000
#define SH_FSB_VGA_REMAP_INIT                    0x0000000000000000

/*   SH_FSB_VGA_REMAP_OFFSET                                            */
/*   Description:  VGA Remap Node Offset                                */
#define SH_FSB_VGA_REMAP_OFFSET_SHFT             17
#define SH_FSB_VGA_REMAP_OFFSET_MASK             0x0000000ffffe0000

/*   SH_FSB_VGA_REMAP_ASID                                              */
/*   Description:  VGA Remap Address Space ID                           */
#define SH_FSB_VGA_REMAP_ASID_SHFT               36
#define SH_FSB_VGA_REMAP_ASID_MASK               0x0000003000000000

/*   SH_FSB_VGA_REMAP_NID                                               */
/*   Description:  VGA Remap Node ID                                    */
#define SH_FSB_VGA_REMAP_NID_SHFT                38
#define SH_FSB_VGA_REMAP_NID_MASK                0x0001ffc000000000

/*   SH_FSB_VGA_REMAP_VGA_REMAPPING_ENABLED                             */
/*   Description:  VGA Remapping Enabled                                */
#define SH_FSB_VGA_REMAP_VGA_REMAPPING_ENABLED_SHFT 62
#define SH_FSB_VGA_REMAP_VGA_REMAPPING_ENABLED_MASK 0x4000000000000000

/* ==================================================================== */
/*                    Register "SH_FSB_RESET_STATUS"                    */
/*                           FSB Reset Status                           */
/* ==================================================================== */

#define SH_FSB_RESET_STATUS                      0x0000000120020000
#define SH_FSB_RESET_STATUS_MASK                 0x0000000000000001
#define SH_FSB_RESET_STATUS_INIT                 0x0000000000000000

/*   SH_FSB_RESET_STATUS_RESET_IN_PROGRESS                              */
/*   Description:  Reset in Progress                                    */
#define SH_FSB_RESET_STATUS_RESET_IN_PROGRESS_SHFT 0
#define SH_FSB_RESET_STATUS_RESET_IN_PROGRESS_MASK 0x0000000000000001

/* ==================================================================== */
/*               Register "SH_FSB_SYMMETRIC_AGENT_STATUS"               */
/*                      FSB Symmetric Agent Status                      */
/* ==================================================================== */

#define SH_FSB_SYMMETRIC_AGENT_STATUS            0x0000000120020080
#define SH_FSB_SYMMETRIC_AGENT_STATUS_MASK       0x0000000000000007
#define SH_FSB_SYMMETRIC_AGENT_STATUS_INIT       0x0000000000000000

/*   SH_FSB_SYMMETRIC_AGENT_STATUS_CPU_0_ACTIVE                         */
/*   Description:  CPU 0 Active.                                        */
#define SH_FSB_SYMMETRIC_AGENT_STATUS_CPU_0_ACTIVE_SHFT 0
#define SH_FSB_SYMMETRIC_AGENT_STATUS_CPU_0_ACTIVE_MASK 0x0000000000000001

/*   SH_FSB_SYMMETRIC_AGENT_STATUS_CPU_1_ACTIVE                         */
/*   Description:  CPU 1 Active.                                        */
#define SH_FSB_SYMMETRIC_AGENT_STATUS_CPU_1_ACTIVE_SHFT 1
#define SH_FSB_SYMMETRIC_AGENT_STATUS_CPU_1_ACTIVE_MASK 0x0000000000000002

/*   SH_FSB_SYMMETRIC_AGENT_STATUS_CPUS_READY                           */
/*   Description:  The Processors are Ready                             */
#define SH_FSB_SYMMETRIC_AGENT_STATUS_CPUS_READY_SHFT 2
#define SH_FSB_SYMMETRIC_AGENT_STATUS_CPUS_READY_MASK 0x0000000000000004

/* ==================================================================== */
/*                   Register "SH_GFX_CREDIT_COUNT_0"                   */
/*                Graphics-write Credit Count for CPU 0                 */
/* ==================================================================== */

#define SH_GFX_CREDIT_COUNT_0                    0x0000000120030000
#define SH_GFX_CREDIT_COUNT_0_MASK               0x80000000000fffff
#define SH_GFX_CREDIT_COUNT_0_INIT               0x000000000000003f

/*   SH_GFX_CREDIT_COUNT_0_COUNT                                        */
/*   Description:  Credit Count                                         */
#define SH_GFX_CREDIT_COUNT_0_COUNT_SHFT         0
#define SH_GFX_CREDIT_COUNT_0_COUNT_MASK         0x00000000000fffff

/*   SH_GFX_CREDIT_COUNT_0_RESET_GFX_STATE                              */
/*   Description:  Reset GFX state                                      */
#define SH_GFX_CREDIT_COUNT_0_RESET_GFX_STATE_SHFT 63
#define SH_GFX_CREDIT_COUNT_0_RESET_GFX_STATE_MASK 0x8000000000000000

/* ==================================================================== */
/*                   Register "SH_GFX_CREDIT_COUNT_1"                   */
/*                Graphics-write Credit Count for CPU 1                 */
/* ==================================================================== */

#define SH_GFX_CREDIT_COUNT_1                    0x0000000120030080
#define SH_GFX_CREDIT_COUNT_1_MASK               0x80000000000fffff
#define SH_GFX_CREDIT_COUNT_1_INIT               0x000000000000003f

/*   SH_GFX_CREDIT_COUNT_1_COUNT                                        */
/*   Description:  Credit Count                                         */
#define SH_GFX_CREDIT_COUNT_1_COUNT_SHFT         0
#define SH_GFX_CREDIT_COUNT_1_COUNT_MASK         0x00000000000fffff

/*   SH_GFX_CREDIT_COUNT_1_RESET_GFX_STATE                              */
/*   Description:  Reset GFX state                                      */
#define SH_GFX_CREDIT_COUNT_1_RESET_GFX_STATE_SHFT 63
#define SH_GFX_CREDIT_COUNT_1_RESET_GFX_STATE_MASK 0x8000000000000000

/* ==================================================================== */
/*                    Register "SH_GFX_MODE_CNTRL_0"                    */
/*         Graphics credit mode amd message ordering for CPU 0          */
/* ==================================================================== */

#define SH_GFX_MODE_CNTRL_0                      0x0000000120030100
#define SH_GFX_MODE_CNTRL_0_MASK                 0x0000000000000007
#define SH_GFX_MODE_CNTRL_0_INIT                 0x0000000000000003

/*   SH_GFX_MODE_CNTRL_0_DWORD_CREDITS                                  */
/*   Description:  GFX credits are tracked by D-words                   */
#define SH_GFX_MODE_CNTRL_0_DWORD_CREDITS_SHFT   0
#define SH_GFX_MODE_CNTRL_0_DWORD_CREDITS_MASK   0x0000000000000001

/*   SH_GFX_MODE_CNTRL_0_MIXED_MODE_CREDITS                             */
/*   Description:  GFX credits are tracked by D-words and messages      */
#define SH_GFX_MODE_CNTRL_0_MIXED_MODE_CREDITS_SHFT 1
#define SH_GFX_MODE_CNTRL_0_MIXED_MODE_CREDITS_MASK 0x0000000000000002

/*   SH_GFX_MODE_CNTRL_0_RELAXED_ORDERING                               */
/*   Description:  GFX message routing order                            */
#define SH_GFX_MODE_CNTRL_0_RELAXED_ORDERING_SHFT 2
#define SH_GFX_MODE_CNTRL_0_RELAXED_ORDERING_MASK 0x0000000000000004

/* ==================================================================== */
/*                    Register "SH_GFX_MODE_CNTRL_1"                    */
/*         Graphics credit mode amd message ordering for CPU 1          */
/* ==================================================================== */

#define SH_GFX_MODE_CNTRL_1                      0x0000000120030180
#define SH_GFX_MODE_CNTRL_1_MASK                 0x0000000000000007
#define SH_GFX_MODE_CNTRL_1_INIT                 0x0000000000000003

/*   SH_GFX_MODE_CNTRL_1_DWORD_CREDITS                                  */
/*   Description:  GFX credits are tracked by D-words                   */
#define SH_GFX_MODE_CNTRL_1_DWORD_CREDITS_SHFT   0
#define SH_GFX_MODE_CNTRL_1_DWORD_CREDITS_MASK   0x0000000000000001

/*   SH_GFX_MODE_CNTRL_1_MIXED_MODE_CREDITS                             */
/*   Description:  GFX credits are tracked by D-words and messages      */
#define SH_GFX_MODE_CNTRL_1_MIXED_MODE_CREDITS_SHFT 1
#define SH_GFX_MODE_CNTRL_1_MIXED_MODE_CREDITS_MASK 0x0000000000000002

/*   SH_GFX_MODE_CNTRL_1_RELAXED_ORDERING                               */
/*   Description:  GFX message routing order                            */
#define SH_GFX_MODE_CNTRL_1_RELAXED_ORDERING_SHFT 2
#define SH_GFX_MODE_CNTRL_1_RELAXED_ORDERING_MASK 0x0000000000000004

/* ==================================================================== */
/*                Register "SH_GFX_SKID_CREDIT_COUNT_0"                 */
/*              Graphics-write Skid Credit Count for CPU 0              */
/* ==================================================================== */

#define SH_GFX_SKID_CREDIT_COUNT_0               0x0000000120030200
#define SH_GFX_SKID_CREDIT_COUNT_0_MASK          0x00000000000fffff
#define SH_GFX_SKID_CREDIT_COUNT_0_INIT          0x0000000000000030

/*   SH_GFX_SKID_CREDIT_COUNT_0_SKID                                    */
/*   Description:  Skid Credit Count                                    */
#define SH_GFX_SKID_CREDIT_COUNT_0_SKID_SHFT     0
#define SH_GFX_SKID_CREDIT_COUNT_0_SKID_MASK     0x00000000000fffff

/* ==================================================================== */
/*                Register "SH_GFX_SKID_CREDIT_COUNT_1"                 */
/*              Graphics-write Skid Credit Count for CPU 1              */
/* ==================================================================== */

#define SH_GFX_SKID_CREDIT_COUNT_1               0x0000000120030280
#define SH_GFX_SKID_CREDIT_COUNT_1_MASK          0x00000000000fffff
#define SH_GFX_SKID_CREDIT_COUNT_1_INIT          0x0000000000000030

/*   SH_GFX_SKID_CREDIT_COUNT_1_SKID                                    */
/*   Description:  Skid Credit Count                                    */
#define SH_GFX_SKID_CREDIT_COUNT_1_SKID_SHFT     0
#define SH_GFX_SKID_CREDIT_COUNT_1_SKID_MASK     0x00000000000fffff

/* ==================================================================== */
/*                   Register "SH_GFX_STALL_LIMIT_0"                    */
/*                 Graphics-write Stall Limit for CPU 0                 */
/* ==================================================================== */

#define SH_GFX_STALL_LIMIT_0                     0x0000000120030300
#define SH_GFX_STALL_LIMIT_0_MASK                0x0000000003ffffff
#define SH_GFX_STALL_LIMIT_0_INIT                0x0000000000010000

/*   SH_GFX_STALL_LIMIT_0_LIMIT                                         */
/*   Description:  Graphics Stall Limit for CPU 0                       */
#define SH_GFX_STALL_LIMIT_0_LIMIT_SHFT          0
#define SH_GFX_STALL_LIMIT_0_LIMIT_MASK          0x0000000003ffffff

/* ==================================================================== */
/*                   Register "SH_GFX_STALL_LIMIT_1"                    */
/*                 Graphics-write Stall Limit for CPU 1                 */
/* ==================================================================== */

#define SH_GFX_STALL_LIMIT_1                     0x0000000120030380
#define SH_GFX_STALL_LIMIT_1_MASK                0x0000000003ffffff
#define SH_GFX_STALL_LIMIT_1_INIT                0x0000000000010000

/*   SH_GFX_STALL_LIMIT_1_LIMIT                                         */
/*   Description:  Graphics Stall Limit for CPU 1                       */
#define SH_GFX_STALL_LIMIT_1_LIMIT_SHFT          0
#define SH_GFX_STALL_LIMIT_1_LIMIT_MASK          0x0000000003ffffff

/* ==================================================================== */
/*                   Register "SH_GFX_STALL_TIMER_0"                    */
/*                 Graphics-write Stall Timer for CPU 0                 */
/* ==================================================================== */

#define SH_GFX_STALL_TIMER_0                     0x0000000120030400
#define SH_GFX_STALL_TIMER_0_MASK                0x0000000003ffffff
#define SH_GFX_STALL_TIMER_0_INIT                0x0000000000000000

/*   SH_GFX_STALL_TIMER_0_TIMER_VALUE                                   */
/*   Description:  Timer Value                                          */
#define SH_GFX_STALL_TIMER_0_TIMER_VALUE_SHFT    0
#define SH_GFX_STALL_TIMER_0_TIMER_VALUE_MASK    0x0000000003ffffff

/* ==================================================================== */
/*                   Register "SH_GFX_STALL_TIMER_1"                    */
/*                 Graphics-write Stall Timer for CPU 1                 */
/* ==================================================================== */

#define SH_GFX_STALL_TIMER_1                     0x0000000120030480
#define SH_GFX_STALL_TIMER_1_MASK                0x0000000003ffffff
#define SH_GFX_STALL_TIMER_1_INIT                0x0000000000000000

/*   SH_GFX_STALL_TIMER_1_TIMER_VALUE                                   */
/*   Description:  Timer Value                                          */
#define SH_GFX_STALL_TIMER_1_TIMER_VALUE_SHFT    0
#define SH_GFX_STALL_TIMER_1_TIMER_VALUE_MASK    0x0000000003ffffff

/* ==================================================================== */
/*                      Register "SH_GFX_WINDOW_0"                      */
/*                   Graphics-write Window for CPU 0                    */
/* ==================================================================== */

#define SH_GFX_WINDOW_0                          0x0000000120030500
#define SH_GFX_WINDOW_0_MASK                     0x8000000fff000000
#define SH_GFX_WINDOW_0_INIT                     0x0000000000000000

/*   SH_GFX_WINDOW_0_BASE_ADDR                                          */
/*   Description:  Base Address for CPU 0's 16 MB Graphics Window       */
#define SH_GFX_WINDOW_0_BASE_ADDR_SHFT           24
#define SH_GFX_WINDOW_0_BASE_ADDR_MASK           0x0000000fff000000

/*   SH_GFX_WINDOW_0_GFX_WINDOW_EN                                      */
/*   Description:  Graphics Window Enabled                              */
#define SH_GFX_WINDOW_0_GFX_WINDOW_EN_SHFT       63
#define SH_GFX_WINDOW_0_GFX_WINDOW_EN_MASK       0x8000000000000000

/* ==================================================================== */
/*                      Register "SH_GFX_WINDOW_1"                      */
/*                   Graphics-write Window for CPU 1                    */
/* ==================================================================== */

#define SH_GFX_WINDOW_1                          0x0000000120030580
#define SH_GFX_WINDOW_1_MASK                     0x8000000fff000000
#define SH_GFX_WINDOW_1_INIT                     0x0000000000000000

/*   SH_GFX_WINDOW_1_BASE_ADDR                                          */
/*   Description:  Base Address for CPU 1's 16 MB Graphics Window       */
#define SH_GFX_WINDOW_1_BASE_ADDR_SHFT           24
#define SH_GFX_WINDOW_1_BASE_ADDR_MASK           0x0000000fff000000

/*   SH_GFX_WINDOW_1_GFX_WINDOW_EN                                      */
/*   Description:  Graphics Window Enabled                              */
#define SH_GFX_WINDOW_1_GFX_WINDOW_EN_SHFT       63
#define SH_GFX_WINDOW_1_GFX_WINDOW_EN_MASK       0x8000000000000000

/* ==================================================================== */
/*              Register "SH_GFX_INTERRUPT_TIMER_LIMIT_0"               */
/*               Graphics-write Interrupt Limit for CPU 0               */
/* ==================================================================== */

#define SH_GFX_INTERRUPT_TIMER_LIMIT_0           0x0000000120030600
#define SH_GFX_INTERRUPT_TIMER_LIMIT_0_MASK      0x00000000000000ff
#define SH_GFX_INTERRUPT_TIMER_LIMIT_0_INIT      0x0000000000000040

/*   SH_GFX_INTERRUPT_TIMER_LIMIT_0_INTERRUPT_TIMER_LIMIT               */
/*   Description:  GFX Interrupt Timer Limit                            */
#define SH_GFX_INTERRUPT_TIMER_LIMIT_0_INTERRUPT_TIMER_LIMIT_SHFT 0
#define SH_GFX_INTERRUPT_TIMER_LIMIT_0_INTERRUPT_TIMER_LIMIT_MASK 0x00000000000000ff

/* ==================================================================== */
/*              Register "SH_GFX_INTERRUPT_TIMER_LIMIT_1"               */
/*               Graphics-write Interrupt Limit for CPU 1               */
/* ==================================================================== */

#define SH_GFX_INTERRUPT_TIMER_LIMIT_1           0x0000000120030680
#define SH_GFX_INTERRUPT_TIMER_LIMIT_1_MASK      0x00000000000000ff
#define SH_GFX_INTERRUPT_TIMER_LIMIT_1_INIT      0x0000000000000040

/*   SH_GFX_INTERRUPT_TIMER_LIMIT_1_INTERRUPT_TIMER_LIMIT               */
/*   Description:  GFX Interrupt Timer Limit                            */
#define SH_GFX_INTERRUPT_TIMER_LIMIT_1_INTERRUPT_TIMER_LIMIT_SHFT 0
#define SH_GFX_INTERRUPT_TIMER_LIMIT_1_INTERRUPT_TIMER_LIMIT_MASK 0x00000000000000ff

/* ==================================================================== */
/*                   Register "SH_GFX_WRITE_STATUS_0"                   */
/*                   Graphics Write Status for CPU 0                    */
/* ==================================================================== */

#define SH_GFX_WRITE_STATUS_0                    0x0000000120040000
#define SH_GFX_WRITE_STATUS_0_MASK               0x8000000000000001
#define SH_GFX_WRITE_STATUS_0_INIT               0x0000000000000000

/*   SH_GFX_WRITE_STATUS_0_BUSY                                         */
/*   Description:  Busy                                                 */
#define SH_GFX_WRITE_STATUS_0_BUSY_SHFT          0
#define SH_GFX_WRITE_STATUS_0_BUSY_MASK          0x0000000000000001

/*   SH_GFX_WRITE_STATUS_0_RE_ENABLE_GFX_STALL                          */
/*   Description:  Re-enable GFX stall logic for this processor         */
#define SH_GFX_WRITE_STATUS_0_RE_ENABLE_GFX_STALL_SHFT 63
#define SH_GFX_WRITE_STATUS_0_RE_ENABLE_GFX_STALL_MASK 0x8000000000000000

/* ==================================================================== */
/*                   Register "SH_GFX_WRITE_STATUS_1"                   */
/*                   Graphics Write Status for CPU 1                    */
/* ==================================================================== */

#define SH_GFX_WRITE_STATUS_1                    0x0000000120040080
#define SH_GFX_WRITE_STATUS_1_MASK               0x8000000000000001
#define SH_GFX_WRITE_STATUS_1_INIT               0x0000000000000000

/*   SH_GFX_WRITE_STATUS_1_BUSY                                         */
/*   Description:  Busy                                                 */
#define SH_GFX_WRITE_STATUS_1_BUSY_SHFT          0
#define SH_GFX_WRITE_STATUS_1_BUSY_MASK          0x0000000000000001

/*   SH_GFX_WRITE_STATUS_1_RE_ENABLE_GFX_STALL                          */
/*   Description:  Re-enable GFX stall logic for this processor         */
#define SH_GFX_WRITE_STATUS_1_RE_ENABLE_GFX_STALL_SHFT 63
#define SH_GFX_WRITE_STATUS_1_RE_ENABLE_GFX_STALL_MASK 0x8000000000000000

/* ==================================================================== */
/*                        Register "SH_II_INT0"                         */
/*                    SHub II Interrupt 0 Registers                     */
/* ==================================================================== */

#define SH_II_INT0                               0x0000000110000000
#define SH_II_INT0_MASK                          0x00000000000001ff
#define SH_II_INT0_INIT                          0x0000000000000000

/*   SH_II_INT0_IDX                                                     */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_II_INT0_IDX_SHFT                      0
#define SH_II_INT0_IDX_MASK                      0x00000000000000ff

/*   SH_II_INT0_SEND                                                    */
/*   Description:  Send Interrupt Message to PI, This generates a puls  */
#define SH_II_INT0_SEND_SHFT                     8
#define SH_II_INT0_SEND_MASK                     0x0000000000000100

/* ==================================================================== */
/*                     Register "SH_II_INT0_CONFIG"                     */
/*                 SHub II Interrupt 0 Config Registers                 */
/* ==================================================================== */

#define SH_II_INT0_CONFIG                        0x0000000110000080
#define SH_II_INT0_CONFIG_MASK                   0x0003ffffffefffff
#define SH_II_INT0_CONFIG_INIT                   0x0000000000000000

/*   SH_II_INT0_CONFIG_TYPE                                             */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_II_INT0_CONFIG_TYPE_SHFT              0
#define SH_II_INT0_CONFIG_TYPE_MASK              0x0000000000000007

/*   SH_II_INT0_CONFIG_AGT                                              */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_II_INT0_CONFIG_AGT_SHFT               3
#define SH_II_INT0_CONFIG_AGT_MASK               0x0000000000000008

/*   SH_II_INT0_CONFIG_PID                                              */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_II_INT0_CONFIG_PID_SHFT               4
#define SH_II_INT0_CONFIG_PID_MASK               0x00000000000ffff0

/*   SH_II_INT0_CONFIG_BASE                                             */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_II_INT0_CONFIG_BASE_SHFT              21
#define SH_II_INT0_CONFIG_BASE_MASK              0x0003ffffffe00000

/* ==================================================================== */
/*                     Register "SH_II_INT0_ENABLE"                     */
/*                 SHub II Interrupt 0 Enable Registers                 */
/* ==================================================================== */

#define SH_II_INT0_ENABLE                        0x0000000110000200
#define SH_II_INT0_ENABLE_MASK                   0x0000000000000001
#define SH_II_INT0_ENABLE_INIT                   0x0000000000000000

/*   SH_II_INT0_ENABLE_II_ENABLE                                        */
/*   Description:  Enable II Interrupt                                  */
#define SH_II_INT0_ENABLE_II_ENABLE_SHFT         0
#define SH_II_INT0_ENABLE_II_ENABLE_MASK         0x0000000000000001

/* ==================================================================== */
/*                        Register "SH_II_INT1"                         */
/*                    SHub II Interrupt 1 Registers                     */
/* ==================================================================== */

#define SH_II_INT1                               0x0000000110000100
#define SH_II_INT1_MASK                          0x00000000000001ff
#define SH_II_INT1_INIT                          0x0000000000000000

/*   SH_II_INT1_IDX                                                     */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_II_INT1_IDX_SHFT                      0
#define SH_II_INT1_IDX_MASK                      0x00000000000000ff

/*   SH_II_INT1_SEND                                                    */
/*   Description:  Send Interrupt Message to PI, This generates a puls  */
#define SH_II_INT1_SEND_SHFT                     8
#define SH_II_INT1_SEND_MASK                     0x0000000000000100

/* ==================================================================== */
/*                     Register "SH_II_INT1_CONFIG"                     */
/*                 SHub II Interrupt 1 Config Registers                 */
/* ==================================================================== */

#define SH_II_INT1_CONFIG                        0x0000000110000180
#define SH_II_INT1_CONFIG_MASK                   0x0003ffffffefffff
#define SH_II_INT1_CONFIG_INIT                   0x0000000000000000

/*   SH_II_INT1_CONFIG_TYPE                                             */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_II_INT1_CONFIG_TYPE_SHFT              0
#define SH_II_INT1_CONFIG_TYPE_MASK              0x0000000000000007

/*   SH_II_INT1_CONFIG_AGT                                              */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_II_INT1_CONFIG_AGT_SHFT               3
#define SH_II_INT1_CONFIG_AGT_MASK               0x0000000000000008

/*   SH_II_INT1_CONFIG_PID                                              */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_II_INT1_CONFIG_PID_SHFT               4
#define SH_II_INT1_CONFIG_PID_MASK               0x00000000000ffff0

/*   SH_II_INT1_CONFIG_BASE                                             */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_II_INT1_CONFIG_BASE_SHFT              21
#define SH_II_INT1_CONFIG_BASE_MASK              0x0003ffffffe00000

/* ==================================================================== */
/*                     Register "SH_II_INT1_ENABLE"                     */
/*                 SHub II Interrupt 1 Enable Registers                 */
/* ==================================================================== */

#define SH_II_INT1_ENABLE                        0x0000000110000280
#define SH_II_INT1_ENABLE_MASK                   0x0000000000000001
#define SH_II_INT1_ENABLE_INIT                   0x0000000000000000

/*   SH_II_INT1_ENABLE_II_ENABLE                                        */
/*   Description:  Enable II 1 Interrupt                                */
#define SH_II_INT1_ENABLE_II_ENABLE_SHFT         0
#define SH_II_INT1_ENABLE_II_ENABLE_MASK         0x0000000000000001

/* ==================================================================== */
/*                   Register "SH_INT_NODE_ID_CONFIG"                   */
/*                 SHub Interrupt Node ID Configuration                 */
/* ==================================================================== */

#define SH_INT_NODE_ID_CONFIG                    0x0000000110000300
#define SH_INT_NODE_ID_CONFIG_MASK               0x0000000000000fff
#define SH_INT_NODE_ID_CONFIG_INIT               0x0000000000000000

/*   SH_INT_NODE_ID_CONFIG_NODE_ID                                      */
/*   Description:  Node ID for interrupt messages                       */
#define SH_INT_NODE_ID_CONFIG_NODE_ID_SHFT       0
#define SH_INT_NODE_ID_CONFIG_NODE_ID_MASK       0x00000000000007ff

/*   SH_INT_NODE_ID_CONFIG_ID_SEL                                       */
/*   Description:  Select node id for interrupt messages                */
#define SH_INT_NODE_ID_CONFIG_ID_SEL_SHFT        11
#define SH_INT_NODE_ID_CONFIG_ID_SEL_MASK        0x0000000000000800

/* ==================================================================== */
/*                        Register "SH_IPI_INT"                         */
/*               SHub Inter-Processor Interrupt Registers               */
/* ==================================================================== */

#define SH_IPI_INT                               0x0000000110000380
#define SH_IPI_INT_MASK                          0x8ff3ffffffefffff
#define SH_IPI_INT_INIT                          0x0000000000000000

/*   SH_IPI_INT_TYPE                                                    */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_IPI_INT_TYPE_SHFT                     0
#define SH_IPI_INT_TYPE_MASK                     0x0000000000000007

/*   SH_IPI_INT_AGT                                                     */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_IPI_INT_AGT_SHFT                      3
#define SH_IPI_INT_AGT_MASK                      0x0000000000000008

/*   SH_IPI_INT_PID                                                     */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_IPI_INT_PID_SHFT                      4
#define SH_IPI_INT_PID_MASK                      0x00000000000ffff0

/*   SH_IPI_INT_BASE                                                    */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_IPI_INT_BASE_SHFT                     21
#define SH_IPI_INT_BASE_MASK                     0x0003ffffffe00000

/*   SH_IPI_INT_IDX                                                     */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_IPI_INT_IDX_SHFT                      52
#define SH_IPI_INT_IDX_MASK                      0x0ff0000000000000

/*   SH_IPI_INT_SEND                                                    */
/*   Description:  Send Interrupt Message to PI, This generates a puls  */
#define SH_IPI_INT_SEND_SHFT                     63
#define SH_IPI_INT_SEND_MASK                     0x8000000000000000

/* ==================================================================== */
/*                     Register "SH_IPI_INT_ENABLE"                     */
/*           SHub Inter-Processor Interrupt Enable Registers            */
/* ==================================================================== */

#define SH_IPI_INT_ENABLE                        0x0000000110000400
#define SH_IPI_INT_ENABLE_MASK                   0x0000000000000001
#define SH_IPI_INT_ENABLE_INIT                   0x0000000000000000

/*   SH_IPI_INT_ENABLE_PIO_ENABLE                                       */
/*   Description:  Enable PIO Interrupt                                 */
#define SH_IPI_INT_ENABLE_PIO_ENABLE_SHFT        0
#define SH_IPI_INT_ENABLE_PIO_ENABLE_MASK        0x0000000000000001

/* ==================================================================== */
/*                   Register "SH_LOCAL_INT0_CONFIG"                    */
/*                   SHub Local Interrupt 0 Registers                   */
/* ==================================================================== */

#define SH_LOCAL_INT0_CONFIG                     0x0000000110000480
#define SH_LOCAL_INT0_CONFIG_MASK                0x0ff3ffffffefffff
#define SH_LOCAL_INT0_CONFIG_INIT                0x0000000000000000

/*   SH_LOCAL_INT0_CONFIG_TYPE                                          */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_LOCAL_INT0_CONFIG_TYPE_SHFT           0
#define SH_LOCAL_INT0_CONFIG_TYPE_MASK           0x0000000000000007

/*   SH_LOCAL_INT0_CONFIG_AGT                                           */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_LOCAL_INT0_CONFIG_AGT_SHFT            3
#define SH_LOCAL_INT0_CONFIG_AGT_MASK            0x0000000000000008

/*   SH_LOCAL_INT0_CONFIG_PID                                           */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_LOCAL_INT0_CONFIG_PID_SHFT            4
#define SH_LOCAL_INT0_CONFIG_PID_MASK            0x00000000000ffff0

/*   SH_LOCAL_INT0_CONFIG_BASE                                          */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_LOCAL_INT0_CONFIG_BASE_SHFT           21
#define SH_LOCAL_INT0_CONFIG_BASE_MASK           0x0003ffffffe00000

/*   SH_LOCAL_INT0_CONFIG_IDX                                           */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_LOCAL_INT0_CONFIG_IDX_SHFT            52
#define SH_LOCAL_INT0_CONFIG_IDX_MASK            0x0ff0000000000000

/* ==================================================================== */
/*                   Register "SH_LOCAL_INT0_ENABLE"                    */
/*                    SHub Local Interrupt 0 Enable                     */
/* ==================================================================== */

#define SH_LOCAL_INT0_ENABLE                     0x0000000110000500
#define SH_LOCAL_INT0_ENABLE_MASK                0x000000000000f7ff
#define SH_LOCAL_INT0_ENABLE_INIT                0x0000000000000000

/*   SH_LOCAL_INT0_ENABLE_PI_HW_INT                                     */
/*   Description:  Enable PI Hardware interrupt                         */
#define SH_LOCAL_INT0_ENABLE_PI_HW_INT_SHFT      0
#define SH_LOCAL_INT0_ENABLE_PI_HW_INT_MASK      0x0000000000000001

/*   SH_LOCAL_INT0_ENABLE_MD_HW_INT                                     */
/*   Description:  Enable MD Hardware interrupt                         */
#define SH_LOCAL_INT0_ENABLE_MD_HW_INT_SHFT      1
#define SH_LOCAL_INT0_ENABLE_MD_HW_INT_MASK      0x0000000000000002

/*   SH_LOCAL_INT0_ENABLE_XN_HW_INT                                     */
/*   Description:  Enable XN Hardware interrupt                         */
#define SH_LOCAL_INT0_ENABLE_XN_HW_INT_SHFT      2
#define SH_LOCAL_INT0_ENABLE_XN_HW_INT_MASK      0x0000000000000004

/*   SH_LOCAL_INT0_ENABLE_LB_HW_INT                                     */
/*   Description:  Enable LB Hardware interrupt                         */
#define SH_LOCAL_INT0_ENABLE_LB_HW_INT_SHFT      3
#define SH_LOCAL_INT0_ENABLE_LB_HW_INT_MASK      0x0000000000000008

/*   SH_LOCAL_INT0_ENABLE_II_HW_INT                                     */
/*   Description:  Enable II wrapper Hardware interrupt                 */
#define SH_LOCAL_INT0_ENABLE_II_HW_INT_SHFT      4
#define SH_LOCAL_INT0_ENABLE_II_HW_INT_MASK      0x0000000000000010

/*   SH_LOCAL_INT0_ENABLE_PI_CE_INT                                     */
/*   Description:  Enable PI Correctable Error Interrupt                */
#define SH_LOCAL_INT0_ENABLE_PI_CE_INT_SHFT      5
#define SH_LOCAL_INT0_ENABLE_PI_CE_INT_MASK      0x0000000000000020

/*   SH_LOCAL_INT0_ENABLE_MD_CE_INT                                     */
/*   Description:  Enable MD Correctable Error Interrupt                */
#define SH_LOCAL_INT0_ENABLE_MD_CE_INT_SHFT      6
#define SH_LOCAL_INT0_ENABLE_MD_CE_INT_MASK      0x0000000000000040

/*   SH_LOCAL_INT0_ENABLE_XN_CE_INT                                     */
/*   Description:  Enable XN Correctable Error Interrupt                */
#define SH_LOCAL_INT0_ENABLE_XN_CE_INT_SHFT      7
#define SH_LOCAL_INT0_ENABLE_XN_CE_INT_MASK      0x0000000000000080

/*   SH_LOCAL_INT0_ENABLE_PI_UCE_INT                                    */
/*   Description:  Enable PI Correctable Error Interrupt                */
#define SH_LOCAL_INT0_ENABLE_PI_UCE_INT_SHFT     8
#define SH_LOCAL_INT0_ENABLE_PI_UCE_INT_MASK     0x0000000000000100

/*   SH_LOCAL_INT0_ENABLE_MD_UCE_INT                                    */
/*   Description:  Enable MD Correctable Error Interrupt                */
#define SH_LOCAL_INT0_ENABLE_MD_UCE_INT_SHFT     9
#define SH_LOCAL_INT0_ENABLE_MD_UCE_INT_MASK     0x0000000000000200

/*   SH_LOCAL_INT0_ENABLE_XN_UCE_INT                                    */
/*   Description:  Enable XN Correctable Error Interrupt                */
#define SH_LOCAL_INT0_ENABLE_XN_UCE_INT_SHFT     10
#define SH_LOCAL_INT0_ENABLE_XN_UCE_INT_MASK     0x0000000000000400

/*   SH_LOCAL_INT0_ENABLE_SYSTEM_SHUTDOWN_INT                           */
/*   Description:  Enable System Shutdown Interrupt                     */
#define SH_LOCAL_INT0_ENABLE_SYSTEM_SHUTDOWN_INT_SHFT 12
#define SH_LOCAL_INT0_ENABLE_SYSTEM_SHUTDOWN_INT_MASK 0x0000000000001000

/*   SH_LOCAL_INT0_ENABLE_UART_INT                                      */
/*   Description:  Enable Junk Bus UART Interrupt                       */
#define SH_LOCAL_INT0_ENABLE_UART_INT_SHFT       13
#define SH_LOCAL_INT0_ENABLE_UART_INT_MASK       0x0000000000002000

/*   SH_LOCAL_INT0_ENABLE_L1_NMI_INT                                    */
/*   Description:  Enable L1 Controller NMI Interrupt                   */
#define SH_LOCAL_INT0_ENABLE_L1_NMI_INT_SHFT     14
#define SH_LOCAL_INT0_ENABLE_L1_NMI_INT_MASK     0x0000000000004000

/*   SH_LOCAL_INT0_ENABLE_STOP_CLOCK                                    */
/*   Description:  Stop Clock Interrupt                                 */
#define SH_LOCAL_INT0_ENABLE_STOP_CLOCK_SHFT     15
#define SH_LOCAL_INT0_ENABLE_STOP_CLOCK_MASK     0x0000000000008000

/* ==================================================================== */
/*                   Register "SH_LOCAL_INT1_CONFIG"                    */
/*                   SHub Local Interrupt 1 Registers                   */
/* ==================================================================== */

#define SH_LOCAL_INT1_CONFIG                     0x0000000110000580
#define SH_LOCAL_INT1_CONFIG_MASK                0x0ff3ffffffefffff
#define SH_LOCAL_INT1_CONFIG_INIT                0x0000000000000000

/*   SH_LOCAL_INT1_CONFIG_TYPE                                          */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_LOCAL_INT1_CONFIG_TYPE_SHFT           0
#define SH_LOCAL_INT1_CONFIG_TYPE_MASK           0x0000000000000007

/*   SH_LOCAL_INT1_CONFIG_AGT                                           */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_LOCAL_INT1_CONFIG_AGT_SHFT            3
#define SH_LOCAL_INT1_CONFIG_AGT_MASK            0x0000000000000008

/*   SH_LOCAL_INT1_CONFIG_PID                                           */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_LOCAL_INT1_CONFIG_PID_SHFT            4
#define SH_LOCAL_INT1_CONFIG_PID_MASK            0x00000000000ffff0

/*   SH_LOCAL_INT1_CONFIG_BASE                                          */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_LOCAL_INT1_CONFIG_BASE_SHFT           21
#define SH_LOCAL_INT1_CONFIG_BASE_MASK           0x0003ffffffe00000

/*   SH_LOCAL_INT1_CONFIG_IDX                                           */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_LOCAL_INT1_CONFIG_IDX_SHFT            52
#define SH_LOCAL_INT1_CONFIG_IDX_MASK            0x0ff0000000000000

/* ==================================================================== */
/*                   Register "SH_LOCAL_INT1_ENABLE"                    */
/*                    SHub Local Interrupt 1 Enable                     */
/* ==================================================================== */

#define SH_LOCAL_INT1_ENABLE                     0x0000000110000600
#define SH_LOCAL_INT1_ENABLE_MASK                0x000000000000f7ff
#define SH_LOCAL_INT1_ENABLE_INIT                0x0000000000000000

/*   SH_LOCAL_INT1_ENABLE_PI_HW_INT                                     */
/*   Description:  Enable PI Hardware interrupt                         */
#define SH_LOCAL_INT1_ENABLE_PI_HW_INT_SHFT      0
#define SH_LOCAL_INT1_ENABLE_PI_HW_INT_MASK      0x0000000000000001

/*   SH_LOCAL_INT1_ENABLE_MD_HW_INT                                     */
/*   Description:  Enable MD Hardware interrupt                         */
#define SH_LOCAL_INT1_ENABLE_MD_HW_INT_SHFT      1
#define SH_LOCAL_INT1_ENABLE_MD_HW_INT_MASK      0x0000000000000002

/*   SH_LOCAL_INT1_ENABLE_XN_HW_INT                                     */
/*   Description:  Enable XN Hardware interrupt                         */
#define SH_LOCAL_INT1_ENABLE_XN_HW_INT_SHFT      2
#define SH_LOCAL_INT1_ENABLE_XN_HW_INT_MASK      0x0000000000000004

/*   SH_LOCAL_INT1_ENABLE_LB_HW_INT                                     */
/*   Description:  Enable LB Hardware interrupt                         */
#define SH_LOCAL_INT1_ENABLE_LB_HW_INT_SHFT      3
#define SH_LOCAL_INT1_ENABLE_LB_HW_INT_MASK      0x0000000000000008

/*   SH_LOCAL_INT1_ENABLE_II_HW_INT                                     */
/*   Description:  Enable II wrapper Hardware interrupt                 */
#define SH_LOCAL_INT1_ENABLE_II_HW_INT_SHFT      4
#define SH_LOCAL_INT1_ENABLE_II_HW_INT_MASK      0x0000000000000010

/*   SH_LOCAL_INT1_ENABLE_PI_CE_INT                                     */
/*   Description:  Enable PI Correctable Error Interrupt                */
#define SH_LOCAL_INT1_ENABLE_PI_CE_INT_SHFT      5
#define SH_LOCAL_INT1_ENABLE_PI_CE_INT_MASK      0x0000000000000020

/*   SH_LOCAL_INT1_ENABLE_MD_CE_INT                                     */
/*   Description:  Enable MD Correctable Error Interrupt                */
#define SH_LOCAL_INT1_ENABLE_MD_CE_INT_SHFT      6
#define SH_LOCAL_INT1_ENABLE_MD_CE_INT_MASK      0x0000000000000040

/*   SH_LOCAL_INT1_ENABLE_XN_CE_INT                                     */
/*   Description:  Enable XN Correctable Error Interrupt                */
#define SH_LOCAL_INT1_ENABLE_XN_CE_INT_SHFT      7
#define SH_LOCAL_INT1_ENABLE_XN_CE_INT_MASK      0x0000000000000080

/*   SH_LOCAL_INT1_ENABLE_PI_UCE_INT                                    */
/*   Description:  Enable PI Correctable Error Interrupt                */
#define SH_LOCAL_INT1_ENABLE_PI_UCE_INT_SHFT     8
#define SH_LOCAL_INT1_ENABLE_PI_UCE_INT_MASK     0x0000000000000100

/*   SH_LOCAL_INT1_ENABLE_MD_UCE_INT                                    */
/*   Description:  Enable MD Correctable Error Interrupt                */
#define SH_LOCAL_INT1_ENABLE_MD_UCE_INT_SHFT     9
#define SH_LOCAL_INT1_ENABLE_MD_UCE_INT_MASK     0x0000000000000200

/*   SH_LOCAL_INT1_ENABLE_XN_UCE_INT                                    */
/*   Description:  Enable XN Correctable Error Interrupt                */
#define SH_LOCAL_INT1_ENABLE_XN_UCE_INT_SHFT     10
#define SH_LOCAL_INT1_ENABLE_XN_UCE_INT_MASK     0x0000000000000400

/*   SH_LOCAL_INT1_ENABLE_SYSTEM_SHUTDOWN_INT                           */
/*   Description:  Enable System Shutdown Interrupt                     */
#define SH_LOCAL_INT1_ENABLE_SYSTEM_SHUTDOWN_INT_SHFT 12
#define SH_LOCAL_INT1_ENABLE_SYSTEM_SHUTDOWN_INT_MASK 0x0000000000001000

/*   SH_LOCAL_INT1_ENABLE_UART_INT                                      */
/*   Description:  Enable Junk Bus UART Interrupt                       */
#define SH_LOCAL_INT1_ENABLE_UART_INT_SHFT       13
#define SH_LOCAL_INT1_ENABLE_UART_INT_MASK       0x0000000000002000

/*   SH_LOCAL_INT1_ENABLE_L1_NMI_INT                                    */
/*   Description:  Enable L1 Controller NMI Interrupt                   */
#define SH_LOCAL_INT1_ENABLE_L1_NMI_INT_SHFT     14
#define SH_LOCAL_INT1_ENABLE_L1_NMI_INT_MASK     0x0000000000004000

/*   SH_LOCAL_INT1_ENABLE_STOP_CLOCK                                    */
/*   Description:  Stop Clock Interrupt                                 */
#define SH_LOCAL_INT1_ENABLE_STOP_CLOCK_SHFT     15
#define SH_LOCAL_INT1_ENABLE_STOP_CLOCK_MASK     0x0000000000008000

/* ==================================================================== */
/*                   Register "SH_LOCAL_INT2_CONFIG"                    */
/*                   SHub Local Interrupt 2 Registers                   */
/* ==================================================================== */

#define SH_LOCAL_INT2_CONFIG                     0x0000000110000680
#define SH_LOCAL_INT2_CONFIG_MASK                0x0ff3ffffffefffff
#define SH_LOCAL_INT2_CONFIG_INIT                0x0000000000000000

/*   SH_LOCAL_INT2_CONFIG_TYPE                                          */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_LOCAL_INT2_CONFIG_TYPE_SHFT           0
#define SH_LOCAL_INT2_CONFIG_TYPE_MASK           0x0000000000000007

/*   SH_LOCAL_INT2_CONFIG_AGT                                           */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_LOCAL_INT2_CONFIG_AGT_SHFT            3
#define SH_LOCAL_INT2_CONFIG_AGT_MASK            0x0000000000000008

/*   SH_LOCAL_INT2_CONFIG_PID                                           */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_LOCAL_INT2_CONFIG_PID_SHFT            4
#define SH_LOCAL_INT2_CONFIG_PID_MASK            0x00000000000ffff0

/*   SH_LOCAL_INT2_CONFIG_BASE                                          */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_LOCAL_INT2_CONFIG_BASE_SHFT           21
#define SH_LOCAL_INT2_CONFIG_BASE_MASK           0x0003ffffffe00000

/*   SH_LOCAL_INT2_CONFIG_IDX                                           */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_LOCAL_INT2_CONFIG_IDX_SHFT            52
#define SH_LOCAL_INT2_CONFIG_IDX_MASK            0x0ff0000000000000

/* ==================================================================== */
/*                   Register "SH_LOCAL_INT2_ENABLE"                    */
/*                    SHub Local Interrupt 2 Enable                     */
/* ==================================================================== */

#define SH_LOCAL_INT2_ENABLE                     0x0000000110000700
#define SH_LOCAL_INT2_ENABLE_MASK                0x000000000000f7ff
#define SH_LOCAL_INT2_ENABLE_INIT                0x0000000000000000

/*   SH_LOCAL_INT2_ENABLE_PI_HW_INT                                     */
/*   Description:  Enable PI Hardware interrupt                         */
#define SH_LOCAL_INT2_ENABLE_PI_HW_INT_SHFT      0
#define SH_LOCAL_INT2_ENABLE_PI_HW_INT_MASK      0x0000000000000001

/*   SH_LOCAL_INT2_ENABLE_MD_HW_INT                                     */
/*   Description:  Enable MD Hardware interrupt                         */
#define SH_LOCAL_INT2_ENABLE_MD_HW_INT_SHFT      1
#define SH_LOCAL_INT2_ENABLE_MD_HW_INT_MASK      0x0000000000000002

/*   SH_LOCAL_INT2_ENABLE_XN_HW_INT                                     */
/*   Description:  Enable XN Hardware interrupt                         */
#define SH_LOCAL_INT2_ENABLE_XN_HW_INT_SHFT      2
#define SH_LOCAL_INT2_ENABLE_XN_HW_INT_MASK      0x0000000000000004

/*   SH_LOCAL_INT2_ENABLE_LB_HW_INT                                     */
/*   Description:  Enable LB Hardware interrupt                         */
#define SH_LOCAL_INT2_ENABLE_LB_HW_INT_SHFT      3
#define SH_LOCAL_INT2_ENABLE_LB_HW_INT_MASK      0x0000000000000008

/*   SH_LOCAL_INT2_ENABLE_II_HW_INT                                     */
/*   Description:  Enable II wrapper Hardware interrupt                 */
#define SH_LOCAL_INT2_ENABLE_II_HW_INT_SHFT      4
#define SH_LOCAL_INT2_ENABLE_II_HW_INT_MASK      0x0000000000000010

/*   SH_LOCAL_INT2_ENABLE_PI_CE_INT                                     */
/*   Description:  Enable PI Correctable Error Interrupt                */
#define SH_LOCAL_INT2_ENABLE_PI_CE_INT_SHFT      5
#define SH_LOCAL_INT2_ENABLE_PI_CE_INT_MASK      0x0000000000000020

/*   SH_LOCAL_INT2_ENABLE_MD_CE_INT                                     */
/*   Description:  Enable MD Correctable Error Interrupt                */
#define SH_LOCAL_INT2_ENABLE_MD_CE_INT_SHFT      6
#define SH_LOCAL_INT2_ENABLE_MD_CE_INT_MASK      0x0000000000000040

/*   SH_LOCAL_INT2_ENABLE_XN_CE_INT                                     */
/*   Description:  Enable XN Correctable Error Interrupt                */
#define SH_LOCAL_INT2_ENABLE_XN_CE_INT_SHFT      7
#define SH_LOCAL_INT2_ENABLE_XN_CE_INT_MASK      0x0000000000000080

/*   SH_LOCAL_INT2_ENABLE_PI_UCE_INT                                    */
/*   Description:  Enable PI Correctable Error Interrupt                */
#define SH_LOCAL_INT2_ENABLE_PI_UCE_INT_SHFT     8
#define SH_LOCAL_INT2_ENABLE_PI_UCE_INT_MASK     0x0000000000000100

/*   SH_LOCAL_INT2_ENABLE_MD_UCE_INT                                    */
/*   Description:  Enable MD Correctable Error Interrupt                */
#define SH_LOCAL_INT2_ENABLE_MD_UCE_INT_SHFT     9
#define SH_LOCAL_INT2_ENABLE_MD_UCE_INT_MASK     0x0000000000000200

/*   SH_LOCAL_INT2_ENABLE_XN_UCE_INT                                    */
/*   Description:  Enable XN Correctable Error Interrupt                */
#define SH_LOCAL_INT2_ENABLE_XN_UCE_INT_SHFT     10
#define SH_LOCAL_INT2_ENABLE_XN_UCE_INT_MASK     0x0000000000000400

/*   SH_LOCAL_INT2_ENABLE_SYSTEM_SHUTDOWN_INT                           */
/*   Description:  Enable System Shutdown Interrupt                     */
#define SH_LOCAL_INT2_ENABLE_SYSTEM_SHUTDOWN_INT_SHFT 12
#define SH_LOCAL_INT2_ENABLE_SYSTEM_SHUTDOWN_INT_MASK 0x0000000000001000

/*   SH_LOCAL_INT2_ENABLE_UART_INT                                      */
/*   Description:  Enable Junk Bus UART Interrupt                       */
#define SH_LOCAL_INT2_ENABLE_UART_INT_SHFT       13
#define SH_LOCAL_INT2_ENABLE_UART_INT_MASK       0x0000000000002000

/*   SH_LOCAL_INT2_ENABLE_L1_NMI_INT                                    */
/*   Description:  Enable L1 Controller NMI Interrupt                   */
#define SH_LOCAL_INT2_ENABLE_L1_NMI_INT_SHFT     14
#define SH_LOCAL_INT2_ENABLE_L1_NMI_INT_MASK     0x0000000000004000

/*   SH_LOCAL_INT2_ENABLE_STOP_CLOCK                                    */
/*   Description:  Stop Clock Interrupt                                 */
#define SH_LOCAL_INT2_ENABLE_STOP_CLOCK_SHFT     15
#define SH_LOCAL_INT2_ENABLE_STOP_CLOCK_MASK     0x0000000000008000

/* ==================================================================== */
/*                   Register "SH_LOCAL_INT3_CONFIG"                    */
/*                   SHub Local Interrupt 3 Registers                   */
/* ==================================================================== */

#define SH_LOCAL_INT3_CONFIG                     0x0000000110000780
#define SH_LOCAL_INT3_CONFIG_MASK                0x0ff3ffffffefffff
#define SH_LOCAL_INT3_CONFIG_INIT                0x0000000000000000

/*   SH_LOCAL_INT3_CONFIG_TYPE                                          */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_LOCAL_INT3_CONFIG_TYPE_SHFT           0
#define SH_LOCAL_INT3_CONFIG_TYPE_MASK           0x0000000000000007

/*   SH_LOCAL_INT3_CONFIG_AGT                                           */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_LOCAL_INT3_CONFIG_AGT_SHFT            3
#define SH_LOCAL_INT3_CONFIG_AGT_MASK            0x0000000000000008

/*   SH_LOCAL_INT3_CONFIG_PID                                           */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_LOCAL_INT3_CONFIG_PID_SHFT            4
#define SH_LOCAL_INT3_CONFIG_PID_MASK            0x00000000000ffff0

/*   SH_LOCAL_INT3_CONFIG_BASE                                          */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_LOCAL_INT3_CONFIG_BASE_SHFT           21
#define SH_LOCAL_INT3_CONFIG_BASE_MASK           0x0003ffffffe00000

/*   SH_LOCAL_INT3_CONFIG_IDX                                           */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_LOCAL_INT3_CONFIG_IDX_SHFT            52
#define SH_LOCAL_INT3_CONFIG_IDX_MASK            0x0ff0000000000000

/* ==================================================================== */
/*                   Register "SH_LOCAL_INT3_ENABLE"                    */
/*                    SHub Local Interrupt 3 Enable                     */
/* ==================================================================== */

#define SH_LOCAL_INT3_ENABLE                     0x0000000110000800
#define SH_LOCAL_INT3_ENABLE_MASK                0x000000000000f7ff
#define SH_LOCAL_INT3_ENABLE_INIT                0x0000000000000000

/*   SH_LOCAL_INT3_ENABLE_PI_HW_INT                                     */
/*   Description:  Enable PI Hardware interrupt                         */
#define SH_LOCAL_INT3_ENABLE_PI_HW_INT_SHFT      0
#define SH_LOCAL_INT3_ENABLE_PI_HW_INT_MASK      0x0000000000000001

/*   SH_LOCAL_INT3_ENABLE_MD_HW_INT                                     */
/*   Description:  Enable MD Hardware interrupt                         */
#define SH_LOCAL_INT3_ENABLE_MD_HW_INT_SHFT      1
#define SH_LOCAL_INT3_ENABLE_MD_HW_INT_MASK      0x0000000000000002

/*   SH_LOCAL_INT3_ENABLE_XN_HW_INT                                     */
/*   Description:  Enable XN Hardware interrupt                         */
#define SH_LOCAL_INT3_ENABLE_XN_HW_INT_SHFT      2
#define SH_LOCAL_INT3_ENABLE_XN_HW_INT_MASK      0x0000000000000004

/*   SH_LOCAL_INT3_ENABLE_LB_HW_INT                                     */
/*   Description:  Enable LB Hardware interrupt                         */
#define SH_LOCAL_INT3_ENABLE_LB_HW_INT_SHFT      3
#define SH_LOCAL_INT3_ENABLE_LB_HW_INT_MASK      0x0000000000000008

/*   SH_LOCAL_INT3_ENABLE_II_HW_INT                                     */
/*   Description:  Enable II wrapper Hardware interrupt                 */
#define SH_LOCAL_INT3_ENABLE_II_HW_INT_SHFT      4
#define SH_LOCAL_INT3_ENABLE_II_HW_INT_MASK      0x0000000000000010

/*   SH_LOCAL_INT3_ENABLE_PI_CE_INT                                     */
/*   Description:  Enable PI Correctable Error Interrupt                */
#define SH_LOCAL_INT3_ENABLE_PI_CE_INT_SHFT      5
#define SH_LOCAL_INT3_ENABLE_PI_CE_INT_MASK      0x0000000000000020

/*   SH_LOCAL_INT3_ENABLE_MD_CE_INT                                     */
/*   Description:  Enable MD Correctable Error Interrupt                */
#define SH_LOCAL_INT3_ENABLE_MD_CE_INT_SHFT      6
#define SH_LOCAL_INT3_ENABLE_MD_CE_INT_MASK      0x0000000000000040

/*   SH_LOCAL_INT3_ENABLE_XN_CE_INT                                     */
/*   Description:  Enable XN Correctable Error Interrupt                */
#define SH_LOCAL_INT3_ENABLE_XN_CE_INT_SHFT      7
#define SH_LOCAL_INT3_ENABLE_XN_CE_INT_MASK      0x0000000000000080

/*   SH_LOCAL_INT3_ENABLE_PI_UCE_INT                                    */
/*   Description:  Enable PI Correctable Error Interrupt                */
#define SH_LOCAL_INT3_ENABLE_PI_UCE_INT_SHFT     8
#define SH_LOCAL_INT3_ENABLE_PI_UCE_INT_MASK     0x0000000000000100

/*   SH_LOCAL_INT3_ENABLE_MD_UCE_INT                                    */
/*   Description:  Enable MD Correctable Error Interrupt                */
#define SH_LOCAL_INT3_ENABLE_MD_UCE_INT_SHFT     9
#define SH_LOCAL_INT3_ENABLE_MD_UCE_INT_MASK     0x0000000000000200

/*   SH_LOCAL_INT3_ENABLE_XN_UCE_INT                                    */
/*   Description:  Enable XN Correctable Error Interrupt                */
#define SH_LOCAL_INT3_ENABLE_XN_UCE_INT_SHFT     10
#define SH_LOCAL_INT3_ENABLE_XN_UCE_INT_MASK     0x0000000000000400

/*   SH_LOCAL_INT3_ENABLE_SYSTEM_SHUTDOWN_INT                           */
/*   Description:  Enable System Shutdown Interrupt                     */
#define SH_LOCAL_INT3_ENABLE_SYSTEM_SHUTDOWN_INT_SHFT 12
#define SH_LOCAL_INT3_ENABLE_SYSTEM_SHUTDOWN_INT_MASK 0x0000000000001000

/*   SH_LOCAL_INT3_ENABLE_UART_INT                                      */
/*   Description:  Enable Junk Bus UART Interrupt                       */
#define SH_LOCAL_INT3_ENABLE_UART_INT_SHFT       13
#define SH_LOCAL_INT3_ENABLE_UART_INT_MASK       0x0000000000002000

/*   SH_LOCAL_INT3_ENABLE_L1_NMI_INT                                    */
/*   Description:  Enable L1 Controller NMI Interrupt                   */
#define SH_LOCAL_INT3_ENABLE_L1_NMI_INT_SHFT     14
#define SH_LOCAL_INT3_ENABLE_L1_NMI_INT_MASK     0x0000000000004000

/*   SH_LOCAL_INT3_ENABLE_STOP_CLOCK                                    */
/*   Description:  Stop Clock Interrupt                                 */
#define SH_LOCAL_INT3_ENABLE_STOP_CLOCK_SHFT     15
#define SH_LOCAL_INT3_ENABLE_STOP_CLOCK_MASK     0x0000000000008000

/* ==================================================================== */
/*                   Register "SH_LOCAL_INT4_CONFIG"                    */
/*                   SHub Local Interrupt 4 Registers                   */
/* ==================================================================== */

#define SH_LOCAL_INT4_CONFIG                     0x0000000110000880
#define SH_LOCAL_INT4_CONFIG_MASK                0x0ff3ffffffefffff
#define SH_LOCAL_INT4_CONFIG_INIT                0x0000000000000000

/*   SH_LOCAL_INT4_CONFIG_TYPE                                          */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_LOCAL_INT4_CONFIG_TYPE_SHFT           0
#define SH_LOCAL_INT4_CONFIG_TYPE_MASK           0x0000000000000007

/*   SH_LOCAL_INT4_CONFIG_AGT                                           */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_LOCAL_INT4_CONFIG_AGT_SHFT            3
#define SH_LOCAL_INT4_CONFIG_AGT_MASK            0x0000000000000008

/*   SH_LOCAL_INT4_CONFIG_PID                                           */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_LOCAL_INT4_CONFIG_PID_SHFT            4
#define SH_LOCAL_INT4_CONFIG_PID_MASK            0x00000000000ffff0

/*   SH_LOCAL_INT4_CONFIG_BASE                                          */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_LOCAL_INT4_CONFIG_BASE_SHFT           21
#define SH_LOCAL_INT4_CONFIG_BASE_MASK           0x0003ffffffe00000

/*   SH_LOCAL_INT4_CONFIG_IDX                                           */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_LOCAL_INT4_CONFIG_IDX_SHFT            52
#define SH_LOCAL_INT4_CONFIG_IDX_MASK            0x0ff0000000000000

/* ==================================================================== */
/*                   Register "SH_LOCAL_INT4_ENABLE"                    */
/*                    SHub Local Interrupt 4 Enable                     */
/* ==================================================================== */

#define SH_LOCAL_INT4_ENABLE                     0x0000000110000900
#define SH_LOCAL_INT4_ENABLE_MASK                0x000000000000f7ff
#define SH_LOCAL_INT4_ENABLE_INIT                0x0000000000000000

/*   SH_LOCAL_INT4_ENABLE_PI_HW_INT                                     */
/*   Description:  Enable PI Hardware interrupt                         */
#define SH_LOCAL_INT4_ENABLE_PI_HW_INT_SHFT      0
#define SH_LOCAL_INT4_ENABLE_PI_HW_INT_MASK      0x0000000000000001

/*   SH_LOCAL_INT4_ENABLE_MD_HW_INT                                     */
/*   Description:  Enable MD Hardware interrupt                         */
#define SH_LOCAL_INT4_ENABLE_MD_HW_INT_SHFT      1
#define SH_LOCAL_INT4_ENABLE_MD_HW_INT_MASK      0x0000000000000002

/*   SH_LOCAL_INT4_ENABLE_XN_HW_INT                                     */
/*   Description:  Enable XN Hardware interrupt                         */
#define SH_LOCAL_INT4_ENABLE_XN_HW_INT_SHFT      2
#define SH_LOCAL_INT4_ENABLE_XN_HW_INT_MASK      0x0000000000000004

/*   SH_LOCAL_INT4_ENABLE_LB_HW_INT                                     */
/*   Description:  Enable LB Hardware interrupt                         */
#define SH_LOCAL_INT4_ENABLE_LB_HW_INT_SHFT      3
#define SH_LOCAL_INT4_ENABLE_LB_HW_INT_MASK      0x0000000000000008

/*   SH_LOCAL_INT4_ENABLE_II_HW_INT                                     */
/*   Description:  Enable II wrapper Hardware interrupt                 */
#define SH_LOCAL_INT4_ENABLE_II_HW_INT_SHFT      4
#define SH_LOCAL_INT4_ENABLE_II_HW_INT_MASK      0x0000000000000010

/*   SH_LOCAL_INT4_ENABLE_PI_CE_INT                                     */
/*   Description:  Enable PI Correctable Error Interrupt                */
#define SH_LOCAL_INT4_ENABLE_PI_CE_INT_SHFT      5
#define SH_LOCAL_INT4_ENABLE_PI_CE_INT_MASK      0x0000000000000020

/*   SH_LOCAL_INT4_ENABLE_MD_CE_INT                                     */
/*   Description:  Enable MD Correctable Error Interrupt                */
#define SH_LOCAL_INT4_ENABLE_MD_CE_INT_SHFT      6
#define SH_LOCAL_INT4_ENABLE_MD_CE_INT_MASK      0x0000000000000040

/*   SH_LOCAL_INT4_ENABLE_XN_CE_INT                                     */
/*   Description:  Enable XN Correctable Error Interrupt                */
#define SH_LOCAL_INT4_ENABLE_XN_CE_INT_SHFT      7
#define SH_LOCAL_INT4_ENABLE_XN_CE_INT_MASK      0x0000000000000080

/*   SH_LOCAL_INT4_ENABLE_PI_UCE_INT                                    */
/*   Description:  Enable PI Correctable Error Interrupt                */
#define SH_LOCAL_INT4_ENABLE_PI_UCE_INT_SHFT     8
#define SH_LOCAL_INT4_ENABLE_PI_UCE_INT_MASK     0x0000000000000100

/*   SH_LOCAL_INT4_ENABLE_MD_UCE_INT                                    */
/*   Description:  Enable MD Correctable Error Interrupt                */
#define SH_LOCAL_INT4_ENABLE_MD_UCE_INT_SHFT     9
#define SH_LOCAL_INT4_ENABLE_MD_UCE_INT_MASK     0x0000000000000200

/*   SH_LOCAL_INT4_ENABLE_XN_UCE_INT                                    */
/*   Description:  Enable XN Correctable Error Interrupt                */
#define SH_LOCAL_INT4_ENABLE_XN_UCE_INT_SHFT     10
#define SH_LOCAL_INT4_ENABLE_XN_UCE_INT_MASK     0x0000000000000400

/*   SH_LOCAL_INT4_ENABLE_SYSTEM_SHUTDOWN_INT                           */
/*   Description:  Enable System Shutdown Interrupt                     */
#define SH_LOCAL_INT4_ENABLE_SYSTEM_SHUTDOWN_INT_SHFT 12
#define SH_LOCAL_INT4_ENABLE_SYSTEM_SHUTDOWN_INT_MASK 0x0000000000001000

/*   SH_LOCAL_INT4_ENABLE_UART_INT                                      */
/*   Description:  Enable Junk Bus UART Interrupt                       */
#define SH_LOCAL_INT4_ENABLE_UART_INT_SHFT       13
#define SH_LOCAL_INT4_ENABLE_UART_INT_MASK       0x0000000000002000

/*   SH_LOCAL_INT4_ENABLE_L1_NMI_INT                                    */
/*   Description:  Enable L1 Controller NMI Interrupt                   */
#define SH_LOCAL_INT4_ENABLE_L1_NMI_INT_SHFT     14
#define SH_LOCAL_INT4_ENABLE_L1_NMI_INT_MASK     0x0000000000004000

/*   SH_LOCAL_INT4_ENABLE_STOP_CLOCK                                    */
/*   Description:  Stop Clock Interrupt                                 */
#define SH_LOCAL_INT4_ENABLE_STOP_CLOCK_SHFT     15
#define SH_LOCAL_INT4_ENABLE_STOP_CLOCK_MASK     0x0000000000008000

/* ==================================================================== */
/*                   Register "SH_LOCAL_INT5_CONFIG"                    */
/*                   SHub Local Interrupt 5 Registers                   */
/* ==================================================================== */

#define SH_LOCAL_INT5_CONFIG                     0x0000000110000980
#define SH_LOCAL_INT5_CONFIG_MASK                0x0ff3ffffffefffff
#define SH_LOCAL_INT5_CONFIG_INIT                0x0000000000000000

/*   SH_LOCAL_INT5_CONFIG_TYPE                                          */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_LOCAL_INT5_CONFIG_TYPE_SHFT           0
#define SH_LOCAL_INT5_CONFIG_TYPE_MASK           0x0000000000000007

/*   SH_LOCAL_INT5_CONFIG_AGT                                           */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_LOCAL_INT5_CONFIG_AGT_SHFT            3
#define SH_LOCAL_INT5_CONFIG_AGT_MASK            0x0000000000000008

/*   SH_LOCAL_INT5_CONFIG_PID                                           */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_LOCAL_INT5_CONFIG_PID_SHFT            4
#define SH_LOCAL_INT5_CONFIG_PID_MASK            0x00000000000ffff0

/*   SH_LOCAL_INT5_CONFIG_BASE                                          */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_LOCAL_INT5_CONFIG_BASE_SHFT           21
#define SH_LOCAL_INT5_CONFIG_BASE_MASK           0x0003ffffffe00000

/*   SH_LOCAL_INT5_CONFIG_IDX                                           */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_LOCAL_INT5_CONFIG_IDX_SHFT            52
#define SH_LOCAL_INT5_CONFIG_IDX_MASK            0x0ff0000000000000

/* ==================================================================== */
/*                   Register "SH_LOCAL_INT5_ENABLE"                    */
/*                    SHub Local Interrupt 5 Enable                     */
/* ==================================================================== */

#define SH_LOCAL_INT5_ENABLE                     0x0000000110000a00
#define SH_LOCAL_INT5_ENABLE_MASK                0x000000000000f7ff
#define SH_LOCAL_INT5_ENABLE_INIT                0x0000000000000000

/*   SH_LOCAL_INT5_ENABLE_PI_HW_INT                                     */
/*   Description:  Enable PI Hardware interrupt                         */
#define SH_LOCAL_INT5_ENABLE_PI_HW_INT_SHFT      0
#define SH_LOCAL_INT5_ENABLE_PI_HW_INT_MASK      0x0000000000000001

/*   SH_LOCAL_INT5_ENABLE_MD_HW_INT                                     */
/*   Description:  Enable MD Hardware interrupt                         */
#define SH_LOCAL_INT5_ENABLE_MD_HW_INT_SHFT      1
#define SH_LOCAL_INT5_ENABLE_MD_HW_INT_MASK      0x0000000000000002

/*   SH_LOCAL_INT5_ENABLE_XN_HW_INT                                     */
/*   Description:  Enable XN Hardware interrupt                         */
#define SH_LOCAL_INT5_ENABLE_XN_HW_INT_SHFT      2
#define SH_LOCAL_INT5_ENABLE_XN_HW_INT_MASK      0x0000000000000004

/*   SH_LOCAL_INT5_ENABLE_LB_HW_INT                                     */
/*   Description:  Enable LB Hardware interrupt                         */
#define SH_LOCAL_INT5_ENABLE_LB_HW_INT_SHFT      3
#define SH_LOCAL_INT5_ENABLE_LB_HW_INT_MASK      0x0000000000000008

/*   SH_LOCAL_INT5_ENABLE_II_HW_INT                                     */
/*   Description:  Enable II wrapper Hardware interrupt                 */
#define SH_LOCAL_INT5_ENABLE_II_HW_INT_SHFT      4
#define SH_LOCAL_INT5_ENABLE_II_HW_INT_MASK      0x0000000000000010

/*   SH_LOCAL_INT5_ENABLE_PI_CE_INT                                     */
/*   Description:  Enable PI Correctable Error Interrupt                */
#define SH_LOCAL_INT5_ENABLE_PI_CE_INT_SHFT      5
#define SH_LOCAL_INT5_ENABLE_PI_CE_INT_MASK      0x0000000000000020

/*   SH_LOCAL_INT5_ENABLE_MD_CE_INT                                     */
/*   Description:  Enable MD Correctable Error Interrupt                */
#define SH_LOCAL_INT5_ENABLE_MD_CE_INT_SHFT      6
#define SH_LOCAL_INT5_ENABLE_MD_CE_INT_MASK      0x0000000000000040

/*   SH_LOCAL_INT5_ENABLE_XN_CE_INT                                     */
/*   Description:  Enable XN Correctable Error Interrupt                */
#define SH_LOCAL_INT5_ENABLE_XN_CE_INT_SHFT      7
#define SH_LOCAL_INT5_ENABLE_XN_CE_INT_MASK      0x0000000000000080

/*   SH_LOCAL_INT5_ENABLE_PI_UCE_INT                                    */
/*   Description:  Enable PI Correctable Error Interrupt                */
#define SH_LOCAL_INT5_ENABLE_PI_UCE_INT_SHFT     8
#define SH_LOCAL_INT5_ENABLE_PI_UCE_INT_MASK     0x0000000000000100

/*   SH_LOCAL_INT5_ENABLE_MD_UCE_INT                                    */
/*   Description:  Enable MD Correctable Error Interrupt                */
#define SH_LOCAL_INT5_ENABLE_MD_UCE_INT_SHFT     9
#define SH_LOCAL_INT5_ENABLE_MD_UCE_INT_MASK     0x0000000000000200

/*   SH_LOCAL_INT5_ENABLE_XN_UCE_INT                                    */
/*   Description:  Enable XN Correctable Error Interrupt                */
#define SH_LOCAL_INT5_ENABLE_XN_UCE_INT_SHFT     10
#define SH_LOCAL_INT5_ENABLE_XN_UCE_INT_MASK     0x0000000000000400

/*   SH_LOCAL_INT5_ENABLE_SYSTEM_SHUTDOWN_INT                           */
/*   Description:  Enable System Shutdown Interrupt                     */
#define SH_LOCAL_INT5_ENABLE_SYSTEM_SHUTDOWN_INT_SHFT 12
#define SH_LOCAL_INT5_ENABLE_SYSTEM_SHUTDOWN_INT_MASK 0x0000000000001000

/*   SH_LOCAL_INT5_ENABLE_UART_INT                                      */
/*   Description:  Enable Junk Bus UART Interrupt                       */
#define SH_LOCAL_INT5_ENABLE_UART_INT_SHFT       13
#define SH_LOCAL_INT5_ENABLE_UART_INT_MASK       0x0000000000002000

/*   SH_LOCAL_INT5_ENABLE_L1_NMI_INT                                    */
/*   Description:  Enable L1 Controller NMI Interrupt                   */
#define SH_LOCAL_INT5_ENABLE_L1_NMI_INT_SHFT     14
#define SH_LOCAL_INT5_ENABLE_L1_NMI_INT_MASK     0x0000000000004000

/*   SH_LOCAL_INT5_ENABLE_STOP_CLOCK                                    */
/*   Description:  Stop Clock Interrupt                                 */
#define SH_LOCAL_INT5_ENABLE_STOP_CLOCK_SHFT     15
#define SH_LOCAL_INT5_ENABLE_STOP_CLOCK_MASK     0x0000000000008000

/* ==================================================================== */
/*                  Register "SH_PROC0_ERR_INT_CONFIG"                  */
/*              SHub Processor 0 Error Interrupt Registers              */
/* ==================================================================== */

#define SH_PROC0_ERR_INT_CONFIG                  0x0000000110000a80
#define SH_PROC0_ERR_INT_CONFIG_MASK             0x0ff3ffffffefffff
#define SH_PROC0_ERR_INT_CONFIG_INIT             0x0000000000000000

/*   SH_PROC0_ERR_INT_CONFIG_TYPE                                       */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_PROC0_ERR_INT_CONFIG_TYPE_SHFT        0
#define SH_PROC0_ERR_INT_CONFIG_TYPE_MASK        0x0000000000000007

/*   SH_PROC0_ERR_INT_CONFIG_AGT                                        */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_PROC0_ERR_INT_CONFIG_AGT_SHFT         3
#define SH_PROC0_ERR_INT_CONFIG_AGT_MASK         0x0000000000000008

/*   SH_PROC0_ERR_INT_CONFIG_PID                                        */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_PROC0_ERR_INT_CONFIG_PID_SHFT         4
#define SH_PROC0_ERR_INT_CONFIG_PID_MASK         0x00000000000ffff0

/*   SH_PROC0_ERR_INT_CONFIG_BASE                                       */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_PROC0_ERR_INT_CONFIG_BASE_SHFT        21
#define SH_PROC0_ERR_INT_CONFIG_BASE_MASK        0x0003ffffffe00000

/*   SH_PROC0_ERR_INT_CONFIG_IDX                                        */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_PROC0_ERR_INT_CONFIG_IDX_SHFT         52
#define SH_PROC0_ERR_INT_CONFIG_IDX_MASK         0x0ff0000000000000

/* ==================================================================== */
/*                  Register "SH_PROC1_ERR_INT_CONFIG"                  */
/*              SHub Processor 1 Error Interrupt Registers              */
/* ==================================================================== */

#define SH_PROC1_ERR_INT_CONFIG                  0x0000000110000b00
#define SH_PROC1_ERR_INT_CONFIG_MASK             0x0ff3ffffffefffff
#define SH_PROC1_ERR_INT_CONFIG_INIT             0x0000000000000000

/*   SH_PROC1_ERR_INT_CONFIG_TYPE                                       */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_PROC1_ERR_INT_CONFIG_TYPE_SHFT        0
#define SH_PROC1_ERR_INT_CONFIG_TYPE_MASK        0x0000000000000007

/*   SH_PROC1_ERR_INT_CONFIG_AGT                                        */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_PROC1_ERR_INT_CONFIG_AGT_SHFT         3
#define SH_PROC1_ERR_INT_CONFIG_AGT_MASK         0x0000000000000008

/*   SH_PROC1_ERR_INT_CONFIG_PID                                        */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_PROC1_ERR_INT_CONFIG_PID_SHFT         4
#define SH_PROC1_ERR_INT_CONFIG_PID_MASK         0x00000000000ffff0

/*   SH_PROC1_ERR_INT_CONFIG_BASE                                       */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_PROC1_ERR_INT_CONFIG_BASE_SHFT        21
#define SH_PROC1_ERR_INT_CONFIG_BASE_MASK        0x0003ffffffe00000

/*   SH_PROC1_ERR_INT_CONFIG_IDX                                        */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_PROC1_ERR_INT_CONFIG_IDX_SHFT         52
#define SH_PROC1_ERR_INT_CONFIG_IDX_MASK         0x0ff0000000000000

/* ==================================================================== */
/*                  Register "SH_PROC2_ERR_INT_CONFIG"                  */
/*              SHub Processor 2 Error Interrupt Registers              */
/* ==================================================================== */

#define SH_PROC2_ERR_INT_CONFIG                  0x0000000110000b80
#define SH_PROC2_ERR_INT_CONFIG_MASK             0x0ff3ffffffefffff
#define SH_PROC2_ERR_INT_CONFIG_INIT             0x0000000000000000

/*   SH_PROC2_ERR_INT_CONFIG_TYPE                                       */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_PROC2_ERR_INT_CONFIG_TYPE_SHFT        0
#define SH_PROC2_ERR_INT_CONFIG_TYPE_MASK        0x0000000000000007

/*   SH_PROC2_ERR_INT_CONFIG_AGT                                        */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_PROC2_ERR_INT_CONFIG_AGT_SHFT         3
#define SH_PROC2_ERR_INT_CONFIG_AGT_MASK         0x0000000000000008

/*   SH_PROC2_ERR_INT_CONFIG_PID                                        */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_PROC2_ERR_INT_CONFIG_PID_SHFT         4
#define SH_PROC2_ERR_INT_CONFIG_PID_MASK         0x00000000000ffff0

/*   SH_PROC2_ERR_INT_CONFIG_BASE                                       */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_PROC2_ERR_INT_CONFIG_BASE_SHFT        21
#define SH_PROC2_ERR_INT_CONFIG_BASE_MASK        0x0003ffffffe00000

/*   SH_PROC2_ERR_INT_CONFIG_IDX                                        */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_PROC2_ERR_INT_CONFIG_IDX_SHFT         52
#define SH_PROC2_ERR_INT_CONFIG_IDX_MASK         0x0ff0000000000000

/* ==================================================================== */
/*                  Register "SH_PROC3_ERR_INT_CONFIG"                  */
/*              SHub Processor 3 Error Interrupt Registers              */
/* ==================================================================== */

#define SH_PROC3_ERR_INT_CONFIG                  0x0000000110000c00
#define SH_PROC3_ERR_INT_CONFIG_MASK             0x0ff3ffffffefffff
#define SH_PROC3_ERR_INT_CONFIG_INIT             0x0000000000000000

/*   SH_PROC3_ERR_INT_CONFIG_TYPE                                       */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_PROC3_ERR_INT_CONFIG_TYPE_SHFT        0
#define SH_PROC3_ERR_INT_CONFIG_TYPE_MASK        0x0000000000000007

/*   SH_PROC3_ERR_INT_CONFIG_AGT                                        */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_PROC3_ERR_INT_CONFIG_AGT_SHFT         3
#define SH_PROC3_ERR_INT_CONFIG_AGT_MASK         0x0000000000000008

/*   SH_PROC3_ERR_INT_CONFIG_PID                                        */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_PROC3_ERR_INT_CONFIG_PID_SHFT         4
#define SH_PROC3_ERR_INT_CONFIG_PID_MASK         0x00000000000ffff0

/*   SH_PROC3_ERR_INT_CONFIG_BASE                                       */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_PROC3_ERR_INT_CONFIG_BASE_SHFT        21
#define SH_PROC3_ERR_INT_CONFIG_BASE_MASK        0x0003ffffffe00000

/*   SH_PROC3_ERR_INT_CONFIG_IDX                                        */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_PROC3_ERR_INT_CONFIG_IDX_SHFT         52
#define SH_PROC3_ERR_INT_CONFIG_IDX_MASK         0x0ff0000000000000

/* ==================================================================== */
/*                  Register "SH_PROC0_ADV_INT_CONFIG"                  */
/*            SHub Processor 0 Advisory Interrupt Registers             */
/* ==================================================================== */

#define SH_PROC0_ADV_INT_CONFIG                  0x0000000110000c80
#define SH_PROC0_ADV_INT_CONFIG_MASK             0x0ff3ffffffefffff
#define SH_PROC0_ADV_INT_CONFIG_INIT             0x0000000000000000

/*   SH_PROC0_ADV_INT_CONFIG_TYPE                                       */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_PROC0_ADV_INT_CONFIG_TYPE_SHFT        0
#define SH_PROC0_ADV_INT_CONFIG_TYPE_MASK        0x0000000000000007

/*   SH_PROC0_ADV_INT_CONFIG_AGT                                        */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_PROC0_ADV_INT_CONFIG_AGT_SHFT         3
#define SH_PROC0_ADV_INT_CONFIG_AGT_MASK         0x0000000000000008

/*   SH_PROC0_ADV_INT_CONFIG_PID                                        */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_PROC0_ADV_INT_CONFIG_PID_SHFT         4
#define SH_PROC0_ADV_INT_CONFIG_PID_MASK         0x00000000000ffff0

/*   SH_PROC0_ADV_INT_CONFIG_BASE                                       */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_PROC0_ADV_INT_CONFIG_BASE_SHFT        21
#define SH_PROC0_ADV_INT_CONFIG_BASE_MASK        0x0003ffffffe00000

/*   SH_PROC0_ADV_INT_CONFIG_IDX                                        */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_PROC0_ADV_INT_CONFIG_IDX_SHFT         52
#define SH_PROC0_ADV_INT_CONFIG_IDX_MASK         0x0ff0000000000000

/* ==================================================================== */
/*                  Register "SH_PROC1_ADV_INT_CONFIG"                  */
/*            SHub Processor 1 Advisory Interrupt Registers             */
/* ==================================================================== */

#define SH_PROC1_ADV_INT_CONFIG                  0x0000000110000d00
#define SH_PROC1_ADV_INT_CONFIG_MASK             0x0ff3ffffffefffff
#define SH_PROC1_ADV_INT_CONFIG_INIT             0x0000000000000000

/*   SH_PROC1_ADV_INT_CONFIG_TYPE                                       */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_PROC1_ADV_INT_CONFIG_TYPE_SHFT        0
#define SH_PROC1_ADV_INT_CONFIG_TYPE_MASK        0x0000000000000007

/*   SH_PROC1_ADV_INT_CONFIG_AGT                                        */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_PROC1_ADV_INT_CONFIG_AGT_SHFT         3
#define SH_PROC1_ADV_INT_CONFIG_AGT_MASK         0x0000000000000008

/*   SH_PROC1_ADV_INT_CONFIG_PID                                        */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_PROC1_ADV_INT_CONFIG_PID_SHFT         4
#define SH_PROC1_ADV_INT_CONFIG_PID_MASK         0x00000000000ffff0

/*   SH_PROC1_ADV_INT_CONFIG_BASE                                       */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_PROC1_ADV_INT_CONFIG_BASE_SHFT        21
#define SH_PROC1_ADV_INT_CONFIG_BASE_MASK        0x0003ffffffe00000

/*   SH_PROC1_ADV_INT_CONFIG_IDX                                        */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_PROC1_ADV_INT_CONFIG_IDX_SHFT         52
#define SH_PROC1_ADV_INT_CONFIG_IDX_MASK         0x0ff0000000000000

/* ==================================================================== */
/*                  Register "SH_PROC2_ADV_INT_CONFIG"                  */
/*            SHub Processor 2 Advisory Interrupt Registers             */
/* ==================================================================== */

#define SH_PROC2_ADV_INT_CONFIG                  0x0000000110000d80
#define SH_PROC2_ADV_INT_CONFIG_MASK             0x0ff3ffffffefffff
#define SH_PROC2_ADV_INT_CONFIG_INIT             0x0000000000000000

/*   SH_PROC2_ADV_INT_CONFIG_TYPE                                       */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_PROC2_ADV_INT_CONFIG_TYPE_SHFT        0
#define SH_PROC2_ADV_INT_CONFIG_TYPE_MASK        0x0000000000000007

/*   SH_PROC2_ADV_INT_CONFIG_AGT                                        */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_PROC2_ADV_INT_CONFIG_AGT_SHFT         3
#define SH_PROC2_ADV_INT_CONFIG_AGT_MASK         0x0000000000000008

/*   SH_PROC2_ADV_INT_CONFIG_PID                                        */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_PROC2_ADV_INT_CONFIG_PID_SHFT         4
#define SH_PROC2_ADV_INT_CONFIG_PID_MASK         0x00000000000ffff0

/*   SH_PROC2_ADV_INT_CONFIG_BASE                                       */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_PROC2_ADV_INT_CONFIG_BASE_SHFT        21
#define SH_PROC2_ADV_INT_CONFIG_BASE_MASK        0x0003ffffffe00000

/*   SH_PROC2_ADV_INT_CONFIG_IDX                                        */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_PROC2_ADV_INT_CONFIG_IDX_SHFT         52
#define SH_PROC2_ADV_INT_CONFIG_IDX_MASK         0x0ff0000000000000

/* ==================================================================== */
/*                  Register "SH_PROC3_ADV_INT_CONFIG"                  */
/*            SHub Processor 3 Advisory Interrupt Registers             */
/* ==================================================================== */

#define SH_PROC3_ADV_INT_CONFIG                  0x0000000110000e00
#define SH_PROC3_ADV_INT_CONFIG_MASK             0x0ff3ffffffefffff
#define SH_PROC3_ADV_INT_CONFIG_INIT             0x0000000000000000

/*   SH_PROC3_ADV_INT_CONFIG_TYPE                                       */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_PROC3_ADV_INT_CONFIG_TYPE_SHFT        0
#define SH_PROC3_ADV_INT_CONFIG_TYPE_MASK        0x0000000000000007

/*   SH_PROC3_ADV_INT_CONFIG_AGT                                        */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_PROC3_ADV_INT_CONFIG_AGT_SHFT         3
#define SH_PROC3_ADV_INT_CONFIG_AGT_MASK         0x0000000000000008

/*   SH_PROC3_ADV_INT_CONFIG_PID                                        */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_PROC3_ADV_INT_CONFIG_PID_SHFT         4
#define SH_PROC3_ADV_INT_CONFIG_PID_MASK         0x00000000000ffff0

/*   SH_PROC3_ADV_INT_CONFIG_BASE                                       */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_PROC3_ADV_INT_CONFIG_BASE_SHFT        21
#define SH_PROC3_ADV_INT_CONFIG_BASE_MASK        0x0003ffffffe00000

/*   SH_PROC3_ADV_INT_CONFIG_IDX                                        */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_PROC3_ADV_INT_CONFIG_IDX_SHFT         52
#define SH_PROC3_ADV_INT_CONFIG_IDX_MASK         0x0ff0000000000000

/* ==================================================================== */
/*                  Register "SH_PROC0_ERR_INT_ENABLE"                  */
/*          SHub Processor 0 Error Interrupt Enable Registers           */
/* ==================================================================== */

#define SH_PROC0_ERR_INT_ENABLE                  0x0000000110000e80
#define SH_PROC0_ERR_INT_ENABLE_MASK             0x0000000000000001
#define SH_PROC0_ERR_INT_ENABLE_INIT             0x0000000000000000

/*   SH_PROC0_ERR_INT_ENABLE_PROC0_ERR_ENABLE                           */
/*   Description:  Enable Processor 0 Error Interrupt                   */
#define SH_PROC0_ERR_INT_ENABLE_PROC0_ERR_ENABLE_SHFT 0
#define SH_PROC0_ERR_INT_ENABLE_PROC0_ERR_ENABLE_MASK 0x0000000000000001

/* ==================================================================== */
/*                  Register "SH_PROC1_ERR_INT_ENABLE"                  */
/*          SHub Processor 1 Error Interrupt Enable Registers           */
/* ==================================================================== */

#define SH_PROC1_ERR_INT_ENABLE                  0x0000000110000f00
#define SH_PROC1_ERR_INT_ENABLE_MASK             0x0000000000000001
#define SH_PROC1_ERR_INT_ENABLE_INIT             0x0000000000000000

/*   SH_PROC1_ERR_INT_ENABLE_PROC1_ERR_ENABLE                           */
/*   Description:  Enable Processor 1 Error Interrupt                   */
#define SH_PROC1_ERR_INT_ENABLE_PROC1_ERR_ENABLE_SHFT 0
#define SH_PROC1_ERR_INT_ENABLE_PROC1_ERR_ENABLE_MASK 0x0000000000000001

/* ==================================================================== */
/*                  Register "SH_PROC2_ERR_INT_ENABLE"                  */
/*          SHub Processor 2 Error Interrupt Enable Registers           */
/* ==================================================================== */

#define SH_PROC2_ERR_INT_ENABLE                  0x0000000110000f80
#define SH_PROC2_ERR_INT_ENABLE_MASK             0x0000000000000001
#define SH_PROC2_ERR_INT_ENABLE_INIT             0x0000000000000000

/*   SH_PROC2_ERR_INT_ENABLE_PROC2_ERR_ENABLE                           */
/*   Description:  Enable Processor 2 Error Interrupt                   */
#define SH_PROC2_ERR_INT_ENABLE_PROC2_ERR_ENABLE_SHFT 0
#define SH_PROC2_ERR_INT_ENABLE_PROC2_ERR_ENABLE_MASK 0x0000000000000001

/* ==================================================================== */
/*                  Register "SH_PROC3_ERR_INT_ENABLE"                  */
/*          SHub Processor 3 Error Interrupt Enable Registers           */
/* ==================================================================== */

#define SH_PROC3_ERR_INT_ENABLE                  0x0000000110001000
#define SH_PROC3_ERR_INT_ENABLE_MASK             0x0000000000000001
#define SH_PROC3_ERR_INT_ENABLE_INIT             0x0000000000000000

/*   SH_PROC3_ERR_INT_ENABLE_PROC3_ERR_ENABLE                           */
/*   Description:  Enable Processor 3 Error Interrupt                   */
#define SH_PROC3_ERR_INT_ENABLE_PROC3_ERR_ENABLE_SHFT 0
#define SH_PROC3_ERR_INT_ENABLE_PROC3_ERR_ENABLE_MASK 0x0000000000000001

/* ==================================================================== */
/*                  Register "SH_PROC0_ADV_INT_ENABLE"                  */
/*         SHub Processor 0 Advisory Interrupt Enable Registers         */
/* ==================================================================== */

#define SH_PROC0_ADV_INT_ENABLE                  0x0000000110001080
#define SH_PROC0_ADV_INT_ENABLE_MASK             0x0000000000000001
#define SH_PROC0_ADV_INT_ENABLE_INIT             0x0000000000000000

/*   SH_PROC0_ADV_INT_ENABLE_PROC0_ADV_ENABLE                           */
/*   Description:  Enable Processor 0 Advisory Interrupt                */
#define SH_PROC0_ADV_INT_ENABLE_PROC0_ADV_ENABLE_SHFT 0
#define SH_PROC0_ADV_INT_ENABLE_PROC0_ADV_ENABLE_MASK 0x0000000000000001

/* ==================================================================== */
/*                  Register "SH_PROC1_ADV_INT_ENABLE"                  */
/*         SHub Processor 1 Advisory Interrupt Enable Registers         */
/* ==================================================================== */

#define SH_PROC1_ADV_INT_ENABLE                  0x0000000110001100
#define SH_PROC1_ADV_INT_ENABLE_MASK             0x0000000000000001
#define SH_PROC1_ADV_INT_ENABLE_INIT             0x0000000000000000

/*   SH_PROC1_ADV_INT_ENABLE_PROC1_ADV_ENABLE                           */
/*   Description:  Enable Processor 1 Advisory Interrupt                */
#define SH_PROC1_ADV_INT_ENABLE_PROC1_ADV_ENABLE_SHFT 0
#define SH_PROC1_ADV_INT_ENABLE_PROC1_ADV_ENABLE_MASK 0x0000000000000001

/* ==================================================================== */
/*                  Register "SH_PROC2_ADV_INT_ENABLE"                  */
/*         SHub Processor 2 Advisory Interrupt Enable Registers         */
/* ==================================================================== */

#define SH_PROC2_ADV_INT_ENABLE                  0x0000000110001180
#define SH_PROC2_ADV_INT_ENABLE_MASK             0x0000000000000001
#define SH_PROC2_ADV_INT_ENABLE_INIT             0x0000000000000000

/*   SH_PROC2_ADV_INT_ENABLE_PROC2_ADV_ENABLE                           */
/*   Description:  Enable Processor 2 Advisory Interrupt                */
#define SH_PROC2_ADV_INT_ENABLE_PROC2_ADV_ENABLE_SHFT 0
#define SH_PROC2_ADV_INT_ENABLE_PROC2_ADV_ENABLE_MASK 0x0000000000000001

/* ==================================================================== */
/*                  Register "SH_PROC3_ADV_INT_ENABLE"                  */
/*         SHub Processor 3 Advisory Interrupt Enable Registers         */
/* ==================================================================== */

#define SH_PROC3_ADV_INT_ENABLE                  0x0000000110001200
#define SH_PROC3_ADV_INT_ENABLE_MASK             0x0000000000000001
#define SH_PROC3_ADV_INT_ENABLE_INIT             0x0000000000000000

/*   SH_PROC3_ADV_INT_ENABLE_PROC3_ADV_ENABLE                           */
/*   Description:  Enable Processor 3 Advisory Interrupt                */
#define SH_PROC3_ADV_INT_ENABLE_PROC3_ADV_ENABLE_SHFT 0
#define SH_PROC3_ADV_INT_ENABLE_PROC3_ADV_ENABLE_MASK 0x0000000000000001

/* ==================================================================== */
/*                   Register "SH_PROFILE_INT_CONFIG"                   */
/*            SHub Profile Interrupt Configuration Registers            */
/* ==================================================================== */

#define SH_PROFILE_INT_CONFIG                    0x0000000110001280
#define SH_PROFILE_INT_CONFIG_MASK               0x0ff3ffffffefffff
#define SH_PROFILE_INT_CONFIG_INIT               0x0000000000000000

/*   SH_PROFILE_INT_CONFIG_TYPE                                         */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_PROFILE_INT_CONFIG_TYPE_SHFT          0
#define SH_PROFILE_INT_CONFIG_TYPE_MASK          0x0000000000000007

/*   SH_PROFILE_INT_CONFIG_AGT                                          */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_PROFILE_INT_CONFIG_AGT_SHFT           3
#define SH_PROFILE_INT_CONFIG_AGT_MASK           0x0000000000000008

/*   SH_PROFILE_INT_CONFIG_PID                                          */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_PROFILE_INT_CONFIG_PID_SHFT           4
#define SH_PROFILE_INT_CONFIG_PID_MASK           0x00000000000ffff0

/*   SH_PROFILE_INT_CONFIG_BASE                                         */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_PROFILE_INT_CONFIG_BASE_SHFT          21
#define SH_PROFILE_INT_CONFIG_BASE_MASK          0x0003ffffffe00000

/*   SH_PROFILE_INT_CONFIG_IDX                                          */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_PROFILE_INT_CONFIG_IDX_SHFT           52
#define SH_PROFILE_INT_CONFIG_IDX_MASK           0x0ff0000000000000

/* ==================================================================== */
/*                   Register "SH_PROFILE_INT_ENABLE"                   */
/*               SHub Profile Interrupt Enable Registers                */
/* ==================================================================== */

#define SH_PROFILE_INT_ENABLE                    0x0000000110001300
#define SH_PROFILE_INT_ENABLE_MASK               0x0000000000000001
#define SH_PROFILE_INT_ENABLE_INIT               0x0000000000000000

/*   SH_PROFILE_INT_ENABLE_PROFILE_ENABLE                               */
/*   Description:  Enable Profile Interrupt                             */
#define SH_PROFILE_INT_ENABLE_PROFILE_ENABLE_SHFT 0
#define SH_PROFILE_INT_ENABLE_PROFILE_ENABLE_MASK 0x0000000000000001

/* ==================================================================== */
/*                    Register "SH_RTC0_INT_CONFIG"                     */
/*                SHub RTC 0 Interrupt Config Registers                 */
/* ==================================================================== */

#define SH_RTC0_INT_CONFIG                       0x0000000110001380
#define SH_RTC0_INT_CONFIG_MASK                  0x0ff3ffffffefffff
#define SH_RTC0_INT_CONFIG_INIT                  0x0000000000000000

/*   SH_RTC0_INT_CONFIG_TYPE                                            */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_RTC0_INT_CONFIG_TYPE_SHFT             0
#define SH_RTC0_INT_CONFIG_TYPE_MASK             0x0000000000000007

/*   SH_RTC0_INT_CONFIG_AGT                                             */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_RTC0_INT_CONFIG_AGT_SHFT              3
#define SH_RTC0_INT_CONFIG_AGT_MASK              0x0000000000000008

/*   SH_RTC0_INT_CONFIG_PID                                             */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_RTC0_INT_CONFIG_PID_SHFT              4
#define SH_RTC0_INT_CONFIG_PID_MASK              0x00000000000ffff0

/*   SH_RTC0_INT_CONFIG_BASE                                            */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_RTC0_INT_CONFIG_BASE_SHFT             21
#define SH_RTC0_INT_CONFIG_BASE_MASK             0x0003ffffffe00000

/*   SH_RTC0_INT_CONFIG_IDX                                             */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_RTC0_INT_CONFIG_IDX_SHFT              52
#define SH_RTC0_INT_CONFIG_IDX_MASK              0x0ff0000000000000

/* ==================================================================== */
/*                    Register "SH_RTC0_INT_ENABLE"                     */
/*                SHub RTC 0 Interrupt Enable Registers                 */
/* ==================================================================== */

#define SH_RTC0_INT_ENABLE                       0x0000000110001400
#define SH_RTC0_INT_ENABLE_MASK                  0x0000000000000001
#define SH_RTC0_INT_ENABLE_INIT                  0x0000000000000000

/*   SH_RTC0_INT_ENABLE_RTC0_ENABLE                                     */
/*   Description:  Enable RTC 0 Interrupt                               */
#define SH_RTC0_INT_ENABLE_RTC0_ENABLE_SHFT      0
#define SH_RTC0_INT_ENABLE_RTC0_ENABLE_MASK      0x0000000000000001

/* ==================================================================== */
/*                    Register "SH_RTC1_INT_CONFIG"                     */
/*                SHub RTC 1 Interrupt Config Registers                 */
/* ==================================================================== */

#define SH_RTC1_INT_CONFIG                       0x0000000110001480
#define SH_RTC1_INT_CONFIG_MASK                  0x0ff3ffffffefffff
#define SH_RTC1_INT_CONFIG_INIT                  0x0000000000000000

/*   SH_RTC1_INT_CONFIG_TYPE                                            */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_RTC1_INT_CONFIG_TYPE_SHFT             0
#define SH_RTC1_INT_CONFIG_TYPE_MASK             0x0000000000000007

/*   SH_RTC1_INT_CONFIG_AGT                                             */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_RTC1_INT_CONFIG_AGT_SHFT              3
#define SH_RTC1_INT_CONFIG_AGT_MASK              0x0000000000000008

/*   SH_RTC1_INT_CONFIG_PID                                             */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_RTC1_INT_CONFIG_PID_SHFT              4
#define SH_RTC1_INT_CONFIG_PID_MASK              0x00000000000ffff0

/*   SH_RTC1_INT_CONFIG_BASE                                            */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_RTC1_INT_CONFIG_BASE_SHFT             21
#define SH_RTC1_INT_CONFIG_BASE_MASK             0x0003ffffffe00000

/*   SH_RTC1_INT_CONFIG_IDX                                             */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_RTC1_INT_CONFIG_IDX_SHFT              52
#define SH_RTC1_INT_CONFIG_IDX_MASK              0x0ff0000000000000

/* ==================================================================== */
/*                    Register "SH_RTC1_INT_ENABLE"                     */
/*                SHub RTC 1 Interrupt Enable Registers                 */
/* ==================================================================== */

#define SH_RTC1_INT_ENABLE                       0x0000000110001500
#define SH_RTC1_INT_ENABLE_MASK                  0x0000000000000001
#define SH_RTC1_INT_ENABLE_INIT                  0x0000000000000000

/*   SH_RTC1_INT_ENABLE_RTC1_ENABLE                                     */
/*   Description:  Enable RTC 1 Interrupt                               */
#define SH_RTC1_INT_ENABLE_RTC1_ENABLE_SHFT      0
#define SH_RTC1_INT_ENABLE_RTC1_ENABLE_MASK      0x0000000000000001

/* ==================================================================== */
/*                    Register "SH_RTC2_INT_CONFIG"                     */
/*                SHub RTC 2 Interrupt Config Registers                 */
/* ==================================================================== */

#define SH_RTC2_INT_CONFIG                       0x0000000110001580
#define SH_RTC2_INT_CONFIG_MASK                  0x0ff3ffffffefffff
#define SH_RTC2_INT_CONFIG_INIT                  0x0000000000000000

/*   SH_RTC2_INT_CONFIG_TYPE                                            */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_RTC2_INT_CONFIG_TYPE_SHFT             0
#define SH_RTC2_INT_CONFIG_TYPE_MASK             0x0000000000000007

/*   SH_RTC2_INT_CONFIG_AGT                                             */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_RTC2_INT_CONFIG_AGT_SHFT              3
#define SH_RTC2_INT_CONFIG_AGT_MASK              0x0000000000000008

/*   SH_RTC2_INT_CONFIG_PID                                             */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_RTC2_INT_CONFIG_PID_SHFT              4
#define SH_RTC2_INT_CONFIG_PID_MASK              0x00000000000ffff0

/*   SH_RTC2_INT_CONFIG_BASE                                            */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_RTC2_INT_CONFIG_BASE_SHFT             21
#define SH_RTC2_INT_CONFIG_BASE_MASK             0x0003ffffffe00000

/*   SH_RTC2_INT_CONFIG_IDX                                             */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_RTC2_INT_CONFIG_IDX_SHFT              52
#define SH_RTC2_INT_CONFIG_IDX_MASK              0x0ff0000000000000

/* ==================================================================== */
/*                    Register "SH_RTC2_INT_ENABLE"                     */
/*                SHub RTC 2 Interrupt Enable Registers                 */
/* ==================================================================== */

#define SH_RTC2_INT_ENABLE                       0x0000000110001600
#define SH_RTC2_INT_ENABLE_MASK                  0x0000000000000001
#define SH_RTC2_INT_ENABLE_INIT                  0x0000000000000000

/*   SH_RTC2_INT_ENABLE_RTC2_ENABLE                                     */
/*   Description:  Enable RTC 2 Interrupt                               */
#define SH_RTC2_INT_ENABLE_RTC2_ENABLE_SHFT      0
#define SH_RTC2_INT_ENABLE_RTC2_ENABLE_MASK      0x0000000000000001

/* ==================================================================== */
/*                    Register "SH_RTC3_INT_CONFIG"                     */
/*                SHub RTC 3 Interrupt Config Registers                 */
/* ==================================================================== */

#define SH_RTC3_INT_CONFIG                       0x0000000110001680
#define SH_RTC3_INT_CONFIG_MASK                  0x0ff3ffffffefffff
#define SH_RTC3_INT_CONFIG_INIT                  0x0000000000000000

/*   SH_RTC3_INT_CONFIG_TYPE                                            */
/*   Description:  Type of Interrupt: 0=INT, 2=PMI, 4=NMI, 5=INIT       */
#define SH_RTC3_INT_CONFIG_TYPE_SHFT             0
#define SH_RTC3_INT_CONFIG_TYPE_MASK             0x0000000000000007

/*   SH_RTC3_INT_CONFIG_AGT                                             */
/*   Description:  Agent, must be 0 for SHub                            */
#define SH_RTC3_INT_CONFIG_AGT_SHFT              3
#define SH_RTC3_INT_CONFIG_AGT_MASK              0x0000000000000008

/*   SH_RTC3_INT_CONFIG_PID                                             */
/*   Description:  Processor ID, same setting as on targeted McKinley  */
#define SH_RTC3_INT_CONFIG_PID_SHFT              4
#define SH_RTC3_INT_CONFIG_PID_MASK              0x00000000000ffff0

/*   SH_RTC3_INT_CONFIG_BASE                                            */
/*   Description:  Optional interrupt vector area, 2MB aligned          */
#define SH_RTC3_INT_CONFIG_BASE_SHFT             21
#define SH_RTC3_INT_CONFIG_BASE_MASK             0x0003ffffffe00000

/*   SH_RTC3_INT_CONFIG_IDX                                             */
/*   Description:  Targeted McKinley interrupt vector                   */
#define SH_RTC3_INT_CONFIG_IDX_SHFT              52
#define SH_RTC3_INT_CONFIG_IDX_MASK              0x0ff0000000000000

/* ==================================================================== */
/*                    Register "SH_RTC3_INT_ENABLE"                     */
/*                SHub RTC 3 Interrupt Enable Registers                 */
/* ==================================================================== */

#define SH_RTC3_INT_ENABLE                       0x0000000110001700
#define SH_RTC3_INT_ENABLE_MASK                  0x0000000000000001
#define SH_RTC3_INT_ENABLE_INIT                  0x0000000000000000

/*   SH_RTC3_INT_ENABLE_RTC3_ENABLE                                     */
/*   Description:  Enable RTC 3 Interrupt                               */
#define SH_RTC3_INT_ENABLE_RTC3_ENABLE_SHFT      0
#define SH_RTC3_INT_ENABLE_RTC3_ENABLE_MASK      0x0000000000000001

/* ==================================================================== */
/*                     Register "SH_EVENT_OCCURRED"                     */
/*                    SHub Interrupt Event Occurred                     */
/* ==================================================================== */

#define SH_EVENT_OCCURRED                        0x0000000110010000
#define SH_EVENT_OCCURRED_MASK                   0x000000007fffffff
#define SH_EVENT_OCCURRED_INIT                   0x0000000000000000

/*   SH_EVENT_OCCURRED_PI_HW_INT                                        */
/*   Description:  Pending PI Hardware interrupt                        */
#define SH_EVENT_OCCURRED_PI_HW_INT_SHFT         0
#define SH_EVENT_OCCURRED_PI_HW_INT_MASK         0x0000000000000001

/*   SH_EVENT_OCCURRED_MD_HW_INT                                        */
/*   Description:  Pending MD Hardware interrupt                        */
#define SH_EVENT_OCCURRED_MD_HW_INT_SHFT         1
#define SH_EVENT_OCCURRED_MD_HW_INT_MASK         0x0000000000000002

/*   SH_EVENT_OCCURRED_XN_HW_INT                                        */
/*   Description:  Pending XN Hardware interrupt                        */
#define SH_EVENT_OCCURRED_XN_HW_INT_SHFT         2
#define SH_EVENT_OCCURRED_XN_HW_INT_MASK         0x0000000000000004

/*   SH_EVENT_OCCURRED_LB_HW_INT                                        */
/*   Description:  Pending LB Hardware interrupt                        */
#define SH_EVENT_OCCURRED_LB_HW_INT_SHFT         3
#define SH_EVENT_OCCURRED_LB_HW_INT_MASK         0x0000000000000008

/*   SH_EVENT_OCCURRED_II_HW_INT                                        */
/*   Description:  Pending II wrapper Hardware interrupt                */
#define SH_EVENT_OCCURRED_II_HW_INT_SHFT         4
#define SH_EVENT_OCCURRED_II_HW_INT_MASK         0x0000000000000010

/*   SH_EVENT_OCCURRED_PI_CE_INT                                        */
/*   Description:  Pending PI Correctable Error Interrupt               */
#define SH_EVENT_OCCURRED_PI_CE_INT_SHFT         5
#define SH_EVENT_OCCURRED_PI_CE_INT_MASK         0x0000000000000020

/*   SH_EVENT_OCCURRED_MD_CE_INT                                        */
/*   Description:  Pending MD Correctable Error Interrupt               */
#define SH_EVENT_OCCURRED_MD_CE_INT_SHFT         6
#define SH_EVENT_OCCURRED_MD_CE_INT_MASK         0x0000000000000040

/*   SH_EVENT_OCCURRED_XN_CE_INT                                        */
/*   Description:  Pending XN Correctable Error Interrupt               */
#define SH_EVENT_OCCURRED_XN_CE_INT_SHFT         7
#define SH_EVENT_OCCURRED_XN_CE_INT_MASK         0x0000000000000080

/*   SH_EVENT_OCCURRED_PI_UCE_INT                                       */
/*   Description:  Pending PI Correctable Error Interrupt               */
#define SH_EVENT_OCCURRED_PI_UCE_INT_SHFT        8
#define SH_EVENT_OCCURRED_PI_UCE_INT_MASK        0x0000000000000100

/*   SH_EVENT_OCCURRED_MD_UCE_INT                                       */
/*   Description:  Pending MD Correctable Error Interrupt               */
#define SH_EVENT_OCCURRED_MD_UCE_INT_SHFT        9
#define SH_EVENT_OCCURRED_MD_UCE_INT_MASK        0x0000000000000200

/*   SH_EVENT_OCCURRED_XN_UCE_INT                                       */
/*   Description:  Pending XN Correctable Error Interrupt               */
#define SH_EVENT_OCCURRED_XN_UCE_INT_SHFT        10
#define SH_EVENT_OCCURRED_XN_UCE_INT_MASK        0x0000000000000400

/*   SH_EVENT_OCCURRED_PROC0_ADV_INT                                    */
/*   Description:  Pending Processor 0 Advisory Interrupt               */
#define SH_EVENT_OCCURRED_PROC0_ADV_INT_SHFT     11
#define SH_EVENT_OCCURRED_PROC0_ADV_INT_MASK     0x0000000000000800

/*   SH_EVENT_OCCURRED_PROC1_ADV_INT                                    */
/*   Description:  Pending Processor 1 Advisory Interrupt               */
#define SH_EVENT_OCCURRED_PROC1_ADV_INT_SHFT     12
#define SH_EVENT_OCCURRED_PROC1_ADV_INT_MASK     0x0000000000001000

/*   SH_EVENT_OCCURRED_PROC2_ADV_INT                                    */
/*   Description:  Pending Processor 2 Advisory Interrupt               */
#define SH_EVENT_OCCURRED_PROC2_ADV_INT_SHFT     13
#define SH_EVENT_OCCURRED_PROC2_ADV_INT_MASK     0x0000000000002000

/*   SH_EVENT_OCCURRED_PROC3_ADV_INT                                    */
/*   Description:  Pending Processor 3 Advisory Interrupt               */
#define SH_EVENT_OCCURRED_PROC3_ADV_INT_SHFT     14
#define SH_EVENT_OCCURRED_PROC3_ADV_INT_MASK     0x0000000000004000

/*   SH_EVENT_OCCURRED_PROC0_ERR_INT                                    */
/*   Description:  Pending Processor 0 Error Interrupt                  */
#define SH_EVENT_OCCURRED_PROC0_ERR_INT_SHFT     15
#define SH_EVENT_OCCURRED_PROC0_ERR_INT_MASK     0x0000000000008000

/*   SH_EVENT_OCCURRED_PROC1_ERR_INT                                    */
/*   Description:  Pending Processor 1 Error Interrupt                  */
#define SH_EVENT_OCCURRED_PROC1_ERR_INT_SHFT     16
#define SH_EVENT_OCCURRED_PROC1_ERR_INT_MASK     0x0000000000010000

/*   SH_EVENT_OCCURRED_PROC2_ERR_INT                                    */
/*   Description:  Pending Processor 2 Error Interrupt                  */
#define SH_EVENT_OCCURRED_PROC2_ERR_INT_SHFT     17
#define SH_EVENT_OCCURRED_PROC2_ERR_INT_MASK     0x0000000000020000

/*   SH_EVENT_OCCURRED_PROC3_ERR_INT                                    */
/*   Description:  Pending Processor 3 Error Interrupt                  */
#define SH_EVENT_OCCURRED_PROC3_ERR_INT_SHFT     18
#define SH_EVENT_OCCURRED_PROC3_ERR_INT_MASK     0x0000000000040000

/*   SH_EVENT_OCCURRED_SYSTEM_SHUTDOWN_INT                              */
/*   Description:  Pending System Shutdown Interrupt                    */
#define SH_EVENT_OCCURRED_SYSTEM_SHUTDOWN_INT_SHFT 19
#define SH_EVENT_OCCURRED_SYSTEM_SHUTDOWN_INT_MASK 0x0000000000080000

/*   SH_EVENT_OCCURRED_UART_INT                                         */
/*   Description:  Pending Junk Bus UART Interrupt                      */
#define SH_EVENT_OCCURRED_UART_INT_SHFT          20
#define SH_EVENT_OCCURRED_UART_INT_MASK          0x0000000000100000

/*   SH_EVENT_OCCURRED_L1_NMI_INT                                       */
/*   Description:  Pending L1 Controller NMI Interrupt                  */
#define SH_EVENT_OCCURRED_L1_NMI_INT_SHFT        21
#define SH_EVENT_OCCURRED_L1_NMI_INT_MASK        0x0000000000200000

/*   SH_EVENT_OCCURRED_STOP_CLOCK                                       */
/*   Description:  Pending Stop Clock Interrupt                         */
#define SH_EVENT_OCCURRED_STOP_CLOCK_SHFT        22
#define SH_EVENT_OCCURRED_STOP_CLOCK_MASK        0x0000000000400000

/*   SH_EVENT_OCCURRED_RTC0_INT                                         */
/*   Description:  Pending RTC 0 Interrupt                              */
#define SH_EVENT_OCCURRED_RTC0_INT_SHFT          23
#define SH_EVENT_OCCURRED_RTC0_INT_MASK          0x0000000000800000

/*   SH_EVENT_OCCURRED_RTC1_INT                                         */
/*   Description:  Pending RTC 1 Interrupt                              */
#define SH_EVENT_OCCURRED_RTC1_INT_SHFT          24
#define SH_EVENT_OCCURRED_RTC1_INT_MASK          0x0000000001000000

/*   SH_EVENT_OCCURRED_RTC2_INT                                         */
/*   Description:  Pending RTC 2 Interrupt                              */
#define SH_EVENT_OCCURRED_RTC2_INT_SHFT          25
#define SH_EVENT_OCCURRED_RTC2_INT_MASK          0x0000000002000000

/*   SH_EVENT_OCCURRED_RTC3_INT                                         */
/*   Description:  Pending RTC 3 Interrupt                              */
#define SH_EVENT_OCCURRED_RTC3_INT_SHFT          26
#define SH_EVENT_OCCURRED_RTC3_INT_MASK          0x0000000004000000

/*   SH_EVENT_OCCURRED_PROFILE_INT                                      */
/*   Description:  Pending Profile Interrupt                            */
#define SH_EVENT_OCCURRED_PROFILE_INT_SHFT       27
#define SH_EVENT_OCCURRED_PROFILE_INT_MASK       0x0000000008000000

/*   SH_EVENT_OCCURRED_IPI_INT                                          */
/*   Description:  Pending IPI Interrupt                                */
#define SH_EVENT_OCCURRED_IPI_INT_SHFT           28
#define SH_EVENT_OCCURRED_IPI_INT_MASK           0x0000000010000000

/*   SH_EVENT_OCCURRED_II_INT0                                          */
/*   Description:  Pending II 0 Interrupt                               */
#define SH_EVENT_OCCURRED_II_INT0_SHFT           29
#define SH_EVENT_OCCURRED_II_INT0_MASK           0x0000000020000000

/*   SH_EVENT_OCCURRED_II_INT1                                          */
/*   Description:  Pending II 1 Interrupt                               */
#define SH_EVENT_OCCURRED_II_INT1_SHFT           30
#define SH_EVENT_OCCURRED_II_INT1_MASK           0x0000000040000000

/* ==================================================================== */
/*                  Register "SH_EVENT_OCCURRED_ALIAS"                  */
/*                 SHub Interrupt Event Occurred Alias                  */
/* ==================================================================== */

#define SH_EVENT_OCCURRED_ALIAS                  0x0000000110010008

/* ==================================================================== */
/*                     Register "SH_EVENT_OVERFLOW"                     */
/*                SHub Interrupt Event Occurred Overflow                */
/* ==================================================================== */

#define SH_EVENT_OVERFLOW                        0x0000000110010080
#define SH_EVENT_OVERFLOW_MASK                   0x000000000fffffff
#define SH_EVENT_OVERFLOW_INIT                   0x0000000000000000

/*   SH_EVENT_OVERFLOW_PI_HW_INT                                        */
/*   Description:  Pending PI Hardware interrupt                        */
#define SH_EVENT_OVERFLOW_PI_HW_INT_SHFT         0
#define SH_EVENT_OVERFLOW_PI_HW_INT_MASK         0x0000000000000001

/*   SH_EVENT_OVERFLOW_MD_HW_INT                                        */
/*   Description:  Pending MD Hardware interrupt                        */
#define SH_EVENT_OVERFLOW_MD_HW_INT_SHFT         1
#define SH_EVENT_OVERFLOW_MD_HW_INT_MASK         0x0000000000000002

/*   SH_EVENT_OVERFLOW_XN_HW_INT                                        */
/*   Description:  Pending XN Hardware interrupt                        */
#define SH_EVENT_OVERFLOW_XN_HW_INT_SHFT         2
#define SH_EVENT_OVERFLOW_XN_HW_INT_MASK         0x0000000000000004

/*   SH_EVENT_OVERFLOW_LB_HW_INT                                        */
/*   Description:  Pending LB Hardware interrupt                        */
#define SH_EVENT_OVERFLOW_LB_HW_INT_SHFT         3
#define SH_EVENT_OVERFLOW_LB_HW_INT_MASK         0x0000000000000008

/*   SH_EVENT_OVERFLOW_II_HW_INT                                        */
/*   Description:  Pending II wrapper Hardware interrupt                */
#define SH_EVENT_OVERFLOW_II_HW_INT_SHFT         4
#define SH_EVENT_OVERFLOW_II_HW_INT_MASK         0x0000000000000010

/*   SH_EVENT_OVERFLOW_PI_CE_INT                                        */
/*   Description:  Pending PI Correctable Error Interrupt               */
#define SH_EVENT_OVERFLOW_PI_CE_INT_SHFT         5
#define SH_EVENT_OVERFLOW_PI_CE_INT_MASK         0x0000000000000020

/*   SH_EVENT_OVERFLOW_MD_CE_INT                                        */
/*   Description:  Pending MD Correctable Error Interrupt               */
#define SH_EVENT_OVERFLOW_MD_CE_INT_SHFT         6
#define SH_EVENT_OVERFLOW_MD_CE_INT_MASK         0x0000000000000040

/*   SH_EVENT_OVERFLOW_XN_CE_INT                                        */
/*   Description:  Pending XN Correctable Error Interrupt               */
#define SH_EVENT_OVERFLOW_XN_CE_INT_SHFT         7
#define SH_EVENT_OVERFLOW_XN_CE_INT_MASK         0x0000000000000080

/*   SH_EVENT_OVERFLOW_PI_UCE_INT                                       */
/*   Description:  Pending PI Correctable Error Interrupt               */
#define SH_EVENT_OVERFLOW_PI_UCE_INT_SHFT        8
#define SH_EVENT_OVERFLOW_PI_UCE_INT_MASK        0x0000000000000100

/*   SH_EVENT_OVERFLOW_MD_UCE_INT                                       */
/*   Description:  Pending MD Correctable Error Interrupt               */
#define SH_EVENT_OVERFLOW_MD_UCE_INT_SHFT        9
#define SH_EVENT_OVERFLOW_MD_UCE_INT_MASK        0x0000000000000200

/*   SH_EVENT_OVERFLOW_XN_UCE_INT                                       */
/*   Description:  Pending XN Correctable Error Interrupt               */
#define SH_EVENT_OVERFLOW_XN_UCE_INT_SHFT        10
#define SH_EVENT_OVERFLOW_XN_UCE_INT_MASK        0x0000000000000400

/*   SH_EVENT_OVERFLOW_PROC0_ADV_INT                                    */
/*   Description:  Pending Processor 0 Advisory Interrupt               */
#define SH_EVENT_OVERFLOW_PROC0_ADV_INT_SHFT     11
#define SH_EVENT_OVERFLOW_PROC0_ADV_INT_MASK     0x0000000000000800

/*   SH_EVENT_OVERFLOW_PROC1_ADV_INT                                    */
/*   Description:  Pending Processor 1 Advisory Interrupt               */
#define SH_EVENT_OVERFLOW_PROC1_ADV_INT_SHFT     12
#define SH_EVENT_OVERFLOW_PROC1_ADV_INT_MASK     0x0000000000001000

/*   SH_EVENT_OVERFLOW_PROC2_ADV_INT                                    */
/*   Description:  Pending Processor 2 Advisory Interrupt               */
#define SH_EVENT_OVERFLOW_PROC2_ADV_INT_SHFT     13
#define SH_EVENT_OVERFLOW_PROC2_ADV_INT_MASK     0x0000000000002000

/*   SH_EVENT_OVERFLOW_PROC3_ADV_INT                                    */
/*   Description:  Pending Processor 3 Advisory Interrupt               */
#define SH_EVENT_OVERFLOW_PROC3_ADV_INT_SHFT     14
#define SH_EVENT_OVERFLOW_PROC3_ADV_INT_MASK     0x0000000000004000

/*   SH_EVENT_OVERFLOW_PROC0_ERR_INT                                    */
/*   Description:  Pending Processor 0 Error Interrupt                  */
#define SH_EVENT_OVERFLOW_PROC0_ERR_INT_SHFT     15
#define SH_EVENT_OVERFLOW_PROC0_ERR_INT_MASK     0x0000000000008000

/*   SH_EVENT_OVERFLOW_PROC1_ERR_INT                                    */
/*   Description:  Pending Processor 1 Error Interrupt                  */
#define SH_EVENT_OVERFLOW_PROC1_ERR_INT_SHFT     16
#define SH_EVENT_OVERFLOW_PROC1_ERR_INT_MASK     0x0000000000010000

/*   SH_EVENT_OVERFLOW_PROC2_ERR_INT                                    */
/*   Description:  Pending Processor 2 Error Interrupt                  */
#define SH_EVENT_OVERFLOW_PROC2_ERR_INT_SHFT     17
#define SH_EVENT_OVERFLOW_PROC2_ERR_INT_MASK     0x0000000000020000

/*   SH_EVENT_OVERFLOW_PROC3_ERR_INT                                    */
/*   Description:  Pending Processor 3 Error Interrupt                  */
#define SH_EVENT_OVERFLOW_PROC3_ERR_INT_SHFT     18
#define SH_EVENT_OVERFLOW_PROC3_ERR_INT_MASK     0x0000000000040000

/*   SH_EVENT_OVERFLOW_SYSTEM_SHUTDOWN_INT                              */
/*   Description:  Pending System Shutdown Interrupt                    */
#define SH_EVENT_OVERFLOW_SYSTEM_SHUTDOWN_INT_SHFT 19
#define SH_EVENT_OVERFLOW_SYSTEM_SHUTDOWN_INT_MASK 0x0000000000080000

/*   SH_EVENT_OVERFLOW_UART_INT                                         */
/*   Description:  Pending Junk Bus UART Interrupt                      */
#define SH_EVENT_OVERFLOW_UART_INT_SHFT          20
#define SH_EVENT_OVERFLOW_UART_INT_MASK          0x0000000000100000

/*   SH_EVENT_OVERFLOW_L1_NMI_INT                                       */
/*   Description:  Pending L1 Controller NMI Interrupt                  */
#define SH_EVENT_OVERFLOW_L1_NMI_INT_SHFT        21
#define SH_EVENT_OVERFLOW_L1_NMI_INT_MASK        0x0000000000200000

/*   SH_EVENT_OVERFLOW_STOP_CLOCK                                       */
/*   Description:  Pending Stop Clock Interrupt                         */
#define SH_EVENT_OVERFLOW_STOP_CLOCK_SHFT        22
#define SH_EVENT_OVERFLOW_STOP_CLOCK_MASK        0x0000000000400000

/*   SH_EVENT_OVERFLOW_RTC0_INT                                         */
/*   Description:  Pending RTC 0 Interrupt                              */
#define SH_EVENT_OVERFLOW_RTC0_INT_SHFT          23
#define SH_EVENT_OVERFLOW_RTC0_INT_MASK          0x0000000000800000

/*   SH_EVENT_OVERFLOW_RTC1_INT                                         */
/*   Description:  Pending RTC 1 Interrupt                              */
#define SH_EVENT_OVERFLOW_RTC1_INT_SHFT          24
#define SH_EVENT_OVERFLOW_RTC1_INT_MASK          0x0000000001000000

/*   SH_EVENT_OVERFLOW_RTC2_INT                                         */
/*   Description:  Pending RTC 2 Interrupt                              */
#define SH_EVENT_OVERFLOW_RTC2_INT_SHFT          25
#define SH_EVENT_OVERFLOW_RTC2_INT_MASK          0x0000000002000000

/*   SH_EVENT_OVERFLOW_RTC3_INT                                         */
/*   Description:  Pending RTC 3 Interrupt                              */
#define SH_EVENT_OVERFLOW_RTC3_INT_SHFT          26
#define SH_EVENT_OVERFLOW_RTC3_INT_MASK          0x0000000004000000

/*   SH_EVENT_OVERFLOW_PROFILE_INT                                      */
/*   Description:  Pending Profile Interrupt                            */
#define SH_EVENT_OVERFLOW_PROFILE_INT_SHFT       27
#define SH_EVENT_OVERFLOW_PROFILE_INT_MASK       0x0000000008000000

/* ==================================================================== */
/*                  Register "SH_EVENT_OVERFLOW_ALIAS"                  */
/*             SHub Interrupt Event Occurred Overflow Alias             */
/* ==================================================================== */

#define SH_EVENT_OVERFLOW_ALIAS                  0x0000000110010088

/* ==================================================================== */
/*                     Register "SH_JUNK_BUS_TIME"                      */
/*                           Junk Bus Timing                            */
/* ==================================================================== */

#define SH_JUNK_BUS_TIME                         0x0000000110020000
#define SH_JUNK_BUS_TIME_MASK                    0x00000000ffffffff
#define SH_JUNK_BUS_TIME_INIT                    0x0000000040404040

/*   SH_JUNK_BUS_TIME_FPROM_SETUP_HOLD                                  */
/*   Description:  Fprom_Setup_Hold                                     */
#define SH_JUNK_BUS_TIME_FPROM_SETUP_HOLD_SHFT   0
#define SH_JUNK_BUS_TIME_FPROM_SETUP_HOLD_MASK   0x00000000000000ff

/*   SH_JUNK_BUS_TIME_FPROM_ENABLE                                      */
/*   Description:  Fprom_Enable                                         */
#define SH_JUNK_BUS_TIME_FPROM_ENABLE_SHFT       8
#define SH_JUNK_BUS_TIME_FPROM_ENABLE_MASK       0x000000000000ff00

/*   SH_JUNK_BUS_TIME_UART_SETUP_HOLD                                   */
/*   Description:  Uart_Setup_Hold                                      */
#define SH_JUNK_BUS_TIME_UART_SETUP_HOLD_SHFT    16
#define SH_JUNK_BUS_TIME_UART_SETUP_HOLD_MASK    0x0000000000ff0000

/*   SH_JUNK_BUS_TIME_UART_ENABLE                                       */
/*   Description:  Uart_Enable                                          */
#define SH_JUNK_BUS_TIME_UART_ENABLE_SHFT        24
#define SH_JUNK_BUS_TIME_UART_ENABLE_MASK        0x00000000ff000000

/* ==================================================================== */
/*                    Register "SH_JUNK_LATCH_TIME"                     */
/*                        Junk Bus Latch Timing                         */
/* ==================================================================== */

#define SH_JUNK_LATCH_TIME                       0x0000000110020080
#define SH_JUNK_LATCH_TIME_MASK                  0x0000000000000007
#define SH_JUNK_LATCH_TIME_INIT                  0x0000000000000002

/*   SH_JUNK_LATCH_TIME_SETUP_HOLD                                      */
/*   Description:  Setup and Hold Time                                  */
#define SH_JUNK_LATCH_TIME_SETUP_HOLD_SHFT       0
#define SH_JUNK_LATCH_TIME_SETUP_HOLD_MASK       0x0000000000000007

/* ==================================================================== */
/*                    Register "SH_JUNK_NACK_RESET"                     */
/*                     Junk Bus Nack Counter Reset                      */
/* ==================================================================== */

#define SH_JUNK_NACK_RESET                       0x0000000110020100
#define SH_JUNK_NACK_RESET_MASK                  0x0000000000000001
#define SH_JUNK_NACK_RESET_INIT                  0x0000000000000000

/*   SH_JUNK_NACK_RESET_PULSE                                           */
/*   Description:  Junk bus nack counter reset                          */
#define SH_JUNK_NACK_RESET_PULSE_SHFT            0
#define SH_JUNK_NACK_RESET_PULSE_MASK            0x0000000000000001

/* ==================================================================== */
/*                     Register "SH_JUNK_BUS_LED0"                      */
/*                            Junk Bus LED0                             */
/* ==================================================================== */

#define SH_JUNK_BUS_LED0                         0x0000000110030000
#define SH_JUNK_BUS_LED0_MASK                    0x00000000000000ff
#define SH_JUNK_BUS_LED0_INIT                    0x0000000000000000

/*   SH_JUNK_BUS_LED0_LED0_DATA                                         */
/*   Description:  LED0_data                                            */
#define SH_JUNK_BUS_LED0_LED0_DATA_SHFT          0
#define SH_JUNK_BUS_LED0_LED0_DATA_MASK          0x00000000000000ff

/* ==================================================================== */
/*                     Register "SH_JUNK_BUS_LED1"                      */
/*                            Junk Bus LED1                             */
/* ==================================================================== */

#define SH_JUNK_BUS_LED1                         0x0000000110030080
#define SH_JUNK_BUS_LED1_MASK                    0x00000000000000ff
#define SH_JUNK_BUS_LED1_INIT                    0x0000000000000000

/*   SH_JUNK_BUS_LED1_LED1_DATA                                         */
/*   Description:  LED1_data                                            */
#define SH_JUNK_BUS_LED1_LED1_DATA_SHFT          0
#define SH_JUNK_BUS_LED1_LED1_DATA_MASK          0x00000000000000ff

/* ==================================================================== */
/*                     Register "SH_JUNK_BUS_LED2"                      */
/*                            Junk Bus LED2                             */
/* ==================================================================== */

#define SH_JUNK_BUS_LED2                         0x0000000110030100
#define SH_JUNK_BUS_LED2_MASK                    0x00000000000000ff
#define SH_JUNK_BUS_LED2_INIT                    0x0000000000000000

/*   SH_JUNK_BUS_LED2_LED2_DATA                                         */
/*   Description:  LED2_data                                            */
#define SH_JUNK_BUS_LED2_LED2_DATA_SHFT          0
#define SH_JUNK_BUS_LED2_LED2_DATA_MASK          0x00000000000000ff

/* ==================================================================== */
/*                     Register "SH_JUNK_BUS_LED3"                      */
/*                            Junk Bus LED3                             */
/* ==================================================================== */

#define SH_JUNK_BUS_LED3                         0x0000000110030180
#define SH_JUNK_BUS_LED3_MASK                    0x00000000000000ff
#define SH_JUNK_BUS_LED3_INIT                    0x0000000000000000

/*   SH_JUNK_BUS_LED3_LED3_DATA                                         */
/*   Description:  LED3_data                                            */
#define SH_JUNK_BUS_LED3_LED3_DATA_SHFT          0
#define SH_JUNK_BUS_LED3_LED3_DATA_MASK          0x00000000000000ff

/* ==================================================================== */
/*                   Register "SH_JUNK_ERROR_STATUS"                    */
/*                        Junk Bus Error Status                         */
/* ==================================================================== */

#define SH_JUNK_ERROR_STATUS                     0x0000000110030200
#define SH_JUNK_ERROR_STATUS_MASK                0x1fff7fffffffffff
#define SH_JUNK_ERROR_STATUS_INIT                0x0000000000000000

/*   SH_JUNK_ERROR_STATUS_ADDRESS                                       */
/*   Description:  Failing junk bus address                             */
#define SH_JUNK_ERROR_STATUS_ADDRESS_SHFT        0
#define SH_JUNK_ERROR_STATUS_ADDRESS_MASK        0x00007fffffffffff

/*   SH_JUNK_ERROR_STATUS_CMD                                           */
/*   Description:  Junk bus command                                     */
#define SH_JUNK_ERROR_STATUS_CMD_SHFT            48
#define SH_JUNK_ERROR_STATUS_CMD_MASK            0x00ff000000000000

/*   SH_JUNK_ERROR_STATUS_MODE                                          */
/*   Description:  Mode                                                 */
#define SH_JUNK_ERROR_STATUS_MODE_SHFT           56
#define SH_JUNK_ERROR_STATUS_MODE_MASK           0x0100000000000000

/*   SH_JUNK_ERROR_STATUS_STATUS                                        */
/*   Description:  Status                                               */
#define SH_JUNK_ERROR_STATUS_STATUS_SHFT         57
#define SH_JUNK_ERROR_STATUS_STATUS_MASK         0x1e00000000000000

/* ==================================================================== */
/*                      Register "SH_NI0_LLP_STAT"                      */
/*               This register describes the LLP status.                */
/* ==================================================================== */

#define SH_NI0_LLP_STAT                          0x0000000150000000
#define SH_NI0_LLP_STAT_MASK                     0x000000000000000f
#define SH_NI0_LLP_STAT_INIT                     0x0000000000000000

/*   SH_NI0_LLP_STAT_LINK_RESET_STATE                                   */
/*   Description:  Status of LLP link.                                  */
#define SH_NI0_LLP_STAT_LINK_RESET_STATE_SHFT    0
#define SH_NI0_LLP_STAT_LINK_RESET_STATE_MASK    0x000000000000000f

/* ==================================================================== */
/*                     Register "SH_NI0_LLP_RESET"                      */
/*           Writing issues a reset to the network interface            */
/* ==================================================================== */

#define SH_NI0_LLP_RESET                         0x0000000150000008
#define SH_NI0_LLP_RESET_MASK                    0x0000000000000003
#define SH_NI0_LLP_RESET_INIT                    0x0000000000000000

/*   SH_NI0_LLP_RESET_LINK                                              */
/*   Description:  Send Link Reset. Generates a pulse.                  */
#define SH_NI0_LLP_RESET_LINK_SHFT               0
#define SH_NI0_LLP_RESET_LINK_MASK               0x0000000000000001

/*   SH_NI0_LLP_RESET_WARM                                              */
/*   Description:  Send Warm Reset. Generates a pulse.                  */
#define SH_NI0_LLP_RESET_WARM_SHFT               1
#define SH_NI0_LLP_RESET_WARM_MASK               0x0000000000000002

/* ==================================================================== */
/*                    Register "SH_NI0_LLP_RESET_EN"                    */
/*                 Controls LLP warm reset propagation                  */
/* ==================================================================== */

#define SH_NI0_LLP_RESET_EN                      0x0000000150000010
#define SH_NI0_LLP_RESET_EN_MASK                 0x0000000000000001
#define SH_NI0_LLP_RESET_EN_INIT                 0x0000000000000001

/*   SH_NI0_LLP_RESET_EN_OK                                             */
/*   Description:  Allow LLP warm reset to reset SHUB                   */
#define SH_NI0_LLP_RESET_EN_OK_SHFT              0
#define SH_NI0_LLP_RESET_EN_OK_MASK              0x0000000000000001

/* ==================================================================== */
/*                   Register "SH_NI0_LLP_CHAN_MODE"                    */
/*              Sets the signaling mode of LLP and channel              */
/* ==================================================================== */

#define SH_NI0_LLP_CHAN_MODE                     0x0000000150000018
#define SH_NI0_LLP_CHAN_MODE_MASK                0x000000000000001f
#define SH_NI0_LLP_CHAN_MODE_INIT                0x0000000000000000

/*   SH_NI0_LLP_CHAN_MODE_BITMODE32                                     */
/*   Description:  Enables 32-bit (plus sideband) channel phits         */
#define SH_NI0_LLP_CHAN_MODE_BITMODE32_SHFT      0
#define SH_NI0_LLP_CHAN_MODE_BITMODE32_MASK      0x0000000000000001

/*   SH_NI0_LLP_CHAN_MODE_AC_ENCODE                                     */
/*   Description:  Enables nearly dc-free encoding for AC-coupling      */
#define SH_NI0_LLP_CHAN_MODE_AC_ENCODE_SHFT      1
#define SH_NI0_LLP_CHAN_MODE_AC_ENCODE_MASK      0x0000000000000002

/*   SH_NI0_LLP_CHAN_MODE_ENABLE_TUNING                                 */
/*   Description:  Enables automatic tuning of channel skew.            */
#define SH_NI0_LLP_CHAN_MODE_ENABLE_TUNING_SHFT  2
#define SH_NI0_LLP_CHAN_MODE_ENABLE_TUNING_MASK  0x0000000000000004

/*   SH_NI0_LLP_CHAN_MODE_ENABLE_RMT_FT_UPD                             */
/*   Description:  Enables remote fine tune updates                     */
#define SH_NI0_LLP_CHAN_MODE_ENABLE_RMT_FT_UPD_SHFT 3
#define SH_NI0_LLP_CHAN_MODE_ENABLE_RMT_FT_UPD_MASK 0x0000000000000008

/*   SH_NI0_LLP_CHAN_MODE_ENABLE_CLKQUAD                                */
/*   Description:  Enables quadrature clock in the pfssd                */
#define SH_NI0_LLP_CHAN_MODE_ENABLE_CLKQUAD_SHFT 4
#define SH_NI0_LLP_CHAN_MODE_ENABLE_CLKQUAD_MASK 0x0000000000000010

/* ==================================================================== */
/*                     Register "SH_NI0_LLP_CONFIG"                     */
/*              Sets the configuration of LLP and channel               */
/* ==================================================================== */

#define SH_NI0_LLP_CONFIG                        0x0000000150000020
#define SH_NI0_LLP_CONFIG_MASK                   0x0000003fffffffff
#define SH_NI0_LLP_CONFIG_INIT                   0x00000007fc6ffd00

/*   SH_NI0_LLP_CONFIG_MAXBURST                                         */
#define SH_NI0_LLP_CONFIG_MAXBURST_SHFT          0
#define SH_NI0_LLP_CONFIG_MAXBURST_MASK          0x00000000000003ff

/*   SH_NI0_LLP_CONFIG_MAXRETRY                                         */
#define SH_NI0_LLP_CONFIG_MAXRETRY_SHFT          10
#define SH_NI0_LLP_CONFIG_MAXRETRY_MASK          0x00000000000ffc00

/*   SH_NI0_LLP_CONFIG_NULLTIMEOUT                                      */
#define SH_NI0_LLP_CONFIG_NULLTIMEOUT_SHFT       20
#define SH_NI0_LLP_CONFIG_NULLTIMEOUT_MASK       0x0000000003f00000

/*   SH_NI0_LLP_CONFIG_FTU_TIME                                         */
#define SH_NI0_LLP_CONFIG_FTU_TIME_SHFT          26
#define SH_NI0_LLP_CONFIG_FTU_TIME_MASK          0x0000003ffc000000

/* ==================================================================== */
/*                    Register "SH_NI0_LLP_TEST_CTL"                    */
/* ==================================================================== */

#define SH_NI0_LLP_TEST_CTL                      0x0000000150000028
#define SH_NI0_LLP_TEST_CTL_MASK                 0x7ff3f3ffffffffff
#define SH_NI0_LLP_TEST_CTL_INIT                 0x000000000a5fffff

/*   SH_NI0_LLP_TEST_CTL_PATTERN                                        */
/*   Description:  Send channel data pattern                            */
#define SH_NI0_LLP_TEST_CTL_PATTERN_SHFT         0
#define SH_NI0_LLP_TEST_CTL_PATTERN_MASK         0x000000ffffffffff

/*   SH_NI0_LLP_TEST_CTL_SEND_TEST_MODE                                 */
/*   Description:  Enables continuous send of data                      */
#define SH_NI0_LLP_TEST_CTL_SEND_TEST_MODE_SHFT  40
#define SH_NI0_LLP_TEST_CTL_SEND_TEST_MODE_MASK  0x0000030000000000

/*   SH_NI0_LLP_TEST_CTL_WIRE_SEL                                       */
#define SH_NI0_LLP_TEST_CTL_WIRE_SEL_SHFT        44
#define SH_NI0_LLP_TEST_CTL_WIRE_SEL_MASK        0x0003f00000000000

/*   SH_NI0_LLP_TEST_CTL_LFSR_MODE                                      */
#define SH_NI0_LLP_TEST_CTL_LFSR_MODE_SHFT       52
#define SH_NI0_LLP_TEST_CTL_LFSR_MODE_MASK       0x0030000000000000

/*   SH_NI0_LLP_TEST_CTL_NOISE_MODE                                     */
#define SH_NI0_LLP_TEST_CTL_NOISE_MODE_SHFT      54
#define SH_NI0_LLP_TEST_CTL_NOISE_MODE_MASK      0x00c0000000000000

/*   SH_NI0_LLP_TEST_CTL_ARMCAPTURE                                     */
/*   Description:  Enable Capture of Next MicroPacket                   */
#define SH_NI0_LLP_TEST_CTL_ARMCAPTURE_SHFT      56
#define SH_NI0_LLP_TEST_CTL_ARMCAPTURE_MASK      0x0100000000000000

/*   SH_NI0_LLP_TEST_CTL_CAPTURECBONLY                                  */
/*   Description:  Only capture a micropacket with a Check Byte error  */
#define SH_NI0_LLP_TEST_CTL_CAPTURECBONLY_SHFT   57
#define SH_NI0_LLP_TEST_CTL_CAPTURECBONLY_MASK   0x0200000000000000

/*   SH_NI0_LLP_TEST_CTL_SENDCBERROR                                    */
/*   Description:  Sends a single error                                 */
#define SH_NI0_LLP_TEST_CTL_SENDCBERROR_SHFT     58
#define SH_NI0_LLP_TEST_CTL_SENDCBERROR_MASK     0x0400000000000000

/*   SH_NI0_LLP_TEST_CTL_SENDSNERROR                                    */
/*   Description:  Sends a single sequence number error                 */
#define SH_NI0_LLP_TEST_CTL_SENDSNERROR_SHFT     59
#define SH_NI0_LLP_TEST_CTL_SENDSNERROR_MASK     0x0800000000000000

/*   SH_NI0_LLP_TEST_CTL_FAKESNERROR                                    */
/*   Description:  Causes receiver to pretend it saw a sn error         */
#define SH_NI0_LLP_TEST_CTL_FAKESNERROR_SHFT     60
#define SH_NI0_LLP_TEST_CTL_FAKESNERROR_MASK     0x1000000000000000

/*   SH_NI0_LLP_TEST_CTL_CAPTURED                                       */
/*   Description:  Indicates a Valid Micropacket was captured           */
#define SH_NI0_LLP_TEST_CTL_CAPTURED_SHFT        61
#define SH_NI0_LLP_TEST_CTL_CAPTURED_MASK        0x2000000000000000

/*   SH_NI0_LLP_TEST_CTL_CBERROR                                        */
/*   Description:  Indicates a Micropacket with a CB error was capture  */
#define SH_NI0_LLP_TEST_CTL_CBERROR_SHFT         62
#define SH_NI0_LLP_TEST_CTL_CBERROR_MASK         0x4000000000000000

/* ==================================================================== */
/*                    Register "SH_NI0_LLP_CAPT_WD1"                    */
/*                    low order 64-bit captured word                    */
/* ==================================================================== */

#define SH_NI0_LLP_CAPT_WD1                      0x0000000150000030
#define SH_NI0_LLP_CAPT_WD1_MASK                 0xffffffffffffffff
#define SH_NI0_LLP_CAPT_WD1_INIT                 0x0000000000000000

/*   SH_NI0_LLP_CAPT_WD1_DATA                                           */
/*   Description:  low order 64-bit captured word                       */
#define SH_NI0_LLP_CAPT_WD1_DATA_SHFT            0
#define SH_NI0_LLP_CAPT_WD1_DATA_MASK            0xffffffffffffffff

/* ==================================================================== */
/*                    Register "SH_NI0_LLP_CAPT_WD2"                    */
/*                   high order 64-bit captured word                    */
/* ==================================================================== */

#define SH_NI0_LLP_CAPT_WD2                      0x0000000150000038
#define SH_NI0_LLP_CAPT_WD2_MASK                 0xffffffffffffffff
#define SH_NI0_LLP_CAPT_WD2_INIT                 0x0000000000000000

/*   SH_NI0_LLP_CAPT_WD2_DATA                                           */
/*   Description:  high order 64-bit captured word                      */
#define SH_NI0_LLP_CAPT_WD2_DATA_SHFT            0
#define SH_NI0_LLP_CAPT_WD2_DATA_MASK            0xffffffffffffffff

/* ==================================================================== */
/*                   Register "SH_NI0_LLP_CAPT_SBCB"                    */
/*                 captured sideband, sequence, and CRC                 */
/* ==================================================================== */

#define SH_NI0_LLP_CAPT_SBCB                     0x0000000150000040
#define SH_NI0_LLP_CAPT_SBCB_MASK                0x0000001fffffffff
#define SH_NI0_LLP_CAPT_SBCB_INIT                0x0000000000000000

/*   SH_NI0_LLP_CAPT_SBCB_CAPTUREDRCVSBSN                               */
/*   Description:  sideband and sequence                                */
#define SH_NI0_LLP_CAPT_SBCB_CAPTUREDRCVSBSN_SHFT 0
#define SH_NI0_LLP_CAPT_SBCB_CAPTUREDRCVSBSN_MASK 0x000000000000ffff

/*   SH_NI0_LLP_CAPT_SBCB_CAPTUREDRCVCRC                                */
/*   Description:  CRC                                                  */
#define SH_NI0_LLP_CAPT_SBCB_CAPTUREDRCVCRC_SHFT 16
#define SH_NI0_LLP_CAPT_SBCB_CAPTUREDRCVCRC_MASK 0x00000000ffff0000

/*   SH_NI0_LLP_CAPT_SBCB_SENTALLCBERRORS                               */
/*   Description:  All CB errors have been sent                         */
#define SH_NI0_LLP_CAPT_SBCB_SENTALLCBERRORS_SHFT 32
#define SH_NI0_LLP_CAPT_SBCB_SENTALLCBERRORS_MASK 0x0000000100000000

/*   SH_NI0_LLP_CAPT_SBCB_SENTALLSNERRORS                               */
/*   Description:  All SN errors have been sent                         */
#define SH_NI0_LLP_CAPT_SBCB_SENTALLSNERRORS_SHFT 33
#define SH_NI0_LLP_CAPT_SBCB_SENTALLSNERRORS_MASK 0x0000000200000000

/*   SH_NI0_LLP_CAPT_SBCB_FAKEDALLSNERRORS                              */
/*   Description:  All faked SN errors have been sent                   */
#define SH_NI0_LLP_CAPT_SBCB_FAKEDALLSNERRORS_SHFT 34
#define SH_NI0_LLP_CAPT_SBCB_FAKEDALLSNERRORS_MASK 0x0000000400000000

/*   SH_NI0_LLP_CAPT_SBCB_CHARGEOVERFLOW                                */
/*   Description:  wire charge counter overflowed, valid if llp_mode e  */
#define SH_NI0_LLP_CAPT_SBCB_CHARGEOVERFLOW_SHFT 35
#define SH_NI0_LLP_CAPT_SBCB_CHARGEOVERFLOW_MASK 0x0000000800000000

/*   SH_NI0_LLP_CAPT_SBCB_CHARGEUNDERFLOW                               */
/*   Description:  wire charge counter underflowed, valid if llp_mode   */
/*  enabled                                                             */
#define SH_NI0_LLP_CAPT_SBCB_CHARGEUNDERFLOW_SHFT 36
#define SH_NI0_LLP_CAPT_SBCB_CHARGEUNDERFLOW_MASK 0x0000001000000000

/* ==================================================================== */
/*                      Register "SH_NI0_LLP_ERR"                       */
/* ==================================================================== */

#define SH_NI0_LLP_ERR                           0x0000000150000048
#define SH_NI0_LLP_ERR_MASK                      0x001fffffffffffff
#define SH_NI0_LLP_ERR_INIT                      0x0000000000000000

/*   SH_NI0_LLP_ERR_RX_SN_ERR_COUNT                                     */
/*   Description:  Counts the sequence number errors received           */
#define SH_NI0_LLP_ERR_RX_SN_ERR_COUNT_SHFT      0
#define SH_NI0_LLP_ERR_RX_SN_ERR_COUNT_MASK      0x00000000000000ff

/*   SH_NI0_LLP_ERR_RX_CB_ERR_COUNT                                     */
/*   Description:  Counts the check byte errors received                */
#define SH_NI0_LLP_ERR_RX_CB_ERR_COUNT_SHFT      8
#define SH_NI0_LLP_ERR_RX_CB_ERR_COUNT_MASK      0x000000000000ff00

/*   SH_NI0_LLP_ERR_RETRY_COUNT                                         */
/*   Description:  Counts the retries                                   */
#define SH_NI0_LLP_ERR_RETRY_COUNT_SHFT          16
#define SH_NI0_LLP_ERR_RETRY_COUNT_MASK          0x0000000000ff0000

/*   SH_NI0_LLP_ERR_RETRY_TIMEOUT                                       */
/*   Description:  Indicates a retry timeout has occurred               */
#define SH_NI0_LLP_ERR_RETRY_TIMEOUT_SHFT        24
#define SH_NI0_LLP_ERR_RETRY_TIMEOUT_MASK        0x0000000001000000

/*   SH_NI0_LLP_ERR_RCV_LINK_RESET                                      */
/*   Description:  Indicates a link reset has been received             */
#define SH_NI0_LLP_ERR_RCV_LINK_RESET_SHFT       25
#define SH_NI0_LLP_ERR_RCV_LINK_RESET_MASK       0x0000000002000000

/*   SH_NI0_LLP_ERR_SQUASH                                              */
/*   Description:  Indicates a micropacket was squashed                 */
#define SH_NI0_LLP_ERR_SQUASH_SHFT               26
#define SH_NI0_LLP_ERR_SQUASH_MASK               0x0000000004000000

/*   SH_NI0_LLP_ERR_POWER_NOT_OK                                        */
/*   Description:  Detects and traps a loss of power_OK                 */
#define SH_NI0_LLP_ERR_POWER_NOT_OK_SHFT         27
#define SH_NI0_LLP_ERR_POWER_NOT_OK_MASK         0x0000000008000000

/*   SH_NI0_LLP_ERR_WIRE_CNT                                            */
/*   Description:  counts the errors detected on a single wire test     */
#define SH_NI0_LLP_ERR_WIRE_CNT_SHFT             28
#define SH_NI0_LLP_ERR_WIRE_CNT_MASK             0x000ffffff0000000

/*   SH_NI0_LLP_ERR_WIRE_OVERFLOW                                       */
/*   Description:  wire_error_cnt has overflowed                        */
#define SH_NI0_LLP_ERR_WIRE_OVERFLOW_SHFT        52
#define SH_NI0_LLP_ERR_WIRE_OVERFLOW_MASK        0x0010000000000000

/* ==================================================================== */
/*                      Register "SH_NI1_LLP_STAT"                      */
/*               This register describes the LLP status.                */
/* ==================================================================== */

#define SH_NI1_LLP_STAT                          0x0000000150002000
#define SH_NI1_LLP_STAT_MASK                     0x000000000000000f
#define SH_NI1_LLP_STAT_INIT                     0x0000000000000000

/*   SH_NI1_LLP_STAT_LINK_RESET_STATE                                   */
/*   Description:  Status of LLP link.                                  */
#define SH_NI1_LLP_STAT_LINK_RESET_STATE_SHFT    0
#define SH_NI1_LLP_STAT_LINK_RESET_STATE_MASK    0x000000000000000f

/* ==================================================================== */
/*                     Register "SH_NI1_LLP_RESET"                      */
/*           Writing issues a reset to the network interface            */
/* ==================================================================== */

#define SH_NI1_LLP_RESET                         0x0000000150002008
#define SH_NI1_LLP_RESET_MASK                    0x0000000000000003
#define SH_NI1_LLP_RESET_INIT                    0x0000000000000000

/*   SH_NI1_LLP_RESET_LINK                                              */
/*   Description:  Send Link Reset. Generates a pulse.                  */
#define SH_NI1_LLP_RESET_LINK_SHFT               0
#define SH_NI1_LLP_RESET_LINK_MASK               0x0000000000000001

/*   SH_NI1_LLP_RESET_WARM                                              */
/*   Description:  Send Warm Reset. Generates a pulse.                  */
#define SH_NI1_LLP_RESET_WARM_SHFT               1
#define SH_NI1_LLP_RESET_WARM_MASK               0x0000000000000002

/* ==================================================================== */
/*                    Register "SH_NI1_LLP_RESET_EN"                    */
/*                 Controls LLP warm reset propagation                  */
/* ==================================================================== */

#define SH_NI1_LLP_RESET_EN                      0x0000000150002010
#define SH_NI1_LLP_RESET_EN_MASK                 0x0000000000000001
#define SH_NI1_LLP_RESET_EN_INIT                 0x0000000000000001

/*   SH_NI1_LLP_RESET_EN_OK                                             */
/*   Description:  Allow LLP warm reset to reset SHUB                   */
#define SH_NI1_LLP_RESET_EN_OK_SHFT              0
#define SH_NI1_LLP_RESET_EN_OK_MASK              0x0000000000000001

/* ==================================================================== */
/*                   Register "SH_NI1_LLP_CHAN_MODE"                    */
/*              Sets the signaling mode of LLP and channel              */
/* ==================================================================== */

#define SH_NI1_LLP_CHAN_MODE                     0x0000000150002018
#define SH_NI1_LLP_CHAN_MODE_MASK                0x000000000000001f
#define SH_NI1_LLP_CHAN_MODE_INIT                0x0000000000000000

/*   SH_NI1_LLP_CHAN_MODE_BITMODE32                                     */
/*   Description:  Enables 32-bit (plus sideband) channel phits         */
#define SH_NI1_LLP_CHAN_MODE_BITMODE32_SHFT      0
#define SH_NI1_LLP_CHAN_MODE_BITMODE32_MASK      0x0000000000000001

/*   SH_NI1_LLP_CHAN_MODE_AC_ENCODE                                     */
/*   Description:  Enables nearly dc-free encoding for AC-coupling      */
#define SH_NI1_LLP_CHAN_MODE_AC_ENCODE_SHFT      1
#define SH_NI1_LLP_CHAN_MODE_AC_ENCODE_MASK      0x0000000000000002

/*   SH_NI1_LLP_CHAN_MODE_ENABLE_TUNING                                 */
/*   Description:  Enables automatic tuning of channel skew.            */
#define SH_NI1_LLP_CHAN_MODE_ENABLE_TUNING_SHFT  2
#define SH_NI1_LLP_CHAN_MODE_ENABLE_TUNING_MASK  0x0000000000000004

/*   SH_NI1_LLP_CHAN_MODE_ENABLE_RMT_FT_UPD                             */
/*   Description:  Enables remote fine tune updates                     */
#define SH_NI1_LLP_CHAN_MODE_ENABLE_RMT_FT_UPD_SHFT 3
#define SH_NI1_LLP_CHAN_MODE_ENABLE_RMT_FT_UPD_MASK 0x0000000000000008

/*   SH_NI1_LLP_CHAN_MODE_ENABLE_CLKQUAD                                */
/*   Description:  Enables quadrature clock in the pfssd                */
#define SH_NI1_LLP_CHAN_MODE_ENABLE_CLKQUAD_SHFT 4
#define SH_NI1_LLP_CHAN_MODE_ENABLE_CLKQUAD_MASK 0x0000000000000010

/* ==================================================================== */
/*                     Register "SH_NI1_LLP_CONFIG"                     */
/*              Sets the configuration of LLP and channel               */
/* ==================================================================== */

#define SH_NI1_LLP_CONFIG                        0x0000000150002020
#define SH_NI1_LLP_CONFIG_MASK                   0x0000003fffffffff
#define SH_NI1_LLP_CONFIG_INIT                   0x00000007fc6ffd00

/*   SH_NI1_LLP_CONFIG_MAXBURST                                         */
#define SH_NI1_LLP_CONFIG_MAXBURST_SHFT          0
#define SH_NI1_LLP_CONFIG_MAXBURST_MASK          0x00000000000003ff

/*   SH_NI1_LLP_CONFIG_MAXRETRY                                         */
#define SH_NI1_LLP_CONFIG_MAXRETRY_SHFT          10
#define SH_NI1_LLP_CONFIG_MAXRETRY_MASK          0x00000000000ffc00

/*   SH_NI1_LLP_CONFIG_NULLTIMEOUT                                      */
#define SH_NI1_LLP_CONFIG_NULLTIMEOUT_SHFT       20
#define SH_NI1_LLP_CONFIG_NULLTIMEOUT_MASK       0x0000000003f00000

/*   SH_NI1_LLP_CONFIG_FTU_TIME                                         */
#define SH_NI1_LLP_CONFIG_FTU_TIME_SHFT          26
#define SH_NI1_LLP_CONFIG_FTU_TIME_MASK          0x0000003ffc000000

/* ==================================================================== */
/*                    Register "SH_NI1_LLP_TEST_CTL"                    */
/* ==================================================================== */

#define SH_NI1_LLP_TEST_CTL                      0x0000000150002028
#define SH_NI1_LLP_TEST_CTL_MASK                 0x7ff3f3ffffffffff
#define SH_NI1_LLP_TEST_CTL_INIT                 0x000000000a5fffff

/*   SH_NI1_LLP_TEST_CTL_PATTERN                                        */
/*   Description:  Send channel data pattern                            */
#define SH_NI1_LLP_TEST_CTL_PATTERN_SHFT         0
#define SH_NI1_LLP_TEST_CTL_PATTERN_MASK         0x000000ffffffffff

/*   SH_NI1_LLP_TEST_CTL_SEND_TEST_MODE                                 */
/*   Description:  Enables continuous send of data                      */
#define SH_NI1_LLP_TEST_CTL_SEND_TEST_MODE_SHFT  40
#define SH_NI1_LLP_TEST_CTL_SEND_TEST_MODE_MASK  0x0000030000000000

/*   SH_NI1_LLP_TEST_CTL_WIRE_SEL                                       */
#define SH_NI1_LLP_TEST_CTL_WIRE_SEL_SHFT        44
#define SH_NI1_LLP_TEST_CTL_WIRE_SEL_MASK        0x0003f00000000000

/*   SH_NI1_LLP_TEST_CTL_LFSR_MODE                                      */
#define SH_NI1_LLP_TEST_CTL_LFSR_MODE_SHFT       52
#define SH_NI1_LLP_TEST_CTL_LFSR_MODE_MASK       0x0030000000000000

/*   SH_NI1_LLP_TEST_CTL_NOISE_MODE                                     */
#define SH_NI1_LLP_TEST_CTL_NOISE_MODE_SHFT      54
#define SH_NI1_LLP_TEST_CTL_NOISE_MODE_MASK      0x00c0000000000000

/*   SH_NI1_LLP_TEST_CTL_ARMCAPTURE                                     */
/*   Description:  Enable Capture of Next MicroPacket                   */
#define SH_NI1_LLP_TEST_CTL_ARMCAPTURE_SHFT      56
#define SH_NI1_LLP_TEST_CTL_ARMCAPTURE_MASK      0x0100000000000000

/*   SH_NI1_LLP_TEST_CTL_CAPTURECBONLY                                  */
/*   Description:  Only capture a micropacket with a Check Byte error  */
#define SH_NI1_LLP_TEST_CTL_CAPTURECBONLY_SHFT   57
#define SH_NI1_LLP_TEST_CTL_CAPTURECBONLY_MASK   0x0200000000000000

/*   SH_NI1_LLP_TEST_CTL_SENDCBERROR                                    */
/*   Description:  Sends a single error                                 */
#define SH_NI1_LLP_TEST_CTL_SENDCBERROR_SHFT     58
#define SH_NI1_LLP_TEST_CTL_SENDCBERROR_MASK     0x0400000000000000

/*   SH_NI1_LLP_TEST_CTL_SENDSNERROR                                    */
/*   Description:  Sends a single sequence number error                 */
#define SH_NI1_LLP_TEST_CTL_SENDSNERROR_SHFT     59
#define SH_NI1_LLP_TEST_CTL_SENDSNERROR_MASK     0x0800000000000000

/*   SH_NI1_LLP_TEST_CTL_FAKESNERROR                                    */
/*   Description:  Causes receiver to pretend it saw a sn error         */
#define SH_NI1_LLP_TEST_CTL_FAKESNERROR_SHFT     60
#define SH_NI1_LLP_TEST_CTL_FAKESNERROR_MASK     0x1000000000000000

/*   SH_NI1_LLP_TEST_CTL_CAPTURED                                       */
/*   Description:  Indicates a Valid Micropacket was captured           */
#define SH_NI1_LLP_TEST_CTL_CAPTURED_SHFT        61
#define SH_NI1_LLP_TEST_CTL_CAPTURED_MASK        0x2000000000000000

/*   SH_NI1_LLP_TEST_CTL_CBERROR                                        */
/*   Description:  Indicates a Micropacket with a CB error was capture  */
#define SH_NI1_LLP_TEST_CTL_CBERROR_SHFT         62
#define SH_NI1_LLP_TEST_CTL_CBERROR_MASK         0x4000000000000000

/* ==================================================================== */
/*                    Register "SH_NI1_LLP_CAPT_WD1"                    */
/*                    low order 64-bit captured word                    */
/* ==================================================================== */

#define SH_NI1_LLP_CAPT_WD1                      0x0000000150002030
#define SH_NI1_LLP_CAPT_WD1_MASK                 0xffffffffffffffff
#define SH_NI1_LLP_CAPT_WD1_INIT                 0x0000000000000000

/*   SH_NI1_LLP_CAPT_WD1_DATA                                           */
/*   Description:  low order 64-bit captured word                       */
#define SH_NI1_LLP_CAPT_WD1_DATA_SHFT            0
#define SH_NI1_LLP_CAPT_WD1_DATA_MASK            0xffffffffffffffff

/* ==================================================================== */
/*                    Register "SH_NI1_LLP_CAPT_WD2"                    */
/*                   high order 64-bit captured word                    */
/* ==================================================================== */

#define SH_NI1_LLP_CAPT_WD2                      0x0000000150002038
#define SH_NI1_LLP_CAPT_WD2_MASK                 0xffffffffffffffff
#define SH_NI1_LLP_CAPT_WD2_INIT                 0x0000000000000000

/*   SH_NI1_LLP_CAPT_WD2_DATA                                           */
/*   Description:  high order 64-bit captured word                      */
#define SH_NI1_LLP_CAPT_WD2_DATA_SHFT            0
#define SH_NI1_LLP_CAPT_WD2_DATA_MASK            0xffffffffffffffff

/* ==================================================================== */
/*                   Register "SH_NI1_LLP_CAPT_SBCB"                    */
/*                 captured sideband, sequence, and CRC                 */
/* ==================================================================== */

#define SH_NI1_LLP_CAPT_SBCB                     0x0000000150002040
#define SH_NI1_LLP_CAPT_SBCB_MASK                0x0000001fffffffff
#define SH_NI1_LLP_CAPT_SBCB_INIT                0x0000000000000000

/*   SH_NI1_LLP_CAPT_SBCB_CAPTUREDRCVSBSN                               */
/*   Description:  sideband and sequence                                */
#define SH_NI1_LLP_CAPT_SBCB_CAPTUREDRCVSBSN_SHFT 0
#define SH_NI1_LLP_CAPT_SBCB_CAPTUREDRCVSBSN_MASK 0x000000000000ffff

/*   SH_NI1_LLP_CAPT_SBCB_CAPTUREDRCVCRC                                */
/*   Description:  CRC                                                  */
#define SH_NI1_LLP_CAPT_SBCB_CAPTUREDRCVCRC_SHFT 16
#define SH_NI1_LLP_CAPT_SBCB_CAPTUREDRCVCRC_MASK 0x00000000ffff0000

/*   SH_NI1_LLP_CAPT_SBCB_SENTALLCBERRORS                               */
/*   Description:  All CB errors have been sent                         */
#define SH_NI1_LLP_CAPT_SBCB_SENTALLCBERRORS_SHFT 32
#define SH_NI1_LLP_CAPT_SBCB_SENTALLCBERRORS_MASK 0x0000000100000000

/*   SH_NI1_LLP_CAPT_SBCB_SENTALLSNERRORS                               */
/*   Description:  All SN errors have been sent                         */
#define SH_NI1_LLP_CAPT_SBCB_SENTALLSNERRORS_SHFT 33
#define SH_NI1_LLP_CAPT_SBCB_SENTALLSNERRORS_MASK 0x0000000200000000

/*   SH_NI1_LLP_CAPT_SBCB_FAKEDALLSNERRORS                              */
/*   Description:  All faked SN errors have been sent                   */
#define SH_NI1_LLP_CAPT_SBCB_FAKEDALLSNERRORS_SHFT 34
#define SH_NI1_LLP_CAPT_SBCB_FAKEDALLSNERRORS_MASK 0x0000000400000000

/*   SH_NI1_LLP_CAPT_SBCB_CHARGEOVERFLOW                                */
/*   Description:  wire charge counter overflowed, valid if llp_mode e  */
#define SH_NI1_LLP_CAPT_SBCB_CHARGEOVERFLOW_SHFT 35
#define SH_NI1_LLP_CAPT_SBCB_CHARGEOVERFLOW_MASK 0x0000000800000000

/*   SH_NI1_LLP_CAPT_SBCB_CHARGEUNDERFLOW                               */
/*   Description:  wire charge counter underflowed, valid if llp_mode   */
/*  enabled                                                             */
#define SH_NI1_LLP_CAPT_SBCB_CHARGEUNDERFLOW_SHFT 36
#define SH_NI1_LLP_CAPT_SBCB_CHARGEUNDERFLOW_MASK 0x0000001000000000

/* ==================================================================== */
/*                      Register "SH_NI1_LLP_ERR"                       */
/* ==================================================================== */

#define SH_NI1_LLP_ERR                           0x0000000150002048
#define SH_NI1_LLP_ERR_MASK                      0x001fffffffffffff
#define SH_NI1_LLP_ERR_INIT                      0x0000000000000000

/*   SH_NI1_LLP_ERR_RX_SN_ERR_COUNT                                     */
/*   Description:  Counts the sequence number errors received           */
#define SH_NI1_LLP_ERR_RX_SN_ERR_COUNT_SHFT      0
#define SH_NI1_LLP_ERR_RX_SN_ERR_COUNT_MASK      0x00000000000000ff

/*   SH_NI1_LLP_ERR_RX_CB_ERR_COUNT                                     */
/*   Description:  Counts the check byte errors received                */
#define SH_NI1_LLP_ERR_RX_CB_ERR_COUNT_SHFT      8
#define SH_NI1_LLP_ERR_RX_CB_ERR_COUNT_MASK      0x000000000000ff00

/*   SH_NI1_LLP_ERR_RETRY_COUNT                                         */
/*   Description:  Counts the retries                                   */
#define SH_NI1_LLP_ERR_RETRY_COUNT_SHFT          16
#define SH_NI1_LLP_ERR_RETRY_COUNT_MASK          0x0000000000ff0000

/*   SH_NI1_LLP_ERR_RETRY_TIMEOUT                                       */
/*   Description:  Indicates a retry timeout has occurred               */
#define SH_NI1_LLP_ERR_RETRY_TIMEOUT_SHFT        24
#define SH_NI1_LLP_ERR_RETRY_TIMEOUT_MASK        0x0000000001000000

/*   SH_NI1_LLP_ERR_RCV_LINK_RESET                                      */
/*   Description:  Indicates a link reset has been received             */
#define SH_NI1_LLP_ERR_RCV_LINK_RESET_SHFT       25
#define SH_NI1_LLP_ERR_RCV_LINK_RESET_MASK       0x0000000002000000

/*   SH_NI1_LLP_ERR_SQUASH                                              */
/*   Description:  Indicates a micropacket was squashed                 */
#define SH_NI1_LLP_ERR_SQUASH_SHFT               26
#define SH_NI1_LLP_ERR_SQUASH_MASK               0x0000000004000000

/*   SH_NI1_LLP_ERR_POWER_NOT_OK                                        */
/*   Description:  Detects and traps a loss of power_OK                 */
#define SH_NI1_LLP_ERR_POWER_NOT_OK_SHFT         27
#define SH_NI1_LLP_ERR_POWER_NOT_OK_MASK         0x0000000008000000

/*   SH_NI1_LLP_ERR_WIRE_CNT                                            */
/*   Description:  counts the errors detected on a single wire test     */
#define SH_NI1_LLP_ERR_WIRE_CNT_SHFT             28
#define SH_NI1_LLP_ERR_WIRE_CNT_MASK             0x000ffffff0000000

/*   SH_NI1_LLP_ERR_WIRE_OVERFLOW                                       */
/*   Description:  wire_error_cnt has overflowed                        */
#define SH_NI1_LLP_ERR_WIRE_OVERFLOW_SHFT        52
#define SH_NI1_LLP_ERR_WIRE_OVERFLOW_MASK        0x0010000000000000

/* ==================================================================== */
/*                Register "SH_XNNI0_LLP_TO_FIFO02_FLOW"                */
/* ==================================================================== */

#define SH_XNNI0_LLP_TO_FIFO02_FLOW              0x0000000150001010
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_MASK         0x3f3f003f3f00bfbf
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_INIT         0x0000000000000000

/*   SH_XNNI0_LLP_TO_FIFO02_FLOW_DEBIT_VC0_WITHHOLD                     */
/*   Description:  vc0 withhold                                         */
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI0_LLP_TO_FIFO02_FLOW_DEBIT_VC0_FORCE_CRED                   */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI0_LLP_TO_FIFO02_FLOW_DEBIT_VC2_WITHHOLD                     */
/*   Description:  vc2 withhold                                         */
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNNI0_LLP_TO_FIFO02_FLOW_DEBIT_VC2_FORCE_CRED                   */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNNI0_LLP_TO_FIFO02_FLOW_CREDIT_VC0_DYN                         */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_CREDIT_VC0_DYN_SHFT 24
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_CREDIT_VC0_DYN_MASK 0x000000003f000000

/*   SH_XNNI0_LLP_TO_FIFO02_FLOW_CREDIT_VC0_CAP                         */
/*   Description:  vc0 credit captured value                            */
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_CREDIT_VC0_CAP_SHFT 32
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_CREDIT_VC0_CAP_MASK 0x0000003f00000000

/*   SH_XNNI0_LLP_TO_FIFO02_FLOW_CREDIT_VC2_DYN                         */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_CREDIT_VC2_DYN_SHFT 48
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_CREDIT_VC2_DYN_MASK 0x003f000000000000

/*   SH_XNNI0_LLP_TO_FIFO02_FLOW_CREDIT_VC2_CAP                         */
/*   Description:  vc2 credit captured value                            */
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_CREDIT_VC2_CAP_SHFT 56
#define SH_XNNI0_LLP_TO_FIFO02_FLOW_CREDIT_VC2_CAP_MASK 0x3f00000000000000

/* ==================================================================== */
/*                Register "SH_XNNI0_LLP_TO_FIFO13_FLOW"                */
/* ==================================================================== */

#define SH_XNNI0_LLP_TO_FIFO13_FLOW              0x0000000150001020
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_MASK         0x3f3f003f3f00bfbf
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_INIT         0x0000000000000000

/*   SH_XNNI0_LLP_TO_FIFO13_FLOW_DEBIT_VC0_WITHHOLD                     */
/*   Description:  vc0 withhold                                         */
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI0_LLP_TO_FIFO13_FLOW_DEBIT_VC0_FORCE_CRED                   */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI0_LLP_TO_FIFO13_FLOW_DEBIT_VC2_WITHHOLD                     */
/*   Description:  vc2 withhold                                         */
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNNI0_LLP_TO_FIFO13_FLOW_DEBIT_VC2_FORCE_CRED                   */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNNI0_LLP_TO_FIFO13_FLOW_CREDIT_VC0_DYN                         */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_CREDIT_VC0_DYN_SHFT 24
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_CREDIT_VC0_DYN_MASK 0x000000003f000000

/*   SH_XNNI0_LLP_TO_FIFO13_FLOW_CREDIT_VC0_CAP                         */
/*   Description:  vc0 credit captured value                            */
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_CREDIT_VC0_CAP_SHFT 32
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_CREDIT_VC0_CAP_MASK 0x0000003f00000000

/*   SH_XNNI0_LLP_TO_FIFO13_FLOW_CREDIT_VC2_DYN                         */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_CREDIT_VC2_DYN_SHFT 48
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_CREDIT_VC2_DYN_MASK 0x003f000000000000

/*   SH_XNNI0_LLP_TO_FIFO13_FLOW_CREDIT_VC2_CAP                         */
/*   Description:  vc2 credit captured value                            */
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_CREDIT_VC2_CAP_SHFT 56
#define SH_XNNI0_LLP_TO_FIFO13_FLOW_CREDIT_VC2_CAP_MASK 0x3f00000000000000

/* ==================================================================== */
/*                  Register "SH_XNNI0_LLP_DEBIT_FLOW"                  */
/* ==================================================================== */

#define SH_XNNI0_LLP_DEBIT_FLOW                  0x0000000150001030
#define SH_XNNI0_LLP_DEBIT_FLOW_MASK             0x1f1f1f1f1f1f1f1f
#define SH_XNNI0_LLP_DEBIT_FLOW_INIT             0x0000000000000000

/*   SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC0_DYN                              */
/*   Description:  vc0 debit dynamic value                              */
#define SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC0_DYN_SHFT 0
#define SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC0_DYN_MASK 0x000000000000001f

/*   SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC0_CAP                              */
/*   Description:  vc0 debit captured value                             */
#define SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC0_CAP_SHFT 8
#define SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC0_CAP_MASK 0x0000000000001f00

/*   SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC1_DYN                              */
/*   Description:  vc1 debit dynamic value                              */
#define SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC1_DYN_SHFT 16
#define SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC1_DYN_MASK 0x00000000001f0000

/*   SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC1_CAP                              */
/*   Description:  vc1 debit captured value                             */
#define SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC1_CAP_SHFT 24
#define SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC1_CAP_MASK 0x000000001f000000

/*   SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC2_DYN                              */
/*   Description:  vc2 debit dynamic value                              */
#define SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC2_DYN_SHFT 32
#define SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC2_DYN_MASK 0x0000001f00000000

/*   SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC2_CAP                              */
/*   Description:  vc2 debit captured value                             */
#define SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC2_CAP_SHFT 40
#define SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC2_CAP_MASK 0x00001f0000000000

/*   SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC3_DYN                              */
/*   Description:  vc3 debit dynamic value                              */
#define SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC3_DYN_SHFT 48
#define SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC3_DYN_MASK 0x001f000000000000

/*   SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC3_CAP                              */
/*   Description:  vc3 debit captured value                             */
#define SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC3_CAP_SHFT 56
#define SH_XNNI0_LLP_DEBIT_FLOW_DEBIT_VC3_CAP_MASK 0x1f00000000000000

/* ==================================================================== */
/*                   Register "SH_XNNI0_LINK_0_FLOW"                    */
/* ==================================================================== */

#define SH_XNNI0_LINK_0_FLOW                     0x0000000150001040
#define SH_XNNI0_LINK_0_FLOW_MASK                0x000000007f7f7fbf
#define SH_XNNI0_LINK_0_FLOW_INIT                0x0000000000001800

/*   SH_XNNI0_LINK_0_FLOW_DEBIT_VC0_WITHHOLD                            */
/*   Description:  vc0 withhold                                         */
#define SH_XNNI0_LINK_0_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNNI0_LINK_0_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI0_LINK_0_FLOW_DEBIT_VC0_FORCE_CRED                          */
/*   Description:  Force Credit on vc0 from debit cntr                  */
#define SH_XNNI0_LINK_0_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNNI0_LINK_0_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI0_LINK_0_FLOW_CREDIT_VC0_TEST                               */
/*   Description:  vc0 Limit Test                                       */
#define SH_XNNI0_LINK_0_FLOW_CREDIT_VC0_TEST_SHFT 8
#define SH_XNNI0_LINK_0_FLOW_CREDIT_VC0_TEST_MASK 0x0000000000007f00

/*   SH_XNNI0_LINK_0_FLOW_CREDIT_VC0_DYN                                */
/*   Description:  Dynamic vc0 credit value                             */
#define SH_XNNI0_LINK_0_FLOW_CREDIT_VC0_DYN_SHFT 16
#define SH_XNNI0_LINK_0_FLOW_CREDIT_VC0_DYN_MASK 0x00000000007f0000

/*   SH_XNNI0_LINK_0_FLOW_CREDIT_VC0_CAP                                */
/*   Description:  Captured vc0 credit                                  */
#define SH_XNNI0_LINK_0_FLOW_CREDIT_VC0_CAP_SHFT 24
#define SH_XNNI0_LINK_0_FLOW_CREDIT_VC0_CAP_MASK 0x000000007f000000

/* ==================================================================== */
/*                   Register "SH_XNNI0_LINK_1_FLOW"                    */
/* ==================================================================== */

#define SH_XNNI0_LINK_1_FLOW                     0x0000000150001050
#define SH_XNNI0_LINK_1_FLOW_MASK                0x000000007f7f7fbf
#define SH_XNNI0_LINK_1_FLOW_INIT                0x0000000000001800

/*   SH_XNNI0_LINK_1_FLOW_DEBIT_VC1_WITHHOLD                            */
/*   Description:  vc1 withhold                                         */
#define SH_XNNI0_LINK_1_FLOW_DEBIT_VC1_WITHHOLD_SHFT 0
#define SH_XNNI0_LINK_1_FLOW_DEBIT_VC1_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI0_LINK_1_FLOW_DEBIT_VC1_FORCE_CRED                          */
/*   Description:  Force Credit on vc1 from debit cntr                  */
#define SH_XNNI0_LINK_1_FLOW_DEBIT_VC1_FORCE_CRED_SHFT 7
#define SH_XNNI0_LINK_1_FLOW_DEBIT_VC1_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI0_LINK_1_FLOW_CREDIT_VC1_TEST                               */
/*   Description:  vc1 Limit Test                                       */
#define SH_XNNI0_LINK_1_FLOW_CREDIT_VC1_TEST_SHFT 8
#define SH_XNNI0_LINK_1_FLOW_CREDIT_VC1_TEST_MASK 0x0000000000007f00

/*   SH_XNNI0_LINK_1_FLOW_CREDIT_VC1_DYN                                */
/*   Description:  Dynamic vc1 credit value                             */
#define SH_XNNI0_LINK_1_FLOW_CREDIT_VC1_DYN_SHFT 16
#define SH_XNNI0_LINK_1_FLOW_CREDIT_VC1_DYN_MASK 0x00000000007f0000

/*   SH_XNNI0_LINK_1_FLOW_CREDIT_VC1_CAP                                */
/*   Description:  Captured vc1 credit                                  */
#define SH_XNNI0_LINK_1_FLOW_CREDIT_VC1_CAP_SHFT 24
#define SH_XNNI0_LINK_1_FLOW_CREDIT_VC1_CAP_MASK 0x000000007f000000

/* ==================================================================== */
/*                   Register "SH_XNNI0_LINK_2_FLOW"                    */
/* ==================================================================== */

#define SH_XNNI0_LINK_2_FLOW                     0x0000000150001060
#define SH_XNNI0_LINK_2_FLOW_MASK                0x000000007f7f7fbf
#define SH_XNNI0_LINK_2_FLOW_INIT                0x0000000000001800

/*   SH_XNNI0_LINK_2_FLOW_DEBIT_VC2_WITHHOLD                            */
/*   Description:  vc2 withhold                                         */
#define SH_XNNI0_LINK_2_FLOW_DEBIT_VC2_WITHHOLD_SHFT 0
#define SH_XNNI0_LINK_2_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI0_LINK_2_FLOW_DEBIT_VC2_FORCE_CRED                          */
/*   Description:  Force Credit on vc2 from debit cntr                  */
#define SH_XNNI0_LINK_2_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 7
#define SH_XNNI0_LINK_2_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI0_LINK_2_FLOW_CREDIT_VC2_TEST                               */
/*   Description:  vc2 Limit Test                                       */
#define SH_XNNI0_LINK_2_FLOW_CREDIT_VC2_TEST_SHFT 8
#define SH_XNNI0_LINK_2_FLOW_CREDIT_VC2_TEST_MASK 0x0000000000007f00

/*   SH_XNNI0_LINK_2_FLOW_CREDIT_VC2_DYN                                */
/*   Description:  Dynamic vc2 credit value                             */
#define SH_XNNI0_LINK_2_FLOW_CREDIT_VC2_DYN_SHFT 16
#define SH_XNNI0_LINK_2_FLOW_CREDIT_VC2_DYN_MASK 0x00000000007f0000

/*   SH_XNNI0_LINK_2_FLOW_CREDIT_VC2_CAP                                */
/*   Description:  Captured vc2 credit                                  */
#define SH_XNNI0_LINK_2_FLOW_CREDIT_VC2_CAP_SHFT 24
#define SH_XNNI0_LINK_2_FLOW_CREDIT_VC2_CAP_MASK 0x000000007f000000

/* ==================================================================== */
/*                   Register "SH_XNNI0_LINK_3_FLOW"                    */
/* ==================================================================== */

#define SH_XNNI0_LINK_3_FLOW                     0x0000000150001070
#define SH_XNNI0_LINK_3_FLOW_MASK                0x000000007f7f7fbf
#define SH_XNNI0_LINK_3_FLOW_INIT                0x0000000000001800

/*   SH_XNNI0_LINK_3_FLOW_DEBIT_VC3_WITHHOLD                            */
/*   Description:  vc3 withhold                                         */
#define SH_XNNI0_LINK_3_FLOW_DEBIT_VC3_WITHHOLD_SHFT 0
#define SH_XNNI0_LINK_3_FLOW_DEBIT_VC3_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI0_LINK_3_FLOW_DEBIT_VC3_FORCE_CRED                          */
/*   Description:  Force Credit on vc3 from debit cntr                  */
#define SH_XNNI0_LINK_3_FLOW_DEBIT_VC3_FORCE_CRED_SHFT 7
#define SH_XNNI0_LINK_3_FLOW_DEBIT_VC3_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI0_LINK_3_FLOW_CREDIT_VC3_TEST                               */
/*   Description:  vc3 Limit Test                                       */
#define SH_XNNI0_LINK_3_FLOW_CREDIT_VC3_TEST_SHFT 8
#define SH_XNNI0_LINK_3_FLOW_CREDIT_VC3_TEST_MASK 0x0000000000007f00

/*   SH_XNNI0_LINK_3_FLOW_CREDIT_VC3_DYN                                */
/*   Description:  Dynamic vc3 credit value                             */
#define SH_XNNI0_LINK_3_FLOW_CREDIT_VC3_DYN_SHFT 16
#define SH_XNNI0_LINK_3_FLOW_CREDIT_VC3_DYN_MASK 0x00000000007f0000

/*   SH_XNNI0_LINK_3_FLOW_CREDIT_VC3_CAP                                */
/*   Description:  Captured vc3 credit                                  */
#define SH_XNNI0_LINK_3_FLOW_CREDIT_VC3_CAP_SHFT 24
#define SH_XNNI0_LINK_3_FLOW_CREDIT_VC3_CAP_MASK 0x000000007f000000

/* ==================================================================== */
/*                Register "SH_XNNI1_LLP_TO_FIFO02_FLOW"                */
/* ==================================================================== */

#define SH_XNNI1_LLP_TO_FIFO02_FLOW              0x0000000150003010
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_MASK         0x3f3f003f3f00bfbf
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_INIT         0x0000000000000000

/*   SH_XNNI1_LLP_TO_FIFO02_FLOW_DEBIT_VC0_WITHHOLD                     */
/*   Description:  vc0 withhold                                         */
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI1_LLP_TO_FIFO02_FLOW_DEBIT_VC0_FORCE_CRED                   */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI1_LLP_TO_FIFO02_FLOW_DEBIT_VC2_WITHHOLD                     */
/*   Description:  vc2 withhold                                         */
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNNI1_LLP_TO_FIFO02_FLOW_DEBIT_VC2_FORCE_CRED                   */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNNI1_LLP_TO_FIFO02_FLOW_CREDIT_VC0_DYN                         */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_CREDIT_VC0_DYN_SHFT 24
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_CREDIT_VC0_DYN_MASK 0x000000003f000000

/*   SH_XNNI1_LLP_TO_FIFO02_FLOW_CREDIT_VC0_CAP                         */
/*   Description:  vc0 credit captured value                            */
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_CREDIT_VC0_CAP_SHFT 32
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_CREDIT_VC0_CAP_MASK 0x0000003f00000000

/*   SH_XNNI1_LLP_TO_FIFO02_FLOW_CREDIT_VC2_DYN                         */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_CREDIT_VC2_DYN_SHFT 48
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_CREDIT_VC2_DYN_MASK 0x003f000000000000

/*   SH_XNNI1_LLP_TO_FIFO02_FLOW_CREDIT_VC2_CAP                         */
/*   Description:  vc2 credit captured value                            */
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_CREDIT_VC2_CAP_SHFT 56
#define SH_XNNI1_LLP_TO_FIFO02_FLOW_CREDIT_VC2_CAP_MASK 0x3f00000000000000

/* ==================================================================== */
/*                Register "SH_XNNI1_LLP_TO_FIFO13_FLOW"                */
/* ==================================================================== */

#define SH_XNNI1_LLP_TO_FIFO13_FLOW              0x0000000150003020
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_MASK         0x3f3f003f3f00bfbf
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_INIT         0x0000000000000000

/*   SH_XNNI1_LLP_TO_FIFO13_FLOW_DEBIT_VC0_WITHHOLD                     */
/*   Description:  vc0 withhold                                         */
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI1_LLP_TO_FIFO13_FLOW_DEBIT_VC0_FORCE_CRED                   */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI1_LLP_TO_FIFO13_FLOW_DEBIT_VC2_WITHHOLD                     */
/*   Description:  vc2 withhold                                         */
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNNI1_LLP_TO_FIFO13_FLOW_DEBIT_VC2_FORCE_CRED                   */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNNI1_LLP_TO_FIFO13_FLOW_CREDIT_VC0_DYN                         */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_CREDIT_VC0_DYN_SHFT 24
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_CREDIT_VC0_DYN_MASK 0x000000003f000000

/*   SH_XNNI1_LLP_TO_FIFO13_FLOW_CREDIT_VC0_CAP                         */
/*   Description:  vc0 credit captured value                            */
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_CREDIT_VC0_CAP_SHFT 32
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_CREDIT_VC0_CAP_MASK 0x0000003f00000000

/*   SH_XNNI1_LLP_TO_FIFO13_FLOW_CREDIT_VC2_DYN                         */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_CREDIT_VC2_DYN_SHFT 48
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_CREDIT_VC2_DYN_MASK 0x003f000000000000

/*   SH_XNNI1_LLP_TO_FIFO13_FLOW_CREDIT_VC2_CAP                         */
/*   Description:  vc2 credit captured value                            */
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_CREDIT_VC2_CAP_SHFT 56
#define SH_XNNI1_LLP_TO_FIFO13_FLOW_CREDIT_VC2_CAP_MASK 0x3f00000000000000

/* ==================================================================== */
/*                  Register "SH_XNNI1_LLP_DEBIT_FLOW"                  */
/* ==================================================================== */

#define SH_XNNI1_LLP_DEBIT_FLOW                  0x0000000150003030
#define SH_XNNI1_LLP_DEBIT_FLOW_MASK             0x1f1f1f1f1f1f1f1f
#define SH_XNNI1_LLP_DEBIT_FLOW_INIT             0x0000000000000000

/*   SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC0_DYN                              */
/*   Description:  vc0 debit dynamic value                              */
#define SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC0_DYN_SHFT 0
#define SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC0_DYN_MASK 0x000000000000001f

/*   SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC0_CAP                              */
/*   Description:  vc0 debit captured value                             */
#define SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC0_CAP_SHFT 8
#define SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC0_CAP_MASK 0x0000000000001f00

/*   SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC1_DYN                              */
/*   Description:  vc1 debit dynamic value                              */
#define SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC1_DYN_SHFT 16
#define SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC1_DYN_MASK 0x00000000001f0000

/*   SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC1_CAP                              */
/*   Description:  vc1 debit captured value                             */
#define SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC1_CAP_SHFT 24
#define SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC1_CAP_MASK 0x000000001f000000

/*   SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC2_DYN                              */
/*   Description:  vc2 debit dynamic value                              */
#define SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC2_DYN_SHFT 32
#define SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC2_DYN_MASK 0x0000001f00000000

/*   SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC2_CAP                              */
/*   Description:  vc2 debit captured value                             */
#define SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC2_CAP_SHFT 40
#define SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC2_CAP_MASK 0x00001f0000000000

/*   SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC3_DYN                              */
/*   Description:  vc3 debit dynamic value                              */
#define SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC3_DYN_SHFT 48
#define SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC3_DYN_MASK 0x001f000000000000

/*   SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC3_CAP                              */
/*   Description:  vc3 debit captured value                             */
#define SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC3_CAP_SHFT 56
#define SH_XNNI1_LLP_DEBIT_FLOW_DEBIT_VC3_CAP_MASK 0x1f00000000000000

/* ==================================================================== */
/*                   Register "SH_XNNI1_LINK_0_FLOW"                    */
/* ==================================================================== */

#define SH_XNNI1_LINK_0_FLOW                     0x0000000150003040
#define SH_XNNI1_LINK_0_FLOW_MASK                0x000000007f7f7fbf
#define SH_XNNI1_LINK_0_FLOW_INIT                0x0000000000001800

/*   SH_XNNI1_LINK_0_FLOW_DEBIT_VC0_WITHHOLD                            */
/*   Description:  vc0 withhold                                         */
#define SH_XNNI1_LINK_0_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNNI1_LINK_0_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI1_LINK_0_FLOW_DEBIT_VC0_FORCE_CRED                          */
/*   Description:  Force Credit on vc0 from debit cntr                  */
#define SH_XNNI1_LINK_0_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNNI1_LINK_0_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI1_LINK_0_FLOW_CREDIT_VC0_TEST                               */
/*   Description:  vc0 Limit Test                                       */
#define SH_XNNI1_LINK_0_FLOW_CREDIT_VC0_TEST_SHFT 8
#define SH_XNNI1_LINK_0_FLOW_CREDIT_VC0_TEST_MASK 0x0000000000007f00

/*   SH_XNNI1_LINK_0_FLOW_CREDIT_VC0_DYN                                */
/*   Description:  Dynamic vc0 credit value                             */
#define SH_XNNI1_LINK_0_FLOW_CREDIT_VC0_DYN_SHFT 16
#define SH_XNNI1_LINK_0_FLOW_CREDIT_VC0_DYN_MASK 0x00000000007f0000

/*   SH_XNNI1_LINK_0_FLOW_CREDIT_VC0_CAP                                */
/*   Description:  Captured vc0 credit                                  */
#define SH_XNNI1_LINK_0_FLOW_CREDIT_VC0_CAP_SHFT 24
#define SH_XNNI1_LINK_0_FLOW_CREDIT_VC0_CAP_MASK 0x000000007f000000

/* ==================================================================== */
/*                   Register "SH_XNNI1_LINK_1_FLOW"                    */
/* ==================================================================== */

#define SH_XNNI1_LINK_1_FLOW                     0x0000000150003050
#define SH_XNNI1_LINK_1_FLOW_MASK                0x000000007f7f7fbf
#define SH_XNNI1_LINK_1_FLOW_INIT                0x0000000000001800

/*   SH_XNNI1_LINK_1_FLOW_DEBIT_VC1_WITHHOLD                            */
/*   Description:  vc1 withhold                                         */
#define SH_XNNI1_LINK_1_FLOW_DEBIT_VC1_WITHHOLD_SHFT 0
#define SH_XNNI1_LINK_1_FLOW_DEBIT_VC1_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI1_LINK_1_FLOW_DEBIT_VC1_FORCE_CRED                          */
/*   Description:  Force Credit on vc1 from debit cntr                  */
#define SH_XNNI1_LINK_1_FLOW_DEBIT_VC1_FORCE_CRED_SHFT 7
#define SH_XNNI1_LINK_1_FLOW_DEBIT_VC1_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI1_LINK_1_FLOW_CREDIT_VC1_TEST                               */
/*   Description:  vc1 Limit Test                                       */
#define SH_XNNI1_LINK_1_FLOW_CREDIT_VC1_TEST_SHFT 8
#define SH_XNNI1_LINK_1_FLOW_CREDIT_VC1_TEST_MASK 0x0000000000007f00

/*   SH_XNNI1_LINK_1_FLOW_CREDIT_VC1_DYN                                */
/*   Description:  Dynamic vc1 credit value                             */
#define SH_XNNI1_LINK_1_FLOW_CREDIT_VC1_DYN_SHFT 16
#define SH_XNNI1_LINK_1_FLOW_CREDIT_VC1_DYN_MASK 0x00000000007f0000

/*   SH_XNNI1_LINK_1_FLOW_CREDIT_VC1_CAP                                */
/*   Description:  Captured vc1 credit                                  */
#define SH_XNNI1_LINK_1_FLOW_CREDIT_VC1_CAP_SHFT 24
#define SH_XNNI1_LINK_1_FLOW_CREDIT_VC1_CAP_MASK 0x000000007f000000

/* ==================================================================== */
/*                   Register "SH_XNNI1_LINK_2_FLOW"                    */
/* ==================================================================== */

#define SH_XNNI1_LINK_2_FLOW                     0x0000000150003060
#define SH_XNNI1_LINK_2_FLOW_MASK                0x000000007f7f7fbf
#define SH_XNNI1_LINK_2_FLOW_INIT                0x0000000000001800

/*   SH_XNNI1_LINK_2_FLOW_DEBIT_VC2_WITHHOLD                            */
/*   Description:  vc2 withhold                                         */
#define SH_XNNI1_LINK_2_FLOW_DEBIT_VC2_WITHHOLD_SHFT 0
#define SH_XNNI1_LINK_2_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI1_LINK_2_FLOW_DEBIT_VC2_FORCE_CRED                          */
/*   Description:  Force Credit on vc2 from debit cntr                  */
#define SH_XNNI1_LINK_2_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 7
#define SH_XNNI1_LINK_2_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI1_LINK_2_FLOW_CREDIT_VC2_TEST                               */
/*   Description:  vc2 Limit Test                                       */
#define SH_XNNI1_LINK_2_FLOW_CREDIT_VC2_TEST_SHFT 8
#define SH_XNNI1_LINK_2_FLOW_CREDIT_VC2_TEST_MASK 0x0000000000007f00

/*   SH_XNNI1_LINK_2_FLOW_CREDIT_VC2_DYN                                */
/*   Description:  Dynamic vc2 credit value                             */
#define SH_XNNI1_LINK_2_FLOW_CREDIT_VC2_DYN_SHFT 16
#define SH_XNNI1_LINK_2_FLOW_CREDIT_VC2_DYN_MASK 0x00000000007f0000

/*   SH_XNNI1_LINK_2_FLOW_CREDIT_VC2_CAP                                */
/*   Description:  Captured vc2 credit                                  */
#define SH_XNNI1_LINK_2_FLOW_CREDIT_VC2_CAP_SHFT 24
#define SH_XNNI1_LINK_2_FLOW_CREDIT_VC2_CAP_MASK 0x000000007f000000

/* ==================================================================== */
/*                   Register "SH_XNNI1_LINK_3_FLOW"                    */
/* ==================================================================== */

#define SH_XNNI1_LINK_3_FLOW                     0x0000000150003070
#define SH_XNNI1_LINK_3_FLOW_MASK                0x000000007f7f7fbf
#define SH_XNNI1_LINK_3_FLOW_INIT                0x0000000000001800

/*   SH_XNNI1_LINK_3_FLOW_DEBIT_VC3_WITHHOLD                            */
/*   Description:  vc3 withhold                                         */
#define SH_XNNI1_LINK_3_FLOW_DEBIT_VC3_WITHHOLD_SHFT 0
#define SH_XNNI1_LINK_3_FLOW_DEBIT_VC3_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI1_LINK_3_FLOW_DEBIT_VC3_FORCE_CRED                          */
/*   Description:  Force Credit on vc3 from debit cntr                  */
#define SH_XNNI1_LINK_3_FLOW_DEBIT_VC3_FORCE_CRED_SHFT 7
#define SH_XNNI1_LINK_3_FLOW_DEBIT_VC3_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI1_LINK_3_FLOW_CREDIT_VC3_TEST                               */
/*   Description:  vc3 Limit Test                                       */
#define SH_XNNI1_LINK_3_FLOW_CREDIT_VC3_TEST_SHFT 8
#define SH_XNNI1_LINK_3_FLOW_CREDIT_VC3_TEST_MASK 0x0000000000007f00

/*   SH_XNNI1_LINK_3_FLOW_CREDIT_VC3_DYN                                */
/*   Description:  Dynamic vc3 credit value                             */
#define SH_XNNI1_LINK_3_FLOW_CREDIT_VC3_DYN_SHFT 16
#define SH_XNNI1_LINK_3_FLOW_CREDIT_VC3_DYN_MASK 0x00000000007f0000

/*   SH_XNNI1_LINK_3_FLOW_CREDIT_VC3_CAP                                */
/*   Description:  Captured vc3 credit                                  */
#define SH_XNNI1_LINK_3_FLOW_CREDIT_VC3_CAP_SHFT 24
#define SH_XNNI1_LINK_3_FLOW_CREDIT_VC3_CAP_MASK 0x000000007f000000

/* ==================================================================== */
/*                    Register "SH_IILB_LOCAL_TABLE"                    */
/*                          local lookup table                          */
/* ==================================================================== */

#define SH_IILB_LOCAL_TABLE                      0x0000000150020000
#define SH_IILB_LOCAL_TABLE_MASK                 0x800000000000003f
#define SH_IILB_LOCAL_TABLE_MEMDEPTH             128
#define SH_IILB_LOCAL_TABLE_INIT                 0x0000000000000000

/*   SH_IILB_LOCAL_TABLE_DIR0                                           */
/*   Description:  Direction field for next chip                        */
#define SH_IILB_LOCAL_TABLE_DIR0_SHFT            0
#define SH_IILB_LOCAL_TABLE_DIR0_MASK            0x000000000000000f

/*   SH_IILB_LOCAL_TABLE_V0                                             */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_IILB_LOCAL_TABLE_V0_SHFT              4
#define SH_IILB_LOCAL_TABLE_V0_MASK              0x0000000000000010

/*   SH_IILB_LOCAL_TABLE_NI_SEL0                                        */
/*   Description:  ni select for requests                               */
#define SH_IILB_LOCAL_TABLE_NI_SEL0_SHFT         5
#define SH_IILB_LOCAL_TABLE_NI_SEL0_MASK         0x0000000000000020

/*   SH_IILB_LOCAL_TABLE_VALID                                          */
/*   Description:  Indicates that this entry is valid                   */
#define SH_IILB_LOCAL_TABLE_VALID_SHFT           63
#define SH_IILB_LOCAL_TABLE_VALID_MASK           0x8000000000000000

/* ==================================================================== */
/*                   Register "SH_IILB_GLOBAL_TABLE"                    */
/*                         global lookup table                          */
/* ==================================================================== */

#define SH_IILB_GLOBAL_TABLE                     0x0000000150020400
#define SH_IILB_GLOBAL_TABLE_MASK                0x800000000000003f
#define SH_IILB_GLOBAL_TABLE_MEMDEPTH            16
#define SH_IILB_GLOBAL_TABLE_INIT                0x0000000000000000

/*   SH_IILB_GLOBAL_TABLE_DIR0                                          */
/*   Description:  Direction field for next chip                        */
#define SH_IILB_GLOBAL_TABLE_DIR0_SHFT           0
#define SH_IILB_GLOBAL_TABLE_DIR0_MASK           0x000000000000000f

/*   SH_IILB_GLOBAL_TABLE_V0                                            */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_IILB_GLOBAL_TABLE_V0_SHFT             4
#define SH_IILB_GLOBAL_TABLE_V0_MASK             0x0000000000000010

/*   SH_IILB_GLOBAL_TABLE_NI_SEL0                                       */
/*   Description:  ni select for requests                               */
#define SH_IILB_GLOBAL_TABLE_NI_SEL0_SHFT        5
#define SH_IILB_GLOBAL_TABLE_NI_SEL0_MASK        0x0000000000000020

/*   SH_IILB_GLOBAL_TABLE_VALID                                         */
/*   Description:  Indicates that this entry is valid                   */
#define SH_IILB_GLOBAL_TABLE_VALID_SHFT          63
#define SH_IILB_GLOBAL_TABLE_VALID_MASK          0x8000000000000000

/* ==================================================================== */
/*                  Register "SH_IILB_OVER_RIDE_TABLE"                  */
/*              If enabled, bypass the Global/Local tables              */
/* ==================================================================== */

#define SH_IILB_OVER_RIDE_TABLE                  0x0000000150020480
#define SH_IILB_OVER_RIDE_TABLE_MASK             0x800000000000003f
#define SH_IILB_OVER_RIDE_TABLE_INIT             0x8000000000000000

/*   SH_IILB_OVER_RIDE_TABLE_DIR0                                       */
/*   Description:  Direction field for next chip                        */
#define SH_IILB_OVER_RIDE_TABLE_DIR0_SHFT        0
#define SH_IILB_OVER_RIDE_TABLE_DIR0_MASK        0x000000000000000f

/*   SH_IILB_OVER_RIDE_TABLE_V0                                         */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_IILB_OVER_RIDE_TABLE_V0_SHFT          4
#define SH_IILB_OVER_RIDE_TABLE_V0_MASK          0x0000000000000010

/*   SH_IILB_OVER_RIDE_TABLE_NI_SEL0                                    */
/*   Description:  ni select                                            */
#define SH_IILB_OVER_RIDE_TABLE_NI_SEL0_SHFT     5
#define SH_IILB_OVER_RIDE_TABLE_NI_SEL0_MASK     0x0000000000000020

/*   SH_IILB_OVER_RIDE_TABLE_ENABLE                                     */
/*   Description:  Indicates that this entry is enabled                 */
#define SH_IILB_OVER_RIDE_TABLE_ENABLE_SHFT      63
#define SH_IILB_OVER_RIDE_TABLE_ENABLE_MASK      0x8000000000000000

/* ==================================================================== */
/*                  Register "SH_IILB_RSP_PLANE_HINT"                   */
/*  If enabled, invert incoming response only plane hint bit before lo  */
/* ==================================================================== */

#define SH_IILB_RSP_PLANE_HINT                   0x0000000150020488
#define SH_IILB_RSP_PLANE_HINT_MASK              0x0000000000000000
#define SH_IILB_RSP_PLANE_HINT_INIT              0x0000000000000000

/* ==================================================================== */
/*                     Register "SH_PI_LOCAL_TABLE"                     */
/*                          local lookup table                          */
/* ==================================================================== */

#define SH_PI_LOCAL_TABLE                        0x0000000150021000
#define SH_PI_LOCAL_TABLE_MASK                   0x8000000000003f3f
#define SH_PI_LOCAL_TABLE_MEMDEPTH               128
#define SH_PI_LOCAL_TABLE_INIT                   0x0000000000000000

/*   SH_PI_LOCAL_TABLE_DIR0                                             */
/*   Description:  Direction field for next chip                        */
#define SH_PI_LOCAL_TABLE_DIR0_SHFT              0
#define SH_PI_LOCAL_TABLE_DIR0_MASK              0x000000000000000f

/*   SH_PI_LOCAL_TABLE_V0                                               */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_PI_LOCAL_TABLE_V0_SHFT                4
#define SH_PI_LOCAL_TABLE_V0_MASK                0x0000000000000010

/*   SH_PI_LOCAL_TABLE_NI_SEL0                                          */
/*   Description:  ni select for requests                               */
#define SH_PI_LOCAL_TABLE_NI_SEL0_SHFT           5
#define SH_PI_LOCAL_TABLE_NI_SEL0_MASK           0x0000000000000020

/*   SH_PI_LOCAL_TABLE_DIR1                                             */
#define SH_PI_LOCAL_TABLE_DIR1_SHFT              8
#define SH_PI_LOCAL_TABLE_DIR1_MASK              0x0000000000000f00

/*   SH_PI_LOCAL_TABLE_V1                                               */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_PI_LOCAL_TABLE_V1_SHFT                12
#define SH_PI_LOCAL_TABLE_V1_MASK                0x0000000000001000

/*   SH_PI_LOCAL_TABLE_NI_SEL1                                          */
/*   Description:  ni select for plane-hint 1                           */
#define SH_PI_LOCAL_TABLE_NI_SEL1_SHFT           13
#define SH_PI_LOCAL_TABLE_NI_SEL1_MASK           0x0000000000002000

/*   SH_PI_LOCAL_TABLE_VALID                                            */
/*   Description:  Indicates that this entry is valid                   */
#define SH_PI_LOCAL_TABLE_VALID_SHFT             63
#define SH_PI_LOCAL_TABLE_VALID_MASK             0x8000000000000000

/* ==================================================================== */
/*                    Register "SH_PI_GLOBAL_TABLE"                     */
/*                         global lookup table                          */
/* ==================================================================== */

#define SH_PI_GLOBAL_TABLE                       0x0000000150021400
#define SH_PI_GLOBAL_TABLE_MASK                  0x8000000000003f3f
#define SH_PI_GLOBAL_TABLE_MEMDEPTH              16
#define SH_PI_GLOBAL_TABLE_INIT                  0x0000000000000000

/*   SH_PI_GLOBAL_TABLE_DIR0                                            */
/*   Description:  Direction field for next chip                        */
#define SH_PI_GLOBAL_TABLE_DIR0_SHFT             0
#define SH_PI_GLOBAL_TABLE_DIR0_MASK             0x000000000000000f

/*   SH_PI_GLOBAL_TABLE_V0                                              */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_PI_GLOBAL_TABLE_V0_SHFT               4
#define SH_PI_GLOBAL_TABLE_V0_MASK               0x0000000000000010

/*   SH_PI_GLOBAL_TABLE_NI_SEL0                                         */
/*   Description:  ni select for requests                               */
#define SH_PI_GLOBAL_TABLE_NI_SEL0_SHFT          5
#define SH_PI_GLOBAL_TABLE_NI_SEL0_MASK          0x0000000000000020

/*   SH_PI_GLOBAL_TABLE_DIR1                                            */
#define SH_PI_GLOBAL_TABLE_DIR1_SHFT             8
#define SH_PI_GLOBAL_TABLE_DIR1_MASK             0x0000000000000f00

/*   SH_PI_GLOBAL_TABLE_V1                                              */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_PI_GLOBAL_TABLE_V1_SHFT               12
#define SH_PI_GLOBAL_TABLE_V1_MASK               0x0000000000001000

/*   SH_PI_GLOBAL_TABLE_NI_SEL1                                         */
/*   Description:  ni select for plane-hint 1                           */
#define SH_PI_GLOBAL_TABLE_NI_SEL1_SHFT          13
#define SH_PI_GLOBAL_TABLE_NI_SEL1_MASK          0x0000000000002000

/*   SH_PI_GLOBAL_TABLE_VALID                                           */
/*   Description:  Indicates that this entry is valid                   */
#define SH_PI_GLOBAL_TABLE_VALID_SHFT            63
#define SH_PI_GLOBAL_TABLE_VALID_MASK            0x8000000000000000

/* ==================================================================== */
/*                   Register "SH_PI_OVER_RIDE_TABLE"                   */
/*              If enabled, bypass the Global/Local tables              */
/* ==================================================================== */

#define SH_PI_OVER_RIDE_TABLE                    0x0000000150021480
#define SH_PI_OVER_RIDE_TABLE_MASK               0x8000000000003f3f
#define SH_PI_OVER_RIDE_TABLE_INIT               0x8000000000002000

/*   SH_PI_OVER_RIDE_TABLE_DIR0                                         */
/*   Description:  Direction field for next chip                        */
#define SH_PI_OVER_RIDE_TABLE_DIR0_SHFT          0
#define SH_PI_OVER_RIDE_TABLE_DIR0_MASK          0x000000000000000f

/*   SH_PI_OVER_RIDE_TABLE_V0                                           */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_PI_OVER_RIDE_TABLE_V0_SHFT            4
#define SH_PI_OVER_RIDE_TABLE_V0_MASK            0x0000000000000010

/*   SH_PI_OVER_RIDE_TABLE_NI_SEL0                                      */
/*   Description:  ni select                                            */
#define SH_PI_OVER_RIDE_TABLE_NI_SEL0_SHFT       5
#define SH_PI_OVER_RIDE_TABLE_NI_SEL0_MASK       0x0000000000000020

/*   SH_PI_OVER_RIDE_TABLE_DIR1                                         */
#define SH_PI_OVER_RIDE_TABLE_DIR1_SHFT          8
#define SH_PI_OVER_RIDE_TABLE_DIR1_MASK          0x0000000000000f00

/*   SH_PI_OVER_RIDE_TABLE_V1                                           */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_PI_OVER_RIDE_TABLE_V1_SHFT            12
#define SH_PI_OVER_RIDE_TABLE_V1_MASK            0x0000000000001000

/*   SH_PI_OVER_RIDE_TABLE_NI_SEL1                                      */
/*   Description:  ni select                                            */
#define SH_PI_OVER_RIDE_TABLE_NI_SEL1_SHFT       13
#define SH_PI_OVER_RIDE_TABLE_NI_SEL1_MASK       0x0000000000002000

/*   SH_PI_OVER_RIDE_TABLE_ENABLE                                       */
/*   Description:  Indicates that this entry is enabled                 */
#define SH_PI_OVER_RIDE_TABLE_ENABLE_SHFT        63
#define SH_PI_OVER_RIDE_TABLE_ENABLE_MASK        0x8000000000000000

/* ==================================================================== */
/*                   Register "SH_PI_RSP_PLANE_HINT"                    */
/*  If enabled, invert incoming response only plane hint bit before lo  */
/* ==================================================================== */

#define SH_PI_RSP_PLANE_HINT                     0x0000000150021488
#define SH_PI_RSP_PLANE_HINT_MASK                0x0000000000000001
#define SH_PI_RSP_PLANE_HINT_INIT                0x0000000000000000

/*   SH_PI_RSP_PLANE_HINT_INVERT                                        */
/*   Description:  Invert Response Plane Hint                           */
#define SH_PI_RSP_PLANE_HINT_INVERT_SHFT         0
#define SH_PI_RSP_PLANE_HINT_INVERT_MASK         0x0000000000000001

/* ==================================================================== */
/*                    Register "SH_NI0_LOCAL_TABLE"                     */
/*                          local lookup table                          */
/* ==================================================================== */

#define SH_NI0_LOCAL_TABLE                       0x0000000150022000
#define SH_NI0_LOCAL_TABLE_MASK                  0x800000000000001f
#define SH_NI0_LOCAL_TABLE_MEMDEPTH              128
#define SH_NI0_LOCAL_TABLE_INIT                  0x0000000000000000

/*   SH_NI0_LOCAL_TABLE_DIR0                                            */
/*   Description:  Direction field for next chip                        */
#define SH_NI0_LOCAL_TABLE_DIR0_SHFT             0
#define SH_NI0_LOCAL_TABLE_DIR0_MASK             0x000000000000000f

/*   SH_NI0_LOCAL_TABLE_V0                                              */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_NI0_LOCAL_TABLE_V0_SHFT               4
#define SH_NI0_LOCAL_TABLE_V0_MASK               0x0000000000000010

/*   SH_NI0_LOCAL_TABLE_VALID                                           */
/*   Description:  Indicates that this entry is valid                   */
#define SH_NI0_LOCAL_TABLE_VALID_SHFT            63
#define SH_NI0_LOCAL_TABLE_VALID_MASK            0x8000000000000000

/* ==================================================================== */
/*                    Register "SH_NI0_GLOBAL_TABLE"                    */
/*                         global lookup table                          */
/* ==================================================================== */

#define SH_NI0_GLOBAL_TABLE                      0x0000000150022400
#define SH_NI0_GLOBAL_TABLE_MASK                 0x800000000000001f
#define SH_NI0_GLOBAL_TABLE_MEMDEPTH             16
#define SH_NI0_GLOBAL_TABLE_INIT                 0x0000000000000000

/*   SH_NI0_GLOBAL_TABLE_DIR0                                           */
/*   Description:  Direction field for next chip                        */
#define SH_NI0_GLOBAL_TABLE_DIR0_SHFT            0
#define SH_NI0_GLOBAL_TABLE_DIR0_MASK            0x000000000000000f

/*   SH_NI0_GLOBAL_TABLE_V0                                             */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_NI0_GLOBAL_TABLE_V0_SHFT              4
#define SH_NI0_GLOBAL_TABLE_V0_MASK              0x0000000000000010

/*   SH_NI0_GLOBAL_TABLE_VALID                                          */
/*   Description:  Indicates that this entry is valid                   */
#define SH_NI0_GLOBAL_TABLE_VALID_SHFT           63
#define SH_NI0_GLOBAL_TABLE_VALID_MASK           0x8000000000000000

/* ==================================================================== */
/*                  Register "SH_NI0_OVER_RIDE_TABLE"                   */
/*              If enabled, bypass the Global/Local tables              */
/* ==================================================================== */

#define SH_NI0_OVER_RIDE_TABLE                   0x0000000150022480
#define SH_NI0_OVER_RIDE_TABLE_MASK              0x800000000000001f
#define SH_NI0_OVER_RIDE_TABLE_INIT              0x8000000000000000

/*   SH_NI0_OVER_RIDE_TABLE_DIR0                                        */
/*   Description:  Direction field for next chip                        */
#define SH_NI0_OVER_RIDE_TABLE_DIR0_SHFT         0
#define SH_NI0_OVER_RIDE_TABLE_DIR0_MASK         0x000000000000000f

/*   SH_NI0_OVER_RIDE_TABLE_V0                                          */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_NI0_OVER_RIDE_TABLE_V0_SHFT           4
#define SH_NI0_OVER_RIDE_TABLE_V0_MASK           0x0000000000000010

/*   SH_NI0_OVER_RIDE_TABLE_ENABLE                                      */
/*   Description:  Indicates that this entry is enabled                 */
#define SH_NI0_OVER_RIDE_TABLE_ENABLE_SHFT       63
#define SH_NI0_OVER_RIDE_TABLE_ENABLE_MASK       0x8000000000000000

/* ==================================================================== */
/*                   Register "SH_NI0_RSP_PLANE_HINT"                   */
/*  If enabled, invert incoming response only plane hint bit before lo  */
/* ==================================================================== */

#define SH_NI0_RSP_PLANE_HINT                    0x0000000150022488
#define SH_NI0_RSP_PLANE_HINT_MASK               0x0000000000000000
#define SH_NI0_RSP_PLANE_HINT_INIT               0x0000000000000000

/* ==================================================================== */
/*                    Register "SH_NI1_LOCAL_TABLE"                     */
/*                          local lookup table                          */
/* ==================================================================== */

#define SH_NI1_LOCAL_TABLE                       0x0000000150023000
#define SH_NI1_LOCAL_TABLE_MASK                  0x800000000000001f
#define SH_NI1_LOCAL_TABLE_MEMDEPTH              128
#define SH_NI1_LOCAL_TABLE_INIT                  0x0000000000000000

/*   SH_NI1_LOCAL_TABLE_DIR0                                            */
/*   Description:  Direction field for next chip                        */
#define SH_NI1_LOCAL_TABLE_DIR0_SHFT             0
#define SH_NI1_LOCAL_TABLE_DIR0_MASK             0x000000000000000f

/*   SH_NI1_LOCAL_TABLE_V0                                              */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_NI1_LOCAL_TABLE_V0_SHFT               4
#define SH_NI1_LOCAL_TABLE_V0_MASK               0x0000000000000010

/*   SH_NI1_LOCAL_TABLE_VALID                                           */
/*   Description:  Indicates that this entry is valid                   */
#define SH_NI1_LOCAL_TABLE_VALID_SHFT            63
#define SH_NI1_LOCAL_TABLE_VALID_MASK            0x8000000000000000

/* ==================================================================== */
/*                    Register "SH_NI1_GLOBAL_TABLE"                    */
/*                         global lookup table                          */
/* ==================================================================== */

#define SH_NI1_GLOBAL_TABLE                      0x0000000150023400
#define SH_NI1_GLOBAL_TABLE_MASK                 0x800000000000001f
#define SH_NI1_GLOBAL_TABLE_MEMDEPTH             16
#define SH_NI1_GLOBAL_TABLE_INIT                 0x0000000000000000

/*   SH_NI1_GLOBAL_TABLE_DIR0                                           */
/*   Description:  Direction field for next chip                        */
#define SH_NI1_GLOBAL_TABLE_DIR0_SHFT            0
#define SH_NI1_GLOBAL_TABLE_DIR0_MASK            0x000000000000000f

/*   SH_NI1_GLOBAL_TABLE_V0                                             */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_NI1_GLOBAL_TABLE_V0_SHFT              4
#define SH_NI1_GLOBAL_TABLE_V0_MASK              0x0000000000000010

/*   SH_NI1_GLOBAL_TABLE_VALID                                          */
/*   Description:  Indicates that this entry is valid                   */
#define SH_NI1_GLOBAL_TABLE_VALID_SHFT           63
#define SH_NI1_GLOBAL_TABLE_VALID_MASK           0x8000000000000000

/* ==================================================================== */
/*                  Register "SH_NI1_OVER_RIDE_TABLE"                   */
/*              If enabled, bypass the Global/Local tables              */
/* ==================================================================== */

#define SH_NI1_OVER_RIDE_TABLE                   0x0000000150023480
#define SH_NI1_OVER_RIDE_TABLE_MASK              0x800000000000001f
#define SH_NI1_OVER_RIDE_TABLE_INIT              0x8000000000000000

/*   SH_NI1_OVER_RIDE_TABLE_DIR0                                        */
/*   Description:  Direction field for next chip                        */
#define SH_NI1_OVER_RIDE_TABLE_DIR0_SHFT         0
#define SH_NI1_OVER_RIDE_TABLE_DIR0_MASK         0x000000000000000f

/*   SH_NI1_OVER_RIDE_TABLE_V0                                          */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_NI1_OVER_RIDE_TABLE_V0_SHFT           4
#define SH_NI1_OVER_RIDE_TABLE_V0_MASK           0x0000000000000010

/*   SH_NI1_OVER_RIDE_TABLE_ENABLE                                      */
/*   Description:  Indicates that this entry is enabled                 */
#define SH_NI1_OVER_RIDE_TABLE_ENABLE_SHFT       63
#define SH_NI1_OVER_RIDE_TABLE_ENABLE_MASK       0x8000000000000000

/* ==================================================================== */
/*                   Register "SH_NI1_RSP_PLANE_HINT"                   */
/*  If enabled, invert incoming response only plane hint bit before lo  */
/* ==================================================================== */

#define SH_NI1_RSP_PLANE_HINT                    0x0000000150023488
#define SH_NI1_RSP_PLANE_HINT_MASK               0x0000000000000000
#define SH_NI1_RSP_PLANE_HINT_INIT               0x0000000000000000

/* ==================================================================== */
/*                     Register "SH_MD_LOCAL_TABLE"                     */
/*                          local lookup table                          */
/* ==================================================================== */

#define SH_MD_LOCAL_TABLE                        0x0000000150024000
#define SH_MD_LOCAL_TABLE_MASK                   0x8000000000003f3f
#define SH_MD_LOCAL_TABLE_MEMDEPTH               128
#define SH_MD_LOCAL_TABLE_INIT                   0x0000000000000000

/*   SH_MD_LOCAL_TABLE_DIR0                                             */
/*   Description:  Direction field for next chip                        */
#define SH_MD_LOCAL_TABLE_DIR0_SHFT              0
#define SH_MD_LOCAL_TABLE_DIR0_MASK              0x000000000000000f

/*   SH_MD_LOCAL_TABLE_V0                                               */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_MD_LOCAL_TABLE_V0_SHFT                4
#define SH_MD_LOCAL_TABLE_V0_MASK                0x0000000000000010

/*   SH_MD_LOCAL_TABLE_NI_SEL0                                          */
/*   Description:  ni select for requests                               */
#define SH_MD_LOCAL_TABLE_NI_SEL0_SHFT           5
#define SH_MD_LOCAL_TABLE_NI_SEL0_MASK           0x0000000000000020

/*   SH_MD_LOCAL_TABLE_DIR1                                             */
#define SH_MD_LOCAL_TABLE_DIR1_SHFT              8
#define SH_MD_LOCAL_TABLE_DIR1_MASK              0x0000000000000f00

/*   SH_MD_LOCAL_TABLE_V1                                               */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_MD_LOCAL_TABLE_V1_SHFT                12
#define SH_MD_LOCAL_TABLE_V1_MASK                0x0000000000001000

/*   SH_MD_LOCAL_TABLE_NI_SEL1                                          */
/*   Description:  ni select for plane-hint 1                           */
#define SH_MD_LOCAL_TABLE_NI_SEL1_SHFT           13
#define SH_MD_LOCAL_TABLE_NI_SEL1_MASK           0x0000000000002000

/*   SH_MD_LOCAL_TABLE_VALID                                            */
/*   Description:  Indicates that this entry is valid                   */
#define SH_MD_LOCAL_TABLE_VALID_SHFT             63
#define SH_MD_LOCAL_TABLE_VALID_MASK             0x8000000000000000

/* ==================================================================== */
/*                    Register "SH_MD_GLOBAL_TABLE"                     */
/*                         global lookup table                          */
/* ==================================================================== */

#define SH_MD_GLOBAL_TABLE                       0x0000000150024400
#define SH_MD_GLOBAL_TABLE_MASK                  0x8000000000003f3f
#define SH_MD_GLOBAL_TABLE_MEMDEPTH              16
#define SH_MD_GLOBAL_TABLE_INIT                  0x0000000000000000

/*   SH_MD_GLOBAL_TABLE_DIR0                                            */
/*   Description:  Direction field for next chip                        */
#define SH_MD_GLOBAL_TABLE_DIR0_SHFT             0
#define SH_MD_GLOBAL_TABLE_DIR0_MASK             0x000000000000000f

/*   SH_MD_GLOBAL_TABLE_V0                                              */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_MD_GLOBAL_TABLE_V0_SHFT               4
#define SH_MD_GLOBAL_TABLE_V0_MASK               0x0000000000000010

/*   SH_MD_GLOBAL_TABLE_NI_SEL0                                         */
/*   Description:  ni select for requests                               */
#define SH_MD_GLOBAL_TABLE_NI_SEL0_SHFT          5
#define SH_MD_GLOBAL_TABLE_NI_SEL0_MASK          0x0000000000000020

/*   SH_MD_GLOBAL_TABLE_DIR1                                            */
#define SH_MD_GLOBAL_TABLE_DIR1_SHFT             8
#define SH_MD_GLOBAL_TABLE_DIR1_MASK             0x0000000000000f00

/*   SH_MD_GLOBAL_TABLE_V1                                              */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_MD_GLOBAL_TABLE_V1_SHFT               12
#define SH_MD_GLOBAL_TABLE_V1_MASK               0x0000000000001000

/*   SH_MD_GLOBAL_TABLE_NI_SEL1                                         */
/*   Description:  ni select for plane-hint 1                           */
#define SH_MD_GLOBAL_TABLE_NI_SEL1_SHFT          13
#define SH_MD_GLOBAL_TABLE_NI_SEL1_MASK          0x0000000000002000

/*   SH_MD_GLOBAL_TABLE_VALID                                           */
/*   Description:  Indicates that this entry is valid                   */
#define SH_MD_GLOBAL_TABLE_VALID_SHFT            63
#define SH_MD_GLOBAL_TABLE_VALID_MASK            0x8000000000000000

/* ==================================================================== */
/*                   Register "SH_MD_OVER_RIDE_TABLE"                   */
/*              If enabled, bypass the Global/Local tables              */
/* ==================================================================== */

#define SH_MD_OVER_RIDE_TABLE                    0x0000000150024480
#define SH_MD_OVER_RIDE_TABLE_MASK               0x8000000000003f3f
#define SH_MD_OVER_RIDE_TABLE_INIT               0x8000000000002000

/*   SH_MD_OVER_RIDE_TABLE_DIR0                                         */
/*   Description:  Direction field for next chip                        */
#define SH_MD_OVER_RIDE_TABLE_DIR0_SHFT          0
#define SH_MD_OVER_RIDE_TABLE_DIR0_MASK          0x000000000000000f

/*   SH_MD_OVER_RIDE_TABLE_V0                                           */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_MD_OVER_RIDE_TABLE_V0_SHFT            4
#define SH_MD_OVER_RIDE_TABLE_V0_MASK            0x0000000000000010

/*   SH_MD_OVER_RIDE_TABLE_NI_SEL0                                      */
/*   Description:  ni select                                            */
#define SH_MD_OVER_RIDE_TABLE_NI_SEL0_SHFT       5
#define SH_MD_OVER_RIDE_TABLE_NI_SEL0_MASK       0x0000000000000020

/*   SH_MD_OVER_RIDE_TABLE_DIR1                                         */
#define SH_MD_OVER_RIDE_TABLE_DIR1_SHFT          8
#define SH_MD_OVER_RIDE_TABLE_DIR1_MASK          0x0000000000000f00

/*   SH_MD_OVER_RIDE_TABLE_V1                                           */
/*   Description:  Low bit of virtual channel for next chip             */
#define SH_MD_OVER_RIDE_TABLE_V1_SHFT            12
#define SH_MD_OVER_RIDE_TABLE_V1_MASK            0x0000000000001000

/*   SH_MD_OVER_RIDE_TABLE_NI_SEL1                                      */
/*   Description:  ni select                                            */
#define SH_MD_OVER_RIDE_TABLE_NI_SEL1_SHFT       13
#define SH_MD_OVER_RIDE_TABLE_NI_SEL1_MASK       0x0000000000002000

/*   SH_MD_OVER_RIDE_TABLE_ENABLE                                       */
/*   Description:  Indicates that this entry is enabled                 */
#define SH_MD_OVER_RIDE_TABLE_ENABLE_SHFT        63
#define SH_MD_OVER_RIDE_TABLE_ENABLE_MASK        0x8000000000000000

/* ==================================================================== */
/*                   Register "SH_MD_RSP_PLANE_HINT"                    */
/*  If enabled, invert incoming response only plane hint bit before lo  */
/* ==================================================================== */

#define SH_MD_RSP_PLANE_HINT                     0x0000000150024488
#define SH_MD_RSP_PLANE_HINT_MASK                0x0000000000000001
#define SH_MD_RSP_PLANE_HINT_INIT                0x0000000000000000

/*   SH_MD_RSP_PLANE_HINT_INVERT                                        */
/*   Description:  Invert Response Plane Hint                           */
#define SH_MD_RSP_PLANE_HINT_INVERT_SHFT         0
#define SH_MD_RSP_PLANE_HINT_INVERT_MASK         0x0000000000000001

/* ==================================================================== */
/*                       Register "SH_LB_LIQ_CTL"                       */
/*                       Local Block LIQ Control                        */
/* ==================================================================== */

#define SH_LB_LIQ_CTL                            0x0000000110040000
#define SH_LB_LIQ_CTL_MASK                       0x0000000000070f1f
#define SH_LB_LIQ_CTL_INIT                       0x0000000000000000

/*   SH_LB_LIQ_CTL_LIQ_REQ_CTL                                          */
/*   Description:  LIQ Request Control                                  */
#define SH_LB_LIQ_CTL_LIQ_REQ_CTL_SHFT           0
#define SH_LB_LIQ_CTL_LIQ_REQ_CTL_MASK           0x000000000000001f

/*   SH_LB_LIQ_CTL_LIQ_RPL_CTL                                          */
/*   Description:  LIQ Reply Control                                    */
#define SH_LB_LIQ_CTL_LIQ_RPL_CTL_SHFT           8
#define SH_LB_LIQ_CTL_LIQ_RPL_CTL_MASK           0x0000000000000f00

/*   SH_LB_LIQ_CTL_FORCE_RQ_CREDIT                                      */
/*   Description:  Force request credit                                 */
#define SH_LB_LIQ_CTL_FORCE_RQ_CREDIT_SHFT       16
#define SH_LB_LIQ_CTL_FORCE_RQ_CREDIT_MASK       0x0000000000010000

/*   SH_LB_LIQ_CTL_FORCE_RP_CREDIT                                      */
/*   Description:  Force reply credit                                   */
#define SH_LB_LIQ_CTL_FORCE_RP_CREDIT_SHFT       17
#define SH_LB_LIQ_CTL_FORCE_RP_CREDIT_MASK       0x0000000000020000

/*   SH_LB_LIQ_CTL_FORCE_LINVV_CREDIT                                   */
/*   Description:  Force linvv credit                                   */
#define SH_LB_LIQ_CTL_FORCE_LINVV_CREDIT_SHFT    18
#define SH_LB_LIQ_CTL_FORCE_LINVV_CREDIT_MASK    0x0000000000040000

/* ==================================================================== */
/*                       Register "SH_LB_LOQ_CTL"                       */
/*                       Local Block LOQ Control                        */
/* ==================================================================== */

#define SH_LB_LOQ_CTL                            0x0000000110040080
#define SH_LB_LOQ_CTL_MASK                       0x0000000000000003
#define SH_LB_LOQ_CTL_INIT                       0x0000000000000000

/*   SH_LB_LOQ_CTL_LOQ_REQ_CTL                                          */
/*   Description:  LOQ Request Control                                  */
#define SH_LB_LOQ_CTL_LOQ_REQ_CTL_SHFT           0
#define SH_LB_LOQ_CTL_LOQ_REQ_CTL_MASK           0x0000000000000001

/*   SH_LB_LOQ_CTL_LOQ_RPL_CTL                                          */
/*   Description:  LOQ Reply Control                                    */
#define SH_LB_LOQ_CTL_LOQ_RPL_CTL_SHFT           1
#define SH_LB_LOQ_CTL_LOQ_RPL_CTL_MASK           0x0000000000000002

/* ==================================================================== */
/*                 Register "SH_LB_MAX_REP_CREDIT_CNT"                  */
/*               Maximum number of reply credits from XN                */
/* ==================================================================== */

#define SH_LB_MAX_REP_CREDIT_CNT                 0x0000000110040100
#define SH_LB_MAX_REP_CREDIT_CNT_MASK            0x000000000000001f
#define SH_LB_MAX_REP_CREDIT_CNT_INIT            0x000000000000001f

/*   SH_LB_MAX_REP_CREDIT_CNT_MAX_CNT                                   */
/*   Description:  Max reply credits                                    */
#define SH_LB_MAX_REP_CREDIT_CNT_MAX_CNT_SHFT    0
#define SH_LB_MAX_REP_CREDIT_CNT_MAX_CNT_MASK    0x000000000000001f

/* ==================================================================== */
/*                 Register "SH_LB_MAX_REQ_CREDIT_CNT"                  */
/*              Maximum number of request credits from XN               */
/* ==================================================================== */

#define SH_LB_MAX_REQ_CREDIT_CNT                 0x0000000110040180
#define SH_LB_MAX_REQ_CREDIT_CNT_MASK            0x000000000000001f
#define SH_LB_MAX_REQ_CREDIT_CNT_INIT            0x000000000000001f

/*   SH_LB_MAX_REQ_CREDIT_CNT_MAX_CNT                                   */
/*   Description:  Max request credits                                  */
#define SH_LB_MAX_REQ_CREDIT_CNT_MAX_CNT_SHFT    0
#define SH_LB_MAX_REQ_CREDIT_CNT_MAX_CNT_MASK    0x000000000000001f

/* ==================================================================== */
/*                      Register "SH_PIO_TIME_OUT"                      */
/*                    Local Block PIO time out value                    */
/* ==================================================================== */

#define SH_PIO_TIME_OUT                          0x0000000110040200
#define SH_PIO_TIME_OUT_MASK                     0x000000000000ffff
#define SH_PIO_TIME_OUT_INIT                     0x0000000000000400

/*   SH_PIO_TIME_OUT_VALUE                                              */
/*   Description:  PIO time out value                                   */
#define SH_PIO_TIME_OUT_VALUE_SHFT               0
#define SH_PIO_TIME_OUT_VALUE_MASK               0x000000000000ffff

/* ==================================================================== */
/*                     Register "SH_PIO_NACK_RESET"                     */
/*               Local Block PIO Reset for nack counters                */
/* ==================================================================== */

#define SH_PIO_NACK_RESET                        0x0000000110040280
#define SH_PIO_NACK_RESET_MASK                   0x0000000000000001
#define SH_PIO_NACK_RESET_INIT                   0x0000000000000000

/*   SH_PIO_NACK_RESET_PULSE                                            */
/*   Description:  PIO nack counter reset                               */
#define SH_PIO_NACK_RESET_PULSE_SHFT             0
#define SH_PIO_NACK_RESET_PULSE_MASK             0x0000000000000001

/* ==================================================================== */
/*                 Register "SH_CONVEYOR_BELT_TIME_OUT"                 */
/*               Local Block conveyor belt time out value               */
/* ==================================================================== */

#define SH_CONVEYOR_BELT_TIME_OUT                0x0000000110040300
#define SH_CONVEYOR_BELT_TIME_OUT_MASK           0x0000000000000fff
#define SH_CONVEYOR_BELT_TIME_OUT_INIT           0x0000000000000000

/*   SH_CONVEYOR_BELT_TIME_OUT_VALUE                                    */
/*   Description:  Conveyor belt time out value                         */
#define SH_CONVEYOR_BELT_TIME_OUT_VALUE_SHFT     0
#define SH_CONVEYOR_BELT_TIME_OUT_VALUE_MASK     0x0000000000000fff

/* ==================================================================== */
/*                    Register "SH_LB_CREDIT_STATUS"                    */
/*                    Credit Counter Status Register                    */
/* ==================================================================== */

#define SH_LB_CREDIT_STATUS                      0x0000000110050000
#define SH_LB_CREDIT_STATUS_MASK                 0x000000000ffff3df
#define SH_LB_CREDIT_STATUS_INIT                 0x0000000000000000

/*   SH_LB_CREDIT_STATUS_LIQ_RQ_CREDIT                                  */
/*   Description:  LIQ request queue credit counter                     */
#define SH_LB_CREDIT_STATUS_LIQ_RQ_CREDIT_SHFT   0
#define SH_LB_CREDIT_STATUS_LIQ_RQ_CREDIT_MASK   0x000000000000001f

/*   SH_LB_CREDIT_STATUS_LIQ_RP_CREDIT                                  */
/*   Description:  LIQ reply queue credit counter                       */
#define SH_LB_CREDIT_STATUS_LIQ_RP_CREDIT_SHFT   6
#define SH_LB_CREDIT_STATUS_LIQ_RP_CREDIT_MASK   0x00000000000003c0

/*   SH_LB_CREDIT_STATUS_LINVV_CREDIT                                   */
/*   Description:  LINVV credit counter                                 */
#define SH_LB_CREDIT_STATUS_LINVV_CREDIT_SHFT    12
#define SH_LB_CREDIT_STATUS_LINVV_CREDIT_MASK    0x000000000003f000

/*   SH_LB_CREDIT_STATUS_LOQ_RQ_CREDIT                                  */
/*   Description:  LOQ request queue credit counter                     */
#define SH_LB_CREDIT_STATUS_LOQ_RQ_CREDIT_SHFT   18
#define SH_LB_CREDIT_STATUS_LOQ_RQ_CREDIT_MASK   0x00000000007c0000

/*   SH_LB_CREDIT_STATUS_LOQ_RP_CREDIT                                  */
/*   Description:  LOQ reply queue credit counter                       */
#define SH_LB_CREDIT_STATUS_LOQ_RP_CREDIT_SHFT   23
#define SH_LB_CREDIT_STATUS_LOQ_RP_CREDIT_MASK   0x000000000f800000

/* ==================================================================== */
/*                   Register "SH_LB_DEBUG_LOCAL_SEL"                   */
/*                         LB Debug Port Select                         */
/* ==================================================================== */

#define SH_LB_DEBUG_LOCAL_SEL                    0x0000000110050080
#define SH_LB_DEBUG_LOCAL_SEL_MASK               0xf777777777777777
#define SH_LB_DEBUG_LOCAL_SEL_INIT               0x0000000000000000

/*   SH_LB_DEBUG_LOCAL_SEL_NIBBLE0_CHIPLET_SEL                          */
/*   Description:  Nibble 0 Chiplet select                              */
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE0_CHIPLET_SEL_SHFT 0
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE0_CHIPLET_SEL_MASK 0x0000000000000007

/*   SH_LB_DEBUG_LOCAL_SEL_NIBBLE0_NIBBLE_SEL                           */
/*   Description:  Nibble 0 Nibble select                               */
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE0_NIBBLE_SEL_SHFT 4
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE0_NIBBLE_SEL_MASK 0x0000000000000070

/*   SH_LB_DEBUG_LOCAL_SEL_NIBBLE1_CHIPLET_SEL                          */
/*   Description:  Nibble 1 Chiplet select                              */
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE1_CHIPLET_SEL_SHFT 8
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE1_CHIPLET_SEL_MASK 0x0000000000000700

/*   SH_LB_DEBUG_LOCAL_SEL_NIBBLE1_NIBBLE_SEL                           */
/*   Description:  Nibble 1 Nibble select                               */
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE1_NIBBLE_SEL_SHFT 12
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE1_NIBBLE_SEL_MASK 0x0000000000007000

/*   SH_LB_DEBUG_LOCAL_SEL_NIBBLE2_CHIPLET_SEL                          */
/*   Description:  Nibble 2 Chiplet select                              */
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE2_CHIPLET_SEL_SHFT 16
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE2_CHIPLET_SEL_MASK 0x0000000000070000

/*   SH_LB_DEBUG_LOCAL_SEL_NIBBLE2_NIBBLE_SEL                           */
/*   Description:  Nibble 2 Nibble select                               */
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE2_NIBBLE_SEL_SHFT 20
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE2_NIBBLE_SEL_MASK 0x0000000000700000

/*   SH_LB_DEBUG_LOCAL_SEL_NIBBLE3_CHIPLET_SEL                          */
/*   Description:  Nibble 3 Chiplet select                              */
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE3_CHIPLET_SEL_SHFT 24
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE3_CHIPLET_SEL_MASK 0x0000000007000000

/*   SH_LB_DEBUG_LOCAL_SEL_NIBBLE3_NIBBLE_SEL                           */
/*   Description:  Nibble 3 Nibble select                               */
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE3_NIBBLE_SEL_SHFT 28
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE3_NIBBLE_SEL_MASK 0x0000000070000000

/*   SH_LB_DEBUG_LOCAL_SEL_NIBBLE4_CHIPLET_SEL                          */
/*   Description:  Nibble 4 Chiplet select                              */
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE4_CHIPLET_SEL_SHFT 32
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE4_CHIPLET_SEL_MASK 0x0000000700000000

/*   SH_LB_DEBUG_LOCAL_SEL_NIBBLE4_NIBBLE_SEL                           */
/*   Description:  Nibble 4 Nibble select                               */
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE4_NIBBLE_SEL_SHFT 36
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE4_NIBBLE_SEL_MASK 0x0000007000000000

/*   SH_LB_DEBUG_LOCAL_SEL_NIBBLE5_CHIPLET_SEL                          */
/*   Description:  Nibble 5 Chiplet select                              */
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE5_CHIPLET_SEL_SHFT 40
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE5_CHIPLET_SEL_MASK 0x0000070000000000

/*   SH_LB_DEBUG_LOCAL_SEL_NIBBLE5_NIBBLE_SEL                           */
/*   Description:  Nibble 5 Nibble select                               */
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE5_NIBBLE_SEL_SHFT 44
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE5_NIBBLE_SEL_MASK 0x0000700000000000

/*   SH_LB_DEBUG_LOCAL_SEL_NIBBLE6_CHIPLET_SEL                          */
/*   Description:  Nibble 6 Chiplet select                              */
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE6_CHIPLET_SEL_SHFT 48
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE6_CHIPLET_SEL_MASK 0x0007000000000000

/*   SH_LB_DEBUG_LOCAL_SEL_NIBBLE6_NIBBLE_SEL                           */
/*   Description:  Nibble 6 Nibble select                               */
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE6_NIBBLE_SEL_SHFT 52
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE6_NIBBLE_SEL_MASK 0x0070000000000000

/*   SH_LB_DEBUG_LOCAL_SEL_NIBBLE7_CHIPLET_SEL                          */
/*   Description:  Nibble 7 Chiplet select                              */
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE7_CHIPLET_SEL_SHFT 56
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE7_CHIPLET_SEL_MASK 0x0700000000000000

/*   SH_LB_DEBUG_LOCAL_SEL_NIBBLE7_NIBBLE_SEL                           */
/*   Description:  Nibble 7 Nibble select                               */
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE7_NIBBLE_SEL_SHFT 60
#define SH_LB_DEBUG_LOCAL_SEL_NIBBLE7_NIBBLE_SEL_MASK 0x7000000000000000

/*   SH_LB_DEBUG_LOCAL_SEL_TRIGGER_ENABLE                               */
/*   Description:  Enable trigger on bit 32 of Analyzer data            */
#define SH_LB_DEBUG_LOCAL_SEL_TRIGGER_ENABLE_SHFT 63
#define SH_LB_DEBUG_LOCAL_SEL_TRIGGER_ENABLE_MASK 0x8000000000000000

/* ==================================================================== */
/*                   Register "SH_LB_DEBUG_PERF_SEL"                    */
/*                   LB Debug Port Performance Select                   */
/* ==================================================================== */

#define SH_LB_DEBUG_PERF_SEL                     0x0000000110050100
#define SH_LB_DEBUG_PERF_SEL_MASK                0x7777777777777777
#define SH_LB_DEBUG_PERF_SEL_INIT                0x0000000000000000

/*   SH_LB_DEBUG_PERF_SEL_NIBBLE0_CHIPLET_SEL                           */
/*   Description:  Nibble 0 Chiplet select                              */
#define SH_LB_DEBUG_PERF_SEL_NIBBLE0_CHIPLET_SEL_SHFT 0
#define SH_LB_DEBUG_PERF_SEL_NIBBLE0_CHIPLET_SEL_MASK 0x0000000000000007

/*   SH_LB_DEBUG_PERF_SEL_NIBBLE0_NIBBLE_SEL                            */
/*   Description:  Nibble 0 Nibble select                               */
#define SH_LB_DEBUG_PERF_SEL_NIBBLE0_NIBBLE_SEL_SHFT 4
#define SH_LB_DEBUG_PERF_SEL_NIBBLE0_NIBBLE_SEL_MASK 0x0000000000000070

/*   SH_LB_DEBUG_PERF_SEL_NIBBLE1_CHIPLET_SEL                           */
/*   Description:  Nibble 1 Chiplet select                              */
#define SH_LB_DEBUG_PERF_SEL_NIBBLE1_CHIPLET_SEL_SHFT 8
#define SH_LB_DEBUG_PERF_SEL_NIBBLE1_CHIPLET_SEL_MASK 0x0000000000000700

/*   SH_LB_DEBUG_PERF_SEL_NIBBLE1_NIBBLE_SEL                            */
/*   Description:  Nibble 1 Nibble select                               */
#define SH_LB_DEBUG_PERF_SEL_NIBBLE1_NIBBLE_SEL_SHFT 12
#define SH_LB_DEBUG_PERF_SEL_NIBBLE1_NIBBLE_SEL_MASK 0x0000000000007000

/*   SH_LB_DEBUG_PERF_SEL_NIBBLE2_CHIPLET_SEL                           */
/*   Description:  Nibble 2 Chiplet select                              */
#define SH_LB_DEBUG_PERF_SEL_NIBBLE2_CHIPLET_SEL_SHFT 16
#define SH_LB_DEBUG_PERF_SEL_NIBBLE2_CHIPLET_SEL_MASK 0x0000000000070000

/*   SH_LB_DEBUG_PERF_SEL_NIBBLE2_NIBBLE_SEL                            */
/*   Description:  Nibble 2 Nibble select                               */
#define SH_LB_DEBUG_PERF_SEL_NIBBLE2_NIBBLE_SEL_SHFT 20
#define SH_LB_DEBUG_PERF_SEL_NIBBLE2_NIBBLE_SEL_MASK 0x0000000000700000

/*   SH_LB_DEBUG_PERF_SEL_NIBBLE3_CHIPLET_SEL                           */
/*   Description:  Nibble 3 Chiplet select                              */
#define SH_LB_DEBUG_PERF_SEL_NIBBLE3_CHIPLET_SEL_SHFT 24
#define SH_LB_DEBUG_PERF_SEL_NIBBLE3_CHIPLET_SEL_MASK 0x0000000007000000

/*   SH_LB_DEBUG_PERF_SEL_NIBBLE3_NIBBLE_SEL                            */
/*   Description:  Nibble 3 Nibble select                               */
#define SH_LB_DEBUG_PERF_SEL_NIBBLE3_NIBBLE_SEL_SHFT 28
#define SH_LB_DEBUG_PERF_SEL_NIBBLE3_NIBBLE_SEL_MASK 0x0000000070000000

/*   SH_LB_DEBUG_PERF_SEL_NIBBLE4_CHIPLET_SEL                           */
/*   Description:  Nibble 4 Chiplet select                              */
#define SH_LB_DEBUG_PERF_SEL_NIBBLE4_CHIPLET_SEL_SHFT 32
#define SH_LB_DEBUG_PERF_SEL_NIBBLE4_CHIPLET_SEL_MASK 0x0000000700000000

/*   SH_LB_DEBUG_PERF_SEL_NIBBLE4_NIBBLE_SEL                            */
/*   Description:  Nibble 4 Nibble select                               */
#define SH_LB_DEBUG_PERF_SEL_NIBBLE4_NIBBLE_SEL_SHFT 36
#define SH_LB_DEBUG_PERF_SEL_NIBBLE4_NIBBLE_SEL_MASK 0x0000007000000000

/*   SH_LB_DEBUG_PERF_SEL_NIBBLE5_CHIPLET_SEL                           */
/*   Description:  Nibble 5 Chiplet select                              */
#define SH_LB_DEBUG_PERF_SEL_NIBBLE5_CHIPLET_SEL_SHFT 40
#define SH_LB_DEBUG_PERF_SEL_NIBBLE5_CHIPLET_SEL_MASK 0x0000070000000000

/*   SH_LB_DEBUG_PERF_SEL_NIBBLE5_NIBBLE_SEL                            */
/*   Description:  Nibble 5 Nibble select                               */
#define SH_LB_DEBUG_PERF_SEL_NIBBLE5_NIBBLE_SEL_SHFT 44
#define SH_LB_DEBUG_PERF_SEL_NIBBLE5_NIBBLE_SEL_MASK 0x0000700000000000

/*   SH_LB_DEBUG_PERF_SEL_NIBBLE6_CHIPLET_SEL                           */
/*   Description:  Nibble 6 Chiplet select                              */
#define SH_LB_DEBUG_PERF_SEL_NIBBLE6_CHIPLET_SEL_SHFT 48
#define SH_LB_DEBUG_PERF_SEL_NIBBLE6_CHIPLET_SEL_MASK 0x0007000000000000

/*   SH_LB_DEBUG_PERF_SEL_NIBBLE6_NIBBLE_SEL                            */
/*   Description:  Nibble 6 Nibble select                               */
#define SH_LB_DEBUG_PERF_SEL_NIBBLE6_NIBBLE_SEL_SHFT 52
#define SH_LB_DEBUG_PERF_SEL_NIBBLE6_NIBBLE_SEL_MASK 0x0070000000000000

/*   SH_LB_DEBUG_PERF_SEL_NIBBLE7_CHIPLET_SEL                           */
/*   Description:  Nibble 7 Chiplet select                              */
#define SH_LB_DEBUG_PERF_SEL_NIBBLE7_CHIPLET_SEL_SHFT 56
#define SH_LB_DEBUG_PERF_SEL_NIBBLE7_CHIPLET_SEL_MASK 0x0700000000000000

/*   SH_LB_DEBUG_PERF_SEL_NIBBLE7_NIBBLE_SEL                            */
/*   Description:  Nibble 7 Nibble select                               */
#define SH_LB_DEBUG_PERF_SEL_NIBBLE7_NIBBLE_SEL_SHFT 60
#define SH_LB_DEBUG_PERF_SEL_NIBBLE7_NIBBLE_SEL_MASK 0x7000000000000000

/* ==================================================================== */
/*                   Register "SH_LB_DEBUG_TRIG_SEL"                    */
/*                       LB Debug Trigger Select                        */
/* ==================================================================== */

#define SH_LB_DEBUG_TRIG_SEL                     0x0000000110050180
#define SH_LB_DEBUG_TRIG_SEL_MASK                0x7777777777777777
#define SH_LB_DEBUG_TRIG_SEL_INIT                0x0000000000000000

/*   SH_LB_DEBUG_TRIG_SEL_TRIGGER0_CHIPLET_SEL                          */
/*   Description:  Nibble 0 Chiplet select                              */
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER0_CHIPLET_SEL_SHFT 0
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER0_CHIPLET_SEL_MASK 0x0000000000000007

/*   SH_LB_DEBUG_TRIG_SEL_TRIGGER0_NIBBLE_SEL                           */
/*   Description:  Nibble 0 Nibble select                               */
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER0_NIBBLE_SEL_SHFT 4
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER0_NIBBLE_SEL_MASK 0x0000000000000070

/*   SH_LB_DEBUG_TRIG_SEL_TRIGGER1_CHIPLET_SEL                          */
/*   Description:  Nibble 1 Chiplet select                              */
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER1_CHIPLET_SEL_SHFT 8
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER1_CHIPLET_SEL_MASK 0x0000000000000700

/*   SH_LB_DEBUG_TRIG_SEL_TRIGGER1_NIBBLE_SEL                           */
/*   Description:  Nibble 1 Nibble select                               */
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER1_NIBBLE_SEL_SHFT 12
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER1_NIBBLE_SEL_MASK 0x0000000000007000

/*   SH_LB_DEBUG_TRIG_SEL_TRIGGER2_CHIPLET_SEL                          */
/*   Description:  Nibble 2 Chiplet select                              */
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER2_CHIPLET_SEL_SHFT 16
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER2_CHIPLET_SEL_MASK 0x0000000000070000

/*   SH_LB_DEBUG_TRIG_SEL_TRIGGER2_NIBBLE_SEL                           */
/*   Description:  Nibble 2 Nibble select                               */
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER2_NIBBLE_SEL_SHFT 20
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER2_NIBBLE_SEL_MASK 0x0000000000700000

/*   SH_LB_DEBUG_TRIG_SEL_TRIGGER3_CHIPLET_SEL                          */
/*   Description:  Nibble 3 Chiplet select                              */
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER3_CHIPLET_SEL_SHFT 24
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER3_CHIPLET_SEL_MASK 0x0000000007000000

/*   SH_LB_DEBUG_TRIG_SEL_TRIGGER3_NIBBLE_SEL                           */
/*   Description:  Nibble 3 Nibble select                               */
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER3_NIBBLE_SEL_SHFT 28
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER3_NIBBLE_SEL_MASK 0x0000000070000000

/*   SH_LB_DEBUG_TRIG_SEL_TRIGGER4_CHIPLET_SEL                          */
/*   Description:  Nibble 4 Chiplet select                              */
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER4_CHIPLET_SEL_SHFT 32
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER4_CHIPLET_SEL_MASK 0x0000000700000000

/*   SH_LB_DEBUG_TRIG_SEL_TRIGGER4_NIBBLE_SEL                           */
/*   Description:  Nibble 4 Nibble select                               */
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER4_NIBBLE_SEL_SHFT 36
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER4_NIBBLE_SEL_MASK 0x0000007000000000

/*   SH_LB_DEBUG_TRIG_SEL_TRIGGER5_CHIPLET_SEL                          */
/*   Description:  Nibble 5 Chiplet select                              */
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER5_CHIPLET_SEL_SHFT 40
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER5_CHIPLET_SEL_MASK 0x0000070000000000

/*   SH_LB_DEBUG_TRIG_SEL_TRIGGER5_NIBBLE_SEL                           */
/*   Description:  Nibble 5 Nibble select                               */
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER5_NIBBLE_SEL_SHFT 44
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER5_NIBBLE_SEL_MASK 0x0000700000000000

/*   SH_LB_DEBUG_TRIG_SEL_TRIGGER6_CHIPLET_SEL                          */
/*   Description:  Nibble 6 Chiplet select                              */
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER6_CHIPLET_SEL_SHFT 48
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER6_CHIPLET_SEL_MASK 0x0007000000000000

/*   SH_LB_DEBUG_TRIG_SEL_TRIGGER6_NIBBLE_SEL                           */
/*   Description:  Nibble 6 Nibble select                               */
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER6_NIBBLE_SEL_SHFT 52
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER6_NIBBLE_SEL_MASK 0x0070000000000000

/*   SH_LB_DEBUG_TRIG_SEL_TRIGGER7_CHIPLET_SEL                          */
/*   Description:  Nibble 7 Chiplet select                              */
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER7_CHIPLET_SEL_SHFT 56
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER7_CHIPLET_SEL_MASK 0x0700000000000000

/*   SH_LB_DEBUG_TRIG_SEL_TRIGGER7_NIBBLE_SEL                           */
/*   Description:  Nibble 7 Nibble select                               */
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER7_NIBBLE_SEL_SHFT 60
#define SH_LB_DEBUG_TRIG_SEL_TRIGGER7_NIBBLE_SEL_MASK 0x7000000000000000

/* ==================================================================== */
/*                   Register "SH_LB_ERROR_DETAIL_1"                    */
/*                  LB Error capture information: HDR1                  */
/* ==================================================================== */

#define SH_LB_ERROR_DETAIL_1                     0x0000000110050200
#define SH_LB_ERROR_DETAIL_1_MASK                0x8003073fff3fffff
#define SH_LB_ERROR_DETAIL_1_INIT                0x0000000000000000

/*   SH_LB_ERROR_DETAIL_1_COMMAND                                       */
/*   Description:  COMMAND                                              */
#define SH_LB_ERROR_DETAIL_1_COMMAND_SHFT        0
#define SH_LB_ERROR_DETAIL_1_COMMAND_MASK        0x00000000000000ff

/*   SH_LB_ERROR_DETAIL_1_SUPPL                                         */
/*   Description:  SUPPLMENTAL                                          */
#define SH_LB_ERROR_DETAIL_1_SUPPL_SHFT          8
#define SH_LB_ERROR_DETAIL_1_SUPPL_MASK          0x00000000003fff00

/*   SH_LB_ERROR_DETAIL_1_SOURCE                                        */
/*   Description:  SOURCE                                               */
#define SH_LB_ERROR_DETAIL_1_SOURCE_SHFT         24
#define SH_LB_ERROR_DETAIL_1_SOURCE_MASK         0x0000003fff000000

/*   SH_LB_ERROR_DETAIL_1_DEST                                          */
/*   Description:  DEST                                                 */
#define SH_LB_ERROR_DETAIL_1_DEST_SHFT           40
#define SH_LB_ERROR_DETAIL_1_DEST_MASK           0x0000070000000000

/*   SH_LB_ERROR_DETAIL_1_HDR_ERR                                       */
/*   Description:  HDR_ERR                                              */
#define SH_LB_ERROR_DETAIL_1_HDR_ERR_SHFT        48
#define SH_LB_ERROR_DETAIL_1_HDR_ERR_MASK        0x0001000000000000

/*   SH_LB_ERROR_DETAIL_1_DATA_ERR                                      */
/*   Description:  DATA_ERR                                             */
#define SH_LB_ERROR_DETAIL_1_DATA_ERR_SHFT       49
#define SH_LB_ERROR_DETAIL_1_DATA_ERR_MASK       0x0002000000000000

/*   SH_LB_ERROR_DETAIL_1_VALID                                         */
/*   Description:  VALID                                                */
#define SH_LB_ERROR_DETAIL_1_VALID_SHFT          63
#define SH_LB_ERROR_DETAIL_1_VALID_MASK          0x8000000000000000

/* ==================================================================== */
/*                   Register "SH_LB_ERROR_DETAIL_2"                    */
/*                            LB Error Bits                             */
/* ==================================================================== */

#define SH_LB_ERROR_DETAIL_2                     0x0000000110050280
#define SH_LB_ERROR_DETAIL_2_MASK                0x00007fffffffffff
#define SH_LB_ERROR_DETAIL_2_INIT                0x0000000000000000

/*   SH_LB_ERROR_DETAIL_2_ADDRESS                                       */
/*   Description:  ADDRESS                                              */
#define SH_LB_ERROR_DETAIL_2_ADDRESS_SHFT        0
#define SH_LB_ERROR_DETAIL_2_ADDRESS_MASK        0x00007fffffffffff

/* ==================================================================== */
/*                   Register "SH_LB_ERROR_DETAIL_3"                    */
/*                            LB Error Bits                             */
/* ==================================================================== */

#define SH_LB_ERROR_DETAIL_3                     0x0000000110050300
#define SH_LB_ERROR_DETAIL_3_MASK                0xffffffffffffffff
#define SH_LB_ERROR_DETAIL_3_INIT                0x0000000000000000

/*   SH_LB_ERROR_DETAIL_3_DATA                                          */
/*   Description:  DATA                                                 */
#define SH_LB_ERROR_DETAIL_3_DATA_SHFT           0
#define SH_LB_ERROR_DETAIL_3_DATA_MASK           0xffffffffffffffff

/* ==================================================================== */
/*                   Register "SH_LB_ERROR_DETAIL_4"                    */
/*                            LB Error Bits                             */
/* ==================================================================== */

#define SH_LB_ERROR_DETAIL_4                     0x0000000110050380
#define SH_LB_ERROR_DETAIL_4_MASK                0xffffffffffffffff
#define SH_LB_ERROR_DETAIL_4_INIT                0x0000000000000000

/*   SH_LB_ERROR_DETAIL_4_ROUTE                                         */
/*   Description:  ROUTE                                                */
#define SH_LB_ERROR_DETAIL_4_ROUTE_SHFT          0
#define SH_LB_ERROR_DETAIL_4_ROUTE_MASK          0xffffffffffffffff

/* ==================================================================== */
/*                   Register "SH_LB_ERROR_DETAIL_5"                    */
/*                            LB Error Bits                             */
/* ==================================================================== */

#define SH_LB_ERROR_DETAIL_5                     0x0000000110050400
#define SH_LB_ERROR_DETAIL_5_MASK                0x000000000000007f
#define SH_LB_ERROR_DETAIL_5_INIT                0x0000000000000000

/*   SH_LB_ERROR_DETAIL_5_READ_RETRY                                    */
/*   Description:  Read retry error                                     */
#define SH_LB_ERROR_DETAIL_5_READ_RETRY_SHFT     0
#define SH_LB_ERROR_DETAIL_5_READ_RETRY_MASK     0x0000000000000001

/*   SH_LB_ERROR_DETAIL_5_PTC1_WRITE                                    */
/*   Description:  PTC1 write error                                     */
#define SH_LB_ERROR_DETAIL_5_PTC1_WRITE_SHFT     1
#define SH_LB_ERROR_DETAIL_5_PTC1_WRITE_MASK     0x0000000000000002

/*   SH_LB_ERROR_DETAIL_5_WRITE_RETRY                                   */
/*   Description:  Write retry error                                    */
#define SH_LB_ERROR_DETAIL_5_WRITE_RETRY_SHFT    2
#define SH_LB_ERROR_DETAIL_5_WRITE_RETRY_MASK    0x0000000000000004

/*   SH_LB_ERROR_DETAIL_5_COUNT_A_OVERFLOW                              */
/*   Description:  Nack A counter overflow error                        */
#define SH_LB_ERROR_DETAIL_5_COUNT_A_OVERFLOW_SHFT 3
#define SH_LB_ERROR_DETAIL_5_COUNT_A_OVERFLOW_MASK 0x0000000000000008

/*   SH_LB_ERROR_DETAIL_5_COUNT_B_OVERFLOW                              */
/*   Description:  Nack B counter overflow error                        */
#define SH_LB_ERROR_DETAIL_5_COUNT_B_OVERFLOW_SHFT 4
#define SH_LB_ERROR_DETAIL_5_COUNT_B_OVERFLOW_MASK 0x0000000000000010

/*   SH_LB_ERROR_DETAIL_5_NACK_A_TIMEOUT                                */
/*   Description:  Nack A counter timeout error                         */
#define SH_LB_ERROR_DETAIL_5_NACK_A_TIMEOUT_SHFT 5
#define SH_LB_ERROR_DETAIL_5_NACK_A_TIMEOUT_MASK 0x0000000000000020

/*   SH_LB_ERROR_DETAIL_5_NACK_B_TIMEOUT                                */
/*   Description:  Nack B counter timeout error                         */
#define SH_LB_ERROR_DETAIL_5_NACK_B_TIMEOUT_SHFT 6
#define SH_LB_ERROR_DETAIL_5_NACK_B_TIMEOUT_MASK 0x0000000000000040

/* ==================================================================== */
/*                     Register "SH_LB_ERROR_MASK"                      */
/*                            LB Error Mask                             */
/* ==================================================================== */

#define SH_LB_ERROR_MASK                         0x0000000110050480
#define SH_LB_ERROR_MASK_MASK                    0x00000000007fffff
#define SH_LB_ERROR_MASK_INIT                    0x00000000007fffff

/*   SH_LB_ERROR_MASK_RQ_BAD_CMD                                        */
/*   Description:  RQ_BAD_CMD                                           */
#define SH_LB_ERROR_MASK_RQ_BAD_CMD_SHFT         0
#define SH_LB_ERROR_MASK_RQ_BAD_CMD_MASK         0x0000000000000001

/*   SH_LB_ERROR_MASK_RP_BAD_CMD                                        */
/*   Description:  RP_BAD_CMD                                           */
#define SH_LB_ERROR_MASK_RP_BAD_CMD_SHFT         1
#define SH_LB_ERROR_MASK_RP_BAD_CMD_MASK         0x0000000000000002

/*   SH_LB_ERROR_MASK_RQ_SHORT                                          */
/*   Description:  RQ_SHORT                                             */
#define SH_LB_ERROR_MASK_RQ_SHORT_SHFT           2
#define SH_LB_ERROR_MASK_RQ_SHORT_MASK           0x0000000000000004

/*   SH_LB_ERROR_MASK_RP_SHORT                                          */
/*   Description:  RP_SHORT                                             */
#define SH_LB_ERROR_MASK_RP_SHORT_SHFT           3
#define SH_LB_ERROR_MASK_RP_SHORT_MASK           0x0000000000000008

/*   SH_LB_ERROR_MASK_RQ_LONG                                           */
/*   Description:  RQ_LONG                                              */
#define SH_LB_ERROR_MASK_RQ_LONG_SHFT            4
#define SH_LB_ERROR_MASK_RQ_LONG_MASK            0x0000000000000010

/*   SH_LB_ERROR_MASK_RP_LONG                                           */
/*   Description:  RP_LONG                                              */
#define SH_LB_ERROR_MASK_RP_LONG_SHFT            5
#define SH_LB_ERROR_MASK_RP_LONG_MASK            0x0000000000000020

/*   SH_LB_ERROR_MASK_RQ_BAD_DATA                                       */
/*   Description:  RQ_BAD_DATA                                          */
#define SH_LB_ERROR_MASK_RQ_BAD_DATA_SHFT        6
#define SH_LB_ERROR_MASK_RQ_BAD_DATA_MASK        0x0000000000000040

/*   SH_LB_ERROR_MASK_RP_BAD_DATA                                       */
/*   Description:  RP_BAD_DATA                                          */
#define SH_LB_ERROR_MASK_RP_BAD_DATA_SHFT        7
#define SH_LB_ERROR_MASK_RP_BAD_DATA_MASK        0x0000000000000080

/*   SH_LB_ERROR_MASK_RQ_BAD_ADDR                                       */
/*   Description:  RQ_BAD_ADDR                                          */
#define SH_LB_ERROR_MASK_RQ_BAD_ADDR_SHFT        8
#define SH_LB_ERROR_MASK_RQ_BAD_ADDR_MASK        0x0000000000000100

/*   SH_LB_ERROR_MASK_RQ_TIME_OUT                                       */
/*   Description:  RQ_TIME_OUT                                          */
#define SH_LB_ERROR_MASK_RQ_TIME_OUT_SHFT        9
#define SH_LB_ERROR_MASK_RQ_TIME_OUT_MASK        0x0000000000000200

/*   SH_LB_ERROR_MASK_LINVV_OVERFLOW                                    */
/*   Description:  LINVV_OVERFLOW                                       */
#define SH_LB_ERROR_MASK_LINVV_OVERFLOW_SHFT     10
#define SH_LB_ERROR_MASK_LINVV_OVERFLOW_MASK     0x0000000000000400

/*   SH_LB_ERROR_MASK_UNEXPECTED_LINV                                   */
/*   Description:  UNEXPECTED_LINV                                      */
#define SH_LB_ERROR_MASK_UNEXPECTED_LINV_SHFT    11
#define SH_LB_ERROR_MASK_UNEXPECTED_LINV_MASK    0x0000000000000800

/*   SH_LB_ERROR_MASK_PTC_1_TIMEOUT                                     */
/*   Description:  PTC_1 Time out                                       */
#define SH_LB_ERROR_MASK_PTC_1_TIMEOUT_SHFT      12
#define SH_LB_ERROR_MASK_PTC_1_TIMEOUT_MASK      0x0000000000001000

/*   SH_LB_ERROR_MASK_JUNK_BUS_ERR                                      */
/*   Description:  Junk Bus error                                       */
#define SH_LB_ERROR_MASK_JUNK_BUS_ERR_SHFT       13
#define SH_LB_ERROR_MASK_JUNK_BUS_ERR_MASK       0x0000000000002000

/*   SH_LB_ERROR_MASK_PIO_CB_ERR                                        */
/*   Description:  PIO Conveyor Belt operation error                    */
#define SH_LB_ERROR_MASK_PIO_CB_ERR_SHFT         14
#define SH_LB_ERROR_MASK_PIO_CB_ERR_MASK         0x0000000000004000

/*   SH_LB_ERROR_MASK_VECTOR_RQ_ROUTE_ERROR                             */
/*   Description:  Vector request Route data was invalid                */
#define SH_LB_ERROR_MASK_VECTOR_RQ_ROUTE_ERROR_SHFT 15
#define SH_LB_ERROR_MASK_VECTOR_RQ_ROUTE_ERROR_MASK 0x0000000000008000

/*   SH_LB_ERROR_MASK_VECTOR_RP_ROUTE_ERROR                             */
/*   Description:  Vector reply Route data was invalid                  */
#define SH_LB_ERROR_MASK_VECTOR_RP_ROUTE_ERROR_SHFT 16
#define SH_LB_ERROR_MASK_VECTOR_RP_ROUTE_ERROR_MASK 0x0000000000010000

/*   SH_LB_ERROR_MASK_GCLK_DROP                                         */
/*   Description:  Gclk drop error                                      */
#define SH_LB_ERROR_MASK_GCLK_DROP_SHFT          17
#define SH_LB_ERROR_MASK_GCLK_DROP_MASK          0x0000000000020000

/*   SH_LB_ERROR_MASK_RQ_FIFO_ERROR                                     */
/*   Description:  Request queue FIFO error                             */
#define SH_LB_ERROR_MASK_RQ_FIFO_ERROR_SHFT      18
#define SH_LB_ERROR_MASK_RQ_FIFO_ERROR_MASK      0x0000000000040000

/*   SH_LB_ERROR_MASK_RP_FIFO_ERROR                                     */
/*   Description:  Reply queue FIFO error                               */
#define SH_LB_ERROR_MASK_RP_FIFO_ERROR_SHFT      19
#define SH_LB_ERROR_MASK_RP_FIFO_ERROR_MASK      0x0000000000080000

/*   SH_LB_ERROR_MASK_UNEXP_VALID                                       */
/*   Description:  Unexpected valid error                               */
#define SH_LB_ERROR_MASK_UNEXP_VALID_SHFT        20
#define SH_LB_ERROR_MASK_UNEXP_VALID_MASK        0x0000000000100000

/*   SH_LB_ERROR_MASK_RQ_CREDIT_OVERFLOW                                */
/*   Description:  Request queue credit overflow                        */
#define SH_LB_ERROR_MASK_RQ_CREDIT_OVERFLOW_SHFT 21
#define SH_LB_ERROR_MASK_RQ_CREDIT_OVERFLOW_MASK 0x0000000000200000

/*   SH_LB_ERROR_MASK_RP_CREDIT_OVERFLOW                                */
/*   Description:  Reply queue credit overflow                          */
#define SH_LB_ERROR_MASK_RP_CREDIT_OVERFLOW_SHFT 22
#define SH_LB_ERROR_MASK_RP_CREDIT_OVERFLOW_MASK 0x0000000000400000

/* ==================================================================== */
/*                   Register "SH_LB_ERROR_OVERFLOW"                    */
/*                          LB Error Overflow                           */
/* ==================================================================== */

#define SH_LB_ERROR_OVERFLOW                     0x0000000110050500
#define SH_LB_ERROR_OVERFLOW_MASK                0x00000000007fffff
#define SH_LB_ERROR_OVERFLOW_INIT                0x0000000000000000

/*   SH_LB_ERROR_OVERFLOW_RQ_BAD_CMD_OVRFL                              */
/*   Description:  RQ_BAD_CMD_OVRFL                                     */
#define SH_LB_ERROR_OVERFLOW_RQ_BAD_CMD_OVRFL_SHFT 0
#define SH_LB_ERROR_OVERFLOW_RQ_BAD_CMD_OVRFL_MASK 0x0000000000000001

/*   SH_LB_ERROR_OVERFLOW_RP_BAD_CMD_OVRFL                              */
/*   Description:  RP_BAD_CMD_OVRFL                                     */
#define SH_LB_ERROR_OVERFLOW_RP_BAD_CMD_OVRFL_SHFT 1
#define SH_LB_ERROR_OVERFLOW_RP_BAD_CMD_OVRFL_MASK 0x0000000000000002

/*   SH_LB_ERROR_OVERFLOW_RQ_SHORT_OVRFL                                */
/*   Description:  RQ_SHORT_OVRFL                                       */
#define SH_LB_ERROR_OVERFLOW_RQ_SHORT_OVRFL_SHFT 2
#define SH_LB_ERROR_OVERFLOW_RQ_SHORT_OVRFL_MASK 0x0000000000000004

/*   SH_LB_ERROR_OVERFLOW_RP_SHORT_OVRFL                                */
/*   Description:  RP_SHORT_OVRFL                                       */
#define SH_LB_ERROR_OVERFLOW_RP_SHORT_OVRFL_SHFT 3
#define SH_LB_ERROR_OVERFLOW_RP_SHORT_OVRFL_MASK 0x0000000000000008

/*   SH_LB_ERROR_OVERFLOW_RQ_LONG_OVRFL                                 */
/*   Description:  RQ_LONG_OVRFL                                        */
#define SH_LB_ERROR_OVERFLOW_RQ_LONG_OVRFL_SHFT  4
#define SH_LB_ERROR_OVERFLOW_RQ_LONG_OVRFL_MASK  0x0000000000000010

/*   SH_LB_ERROR_OVERFLOW_RP_LONG_OVRFL                                 */
/*   Description:  RP_LONG_OVRFL                                        */
#define SH_LB_ERROR_OVERFLOW_RP_LONG_OVRFL_SHFT  5
#define SH_LB_ERROR_OVERFLOW_RP_LONG_OVRFL_MASK  0x0000000000000020

/*   SH_LB_ERROR_OVERFLOW_RQ_BAD_DATA_OVRFL                             */
/*   Description:  RQ_BAD_DATA_OVRFL                                    */
#define SH_LB_ERROR_OVERFLOW_RQ_BAD_DATA_OVRFL_SHFT 6
#define SH_LB_ERROR_OVERFLOW_RQ_BAD_DATA_OVRFL_MASK 0x0000000000000040

/*   SH_LB_ERROR_OVERFLOW_RP_BAD_DATA_OVRFL                             */
/*   Description:  RP_BAD_DATA_OVRFL                                    */
#define SH_LB_ERROR_OVERFLOW_RP_BAD_DATA_OVRFL_SHFT 7
#define SH_LB_ERROR_OVERFLOW_RP_BAD_DATA_OVRFL_MASK 0x0000000000000080

/*   SH_LB_ERROR_OVERFLOW_RQ_BAD_ADDR_OVRFL                             */
/*   Description:  RQ_BAD_ADDR_OVRFL                                    */
#define SH_LB_ERROR_OVERFLOW_RQ_BAD_ADDR_OVRFL_SHFT 8
#define SH_LB_ERROR_OVERFLOW_RQ_BAD_ADDR_OVRFL_MASK 0x0000000000000100

/*   SH_LB_ERROR_OVERFLOW_RQ_TIME_OUT_OVRFL                             */
/*   Description:  RQ_TIME_OUT_OVRFL                                    */
#define SH_LB_ERROR_OVERFLOW_RQ_TIME_OUT_OVRFL_SHFT 9
#define SH_LB_ERROR_OVERFLOW_RQ_TIME_OUT_OVRFL_MASK 0x0000000000000200

/*   SH_LB_ERROR_OVERFLOW_LINVV_OVERFLOW_OVRFL                          */
/*   Description:  LINVV_OVERFLOW_OVRFL                                 */
#define SH_LB_ERROR_OVERFLOW_LINVV_OVERFLOW_OVRFL_SHFT 10
#define SH_LB_ERROR_OVERFLOW_LINVV_OVERFLOW_OVRFL_MASK 0x0000000000000400

/*   SH_LB_ERROR_OVERFLOW_UNEXPECTED_LINV_OVRFL                         */
/*   Description:  UNEXPECTED_LINV_OVRFL                                */
#define SH_LB_ERROR_OVERFLOW_UNEXPECTED_LINV_OVRFL_SHFT 11
#define SH_LB_ERROR_OVERFLOW_UNEXPECTED_LINV_OVRFL_MASK 0x0000000000000800

/*   SH_LB_ERROR_OVERFLOW_PTC_1_TIMEOUT_OVRFL                           */
/*   Description:  PTC_1 Time out overflow                              */
#define SH_LB_ERROR_OVERFLOW_PTC_1_TIMEOUT_OVRFL_SHFT 12
#define SH_LB_ERROR_OVERFLOW_PTC_1_TIMEOUT_OVRFL_MASK 0x0000000000001000

/*   SH_LB_ERROR_OVERFLOW_JUNK_BUS_ERR_OVRFL                            */
/*   Description:  Junk Bus error overflow                              */
#define SH_LB_ERROR_OVERFLOW_JUNK_BUS_ERR_OVRFL_SHFT 13
#define SH_LB_ERROR_OVERFLOW_JUNK_BUS_ERR_OVRFL_MASK 0x0000000000002000

/*   SH_LB_ERROR_OVERFLOW_PIO_CB_ERR_OVRFL                              */
/*   Description:  PIO Conveyor Belt operation error overflow           */
#define SH_LB_ERROR_OVERFLOW_PIO_CB_ERR_OVRFL_SHFT 14
#define SH_LB_ERROR_OVERFLOW_PIO_CB_ERR_OVRFL_MASK 0x0000000000004000

/*   SH_LB_ERROR_OVERFLOW_VECTOR_RQ_ROUTE_ERROR_OVRFL                   */
/*   Description:  Vector request Route data was invalid overflow       */
#define SH_LB_ERROR_OVERFLOW_VECTOR_RQ_ROUTE_ERROR_OVRFL_SHFT 15
#define SH_LB_ERROR_OVERFLOW_VECTOR_RQ_ROUTE_ERROR_OVRFL_MASK 0x0000000000008000

/*   SH_LB_ERROR_OVERFLOW_VECTOR_RP_ROUTE_ERROR_OVRFL                   */
/*   Description:  Vector reply Route data was invalid overflow         */
#define SH_LB_ERROR_OVERFLOW_VECTOR_RP_ROUTE_ERROR_OVRFL_SHFT 16
#define SH_LB_ERROR_OVERFLOW_VECTOR_RP_ROUTE_ERROR_OVRFL_MASK 0x0000000000010000

/*   SH_LB_ERROR_OVERFLOW_GCLK_DROP_OVRFL                               */
/*   Description:  Gclk drop error overflow                             */
#define SH_LB_ERROR_OVERFLOW_GCLK_DROP_OVRFL_SHFT 17
#define SH_LB_ERROR_OVERFLOW_GCLK_DROP_OVRFL_MASK 0x0000000000020000

/*   SH_LB_ERROR_OVERFLOW_RQ_FIFO_ERROR_OVRFL                           */
/*   Description:  Request queue FIFO error overflow                    */
#define SH_LB_ERROR_OVERFLOW_RQ_FIFO_ERROR_OVRFL_SHFT 18
#define SH_LB_ERROR_OVERFLOW_RQ_FIFO_ERROR_OVRFL_MASK 0x0000000000040000

/*   SH_LB_ERROR_OVERFLOW_RP_FIFO_ERROR_OVRFL                           */
/*   Description:  Reply queue FIFO error overflow                      */
#define SH_LB_ERROR_OVERFLOW_RP_FIFO_ERROR_OVRFL_SHFT 19
#define SH_LB_ERROR_OVERFLOW_RP_FIFO_ERROR_OVRFL_MASK 0x0000000000080000

/*   SH_LB_ERROR_OVERFLOW_UNEXP_VALID_OVRFL                             */
/*   Description:  Unexpected valid error overflow                      */
#define SH_LB_ERROR_OVERFLOW_UNEXP_VALID_OVRFL_SHFT 20
#define SH_LB_ERROR_OVERFLOW_UNEXP_VALID_OVRFL_MASK 0x0000000000100000

/*   SH_LB_ERROR_OVERFLOW_RQ_CREDIT_OVERFLOW_OVRFL                      */
/*   Description:  Request queue credit overflow                        */
#define SH_LB_ERROR_OVERFLOW_RQ_CREDIT_OVERFLOW_OVRFL_SHFT 21
#define SH_LB_ERROR_OVERFLOW_RQ_CREDIT_OVERFLOW_OVRFL_MASK 0x0000000000200000

/*   SH_LB_ERROR_OVERFLOW_RP_CREDIT_OVERFLOW_OVRFL                      */
/*   Description:  Reply queue credit overflow                          */
#define SH_LB_ERROR_OVERFLOW_RP_CREDIT_OVERFLOW_OVRFL_SHFT 22
#define SH_LB_ERROR_OVERFLOW_RP_CREDIT_OVERFLOW_OVRFL_MASK 0x0000000000400000

/* ==================================================================== */
/*                Register "SH_LB_ERROR_OVERFLOW_ALIAS"                 */
/*                          LB Error Overflow                           */
/* ==================================================================== */

#define SH_LB_ERROR_OVERFLOW_ALIAS               0x0000000110050508

/* ==================================================================== */
/*                    Register "SH_LB_ERROR_SUMMARY"                    */
/*                            LB Error Bits                             */
/* ==================================================================== */

#define SH_LB_ERROR_SUMMARY                      0x0000000110050580
#define SH_LB_ERROR_SUMMARY_MASK                 0x00000000007fffff
#define SH_LB_ERROR_SUMMARY_INIT                 0x0000000000000000

/*   SH_LB_ERROR_SUMMARY_RQ_BAD_CMD                                     */
/*   Description:  RQ_BAD_CMD                                           */
#define SH_LB_ERROR_SUMMARY_RQ_BAD_CMD_SHFT      0
#define SH_LB_ERROR_SUMMARY_RQ_BAD_CMD_MASK      0x0000000000000001

/*   SH_LB_ERROR_SUMMARY_RP_BAD_CMD                                     */
/*   Description:  RP_BAD_CMD                                           */
#define SH_LB_ERROR_SUMMARY_RP_BAD_CMD_SHFT      1
#define SH_LB_ERROR_SUMMARY_RP_BAD_CMD_MASK      0x0000000000000002

/*   SH_LB_ERROR_SUMMARY_RQ_SHORT                                       */
/*   Description:  RQ_SHORT                                             */
#define SH_LB_ERROR_SUMMARY_RQ_SHORT_SHFT        2
#define SH_LB_ERROR_SUMMARY_RQ_SHORT_MASK        0x0000000000000004

/*   SH_LB_ERROR_SUMMARY_RP_SHORT                                       */
/*   Description:  RP_SHORT                                             */
#define SH_LB_ERROR_SUMMARY_RP_SHORT_SHFT        3
#define SH_LB_ERROR_SUMMARY_RP_SHORT_MASK        0x0000000000000008

/*   SH_LB_ERROR_SUMMARY_RQ_LONG                                        */
/*   Description:  RQ_LONG                                              */
#define SH_LB_ERROR_SUMMARY_RQ_LONG_SHFT         4
#define SH_LB_ERROR_SUMMARY_RQ_LONG_MASK         0x0000000000000010

/*   SH_LB_ERROR_SUMMARY_RP_LONG                                        */
/*   Description:  RP_LONG                                              */
#define SH_LB_ERROR_SUMMARY_RP_LONG_SHFT         5
#define SH_LB_ERROR_SUMMARY_RP_LONG_MASK         0x0000000000000020

/*   SH_LB_ERROR_SUMMARY_RQ_BAD_DATA                                    */
/*   Description:  RQ_BAD_DATA                                          */
#define SH_LB_ERROR_SUMMARY_RQ_BAD_DATA_SHFT     6
#define SH_LB_ERROR_SUMMARY_RQ_BAD_DATA_MASK     0x0000000000000040

/*   SH_LB_ERROR_SUMMARY_RP_BAD_DATA                                    */
/*   Description:  RP_BAD_DATA                                          */
#define SH_LB_ERROR_SUMMARY_RP_BAD_DATA_SHFT     7
#define SH_LB_ERROR_SUMMARY_RP_BAD_DATA_MASK     0x0000000000000080

/*   SH_LB_ERROR_SUMMARY_RQ_BAD_ADDR                                    */
/*   Description:  RQ_BAD_ADDR                                          */
#define SH_LB_ERROR_SUMMARY_RQ_BAD_ADDR_SHFT     8
#define SH_LB_ERROR_SUMMARY_RQ_BAD_ADDR_MASK     0x0000000000000100

/*   SH_LB_ERROR_SUMMARY_RQ_TIME_OUT                                    */
/*   Description:  RQ_TIME_OUT                                          */
#define SH_LB_ERROR_SUMMARY_RQ_TIME_OUT_SHFT     9
#define SH_LB_ERROR_SUMMARY_RQ_TIME_OUT_MASK     0x0000000000000200

/*   SH_LB_ERROR_SUMMARY_LINVV_OVERFLOW                                 */
/*   Description:  LINVV_OVERFLOW                                       */
#define SH_LB_ERROR_SUMMARY_LINVV_OVERFLOW_SHFT  10
#define SH_LB_ERROR_SUMMARY_LINVV_OVERFLOW_MASK  0x0000000000000400

/*   SH_LB_ERROR_SUMMARY_UNEXPECTED_LINV                                */
/*   Description:  UNEXPECTED_LINV                                      */
#define SH_LB_ERROR_SUMMARY_UNEXPECTED_LINV_SHFT 11
#define SH_LB_ERROR_SUMMARY_UNEXPECTED_LINV_MASK 0x0000000000000800

/*   SH_LB_ERROR_SUMMARY_PTC_1_TIMEOUT                                  */
/*   Description:  PTC_1 Time out                                       */
#define SH_LB_ERROR_SUMMARY_PTC_1_TIMEOUT_SHFT   12
#define SH_LB_ERROR_SUMMARY_PTC_1_TIMEOUT_MASK   0x0000000000001000

/*   SH_LB_ERROR_SUMMARY_JUNK_BUS_ERR                                   */
/*   Description:  Junk Bus error                                       */
#define SH_LB_ERROR_SUMMARY_JUNK_BUS_ERR_SHFT    13
#define SH_LB_ERROR_SUMMARY_JUNK_BUS_ERR_MASK    0x0000000000002000

/*   SH_LB_ERROR_SUMMARY_PIO_CB_ERR                                     */
/*   Description:  PIO Conveyor Belt operation error                    */
#define SH_LB_ERROR_SUMMARY_PIO_CB_ERR_SHFT      14
#define SH_LB_ERROR_SUMMARY_PIO_CB_ERR_MASK      0x0000000000004000

/*   SH_LB_ERROR_SUMMARY_VECTOR_RQ_ROUTE_ERROR                          */
/*   Description:  Vector request Route data was invalid                */
#define SH_LB_ERROR_SUMMARY_VECTOR_RQ_ROUTE_ERROR_SHFT 15
#define SH_LB_ERROR_SUMMARY_VECTOR_RQ_ROUTE_ERROR_MASK 0x0000000000008000

/*   SH_LB_ERROR_SUMMARY_VECTOR_RP_ROUTE_ERROR                          */
/*   Description:  Vector reply Route data was invalid                  */
#define SH_LB_ERROR_SUMMARY_VECTOR_RP_ROUTE_ERROR_SHFT 16
#define SH_LB_ERROR_SUMMARY_VECTOR_RP_ROUTE_ERROR_MASK 0x0000000000010000

/*   SH_LB_ERROR_SUMMARY_GCLK_DROP                                      */
/*   Description:  Gclk drop error                                      */
#define SH_LB_ERROR_SUMMARY_GCLK_DROP_SHFT       17
#define SH_LB_ERROR_SUMMARY_GCLK_DROP_MASK       0x0000000000020000

/*   SH_LB_ERROR_SUMMARY_RQ_FIFO_ERROR                                  */
/*   Description:  Request queue FIFO error                             */
#define SH_LB_ERROR_SUMMARY_RQ_FIFO_ERROR_SHFT   18
#define SH_LB_ERROR_SUMMARY_RQ_FIFO_ERROR_MASK   0x0000000000040000

/*   SH_LB_ERROR_SUMMARY_RP_FIFO_ERROR                                  */
/*   Description:  Reply queue FIFO error                               */
#define SH_LB_ERROR_SUMMARY_RP_FIFO_ERROR_SHFT   19
#define SH_LB_ERROR_SUMMARY_RP_FIFO_ERROR_MASK   0x0000000000080000

/*   SH_LB_ERROR_SUMMARY_UNEXP_VALID                                    */
/*   Description:  Unexpected valid error                               */
#define SH_LB_ERROR_SUMMARY_UNEXP_VALID_SHFT     20
#define SH_LB_ERROR_SUMMARY_UNEXP_VALID_MASK     0x0000000000100000

/*   SH_LB_ERROR_SUMMARY_RQ_CREDIT_OVERFLOW                             */
/*   Description:  Request queue credit overflow                        */
#define SH_LB_ERROR_SUMMARY_RQ_CREDIT_OVERFLOW_SHFT 21
#define SH_LB_ERROR_SUMMARY_RQ_CREDIT_OVERFLOW_MASK 0x0000000000200000

/*   SH_LB_ERROR_SUMMARY_RP_CREDIT_OVERFLOW                             */
/*   Description:  Reply queue credit overflow                          */
#define SH_LB_ERROR_SUMMARY_RP_CREDIT_OVERFLOW_SHFT 22
#define SH_LB_ERROR_SUMMARY_RP_CREDIT_OVERFLOW_MASK 0x0000000000400000

/* ==================================================================== */
/*                 Register "SH_LB_ERROR_SUMMARY_ALIAS"                 */
/*                         LB Error Bits Alias                          */
/* ==================================================================== */

#define SH_LB_ERROR_SUMMARY_ALIAS                0x0000000110050588

/* ==================================================================== */
/*                     Register "SH_LB_FIRST_ERROR"                     */
/*                            LB First Error                            */
/* ==================================================================== */

#define SH_LB_FIRST_ERROR                        0x0000000110050600
#define SH_LB_FIRST_ERROR_MASK                   0x00000000007fffff
#define SH_LB_FIRST_ERROR_INIT                   0x0000000000000000

/*   SH_LB_FIRST_ERROR_RQ_BAD_CMD                                       */
/*   Description:  RQ_BAD_CMD                                           */
#define SH_LB_FIRST_ERROR_RQ_BAD_CMD_SHFT        0
#define SH_LB_FIRST_ERROR_RQ_BAD_CMD_MASK        0x0000000000000001

/*   SH_LB_FIRST_ERROR_RP_BAD_CMD                                       */
/*   Description:  RP_BAD_CMD                                           */
#define SH_LB_FIRST_ERROR_RP_BAD_CMD_SHFT        1
#define SH_LB_FIRST_ERROR_RP_BAD_CMD_MASK        0x0000000000000002

/*   SH_LB_FIRST_ERROR_RQ_SHORT                                         */
/*   Description:  RQ_SHORT                                             */
#define SH_LB_FIRST_ERROR_RQ_SHORT_SHFT          2
#define SH_LB_FIRST_ERROR_RQ_SHORT_MASK          0x0000000000000004

/*   SH_LB_FIRST_ERROR_RP_SHORT                                         */
/*   Description:  RP_SHORT                                             */
#define SH_LB_FIRST_ERROR_RP_SHORT_SHFT          3
#define SH_LB_FIRST_ERROR_RP_SHORT_MASK          0x0000000000000008

/*   SH_LB_FIRST_ERROR_RQ_LONG                                          */
/*   Description:  RQ_LONG                                              */
#define SH_LB_FIRST_ERROR_RQ_LONG_SHFT           4
#define SH_LB_FIRST_ERROR_RQ_LONG_MASK           0x0000000000000010

/*   SH_LB_FIRST_ERROR_RP_LONG                                          */
/*   Description:  RP_LONG                                              */
#define SH_LB_FIRST_ERROR_RP_LONG_SHFT           5
#define SH_LB_FIRST_ERROR_RP_LONG_MASK           0x0000000000000020

/*   SH_LB_FIRST_ERROR_RQ_BAD_DATA                                      */
/*   Description:  RQ_BAD_DATA                                          */
#define SH_LB_FIRST_ERROR_RQ_BAD_DATA_SHFT       6
#define SH_LB_FIRST_ERROR_RQ_BAD_DATA_MASK       0x0000000000000040

/*   SH_LB_FIRST_ERROR_RP_BAD_DATA                                      */
/*   Description:  RP_BAD_DATA                                          */
#define SH_LB_FIRST_ERROR_RP_BAD_DATA_SHFT       7
#define SH_LB_FIRST_ERROR_RP_BAD_DATA_MASK       0x0000000000000080

/*   SH_LB_FIRST_ERROR_RQ_BAD_ADDR                                      */
/*   Description:  RQ_BAD_ADDR                                          */
#define SH_LB_FIRST_ERROR_RQ_BAD_ADDR_SHFT       8
#define SH_LB_FIRST_ERROR_RQ_BAD_ADDR_MASK       0x0000000000000100

/*   SH_LB_FIRST_ERROR_RQ_TIME_OUT                                      */
/*   Description:  RQ_TIME_OUT                                          */
#define SH_LB_FIRST_ERROR_RQ_TIME_OUT_SHFT       9
#define SH_LB_FIRST_ERROR_RQ_TIME_OUT_MASK       0x0000000000000200

/*   SH_LB_FIRST_ERROR_LINVV_OVERFLOW                                   */
/*   Description:  LINVV_OVERFLOW                                       */
#define SH_LB_FIRST_ERROR_LINVV_OVERFLOW_SHFT    10
#define SH_LB_FIRST_ERROR_LINVV_OVERFLOW_MASK    0x0000000000000400

/*   SH_LB_FIRST_ERROR_UNEXPECTED_LINV                                  */
/*   Description:  UNEXPECTED_LINV                                      */
#define SH_LB_FIRST_ERROR_UNEXPECTED_LINV_SHFT   11
#define SH_LB_FIRST_ERROR_UNEXPECTED_LINV_MASK   0x0000000000000800

/*   SH_LB_FIRST_ERROR_PTC_1_TIMEOUT                                    */
/*   Description:  PTC_1 Time out                                       */
#define SH_LB_FIRST_ERROR_PTC_1_TIMEOUT_SHFT     12
#define SH_LB_FIRST_ERROR_PTC_1_TIMEOUT_MASK     0x0000000000001000

/*   SH_LB_FIRST_ERROR_JUNK_BUS_ERR                                     */
/*   Description:  Junk Bus error                                       */
#define SH_LB_FIRST_ERROR_JUNK_BUS_ERR_SHFT      13
#define SH_LB_FIRST_ERROR_JUNK_BUS_ERR_MASK      0x0000000000002000

/*   SH_LB_FIRST_ERROR_PIO_CB_ERR                                       */
/*   Description:  PIO Conveyor Belt operation error                    */
#define SH_LB_FIRST_ERROR_PIO_CB_ERR_SHFT        14
#define SH_LB_FIRST_ERROR_PIO_CB_ERR_MASK        0x0000000000004000

/*   SH_LB_FIRST_ERROR_VECTOR_RQ_ROUTE_ERROR                            */
/*   Description:  Vector request Route data was invalid                */
#define SH_LB_FIRST_ERROR_VECTOR_RQ_ROUTE_ERROR_SHFT 15
#define SH_LB_FIRST_ERROR_VECTOR_RQ_ROUTE_ERROR_MASK 0x0000000000008000

/*   SH_LB_FIRST_ERROR_VECTOR_RP_ROUTE_ERROR                            */
/*   Description:  Vector reply Route data was invalid                  */
#define SH_LB_FIRST_ERROR_VECTOR_RP_ROUTE_ERROR_SHFT 16
#define SH_LB_FIRST_ERROR_VECTOR_RP_ROUTE_ERROR_MASK 0x0000000000010000

/*   SH_LB_FIRST_ERROR_GCLK_DROP                                        */
/*   Description:  Gclk drop error                                      */
#define SH_LB_FIRST_ERROR_GCLK_DROP_SHFT         17
#define SH_LB_FIRST_ERROR_GCLK_DROP_MASK         0x0000000000020000

/*   SH_LB_FIRST_ERROR_RQ_FIFO_ERROR                                    */
/*   Description:  Request queue FIFO error                             */
#define SH_LB_FIRST_ERROR_RQ_FIFO_ERROR_SHFT     18
#define SH_LB_FIRST_ERROR_RQ_FIFO_ERROR_MASK     0x0000000000040000

/*   SH_LB_FIRST_ERROR_RP_FIFO_ERROR                                    */
/*   Description:  Reply queue FIFO error                               */
#define SH_LB_FIRST_ERROR_RP_FIFO_ERROR_SHFT     19
#define SH_LB_FIRST_ERROR_RP_FIFO_ERROR_MASK     0x0000000000080000

/*   SH_LB_FIRST_ERROR_UNEXP_VALID                                      */
/*   Description:  Unexpected valid error                               */
#define SH_LB_FIRST_ERROR_UNEXP_VALID_SHFT       20
#define SH_LB_FIRST_ERROR_UNEXP_VALID_MASK       0x0000000000100000

/*   SH_LB_FIRST_ERROR_RQ_CREDIT_OVERFLOW                               */
/*   Description:  Request queue credit overflow                        */
#define SH_LB_FIRST_ERROR_RQ_CREDIT_OVERFLOW_SHFT 21
#define SH_LB_FIRST_ERROR_RQ_CREDIT_OVERFLOW_MASK 0x0000000000200000

/*   SH_LB_FIRST_ERROR_RP_CREDIT_OVERFLOW                               */
/*   Description:  Reply queue credit overflow                          */
#define SH_LB_FIRST_ERROR_RP_CREDIT_OVERFLOW_SHFT 22
#define SH_LB_FIRST_ERROR_RP_CREDIT_OVERFLOW_MASK 0x0000000000400000

/* ==================================================================== */
/*                     Register "SH_LB_LAST_CREDIT"                     */
/*                    Credit counter status register                    */
/* ==================================================================== */

#define SH_LB_LAST_CREDIT                        0x0000000110050680
#define SH_LB_LAST_CREDIT_MASK                   0x000000000ffff3df
#define SH_LB_LAST_CREDIT_INIT                   0x0000000000000000

/*   SH_LB_LAST_CREDIT_LIQ_RQ_CREDIT                                    */
/*   Description:  LIQ request queue credit counter                     */
#define SH_LB_LAST_CREDIT_LIQ_RQ_CREDIT_SHFT     0
#define SH_LB_LAST_CREDIT_LIQ_RQ_CREDIT_MASK     0x000000000000001f

/*   SH_LB_LAST_CREDIT_LIQ_RP_CREDIT                                    */
/*   Description:  LIQ reply queue credit counter                       */
#define SH_LB_LAST_CREDIT_LIQ_RP_CREDIT_SHFT     6
#define SH_LB_LAST_CREDIT_LIQ_RP_CREDIT_MASK     0x00000000000003c0

/*   SH_LB_LAST_CREDIT_LINVV_CREDIT                                     */
/*   Description:  LINVV credit counter                                 */
#define SH_LB_LAST_CREDIT_LINVV_CREDIT_SHFT      12
#define SH_LB_LAST_CREDIT_LINVV_CREDIT_MASK      0x000000000003f000

/*   SH_LB_LAST_CREDIT_LOQ_RQ_CREDIT                                    */
/*   Description:  LOQ request queue credit counter                     */
#define SH_LB_LAST_CREDIT_LOQ_RQ_CREDIT_SHFT     18
#define SH_LB_LAST_CREDIT_LOQ_RQ_CREDIT_MASK     0x00000000007c0000

/*   SH_LB_LAST_CREDIT_LOQ_RP_CREDIT                                    */
/*   Description:  LOQ reply queue credit counter                       */
#define SH_LB_LAST_CREDIT_LOQ_RP_CREDIT_SHFT     23
#define SH_LB_LAST_CREDIT_LOQ_RP_CREDIT_MASK     0x000000000f800000

/* ==================================================================== */
/*                     Register "SH_LB_NACK_STATUS"                     */
/*                     Nack Counter Status Register                     */
/* ==================================================================== */

#define SH_LB_NACK_STATUS                        0x0000000110050700
#define SH_LB_NACK_STATUS_MASK                   0x3fffffff0fff0fff
#define SH_LB_NACK_STATUS_INIT                   0x0000000000000000

/*   SH_LB_NACK_STATUS_PIO_NACK_A                                       */
/*   Description:  PIO nackA counter                                    */
#define SH_LB_NACK_STATUS_PIO_NACK_A_SHFT        0
#define SH_LB_NACK_STATUS_PIO_NACK_A_MASK        0x0000000000000fff

/*   SH_LB_NACK_STATUS_PIO_NACK_B                                       */
/*   Description:  PIO nackA counter                                    */
#define SH_LB_NACK_STATUS_PIO_NACK_B_SHFT        16
#define SH_LB_NACK_STATUS_PIO_NACK_B_MASK        0x000000000fff0000

/*   SH_LB_NACK_STATUS_JUNK_NACK                                        */
/*   Description:  Junk bus nack counter                                */
#define SH_LB_NACK_STATUS_JUNK_NACK_SHFT         32
#define SH_LB_NACK_STATUS_JUNK_NACK_MASK         0x0000ffff00000000

/*   SH_LB_NACK_STATUS_CB_TIMEOUT_COUNT                                 */
/*   Description:  Conveyor belt time out counter                       */
#define SH_LB_NACK_STATUS_CB_TIMEOUT_COUNT_SHFT  48
#define SH_LB_NACK_STATUS_CB_TIMEOUT_COUNT_MASK  0x0fff000000000000

/*   SH_LB_NACK_STATUS_CB_STATE                                         */
/*   Description:  Conveyor belt state                                  */
#define SH_LB_NACK_STATUS_CB_STATE_SHFT          60
#define SH_LB_NACK_STATUS_CB_STATE_MASK          0x3000000000000000

/* ==================================================================== */
/*                   Register "SH_LB_TRIGGER_COMPARE"                   */
/*                    LB Test-point Trigger Compare                     */
/* ==================================================================== */

#define SH_LB_TRIGGER_COMPARE                    0x0000000110050780
#define SH_LB_TRIGGER_COMPARE_MASK               0x00000000ffffffff
#define SH_LB_TRIGGER_COMPARE_INIT               0x0000000000000000

/*   SH_LB_TRIGGER_COMPARE_MASK                                         */
/*   Description:  Mask to select Debug bits for trigger generation     */
#define SH_LB_TRIGGER_COMPARE_MASK_SHFT          0
#define SH_LB_TRIGGER_COMPARE_MASK_MASK          0x00000000ffffffff

/* ==================================================================== */
/*                    Register "SH_LB_TRIGGER_DATA"                     */
/*                  LB Test-point Trigger Compare Data                  */
/* ==================================================================== */

#define SH_LB_TRIGGER_DATA                       0x0000000110050800
#define SH_LB_TRIGGER_DATA_MASK                  0x00000000ffffffff
#define SH_LB_TRIGGER_DATA_INIT                  0x00000000ffffffff

/*   SH_LB_TRIGGER_DATA_COMPARE_PATTERN                                 */
/*   Description:  debug bit pattern for trigger generation             */
#define SH_LB_TRIGGER_DATA_COMPARE_PATTERN_SHFT  0
#define SH_LB_TRIGGER_DATA_COMPARE_PATTERN_MASK  0x00000000ffffffff

/* ==================================================================== */
/*                     Register "SH_PI_AEC_CONFIG"                      */
/*              PI Adaptive Error Correction Configuration              */
/* ==================================================================== */

#define SH_PI_AEC_CONFIG                         0x0000000120050000
#define SH_PI_AEC_CONFIG_MASK                    0x0000000000000007
#define SH_PI_AEC_CONFIG_INIT                    0x0000000000000000

/*   SH_PI_AEC_CONFIG_MODE                                              */
/*   Description:  AEC Operation Mode                                   */
#define SH_PI_AEC_CONFIG_MODE_SHFT               0
#define SH_PI_AEC_CONFIG_MODE_MASK               0x0000000000000007

/* ==================================================================== */
/*                   Register "SH_PI_AFI_ERROR_MASK"                    */
/*                          PI AFI Error Mask                           */
/* ==================================================================== */

#define SH_PI_AFI_ERROR_MASK                     0x0000000120050080
#define SH_PI_AFI_ERROR_MASK_MASK                0x00000007ffe00000
#define SH_PI_AFI_ERROR_MASK_INIT                0x00000007ffe00000

/*   SH_PI_AFI_ERROR_MASK_HUNG_BUS                                      */
/*   Description:  FSB is hung                                          */
#define SH_PI_AFI_ERROR_MASK_HUNG_BUS_SHFT       21
#define SH_PI_AFI_ERROR_MASK_HUNG_BUS_MASK       0x0000000000200000

/*   SH_PI_AFI_ERROR_MASK_RSP_PARITY                                    */
/*   Description:  Parity error detecte during response phase           */
#define SH_PI_AFI_ERROR_MASK_RSP_PARITY_SHFT     22
#define SH_PI_AFI_ERROR_MASK_RSP_PARITY_MASK     0x0000000000400000

/*   SH_PI_AFI_ERROR_MASK_IOQ_OVERRUN                                   */
/*   Description:  Over run error detected on IOQ                       */
#define SH_PI_AFI_ERROR_MASK_IOQ_OVERRUN_SHFT    23
#define SH_PI_AFI_ERROR_MASK_IOQ_OVERRUN_MASK    0x0000000000800000

/*   SH_PI_AFI_ERROR_MASK_REQ_FORMAT                                    */
/*   Description:  FSB request format not supported                     */
#define SH_PI_AFI_ERROR_MASK_REQ_FORMAT_SHFT     24
#define SH_PI_AFI_ERROR_MASK_REQ_FORMAT_MASK     0x0000000001000000

/*   SH_PI_AFI_ERROR_MASK_ADDR_ACCESS                                   */
/*   Description:  Access to Address is not supported                   */
#define SH_PI_AFI_ERROR_MASK_ADDR_ACCESS_SHFT    25
#define SH_PI_AFI_ERROR_MASK_ADDR_ACCESS_MASK    0x0000000002000000

/*   SH_PI_AFI_ERROR_MASK_REQ_PARITY                                    */
/*   Description:  Parity error detected during request phase           */
#define SH_PI_AFI_ERROR_MASK_REQ_PARITY_SHFT     26
#define SH_PI_AFI_ERROR_MASK_REQ_PARITY_MASK     0x0000000004000000

/*   SH_PI_AFI_ERROR_MASK_ADDR_PARITY                                   */
/*   Description:  Parity error detected on address                     */
#define SH_PI_AFI_ERROR_MASK_ADDR_PARITY_SHFT    27
#define SH_PI_AFI_ERROR_MASK_ADDR_PARITY_MASK    0x0000000008000000

/*   SH_PI_AFI_ERROR_MASK_SHUB_FSB_DQE                                  */
/*   Description:  SHUB_FSB_DQE                                         */
#define SH_PI_AFI_ERROR_MASK_SHUB_FSB_DQE_SHFT   28
#define SH_PI_AFI_ERROR_MASK_SHUB_FSB_DQE_MASK   0x0000000010000000

/*   SH_PI_AFI_ERROR_MASK_SHUB_FSB_UCE                                  */
/*   Description:  An un-correctable ECC error was detected             */
#define SH_PI_AFI_ERROR_MASK_SHUB_FSB_UCE_SHFT   29
#define SH_PI_AFI_ERROR_MASK_SHUB_FSB_UCE_MASK   0x0000000020000000

/*   SH_PI_AFI_ERROR_MASK_SHUB_FSB_CE                                   */
/*   Description:  An correctable ECC error was detected                */
#define SH_PI_AFI_ERROR_MASK_SHUB_FSB_CE_SHFT    30
#define SH_PI_AFI_ERROR_MASK_SHUB_FSB_CE_MASK    0x0000000040000000

/*   SH_PI_AFI_ERROR_MASK_LIVELOCK                                      */
/*   Description:  AFI livelock error was detected                      */
#define SH_PI_AFI_ERROR_MASK_LIVELOCK_SHFT       31
#define SH_PI_AFI_ERROR_MASK_LIVELOCK_MASK       0x0000000080000000

/*   SH_PI_AFI_ERROR_MASK_BAD_SNOOP                                     */
/*   Description:  AFI bad snoop error was detected                     */
#define SH_PI_AFI_ERROR_MASK_BAD_SNOOP_SHFT      32
#define SH_PI_AFI_ERROR_MASK_BAD_SNOOP_MASK      0x0000000100000000

/*   SH_PI_AFI_ERROR_MASK_FSB_TBL_MISS                                  */
/*   Description:  AFI FSB request table miss error was detected        */
#define SH_PI_AFI_ERROR_MASK_FSB_TBL_MISS_SHFT   33
#define SH_PI_AFI_ERROR_MASK_FSB_TBL_MISS_MASK   0x0000000200000000

/*   SH_PI_AFI_ERROR_MASK_MSG_LEN                                       */
/*   Description:  Runt or Obese message received from SIC              */
#define SH_PI_AFI_ERROR_MASK_MSG_LEN_SHFT        34
#define SH_PI_AFI_ERROR_MASK_MSG_LEN_MASK        0x0000000400000000

/* ==================================================================== */
/*               Register "SH_PI_AFI_TEST_POINT_COMPARE"                */
/*                      PI AFI Test Point Compare                       */
/* ==================================================================== */

#define SH_PI_AFI_TEST_POINT_COMPARE             0x0000000120050100
#define SH_PI_AFI_TEST_POINT_COMPARE_MASK        0xffffffffffffffff
#define SH_PI_AFI_TEST_POINT_COMPARE_INIT        0xffffffff00000000

/*   SH_PI_AFI_TEST_POINT_COMPARE_COMPARE_MASK                          */
/*   Description:  Mask to select Debug bits for trigger generation     */
#define SH_PI_AFI_TEST_POINT_COMPARE_COMPARE_MASK_SHFT 0
#define SH_PI_AFI_TEST_POINT_COMPARE_COMPARE_MASK_MASK 0x00000000ffffffff

/*   SH_PI_AFI_TEST_POINT_COMPARE_COMPARE_PATTERN                       */
/*   Description:  debug bit pattern for trigger generation             */
#define SH_PI_AFI_TEST_POINT_COMPARE_COMPARE_PATTERN_SHFT 32
#define SH_PI_AFI_TEST_POINT_COMPARE_COMPARE_PATTERN_MASK 0xffffffff00000000

/* ==================================================================== */
/*                Register "SH_PI_AFI_TEST_POINT_SELECT"                */
/*                       PI AFI Test Point Select                       */
/* ==================================================================== */

#define SH_PI_AFI_TEST_POINT_SELECT              0x0000000120050180
#define SH_PI_AFI_TEST_POINT_SELECT_MASK         0xff7f7f7f7f7f7f7f
#define SH_PI_AFI_TEST_POINT_SELECT_INIT         0x0000000000000000

/*   SH_PI_AFI_TEST_POINT_SELECT_NIBBLE0_CHIPLET_SEL                    */
/*   Description:  Nibble 0: Word Select                                */
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE0_CHIPLET_SEL_SHFT 0
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE0_CHIPLET_SEL_MASK 0x000000000000000f

/*   SH_PI_AFI_TEST_POINT_SELECT_NIBBLE0_NIBBLE_SEL                     */
/*   Description:  Nibble 0: Nibble Select                              */
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE0_NIBBLE_SEL_SHFT 4
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE0_NIBBLE_SEL_MASK 0x0000000000000070

/*   SH_PI_AFI_TEST_POINT_SELECT_NIBBLE1_CHIPLET_SEL                    */
/*   Description:  Nibble 1: Word Select                                */
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE1_CHIPLET_SEL_SHFT 8
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE1_CHIPLET_SEL_MASK 0x0000000000000f00

/*   SH_PI_AFI_TEST_POINT_SELECT_NIBBLE1_NIBBLE_SEL                     */
/*   Description:  Nibble 1: Nibble Select                              */
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE1_NIBBLE_SEL_SHFT 12
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE1_NIBBLE_SEL_MASK 0x0000000000007000

/*   SH_PI_AFI_TEST_POINT_SELECT_NIBBLE2_CHIPLET_SEL                    */
/*   Description:  Nibble 2: Word Select                                */
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE2_CHIPLET_SEL_SHFT 16
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE2_CHIPLET_SEL_MASK 0x00000000000f0000

/*   SH_PI_AFI_TEST_POINT_SELECT_NIBBLE2_NIBBLE_SEL                     */
/*   Description:  Nibble 2: Nibble Select                              */
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE2_NIBBLE_SEL_SHFT 20
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE2_NIBBLE_SEL_MASK 0x0000000000700000

/*   SH_PI_AFI_TEST_POINT_SELECT_NIBBLE3_CHIPLET_SEL                    */
/*   Description:  Nibble 3: Word Select                                */
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE3_CHIPLET_SEL_SHFT 24
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE3_CHIPLET_SEL_MASK 0x000000000f000000

/*   SH_PI_AFI_TEST_POINT_SELECT_NIBBLE3_NIBBLE_SEL                     */
/*   Description:  Nibble 3: Nibble Select                              */
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE3_NIBBLE_SEL_SHFT 28
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE3_NIBBLE_SEL_MASK 0x0000000070000000

/*   SH_PI_AFI_TEST_POINT_SELECT_NIBBLE4_CHIPLET_SEL                    */
/*   Description:  Nibble 4: Word Select                                */
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE4_CHIPLET_SEL_SHFT 32
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE4_CHIPLET_SEL_MASK 0x0000000f00000000

/*   SH_PI_AFI_TEST_POINT_SELECT_NIBBLE4_NIBBLE_SEL                     */
/*   Description:  Nibble 4: Nibble Select                              */
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE4_NIBBLE_SEL_SHFT 36
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE4_NIBBLE_SEL_MASK 0x0000007000000000

/*   SH_PI_AFI_TEST_POINT_SELECT_NIBBLE5_CHIPLET_SEL                    */
/*   Description:  Nibble 5: Word Select                                */
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE5_CHIPLET_SEL_SHFT 40
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE5_CHIPLET_SEL_MASK 0x00000f0000000000

/*   SH_PI_AFI_TEST_POINT_SELECT_NIBBLE5_NIBBLE_SEL                     */
/*   Description:  Nibble 5: Nibble Select                              */
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE5_NIBBLE_SEL_SHFT 44
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE5_NIBBLE_SEL_MASK 0x0000700000000000

/*   SH_PI_AFI_TEST_POINT_SELECT_NIBBLE6_CHIPLET_SEL                    */
/*   Description:  Nibble 6: Word Select                                */
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE6_CHIPLET_SEL_SHFT 48
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE6_CHIPLET_SEL_MASK 0x000f000000000000

/*   SH_PI_AFI_TEST_POINT_SELECT_NIBBLE6_NIBBLE_SEL                     */
/*   Description:  Nibble 6: Nibble Select                              */
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE6_NIBBLE_SEL_SHFT 52
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE6_NIBBLE_SEL_MASK 0x0070000000000000

/*   SH_PI_AFI_TEST_POINT_SELECT_NIBBLE7_CHIPLET_SEL                    */
/*   Description:  Nibble 7: Word Select                                */
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE7_CHIPLET_SEL_SHFT 56
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE7_CHIPLET_SEL_MASK 0x0f00000000000000

/*   SH_PI_AFI_TEST_POINT_SELECT_NIBBLE7_NIBBLE_SEL                     */
/*   Description:  Nibble 7: Nibble Select                              */
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE7_NIBBLE_SEL_SHFT 60
#define SH_PI_AFI_TEST_POINT_SELECT_NIBBLE7_NIBBLE_SEL_MASK 0x7000000000000000

/*   SH_PI_AFI_TEST_POINT_SELECT_TRIGGER_ENABLE                         */
/*   Description:  Trigger Enabled                                      */
#define SH_PI_AFI_TEST_POINT_SELECT_TRIGGER_ENABLE_SHFT 63
#define SH_PI_AFI_TEST_POINT_SELECT_TRIGGER_ENABLE_MASK 0x8000000000000000

/* ==================================================================== */
/*            Register "SH_PI_AFI_TEST_POINT_TRIGGER_SELECT"            */
/*                  PI CRBC Test Point Trigger Select                   */
/* ==================================================================== */

#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT      0x0000000120050200
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_MASK 0x7f7f7f7f7f7f7f7f
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_INIT 0x0000000000000000

/*   SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER0_CHIPLET_SEL           */
/*   Description:  Nibble 0 Chiplet select                              */
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER0_CHIPLET_SEL_SHFT 0
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER0_CHIPLET_SEL_MASK 0x000000000000000f

/*   SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER0_NIBBLE_SEL            */
/*   Description:  Nibble 0 Nibble select                               */
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER0_NIBBLE_SEL_SHFT 4
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER0_NIBBLE_SEL_MASK 0x0000000000000070

/*   SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER1_CHIPLET_SEL           */
/*   Description:  Nibble 1 Chiplet select                              */
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER1_CHIPLET_SEL_SHFT 8
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER1_CHIPLET_SEL_MASK 0x0000000000000f00

/*   SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER1_NIBBLE_SEL            */
/*   Description:  Nibble 1 Nibble select                               */
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER1_NIBBLE_SEL_SHFT 12
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER1_NIBBLE_SEL_MASK 0x0000000000007000

/*   SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER2_CHIPLET_SEL           */
/*   Description:  Nibble 2 Chiplet select                              */
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER2_CHIPLET_SEL_SHFT 16
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER2_CHIPLET_SEL_MASK 0x00000000000f0000

/*   SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER2_NIBBLE_SEL            */
/*   Description:  Nibble 2 Nibble select                               */
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER2_NIBBLE_SEL_SHFT 20
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER2_NIBBLE_SEL_MASK 0x0000000000700000

/*   SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER3_CHIPLET_SEL           */
/*   Description:  Nibble 3 Chiplet select                              */
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER3_CHIPLET_SEL_SHFT 24
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER3_CHIPLET_SEL_MASK 0x000000000f000000

/*   SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER3_NIBBLE_SEL            */
/*   Description:  Nibble 3 Nibble select                               */
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER3_NIBBLE_SEL_SHFT 28
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER3_NIBBLE_SEL_MASK 0x0000000070000000

/*   SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER4_CHIPLET_SEL           */
/*   Description:  Nibble 4 Chiplet select                              */
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER4_CHIPLET_SEL_SHFT 32
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER4_CHIPLET_SEL_MASK 0x0000000f00000000

/*   SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER4_NIBBLE_SEL            */
/*   Description:  Nibble 4 Nibble select                               */
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER4_NIBBLE_SEL_SHFT 36
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER4_NIBBLE_SEL_MASK 0x0000007000000000

/*   SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER5_CHIPLET_SEL           */
/*   Description:  Nibble 5 Chiplet select                              */
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER5_CHIPLET_SEL_SHFT 40
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER5_CHIPLET_SEL_MASK 0x00000f0000000000

/*   SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER5_NIBBLE_SEL            */
/*   Description:  Nibble 5 Nibble select                               */
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER5_NIBBLE_SEL_SHFT 44
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER5_NIBBLE_SEL_MASK 0x0000700000000000

/*   SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER6_CHIPLET_SEL           */
/*   Description:  Nibble 6 Chiplet select                              */
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER6_CHIPLET_SEL_SHFT 48
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER6_CHIPLET_SEL_MASK 0x000f000000000000

/*   SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER6_NIBBLE_SEL            */
/*   Description:  Nibble 6 Nibble select                               */
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER6_NIBBLE_SEL_SHFT 52
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER6_NIBBLE_SEL_MASK 0x0070000000000000

/*   SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER7_CHIPLET_SEL           */
/*   Description:  Nibble 7 Chiplet select                              */
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER7_CHIPLET_SEL_SHFT 56
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER7_CHIPLET_SEL_MASK 0x0f00000000000000

/*   SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER7_NIBBLE_SEL            */
/*   Description:  Nibble 7 Nibble select                               */
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER7_NIBBLE_SEL_SHFT 60
#define SH_PI_AFI_TEST_POINT_TRIGGER_SELECT_TRIGGER7_NIBBLE_SEL_MASK 0x7000000000000000

/* ==================================================================== */
/*                  Register "SH_PI_AUTO_REPLY_ENABLE"                  */
/*                         PI Auto Reply Enable                         */
/* ==================================================================== */

#define SH_PI_AUTO_REPLY_ENABLE                  0x0000000120050280
#define SH_PI_AUTO_REPLY_ENABLE_MASK             0x0000000000000001
#define SH_PI_AUTO_REPLY_ENABLE_INIT             0x0000000000000000

/*   SH_PI_AUTO_REPLY_ENABLE_AUTO_REPLY_ENABLE                          */
/*   Description:  Auto Reply Enabled                                   */
#define SH_PI_AUTO_REPLY_ENABLE_AUTO_REPLY_ENABLE_SHFT 0
#define SH_PI_AUTO_REPLY_ENABLE_AUTO_REPLY_ENABLE_MASK 0x0000000000000001

/* ==================================================================== */
/*                     Register "SH_PI_CAM_CONTROL"                     */
/*                      CRB CAM MMR Access Control                      */
/* ==================================================================== */

#define SH_PI_CAM_CONTROL                        0x0000000120050300
#define SH_PI_CAM_CONTROL_MASK                   0x800000000000037f
#define SH_PI_CAM_CONTROL_INIT                   0x0000000000000000

/*   SH_PI_CAM_CONTROL_CAM_INDX                                         */
/*   Description:  CRB CAM Index to perform read/write on.              */
#define SH_PI_CAM_CONTROL_CAM_INDX_SHFT          0
#define SH_PI_CAM_CONTROL_CAM_INDX_MASK          0x000000000000007f

/*   SH_PI_CAM_CONTROL_CAM_WRITE                                        */
/*   Description:  Is CRB CAM MMR function a write.                     */
#define SH_PI_CAM_CONTROL_CAM_WRITE_SHFT         8
#define SH_PI_CAM_CONTROL_CAM_WRITE_MASK         0x0000000000000100

/*   SH_PI_CAM_CONTROL_RRB_RD_XFER_CLEAR                                */
/*   Description:  Clear RRB read tranfer pending.                      */
#define SH_PI_CAM_CONTROL_RRB_RD_XFER_CLEAR_SHFT 9
#define SH_PI_CAM_CONTROL_RRB_RD_XFER_CLEAR_MASK 0x0000000000000200

/*   SH_PI_CAM_CONTROL_START                                            */
/*   Description:  Start CRB CAM read/write operation                   */
#define SH_PI_CAM_CONTROL_START_SHFT             63
#define SH_PI_CAM_CONTROL_START_MASK             0x8000000000000000

/* ==================================================================== */
/*               Register "SH_PI_CRBC_TEST_POINT_COMPARE"               */
/*                      PI CRBC Test Point Compare                      */
/* ==================================================================== */

#define SH_PI_CRBC_TEST_POINT_COMPARE            0x0000000120050380
#define SH_PI_CRBC_TEST_POINT_COMPARE_MASK       0xffffffffffffffff
#define SH_PI_CRBC_TEST_POINT_COMPARE_INIT       0xffffffff00000000

/*   SH_PI_CRBC_TEST_POINT_COMPARE_COMPARE_MASK                         */
/*   Description:  Mask to select Debug bits for trigger generation     */
#define SH_PI_CRBC_TEST_POINT_COMPARE_COMPARE_MASK_SHFT 0
#define SH_PI_CRBC_TEST_POINT_COMPARE_COMPARE_MASK_MASK 0x00000000ffffffff

/*   SH_PI_CRBC_TEST_POINT_COMPARE_COMPARE_PATTERN                      */
/*   Description:  debug bit pattern for trigger generation             */
#define SH_PI_CRBC_TEST_POINT_COMPARE_COMPARE_PATTERN_SHFT 32
#define SH_PI_CRBC_TEST_POINT_COMPARE_COMPARE_PATTERN_MASK 0xffffffff00000000

/* ==================================================================== */
/*               Register "SH_PI_CRBC_TEST_POINT_SELECT"                */
/*                      PI CRBC Test Point Select                       */
/* ==================================================================== */

#define SH_PI_CRBC_TEST_POINT_SELECT             0x0000000120050400
#define SH_PI_CRBC_TEST_POINT_SELECT_MASK        0xf777777777777777
#define SH_PI_CRBC_TEST_POINT_SELECT_INIT        0x0000000000000000

/*   SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE0_CHIPLET_SEL                   */
/*   Description:  Nibble 0 Chiplet select                              */
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE0_CHIPLET_SEL_SHFT 0
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE0_CHIPLET_SEL_MASK 0x0000000000000007

/*   SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE0_NIBBLE_SEL                    */
/*   Description:  Nibble 0 Nibble select                               */
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE0_NIBBLE_SEL_SHFT 4
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE0_NIBBLE_SEL_MASK 0x0000000000000070

/*   SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE1_CHIPLET_SEL                   */
/*   Description:  Nibble 1 Chiplet select                              */
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE1_CHIPLET_SEL_SHFT 8
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE1_CHIPLET_SEL_MASK 0x0000000000000700

/*   SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE1_NIBBLE_SEL                    */
/*   Description:  Nibble 1 Nibble select                               */
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE1_NIBBLE_SEL_SHFT 12
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE1_NIBBLE_SEL_MASK 0x0000000000007000

/*   SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE2_CHIPLET_SEL                   */
/*   Description:  Nibble 2 Chiplet select                              */
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE2_CHIPLET_SEL_SHFT 16
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE2_CHIPLET_SEL_MASK 0x0000000000070000

/*   SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE2_NIBBLE_SEL                    */
/*   Description:  Nibble 2 Nibble select                               */
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE2_NIBBLE_SEL_SHFT 20
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE2_NIBBLE_SEL_MASK 0x0000000000700000

/*   SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE3_CHIPLET_SEL                   */
/*   Description:  Nibble 3 Chiplet select                              */
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE3_CHIPLET_SEL_SHFT 24
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE3_CHIPLET_SEL_MASK 0x0000000007000000

/*   SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE3_NIBBLE_SEL                    */
/*   Description:  Nibble 3 Nibble select                               */
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE3_NIBBLE_SEL_SHFT 28
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE3_NIBBLE_SEL_MASK 0x0000000070000000

/*   SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE4_CHIPLET_SEL                   */
/*   Description:  Nibble 4 Chiplet select                              */
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE4_CHIPLET_SEL_SHFT 32
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE4_CHIPLET_SEL_MASK 0x0000000700000000

/*   SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE4_NIBBLE_SEL                    */
/*   Description:  Nibble 4 Nibble select                               */
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE4_NIBBLE_SEL_SHFT 36
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE4_NIBBLE_SEL_MASK 0x0000007000000000

/*   SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE5_CHIPLET_SEL                   */
/*   Description:  Nibble 5 Chiplet select                              */
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE5_CHIPLET_SEL_SHFT 40
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE5_CHIPLET_SEL_MASK 0x0000070000000000

/*   SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE5_NIBBLE_SEL                    */
/*   Description:  Nibble 5 Nibble select                               */
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE5_NIBBLE_SEL_SHFT 44
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE5_NIBBLE_SEL_MASK 0x0000700000000000

/*   SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE6_CHIPLET_SEL                   */
/*   Description:  Nibble 6 Chiplet select                              */
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE6_CHIPLET_SEL_SHFT 48
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE6_CHIPLET_SEL_MASK 0x0007000000000000

/*   SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE6_NIBBLE_SEL                    */
/*   Description:  Nibble 6 Nibble select                               */
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE6_NIBBLE_SEL_SHFT 52
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE6_NIBBLE_SEL_MASK 0x0070000000000000

/*   SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE7_CHIPLET_SEL                   */
/*   Description:  Nibble 7 Chiplet select                              */
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE7_CHIPLET_SEL_SHFT 56
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE7_CHIPLET_SEL_MASK 0x0700000000000000

/*   SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE7_NIBBLE_SEL                    */
/*   Description:  Nibble 7 Nibble select                               */
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE7_NIBBLE_SEL_SHFT 60
#define SH_PI_CRBC_TEST_POINT_SELECT_NIBBLE7_NIBBLE_SEL_MASK 0x7000000000000000

/*   SH_PI_CRBC_TEST_POINT_SELECT_TRIGGER_ENABLE                        */
/*   Description:  Enable trigger on bit 32 of Analyzer data            */
#define SH_PI_CRBC_TEST_POINT_SELECT_TRIGGER_ENABLE_SHFT 63
#define SH_PI_CRBC_TEST_POINT_SELECT_TRIGGER_ENABLE_MASK 0x8000000000000000

/* ==================================================================== */
/*           Register "SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT"            */
/*                  PI CRBC Test Point Trigger Select                   */
/* ==================================================================== */

#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT     0x0000000120050480
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_MASK 0x7777777777777777
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_INIT 0x0000000000000000

/*   SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER0_CHIPLET_SEL          */
/*   Description:  Nibble 0 Chiplet select                              */
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER0_CHIPLET_SEL_SHFT 0
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER0_CHIPLET_SEL_MASK 0x0000000000000007

/*   SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER0_NIBBLE_SEL           */
/*   Description:  Nibble 0 Nibble select                               */
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER0_NIBBLE_SEL_SHFT 4
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER0_NIBBLE_SEL_MASK 0x0000000000000070

/*   SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER1_CHIPLET_SEL          */
/*   Description:  Nibble 1 Chiplet select                              */
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER1_CHIPLET_SEL_SHFT 8
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER1_CHIPLET_SEL_MASK 0x0000000000000700

/*   SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER1_NIBBLE_SEL           */
/*   Description:  Nibble 1 Nibble select                               */
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER1_NIBBLE_SEL_SHFT 12
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER1_NIBBLE_SEL_MASK 0x0000000000007000

/*   SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER2_CHIPLET_SEL          */
/*   Description:  Nibble 2 Chiplet select                              */
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER2_CHIPLET_SEL_SHFT 16
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER2_CHIPLET_SEL_MASK 0x0000000000070000

/*   SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER2_NIBBLE_SEL           */
/*   Description:  Nibble 2 Nibble select                               */
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER2_NIBBLE_SEL_SHFT 20
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER2_NIBBLE_SEL_MASK 0x0000000000700000

/*   SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER3_CHIPLET_SEL          */
/*   Description:  Nibble 3 Chiplet select                              */
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER3_CHIPLET_SEL_SHFT 24
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER3_CHIPLET_SEL_MASK 0x0000000007000000

/*   SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER3_NIBBLE_SEL           */
/*   Description:  Nibble 3 Nibble select                               */
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER3_NIBBLE_SEL_SHFT 28
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER3_NIBBLE_SEL_MASK 0x0000000070000000

/*   SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER4_CHIPLET_SEL          */
/*   Description:  Nibble 4 Chiplet select                              */
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER4_CHIPLET_SEL_SHFT 32
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER4_CHIPLET_SEL_MASK 0x0000000700000000

/*   SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER4_NIBBLE_SEL           */
/*   Description:  Nibble 4 Nibble select                               */
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER4_NIBBLE_SEL_SHFT 36
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER4_NIBBLE_SEL_MASK 0x0000007000000000

/*   SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER5_CHIPLET_SEL          */
/*   Description:  Nibble 5 Chiplet select                              */
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER5_CHIPLET_SEL_SHFT 40
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER5_CHIPLET_SEL_MASK 0x0000070000000000

/*   SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER5_NIBBLE_SEL           */
/*   Description:  Nibble 5 Nibble select                               */
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER5_NIBBLE_SEL_SHFT 44
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER5_NIBBLE_SEL_MASK 0x0000700000000000

/*   SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER6_CHIPLET_SEL          */
/*   Description:  Nibble 6 Chiplet select                              */
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER6_CHIPLET_SEL_SHFT 48
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER6_CHIPLET_SEL_MASK 0x0007000000000000

/*   SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER6_NIBBLE_SEL           */
/*   Description:  Nibble 6 Nibble select                               */
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER6_NIBBLE_SEL_SHFT 52
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER6_NIBBLE_SEL_MASK 0x0070000000000000

/*   SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER7_CHIPLET_SEL          */
/*   Description:  Nibble 7 Chiplet select                              */
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER7_CHIPLET_SEL_SHFT 56
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER7_CHIPLET_SEL_MASK 0x0700000000000000

/*   SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER7_NIBBLE_SEL           */
/*   Description:  Nibble 7 Nibble select                               */
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER7_NIBBLE_SEL_SHFT 60
#define SH_PI_CRBC_TEST_POINT_TRIGGER_SELECT_TRIGGER7_NIBBLE_SEL_MASK 0x7000000000000000

/* ==================================================================== */
/*                   Register "SH_PI_CRBP_ERROR_MASK"                   */
/*                          PI CRBP Error Mask                          */
/* ==================================================================== */

#define SH_PI_CRBP_ERROR_MASK                    0x0000000120050500
#define SH_PI_CRBP_ERROR_MASK_MASK               0x00000000001fffff
#define SH_PI_CRBP_ERROR_MASK_INIT               0x00000000001fffff

/*   SH_PI_CRBP_ERROR_MASK_FSB_PROTO_ERR                                */
/*   Description:  Mask detection internal protocol table misses        */
#define SH_PI_CRBP_ERROR_MASK_FSB_PROTO_ERR_SHFT 0
#define SH_PI_CRBP_ERROR_MASK_FSB_PROTO_ERR_MASK 0x0000000000000001

/*   SH_PI_CRBP_ERROR_MASK_GFX_RP_ERR                                   */
/*   Description:  Mask graphic reply error detection                   */
#define SH_PI_CRBP_ERROR_MASK_GFX_RP_ERR_SHFT    1
#define SH_PI_CRBP_ERROR_MASK_GFX_RP_ERR_MASK    0x0000000000000002

/*   SH_PI_CRBP_ERROR_MASK_XB_PROTO_ERR                                 */
/*   Description:  Mask detection of external protocol table misses     */
#define SH_PI_CRBP_ERROR_MASK_XB_PROTO_ERR_SHFT  2
#define SH_PI_CRBP_ERROR_MASK_XB_PROTO_ERR_MASK  0x0000000000000004

/*   SH_PI_CRBP_ERROR_MASK_MEM_RP_ERR                                   */
/*   Description:  Mask memory error reply message detection            */
#define SH_PI_CRBP_ERROR_MASK_MEM_RP_ERR_SHFT    3
#define SH_PI_CRBP_ERROR_MASK_MEM_RP_ERR_MASK    0x0000000000000008

/*   SH_PI_CRBP_ERROR_MASK_PIO_RP_ERR                                   */
/*   Description:  Mask PIO reply error message detection               */
#define SH_PI_CRBP_ERROR_MASK_PIO_RP_ERR_SHFT    4
#define SH_PI_CRBP_ERROR_MASK_PIO_RP_ERR_MASK    0x0000000000000010

/*   SH_PI_CRBP_ERROR_MASK_MEM_TO_ERR                                   */
/*   Description:  Mask memory time-out detection                       */
#define SH_PI_CRBP_ERROR_MASK_MEM_TO_ERR_SHFT    5
#define SH_PI_CRBP_ERROR_MASK_MEM_TO_ERR_MASK    0x0000000000000020

/*   SH_PI_CRBP_ERROR_MASK_PIO_TO_ERR                                   */
/*   Description:  Mask PIO time-out detection                          */
#define SH_PI_CRBP_ERROR_MASK_PIO_TO_ERR_SHFT    6
#define SH_PI_CRBP_ERROR_MASK_PIO_TO_ERR_MASK    0x0000000000000040

/*   SH_PI_CRBP_ERROR_MASK_FSB_SHUB_UCE                                 */
/*   Description:  Mask un-correctable ECC error detection              */
#define SH_PI_CRBP_ERROR_MASK_FSB_SHUB_UCE_SHFT  7
#define SH_PI_CRBP_ERROR_MASK_FSB_SHUB_UCE_MASK  0x0000000000000080

/*   SH_PI_CRBP_ERROR_MASK_FSB_SHUB_CE                                  */
/*   Description:  Mask correctable ECC error detection                 */
#define SH_PI_CRBP_ERROR_MASK_FSB_SHUB_CE_SHFT   8
#define SH_PI_CRBP_ERROR_MASK_FSB_SHUB_CE_MASK   0x0000000000000100

/*   SH_PI_CRBP_ERROR_MASK_MSG_COLOR_ERR                                */
/*   Description:  Mask detection of color errors                       */
#define SH_PI_CRBP_ERROR_MASK_MSG_COLOR_ERR_SHFT 9
#define SH_PI_CRBP_ERROR_MASK_MSG_COLOR_ERR_MASK 0x0000000000000200

/*   SH_PI_CRBP_ERROR_MASK_MD_RQ_Q_OFLOW                                */
/*   Description:  Mask MD Request input buffer over flow error         */
#define SH_PI_CRBP_ERROR_MASK_MD_RQ_Q_OFLOW_SHFT 10
#define SH_PI_CRBP_ERROR_MASK_MD_RQ_Q_OFLOW_MASK 0x0000000000000400

/*   SH_PI_CRBP_ERROR_MASK_MD_RP_Q_OFLOW                                */
/*   Description:  Mask MD Reply input buffer over flow error           */
#define SH_PI_CRBP_ERROR_MASK_MD_RP_Q_OFLOW_SHFT 11
#define SH_PI_CRBP_ERROR_MASK_MD_RP_Q_OFLOW_MASK 0x0000000000000800

/*   SH_PI_CRBP_ERROR_MASK_XN_RQ_Q_OFLOW                                */
/*   Description:  Mask XN Request input buffer over flow error         */
#define SH_PI_CRBP_ERROR_MASK_XN_RQ_Q_OFLOW_SHFT 12
#define SH_PI_CRBP_ERROR_MASK_XN_RQ_Q_OFLOW_MASK 0x0000000000001000

/*   SH_PI_CRBP_ERROR_MASK_XN_RP_Q_OFLOW                                */
/*   Description:  Mask XN Reply input buffer over flow error           */
#define SH_PI_CRBP_ERROR_MASK_XN_RP_Q_OFLOW_SHFT 13
#define SH_PI_CRBP_ERROR_MASK_XN_RP_Q_OFLOW_MASK 0x0000000000002000

/*   SH_PI_CRBP_ERROR_MASK_NACK_OFLOW                                   */
/*   Description:  Mask NACK over flow error                            */
#define SH_PI_CRBP_ERROR_MASK_NACK_OFLOW_SHFT    14
#define SH_PI_CRBP_ERROR_MASK_NACK_OFLOW_MASK    0x0000000000004000

/*   SH_PI_CRBP_ERROR_MASK_GFX_INT_0                                    */
/*   Description:  Mask GFX transfer interrupt for CPU 0                */
#define SH_PI_CRBP_ERROR_MASK_GFX_INT_0_SHFT     15
#define SH_PI_CRBP_ERROR_MASK_GFX_INT_0_MASK     0x0000000000008000

/*   SH_PI_CRBP_ERROR_MASK_GFX_INT_1                                    */
/*   Description:  Mask GFX transfer interrupt for CPU 1                */
#define SH_PI_CRBP_ERROR_MASK_GFX_INT_1_SHFT     16
#define SH_PI_CRBP_ERROR_MASK_GFX_INT_1_MASK     0x0000000000010000

/*   SH_PI_CRBP_ERROR_MASK_MD_RQ_CRD_OFLOW                              */
/*   Description:  Mask MD Request Credit Overflow Error                */
#define SH_PI_CRBP_ERROR_MASK_MD_RQ_CRD_OFLOW_SHFT 17
#define SH_PI_CRBP_ERROR_MASK_MD_RQ_CRD_OFLOW_MASK 0x0000000000020000

/*   SH_PI_CRBP_ERROR_MASK_MD_RP_CRD_OFLOW                              */
/*   Description:  Mask MD Reply Credit Overflow Error                  */
#define SH_PI_CRBP_ERROR_MASK_MD_RP_CRD_OFLOW_SHFT 18
#define SH_PI_CRBP_ERROR_MASK_MD_RP_CRD_OFLOW_MASK 0x0000000000040000

/*   SH_PI_CRBP_ERROR_MASK_XN_RQ_CRD_OFLOW                              */
/*   Description:  Mask XN Request Credit Overflow Error                */
#define SH_PI_CRBP_ERROR_MASK_XN_RQ_CRD_OFLOW_SHFT 19
#define SH_PI_CRBP_ERROR_MASK_XN_RQ_CRD_OFLOW_MASK 0x0000000000080000

/*   SH_PI_CRBP_ERROR_MASK_XN_RP_CRD_OFLOW                              */
/*   Description:  Mask XN Reply Credit Overflow Error                  */
#define SH_PI_CRBP_ERROR_MASK_XN_RP_CRD_OFLOW_SHFT 20
#define SH_PI_CRBP_ERROR_MASK_XN_RP_CRD_OFLOW_MASK 0x0000000000100000

/* ==================================================================== */
/*                Register "SH_PI_CRBP_FSB_PIPE_COMPARE"                */
/*                        CRBP FSB Pipe Compare                         */
/* ==================================================================== */

#define SH_PI_CRBP_FSB_PIPE_COMPARE              0x0000000120050580
#define SH_PI_CRBP_FSB_PIPE_COMPARE_MASK         0x001fffffffffffff
#define SH_PI_CRBP_FSB_PIPE_COMPARE_INIT         0x0000000000000000

/*   SH_PI_CRBP_FSB_PIPE_COMPARE_COMPARE_ADDRESS                        */
/*   Description:  Address A or B to compare against                    */
#define SH_PI_CRBP_FSB_PIPE_COMPARE_COMPARE_ADDRESS_SHFT 0
#define SH_PI_CRBP_FSB_PIPE_COMPARE_COMPARE_ADDRESS_MASK 0x00007fffffffffff

/*   SH_PI_CRBP_FSB_PIPE_COMPARE_COMPARE_REQ                            */
/*   Description:  REQa or REQb value to compare against                */
#define SH_PI_CRBP_FSB_PIPE_COMPARE_COMPARE_REQ_SHFT 47
#define SH_PI_CRBP_FSB_PIPE_COMPARE_COMPARE_REQ_MASK 0x001f800000000000

/* ==================================================================== */
/*                 Register "SH_PI_CRBP_FSB_PIPE_MASK"                  */
/*                          CRBP Compare Mask                           */
/* ==================================================================== */

#define SH_PI_CRBP_FSB_PIPE_MASK                 0x0000000120050600
#define SH_PI_CRBP_FSB_PIPE_MASK_MASK            0x001fffffffffffff
#define SH_PI_CRBP_FSB_PIPE_MASK_INIT            0x0000000000000000

/*   SH_PI_CRBP_FSB_PIPE_MASK_COMPARE_ADDRESS_MASK                      */
/*   Description:  Address A or B mask values                           */
#define SH_PI_CRBP_FSB_PIPE_MASK_COMPARE_ADDRESS_MASK_SHFT 0
#define SH_PI_CRBP_FSB_PIPE_MASK_COMPARE_ADDRESS_MASK_MASK 0x00007fffffffffff

/*   SH_PI_CRBP_FSB_PIPE_MASK_COMPARE_REQ_MASK                          */
/*   Description:  REQa or REQb mask values                             */
#define SH_PI_CRBP_FSB_PIPE_MASK_COMPARE_REQ_MASK_SHFT 47
#define SH_PI_CRBP_FSB_PIPE_MASK_COMPARE_REQ_MASK_MASK 0x001f800000000000

/* ==================================================================== */
/*               Register "SH_PI_CRBP_TEST_POINT_COMPARE"               */
/*                      PI CRBP Test Point Compare                      */
/* ==================================================================== */

#define SH_PI_CRBP_TEST_POINT_COMPARE            0x0000000120050680
#define SH_PI_CRBP_TEST_POINT_COMPARE_MASK       0xffffffffffffffff
#define SH_PI_CRBP_TEST_POINT_COMPARE_INIT       0xffffffff00000000

/*   SH_PI_CRBP_TEST_POINT_COMPARE_COMPARE_MASK                         */
/*   Description:  Mask to select Debug bits for trigger generation     */
#define SH_PI_CRBP_TEST_POINT_COMPARE_COMPARE_MASK_SHFT 0
#define SH_PI_CRBP_TEST_POINT_COMPARE_COMPARE_MASK_MASK 0x00000000ffffffff

/*   SH_PI_CRBP_TEST_POINT_COMPARE_COMPARE_PATTERN                      */
/*   Description:  debug bit pattern for trigger generation             */
#define SH_PI_CRBP_TEST_POINT_COMPARE_COMPARE_PATTERN_SHFT 32
#define SH_PI_CRBP_TEST_POINT_COMPARE_COMPARE_PATTERN_MASK 0xffffffff00000000

/* ==================================================================== */
/*               Register "SH_PI_CRBP_TEST_POINT_SELECT"                */
/*                      PI CRBP Test Point Select                       */
/* ==================================================================== */

#define SH_PI_CRBP_TEST_POINT_SELECT             0x0000000120050700
#define SH_PI_CRBP_TEST_POINT_SELECT_MASK        0xf777777777777777
#define SH_PI_CRBP_TEST_POINT_SELECT_INIT        0x0000000000000000

/*   SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE0_CHIPLET_SEL                   */
/*   Description:  Nibble 0 Chiplet select                              */
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE0_CHIPLET_SEL_SHFT 0
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE0_CHIPLET_SEL_MASK 0x0000000000000007

/*   SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE0_NIBBLE_SEL                    */
/*   Description:  Nibble 0 Nibble select                               */
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE0_NIBBLE_SEL_SHFT 4
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE0_NIBBLE_SEL_MASK 0x0000000000000070

/*   SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE1_CHIPLET_SEL                   */
/*   Description:  Nibble 1 Chiplet select                              */
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE1_CHIPLET_SEL_SHFT 8
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE1_CHIPLET_SEL_MASK 0x0000000000000700

/*   SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE1_NIBBLE_SEL                    */
/*   Description:  Nibble 1 Nibble select                               */
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE1_NIBBLE_SEL_SHFT 12
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE1_NIBBLE_SEL_MASK 0x0000000000007000

/*   SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE2_CHIPLET_SEL                   */
/*   Description:  Nibble 2 Chiplet select                              */
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE2_CHIPLET_SEL_SHFT 16
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE2_CHIPLET_SEL_MASK 0x0000000000070000

/*   SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE2_NIBBLE_SEL                    */
/*   Description:  Nibble 2 Nibble select                               */
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE2_NIBBLE_SEL_SHFT 20
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE2_NIBBLE_SEL_MASK 0x0000000000700000

/*   SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE3_CHIPLET_SEL                   */
/*   Description:  Nibble 3 Chiplet select                              */
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE3_CHIPLET_SEL_SHFT 24
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE3_CHIPLET_SEL_MASK 0x0000000007000000

/*   SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE3_NIBBLE_SEL                    */
/*   Description:  Nibble 3 Nibble select                               */
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE3_NIBBLE_SEL_SHFT 28
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE3_NIBBLE_SEL_MASK 0x0000000070000000

/*   SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE4_CHIPLET_SEL                   */
/*   Description:  Nibble 4 Chiplet select                              */
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE4_CHIPLET_SEL_SHFT 32
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE4_CHIPLET_SEL_MASK 0x0000000700000000

/*   SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE4_NIBBLE_SEL                    */
/*   Description:  Nibble 4 Nibble select                               */
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE4_NIBBLE_SEL_SHFT 36
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE4_NIBBLE_SEL_MASK 0x0000007000000000

/*   SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE5_CHIPLET_SEL                   */
/*   Description:  Nibble 5 Chiplet select                              */
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE5_CHIPLET_SEL_SHFT 40
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE5_CHIPLET_SEL_MASK 0x0000070000000000

/*   SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE5_NIBBLE_SEL                    */
/*   Description:  Nibble 5 Nibble select                               */
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE5_NIBBLE_SEL_SHFT 44
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE5_NIBBLE_SEL_MASK 0x0000700000000000

/*   SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE6_CHIPLET_SEL                   */
/*   Description:  Nibble 6 Chiplet select                              */
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE6_CHIPLET_SEL_SHFT 48
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE6_CHIPLET_SEL_MASK 0x0007000000000000

/*   SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE6_NIBBLE_SEL                    */
/*   Description:  Nibble 6 Nibble select                               */
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE6_NIBBLE_SEL_SHFT 52
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE6_NIBBLE_SEL_MASK 0x0070000000000000

/*   SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE7_CHIPLET_SEL                   */
/*   Description:  Nibble 7 Chiplet select                              */
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE7_CHIPLET_SEL_SHFT 56
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE7_CHIPLET_SEL_MASK 0x0700000000000000

/*   SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE7_NIBBLE_SEL                    */
/*   Description:  Nibble 7 Nibble select                               */
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE7_NIBBLE_SEL_SHFT 60
#define SH_PI_CRBP_TEST_POINT_SELECT_NIBBLE7_NIBBLE_SEL_MASK 0x7000000000000000

/*   SH_PI_CRBP_TEST_POINT_SELECT_TRIGGER_ENABLE                        */
/*   Description:  Enable trigger on bit 32 of Analyzer data            */
#define SH_PI_CRBP_TEST_POINT_SELECT_TRIGGER_ENABLE_SHFT 63
#define SH_PI_CRBP_TEST_POINT_SELECT_TRIGGER_ENABLE_MASK 0x8000000000000000

/* ==================================================================== */
/*           Register "SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT"            */
/*                  PI CRBP Test Point Trigger Select                   */
/* ==================================================================== */

#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT     0x0000000120050780
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_MASK 0x7777777777777777
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_INIT 0x0000000000000000

/*   SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER0_CHIPLET_SEL          */
/*   Description:  Nibble 0 Chiplet select                              */
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER0_CHIPLET_SEL_SHFT 0
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER0_CHIPLET_SEL_MASK 0x0000000000000007

/*   SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER0_NIBBLE_SEL           */
/*   Description:  Nibble 0 Nibble select                               */
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER0_NIBBLE_SEL_SHFT 4
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER0_NIBBLE_SEL_MASK 0x0000000000000070

/*   SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER1_CHIPLET_SEL          */
/*   Description:  Nibble 1 Chiplet select                              */
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER1_CHIPLET_SEL_SHFT 8
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER1_CHIPLET_SEL_MASK 0x0000000000000700

/*   SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER1_NIBBLE_SEL           */
/*   Description:  Nibble 1 Nibble select                               */
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER1_NIBBLE_SEL_SHFT 12
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER1_NIBBLE_SEL_MASK 0x0000000000007000

/*   SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER2_CHIPLET_SEL          */
/*   Description:  Nibble 2 Chiplet select                              */
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER2_CHIPLET_SEL_SHFT 16
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER2_CHIPLET_SEL_MASK 0x0000000000070000

/*   SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER2_NIBBLE_SEL           */
/*   Description:  Nibble 2 Nibble select                               */
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER2_NIBBLE_SEL_SHFT 20
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER2_NIBBLE_SEL_MASK 0x0000000000700000

/*   SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER3_CHIPLET_SEL          */
/*   Description:  Nibble 3 Chiplet select                              */
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER3_CHIPLET_SEL_SHFT 24
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER3_CHIPLET_SEL_MASK 0x0000000007000000

/*   SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER3_NIBBLE_SEL           */
/*   Description:  Nibble 3 Nibble select                               */
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER3_NIBBLE_SEL_SHFT 28
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER3_NIBBLE_SEL_MASK 0x0000000070000000

/*   SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER4_CHIPLET_SEL          */
/*   Description:  Nibble 4 Chiplet select                              */
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER4_CHIPLET_SEL_SHFT 32
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER4_CHIPLET_SEL_MASK 0x0000000700000000

/*   SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER4_NIBBLE_SEL           */
/*   Description:  Nibble 4 Nibble select                               */
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER4_NIBBLE_SEL_SHFT 36
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER4_NIBBLE_SEL_MASK 0x0000007000000000

/*   SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER5_CHIPLET_SEL          */
/*   Description:  Nibble 5 Chiplet select                              */
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER5_CHIPLET_SEL_SHFT 40
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER5_CHIPLET_SEL_MASK 0x0000070000000000

/*   SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER5_NIBBLE_SEL           */
/*   Description:  Nibble 5 Nibble select                               */
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER5_NIBBLE_SEL_SHFT 44
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER5_NIBBLE_SEL_MASK 0x0000700000000000

/*   SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER6_CHIPLET_SEL          */
/*   Description:  Nibble 6 Chiplet select                              */
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER6_CHIPLET_SEL_SHFT 48
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER6_CHIPLET_SEL_MASK 0x0007000000000000

/*   SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER6_NIBBLE_SEL           */
/*   Description:  Nibble 6 Nibble select                               */
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER6_NIBBLE_SEL_SHFT 52
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER6_NIBBLE_SEL_MASK 0x0070000000000000

/*   SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER7_CHIPLET_SEL          */
/*   Description:  Nibble 7 Chiplet select                              */
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER7_CHIPLET_SEL_SHFT 56
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER7_CHIPLET_SEL_MASK 0x0700000000000000

/*   SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER7_NIBBLE_SEL           */
/*   Description:  Nibble 7 Nibble select                               */
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER7_NIBBLE_SEL_SHFT 60
#define SH_PI_CRBP_TEST_POINT_TRIGGER_SELECT_TRIGGER7_NIBBLE_SEL_MASK 0x7000000000000000

/* ==================================================================== */
/*               Register "SH_PI_CRBP_XB_PIPE_COMPARE_0"                */
/*                         CRBP XB Pipe Compare                         */
/* ==================================================================== */

#define SH_PI_CRBP_XB_PIPE_COMPARE_0             0x0000000120050800
#define SH_PI_CRBP_XB_PIPE_COMPARE_0_MASK        0x007fffffffffffff
#define SH_PI_CRBP_XB_PIPE_COMPARE_0_INIT        0x0000000000000000

/*   SH_PI_CRBP_XB_PIPE_COMPARE_0_COMPARE_ADDRESS                       */
/*   Description:  Address to compare against                           */
#define SH_PI_CRBP_XB_PIPE_COMPARE_0_COMPARE_ADDRESS_SHFT 0
#define SH_PI_CRBP_XB_PIPE_COMPARE_0_COMPARE_ADDRESS_MASK 0x00007fffffffffff

/*   SH_PI_CRBP_XB_PIPE_COMPARE_0_COMPARE_COMMAND                       */
/*   Description:  SN2NET Command to compare against                    */
#define SH_PI_CRBP_XB_PIPE_COMPARE_0_COMPARE_COMMAND_SHFT 47
#define SH_PI_CRBP_XB_PIPE_COMPARE_0_COMPARE_COMMAND_MASK 0x007f800000000000

/* ==================================================================== */
/*               Register "SH_PI_CRBP_XB_PIPE_COMPARE_1"                */
/*                         CRBP XB Pipe Compare                         */
/* ==================================================================== */

#define SH_PI_CRBP_XB_PIPE_COMPARE_1             0x0000000120050880
#define SH_PI_CRBP_XB_PIPE_COMPARE_1_MASK        0x000001ff3fff3fff
#define SH_PI_CRBP_XB_PIPE_COMPARE_1_INIT        0x0000000000000000

/*   SH_PI_CRBP_XB_PIPE_COMPARE_1_COMPARE_SOURCE                        */
/*   Description:  Source to compare against                            */
#define SH_PI_CRBP_XB_PIPE_COMPARE_1_COMPARE_SOURCE_SHFT 0
#define SH_PI_CRBP_XB_PIPE_COMPARE_1_COMPARE_SOURCE_MASK 0x0000000000003fff

/*   SH_PI_CRBP_XB_PIPE_COMPARE_1_COMPARE_SUPPLEMENTAL                  */
/*   Description:  Supplemental to compare against                      */
#define SH_PI_CRBP_XB_PIPE_COMPARE_1_COMPARE_SUPPLEMENTAL_SHFT 16
#define SH_PI_CRBP_XB_PIPE_COMPARE_1_COMPARE_SUPPLEMENTAL_MASK 0x000000003fff0000

/*   SH_PI_CRBP_XB_PIPE_COMPARE_1_COMPARE_ECHO                          */
/*   Description:  Echo to compare against                              */
#define SH_PI_CRBP_XB_PIPE_COMPARE_1_COMPARE_ECHO_SHFT 32
#define SH_PI_CRBP_XB_PIPE_COMPARE_1_COMPARE_ECHO_MASK 0x000001ff00000000

/* ==================================================================== */
/*                 Register "SH_PI_CRBP_XB_PIPE_MASK_0"                 */
/*                     CRBP Compare Mask Register 1                     */
/* ==================================================================== */

#define SH_PI_CRBP_XB_PIPE_MASK_0                0x0000000120050900
#define SH_PI_CRBP_XB_PIPE_MASK_0_MASK           0x007fffffffffffff
#define SH_PI_CRBP_XB_PIPE_MASK_0_INIT           0x0000000000000000

/*   SH_PI_CRBP_XB_PIPE_MASK_0_COMPARE_ADDRESS_MASK                     */
/*   Description:  Address to compare against                           */
#define SH_PI_CRBP_XB_PIPE_MASK_0_COMPARE_ADDRESS_MASK_SHFT 0
#define SH_PI_CRBP_XB_PIPE_MASK_0_COMPARE_ADDRESS_MASK_MASK 0x00007fffffffffff

/*   SH_PI_CRBP_XB_PIPE_MASK_0_COMPARE_COMMAND_MASK                     */
/*   Description:  SN2NET Command to compare against                    */
#define SH_PI_CRBP_XB_PIPE_MASK_0_COMPARE_COMMAND_MASK_SHFT 47
#define SH_PI_CRBP_XB_PIPE_MASK_0_COMPARE_COMMAND_MASK_MASK 0x007f800000000000

/* ==================================================================== */
/*                 Register "SH_PI_CRBP_XB_PIPE_MASK_1"                 */
/*                 CRBP XB Pipe Compare Mask Register 1                 */
/* ==================================================================== */

#define SH_PI_CRBP_XB_PIPE_MASK_1                0x0000000120050980
#define SH_PI_CRBP_XB_PIPE_MASK_1_MASK           0x000001ff3fff3fff
#define SH_PI_CRBP_XB_PIPE_MASK_1_INIT           0x0000000000000000

/*   SH_PI_CRBP_XB_PIPE_MASK_1_COMPARE_SOURCE_MASK                      */
/*   Description:  Source to compare against                            */
#define SH_PI_CRBP_XB_PIPE_MASK_1_COMPARE_SOURCE_MASK_SHFT 0
#define SH_PI_CRBP_XB_PIPE_MASK_1_COMPARE_SOURCE_MASK_MASK 0x0000000000003fff

/*   SH_PI_CRBP_XB_PIPE_MASK_1_COMPARE_SUPPLEMENTAL_MASK                */
/*   Description:  Supplemental to compare against                      */
#define SH_PI_CRBP_XB_PIPE_MASK_1_COMPARE_SUPPLEMENTAL_MASK_SHFT 16
#define SH_PI_CRBP_XB_PIPE_MASK_1_COMPARE_SUPPLEMENTAL_MASK_MASK 0x000000003fff0000

/*   SH_PI_CRBP_XB_PIPE_MASK_1_COMPARE_ECHO_MASK                        */
/*   Description:  Echo to compare against                              */
#define SH_PI_CRBP_XB_PIPE_MASK_1_COMPARE_ECHO_MASK_SHFT 32
#define SH_PI_CRBP_XB_PIPE_MASK_1_COMPARE_ECHO_MASK_MASK 0x000001ff00000000

/* ==================================================================== */
/*                  Register "SH_PI_DPC_QUEUE_CONFIG"                   */
/*                       DPC Queue Configuration                        */
/* ==================================================================== */

#define SH_PI_DPC_QUEUE_CONFIG                   0x0000000120050a00
#define SH_PI_DPC_QUEUE_CONFIG_MASK              0x000000001f1f1f1f
#define SH_PI_DPC_QUEUE_CONFIG_INIT              0x000000000c010c01

/*   SH_PI_DPC_QUEUE_CONFIG_DWCQ_AE_LEVEL                               */
/*   Description:  DXB WTL Command Queue Almost Empty Level             */
#define SH_PI_DPC_QUEUE_CONFIG_DWCQ_AE_LEVEL_SHFT 0
#define SH_PI_DPC_QUEUE_CONFIG_DWCQ_AE_LEVEL_MASK 0x000000000000001f

/*   SH_PI_DPC_QUEUE_CONFIG_DWCQ_AF_THRESH                              */
/*   Description:  DXB WTL Command Queue Almost Full Threshold          */
#define SH_PI_DPC_QUEUE_CONFIG_DWCQ_AF_THRESH_SHFT 8
#define SH_PI_DPC_QUEUE_CONFIG_DWCQ_AF_THRESH_MASK 0x0000000000001f00

/*   SH_PI_DPC_QUEUE_CONFIG_FWCQ_AE_LEVEL                               */
/*   Description:  FSB WTL Command Queue Almost Empty Level             */
#define SH_PI_DPC_QUEUE_CONFIG_FWCQ_AE_LEVEL_SHFT 16
#define SH_PI_DPC_QUEUE_CONFIG_FWCQ_AE_LEVEL_MASK 0x00000000001f0000

/*   SH_PI_DPC_QUEUE_CONFIG_FWCQ_AF_THRESH                              */
/*   Description:  FSB WTL Command Queue Almost Full Threshold          */
#define SH_PI_DPC_QUEUE_CONFIG_FWCQ_AF_THRESH_SHFT 24
#define SH_PI_DPC_QUEUE_CONFIG_FWCQ_AF_THRESH_MASK 0x000000001f000000

/* ==================================================================== */
/*                     Register "SH_PI_ERROR_MASK"                      */
/*                            PI Error Mask                             */
/* ==================================================================== */

#define SH_PI_ERROR_MASK                         0x0000000120050a80
#define SH_PI_ERROR_MASK_MASK                    0x00000007ffffffff
#define SH_PI_ERROR_MASK_INIT                    0x00000007ffffffff

/*   SH_PI_ERROR_MASK_FSB_PROTO_ERR                                     */
/*   Description:  Mask detection of internal protocol table misses     */
#define SH_PI_ERROR_MASK_FSB_PROTO_ERR_SHFT      0
#define SH_PI_ERROR_MASK_FSB_PROTO_ERR_MASK      0x0000000000000001

/*   SH_PI_ERROR_MASK_GFX_RP_ERR                                        */
/*   Description:  Mask graphic reply error message error detection     */
#define SH_PI_ERROR_MASK_GFX_RP_ERR_SHFT         1
#define SH_PI_ERROR_MASK_GFX_RP_ERR_MASK         0x0000000000000002

/*   SH_PI_ERROR_MASK_XB_PROTO_ERR                                      */
/*   Description:  Mask detection of external protocol table misses     */
#define SH_PI_ERROR_MASK_XB_PROTO_ERR_SHFT       2
#define SH_PI_ERROR_MASK_XB_PROTO_ERR_MASK       0x0000000000000004

/*   SH_PI_ERROR_MASK_MEM_RP_ERR                                        */
/*   Description:  Mask memory reply error detection                    */
#define SH_PI_ERROR_MASK_MEM_RP_ERR_SHFT         3
#define SH_PI_ERROR_MASK_MEM_RP_ERR_MASK         0x0000000000000008

/*   SH_PI_ERROR_MASK_PIO_RP_ERR                                        */
/*   Description:  Mask PIO reply error detection                       */
#define SH_PI_ERROR_MASK_PIO_RP_ERR_SHFT         4
#define SH_PI_ERROR_MASK_PIO_RP_ERR_MASK         0x0000000000000010

/*   SH_PI_ERROR_MASK_MEM_TO_ERR                                        */
/*   Description:  Mask CRB time-out errors                             */
#define SH_PI_ERROR_MASK_MEM_TO_ERR_SHFT         5
#define SH_PI_ERROR_MASK_MEM_TO_ERR_MASK         0x0000000000000020

/*   SH_PI_ERROR_MASK_PIO_TO_ERR                                        */
/*   Description:  Mask PIO time-out errors                             */
#define SH_PI_ERROR_MASK_PIO_TO_ERR_SHFT         6
#define SH_PI_ERROR_MASK_PIO_TO_ERR_MASK         0x0000000000000040

/*   SH_PI_ERROR_MASK_FSB_SHUB_UCE                                      */
/*   Description:  Mask un-correctable ECC error detection              */
#define SH_PI_ERROR_MASK_FSB_SHUB_UCE_SHFT       7
#define SH_PI_ERROR_MASK_FSB_SHUB_UCE_MASK       0x0000000000000080

/*   SH_PI_ERROR_MASK_FSB_SHUB_CE                                       */
/*   Description:  Mask correctable ECC error detection                 */
#define SH_PI_ERROR_MASK_FSB_SHUB_CE_SHFT        8
#define SH_PI_ERROR_MASK_FSB_SHUB_CE_MASK        0x0000000000000100

/*   SH_PI_ERROR_MASK_MSG_COLOR_ERR                                     */
/*   Description:  Mask message color error detection                   */
#define SH_PI_ERROR_MASK_MSG_COLOR_ERR_SHFT      9
#define SH_PI_ERROR_MASK_MSG_COLOR_ERR_MASK      0x0000000000000200

/*   SH_PI_ERROR_MASK_MD_RQ_Q_OFLOW                                     */
/*   Description:  Mask MD Request input buffer over flow error         */
#define SH_PI_ERROR_MASK_MD_RQ_Q_OFLOW_SHFT      10
#define SH_PI_ERROR_MASK_MD_RQ_Q_OFLOW_MASK      0x0000000000000400

/*   SH_PI_ERROR_MASK_MD_RP_Q_OFLOW                                     */
/*   Description:  Mask MD Reply input buffer over flow error           */
#define SH_PI_ERROR_MASK_MD_RP_Q_OFLOW_SHFT      11
#define SH_PI_ERROR_MASK_MD_RP_Q_OFLOW_MASK      0x0000000000000800

/*   SH_PI_ERROR_MASK_XN_RQ_Q_OFLOW                                     */
/*   Description:  Mask XN Request input buffer over flow error         */
#define SH_PI_ERROR_MASK_XN_RQ_Q_OFLOW_SHFT      12
#define SH_PI_ERROR_MASK_XN_RQ_Q_OFLOW_MASK      0x0000000000001000

/*   SH_PI_ERROR_MASK_XN_RP_Q_OFLOW                                     */
/*   Description:  Mask XN Reply input buffer over flow error           */
#define SH_PI_ERROR_MASK_XN_RP_Q_OFLOW_SHFT      13
#define SH_PI_ERROR_MASK_XN_RP_Q_OFLOW_MASK      0x0000000000002000

/*   SH_PI_ERROR_MASK_NACK_OFLOW                                        */
/*   Description:  Mask NACK over flow error                            */
#define SH_PI_ERROR_MASK_NACK_OFLOW_SHFT         14
#define SH_PI_ERROR_MASK_NACK_OFLOW_MASK         0x0000000000004000

/*   SH_PI_ERROR_MASK_GFX_INT_0                                         */
/*   Description:  Mask GFX transfer interrupt for CPU 0                */
#define SH_PI_ERROR_MASK_GFX_INT_0_SHFT          15
#define SH_PI_ERROR_MASK_GFX_INT_0_MASK          0x0000000000008000

/*   SH_PI_ERROR_MASK_GFX_INT_1                                         */
/*   Description:  Mask GFX transfer interrupt for CPU 1                */
#define SH_PI_ERROR_MASK_GFX_INT_1_SHFT          16
#define SH_PI_ERROR_MASK_GFX_INT_1_MASK          0x0000000000010000

/*   SH_PI_ERROR_MASK_MD_RQ_CRD_OFLOW                                   */
/*   Description:  Mask MD Request Credit Overflow Error                */
#define SH_PI_ERROR_MASK_MD_RQ_CRD_OFLOW_SHFT    17
#define SH_PI_ERROR_MASK_MD_RQ_CRD_OFLOW_MASK    0x0000000000020000

/*   SH_PI_ERROR_MASK_MD_RP_CRD_OFLOW                                   */
/*   Description:  Mask MD Reply Credit Overflow Error                  */
#define SH_PI_ERROR_MASK_MD_RP_CRD_OFLOW_SHFT    18
#define SH_PI_ERROR_MASK_MD_RP_CRD_OFLOW_MASK    0x0000000000040000

/*   SH_PI_ERROR_MASK_XN_RQ_CRD_OFLOW                                   */
/*   Description:  Mask XN Request Credit Overflow Error                */
#define SH_PI_ERROR_MASK_XN_RQ_CRD_OFLOW_SHFT    19
#define SH_PI_ERROR_MASK_XN_RQ_CRD_OFLOW_MASK    0x0000000000080000

/*   SH_PI_ERROR_MASK_XN_RP_CRD_OFLOW                                   */
/*   Description:  Mask XN Reply Credit Overflow Error                  */
#define SH_PI_ERROR_MASK_XN_RP_CRD_OFLOW_SHFT    20
#define SH_PI_ERROR_MASK_XN_RP_CRD_OFLOW_MASK    0x0000000000100000

/*   SH_PI_ERROR_MASK_HUNG_BUS                                          */
/*   Description:  Mask FSB hung error                                  */
#define SH_PI_ERROR_MASK_HUNG_BUS_SHFT           21
#define SH_PI_ERROR_MASK_HUNG_BUS_MASK           0x0000000000200000

/*   SH_PI_ERROR_MASK_RSP_PARITY                                        */
/*   Description:  Parity error detecte during response phase           */
#define SH_PI_ERROR_MASK_RSP_PARITY_SHFT         22
#define SH_PI_ERROR_MASK_RSP_PARITY_MASK         0x0000000000400000

/*   SH_PI_ERROR_MASK_IOQ_OVERRUN                                       */
/*   Description:  Over run error detected on IOQ                       */
#define SH_PI_ERROR_MASK_IOQ_OVERRUN_SHFT        23
#define SH_PI_ERROR_MASK_IOQ_OVERRUN_MASK        0x0000000000800000

/*   SH_PI_ERROR_MASK_REQ_FORMAT                                        */
/*   Description:  FSB request format not supported                     */
#define SH_PI_ERROR_MASK_REQ_FORMAT_SHFT         24
#define SH_PI_ERROR_MASK_REQ_FORMAT_MASK         0x0000000001000000

/*   SH_PI_ERROR_MASK_ADDR_ACCESS                                       */
/*   Description:  Access to Address is not supported                   */
#define SH_PI_ERROR_MASK_ADDR_ACCESS_SHFT        25
#define SH_PI_ERROR_MASK_ADDR_ACCESS_MASK        0x0000000002000000

/*   SH_PI_ERROR_MASK_REQ_PARITY                                        */
/*   Description:  Parity error detected during request phase           */
#define SH_PI_ERROR_MASK_REQ_PARITY_SHFT         26
#define SH_PI_ERROR_MASK_REQ_PARITY_MASK         0x0000000004000000

/*   SH_PI_ERROR_MASK_ADDR_PARITY                                       */
/*   Description:  Parity error detected on address                     */
#define SH_PI_ERROR_MASK_ADDR_PARITY_SHFT        27
#define SH_PI_ERROR_MASK_ADDR_PARITY_MASK        0x0000000008000000

/*   SH_PI_ERROR_MASK_SHUB_FSB_DQE                                      */
/*   Description:  SHUB_FSB_DQE                                         */
#define SH_PI_ERROR_MASK_SHUB_FSB_DQE_SHFT       28
#define SH_PI_ERROR_MASK_SHUB_FSB_DQE_MASK       0x0000000010000000

/*   SH_PI_ERROR_MASK_SHUB_FSB_UCE                                      */
/*   Description:  An un-correctable ECC error was detected             */
#define SH_PI_ERROR_MASK_SHUB_FSB_UCE_SHFT       29
#define SH_PI_ERROR_MASK_SHUB_FSB_UCE_MASK       0x0000000020000000

/*   SH_PI_ERROR_MASK_SHUB_FSB_CE                                       */
/*   Description:  An correctable ECC error was detected                */
#define SH_PI_ERROR_MASK_SHUB_FSB_CE_SHFT        30
#define SH_PI_ERROR_MASK_SHUB_FSB_CE_MASK        0x0000000040000000

/*   SH_PI_ERROR_MASK_LIVELOCK                                          */
/*   Description:  AFI livelock error was detected                      */
#define SH_PI_ERROR_MASK_LIVELOCK_SHFT           31
#define SH_PI_ERROR_MASK_LIVELOCK_MASK           0x0000000080000000

/*   SH_PI_ERROR_MASK_BAD_SNOOP                                         */
/*   Description:  AFI bad snoop error was detected                     */
#define SH_PI_ERROR_MASK_BAD_SNOOP_SHFT          32
#define SH_PI_ERROR_MASK_BAD_SNOOP_MASK          0x0000000100000000

/*   SH_PI_ERROR_MASK_FSB_TBL_MISS                                      */
/*   Description:  AFI FSB request table miss error was detected        */
#define SH_PI_ERROR_MASK_FSB_TBL_MISS_SHFT       33
#define SH_PI_ERROR_MASK_FSB_TBL_MISS_MASK       0x0000000200000000

/*   SH_PI_ERROR_MASK_MSG_LENGTH                                        */
/*   Description:  Message length error on received message from SIC    */
#define SH_PI_ERROR_MASK_MSG_LENGTH_SHFT         34
#define SH_PI_ERROR_MASK_MSG_LENGTH_MASK         0x0000000400000000

/* ==================================================================== */
/*                Register "SH_PI_EXPRESS_REPLY_CONFIG"                 */
/*                    PI Express Reply Configuration                    */
/* ==================================================================== */

#define SH_PI_EXPRESS_REPLY_CONFIG               0x0000000120050b00
#define SH_PI_EXPRESS_REPLY_CONFIG_MASK          0x0000000000000007
#define SH_PI_EXPRESS_REPLY_CONFIG_INIT          0x0000000000000001

/*   SH_PI_EXPRESS_REPLY_CONFIG_MODE                                    */
/*   Description:  Express Reply Mode                                   */
#define SH_PI_EXPRESS_REPLY_CONFIG_MODE_SHFT     0
#define SH_PI_EXPRESS_REPLY_CONFIG_MODE_MASK     0x0000000000000007

/* ==================================================================== */
/*                  Register "SH_PI_FSB_COMPARE_VALUE"                  */
/*                          FSB Compare Value                           */
/* ==================================================================== */

#define SH_PI_FSB_COMPARE_VALUE                  0x0000000120050c00
#define SH_PI_FSB_COMPARE_VALUE_MASK             0xffffffffffffffff
#define SH_PI_FSB_COMPARE_VALUE_INIT             0x0000000000000000

/*   SH_PI_FSB_COMPARE_VALUE_COMPARE_VALUE                              */
/*   Description:  Compare value                                        */
#define SH_PI_FSB_COMPARE_VALUE_COMPARE_VALUE_SHFT 0
#define SH_PI_FSB_COMPARE_VALUE_COMPARE_VALUE_MASK 0xffffffffffffffff

/* ==================================================================== */
/*                  Register "SH_PI_FSB_COMPARE_MASK"                   */
/*                           FSB Compare Mask                           */
/* ==================================================================== */

#define SH_PI_FSB_COMPARE_MASK                   0x0000000120050b80
#define SH_PI_FSB_COMPARE_MASK_MASK              0xffffffffffffffff
#define SH_PI_FSB_COMPARE_MASK_INIT              0x0000000000000000

/*   SH_PI_FSB_COMPARE_MASK_MASK_VALUE                                  */
/*   Description:  Mask value                                           */
#define SH_PI_FSB_COMPARE_MASK_MASK_VALUE_SHFT   0
#define SH_PI_FSB_COMPARE_MASK_MASK_VALUE_MASK   0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_PI_FSB_ERROR_INJECTION"                 */
/*                     Inject an Error onto the FSB                     */
/* ==================================================================== */

#define SH_PI_FSB_ERROR_INJECTION                0x0000000120050c80
#define SH_PI_FSB_ERROR_INJECTION_MASK           0x000000070fff03ff
#define SH_PI_FSB_ERROR_INJECTION_INIT           0x0000000000000000

/*   SH_PI_FSB_ERROR_INJECTION_RP_PE_TO_FSB                             */
/*   Description:  Inject a RP# Parity Error onto the FSB               */
#define SH_PI_FSB_ERROR_INJECTION_RP_PE_TO_FSB_SHFT 0
#define SH_PI_FSB_ERROR_INJECTION_RP_PE_TO_FSB_MASK 0x0000000000000001

/*   SH_PI_FSB_ERROR_INJECTION_AP0_PE_TO_FSB                            */
/*   Description:  Inject an AP[0]# Parity Error onto the FSB           */
#define SH_PI_FSB_ERROR_INJECTION_AP0_PE_TO_FSB_SHFT 1
#define SH_PI_FSB_ERROR_INJECTION_AP0_PE_TO_FSB_MASK 0x0000000000000002

/*   SH_PI_FSB_ERROR_INJECTION_AP1_PE_TO_FSB                            */
/*   Description:  Inject an AP[1]# Parity Error onto the FSB           */
#define SH_PI_FSB_ERROR_INJECTION_AP1_PE_TO_FSB_SHFT 2
#define SH_PI_FSB_ERROR_INJECTION_AP1_PE_TO_FSB_MASK 0x0000000000000004

/*   SH_PI_FSB_ERROR_INJECTION_RSP_PE_TO_FSB                            */
/*   Description:  Inject a RSP# Parity Error onto the FSB              */
#define SH_PI_FSB_ERROR_INJECTION_RSP_PE_TO_FSB_SHFT 3
#define SH_PI_FSB_ERROR_INJECTION_RSP_PE_TO_FSB_MASK 0x0000000000000008

/*   SH_PI_FSB_ERROR_INJECTION_DW0_CE_TO_FSB                            */
/*   Description:  Inject a Correctable Error in Doubleword 0 onto the  */
#define SH_PI_FSB_ERROR_INJECTION_DW0_CE_TO_FSB_SHFT 4
#define SH_PI_FSB_ERROR_INJECTION_DW0_CE_TO_FSB_MASK 0x0000000000000010

/*   SH_PI_FSB_ERROR_INJECTION_DW0_UCE_TO_FSB                           */
/*   Description:  Inject an Uncorrectable Error in Doubleword 0 onto   */
/*  the FSB                                                             */
#define SH_PI_FSB_ERROR_INJECTION_DW0_UCE_TO_FSB_SHFT 5
#define SH_PI_FSB_ERROR_INJECTION_DW0_UCE_TO_FSB_MASK 0x0000000000000020

/*   SH_PI_FSB_ERROR_INJECTION_DW1_CE_TO_FSB                            */
/*   Description:  Inject a Correctable Error in Doubleword 1 onto the  */
#define SH_PI_FSB_ERROR_INJECTION_DW1_CE_TO_FSB_SHFT 6
#define SH_PI_FSB_ERROR_INJECTION_DW1_CE_TO_FSB_MASK 0x0000000000000040

/*   SH_PI_FSB_ERROR_INJECTION_DW1_UCE_TO_FSB                           */
/*   Description:  Inject an Uncorrectable Error in Doubleword 1 onto   */
/*  the FSB                                                             */
#define SH_PI_FSB_ERROR_INJECTION_DW1_UCE_TO_FSB_SHFT 7
#define SH_PI_FSB_ERROR_INJECTION_DW1_UCE_TO_FSB_MASK 0x0000000000000080

/*   SH_PI_FSB_ERROR_INJECTION_IP0_PE_TO_FSB                            */
/*   Description:  Inject an IP[0]# Parity Error onto the FSB           */
#define SH_PI_FSB_ERROR_INJECTION_IP0_PE_TO_FSB_SHFT 8
#define SH_PI_FSB_ERROR_INJECTION_IP0_PE_TO_FSB_MASK 0x0000000000000100

/*   SH_PI_FSB_ERROR_INJECTION_IP1_PE_TO_FSB                            */
/*   Description:  Inject an IP[1]# Parity Error onto the FSB           */
#define SH_PI_FSB_ERROR_INJECTION_IP1_PE_TO_FSB_SHFT 9
#define SH_PI_FSB_ERROR_INJECTION_IP1_PE_TO_FSB_MASK 0x0000000000000200

/*   SH_PI_FSB_ERROR_INJECTION_RP_PE_FROM_FSB                           */
/*   Description:  Inject a RP# Parity Error When Sampling the FSB      */
#define SH_PI_FSB_ERROR_INJECTION_RP_PE_FROM_FSB_SHFT 16
#define SH_PI_FSB_ERROR_INJECTION_RP_PE_FROM_FSB_MASK 0x0000000000010000

/*   SH_PI_FSB_ERROR_INJECTION_AP0_PE_FROM_FSB                          */
/*   Description:  Inject an AP[0]# Parity Error When Sampling the FSB  */
#define SH_PI_FSB_ERROR_INJECTION_AP0_PE_FROM_FSB_SHFT 17
#define SH_PI_FSB_ERROR_INJECTION_AP0_PE_FROM_FSB_MASK 0x0000000000020000

/*   SH_PI_FSB_ERROR_INJECTION_AP1_PE_FROM_FSB                          */
/*   Description:  Inject an AP[1]# Parity Error When Sampling the FSB  */
#define SH_PI_FSB_ERROR_INJECTION_AP1_PE_FROM_FSB_SHFT 18
#define SH_PI_FSB_ERROR_INJECTION_AP1_PE_FROM_FSB_MASK 0x0000000000040000

/*   SH_PI_FSB_ERROR_INJECTION_RSP_PE_FROM_FSB                          */
/*   Description:  Inject a RSP# Parity Error When Sampling the FSB     */
#define SH_PI_FSB_ERROR_INJECTION_RSP_PE_FROM_FSB_SHFT 19
#define SH_PI_FSB_ERROR_INJECTION_RSP_PE_FROM_FSB_MASK 0x0000000000080000

/*   SH_PI_FSB_ERROR_INJECTION_DW0_CE_FROM_FSB                          */
/*   Description:  Inject a Correctable Error in Doubleword 0 of SIC D  */
/*  ata Packet 0                                                        */
#define SH_PI_FSB_ERROR_INJECTION_DW0_CE_FROM_FSB_SHFT 20
#define SH_PI_FSB_ERROR_INJECTION_DW0_CE_FROM_FSB_MASK 0x0000000000100000

/*   SH_PI_FSB_ERROR_INJECTION_DW0_UCE_FROM_FSB                         */
/*   Description:  Inject a Uncorrectable Error in Doubleword 0 of SIC  */
/*   Data Packet 0                                                      */
#define SH_PI_FSB_ERROR_INJECTION_DW0_UCE_FROM_FSB_SHFT 21
#define SH_PI_FSB_ERROR_INJECTION_DW0_UCE_FROM_FSB_MASK 0x0000000000200000

/*   SH_PI_FSB_ERROR_INJECTION_DW1_CE_FROM_FSB                          */
/*   Description:  Inject a Correctable Error in Doubleword 0 of SIC D  */
/*  ata Packet 0                                                        */
#define SH_PI_FSB_ERROR_INJECTION_DW1_CE_FROM_FSB_SHFT 22
#define SH_PI_FSB_ERROR_INJECTION_DW1_CE_FROM_FSB_MASK 0x0000000000400000

/*   SH_PI_FSB_ERROR_INJECTION_DW1_UCE_FROM_FSB                         */
/*   Description:  Inject a Uncorrectable Error in Doubleword 0 of SIC  */
/*   Data Packet 0                                                      */
#define SH_PI_FSB_ERROR_INJECTION_DW1_UCE_FROM_FSB_SHFT 23
#define SH_PI_FSB_ERROR_INJECTION_DW1_UCE_FROM_FSB_MASK 0x0000000000800000

/*   SH_PI_FSB_ERROR_INJECTION_DW2_CE_FROM_FSB                          */
/*   Description:  Inject a Correctable Error in Doubleword 0 of SIC D  */
/*  ata Packet 0                                                        */
#define SH_PI_FSB_ERROR_INJECTION_DW2_CE_FROM_FSB_SHFT 24
#define SH_PI_FSB_ERROR_INJECTION_DW2_CE_FROM_FSB_MASK 0x0000000001000000

/*   SH_PI_FSB_ERROR_INJECTION_DW2_UCE_FROM_FSB                         */
/*   Description:  Inject a Uncorrectable Error in Doubleword 0 of SIC  */
/*   Data Packet 0                                                      */
#define SH_PI_FSB_ERROR_INJECTION_DW2_UCE_FROM_FSB_SHFT 25
#define SH_PI_FSB_ERROR_INJECTION_DW2_UCE_FROM_FSB_MASK 0x0000000002000000

/*   SH_PI_FSB_ERROR_INJECTION_DW3_CE_FROM_FSB                          */
/*   Description:  Inject a Correctable Error in Doubleword 0 of SIC D  */
/*  ata Packet 0                                                        */
#define SH_PI_FSB_ERROR_INJECTION_DW3_CE_FROM_FSB_SHFT 26
#define SH_PI_FSB_ERROR_INJECTION_DW3_CE_FROM_FSB_MASK 0x0000000004000000

/*   SH_PI_FSB_ERROR_INJECTION_DW3_UCE_FROM_FSB                         */
/*   Description:  Inject a Uncorrectable Error in Doubleword 0 of SIC  */
/*   Data Packet 0                                                      */
#define SH_PI_FSB_ERROR_INJECTION_DW3_UCE_FROM_FSB_SHFT 27
#define SH_PI_FSB_ERROR_INJECTION_DW3_UCE_FROM_FSB_MASK 0x0000000008000000

/*   SH_PI_FSB_ERROR_INJECTION_IOQ_OVERRUN                              */
/*   Description:  Inject an ioq overrun Error on the FSB               */
#define SH_PI_FSB_ERROR_INJECTION_IOQ_OVERRUN_SHFT 32
#define SH_PI_FSB_ERROR_INJECTION_IOQ_OVERRUN_MASK 0x0000000100000000

/*   SH_PI_FSB_ERROR_INJECTION_LIVELOCK                                 */
/*   Description:  Inject a livelock Error on the FSB                   */
#define SH_PI_FSB_ERROR_INJECTION_LIVELOCK_SHFT  33
#define SH_PI_FSB_ERROR_INJECTION_LIVELOCK_MASK  0x0000000200000000

/*   SH_PI_FSB_ERROR_INJECTION_BUS_HANG                                 */
/*   Description:  Inject an bus hang on the FSB                        */
#define SH_PI_FSB_ERROR_INJECTION_BUS_HANG_SHFT  34
#define SH_PI_FSB_ERROR_INJECTION_BUS_HANG_MASK  0x0000000400000000

/* ==================================================================== */
/*                Register "SH_PI_MD2PI_REPLY_VC_CONFIG"                */
/*             MD-to-PI Reply Virtual Channel Configuration             */
/* ==================================================================== */

#define SH_PI_MD2PI_REPLY_VC_CONFIG              0x0000000120050d00
#define SH_PI_MD2PI_REPLY_VC_CONFIG_MASK         0xc000000000003fff
#define SH_PI_MD2PI_REPLY_VC_CONFIG_INIT         0x000000000000088c

/*   SH_PI_MD2PI_REPLY_VC_CONFIG_HDR_DEPTH                              */
/*   Description:  Depth of header Buffer                               */
#define SH_PI_MD2PI_REPLY_VC_CONFIG_HDR_DEPTH_SHFT 0
#define SH_PI_MD2PI_REPLY_VC_CONFIG_HDR_DEPTH_MASK 0x000000000000000f

/*   SH_PI_MD2PI_REPLY_VC_CONFIG_DATA_DEPTH                             */
/*   Description:  Number of data buffers Available                     */
#define SH_PI_MD2PI_REPLY_VC_CONFIG_DATA_DEPTH_SHFT 4
#define SH_PI_MD2PI_REPLY_VC_CONFIG_DATA_DEPTH_MASK 0x00000000000000f0

/*   SH_PI_MD2PI_REPLY_VC_CONFIG_MAX_CREDITS                            */
/*   Description:  Maximum credits from sender                          */
#define SH_PI_MD2PI_REPLY_VC_CONFIG_MAX_CREDITS_SHFT 8
#define SH_PI_MD2PI_REPLY_VC_CONFIG_MAX_CREDITS_MASK 0x0000000000003f00

/*   SH_PI_MD2PI_REPLY_VC_CONFIG_FORCE_CREDIT                           */
/*   Description:  Send an extra credit to sender                       */
#define SH_PI_MD2PI_REPLY_VC_CONFIG_FORCE_CREDIT_SHFT 62
#define SH_PI_MD2PI_REPLY_VC_CONFIG_FORCE_CREDIT_MASK 0x4000000000000000

/*   SH_PI_MD2PI_REPLY_VC_CONFIG_CAPTURE_CREDIT_STATUS                  */
/*   Description:  Capture credit and status information                */
#define SH_PI_MD2PI_REPLY_VC_CONFIG_CAPTURE_CREDIT_STATUS_SHFT 63
#define SH_PI_MD2PI_REPLY_VC_CONFIG_CAPTURE_CREDIT_STATUS_MASK 0x8000000000000000

/* ==================================================================== */
/*               Register "SH_PI_MD2PI_REQUEST_VC_CONFIG"               */
/*            MD-to-PI Request Virtual Channel Configuration            */
/* ==================================================================== */

#define SH_PI_MD2PI_REQUEST_VC_CONFIG            0x0000000120050d80
#define SH_PI_MD2PI_REQUEST_VC_CONFIG_MASK       0xc000000000003fff
#define SH_PI_MD2PI_REQUEST_VC_CONFIG_INIT       0x000000000000088c

/*   SH_PI_MD2PI_REQUEST_VC_CONFIG_HDR_DEPTH                            */
/*   Description:  Depth of header Buffer                               */
#define SH_PI_MD2PI_REQUEST_VC_CONFIG_HDR_DEPTH_SHFT 0
#define SH_PI_MD2PI_REQUEST_VC_CONFIG_HDR_DEPTH_MASK 0x000000000000000f

/*   SH_PI_MD2PI_REQUEST_VC_CONFIG_DATA_DEPTH                           */
/*   Description:  Number of data buffers Available                     */
#define SH_PI_MD2PI_REQUEST_VC_CONFIG_DATA_DEPTH_SHFT 4
#define SH_PI_MD2PI_REQUEST_VC_CONFIG_DATA_DEPTH_MASK 0x00000000000000f0

/*   SH_PI_MD2PI_REQUEST_VC_CONFIG_MAX_CREDITS                          */
/*   Description:  Maximum credits from sender                          */
#define SH_PI_MD2PI_REQUEST_VC_CONFIG_MAX_CREDITS_SHFT 8
#define SH_PI_MD2PI_REQUEST_VC_CONFIG_MAX_CREDITS_MASK 0x0000000000003f00

/*   SH_PI_MD2PI_REQUEST_VC_CONFIG_FORCE_CREDIT                         */
/*   Description:  Send an extra credit to sender                       */
#define SH_PI_MD2PI_REQUEST_VC_CONFIG_FORCE_CREDIT_SHFT 62
#define SH_PI_MD2PI_REQUEST_VC_CONFIG_FORCE_CREDIT_MASK 0x4000000000000000

/*   SH_PI_MD2PI_REQUEST_VC_CONFIG_CAPTURE_CREDIT_STATUS                */
/*   Description:  Capture credit and status information                */
#define SH_PI_MD2PI_REQUEST_VC_CONFIG_CAPTURE_CREDIT_STATUS_SHFT 63
#define SH_PI_MD2PI_REQUEST_VC_CONFIG_CAPTURE_CREDIT_STATUS_MASK 0x8000000000000000

/* ==================================================================== */
/*                Register "SH_PI_QUEUE_ERROR_INJECTION"                */
/*                       PI Queue Error Injection                       */
/* ==================================================================== */

#define SH_PI_QUEUE_ERROR_INJECTION              0x0000000120050e00
#define SH_PI_QUEUE_ERROR_INJECTION_MASK         0x00000000000000ff
#define SH_PI_QUEUE_ERROR_INJECTION_INIT         0x0000000000000000

/*   SH_PI_QUEUE_ERROR_INJECTION_DAT_DFR_Q                              */
#define SH_PI_QUEUE_ERROR_INJECTION_DAT_DFR_Q_SHFT 0
#define SH_PI_QUEUE_ERROR_INJECTION_DAT_DFR_Q_MASK 0x0000000000000001

/*   SH_PI_QUEUE_ERROR_INJECTION_DXB_WTL_CMND_Q                         */
#define SH_PI_QUEUE_ERROR_INJECTION_DXB_WTL_CMND_Q_SHFT 1
#define SH_PI_QUEUE_ERROR_INJECTION_DXB_WTL_CMND_Q_MASK 0x0000000000000002

/*   SH_PI_QUEUE_ERROR_INJECTION_FSB_WTL_CMND_Q                         */
#define SH_PI_QUEUE_ERROR_INJECTION_FSB_WTL_CMND_Q_SHFT 2
#define SH_PI_QUEUE_ERROR_INJECTION_FSB_WTL_CMND_Q_MASK 0x0000000000000004

/*   SH_PI_QUEUE_ERROR_INJECTION_MDPI_RPY_BFR                           */
#define SH_PI_QUEUE_ERROR_INJECTION_MDPI_RPY_BFR_SHFT 3
#define SH_PI_QUEUE_ERROR_INJECTION_MDPI_RPY_BFR_MASK 0x0000000000000008

/*   SH_PI_QUEUE_ERROR_INJECTION_PTC_INTR                               */
#define SH_PI_QUEUE_ERROR_INJECTION_PTC_INTR_SHFT 4
#define SH_PI_QUEUE_ERROR_INJECTION_PTC_INTR_MASK 0x0000000000000010

/*   SH_PI_QUEUE_ERROR_INJECTION_RXL_KILL_Q                             */
#define SH_PI_QUEUE_ERROR_INJECTION_RXL_KILL_Q_SHFT 5
#define SH_PI_QUEUE_ERROR_INJECTION_RXL_KILL_Q_MASK 0x0000000000000020

/*   SH_PI_QUEUE_ERROR_INJECTION_RXL_RDY_Q                              */
#define SH_PI_QUEUE_ERROR_INJECTION_RXL_RDY_Q_SHFT 6
#define SH_PI_QUEUE_ERROR_INJECTION_RXL_RDY_Q_MASK 0x0000000000000040

/*   SH_PI_QUEUE_ERROR_INJECTION_XNPI_RPY_BFR                           */
#define SH_PI_QUEUE_ERROR_INJECTION_XNPI_RPY_BFR_SHFT 7
#define SH_PI_QUEUE_ERROR_INJECTION_XNPI_RPY_BFR_MASK 0x0000000000000080

/* ==================================================================== */
/*                 Register "SH_PI_TEST_POINT_COMPARE"                  */
/*                        PI Test Point Compare                         */
/* ==================================================================== */

#define SH_PI_TEST_POINT_COMPARE                 0x0000000120050e80
#define SH_PI_TEST_POINT_COMPARE_MASK            0xffffffffffffffff
#define SH_PI_TEST_POINT_COMPARE_INIT            0xffffffff00000000

/*   SH_PI_TEST_POINT_COMPARE_COMPARE_MASK                              */
/*   Description:  Mask to select test point data for trigger generati  */
#define SH_PI_TEST_POINT_COMPARE_COMPARE_MASK_SHFT 0
#define SH_PI_TEST_POINT_COMPARE_COMPARE_MASK_MASK 0x00000000ffffffff

/*   SH_PI_TEST_POINT_COMPARE_COMPARE_PATTERN                           */
/*   Description:  Pattern of test point data to cause trigger          */
#define SH_PI_TEST_POINT_COMPARE_COMPARE_PATTERN_SHFT 32
#define SH_PI_TEST_POINT_COMPARE_COMPARE_PATTERN_MASK 0xffffffff00000000

/* ==================================================================== */
/*                  Register "SH_PI_TEST_POINT_SELECT"                  */
/*                         PI Test Point Select                         */
/* ==================================================================== */

#define SH_PI_TEST_POINT_SELECT                  0x0000000120050f00
#define SH_PI_TEST_POINT_SELECT_MASK             0xf777777777777777
#define SH_PI_TEST_POINT_SELECT_INIT             0x0000000000000000

/*   SH_PI_TEST_POINT_SELECT_NIBBLE0_CHIPLET_SEL                        */
/*   Description:  Nibble 0 data is from Chiplet X                      */
#define SH_PI_TEST_POINT_SELECT_NIBBLE0_CHIPLET_SEL_SHFT 0
#define SH_PI_TEST_POINT_SELECT_NIBBLE0_CHIPLET_SEL_MASK 0x0000000000000007

/*   SH_PI_TEST_POINT_SELECT_NIBBLE0_NIBBLE_SEL                         */
/*   Description:  Nibble X is routed to Nibble 0                       */
#define SH_PI_TEST_POINT_SELECT_NIBBLE0_NIBBLE_SEL_SHFT 4
#define SH_PI_TEST_POINT_SELECT_NIBBLE0_NIBBLE_SEL_MASK 0x0000000000000070

/*   SH_PI_TEST_POINT_SELECT_NIBBLE1_CHIPLET_SEL                        */
/*   Description:  Nibble 1 data is from Chiplet X                      */
#define SH_PI_TEST_POINT_SELECT_NIBBLE1_CHIPLET_SEL_SHFT 8
#define SH_PI_TEST_POINT_SELECT_NIBBLE1_CHIPLET_SEL_MASK 0x0000000000000700

/*   SH_PI_TEST_POINT_SELECT_NIBBLE1_NIBBLE_SEL                         */
/*   Description:  Nibble X is routed to Nibble 1                       */
#define SH_PI_TEST_POINT_SELECT_NIBBLE1_NIBBLE_SEL_SHFT 12
#define SH_PI_TEST_POINT_SELECT_NIBBLE1_NIBBLE_SEL_MASK 0x0000000000007000

/*   SH_PI_TEST_POINT_SELECT_NIBBLE2_CHIPLET_SEL                        */
/*   Description:  Nibble 2 data is from Chiplet X                      */
#define SH_PI_TEST_POINT_SELECT_NIBBLE2_CHIPLET_SEL_SHFT 16
#define SH_PI_TEST_POINT_SELECT_NIBBLE2_CHIPLET_SEL_MASK 0x0000000000070000

/*   SH_PI_TEST_POINT_SELECT_NIBBLE2_NIBBLE_SEL                         */
/*   Description:  Nibble X is routed to Nibble 2                       */
#define SH_PI_TEST_POINT_SELECT_NIBBLE2_NIBBLE_SEL_SHFT 20
#define SH_PI_TEST_POINT_SELECT_NIBBLE2_NIBBLE_SEL_MASK 0x0000000000700000

/*   SH_PI_TEST_POINT_SELECT_NIBBLE3_CHIPLET_SEL                        */
/*   Description:  Nibble 3 data is from Chiplet X                      */
#define SH_PI_TEST_POINT_SELECT_NIBBLE3_CHIPLET_SEL_SHFT 24
#define SH_PI_TEST_POINT_SELECT_NIBBLE3_CHIPLET_SEL_MASK 0x0000000007000000

/*   SH_PI_TEST_POINT_SELECT_NIBBLE3_NIBBLE_SEL                         */
/*   Description:  Nibble X is routed to Nibble 3                       */
#define SH_PI_TEST_POINT_SELECT_NIBBLE3_NIBBLE_SEL_SHFT 28
#define SH_PI_TEST_POINT_SELECT_NIBBLE3_NIBBLE_SEL_MASK 0x0000000070000000

/*   SH_PI_TEST_POINT_SELECT_NIBBLE4_CHIPLET_SEL                        */
/*   Description:  Nibble 4 data is from Chiplet X                      */
#define SH_PI_TEST_POINT_SELECT_NIBBLE4_CHIPLET_SEL_SHFT 32
#define SH_PI_TEST_POINT_SELECT_NIBBLE4_CHIPLET_SEL_MASK 0x0000000700000000

/*   SH_PI_TEST_POINT_SELECT_NIBBLE4_NIBBLE_SEL                         */
/*   Description:  Nibble X is routed to Nibble 4                       */
#define SH_PI_TEST_POINT_SELECT_NIBBLE4_NIBBLE_SEL_SHFT 36
#define SH_PI_TEST_POINT_SELECT_NIBBLE4_NIBBLE_SEL_MASK 0x0000007000000000

/*   SH_PI_TEST_POINT_SELECT_NIBBLE5_CHIPLET_SEL                        */
/*   Description:  Nibble 5 data is from Chiplet X                      */
#define SH_PI_TEST_POINT_SELECT_NIBBLE5_CHIPLET_SEL_SHFT 40
#define SH_PI_TEST_POINT_SELECT_NIBBLE5_CHIPLET_SEL_MASK 0x0000070000000000

/*   SH_PI_TEST_POINT_SELECT_NIBBLE5_NIBBLE_SEL                         */
/*   Description:  Nibble X is routed to Nibble 5                       */
#define SH_PI_TEST_POINT_SELECT_NIBBLE5_NIBBLE_SEL_SHFT 44
#define SH_PI_TEST_POINT_SELECT_NIBBLE5_NIBBLE_SEL_MASK 0x0000700000000000

/*   SH_PI_TEST_POINT_SELECT_NIBBLE6_CHIPLET_SEL                        */
/*   Description:  Nibble 6 data is from Chiplet X                      */
#define SH_PI_TEST_POINT_SELECT_NIBBLE6_CHIPLET_SEL_SHFT 48
#define SH_PI_TEST_POINT_SELECT_NIBBLE6_CHIPLET_SEL_MASK 0x0007000000000000

/*   SH_PI_TEST_POINT_SELECT_NIBBLE6_NIBBLE_SEL                         */
/*   Description:  Nibble X is routed to Nibble 6                       */
#define SH_PI_TEST_POINT_SELECT_NIBBLE6_NIBBLE_SEL_SHFT 52
#define SH_PI_TEST_POINT_SELECT_NIBBLE6_NIBBLE_SEL_MASK 0x0070000000000000

/*   SH_PI_TEST_POINT_SELECT_NIBBLE7_CHIPLET_SEL                        */
/*   Description:  Nibble 7 data is from Chiplet X                      */
#define SH_PI_TEST_POINT_SELECT_NIBBLE7_CHIPLET_SEL_SHFT 56
#define SH_PI_TEST_POINT_SELECT_NIBBLE7_CHIPLET_SEL_MASK 0x0700000000000000

/*   SH_PI_TEST_POINT_SELECT_NIBBLE7_NIBBLE_SEL                         */
/*   Description:  Nibble X is routed to Nibble 7                       */
#define SH_PI_TEST_POINT_SELECT_NIBBLE7_NIBBLE_SEL_SHFT 60
#define SH_PI_TEST_POINT_SELECT_NIBBLE7_NIBBLE_SEL_MASK 0x7000000000000000

/*   SH_PI_TEST_POINT_SELECT_TRIGGER_ENABLE                             */
/*   Description:  Enable trigger on bit 32 of Analyzer data            */
#define SH_PI_TEST_POINT_SELECT_TRIGGER_ENABLE_SHFT 63
#define SH_PI_TEST_POINT_SELECT_TRIGGER_ENABLE_MASK 0x8000000000000000

/* ==================================================================== */
/*              Register "SH_PI_TEST_POINT_TRIGGER_SELECT"              */
/*                     PI Test Point Trigger Select                     */
/* ==================================================================== */

#define SH_PI_TEST_POINT_TRIGGER_SELECT          0x0000000120050f80
#define SH_PI_TEST_POINT_TRIGGER_SELECT_MASK     0x7777777777777777
#define SH_PI_TEST_POINT_TRIGGER_SELECT_INIT     0x0000000000000000

/*   SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER0_CHIPLET_SEL               */
/*   Description:  Nibble 0 Chiplet select                              */
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER0_CHIPLET_SEL_SHFT 0
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER0_CHIPLET_SEL_MASK 0x0000000000000007

/*   SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER0_NIBBLE_SEL                */
/*   Description:  Nibble 0 Nibble select                               */
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER0_NIBBLE_SEL_SHFT 4
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER0_NIBBLE_SEL_MASK 0x0000000000000070

/*   SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER1_CHIPLET_SEL               */
/*   Description:  Nibble 1 Chiplet select                              */
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER1_CHIPLET_SEL_SHFT 8
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER1_CHIPLET_SEL_MASK 0x0000000000000700

/*   SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER1_NIBBLE_SEL                */
/*   Description:  Nibble 1 Nibble select                               */
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER1_NIBBLE_SEL_SHFT 12
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER1_NIBBLE_SEL_MASK 0x0000000000007000

/*   SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER2_CHIPLET_SEL               */
/*   Description:  Nibble 2 Chiplet select                              */
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER2_CHIPLET_SEL_SHFT 16
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER2_CHIPLET_SEL_MASK 0x0000000000070000

/*   SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER2_NIBBLE_SEL                */
/*   Description:  Nibble 2 Nibble select                               */
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER2_NIBBLE_SEL_SHFT 20
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER2_NIBBLE_SEL_MASK 0x0000000000700000

/*   SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER3_CHIPLET_SEL               */
/*   Description:  Nibble 3 Chiplet select                              */
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER3_CHIPLET_SEL_SHFT 24
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER3_CHIPLET_SEL_MASK 0x0000000007000000

/*   SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER3_NIBBLE_SEL                */
/*   Description:  Nibble 3 Nibble select                               */
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER3_NIBBLE_SEL_SHFT 28
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER3_NIBBLE_SEL_MASK 0x0000000070000000

/*   SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER4_CHIPLET_SEL               */
/*   Description:  Nibble 4 Chiplet select                              */
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER4_CHIPLET_SEL_SHFT 32
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER4_CHIPLET_SEL_MASK 0x0000000700000000

/*   SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER4_NIBBLE_SEL                */
/*   Description:  Nibble 4 Nibble select                               */
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER4_NIBBLE_SEL_SHFT 36
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER4_NIBBLE_SEL_MASK 0x0000007000000000

/*   SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER5_CHIPLET_SEL               */
/*   Description:  Nibble 5 Chiplet select                              */
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER5_CHIPLET_SEL_SHFT 40
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER5_CHIPLET_SEL_MASK 0x0000070000000000

/*   SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER5_NIBBLE_SEL                */
/*   Description:  Nibble 5 Nibble select                               */
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER5_NIBBLE_SEL_SHFT 44
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER5_NIBBLE_SEL_MASK 0x0000700000000000

/*   SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER6_CHIPLET_SEL               */
/*   Description:  Nibble 6 Chiplet select                              */
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER6_CHIPLET_SEL_SHFT 48
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER6_CHIPLET_SEL_MASK 0x0007000000000000

/*   SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER6_NIBBLE_SEL                */
/*   Description:  Nibble 6 Nibble select                               */
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER6_NIBBLE_SEL_SHFT 52
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER6_NIBBLE_SEL_MASK 0x0070000000000000

/*   SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER7_CHIPLET_SEL               */
/*   Description:  Nibble 7 Chiplet select                              */
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER7_CHIPLET_SEL_SHFT 56
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER7_CHIPLET_SEL_MASK 0x0700000000000000

/*   SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER7_NIBBLE_SEL                */
/*   Description:  Nibble 7 Nibble select                               */
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER7_NIBBLE_SEL_SHFT 60
#define SH_PI_TEST_POINT_TRIGGER_SELECT_TRIGGER7_NIBBLE_SEL_MASK 0x7000000000000000

/* ==================================================================== */
/*                Register "SH_PI_XN2PI_REPLY_VC_CONFIG"                */
/*             XN-to-PI Reply Virtual Channel Configuration             */
/* ==================================================================== */

#define SH_PI_XN2PI_REPLY_VC_CONFIG              0x0000000120051000
#define SH_PI_XN2PI_REPLY_VC_CONFIG_MASK         0xc000000000003fff
#define SH_PI_XN2PI_REPLY_VC_CONFIG_INIT         0x000000000000068c

/*   SH_PI_XN2PI_REPLY_VC_CONFIG_HDR_DEPTH                              */
/*   Description:  Depth of header Buffer                               */
#define SH_PI_XN2PI_REPLY_VC_CONFIG_HDR_DEPTH_SHFT 0
#define SH_PI_XN2PI_REPLY_VC_CONFIG_HDR_DEPTH_MASK 0x000000000000000f

/*   SH_PI_XN2PI_REPLY_VC_CONFIG_DATA_DEPTH                             */
/*   Description:  Number of data buffers Available                     */
#define SH_PI_XN2PI_REPLY_VC_CONFIG_DATA_DEPTH_SHFT 4
#define SH_PI_XN2PI_REPLY_VC_CONFIG_DATA_DEPTH_MASK 0x00000000000000f0

/*   SH_PI_XN2PI_REPLY_VC_CONFIG_MAX_CREDITS                            */
/*   Description:  Maximum credits from sender                          */
#define SH_PI_XN2PI_REPLY_VC_CONFIG_MAX_CREDITS_SHFT 8
#define SH_PI_XN2PI_REPLY_VC_CONFIG_MAX_CREDITS_MASK 0x0000000000003f00

/*   SH_PI_XN2PI_REPLY_VC_CONFIG_FORCE_CREDIT                           */
/*   Description:  Send an extra credit to sender                       */
#define SH_PI_XN2PI_REPLY_VC_CONFIG_FORCE_CREDIT_SHFT 62
#define SH_PI_XN2PI_REPLY_VC_CONFIG_FORCE_CREDIT_MASK 0x4000000000000000

/*   SH_PI_XN2PI_REPLY_VC_CONFIG_CAPTURE_CREDIT_STATUS                  */
/*   Description:  Capture credit and status information                */
#define SH_PI_XN2PI_REPLY_VC_CONFIG_CAPTURE_CREDIT_STATUS_SHFT 63
#define SH_PI_XN2PI_REPLY_VC_CONFIG_CAPTURE_CREDIT_STATUS_MASK 0x8000000000000000

/* ==================================================================== */
/*               Register "SH_PI_XN2PI_REQUEST_VC_CONFIG"               */
/*            XN-to-PI Request Virtual Channel Configuration            */
/* ==================================================================== */

#define SH_PI_XN2PI_REQUEST_VC_CONFIG            0x0000000120051080
#define SH_PI_XN2PI_REQUEST_VC_CONFIG_MASK       0xc000000000003fff
#define SH_PI_XN2PI_REQUEST_VC_CONFIG_INIT       0x000000000000068c

/*   SH_PI_XN2PI_REQUEST_VC_CONFIG_HDR_DEPTH                            */
/*   Description:  Depth of header Buffer                               */
#define SH_PI_XN2PI_REQUEST_VC_CONFIG_HDR_DEPTH_SHFT 0
#define SH_PI_XN2PI_REQUEST_VC_CONFIG_HDR_DEPTH_MASK 0x000000000000000f

/*   SH_PI_XN2PI_REQUEST_VC_CONFIG_DATA_DEPTH                           */
/*   Description:  Number of data buffers Available                     */
#define SH_PI_XN2PI_REQUEST_VC_CONFIG_DATA_DEPTH_SHFT 4
#define SH_PI_XN2PI_REQUEST_VC_CONFIG_DATA_DEPTH_MASK 0x00000000000000f0

/*   SH_PI_XN2PI_REQUEST_VC_CONFIG_MAX_CREDITS                          */
/*   Description:  Maximum credits from sender                          */
#define SH_PI_XN2PI_REQUEST_VC_CONFIG_MAX_CREDITS_SHFT 8
#define SH_PI_XN2PI_REQUEST_VC_CONFIG_MAX_CREDITS_MASK 0x0000000000003f00

/*   SH_PI_XN2PI_REQUEST_VC_CONFIG_FORCE_CREDIT                         */
/*   Description:  Send an extra credit to sender                       */
#define SH_PI_XN2PI_REQUEST_VC_CONFIG_FORCE_CREDIT_SHFT 62
#define SH_PI_XN2PI_REQUEST_VC_CONFIG_FORCE_CREDIT_MASK 0x4000000000000000

/*   SH_PI_XN2PI_REQUEST_VC_CONFIG_CAPTURE_CREDIT_STATUS                */
/*   Description:  Capture credit and status information                */
#define SH_PI_XN2PI_REQUEST_VC_CONFIG_CAPTURE_CREDIT_STATUS_SHFT 63
#define SH_PI_XN2PI_REQUEST_VC_CONFIG_CAPTURE_CREDIT_STATUS_MASK 0x8000000000000000

/* ==================================================================== */
/*                     Register "SH_PI_AEC_STATUS"                      */
/*                 PI Adaptive Error Correction Status                  */
/* ==================================================================== */

#define SH_PI_AEC_STATUS                         0x0000000120060000
#define SH_PI_AEC_STATUS_MASK                    0x0000000000000007
#define SH_PI_AEC_STATUS_INIT                    0x0000000000000000

/*   SH_PI_AEC_STATUS_STATE                                             */
/*   Description:  AEC State                                            */
#define SH_PI_AEC_STATUS_STATE_SHFT              0
#define SH_PI_AEC_STATUS_STATE_MASK              0x0000000000000007

/* ==================================================================== */
/*                   Register "SH_PI_AFI_FIRST_ERROR"                   */
/*                          PI AFI First Error                          */
/* ==================================================================== */

#define SH_PI_AFI_FIRST_ERROR                    0x0000000120060080
#define SH_PI_AFI_FIRST_ERROR_MASK               0x00000007ffe00180
#define SH_PI_AFI_FIRST_ERROR_INIT               0x0000000000000000

/*   SH_PI_AFI_FIRST_ERROR_FSB_SHUB_UCE                                 */
/*   Description:  An un-correctable ECC error was detected             */
#define SH_PI_AFI_FIRST_ERROR_FSB_SHUB_UCE_SHFT  7
#define SH_PI_AFI_FIRST_ERROR_FSB_SHUB_UCE_MASK  0x0000000000000080

/*   SH_PI_AFI_FIRST_ERROR_FSB_SHUB_CE                                  */
/*   Description:  A correctable ECC error was detected                 */
#define SH_PI_AFI_FIRST_ERROR_FSB_SHUB_CE_SHFT   8
#define SH_PI_AFI_FIRST_ERROR_FSB_SHUB_CE_MASK   0x0000000000000100

/*   SH_PI_AFI_FIRST_ERROR_HUNG_BUS                                     */
/*   Description:  FSB is hung                                          */
#define SH_PI_AFI_FIRST_ERROR_HUNG_BUS_SHFT      21
#define SH_PI_AFI_FIRST_ERROR_HUNG_BUS_MASK      0x0000000000200000

/*   SH_PI_AFI_FIRST_ERROR_RSP_PARITY                                   */
/*   Description:  Parity error detecte during response phase           */
#define SH_PI_AFI_FIRST_ERROR_RSP_PARITY_SHFT    22
#define SH_PI_AFI_FIRST_ERROR_RSP_PARITY_MASK    0x0000000000400000

/*   SH_PI_AFI_FIRST_ERROR_IOQ_OVERRUN                                  */
/*   Description:  Over run error detected on IOQ                       */
#define SH_PI_AFI_FIRST_ERROR_IOQ_OVERRUN_SHFT   23
#define SH_PI_AFI_FIRST_ERROR_IOQ_OVERRUN_MASK   0x0000000000800000

/*   SH_PI_AFI_FIRST_ERROR_REQ_FORMAT                                   */
/*   Description:  FSB request format not supported                     */
#define SH_PI_AFI_FIRST_ERROR_REQ_FORMAT_SHFT    24
#define SH_PI_AFI_FIRST_ERROR_REQ_FORMAT_MASK    0x0000000001000000

/*   SH_PI_AFI_FIRST_ERROR_ADDR_ACCESS                                  */
/*   Description:  Access to Address is not supported                   */
#define SH_PI_AFI_FIRST_ERROR_ADDR_ACCESS_SHFT   25
#define SH_PI_AFI_FIRST_ERROR_ADDR_ACCESS_MASK   0x0000000002000000

/*   SH_PI_AFI_FIRST_ERROR_REQ_PARITY                                   */
/*   Description:  Parity error detected during request phase           */
#define SH_PI_AFI_FIRST_ERROR_REQ_PARITY_SHFT    26
#define SH_PI_AFI_FIRST_ERROR_REQ_PARITY_MASK    0x0000000004000000

/*   SH_PI_AFI_FIRST_ERROR_ADDR_PARITY                                  */
/*   Description:  Parity error detected on address                     */
#define SH_PI_AFI_FIRST_ERROR_ADDR_PARITY_SHFT   27
#define SH_PI_AFI_FIRST_ERROR_ADDR_PARITY_MASK   0x0000000008000000

/*   SH_PI_AFI_FIRST_ERROR_SHUB_FSB_DQE                                 */
/*   Description:  SHUB_FSB_DQE                                         */
#define SH_PI_AFI_FIRST_ERROR_SHUB_FSB_DQE_SHFT  28
#define SH_PI_AFI_FIRST_ERROR_SHUB_FSB_DQE_MASK  0x0000000010000000

/*   SH_PI_AFI_FIRST_ERROR_SHUB_FSB_UCE                                 */
/*   Description:  An un-correctable ECC error was detected             */
#define SH_PI_AFI_FIRST_ERROR_SHUB_FSB_UCE_SHFT  29
#define SH_PI_AFI_FIRST_ERROR_SHUB_FSB_UCE_MASK  0x0000000020000000

/*   SH_PI_AFI_FIRST_ERROR_SHUB_FSB_CE                                  */
/*   Description:  An correctable ECC error was detected                */
#define SH_PI_AFI_FIRST_ERROR_SHUB_FSB_CE_SHFT   30
#define SH_PI_AFI_FIRST_ERROR_SHUB_FSB_CE_MASK   0x0000000040000000

/*   SH_PI_AFI_FIRST_ERROR_LIVELOCK                                     */
/*   Description:  AFI livelock error was detected                      */
#define SH_PI_AFI_FIRST_ERROR_LIVELOCK_SHFT      31
#define SH_PI_AFI_FIRST_ERROR_LIVELOCK_MASK      0x0000000080000000

/*   SH_PI_AFI_FIRST_ERROR_BAD_SNOOP                                    */
/*   Description:  AFI bad snoop error was detected                     */
#define SH_PI_AFI_FIRST_ERROR_BAD_SNOOP_SHFT     32
#define SH_PI_AFI_FIRST_ERROR_BAD_SNOOP_MASK     0x0000000100000000

/*   SH_PI_AFI_FIRST_ERROR_FSB_TBL_MISS                                 */
/*   Description:  AFI FSB request table miss error was detected        */
#define SH_PI_AFI_FIRST_ERROR_FSB_TBL_MISS_SHFT  33
#define SH_PI_AFI_FIRST_ERROR_FSB_TBL_MISS_MASK  0x0000000200000000

/*   SH_PI_AFI_FIRST_ERROR_MSG_LEN                                      */
/*   Description:  Runt or Obese message received from SIC              */
#define SH_PI_AFI_FIRST_ERROR_MSG_LEN_SHFT       34
#define SH_PI_AFI_FIRST_ERROR_MSG_LEN_MASK       0x0000000400000000

/* ==================================================================== */
/*                Register "SH_PI_CAM_ADDRESS_READ_DATA"                */
/*                    CRB CAM MMR Address Read Data                     */
/* ==================================================================== */

#define SH_PI_CAM_ADDRESS_READ_DATA              0x0000000120060100
#define SH_PI_CAM_ADDRESS_READ_DATA_MASK         0x8000ffffffffffff
#define SH_PI_CAM_ADDRESS_READ_DATA_INIT         0x0000000000000000

/*   SH_PI_CAM_ADDRESS_READ_DATA_CAM_ADDR                               */
/*   Description:  CRB CAM Address Read Data.                           */
#define SH_PI_CAM_ADDRESS_READ_DATA_CAM_ADDR_SHFT 0
#define SH_PI_CAM_ADDRESS_READ_DATA_CAM_ADDR_MASK 0x0000ffffffffffff

/*   SH_PI_CAM_ADDRESS_READ_DATA_CAM_ADDR_VAL                           */
/*   Description:  CRB CAM Address Read Data Valid.                     */
#define SH_PI_CAM_ADDRESS_READ_DATA_CAM_ADDR_VAL_SHFT 63
#define SH_PI_CAM_ADDRESS_READ_DATA_CAM_ADDR_VAL_MASK 0x8000000000000000

/* ==================================================================== */
/*                 Register "SH_PI_CAM_LPRA_READ_DATA"                  */
/*                      CRB CAM MMR LPRA Read Data                      */
/* ==================================================================== */

#define SH_PI_CAM_LPRA_READ_DATA                 0x0000000120060180
#define SH_PI_CAM_LPRA_READ_DATA_MASK            0xffffffffffffffff
#define SH_PI_CAM_LPRA_READ_DATA_INIT            0x0000000000000000

/*   SH_PI_CAM_LPRA_READ_DATA_CAM_LPRA                                  */
/*   Description:  CRB CAM LPRA read data.                              */
#define SH_PI_CAM_LPRA_READ_DATA_CAM_LPRA_SHFT   0
#define SH_PI_CAM_LPRA_READ_DATA_CAM_LPRA_MASK   0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_PI_CAM_STATE_READ_DATA"                 */
/*                     CRB CAM MMR State Read Data                      */
/* ==================================================================== */

#define SH_PI_CAM_STATE_READ_DATA                0x0000000120060200
#define SH_PI_CAM_STATE_READ_DATA_MASK           0x8003ffff0000003f
#define SH_PI_CAM_STATE_READ_DATA_INIT           0x0000000000000000

/*   SH_PI_CAM_STATE_READ_DATA_CAM_STATE                                */
/*   Description:  CRB CAM State read data.                             */
#define SH_PI_CAM_STATE_READ_DATA_CAM_STATE_SHFT 0
#define SH_PI_CAM_STATE_READ_DATA_CAM_STATE_MASK 0x000000000000000f

/*   SH_PI_CAM_STATE_READ_DATA_CAM_TO                                   */
/*   Description:  CRB CAM Time-out Status.                             */
#define SH_PI_CAM_STATE_READ_DATA_CAM_TO_SHFT    4
#define SH_PI_CAM_STATE_READ_DATA_CAM_TO_MASK    0x0000000000000010

/*   SH_PI_CAM_STATE_READ_DATA_CAM_STATE_RD_PEND                        */
/*   Description:  CRB CAM State Read Pending.                          */
#define SH_PI_CAM_STATE_READ_DATA_CAM_STATE_RD_PEND_SHFT 5
#define SH_PI_CAM_STATE_READ_DATA_CAM_STATE_RD_PEND_MASK 0x0000000000000020

/*   SH_PI_CAM_STATE_READ_DATA_CAM_LPRA                                 */
/*   Description:  CRB LPRA Overflow Data.                              */
#define SH_PI_CAM_STATE_READ_DATA_CAM_LPRA_SHFT  32
#define SH_PI_CAM_STATE_READ_DATA_CAM_LPRA_MASK  0x0003ffff00000000

/*   SH_PI_CAM_STATE_READ_DATA_CAM_RD_DATA_VAL                          */
/*   Description:  CRB CAM MMR read data is valid.                      */
#define SH_PI_CAM_STATE_READ_DATA_CAM_RD_DATA_VAL_SHFT 63
#define SH_PI_CAM_STATE_READ_DATA_CAM_RD_DATA_VAL_MASK 0x8000000000000000

/* ==================================================================== */
/*                 Register "SH_PI_CORRECTED_DETAIL_1"                  */
/*                      PI Corrected Error Detail                       */
/* ==================================================================== */

#define SH_PI_CORRECTED_DETAIL_1                 0x0000000120060280
#define SH_PI_CORRECTED_DETAIL_1_MASK            0xffffffffffffffff
#define SH_PI_CORRECTED_DETAIL_1_INIT            0x0000000000000000

/*   SH_PI_CORRECTED_DETAIL_1_ADDRESS                                   */
/*   Description:  Address of Message that logged Correctable Error     */
#define SH_PI_CORRECTED_DETAIL_1_ADDRESS_SHFT    0
#define SH_PI_CORRECTED_DETAIL_1_ADDRESS_MASK    0x0000ffffffffffff

/*   SH_PI_CORRECTED_DETAIL_1_SYNDROME                                  */
/*   Description:  Syndrome for double word data with Correctable Erro  */
#define SH_PI_CORRECTED_DETAIL_1_SYNDROME_SHFT   48
#define SH_PI_CORRECTED_DETAIL_1_SYNDROME_MASK   0x00ff000000000000

/*   SH_PI_CORRECTED_DETAIL_1_DEP                                       */
/*   Description:  DEP code for Double word in error                    */
#define SH_PI_CORRECTED_DETAIL_1_DEP_SHFT        56
#define SH_PI_CORRECTED_DETAIL_1_DEP_MASK        0xff00000000000000

/* ==================================================================== */
/*                 Register "SH_PI_CORRECTED_DETAIL_2"                  */
/*                     PI Corrected Error Detail 2                      */
/* ==================================================================== */

#define SH_PI_CORRECTED_DETAIL_2                 0x0000000120060300
#define SH_PI_CORRECTED_DETAIL_2_MASK            0xffffffffffffffff
#define SH_PI_CORRECTED_DETAIL_2_INIT            0x0000000000000000

/*   SH_PI_CORRECTED_DETAIL_2_DATA                                      */
/*   Description:  Double word data in error                            */
#define SH_PI_CORRECTED_DETAIL_2_DATA_SHFT       0
#define SH_PI_CORRECTED_DETAIL_2_DATA_MASK       0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_PI_CORRECTED_DETAIL_3"                  */
/*                     PI Corrected Error Detail 3                      */
/* ==================================================================== */

#define SH_PI_CORRECTED_DETAIL_3                 0x0000000120060380
#define SH_PI_CORRECTED_DETAIL_3_MASK            0xffffffffffffffff
#define SH_PI_CORRECTED_DETAIL_3_INIT            0x0000000000000000

/*   SH_PI_CORRECTED_DETAIL_3_ADDRESS                                   */
/*   Description:  Address of Message that logged Correctable Error     */
#define SH_PI_CORRECTED_DETAIL_3_ADDRESS_SHFT    0
#define SH_PI_CORRECTED_DETAIL_3_ADDRESS_MASK    0x0000ffffffffffff

/*   SH_PI_CORRECTED_DETAIL_3_SYNDROME                                  */
/*   Description:  Syndrome for double word data with Correctable Erro  */
#define SH_PI_CORRECTED_DETAIL_3_SYNDROME_SHFT   48
#define SH_PI_CORRECTED_DETAIL_3_SYNDROME_MASK   0x00ff000000000000

/*   SH_PI_CORRECTED_DETAIL_3_DEP                                       */
/*   Description:  DEP code for Double word in error                    */
#define SH_PI_CORRECTED_DETAIL_3_DEP_SHFT        56
#define SH_PI_CORRECTED_DETAIL_3_DEP_MASK        0xff00000000000000

/* ==================================================================== */
/*                 Register "SH_PI_CORRECTED_DETAIL_4"                  */
/*                     PI Corrected Error Detail 4                      */
/* ==================================================================== */

#define SH_PI_CORRECTED_DETAIL_4                 0x0000000120060400
#define SH_PI_CORRECTED_DETAIL_4_MASK            0xffffffffffffffff
#define SH_PI_CORRECTED_DETAIL_4_INIT            0x0000000000000000

/*   SH_PI_CORRECTED_DETAIL_4_DATA                                      */
/*   Description:  Double word data in error                            */
#define SH_PI_CORRECTED_DETAIL_4_DATA_SHFT       0
#define SH_PI_CORRECTED_DETAIL_4_DATA_MASK       0xffffffffffffffff

/* ==================================================================== */
/*                  Register "SH_PI_CRBP_FIRST_ERROR"                   */
/*                         PI CRBP First Error                          */
/* ==================================================================== */

#define SH_PI_CRBP_FIRST_ERROR                   0x0000000120060480
#define SH_PI_CRBP_FIRST_ERROR_MASK              0x00000000001fffff
#define SH_PI_CRBP_FIRST_ERROR_INIT              0x0000000000000000

/*   SH_PI_CRBP_FIRST_ERROR_FSB_PROTO_ERR                               */
/*   Description:  CRB's FSB pipe detected protocol table miss          */
#define SH_PI_CRBP_FIRST_ERROR_FSB_PROTO_ERR_SHFT 0
#define SH_PI_CRBP_FIRST_ERROR_FSB_PROTO_ERR_MASK 0x0000000000000001

/*   SH_PI_CRBP_FIRST_ERROR_GFX_RP_ERR                                  */
/*   Description:  CRB's XB pipe received a GFX error reply             */
#define SH_PI_CRBP_FIRST_ERROR_GFX_RP_ERR_SHFT   1
#define SH_PI_CRBP_FIRST_ERROR_GFX_RP_ERR_MASK   0x0000000000000002

/*   SH_PI_CRBP_FIRST_ERROR_XB_PROTO_ERR                                */
/*   Description:  CRB's XB pipe detected protocol table miss           */
#define SH_PI_CRBP_FIRST_ERROR_XB_PROTO_ERR_SHFT 2
#define SH_PI_CRBP_FIRST_ERROR_XB_PROTO_ERR_MASK 0x0000000000000004

/*   SH_PI_CRBP_FIRST_ERROR_MEM_RP_ERR                                  */
/*   Description:  CRB's XB pipe received a memory error reply message  */
#define SH_PI_CRBP_FIRST_ERROR_MEM_RP_ERR_SHFT   3
#define SH_PI_CRBP_FIRST_ERROR_MEM_RP_ERR_MASK   0x0000000000000008

/*   SH_PI_CRBP_FIRST_ERROR_PIO_RP_ERR                                  */
/*   Description:  CRB's XB pipe received a PIO error reply message     */
#define SH_PI_CRBP_FIRST_ERROR_PIO_RP_ERR_SHFT   4
#define SH_PI_CRBP_FIRST_ERROR_PIO_RP_ERR_MASK   0x0000000000000010

/*   SH_PI_CRBP_FIRST_ERROR_MEM_TO_ERR                                  */
/*   Description:  CRB's XB pipe detected a CRB time-out                */
#define SH_PI_CRBP_FIRST_ERROR_MEM_TO_ERR_SHFT   5
#define SH_PI_CRBP_FIRST_ERROR_MEM_TO_ERR_MASK   0x0000000000000020

/*   SH_PI_CRBP_FIRST_ERROR_PIO_TO_ERR                                  */
/*   Description:  CRB's XB pipe detected a PIO time-out                */
#define SH_PI_CRBP_FIRST_ERROR_PIO_TO_ERR_SHFT   6
#define SH_PI_CRBP_FIRST_ERROR_PIO_TO_ERR_MASK   0x0000000000000040

/*   SH_PI_CRBP_FIRST_ERROR_FSB_SHUB_UCE                                */
/*   Description:  An un-correctable ECC error was detected             */
#define SH_PI_CRBP_FIRST_ERROR_FSB_SHUB_UCE_SHFT 7
#define SH_PI_CRBP_FIRST_ERROR_FSB_SHUB_UCE_MASK 0x0000000000000080

/*   SH_PI_CRBP_FIRST_ERROR_FSB_SHUB_CE                                 */
/*   Description:  A correctable ECC error was detected                 */
#define SH_PI_CRBP_FIRST_ERROR_FSB_SHUB_CE_SHFT  8
#define SH_PI_CRBP_FIRST_ERROR_FSB_SHUB_CE_MASK  0x0000000000000100

/*   SH_PI_CRBP_FIRST_ERROR_MSG_COLOR_ERR                               */
/*   Description:  Message color was wrong                              */
#define SH_PI_CRBP_FIRST_ERROR_MSG_COLOR_ERR_SHFT 9
#define SH_PI_CRBP_FIRST_ERROR_MSG_COLOR_ERR_MASK 0x0000000000000200

/*   SH_PI_CRBP_FIRST_ERROR_MD_RQ_Q_OFLOW                               */
/*   Description:  MD Request input buffer over flow error              */
#define SH_PI_CRBP_FIRST_ERROR_MD_RQ_Q_OFLOW_SHFT 10
#define SH_PI_CRBP_FIRST_ERROR_MD_RQ_Q_OFLOW_MASK 0x0000000000000400

/*   SH_PI_CRBP_FIRST_ERROR_MD_RP_Q_OFLOW                               */
/*   Description:  MD Reply input buffer over flow error                */
#define SH_PI_CRBP_FIRST_ERROR_MD_RP_Q_OFLOW_SHFT 11
#define SH_PI_CRBP_FIRST_ERROR_MD_RP_Q_OFLOW_MASK 0x0000000000000800

/*   SH_PI_CRBP_FIRST_ERROR_XN_RQ_Q_OFLOW                               */
/*   Description:  XN Request input buffer over flow error              */
#define SH_PI_CRBP_FIRST_ERROR_XN_RQ_Q_OFLOW_SHFT 12
#define SH_PI_CRBP_FIRST_ERROR_XN_RQ_Q_OFLOW_MASK 0x0000000000001000

/*   SH_PI_CRBP_FIRST_ERROR_XN_RP_Q_OFLOW                               */
/*   Description:  XN Reply input buffer over flow error                */
#define SH_PI_CRBP_FIRST_ERROR_XN_RP_Q_OFLOW_SHFT 13
#define SH_PI_CRBP_FIRST_ERROR_XN_RP_Q_OFLOW_MASK 0x0000000000002000

/*   SH_PI_CRBP_FIRST_ERROR_NACK_OFLOW                                  */
/*   Description:  NACK over flow error                                 */
#define SH_PI_CRBP_FIRST_ERROR_NACK_OFLOW_SHFT   14
#define SH_PI_CRBP_FIRST_ERROR_NACK_OFLOW_MASK   0x0000000000004000

/*   SH_PI_CRBP_FIRST_ERROR_GFX_INT_0                                   */
/*   Description:  GFX transfer interrupt for CPU 0                     */
#define SH_PI_CRBP_FIRST_ERROR_GFX_INT_0_SHFT    15
#define SH_PI_CRBP_FIRST_ERROR_GFX_INT_0_MASK    0x0000000000008000

/*   SH_PI_CRBP_FIRST_ERROR_GFX_INT_1                                   */
/*   Description:  GFX transfer interrupt for CPU 1                     */
#define SH_PI_CRBP_FIRST_ERROR_GFX_INT_1_SHFT    16
#define SH_PI_CRBP_FIRST_ERROR_GFX_INT_1_MASK    0x0000000000010000

/*   SH_PI_CRBP_FIRST_ERROR_MD_RQ_CRD_OFLOW                             */
/*   Description:  MD Request Credit Overflow Error                     */
#define SH_PI_CRBP_FIRST_ERROR_MD_RQ_CRD_OFLOW_SHFT 17
#define SH_PI_CRBP_FIRST_ERROR_MD_RQ_CRD_OFLOW_MASK 0x0000000000020000

/*   SH_PI_CRBP_FIRST_ERROR_MD_RP_CRD_OFLOW                             */
/*   Description:  MD Reply Credit Overflow Error                       */
#define SH_PI_CRBP_FIRST_ERROR_MD_RP_CRD_OFLOW_SHFT 18
#define SH_PI_CRBP_FIRST_ERROR_MD_RP_CRD_OFLOW_MASK 0x0000000000040000

/*   SH_PI_CRBP_FIRST_ERROR_XN_RQ_CRD_OFLOW                             */
/*   Description:  XN Request Credit Overflow Error                     */
#define SH_PI_CRBP_FIRST_ERROR_XN_RQ_CRD_OFLOW_SHFT 19
#define SH_PI_CRBP_FIRST_ERROR_XN_RQ_CRD_OFLOW_MASK 0x0000000000080000

/*   SH_PI_CRBP_FIRST_ERROR_XN_RP_CRD_OFLOW                             */
/*   Description:  XN Reply Credit Overflow Error                       */
#define SH_PI_CRBP_FIRST_ERROR_XN_RP_CRD_OFLOW_SHFT 20
#define SH_PI_CRBP_FIRST_ERROR_XN_RP_CRD_OFLOW_MASK 0x0000000000100000

/* ==================================================================== */
/*                   Register "SH_PI_ERROR_DETAIL_1"                    */
/*                          PI Error Detail 1                           */
/* ==================================================================== */

#define SH_PI_ERROR_DETAIL_1                     0x0000000120060500
#define SH_PI_ERROR_DETAIL_1_MASK                0xffffffffffffffff
#define SH_PI_ERROR_DETAIL_1_INIT                0x0000000000000000

/*   SH_PI_ERROR_DETAIL_1_STATUS                                        */
/*   Description:  Error Detail 1                                       */
#define SH_PI_ERROR_DETAIL_1_STATUS_SHFT         0
#define SH_PI_ERROR_DETAIL_1_STATUS_MASK         0xffffffffffffffff

/* ==================================================================== */
/*                   Register "SH_PI_ERROR_DETAIL_2"                    */
/*                          PI Error Detail 2                           */
/* ==================================================================== */

#define SH_PI_ERROR_DETAIL_2                     0x0000000120060580
#define SH_PI_ERROR_DETAIL_2_MASK                0xffffffffffffffff
#define SH_PI_ERROR_DETAIL_2_INIT                0x0000000000000000

/*   SH_PI_ERROR_DETAIL_2_STATUS                                        */
/*   Description:  Error Status                                         */
#define SH_PI_ERROR_DETAIL_2_STATUS_SHFT         0
#define SH_PI_ERROR_DETAIL_2_STATUS_MASK         0xffffffffffffffff

/* ==================================================================== */
/*                   Register "SH_PI_ERROR_OVERFLOW"                    */
/*                          PI Error Overflow                           */
/* ==================================================================== */

#define SH_PI_ERROR_OVERFLOW                     0x0000000120060600
#define SH_PI_ERROR_OVERFLOW_MASK                0x00000007ffffffff
#define SH_PI_ERROR_OVERFLOW_INIT                0x0000000000000000

/*   SH_PI_ERROR_OVERFLOW_FSB_PROTO_ERR                                 */
/*   Description:  CRB's FSB pipe detected protocol table miss          */
#define SH_PI_ERROR_OVERFLOW_FSB_PROTO_ERR_SHFT  0
#define SH_PI_ERROR_OVERFLOW_FSB_PROTO_ERR_MASK  0x0000000000000001

/*   SH_PI_ERROR_OVERFLOW_GFX_RP_ERR                                    */
/*   Description:  CRB's XB pipe received another GFX reply error mess  */
#define SH_PI_ERROR_OVERFLOW_GFX_RP_ERR_SHFT     1
#define SH_PI_ERROR_OVERFLOW_GFX_RP_ERR_MASK     0x0000000000000002

/*   SH_PI_ERROR_OVERFLOW_XB_PROTO_ERR                                  */
/*   Description:  CRB's XB pipe detected another protocol table miss  */
#define SH_PI_ERROR_OVERFLOW_XB_PROTO_ERR_SHFT   2
#define SH_PI_ERROR_OVERFLOW_XB_PROTO_ERR_MASK   0x0000000000000004

/*   SH_PI_ERROR_OVERFLOW_MEM_RP_ERR                                    */
/*   Description:  CRB's XB pipe received another memory reply error m  */
#define SH_PI_ERROR_OVERFLOW_MEM_RP_ERR_SHFT     3
#define SH_PI_ERROR_OVERFLOW_MEM_RP_ERR_MASK     0x0000000000000008

/*   SH_PI_ERROR_OVERFLOW_PIO_RP_ERR                                    */
/*   Description:  CRB's XB pipe received another PIO reply error mess  */
#define SH_PI_ERROR_OVERFLOW_PIO_RP_ERR_SHFT     4
#define SH_PI_ERROR_OVERFLOW_PIO_RP_ERR_MASK     0x0000000000000010

/*   SH_PI_ERROR_OVERFLOW_MEM_TO_ERR                                    */
/*   Description:  CRB's XB pipe detected a CRB time-out                */
#define SH_PI_ERROR_OVERFLOW_MEM_TO_ERR_SHFT     5
#define SH_PI_ERROR_OVERFLOW_MEM_TO_ERR_MASK     0x0000000000000020

/*   SH_PI_ERROR_OVERFLOW_PIO_TO_ERR                                    */
/*   Description:  CRB's XB pipe detected a PIO time-out                */
#define SH_PI_ERROR_OVERFLOW_PIO_TO_ERR_SHFT     6
#define SH_PI_ERROR_OVERFLOW_PIO_TO_ERR_MASK     0x0000000000000040

/*   SH_PI_ERROR_OVERFLOW_FSB_SHUB_UCE                                  */
/*   Description:  An un-correctable ECC error was detected             */
#define SH_PI_ERROR_OVERFLOW_FSB_SHUB_UCE_SHFT   7
#define SH_PI_ERROR_OVERFLOW_FSB_SHUB_UCE_MASK   0x0000000000000080

/*   SH_PI_ERROR_OVERFLOW_FSB_SHUB_CE                                   */
/*   Description:  An correctable ECC error was detected                */
#define SH_PI_ERROR_OVERFLOW_FSB_SHUB_CE_SHFT    8
#define SH_PI_ERROR_OVERFLOW_FSB_SHUB_CE_MASK    0x0000000000000100

/*   SH_PI_ERROR_OVERFLOW_MSG_COLOR_ERR                                 */
/*   Description:  Message color was not correct                        */
#define SH_PI_ERROR_OVERFLOW_MSG_COLOR_ERR_SHFT  9
#define SH_PI_ERROR_OVERFLOW_MSG_COLOR_ERR_MASK  0x0000000000000200

/*   SH_PI_ERROR_OVERFLOW_MD_RQ_Q_OFLOW                                 */
/*   Description:  MD Request input buffer over flow error              */
#define SH_PI_ERROR_OVERFLOW_MD_RQ_Q_OFLOW_SHFT  10
#define SH_PI_ERROR_OVERFLOW_MD_RQ_Q_OFLOW_MASK  0x0000000000000400

/*   SH_PI_ERROR_OVERFLOW_MD_RP_Q_OFLOW                                 */
/*   Description:  MD Reply input buffer over flow error                */
#define SH_PI_ERROR_OVERFLOW_MD_RP_Q_OFLOW_SHFT  11
#define SH_PI_ERROR_OVERFLOW_MD_RP_Q_OFLOW_MASK  0x0000000000000800

/*   SH_PI_ERROR_OVERFLOW_XN_RQ_Q_OFLOW                                 */
/*   Description:  XN Request input buffer over flow error              */
#define SH_PI_ERROR_OVERFLOW_XN_RQ_Q_OFLOW_SHFT  12
#define SH_PI_ERROR_OVERFLOW_XN_RQ_Q_OFLOW_MASK  0x0000000000001000

/*   SH_PI_ERROR_OVERFLOW_XN_RP_Q_OFLOW                                 */
/*   Description:  XN Reply input buffer over flow error                */
#define SH_PI_ERROR_OVERFLOW_XN_RP_Q_OFLOW_SHFT  13
#define SH_PI_ERROR_OVERFLOW_XN_RP_Q_OFLOW_MASK  0x0000000000002000

/*   SH_PI_ERROR_OVERFLOW_NACK_OFLOW                                    */
/*   Description:  NACK over flow error                                 */
#define SH_PI_ERROR_OVERFLOW_NACK_OFLOW_SHFT     14
#define SH_PI_ERROR_OVERFLOW_NACK_OFLOW_MASK     0x0000000000004000

/*   SH_PI_ERROR_OVERFLOW_GFX_INT_0                                     */
/*   Description:  GFX transfer interrupt for CPU 0                     */
#define SH_PI_ERROR_OVERFLOW_GFX_INT_0_SHFT      15
#define SH_PI_ERROR_OVERFLOW_GFX_INT_0_MASK      0x0000000000008000

/*   SH_PI_ERROR_OVERFLOW_GFX_INT_1                                     */
/*   Description:  GFX transfer interrupt for CPU 1                     */
#define SH_PI_ERROR_OVERFLOW_GFX_INT_1_SHFT      16
#define SH_PI_ERROR_OVERFLOW_GFX_INT_1_MASK      0x0000000000010000

/*   SH_PI_ERROR_OVERFLOW_MD_RQ_CRD_OFLOW                               */
/*   Description:  MD Request Credit Overflow Error                     */
#define SH_PI_ERROR_OVERFLOW_MD_RQ_CRD_OFLOW_SHFT 17
#define SH_PI_ERROR_OVERFLOW_MD_RQ_CRD_OFLOW_MASK 0x0000000000020000

/*   SH_PI_ERROR_OVERFLOW_MD_RP_CRD_OFLOW                               */
/*   Description:  MD Reply Credit Overflow Error                       */
#define SH_PI_ERROR_OVERFLOW_MD_RP_CRD_OFLOW_SHFT 18
#define SH_PI_ERROR_OVERFLOW_MD_RP_CRD_OFLOW_MASK 0x0000000000040000

/*   SH_PI_ERROR_OVERFLOW_XN_RQ_CRD_OFLOW                               */
/*   Description:  XN Request Credit Overflow Error                     */
#define SH_PI_ERROR_OVERFLOW_XN_RQ_CRD_OFLOW_SHFT 19
#define SH_PI_ERROR_OVERFLOW_XN_RQ_CRD_OFLOW_MASK 0x0000000000080000

/*   SH_PI_ERROR_OVERFLOW_XN_RP_CRD_OFLOW                               */
/*   Description:  XN Reply Credit Overflow Error                       */
#define SH_PI_ERROR_OVERFLOW_XN_RP_CRD_OFLOW_SHFT 20
#define SH_PI_ERROR_OVERFLOW_XN_RP_CRD_OFLOW_MASK 0x0000000000100000

/*   SH_PI_ERROR_OVERFLOW_HUNG_BUS                                      */
/*   Description:  FSB is hung                                          */
#define SH_PI_ERROR_OVERFLOW_HUNG_BUS_SHFT       21
#define SH_PI_ERROR_OVERFLOW_HUNG_BUS_MASK       0x0000000000200000

/*   SH_PI_ERROR_OVERFLOW_RSP_PARITY                                    */
/*   Description:  Parity error detecte during response phase           */
#define SH_PI_ERROR_OVERFLOW_RSP_PARITY_SHFT     22
#define SH_PI_ERROR_OVERFLOW_RSP_PARITY_MASK     0x0000000000400000

/*   SH_PI_ERROR_OVERFLOW_IOQ_OVERRUN                                   */
/*   Description:  Over run error detected on IOQ                       */
#define SH_PI_ERROR_OVERFLOW_IOQ_OVERRUN_SHFT    23
#define SH_PI_ERROR_OVERFLOW_IOQ_OVERRUN_MASK    0x0000000000800000

/*   SH_PI_ERROR_OVERFLOW_REQ_FORMAT                                    */
/*   Description:  FSB request format not supported                     */
#define SH_PI_ERROR_OVERFLOW_REQ_FORMAT_SHFT     24
#define SH_PI_ERROR_OVERFLOW_REQ_FORMAT_MASK     0x0000000001000000

/*   SH_PI_ERROR_OVERFLOW_ADDR_ACCESS                                   */
/*   Description:  Access to Address is not supported                   */
#define SH_PI_ERROR_OVERFLOW_ADDR_ACCESS_SHFT    25
#define SH_PI_ERROR_OVERFLOW_ADDR_ACCESS_MASK    0x0000000002000000

/*   SH_PI_ERROR_OVERFLOW_REQ_PARITY                                    */
/*   Description:  Parity error detected during request phase           */
#define SH_PI_ERROR_OVERFLOW_REQ_PARITY_SHFT     26
#define SH_PI_ERROR_OVERFLOW_REQ_PARITY_MASK     0x0000000004000000

/*   SH_PI_ERROR_OVERFLOW_ADDR_PARITY                                   */
/*   Description:  Parity error detected on address                     */
#define SH_PI_ERROR_OVERFLOW_ADDR_PARITY_SHFT    27
#define SH_PI_ERROR_OVERFLOW_ADDR_PARITY_MASK    0x0000000008000000

/*   SH_PI_ERROR_OVERFLOW_SHUB_FSB_DQE                                  */
/*   Description:  SHUB_FSB_DQE                                         */
#define SH_PI_ERROR_OVERFLOW_SHUB_FSB_DQE_SHFT   28
#define SH_PI_ERROR_OVERFLOW_SHUB_FSB_DQE_MASK   0x0000000010000000

/*   SH_PI_ERROR_OVERFLOW_SHUB_FSB_UCE                                  */
/*   Description:  An un-correctable ECC error was detected             */
#define SH_PI_ERROR_OVERFLOW_SHUB_FSB_UCE_SHFT   29
#define SH_PI_ERROR_OVERFLOW_SHUB_FSB_UCE_MASK   0x0000000020000000

/*   SH_PI_ERROR_OVERFLOW_SHUB_FSB_CE                                   */
/*   Description:  An correctable ECC error was detected                */
#define SH_PI_ERROR_OVERFLOW_SHUB_FSB_CE_SHFT    30
#define SH_PI_ERROR_OVERFLOW_SHUB_FSB_CE_MASK    0x0000000040000000

/*   SH_PI_ERROR_OVERFLOW_LIVELOCK                                      */
/*   Description:  AFI livelock error was detected                      */
#define SH_PI_ERROR_OVERFLOW_LIVELOCK_SHFT       31
#define SH_PI_ERROR_OVERFLOW_LIVELOCK_MASK       0x0000000080000000

/*   SH_PI_ERROR_OVERFLOW_BAD_SNOOP                                     */
/*   Description:  AFI bad snoop error was detected                     */
#define SH_PI_ERROR_OVERFLOW_BAD_SNOOP_SHFT      32
#define SH_PI_ERROR_OVERFLOW_BAD_SNOOP_MASK      0x0000000100000000

/*   SH_PI_ERROR_OVERFLOW_FSB_TBL_MISS                                  */
/*   Description:  AFI FSB request table miss error was detected        */
#define SH_PI_ERROR_OVERFLOW_FSB_TBL_MISS_SHFT   33
#define SH_PI_ERROR_OVERFLOW_FSB_TBL_MISS_MASK   0x0000000200000000

/*   SH_PI_ERROR_OVERFLOW_MSG_LENGTH                                    */
/*   Description:  Message length error on received message from SIC    */
#define SH_PI_ERROR_OVERFLOW_MSG_LENGTH_SHFT     34
#define SH_PI_ERROR_OVERFLOW_MSG_LENGTH_MASK     0x0000000400000000

/* ==================================================================== */
/*                Register "SH_PI_ERROR_OVERFLOW_ALIAS"                 */
/*                       PI Error Overflow Alias                        */
/* ==================================================================== */

#define SH_PI_ERROR_OVERFLOW_ALIAS               0x0000000120060608

/* ==================================================================== */
/*                    Register "SH_PI_ERROR_SUMMARY"                    */
/*                           PI Error Summary                           */
/* ==================================================================== */

#define SH_PI_ERROR_SUMMARY                      0x0000000120060680
#define SH_PI_ERROR_SUMMARY_MASK                 0x00000007ffffffff
#define SH_PI_ERROR_SUMMARY_INIT                 0x0000000000000000

/*   SH_PI_ERROR_SUMMARY_FSB_PROTO_ERR                                  */
/*   Description:  CRB's FSB pipe detected protocol table miss          */
#define SH_PI_ERROR_SUMMARY_FSB_PROTO_ERR_SHFT   0
#define SH_PI_ERROR_SUMMARY_FSB_PROTO_ERR_MASK   0x0000000000000001

/*   SH_PI_ERROR_SUMMARY_GFX_RP_ERR                                     */
/*   Description:  Graphic reply error message received                 */
#define SH_PI_ERROR_SUMMARY_GFX_RP_ERR_SHFT      1
#define SH_PI_ERROR_SUMMARY_GFX_RP_ERR_MASK      0x0000000000000002

/*   SH_PI_ERROR_SUMMARY_XB_PROTO_ERR                                   */
/*   Description:  CRB's XB pipe detected protocol table miss           */
#define SH_PI_ERROR_SUMMARY_XB_PROTO_ERR_SHFT    2
#define SH_PI_ERROR_SUMMARY_XB_PROTO_ERR_MASK    0x0000000000000004

/*   SH_PI_ERROR_SUMMARY_MEM_RP_ERR                                     */
/*   Description:  Memory reply error message received                  */
#define SH_PI_ERROR_SUMMARY_MEM_RP_ERR_SHFT      3
#define SH_PI_ERROR_SUMMARY_MEM_RP_ERR_MASK      0x0000000000000008

/*   SH_PI_ERROR_SUMMARY_PIO_RP_ERR                                     */
/*   Description:  PIO error reply message received                     */
#define SH_PI_ERROR_SUMMARY_PIO_RP_ERR_SHFT      4
#define SH_PI_ERROR_SUMMARY_PIO_RP_ERR_MASK      0x0000000000000010

/*   SH_PI_ERROR_SUMMARY_MEM_TO_ERR                                     */
/*   Description:  CRB's XB pipe detected a CRB time-out                */
#define SH_PI_ERROR_SUMMARY_MEM_TO_ERR_SHFT      5
#define SH_PI_ERROR_SUMMARY_MEM_TO_ERR_MASK      0x0000000000000020

/*   SH_PI_ERROR_SUMMARY_PIO_TO_ERR                                     */
/*   Description:  CRB's XB pipe detected a PIO time-out                */
#define SH_PI_ERROR_SUMMARY_PIO_TO_ERR_SHFT      6
#define SH_PI_ERROR_SUMMARY_PIO_TO_ERR_MASK      0x0000000000000040

/*   SH_PI_ERROR_SUMMARY_FSB_SHUB_UCE                                   */
/*   Description:  An un-correctable ECC error was detected             */
#define SH_PI_ERROR_SUMMARY_FSB_SHUB_UCE_SHFT    7
#define SH_PI_ERROR_SUMMARY_FSB_SHUB_UCE_MASK    0x0000000000000080

/*   SH_PI_ERROR_SUMMARY_FSB_SHUB_CE                                    */
/*   Description:  An correctable ECC error was detected                */
#define SH_PI_ERROR_SUMMARY_FSB_SHUB_CE_SHFT     8
#define SH_PI_ERROR_SUMMARY_FSB_SHUB_CE_MASK     0x0000000000000100

/*   SH_PI_ERROR_SUMMARY_MSG_COLOR_ERR                                  */
/*   Description:  Message color was wrong                              */
#define SH_PI_ERROR_SUMMARY_MSG_COLOR_ERR_SHFT   9
#define SH_PI_ERROR_SUMMARY_MSG_COLOR_ERR_MASK   0x0000000000000200

/*   SH_PI_ERROR_SUMMARY_MD_RQ_Q_OFLOW                                  */
/*   Description:  MD Request input buffer over flow error              */
#define SH_PI_ERROR_SUMMARY_MD_RQ_Q_OFLOW_SHFT   10
#define SH_PI_ERROR_SUMMARY_MD_RQ_Q_OFLOW_MASK   0x0000000000000400

/*   SH_PI_ERROR_SUMMARY_MD_RP_Q_OFLOW                                  */
/*   Description:  MD Reply input buffer over flow error                */
#define SH_PI_ERROR_SUMMARY_MD_RP_Q_OFLOW_SHFT   11
#define SH_PI_ERROR_SUMMARY_MD_RP_Q_OFLOW_MASK   0x0000000000000800

/*   SH_PI_ERROR_SUMMARY_XN_RQ_Q_OFLOW                                  */
/*   Description:  XN Request input buffer over flow error              */
#define SH_PI_ERROR_SUMMARY_XN_RQ_Q_OFLOW_SHFT   12
#define SH_PI_ERROR_SUMMARY_XN_RQ_Q_OFLOW_MASK   0x0000000000001000

/*   SH_PI_ERROR_SUMMARY_XN_RP_Q_OFLOW                                  */
/*   Description:  XN Reply input buffer over flow error                */
#define SH_PI_ERROR_SUMMARY_XN_RP_Q_OFLOW_SHFT   13
#define SH_PI_ERROR_SUMMARY_XN_RP_Q_OFLOW_MASK   0x0000000000002000

/*   SH_PI_ERROR_SUMMARY_NACK_OFLOW                                     */
/*   Description:  NACK over flow error                                 */
#define SH_PI_ERROR_SUMMARY_NACK_OFLOW_SHFT      14
#define SH_PI_ERROR_SUMMARY_NACK_OFLOW_MASK      0x0000000000004000

/*   SH_PI_ERROR_SUMMARY_GFX_INT_0                                      */
/*   Description:  GFX transfer interrupt for CPU 0                     */
#define SH_PI_ERROR_SUMMARY_GFX_INT_0_SHFT       15
#define SH_PI_ERROR_SUMMARY_GFX_INT_0_MASK       0x0000000000008000

/*   SH_PI_ERROR_SUMMARY_GFX_INT_1                                      */
/*   Description:  GFX transfer interrupt for CPU 1                     */
#define SH_PI_ERROR_SUMMARY_GFX_INT_1_SHFT       16
#define SH_PI_ERROR_SUMMARY_GFX_INT_1_MASK       0x0000000000010000

/*   SH_PI_ERROR_SUMMARY_MD_RQ_CRD_OFLOW                                */
/*   Description:  MD Request Credit Overflow Error                     */
#define SH_PI_ERROR_SUMMARY_MD_RQ_CRD_OFLOW_SHFT 17
#define SH_PI_ERROR_SUMMARY_MD_RQ_CRD_OFLOW_MASK 0x0000000000020000

/*   SH_PI_ERROR_SUMMARY_MD_RP_CRD_OFLOW                                */
/*   Description:  MD Reply Credit Overflow Error                       */
#define SH_PI_ERROR_SUMMARY_MD_RP_CRD_OFLOW_SHFT 18
#define SH_PI_ERROR_SUMMARY_MD_RP_CRD_OFLOW_MASK 0x0000000000040000

/*   SH_PI_ERROR_SUMMARY_XN_RQ_CRD_OFLOW                                */
/*   Description:  XN Request Credit Overflow Error                     */
#define SH_PI_ERROR_SUMMARY_XN_RQ_CRD_OFLOW_SHFT 19
#define SH_PI_ERROR_SUMMARY_XN_RQ_CRD_OFLOW_MASK 0x0000000000080000

/*   SH_PI_ERROR_SUMMARY_XN_RP_CRD_OFLOW                                */
/*   Description:  XN Reply Credit Overflow Error                       */
#define SH_PI_ERROR_SUMMARY_XN_RP_CRD_OFLOW_SHFT 20
#define SH_PI_ERROR_SUMMARY_XN_RP_CRD_OFLOW_MASK 0x0000000000100000

/*   SH_PI_ERROR_SUMMARY_HUNG_BUS                                       */
/*   Description:  FSB is hung                                          */
#define SH_PI_ERROR_SUMMARY_HUNG_BUS_SHFT        21
#define SH_PI_ERROR_SUMMARY_HUNG_BUS_MASK        0x0000000000200000

/*   SH_PI_ERROR_SUMMARY_RSP_PARITY                                     */
/*   Description:  Parity error detecte during response phase           */
#define SH_PI_ERROR_SUMMARY_RSP_PARITY_SHFT      22
#define SH_PI_ERROR_SUMMARY_RSP_PARITY_MASK      0x0000000000400000

/*   SH_PI_ERROR_SUMMARY_IOQ_OVERRUN                                    */
/*   Description:  Over run error detected on IOQ                       */
#define SH_PI_ERROR_SUMMARY_IOQ_OVERRUN_SHFT     23
#define SH_PI_ERROR_SUMMARY_IOQ_OVERRUN_MASK     0x0000000000800000

/*   SH_PI_ERROR_SUMMARY_REQ_FORMAT                                     */
/*   Description:  FSB request format not supported                     */
#define SH_PI_ERROR_SUMMARY_REQ_FORMAT_SHFT      24
#define SH_PI_ERROR_SUMMARY_REQ_FORMAT_MASK      0x0000000001000000

/*   SH_PI_ERROR_SUMMARY_ADDR_ACCESS                                    */
/*   Description:  Access to Address is not supported                   */
#define SH_PI_ERROR_SUMMARY_ADDR_ACCESS_SHFT     25
#define SH_PI_ERROR_SUMMARY_ADDR_ACCESS_MASK     0x0000000002000000

/*   SH_PI_ERROR_SUMMARY_REQ_PARITY                                     */
/*   Description:  Parity error detected during request phase           */
#define SH_PI_ERROR_SUMMARY_REQ_PARITY_SHFT      26
#define SH_PI_ERROR_SUMMARY_REQ_PARITY_MASK      0x0000000004000000

/*   SH_PI_ERROR_SUMMARY_ADDR_PARITY                                    */
/*   Description:  Parity error detected on address                     */
#define SH_PI_ERROR_SUMMARY_ADDR_PARITY_SHFT     27
#define SH_PI_ERROR_SUMMARY_ADDR_PARITY_MASK     0x0000000008000000

/*   SH_PI_ERROR_SUMMARY_SHUB_FSB_DQE                                   */
/*   Description:  SHUB_FSB_DQE error                                   */
#define SH_PI_ERROR_SUMMARY_SHUB_FSB_DQE_SHFT    28
#define SH_PI_ERROR_SUMMARY_SHUB_FSB_DQE_MASK    0x0000000010000000

/*   SH_PI_ERROR_SUMMARY_SHUB_FSB_UCE                                   */
/*   Description:  An un-correctable ECC error was detected             */
#define SH_PI_ERROR_SUMMARY_SHUB_FSB_UCE_SHFT    29
#define SH_PI_ERROR_SUMMARY_SHUB_FSB_UCE_MASK    0x0000000020000000

/*   SH_PI_ERROR_SUMMARY_SHUB_FSB_CE                                    */
/*   Description:  An correctable ECC error was detected                */
#define SH_PI_ERROR_SUMMARY_SHUB_FSB_CE_SHFT     30
#define SH_PI_ERROR_SUMMARY_SHUB_FSB_CE_MASK     0x0000000040000000

/*   SH_PI_ERROR_SUMMARY_LIVELOCK                                       */
/*   Description:  AFI livelock error was detected                      */
#define SH_PI_ERROR_SUMMARY_LIVELOCK_SHFT        31
#define SH_PI_ERROR_SUMMARY_LIVELOCK_MASK        0x0000000080000000

/*   SH_PI_ERROR_SUMMARY_BAD_SNOOP                                      */
/*   Description:  AFI bad snoop error was detected                     */
#define SH_PI_ERROR_SUMMARY_BAD_SNOOP_SHFT       32
#define SH_PI_ERROR_SUMMARY_BAD_SNOOP_MASK       0x0000000100000000

/*   SH_PI_ERROR_SUMMARY_FSB_TBL_MISS                                   */
/*   Description:  AFI FSB request table miss error was detected        */
#define SH_PI_ERROR_SUMMARY_FSB_TBL_MISS_SHFT    33
#define SH_PI_ERROR_SUMMARY_FSB_TBL_MISS_MASK    0x0000000200000000

/*   SH_PI_ERROR_SUMMARY_MSG_LENGTH                                     */
/*   Description:  Message length error on received message from SIC    */
#define SH_PI_ERROR_SUMMARY_MSG_LENGTH_SHFT      34
#define SH_PI_ERROR_SUMMARY_MSG_LENGTH_MASK      0x0000000400000000

/* ==================================================================== */
/*                 Register "SH_PI_ERROR_SUMMARY_ALIAS"                 */
/*                        PI Error Summary Alias                        */
/* ==================================================================== */

#define SH_PI_ERROR_SUMMARY_ALIAS                0x0000000120060688

/* ==================================================================== */
/*                Register "SH_PI_EXPRESS_REPLY_STATUS"                 */
/*                       PI Express Reply Status                        */
/* ==================================================================== */

#define SH_PI_EXPRESS_REPLY_STATUS               0x0000000120060700
#define SH_PI_EXPRESS_REPLY_STATUS_MASK          0x0000000000000007
#define SH_PI_EXPRESS_REPLY_STATUS_INIT          0x0000000000000000

/*   SH_PI_EXPRESS_REPLY_STATUS_STATE                                   */
/*   Description:  Express Reply State                                  */
#define SH_PI_EXPRESS_REPLY_STATUS_STATE_SHFT    0
#define SH_PI_EXPRESS_REPLY_STATUS_STATE_MASK    0x0000000000000007

/* ==================================================================== */
/*                     Register "SH_PI_FIRST_ERROR"                     */
/*                            PI First Error                            */
/* ==================================================================== */

#define SH_PI_FIRST_ERROR                        0x0000000120060780
#define SH_PI_FIRST_ERROR_MASK                   0x00000007ffffffff
#define SH_PI_FIRST_ERROR_INIT                   0x0000000000000000

/*   SH_PI_FIRST_ERROR_FSB_PROTO_ERR                                    */
/*   Description:  CRB's FSB pipe detected protocol table miss          */
#define SH_PI_FIRST_ERROR_FSB_PROTO_ERR_SHFT     0
#define SH_PI_FIRST_ERROR_FSB_PROTO_ERR_MASK     0x0000000000000001

/*   SH_PI_FIRST_ERROR_GFX_RP_ERR                                       */
/*   Description:  Graphics error reply message received                */
#define SH_PI_FIRST_ERROR_GFX_RP_ERR_SHFT        1
#define SH_PI_FIRST_ERROR_GFX_RP_ERR_MASK        0x0000000000000002

/*   SH_PI_FIRST_ERROR_XB_PROTO_ERR                                     */
/*   Description:  CRB's XB pipe detected protocol table miss           */
#define SH_PI_FIRST_ERROR_XB_PROTO_ERR_SHFT      2
#define SH_PI_FIRST_ERROR_XB_PROTO_ERR_MASK      0x0000000000000004

/*   SH_PI_FIRST_ERROR_MEM_RP_ERR                                       */
/*   Description:  Memory reply error message received                  */
#define SH_PI_FIRST_ERROR_MEM_RP_ERR_SHFT        3
#define SH_PI_FIRST_ERROR_MEM_RP_ERR_MASK        0x0000000000000008

/*   SH_PI_FIRST_ERROR_PIO_RP_ERR                                       */
/*   Description:  PIO reply error message received                     */
#define SH_PI_FIRST_ERROR_PIO_RP_ERR_SHFT        4
#define SH_PI_FIRST_ERROR_PIO_RP_ERR_MASK        0x0000000000000010

/*   SH_PI_FIRST_ERROR_MEM_TO_ERR                                       */
/*   Description:  CRB's XB pipe detected a CRB time-out                */
#define SH_PI_FIRST_ERROR_MEM_TO_ERR_SHFT        5
#define SH_PI_FIRST_ERROR_MEM_TO_ERR_MASK        0x0000000000000020

/*   SH_PI_FIRST_ERROR_PIO_TO_ERR                                       */
/*   Description:  CRB's XB pipe detected a PIO time-out                */
#define SH_PI_FIRST_ERROR_PIO_TO_ERR_SHFT        6
#define SH_PI_FIRST_ERROR_PIO_TO_ERR_MASK        0x0000000000000040

/*   SH_PI_FIRST_ERROR_FSB_SHUB_UCE                                     */
/*   Description:  An un-correctable ECC error was detected             */
#define SH_PI_FIRST_ERROR_FSB_SHUB_UCE_SHFT      7
#define SH_PI_FIRST_ERROR_FSB_SHUB_UCE_MASK      0x0000000000000080

/*   SH_PI_FIRST_ERROR_FSB_SHUB_CE                                      */
/*   Description:  A correctable ECC error was detected                 */
#define SH_PI_FIRST_ERROR_FSB_SHUB_CE_SHFT       8
#define SH_PI_FIRST_ERROR_FSB_SHUB_CE_MASK       0x0000000000000100

/*   SH_PI_FIRST_ERROR_MSG_COLOR_ERR                                    */
/*   Description:  Message color was wrong                              */
#define SH_PI_FIRST_ERROR_MSG_COLOR_ERR_SHFT     9
#define SH_PI_FIRST_ERROR_MSG_COLOR_ERR_MASK     0x0000000000000200

/*   SH_PI_FIRST_ERROR_MD_RQ_Q_OFLOW                                    */
/*   Description:  MD Request input buffer over flow error              */
#define SH_PI_FIRST_ERROR_MD_RQ_Q_OFLOW_SHFT     10
#define SH_PI_FIRST_ERROR_MD_RQ_Q_OFLOW_MASK     0x0000000000000400

/*   SH_PI_FIRST_ERROR_MD_RP_Q_OFLOW                                    */
/*   Description:  MD Reply input buffer over flow error                */
#define SH_PI_FIRST_ERROR_MD_RP_Q_OFLOW_SHFT     11
#define SH_PI_FIRST_ERROR_MD_RP_Q_OFLOW_MASK     0x0000000000000800

/*   SH_PI_FIRST_ERROR_XN_RQ_Q_OFLOW                                    */
/*   Description:  XN Request input buffer over flow error              */
#define SH_PI_FIRST_ERROR_XN_RQ_Q_OFLOW_SHFT     12
#define SH_PI_FIRST_ERROR_XN_RQ_Q_OFLOW_MASK     0x0000000000001000

/*   SH_PI_FIRST_ERROR_XN_RP_Q_OFLOW                                    */
/*   Description:  XN Reply input buffer over flow error                */
#define SH_PI_FIRST_ERROR_XN_RP_Q_OFLOW_SHFT     13
#define SH_PI_FIRST_ERROR_XN_RP_Q_OFLOW_MASK     0x0000000000002000

/*   SH_PI_FIRST_ERROR_NACK_OFLOW                                       */
/*   Description:  NACK over flow error                                 */
#define SH_PI_FIRST_ERROR_NACK_OFLOW_SHFT        14
#define SH_PI_FIRST_ERROR_NACK_OFLOW_MASK        0x0000000000004000

/*   SH_PI_FIRST_ERROR_GFX_INT_0                                        */
/*   Description:  GFX transfer interrupt for CPU 0                     */
#define SH_PI_FIRST_ERROR_GFX_INT_0_SHFT         15
#define SH_PI_FIRST_ERROR_GFX_INT_0_MASK         0x0000000000008000

/*   SH_PI_FIRST_ERROR_GFX_INT_1                                        */
/*   Description:  GFX transfer interrupt for CPU 1                     */
#define SH_PI_FIRST_ERROR_GFX_INT_1_SHFT         16
#define SH_PI_FIRST_ERROR_GFX_INT_1_MASK         0x0000000000010000

/*   SH_PI_FIRST_ERROR_MD_RQ_CRD_OFLOW                                  */
/*   Description:  MD Request Credit Overflow Error                     */
#define SH_PI_FIRST_ERROR_MD_RQ_CRD_OFLOW_SHFT   17
#define SH_PI_FIRST_ERROR_MD_RQ_CRD_OFLOW_MASK   0x0000000000020000

/*   SH_PI_FIRST_ERROR_MD_RP_CRD_OFLOW                                  */
/*   Description:  MD Reply Credit Overflow Error                       */
#define SH_PI_FIRST_ERROR_MD_RP_CRD_OFLOW_SHFT   18
#define SH_PI_FIRST_ERROR_MD_RP_CRD_OFLOW_MASK   0x0000000000040000

/*   SH_PI_FIRST_ERROR_XN_RQ_CRD_OFLOW                                  */
/*   Description:  XN Request Credit Overflow Error                     */
#define SH_PI_FIRST_ERROR_XN_RQ_CRD_OFLOW_SHFT   19
#define SH_PI_FIRST_ERROR_XN_RQ_CRD_OFLOW_MASK   0x0000000000080000

/*   SH_PI_FIRST_ERROR_XN_RP_CRD_OFLOW                                  */
/*   Description:  XN Reply Credit Overflow Error                       */
#define SH_PI_FIRST_ERROR_XN_RP_CRD_OFLOW_SHFT   20
#define SH_PI_FIRST_ERROR_XN_RP_CRD_OFLOW_MASK   0x0000000000100000

/*   SH_PI_FIRST_ERROR_HUNG_BUS                                         */
/*   Description:  FSB is hung                                          */
#define SH_PI_FIRST_ERROR_HUNG_BUS_SHFT          21
#define SH_PI_FIRST_ERROR_HUNG_BUS_MASK          0x0000000000200000

/*   SH_PI_FIRST_ERROR_RSP_PARITY                                       */
/*   Description:  Parity error detecte during response phase           */
#define SH_PI_FIRST_ERROR_RSP_PARITY_SHFT        22
#define SH_PI_FIRST_ERROR_RSP_PARITY_MASK        0x0000000000400000

/*   SH_PI_FIRST_ERROR_IOQ_OVERRUN                                      */
/*   Description:  Over run error detected on IOQ                       */
#define SH_PI_FIRST_ERROR_IOQ_OVERRUN_SHFT       23
#define SH_PI_FIRST_ERROR_IOQ_OVERRUN_MASK       0x0000000000800000

/*   SH_PI_FIRST_ERROR_REQ_FORMAT                                       */
/*   Description:  FSB request format not supported                     */
#define SH_PI_FIRST_ERROR_REQ_FORMAT_SHFT        24
#define SH_PI_FIRST_ERROR_REQ_FORMAT_MASK        0x0000000001000000

/*   SH_PI_FIRST_ERROR_ADDR_ACCESS                                      */
/*   Description:  Access to Address is not supported                   */
#define SH_PI_FIRST_ERROR_ADDR_ACCESS_SHFT       25
#define SH_PI_FIRST_ERROR_ADDR_ACCESS_MASK       0x0000000002000000

/*   SH_PI_FIRST_ERROR_REQ_PARITY                                       */
/*   Description:  Parity error detected during request phase           */
#define SH_PI_FIRST_ERROR_REQ_PARITY_SHFT        26
#define SH_PI_FIRST_ERROR_REQ_PARITY_MASK        0x0000000004000000

/*   SH_PI_FIRST_ERROR_ADDR_PARITY                                      */
/*   Description:  Parity error detected on address                     */
#define SH_PI_FIRST_ERROR_ADDR_PARITY_SHFT       27
#define SH_PI_FIRST_ERROR_ADDR_PARITY_MASK       0x0000000008000000

/*   SH_PI_FIRST_ERROR_SHUB_FSB_DQE                                     */
/*   Description:  SHUB_FSB_DQE                                         */
#define SH_PI_FIRST_ERROR_SHUB_FSB_DQE_SHFT      28
#define SH_PI_FIRST_ERROR_SHUB_FSB_DQE_MASK      0x0000000010000000

/*   SH_PI_FIRST_ERROR_SHUB_FSB_UCE                                     */
/*   Description:  An un-correctable ECC error was detected             */
#define SH_PI_FIRST_ERROR_SHUB_FSB_UCE_SHFT      29
#define SH_PI_FIRST_ERROR_SHUB_FSB_UCE_MASK      0x0000000020000000

/*   SH_PI_FIRST_ERROR_SHUB_FSB_CE                                      */
/*   Description:  An correctable ECC error was detected                */
#define SH_PI_FIRST_ERROR_SHUB_FSB_CE_SHFT       30
#define SH_PI_FIRST_ERROR_SHUB_FSB_CE_MASK       0x0000000040000000

/*   SH_PI_FIRST_ERROR_LIVELOCK                                         */
/*   Description:  AFI livelock error was detected                      */
#define SH_PI_FIRST_ERROR_LIVELOCK_SHFT          31
#define SH_PI_FIRST_ERROR_LIVELOCK_MASK          0x0000000080000000

/*   SH_PI_FIRST_ERROR_BAD_SNOOP                                        */
/*   Description:  AFI bad snoop error was detected                     */
#define SH_PI_FIRST_ERROR_BAD_SNOOP_SHFT         32
#define SH_PI_FIRST_ERROR_BAD_SNOOP_MASK         0x0000000100000000

/*   SH_PI_FIRST_ERROR_FSB_TBL_MISS                                     */
/*   Description:  AFI FSB request table miss error was detected        */
#define SH_PI_FIRST_ERROR_FSB_TBL_MISS_SHFT      33
#define SH_PI_FIRST_ERROR_FSB_TBL_MISS_MASK      0x0000000200000000

/*   SH_PI_FIRST_ERROR_MSG_LENGTH                                       */
/*   Description:  Message length error on received message from SIC    */
#define SH_PI_FIRST_ERROR_MSG_LENGTH_SHFT        34
#define SH_PI_FIRST_ERROR_MSG_LENGTH_MASK        0x0000000400000000

/* ==================================================================== */
/*                  Register "SH_PI_FIRST_ERROR_ALIAS"                  */
/*                         PI First Error Alias                         */
/* ==================================================================== */

#define SH_PI_FIRST_ERROR_ALIAS                  0x0000000120060788

/* ==================================================================== */
/*                Register "SH_PI_PI2MD_REPLY_VC_STATUS"                */
/*                PI-to-MD Reply Virtual Channel Status                 */
/* ==================================================================== */

#define SH_PI_PI2MD_REPLY_VC_STATUS              0x0000000120060900
#define SH_PI_PI2MD_REPLY_VC_STATUS_MASK         0x000000000000003f
#define SH_PI_PI2MD_REPLY_VC_STATUS_INIT         0x0000000000000000

/*   SH_PI_PI2MD_REPLY_VC_STATUS_OUTPUT_CRD_STAT                        */
/*   Description:  Status of output credits                             */
#define SH_PI_PI2MD_REPLY_VC_STATUS_OUTPUT_CRD_STAT_SHFT 0
#define SH_PI_PI2MD_REPLY_VC_STATUS_OUTPUT_CRD_STAT_MASK 0x000000000000003f

/* ==================================================================== */
/*               Register "SH_PI_PI2MD_REQUEST_VC_STATUS"               */
/*               PI-to-MD Request Virtual Channel Status                */
/* ==================================================================== */

#define SH_PI_PI2MD_REQUEST_VC_STATUS            0x0000000120060980
#define SH_PI_PI2MD_REQUEST_VC_STATUS_MASK       0x000000000000003f
#define SH_PI_PI2MD_REQUEST_VC_STATUS_INIT       0x0000000000000000

/*   SH_PI_PI2MD_REQUEST_VC_STATUS_OUTPUT_CRD_STAT                      */
/*   Description:  Status of output credits                             */
#define SH_PI_PI2MD_REQUEST_VC_STATUS_OUTPUT_CRD_STAT_SHFT 0
#define SH_PI_PI2MD_REQUEST_VC_STATUS_OUTPUT_CRD_STAT_MASK 0x000000000000003f

/* ==================================================================== */
/*                Register "SH_PI_PI2XN_REPLY_VC_STATUS"                */
/*                PI-to-XN Reply Virtual Channel Status                 */
/* ==================================================================== */

#define SH_PI_PI2XN_REPLY_VC_STATUS              0x0000000120060a00
#define SH_PI_PI2XN_REPLY_VC_STATUS_MASK         0x000000000000003f
#define SH_PI_PI2XN_REPLY_VC_STATUS_INIT         0x0000000000000000

/*   SH_PI_PI2XN_REPLY_VC_STATUS_OUTPUT_CRD_STAT                        */
/*   Description:  Status of output credits                             */
#define SH_PI_PI2XN_REPLY_VC_STATUS_OUTPUT_CRD_STAT_SHFT 0
#define SH_PI_PI2XN_REPLY_VC_STATUS_OUTPUT_CRD_STAT_MASK 0x000000000000003f

/* ==================================================================== */
/*               Register "SH_PI_PI2XN_REQUEST_VC_STATUS"               */
/*               PI-to-XN Request Virtual Channel Status                */
/* ==================================================================== */

#define SH_PI_PI2XN_REQUEST_VC_STATUS            0x0000000120060a80
#define SH_PI_PI2XN_REQUEST_VC_STATUS_MASK       0x000000000000003f
#define SH_PI_PI2XN_REQUEST_VC_STATUS_INIT       0x0000000000000000

/*   SH_PI_PI2XN_REQUEST_VC_STATUS_OUTPUT_CRD_STAT                      */
/*   Description:  Status of output credits                             */
#define SH_PI_PI2XN_REQUEST_VC_STATUS_OUTPUT_CRD_STAT_SHFT 0
#define SH_PI_PI2XN_REQUEST_VC_STATUS_OUTPUT_CRD_STAT_MASK 0x000000000000003f

/* ==================================================================== */
/*                Register "SH_PI_UNCORRECTED_DETAIL_1"                 */
/*                    PI Uncorrected Error Detail 1                     */
/* ==================================================================== */

#define SH_PI_UNCORRECTED_DETAIL_1               0x0000000120060b00
#define SH_PI_UNCORRECTED_DETAIL_1_MASK          0xffffffffffffffff
#define SH_PI_UNCORRECTED_DETAIL_1_INIT          0x0000000000000000

/*   SH_PI_UNCORRECTED_DETAIL_1_ADDRESS                                 */
/*   Description:  Address of Message that logged Uncorrectable Error  */
#define SH_PI_UNCORRECTED_DETAIL_1_ADDRESS_SHFT  0
#define SH_PI_UNCORRECTED_DETAIL_1_ADDRESS_MASK  0x0000ffffffffffff

/*   SH_PI_UNCORRECTED_DETAIL_1_SYNDROME                                */
/*   Description:  Syndrome for double word data with Uncorrectable Er  */
#define SH_PI_UNCORRECTED_DETAIL_1_SYNDROME_SHFT 48
#define SH_PI_UNCORRECTED_DETAIL_1_SYNDROME_MASK 0x00ff000000000000

/*   SH_PI_UNCORRECTED_DETAIL_1_DEP                                     */
/*   Description:  DEP for Double word in error                         */
#define SH_PI_UNCORRECTED_DETAIL_1_DEP_SHFT      56
#define SH_PI_UNCORRECTED_DETAIL_1_DEP_MASK      0xff00000000000000

/* ==================================================================== */
/*                Register "SH_PI_UNCORRECTED_DETAIL_2"                 */
/*                    PI Uncorrected Error Detail 2                     */
/* ==================================================================== */

#define SH_PI_UNCORRECTED_DETAIL_2               0x0000000120060b80
#define SH_PI_UNCORRECTED_DETAIL_2_MASK          0xffffffffffffffff
#define SH_PI_UNCORRECTED_DETAIL_2_INIT          0x0000000000000000

/*   SH_PI_UNCORRECTED_DETAIL_2_DATA                                    */
/*   Description:  Double word data in error                            */
#define SH_PI_UNCORRECTED_DETAIL_2_DATA_SHFT     0
#define SH_PI_UNCORRECTED_DETAIL_2_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_PI_UNCORRECTED_DETAIL_3"                 */
/*                    PI Uncorrected Error Detail 3                     */
/* ==================================================================== */

#define SH_PI_UNCORRECTED_DETAIL_3               0x0000000120060c00
#define SH_PI_UNCORRECTED_DETAIL_3_MASK          0xffffffffffffffff
#define SH_PI_UNCORRECTED_DETAIL_3_INIT          0x0000000000000000

/*   SH_PI_UNCORRECTED_DETAIL_3_ADDRESS                                 */
/*   Description:  Address of Message that logged Uncorrectable Error  */
#define SH_PI_UNCORRECTED_DETAIL_3_ADDRESS_SHFT  0
#define SH_PI_UNCORRECTED_DETAIL_3_ADDRESS_MASK  0x0000ffffffffffff

/*   SH_PI_UNCORRECTED_DETAIL_3_SYNDROME                                */
/*   Description:  Syndrome for double word data with Uncorrectable Er  */
#define SH_PI_UNCORRECTED_DETAIL_3_SYNDROME_SHFT 48
#define SH_PI_UNCORRECTED_DETAIL_3_SYNDROME_MASK 0x00ff000000000000

/*   SH_PI_UNCORRECTED_DETAIL_3_DEP                                     */
/*   Description:  DCP for Double word in error                         */
#define SH_PI_UNCORRECTED_DETAIL_3_DEP_SHFT      56
#define SH_PI_UNCORRECTED_DETAIL_3_DEP_MASK      0xff00000000000000

/* ==================================================================== */
/*                Register "SH_PI_UNCORRECTED_DETAIL_4"                 */
/*                    PI Uncorrected Error Detail 4                     */
/* ==================================================================== */

#define SH_PI_UNCORRECTED_DETAIL_4               0x0000000120060c80
#define SH_PI_UNCORRECTED_DETAIL_4_MASK          0xffffffffffffffff
#define SH_PI_UNCORRECTED_DETAIL_4_INIT          0x0000000000000000

/*   SH_PI_UNCORRECTED_DETAIL_4_DATA                                    */
/*   Description:  Double word data in error                            */
#define SH_PI_UNCORRECTED_DETAIL_4_DATA_SHFT     0
#define SH_PI_UNCORRECTED_DETAIL_4_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_PI_MD2PI_REPLY_VC_STATUS"                */
/*                MD-to-PI Reply Virtual Channel Status                 */
/* ==================================================================== */

#define SH_PI_MD2PI_REPLY_VC_STATUS              0x0000000120060800
#define SH_PI_MD2PI_REPLY_VC_STATUS_MASK         0x0000000000000fff
#define SH_PI_MD2PI_REPLY_VC_STATUS_INIT         0x0000000000000000

/*   SH_PI_MD2PI_REPLY_VC_STATUS_INPUT_HDR_CRD_STAT                     */
/*   Description:  Status of input header credits                       */
#define SH_PI_MD2PI_REPLY_VC_STATUS_INPUT_HDR_CRD_STAT_SHFT 0
#define SH_PI_MD2PI_REPLY_VC_STATUS_INPUT_HDR_CRD_STAT_MASK 0x000000000000000f

/*   SH_PI_MD2PI_REPLY_VC_STATUS_INPUT_DAT_CRD_STAT                     */
/*   Description:  Status of data credits                               */
#define SH_PI_MD2PI_REPLY_VC_STATUS_INPUT_DAT_CRD_STAT_SHFT 4
#define SH_PI_MD2PI_REPLY_VC_STATUS_INPUT_DAT_CRD_STAT_MASK 0x00000000000000f0

/*   SH_PI_MD2PI_REPLY_VC_STATUS_INPUT_QUEUE_STAT                       */
/*   Description:  Status of MD Reply Input Queue                       */
#define SH_PI_MD2PI_REPLY_VC_STATUS_INPUT_QUEUE_STAT_SHFT 8
#define SH_PI_MD2PI_REPLY_VC_STATUS_INPUT_QUEUE_STAT_MASK 0x0000000000000f00

/* ==================================================================== */
/*               Register "SH_PI_MD2PI_REQUEST_VC_STATUS"               */
/*               MD-to-PI Request Virtual Channel Status                */
/* ==================================================================== */

#define SH_PI_MD2PI_REQUEST_VC_STATUS            0x0000000120060880
#define SH_PI_MD2PI_REQUEST_VC_STATUS_MASK       0x0000000000000fff
#define SH_PI_MD2PI_REQUEST_VC_STATUS_INIT       0x0000000000000000

/*   SH_PI_MD2PI_REQUEST_VC_STATUS_INPUT_HDR_CRD_STAT                   */
/*   Description:  Status of input header credits                       */
#define SH_PI_MD2PI_REQUEST_VC_STATUS_INPUT_HDR_CRD_STAT_SHFT 0
#define SH_PI_MD2PI_REQUEST_VC_STATUS_INPUT_HDR_CRD_STAT_MASK 0x000000000000000f

/*   SH_PI_MD2PI_REQUEST_VC_STATUS_INPUT_DAT_CRD_STAT                   */
/*   Description:  Status of input data credits                         */
#define SH_PI_MD2PI_REQUEST_VC_STATUS_INPUT_DAT_CRD_STAT_SHFT 4
#define SH_PI_MD2PI_REQUEST_VC_STATUS_INPUT_DAT_CRD_STAT_MASK 0x00000000000000f0

/*   SH_PI_MD2PI_REQUEST_VC_STATUS_INPUT_QUEUE_STAT                     */
/*   Description:  Status of MD Request Input Queue                     */
#define SH_PI_MD2PI_REQUEST_VC_STATUS_INPUT_QUEUE_STAT_SHFT 8
#define SH_PI_MD2PI_REQUEST_VC_STATUS_INPUT_QUEUE_STAT_MASK 0x0000000000000f00

/* ==================================================================== */
/*                Register "SH_PI_XN2PI_REPLY_VC_STATUS"                */
/*                XN-to-PI Reply Virtual Channel Status                 */
/* ==================================================================== */

#define SH_PI_XN2PI_REPLY_VC_STATUS              0x0000000120060d00
#define SH_PI_XN2PI_REPLY_VC_STATUS_MASK         0x0000000000000fff
#define SH_PI_XN2PI_REPLY_VC_STATUS_INIT         0x0000000000000000

/*   SH_PI_XN2PI_REPLY_VC_STATUS_INPUT_HDR_CRD_STAT                     */
/*   Description:  Status of input header credits                       */
#define SH_PI_XN2PI_REPLY_VC_STATUS_INPUT_HDR_CRD_STAT_SHFT 0
#define SH_PI_XN2PI_REPLY_VC_STATUS_INPUT_HDR_CRD_STAT_MASK 0x000000000000000f

/*   SH_PI_XN2PI_REPLY_VC_STATUS_INPUT_DAT_CRD_STAT                     */
/*   Description:  Status of input data credits                         */
#define SH_PI_XN2PI_REPLY_VC_STATUS_INPUT_DAT_CRD_STAT_SHFT 4
#define SH_PI_XN2PI_REPLY_VC_STATUS_INPUT_DAT_CRD_STAT_MASK 0x00000000000000f0

/*   SH_PI_XN2PI_REPLY_VC_STATUS_INPUT_QUEUE_STAT                       */
/*   Description:  Status of XN Reply Input Queue                       */
#define SH_PI_XN2PI_REPLY_VC_STATUS_INPUT_QUEUE_STAT_SHFT 8
#define SH_PI_XN2PI_REPLY_VC_STATUS_INPUT_QUEUE_STAT_MASK 0x0000000000000f00

/* ==================================================================== */
/*               Register "SH_PI_XN2PI_REQUEST_VC_STATUS"               */
/*               XN-to-PI Request Virtual Channel Status                */
/* ==================================================================== */

#define SH_PI_XN2PI_REQUEST_VC_STATUS            0x0000000120060d80
#define SH_PI_XN2PI_REQUEST_VC_STATUS_MASK       0x0000000000000fff
#define SH_PI_XN2PI_REQUEST_VC_STATUS_INIT       0x0000000000000000

/*   SH_PI_XN2PI_REQUEST_VC_STATUS_INPUT_HDR_CRD_STAT                   */
/*   Description:  Status of input header credits                       */
#define SH_PI_XN2PI_REQUEST_VC_STATUS_INPUT_HDR_CRD_STAT_SHFT 0
#define SH_PI_XN2PI_REQUEST_VC_STATUS_INPUT_HDR_CRD_STAT_MASK 0x000000000000000f

/*   SH_PI_XN2PI_REQUEST_VC_STATUS_INPUT_DAT_CRD_STAT                   */
/*   Description:  Status of input data credits                         */
#define SH_PI_XN2PI_REQUEST_VC_STATUS_INPUT_DAT_CRD_STAT_SHFT 4
#define SH_PI_XN2PI_REQUEST_VC_STATUS_INPUT_DAT_CRD_STAT_MASK 0x00000000000000f0

/*   SH_PI_XN2PI_REQUEST_VC_STATUS_INPUT_QUEUE_STAT                     */
/*   Description:  Status of XN Request Input Queue                     */
#define SH_PI_XN2PI_REQUEST_VC_STATUS_INPUT_QUEUE_STAT_SHFT 8
#define SH_PI_XN2PI_REQUEST_VC_STATUS_INPUT_QUEUE_STAT_MASK 0x0000000000000f00

/* ==================================================================== */
/*                     Register "SH_XNPI_SIC_FLOW"                      */
/* ==================================================================== */

#define SH_XNPI_SIC_FLOW                         0x0000000150030000
#define SH_XNPI_SIC_FLOW_MASK                    0x9f1f1f1f1f1f9f9f
#define SH_XNPI_SIC_FLOW_INIT                    0x0000080000080000

/*   SH_XNPI_SIC_FLOW_DEBIT_VC0_WITHHOLD                                */
/*   Description:  vc0 withhold                                         */
#define SH_XNPI_SIC_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNPI_SIC_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000001f

/*   SH_XNPI_SIC_FLOW_DEBIT_VC0_FORCE_CRED                              */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNPI_SIC_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNPI_SIC_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNPI_SIC_FLOW_DEBIT_VC2_WITHHOLD                                */
/*   Description:  vc2 withhold                                         */
#define SH_XNPI_SIC_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNPI_SIC_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000001f00

/*   SH_XNPI_SIC_FLOW_DEBIT_VC2_FORCE_CRED                              */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNPI_SIC_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNPI_SIC_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNPI_SIC_FLOW_CREDIT_VC0_TEST                                   */
/*   Description:  vc0 credit_test                                      */
#define SH_XNPI_SIC_FLOW_CREDIT_VC0_TEST_SHFT    16
#define SH_XNPI_SIC_FLOW_CREDIT_VC0_TEST_MASK    0x00000000001f0000

/*   SH_XNPI_SIC_FLOW_CREDIT_VC0_DYN                                    */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNPI_SIC_FLOW_CREDIT_VC0_DYN_SHFT     24
#define SH_XNPI_SIC_FLOW_CREDIT_VC0_DYN_MASK     0x000000001f000000

/*   SH_XNPI_SIC_FLOW_CREDIT_VC0_CAP                                    */
/*   Description:  vc0 credit captured value                            */
#define SH_XNPI_SIC_FLOW_CREDIT_VC0_CAP_SHFT     32
#define SH_XNPI_SIC_FLOW_CREDIT_VC0_CAP_MASK     0x0000001f00000000

/*   SH_XNPI_SIC_FLOW_CREDIT_VC2_TEST                                   */
/*   Description:  vc2 credit_test                                      */
#define SH_XNPI_SIC_FLOW_CREDIT_VC2_TEST_SHFT    40
#define SH_XNPI_SIC_FLOW_CREDIT_VC2_TEST_MASK    0x00001f0000000000

/*   SH_XNPI_SIC_FLOW_CREDIT_VC2_DYN                                    */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNPI_SIC_FLOW_CREDIT_VC2_DYN_SHFT     48
#define SH_XNPI_SIC_FLOW_CREDIT_VC2_DYN_MASK     0x001f000000000000

/*   SH_XNPI_SIC_FLOW_CREDIT_VC2_CAP                                    */
/*   Description:  vc2 credit captured value                            */
#define SH_XNPI_SIC_FLOW_CREDIT_VC2_CAP_SHFT     56
#define SH_XNPI_SIC_FLOW_CREDIT_VC2_CAP_MASK     0x1f00000000000000

/*   SH_XNPI_SIC_FLOW_DISABLE_BYPASS_OUT                                */
#define SH_XNPI_SIC_FLOW_DISABLE_BYPASS_OUT_SHFT 63
#define SH_XNPI_SIC_FLOW_DISABLE_BYPASS_OUT_MASK 0x8000000000000000

/* ==================================================================== */
/*                 Register "SH_XNPI_TO_NI0_PORT_FLOW"                  */
/* ==================================================================== */

#define SH_XNPI_TO_NI0_PORT_FLOW                 0x0000000150030010
#define SH_XNPI_TO_NI0_PORT_FLOW_MASK            0x3f3f003f3f00bfbf
#define SH_XNPI_TO_NI0_PORT_FLOW_INIT            0x0000000000000000

/*   SH_XNPI_TO_NI0_PORT_FLOW_DEBIT_VC0_WITHHOLD                        */
/*   Description:  vc0 withhold                                         */
#define SH_XNPI_TO_NI0_PORT_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNPI_TO_NI0_PORT_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNPI_TO_NI0_PORT_FLOW_DEBIT_VC0_FORCE_CRED                      */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNPI_TO_NI0_PORT_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNPI_TO_NI0_PORT_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNPI_TO_NI0_PORT_FLOW_DEBIT_VC2_WITHHOLD                        */
/*   Description:  vc2 withhold                                         */
#define SH_XNPI_TO_NI0_PORT_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNPI_TO_NI0_PORT_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNPI_TO_NI0_PORT_FLOW_DEBIT_VC2_FORCE_CRED                      */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNPI_TO_NI0_PORT_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNPI_TO_NI0_PORT_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNPI_TO_NI0_PORT_FLOW_CREDIT_VC0_DYN                            */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNPI_TO_NI0_PORT_FLOW_CREDIT_VC0_DYN_SHFT 24
#define SH_XNPI_TO_NI0_PORT_FLOW_CREDIT_VC0_DYN_MASK 0x000000003f000000

/*   SH_XNPI_TO_NI0_PORT_FLOW_CREDIT_VC0_CAP                            */
/*   Description:  vc0 credit captured value                            */
#define SH_XNPI_TO_NI0_PORT_FLOW_CREDIT_VC0_CAP_SHFT 32
#define SH_XNPI_TO_NI0_PORT_FLOW_CREDIT_VC0_CAP_MASK 0x0000003f00000000

/*   SH_XNPI_TO_NI0_PORT_FLOW_CREDIT_VC2_DYN                            */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNPI_TO_NI0_PORT_FLOW_CREDIT_VC2_DYN_SHFT 48
#define SH_XNPI_TO_NI0_PORT_FLOW_CREDIT_VC2_DYN_MASK 0x003f000000000000

/*   SH_XNPI_TO_NI0_PORT_FLOW_CREDIT_VC2_CAP                            */
/*   Description:  vc2 credit captured value                            */
#define SH_XNPI_TO_NI0_PORT_FLOW_CREDIT_VC2_CAP_SHFT 56
#define SH_XNPI_TO_NI0_PORT_FLOW_CREDIT_VC2_CAP_MASK 0x3f00000000000000

/* ==================================================================== */
/*                 Register "SH_XNPI_TO_NI1_PORT_FLOW"                  */
/* ==================================================================== */

#define SH_XNPI_TO_NI1_PORT_FLOW                 0x0000000150030020
#define SH_XNPI_TO_NI1_PORT_FLOW_MASK            0x3f3f003f3f00bfbf
#define SH_XNPI_TO_NI1_PORT_FLOW_INIT            0x0000000000000000

/*   SH_XNPI_TO_NI1_PORT_FLOW_DEBIT_VC0_WITHHOLD                        */
/*   Description:  vc0 withhold                                         */
#define SH_XNPI_TO_NI1_PORT_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNPI_TO_NI1_PORT_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNPI_TO_NI1_PORT_FLOW_DEBIT_VC0_FORCE_CRED                      */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNPI_TO_NI1_PORT_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNPI_TO_NI1_PORT_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNPI_TO_NI1_PORT_FLOW_DEBIT_VC2_WITHHOLD                        */
/*   Description:  vc2 withhold                                         */
#define SH_XNPI_TO_NI1_PORT_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNPI_TO_NI1_PORT_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNPI_TO_NI1_PORT_FLOW_DEBIT_VC2_FORCE_CRED                      */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNPI_TO_NI1_PORT_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNPI_TO_NI1_PORT_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNPI_TO_NI1_PORT_FLOW_CREDIT_VC0_DYN                            */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNPI_TO_NI1_PORT_FLOW_CREDIT_VC0_DYN_SHFT 24
#define SH_XNPI_TO_NI1_PORT_FLOW_CREDIT_VC0_DYN_MASK 0x000000003f000000

/*   SH_XNPI_TO_NI1_PORT_FLOW_CREDIT_VC0_CAP                            */
/*   Description:  vc0 credit captured value                            */
#define SH_XNPI_TO_NI1_PORT_FLOW_CREDIT_VC0_CAP_SHFT 32
#define SH_XNPI_TO_NI1_PORT_FLOW_CREDIT_VC0_CAP_MASK 0x0000003f00000000

/*   SH_XNPI_TO_NI1_PORT_FLOW_CREDIT_VC2_DYN                            */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNPI_TO_NI1_PORT_FLOW_CREDIT_VC2_DYN_SHFT 48
#define SH_XNPI_TO_NI1_PORT_FLOW_CREDIT_VC2_DYN_MASK 0x003f000000000000

/*   SH_XNPI_TO_NI1_PORT_FLOW_CREDIT_VC2_CAP                            */
/*   Description:  vc2 credit captured value                            */
#define SH_XNPI_TO_NI1_PORT_FLOW_CREDIT_VC2_CAP_SHFT 56
#define SH_XNPI_TO_NI1_PORT_FLOW_CREDIT_VC2_CAP_MASK 0x3f00000000000000

/* ==================================================================== */
/*                 Register "SH_XNPI_TO_IILB_PORT_FLOW"                 */
/* ==================================================================== */

#define SH_XNPI_TO_IILB_PORT_FLOW                0x0000000150030030
#define SH_XNPI_TO_IILB_PORT_FLOW_MASK           0x3f3f003f3f00bfbf
#define SH_XNPI_TO_IILB_PORT_FLOW_INIT           0x0000000000000000

/*   SH_XNPI_TO_IILB_PORT_FLOW_DEBIT_VC0_WITHHOLD                       */
/*   Description:  vc0 withhold                                         */
#define SH_XNPI_TO_IILB_PORT_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNPI_TO_IILB_PORT_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNPI_TO_IILB_PORT_FLOW_DEBIT_VC0_FORCE_CRED                     */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNPI_TO_IILB_PORT_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNPI_TO_IILB_PORT_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNPI_TO_IILB_PORT_FLOW_DEBIT_VC2_WITHHOLD                       */
/*   Description:  vc2 withhold                                         */
#define SH_XNPI_TO_IILB_PORT_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNPI_TO_IILB_PORT_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNPI_TO_IILB_PORT_FLOW_DEBIT_VC2_FORCE_CRED                     */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNPI_TO_IILB_PORT_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNPI_TO_IILB_PORT_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNPI_TO_IILB_PORT_FLOW_CREDIT_VC0_DYN                           */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNPI_TO_IILB_PORT_FLOW_CREDIT_VC0_DYN_SHFT 24
#define SH_XNPI_TO_IILB_PORT_FLOW_CREDIT_VC0_DYN_MASK 0x000000003f000000

/*   SH_XNPI_TO_IILB_PORT_FLOW_CREDIT_VC0_CAP                           */
/*   Description:  vc0 credit captured value                            */
#define SH_XNPI_TO_IILB_PORT_FLOW_CREDIT_VC0_CAP_SHFT 32
#define SH_XNPI_TO_IILB_PORT_FLOW_CREDIT_VC0_CAP_MASK 0x0000003f00000000

/*   SH_XNPI_TO_IILB_PORT_FLOW_CREDIT_VC2_DYN                           */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNPI_TO_IILB_PORT_FLOW_CREDIT_VC2_DYN_SHFT 48
#define SH_XNPI_TO_IILB_PORT_FLOW_CREDIT_VC2_DYN_MASK 0x003f000000000000

/*   SH_XNPI_TO_IILB_PORT_FLOW_CREDIT_VC2_CAP                           */
/*   Description:  vc2 credit captured value                            */
#define SH_XNPI_TO_IILB_PORT_FLOW_CREDIT_VC2_CAP_SHFT 56
#define SH_XNPI_TO_IILB_PORT_FLOW_CREDIT_VC2_CAP_MASK 0x3f00000000000000

/* ==================================================================== */
/*               Register "SH_XNPI_FR_NI0_PORT_FLOW_FIFO"               */
/* ==================================================================== */

#define SH_XNPI_FR_NI0_PORT_FLOW_FIFO            0x0000000150030040
#define SH_XNPI_FR_NI0_PORT_FLOW_FIFO_MASK       0x00001f1f3f3f3f3f
#define SH_XNPI_FR_NI0_PORT_FLOW_FIFO_INIT       0x00000c0c00000000

/*   SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_DYN                        */
/*   Description:  vc0 fifo entry dynamic value                         */
#define SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_DYN_SHFT 0
#define SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_DYN_MASK 0x000000000000003f

/*   SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_CAP                        */
/*   Description:  vc0 fifo entry captured value                        */
#define SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_CAP_SHFT 8
#define SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_CAP_MASK 0x0000000000003f00

/*   SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_DYN                        */
/*   Description:  vc2 fifo entry dynamic value                         */
#define SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_DYN_SHFT 16
#define SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_DYN_MASK 0x00000000003f0000

/*   SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_CAP                        */
/*   Description:  vc2 fifo entry  captured value                       */
#define SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_CAP_SHFT 24
#define SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_CAP_MASK 0x000000003f000000

/*   SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_TEST                       */
/*   Description:  vc0 test credits limit                               */
#define SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_TEST_SHFT 32
#define SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_TEST_MASK 0x0000001f00000000

/*   SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_TEST                       */
/*   Description:  vc2 test credits limit                               */
#define SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_TEST_SHFT 40
#define SH_XNPI_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_TEST_MASK 0x00001f0000000000

/* ==================================================================== */
/*               Register "SH_XNPI_FR_NI1_PORT_FLOW_FIFO"               */
/* ==================================================================== */

#define SH_XNPI_FR_NI1_PORT_FLOW_FIFO            0x0000000150030050
#define SH_XNPI_FR_NI1_PORT_FLOW_FIFO_MASK       0x00001f1f3f3f3f3f
#define SH_XNPI_FR_NI1_PORT_FLOW_FIFO_INIT       0x00000c0c00000000

/*   SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_DYN                        */
/*   Description:  vc0 fifo entry dynamic value                         */
#define SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_DYN_SHFT 0
#define SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_DYN_MASK 0x000000000000003f

/*   SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_CAP                        */
/*   Description:  vc0 fifo entry captured value                        */
#define SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_CAP_SHFT 8
#define SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_CAP_MASK 0x0000000000003f00

/*   SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_DYN                        */
/*   Description:  vc2 fifo entry dynamic value                         */
#define SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_DYN_SHFT 16
#define SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_DYN_MASK 0x00000000003f0000

/*   SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_CAP                        */
/*   Description:  vc2 fifo entry  captured value                       */
#define SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_CAP_SHFT 24
#define SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_CAP_MASK 0x000000003f000000

/*   SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_TEST                       */
/*   Description:  vc0 test credits limit                               */
#define SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_TEST_SHFT 32
#define SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_TEST_MASK 0x0000001f00000000

/*   SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_TEST                       */
/*   Description:  vc2 test credits limit                               */
#define SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_TEST_SHFT 40
#define SH_XNPI_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_TEST_MASK 0x00001f0000000000

/* ==================================================================== */
/*              Register "SH_XNPI_FR_IILB_PORT_FLOW_FIFO"               */
/* ==================================================================== */

#define SH_XNPI_FR_IILB_PORT_FLOW_FIFO           0x0000000150030060
#define SH_XNPI_FR_IILB_PORT_FLOW_FIFO_MASK      0x00001f1f3f3f3f3f
#define SH_XNPI_FR_IILB_PORT_FLOW_FIFO_INIT      0x00000c0c00000000

/*   SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_DYN                       */
/*   Description:  vc0 fifo entry dynamic value                         */
#define SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_DYN_SHFT 0
#define SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_DYN_MASK 0x000000000000003f

/*   SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_CAP                       */
/*   Description:  vc0 fifo entry captured value                        */
#define SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_CAP_SHFT 8
#define SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_CAP_MASK 0x0000000000003f00

/*   SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_DYN                       */
/*   Description:  vc2 fifo entry dynamic value                         */
#define SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_DYN_SHFT 16
#define SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_DYN_MASK 0x00000000003f0000

/*   SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_CAP                       */
/*   Description:  vc2 fifo entry  captured value                       */
#define SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_CAP_SHFT 24
#define SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_CAP_MASK 0x000000003f000000

/*   SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_TEST                      */
/*   Description:  vc0 test credits limit                               */
#define SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_TEST_SHFT 32
#define SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_TEST_MASK 0x0000001f00000000

/*   SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_TEST                      */
/*   Description:  vc2 test credits limit                               */
#define SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_TEST_SHFT 40
#define SH_XNPI_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_TEST_MASK 0x00001f0000000000

/* ==================================================================== */
/*                     Register "SH_XNMD_SIC_FLOW"                      */
/* ==================================================================== */

#define SH_XNMD_SIC_FLOW                         0x0000000150030100
#define SH_XNMD_SIC_FLOW_MASK                    0x9f1f1f1f1f1f9f9f
#define SH_XNMD_SIC_FLOW_INIT                    0x0000090000090000

/*   SH_XNMD_SIC_FLOW_DEBIT_VC0_WITHHOLD                                */
/*   Description:  vc0 withhold                                         */
#define SH_XNMD_SIC_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNMD_SIC_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000001f

/*   SH_XNMD_SIC_FLOW_DEBIT_VC0_FORCE_CRED                              */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNMD_SIC_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNMD_SIC_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNMD_SIC_FLOW_DEBIT_VC2_WITHHOLD                                */
/*   Description:  vc2 withhold                                         */
#define SH_XNMD_SIC_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNMD_SIC_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000001f00

/*   SH_XNMD_SIC_FLOW_DEBIT_VC2_FORCE_CRED                              */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNMD_SIC_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNMD_SIC_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNMD_SIC_FLOW_CREDIT_VC0_TEST                                   */
/*   Description:  vc0 credit_test                                      */
#define SH_XNMD_SIC_FLOW_CREDIT_VC0_TEST_SHFT    16
#define SH_XNMD_SIC_FLOW_CREDIT_VC0_TEST_MASK    0x00000000001f0000

/*   SH_XNMD_SIC_FLOW_CREDIT_VC0_DYN                                    */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNMD_SIC_FLOW_CREDIT_VC0_DYN_SHFT     24
#define SH_XNMD_SIC_FLOW_CREDIT_VC0_DYN_MASK     0x000000001f000000

/*   SH_XNMD_SIC_FLOW_CREDIT_VC0_CAP                                    */
/*   Description:  vc0 credit captured value                            */
#define SH_XNMD_SIC_FLOW_CREDIT_VC0_CAP_SHFT     32
#define SH_XNMD_SIC_FLOW_CREDIT_VC0_CAP_MASK     0x0000001f00000000

/*   SH_XNMD_SIC_FLOW_CREDIT_VC2_TEST                                   */
/*   Description:  vc2 credit_test                                      */
#define SH_XNMD_SIC_FLOW_CREDIT_VC2_TEST_SHFT    40
#define SH_XNMD_SIC_FLOW_CREDIT_VC2_TEST_MASK    0x00001f0000000000

/*   SH_XNMD_SIC_FLOW_CREDIT_VC2_DYN                                    */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNMD_SIC_FLOW_CREDIT_VC2_DYN_SHFT     48
#define SH_XNMD_SIC_FLOW_CREDIT_VC2_DYN_MASK     0x001f000000000000

/*   SH_XNMD_SIC_FLOW_CREDIT_VC2_CAP                                    */
/*   Description:  vc2 credit captured value                            */
#define SH_XNMD_SIC_FLOW_CREDIT_VC2_CAP_SHFT     56
#define SH_XNMD_SIC_FLOW_CREDIT_VC2_CAP_MASK     0x1f00000000000000

/*   SH_XNMD_SIC_FLOW_DISABLE_BYPASS_OUT                                */
#define SH_XNMD_SIC_FLOW_DISABLE_BYPASS_OUT_SHFT 63
#define SH_XNMD_SIC_FLOW_DISABLE_BYPASS_OUT_MASK 0x8000000000000000

/* ==================================================================== */
/*                 Register "SH_XNMD_TO_NI0_PORT_FLOW"                  */
/* ==================================================================== */

#define SH_XNMD_TO_NI0_PORT_FLOW                 0x0000000150030110
#define SH_XNMD_TO_NI0_PORT_FLOW_MASK            0x3f3f003f3f00bfbf
#define SH_XNMD_TO_NI0_PORT_FLOW_INIT            0x0000000000000000

/*   SH_XNMD_TO_NI0_PORT_FLOW_DEBIT_VC0_WITHHOLD                        */
/*   Description:  vc0 withhold                                         */
#define SH_XNMD_TO_NI0_PORT_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNMD_TO_NI0_PORT_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNMD_TO_NI0_PORT_FLOW_DEBIT_VC0_FORCE_CRED                      */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNMD_TO_NI0_PORT_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNMD_TO_NI0_PORT_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNMD_TO_NI0_PORT_FLOW_DEBIT_VC2_WITHHOLD                        */
/*   Description:  vc2 withhold                                         */
#define SH_XNMD_TO_NI0_PORT_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNMD_TO_NI0_PORT_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNMD_TO_NI0_PORT_FLOW_DEBIT_VC2_FORCE_CRED                      */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNMD_TO_NI0_PORT_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNMD_TO_NI0_PORT_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNMD_TO_NI0_PORT_FLOW_CREDIT_VC0_DYN                            */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNMD_TO_NI0_PORT_FLOW_CREDIT_VC0_DYN_SHFT 24
#define SH_XNMD_TO_NI0_PORT_FLOW_CREDIT_VC0_DYN_MASK 0x000000003f000000

/*   SH_XNMD_TO_NI0_PORT_FLOW_CREDIT_VC0_CAP                            */
/*   Description:  vc0 credit captured value                            */
#define SH_XNMD_TO_NI0_PORT_FLOW_CREDIT_VC0_CAP_SHFT 32
#define SH_XNMD_TO_NI0_PORT_FLOW_CREDIT_VC0_CAP_MASK 0x0000003f00000000

/*   SH_XNMD_TO_NI0_PORT_FLOW_CREDIT_VC2_DYN                            */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNMD_TO_NI0_PORT_FLOW_CREDIT_VC2_DYN_SHFT 48
#define SH_XNMD_TO_NI0_PORT_FLOW_CREDIT_VC2_DYN_MASK 0x003f000000000000

/*   SH_XNMD_TO_NI0_PORT_FLOW_CREDIT_VC2_CAP                            */
/*   Description:  vc2 credit captured value                            */
#define SH_XNMD_TO_NI0_PORT_FLOW_CREDIT_VC2_CAP_SHFT 56
#define SH_XNMD_TO_NI0_PORT_FLOW_CREDIT_VC2_CAP_MASK 0x3f00000000000000

/* ==================================================================== */
/*                 Register "SH_XNMD_TO_NI1_PORT_FLOW"                  */
/* ==================================================================== */

#define SH_XNMD_TO_NI1_PORT_FLOW                 0x0000000150030120
#define SH_XNMD_TO_NI1_PORT_FLOW_MASK            0x3f3f003f3f00bfbf
#define SH_XNMD_TO_NI1_PORT_FLOW_INIT            0x0000000000000000

/*   SH_XNMD_TO_NI1_PORT_FLOW_DEBIT_VC0_WITHHOLD                        */
/*   Description:  vc0 withhold                                         */
#define SH_XNMD_TO_NI1_PORT_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNMD_TO_NI1_PORT_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNMD_TO_NI1_PORT_FLOW_DEBIT_VC0_FORCE_CRED                      */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNMD_TO_NI1_PORT_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNMD_TO_NI1_PORT_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNMD_TO_NI1_PORT_FLOW_DEBIT_VC2_WITHHOLD                        */
/*   Description:  vc2 withhold                                         */
#define SH_XNMD_TO_NI1_PORT_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNMD_TO_NI1_PORT_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNMD_TO_NI1_PORT_FLOW_DEBIT_VC2_FORCE_CRED                      */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNMD_TO_NI1_PORT_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNMD_TO_NI1_PORT_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNMD_TO_NI1_PORT_FLOW_CREDIT_VC0_DYN                            */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNMD_TO_NI1_PORT_FLOW_CREDIT_VC0_DYN_SHFT 24
#define SH_XNMD_TO_NI1_PORT_FLOW_CREDIT_VC0_DYN_MASK 0x000000003f000000

/*   SH_XNMD_TO_NI1_PORT_FLOW_CREDIT_VC0_CAP                            */
/*   Description:  vc0 credit captured value                            */
#define SH_XNMD_TO_NI1_PORT_FLOW_CREDIT_VC0_CAP_SHFT 32
#define SH_XNMD_TO_NI1_PORT_FLOW_CREDIT_VC0_CAP_MASK 0x0000003f00000000

/*   SH_XNMD_TO_NI1_PORT_FLOW_CREDIT_VC2_DYN                            */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNMD_TO_NI1_PORT_FLOW_CREDIT_VC2_DYN_SHFT 48
#define SH_XNMD_TO_NI1_PORT_FLOW_CREDIT_VC2_DYN_MASK 0x003f000000000000

/*   SH_XNMD_TO_NI1_PORT_FLOW_CREDIT_VC2_CAP                            */
/*   Description:  vc2 credit captured value                            */
#define SH_XNMD_TO_NI1_PORT_FLOW_CREDIT_VC2_CAP_SHFT 56
#define SH_XNMD_TO_NI1_PORT_FLOW_CREDIT_VC2_CAP_MASK 0x3f00000000000000

/* ==================================================================== */
/*                 Register "SH_XNMD_TO_IILB_PORT_FLOW"                 */
/* ==================================================================== */

#define SH_XNMD_TO_IILB_PORT_FLOW                0x0000000150030130
#define SH_XNMD_TO_IILB_PORT_FLOW_MASK           0x3f3f003f3f00bfbf
#define SH_XNMD_TO_IILB_PORT_FLOW_INIT           0x0000000000000000

/*   SH_XNMD_TO_IILB_PORT_FLOW_DEBIT_VC0_WITHHOLD                       */
/*   Description:  vc0 withhold                                         */
#define SH_XNMD_TO_IILB_PORT_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNMD_TO_IILB_PORT_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNMD_TO_IILB_PORT_FLOW_DEBIT_VC0_FORCE_CRED                     */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNMD_TO_IILB_PORT_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNMD_TO_IILB_PORT_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNMD_TO_IILB_PORT_FLOW_DEBIT_VC2_WITHHOLD                       */
/*   Description:  vc2 withhold                                         */
#define SH_XNMD_TO_IILB_PORT_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNMD_TO_IILB_PORT_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNMD_TO_IILB_PORT_FLOW_DEBIT_VC2_FORCE_CRED                     */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNMD_TO_IILB_PORT_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNMD_TO_IILB_PORT_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNMD_TO_IILB_PORT_FLOW_CREDIT_VC0_DYN                           */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNMD_TO_IILB_PORT_FLOW_CREDIT_VC0_DYN_SHFT 24
#define SH_XNMD_TO_IILB_PORT_FLOW_CREDIT_VC0_DYN_MASK 0x000000003f000000

/*   SH_XNMD_TO_IILB_PORT_FLOW_CREDIT_VC0_CAP                           */
/*   Description:  vc0 credit captured value                            */
#define SH_XNMD_TO_IILB_PORT_FLOW_CREDIT_VC0_CAP_SHFT 32
#define SH_XNMD_TO_IILB_PORT_FLOW_CREDIT_VC0_CAP_MASK 0x0000003f00000000

/*   SH_XNMD_TO_IILB_PORT_FLOW_CREDIT_VC2_DYN                           */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNMD_TO_IILB_PORT_FLOW_CREDIT_VC2_DYN_SHFT 48
#define SH_XNMD_TO_IILB_PORT_FLOW_CREDIT_VC2_DYN_MASK 0x003f000000000000

/*   SH_XNMD_TO_IILB_PORT_FLOW_CREDIT_VC2_CAP                           */
/*   Description:  vc2 credit captured value                            */
#define SH_XNMD_TO_IILB_PORT_FLOW_CREDIT_VC2_CAP_SHFT 56
#define SH_XNMD_TO_IILB_PORT_FLOW_CREDIT_VC2_CAP_MASK 0x3f00000000000000

/* ==================================================================== */
/*               Register "SH_XNMD_FR_NI0_PORT_FLOW_FIFO"               */
/* ==================================================================== */

#define SH_XNMD_FR_NI0_PORT_FLOW_FIFO            0x0000000150030140
#define SH_XNMD_FR_NI0_PORT_FLOW_FIFO_MASK       0x00001f1f3f3f3f3f
#define SH_XNMD_FR_NI0_PORT_FLOW_FIFO_INIT       0x00000c0c00000000

/*   SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_DYN                        */
/*   Description:  vc0 fifo entry dynamic value                         */
#define SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_DYN_SHFT 0
#define SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_DYN_MASK 0x000000000000003f

/*   SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_CAP                        */
/*   Description:  vc0 fifo entry captured value                        */
#define SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_CAP_SHFT 8
#define SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_CAP_MASK 0x0000000000003f00

/*   SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_DYN                        */
/*   Description:  vc2 fifo entry dynamic value                         */
#define SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_DYN_SHFT 16
#define SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_DYN_MASK 0x00000000003f0000

/*   SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_CAP                        */
/*   Description:  vc2 fifo entry  captured value                       */
#define SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_CAP_SHFT 24
#define SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_CAP_MASK 0x000000003f000000

/*   SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_TEST                       */
/*   Description:  vc0 test credits limit                               */
#define SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_TEST_SHFT 32
#define SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC0_TEST_MASK 0x0000001f00000000

/*   SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_TEST                       */
/*   Description:  vc2 test credits limit                               */
#define SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_TEST_SHFT 40
#define SH_XNMD_FR_NI0_PORT_FLOW_FIFO_ENTRY_VC2_TEST_MASK 0x00001f0000000000

/* ==================================================================== */
/*               Register "SH_XNMD_FR_NI1_PORT_FLOW_FIFO"               */
/* ==================================================================== */

#define SH_XNMD_FR_NI1_PORT_FLOW_FIFO            0x0000000150030150
#define SH_XNMD_FR_NI1_PORT_FLOW_FIFO_MASK       0x00001f1f3f3f3f3f
#define SH_XNMD_FR_NI1_PORT_FLOW_FIFO_INIT       0x00000c0c00000000

/*   SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_DYN                        */
/*   Description:  vc0 fifo entry dynamic value                         */
#define SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_DYN_SHFT 0
#define SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_DYN_MASK 0x000000000000003f

/*   SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_CAP                        */
/*   Description:  vc0 fifo entry captured value                        */
#define SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_CAP_SHFT 8
#define SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_CAP_MASK 0x0000000000003f00

/*   SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_DYN                        */
/*   Description:  vc2 fifo entry dynamic value                         */
#define SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_DYN_SHFT 16
#define SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_DYN_MASK 0x00000000003f0000

/*   SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_CAP                        */
/*   Description:  vc2 fifo entry  captured value                       */
#define SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_CAP_SHFT 24
#define SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_CAP_MASK 0x000000003f000000

/*   SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_TEST                       */
/*   Description:  vc0 test credits limit                               */
#define SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_TEST_SHFT 32
#define SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC0_TEST_MASK 0x0000001f00000000

/*   SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_TEST                       */
/*   Description:  vc2 test credits limit                               */
#define SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_TEST_SHFT 40
#define SH_XNMD_FR_NI1_PORT_FLOW_FIFO_ENTRY_VC2_TEST_MASK 0x00001f0000000000

/* ==================================================================== */
/*              Register "SH_XNMD_FR_IILB_PORT_FLOW_FIFO"               */
/* ==================================================================== */

#define SH_XNMD_FR_IILB_PORT_FLOW_FIFO           0x0000000150030160
#define SH_XNMD_FR_IILB_PORT_FLOW_FIFO_MASK      0x00001f1f3f3f3f3f
#define SH_XNMD_FR_IILB_PORT_FLOW_FIFO_INIT      0x00000c0c00000000

/*   SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_DYN                       */
/*   Description:  vc0 fifo entry dynamic value                         */
#define SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_DYN_SHFT 0
#define SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_DYN_MASK 0x000000000000003f

/*   SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_CAP                       */
/*   Description:  vc0 fifo entry captured value                        */
#define SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_CAP_SHFT 8
#define SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_CAP_MASK 0x0000000000003f00

/*   SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_DYN                       */
/*   Description:  vc2 fifo entry dynamic value                         */
#define SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_DYN_SHFT 16
#define SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_DYN_MASK 0x00000000003f0000

/*   SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_CAP                       */
/*   Description:  vc2 fifo entry  captured value                       */
#define SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_CAP_SHFT 24
#define SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_CAP_MASK 0x000000003f000000

/*   SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_TEST                      */
/*   Description:  vc0 test credits limit                               */
#define SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_TEST_SHFT 32
#define SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC0_TEST_MASK 0x0000001f00000000

/*   SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_TEST                      */
/*   Description:  vc2 test credits limit                               */
#define SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_TEST_SHFT 40
#define SH_XNMD_FR_IILB_PORT_FLOW_FIFO_ENTRY_VC2_TEST_MASK 0x00001f0000000000

/* ==================================================================== */
/*                    Register "SH_XNII_INTRA_FLOW"                     */
/* ==================================================================== */

#define SH_XNII_INTRA_FLOW                       0x0000000150030200
#define SH_XNII_INTRA_FLOW_MASK                  0x7f7f7f7f7f7fbfbf
#define SH_XNII_INTRA_FLOW_INIT                  0x00003f00003f0000

/*   SH_XNII_INTRA_FLOW_DEBIT_VC0_WITHHOLD                              */
/*   Description:  vc0 withhold                                         */
#define SH_XNII_INTRA_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNII_INTRA_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNII_INTRA_FLOW_DEBIT_VC0_FORCE_CRED                            */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNII_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNII_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNII_INTRA_FLOW_DEBIT_VC2_WITHHOLD                              */
/*   Description:  vc2 withhold                                         */
#define SH_XNII_INTRA_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNII_INTRA_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNII_INTRA_FLOW_DEBIT_VC2_FORCE_CRED                            */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNII_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNII_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNII_INTRA_FLOW_CREDIT_VC0_TEST                                 */
/*   Description:  vc0 credit_test                                      */
#define SH_XNII_INTRA_FLOW_CREDIT_VC0_TEST_SHFT  16
#define SH_XNII_INTRA_FLOW_CREDIT_VC0_TEST_MASK  0x00000000007f0000

/*   SH_XNII_INTRA_FLOW_CREDIT_VC0_DYN                                  */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNII_INTRA_FLOW_CREDIT_VC0_DYN_SHFT   24
#define SH_XNII_INTRA_FLOW_CREDIT_VC0_DYN_MASK   0x000000007f000000

/*   SH_XNII_INTRA_FLOW_CREDIT_VC0_CAP                                  */
/*   Description:  vc0 credit captured value                            */
#define SH_XNII_INTRA_FLOW_CREDIT_VC0_CAP_SHFT   32
#define SH_XNII_INTRA_FLOW_CREDIT_VC0_CAP_MASK   0x0000007f00000000

/*   SH_XNII_INTRA_FLOW_CREDIT_VC2_TEST                                 */
/*   Description:  vc2 credit_test                                      */
#define SH_XNII_INTRA_FLOW_CREDIT_VC2_TEST_SHFT  40
#define SH_XNII_INTRA_FLOW_CREDIT_VC2_TEST_MASK  0x00007f0000000000

/*   SH_XNII_INTRA_FLOW_CREDIT_VC2_DYN                                  */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNII_INTRA_FLOW_CREDIT_VC2_DYN_SHFT   48
#define SH_XNII_INTRA_FLOW_CREDIT_VC2_DYN_MASK   0x007f000000000000

/*   SH_XNII_INTRA_FLOW_CREDIT_VC2_CAP                                  */
/*   Description:  vc2 credit captured value                            */
#define SH_XNII_INTRA_FLOW_CREDIT_VC2_CAP_SHFT   56
#define SH_XNII_INTRA_FLOW_CREDIT_VC2_CAP_MASK   0x7f00000000000000

/* ==================================================================== */
/*                    Register "SH_XNLB_INTRA_FLOW"                     */
/* ==================================================================== */

#define SH_XNLB_INTRA_FLOW                       0x0000000150030210
#define SH_XNLB_INTRA_FLOW_MASK                  0xff7f7f7f7f7fbfbf
#define SH_XNLB_INTRA_FLOW_INIT                  0x0000080000100000

/*   SH_XNLB_INTRA_FLOW_DEBIT_VC0_WITHHOLD                              */
/*   Description:  vc0 withhold                                         */
#define SH_XNLB_INTRA_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNLB_INTRA_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNLB_INTRA_FLOW_DEBIT_VC0_FORCE_CRED                            */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNLB_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNLB_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNLB_INTRA_FLOW_DEBIT_VC2_WITHHOLD                              */
/*   Description:  vc2 withhold                                         */
#define SH_XNLB_INTRA_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNLB_INTRA_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNLB_INTRA_FLOW_DEBIT_VC2_FORCE_CRED                            */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNLB_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNLB_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNLB_INTRA_FLOW_CREDIT_VC0_TEST                                 */
/*   Description:  vc0 credit_test                                      */
#define SH_XNLB_INTRA_FLOW_CREDIT_VC0_TEST_SHFT  16
#define SH_XNLB_INTRA_FLOW_CREDIT_VC0_TEST_MASK  0x00000000007f0000

/*   SH_XNLB_INTRA_FLOW_CREDIT_VC0_DYN                                  */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNLB_INTRA_FLOW_CREDIT_VC0_DYN_SHFT   24
#define SH_XNLB_INTRA_FLOW_CREDIT_VC0_DYN_MASK   0x000000007f000000

/*   SH_XNLB_INTRA_FLOW_CREDIT_VC0_CAP                                  */
/*   Description:  vc0 credit captured value                            */
#define SH_XNLB_INTRA_FLOW_CREDIT_VC0_CAP_SHFT   32
#define SH_XNLB_INTRA_FLOW_CREDIT_VC0_CAP_MASK   0x0000007f00000000

/*   SH_XNLB_INTRA_FLOW_CREDIT_VC2_TEST                                 */
/*   Description:  vc2 credit_test                                      */
#define SH_XNLB_INTRA_FLOW_CREDIT_VC2_TEST_SHFT  40
#define SH_XNLB_INTRA_FLOW_CREDIT_VC2_TEST_MASK  0x00007f0000000000

/*   SH_XNLB_INTRA_FLOW_CREDIT_VC2_DYN                                  */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNLB_INTRA_FLOW_CREDIT_VC2_DYN_SHFT   48
#define SH_XNLB_INTRA_FLOW_CREDIT_VC2_DYN_MASK   0x007f000000000000

/*   SH_XNLB_INTRA_FLOW_CREDIT_VC2_CAP                                  */
/*   Description:  vc2 credit captured value                            */
#define SH_XNLB_INTRA_FLOW_CREDIT_VC2_CAP_SHFT   56
#define SH_XNLB_INTRA_FLOW_CREDIT_VC2_CAP_MASK   0x7f00000000000000

/*   SH_XNLB_INTRA_FLOW_DISABLE_BYPASS_IN                               */
#define SH_XNLB_INTRA_FLOW_DISABLE_BYPASS_IN_SHFT 63
#define SH_XNLB_INTRA_FLOW_DISABLE_BYPASS_IN_MASK 0x8000000000000000

/* ==================================================================== */
/*             Register "SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT"             */
/* ==================================================================== */

#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT        0x0000000150030220
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_MASK   0x7f7f007f7f00bfbf
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_INIT   0x0000000000000000

/*   SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC0_WITHHOLD                     */
/*   Description:  vc0 withhold                                         */
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC0_FORCE_CRED                   */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC2_WITHHOLD                     */
/*   Description:  vc2 withhold                                         */
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC2_FORCE_CRED                   */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC0_DYN                          */
/*   Description:  vc0 debit dynamic value                              */
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC0_DYN_SHFT 24
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC0_DYN_MASK 0x000000007f000000

/*   SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC0_CAP                          */
/*   Description:  vc0 debit captured value                             */
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC0_CAP_SHFT 32
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC0_CAP_MASK 0x0000007f00000000

/*   SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC2_DYN                          */
/*   Description:  vc2 debit dynamic value                              */
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC2_DYN_SHFT 48
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC2_DYN_MASK 0x007f000000000000

/*   SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC2_CAP                          */
/*   Description:  vc2 debit captured value                             */
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC2_CAP_SHFT 56
#define SH_XNIILB_TO_NI0_INTRA_FLOW_DEBIT_VC2_CAP_MASK 0x7f00000000000000

/* ==================================================================== */
/*             Register "SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT"             */
/* ==================================================================== */

#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT        0x0000000150030230
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_MASK   0x7f7f007f7f00bfbf
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_INIT   0x0000000000000000

/*   SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC0_WITHHOLD                     */
/*   Description:  vc0 withhold                                         */
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC0_FORCE_CRED                   */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC2_WITHHOLD                     */
/*   Description:  vc2 withhold                                         */
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC2_FORCE_CRED                   */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC0_DYN                          */
/*   Description:  vc0 debit dynamic value                              */
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC0_DYN_SHFT 24
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC0_DYN_MASK 0x000000007f000000

/*   SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC0_CAP                          */
/*   Description:  vc0 debit captured value                             */
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC0_CAP_SHFT 32
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC0_CAP_MASK 0x0000007f00000000

/*   SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC2_DYN                          */
/*   Description:  vc2 debit dynamic value                              */
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC2_DYN_SHFT 48
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC2_DYN_MASK 0x007f000000000000

/*   SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC2_CAP                          */
/*   Description:  vc2 debit captured value                             */
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC2_CAP_SHFT 56
#define SH_XNIILB_TO_NI1_INTRA_FLOW_DEBIT_VC2_CAP_MASK 0x7f00000000000000

/* ==================================================================== */
/*             Register "SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT"              */
/* ==================================================================== */

#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT         0x0000000150030240
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_MASK    0x7f7f007f7f00bfbf
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_INIT    0x0000000000000000

/*   SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC0_WITHHOLD                      */
/*   Description:  vc0 withhold                                         */
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC0_FORCE_CRED                    */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC2_WITHHOLD                      */
/*   Description:  vc2 withhold                                         */
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC2_FORCE_CRED                    */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC0_DYN                           */
/*   Description:  vc0 debit dynamic value                              */
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC0_DYN_SHFT 24
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC0_DYN_MASK 0x000000007f000000

/*   SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC0_CAP                           */
/*   Description:  vc0 debit captured value                             */
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC0_CAP_SHFT 32
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC0_CAP_MASK 0x0000007f00000000

/*   SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC2_DYN                           */
/*   Description:  vc2 debit dynamic value                              */
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC2_DYN_SHFT 48
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC2_DYN_MASK 0x007f000000000000

/*   SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC2_CAP                           */
/*   Description:  vc2 debit captured value                             */
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC2_CAP_SHFT 56
#define SH_XNIILB_TO_MD_INTRA_FLOW_DEBIT_VC2_CAP_MASK 0x7f00000000000000

/* ==================================================================== */
/*            Register "SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT"             */
/* ==================================================================== */

#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT       0x0000000150030250
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_MASK  0x7f7f007f7f00bfbf
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_INIT  0x0000000000000000

/*   SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC0_WITHHOLD                    */
/*   Description:  vc0 withhold                                         */
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC0_FORCE_CRED                  */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC2_WITHHOLD                    */
/*   Description:  vc2 withhold                                         */
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC2_FORCE_CRED                  */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC0_DYN                         */
/*   Description:  vc0 debit dynamic value                              */
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC0_DYN_SHFT 24
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC0_DYN_MASK 0x000000007f000000

/*   SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC0_CAP                         */
/*   Description:  vc0 debit captured value                             */
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC0_CAP_SHFT 32
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC0_CAP_MASK 0x0000007f00000000

/*   SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC2_DYN                         */
/*   Description:  vc2 debit dynamic value                              */
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC2_DYN_SHFT 48
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC2_DYN_MASK 0x007f000000000000

/*   SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC2_CAP                         */
/*   Description:  vc2 debit captured value                             */
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC2_CAP_SHFT 56
#define SH_XNIILB_TO_IILB_INTRA_FLOW_DEBIT_VC2_CAP_MASK 0x7f00000000000000

/* ==================================================================== */
/*             Register "SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT"              */
/* ==================================================================== */

#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT         0x0000000150030260
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_MASK    0x7f7f007f7f00bfbf
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_INIT    0x0000000000000000

/*   SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC0_WITHHOLD                      */
/*   Description:  vc0 withhold                                         */
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC0_FORCE_CRED                    */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC2_WITHHOLD                      */
/*   Description:  vc2 withhold                                         */
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC2_FORCE_CRED                    */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC0_DYN                           */
/*   Description:  vc0 debit dynamic value                              */
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC0_DYN_SHFT 24
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC0_DYN_MASK 0x000000007f000000

/*   SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC0_CAP                           */
/*   Description:  vc0 debit captured value                             */
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC0_CAP_SHFT 32
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC0_CAP_MASK 0x0000007f00000000

/*   SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC2_DYN                           */
/*   Description:  vc2 debit dynamic value                              */
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC2_DYN_SHFT 48
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC2_DYN_MASK 0x007f000000000000

/*   SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC2_CAP                           */
/*   Description:  vc2 debit captured value                             */
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC2_CAP_SHFT 56
#define SH_XNIILB_TO_PI_INTRA_FLOW_DEBIT_VC2_CAP_MASK 0x7f00000000000000

/* ==================================================================== */
/*            Register "SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT"             */
/* ==================================================================== */

#define SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT       0x0000000150030270
#define SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_MASK  0x00007f7f7f7f7f7f
#define SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_INIT  0x000000000c00000c

/*   SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC0_TEST                        */
/*   Description:  vc0 credit_test                                      */
#define SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC0_TEST_SHFT 0
#define SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC0_TEST_MASK 0x000000000000007f

/*   SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC0_DYN                         */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC0_DYN_SHFT 8
#define SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC0_DYN_MASK 0x0000000000007f00

/*   SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC0_CAP                         */
/*   Description:  vc0 credit captured value                            */
#define SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC0_CAP_SHFT 16
#define SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC0_CAP_MASK 0x00000000007f0000

/*   SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC2_TEST                        */
/*   Description:  vc2 credit_test                                      */
#define SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC2_TEST_SHFT 24
#define SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC2_TEST_MASK 0x000000007f000000

/*   SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC2_DYN                         */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC2_DYN_SHFT 32
#define SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC2_DYN_MASK 0x0000007f00000000

/*   SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC2_CAP                         */
/*   Description:  vc2 credit captured value                            */
#define SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC2_CAP_SHFT 40
#define SH_XNIILB_FR_NI0_INTRA_FLOW_CREDIT_VC2_CAP_MASK 0x00007f0000000000

/* ==================================================================== */
/*            Register "SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT"             */
/* ==================================================================== */

#define SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT       0x0000000150030280
#define SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_MASK  0x00007f7f7f7f7f7f
#define SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_INIT  0x000000000c00000c

/*   SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC0_TEST                        */
/*   Description:  vc0 credit_test                                      */
#define SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC0_TEST_SHFT 0
#define SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC0_TEST_MASK 0x000000000000007f

/*   SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC0_DYN                         */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC0_DYN_SHFT 8
#define SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC0_DYN_MASK 0x0000000000007f00

/*   SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC0_CAP                         */
/*   Description:  vc0 credit captured value                            */
#define SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC0_CAP_SHFT 16
#define SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC0_CAP_MASK 0x00000000007f0000

/*   SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC2_TEST                        */
/*   Description:  vc2 credit_test                                      */
#define SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC2_TEST_SHFT 24
#define SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC2_TEST_MASK 0x000000007f000000

/*   SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC2_DYN                         */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC2_DYN_SHFT 32
#define SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC2_DYN_MASK 0x0000007f00000000

/*   SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC2_CAP                         */
/*   Description:  vc2 credit captured value                            */
#define SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC2_CAP_SHFT 40
#define SH_XNIILB_FR_NI1_INTRA_FLOW_CREDIT_VC2_CAP_MASK 0x00007f0000000000

/* ==================================================================== */
/*             Register "SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT"             */
/* ==================================================================== */

#define SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT        0x0000000150030290
#define SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_MASK   0x00007f7f7f7f7f7f
#define SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_INIT   0x000000000c00000c

/*   SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC0_TEST                         */
/*   Description:  vc0 credit_test                                      */
#define SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC0_TEST_SHFT 0
#define SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC0_TEST_MASK 0x000000000000007f

/*   SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC0_DYN                          */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC0_DYN_SHFT 8
#define SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC0_DYN_MASK 0x0000000000007f00

/*   SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC0_CAP                          */
/*   Description:  vc0 credit captured value                            */
#define SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC0_CAP_SHFT 16
#define SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC0_CAP_MASK 0x00000000007f0000

/*   SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC2_TEST                         */
/*   Description:  vc2 credit_test                                      */
#define SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC2_TEST_SHFT 24
#define SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC2_TEST_MASK 0x000000007f000000

/*   SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC2_DYN                          */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC2_DYN_SHFT 32
#define SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC2_DYN_MASK 0x0000007f00000000

/*   SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC2_CAP                          */
/*   Description:  vc2 credit captured value                            */
#define SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC2_CAP_SHFT 40
#define SH_XNIILB_FR_MD_INTRA_FLOW_CREDIT_VC2_CAP_MASK 0x00007f0000000000

/* ==================================================================== */
/*            Register "SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT"            */
/* ==================================================================== */

#define SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT      0x00000001500302a0
#define SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_MASK 0x00007f7f7f7f7f7f
#define SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_INIT 0x000000000c00000c

/*   SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC0_TEST                       */
/*   Description:  vc0 credit_test                                      */
#define SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC0_TEST_SHFT 0
#define SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC0_TEST_MASK 0x000000000000007f

/*   SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC0_DYN                        */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC0_DYN_SHFT 8
#define SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC0_DYN_MASK 0x0000000000007f00

/*   SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC0_CAP                        */
/*   Description:  vc0 credit captured value                            */
#define SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC0_CAP_SHFT 16
#define SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC0_CAP_MASK 0x00000000007f0000

/*   SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC2_TEST                       */
/*   Description:  vc2 credit_test                                      */
#define SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC2_TEST_SHFT 24
#define SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC2_TEST_MASK 0x000000007f000000

/*   SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC2_DYN                        */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC2_DYN_SHFT 32
#define SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC2_DYN_MASK 0x0000007f00000000

/*   SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC2_CAP                        */
/*   Description:  vc2 credit captured value                            */
#define SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC2_CAP_SHFT 40
#define SH_XNIILB_FR_IILB_INTRA_FLOW_CREDIT_VC2_CAP_MASK 0x00007f0000000000

/* ==================================================================== */
/*             Register "SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT"             */
/* ==================================================================== */

#define SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT        0x00000001500302b0
#define SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_MASK   0x00007f7f7f7f7f7f
#define SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_INIT   0x000000000c00000c

/*   SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC0_TEST                         */
/*   Description:  vc0 credit_test                                      */
#define SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC0_TEST_SHFT 0
#define SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC0_TEST_MASK 0x000000000000007f

/*   SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC0_DYN                          */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC0_DYN_SHFT 8
#define SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC0_DYN_MASK 0x0000000000007f00

/*   SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC0_CAP                          */
/*   Description:  vc0 credit captured value                            */
#define SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC0_CAP_SHFT 16
#define SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC0_CAP_MASK 0x00000000007f0000

/*   SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC2_TEST                         */
/*   Description:  vc2 credit_test                                      */
#define SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC2_TEST_SHFT 24
#define SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC2_TEST_MASK 0x000000007f000000

/*   SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC2_DYN                          */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC2_DYN_SHFT 32
#define SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC2_DYN_MASK 0x0000007f00000000

/*   SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC2_CAP                          */
/*   Description:  vc2 credit captured value                            */
#define SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC2_CAP_SHFT 40
#define SH_XNIILB_FR_PI_INTRA_FLOW_CREDIT_VC2_CAP_MASK 0x00007f0000000000

/* ==================================================================== */
/*              Register "SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT"              */
/* ==================================================================== */

#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT          0x0000000150030300
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_MASK     0x7f7f007f7f00bfbf
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_INIT     0x0000000000000000

/*   SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC0_WITHHOLD                       */
/*   Description:  vc0 withhold                                         */
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC0_FORCE_CRED                     */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC2_WITHHOLD                       */
/*   Description:  vc2 withhold                                         */
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC2_FORCE_CRED                     */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC0_DYN                            */
/*   Description:  vc0 debit dynamic value                              */
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC0_DYN_SHFT 24
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC0_DYN_MASK 0x000000007f000000

/*   SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC0_CAP                            */
/*   Description:  vc0 debit captured value                             */
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC0_CAP_SHFT 32
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC0_CAP_MASK 0x0000007f00000000

/*   SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC2_DYN                            */
/*   Description:  vc2 debit dynamic value                              */
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC2_DYN_SHFT 48
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC2_DYN_MASK 0x007f000000000000

/*   SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC2_CAP                            */
/*   Description:  vc2 debit captured value                             */
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC2_CAP_SHFT 56
#define SH_XNNI0_TO_PI_INTRA_FLOW_DEBIT_VC2_CAP_MASK 0x7f00000000000000

/* ==================================================================== */
/*              Register "SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT"              */
/* ==================================================================== */

#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT          0x0000000150030310
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_MASK     0x7f7f007f7f00bfbf
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_INIT     0x0000000000000000

/*   SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC0_WITHHOLD                       */
/*   Description:  vc0 withhold                                         */
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC0_FORCE_CRED                     */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC2_WITHHOLD                       */
/*   Description:  vc2 withhold                                         */
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC2_FORCE_CRED                     */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC0_DYN                            */
/*   Description:  vc0 debit dynamic value                              */
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC0_DYN_SHFT 24
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC0_DYN_MASK 0x000000007f000000

/*   SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC0_CAP                            */
/*   Description:  vc0 debit captured value                             */
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC0_CAP_SHFT 32
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC0_CAP_MASK 0x0000007f00000000

/*   SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC2_DYN                            */
/*   Description:  vc2 debit dynamic value                              */
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC2_DYN_SHFT 48
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC2_DYN_MASK 0x007f000000000000

/*   SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC2_CAP                            */
/*   Description:  vc2 debit captured value                             */
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC2_CAP_SHFT 56
#define SH_XNNI0_TO_MD_INTRA_FLOW_DEBIT_VC2_CAP_MASK 0x7f00000000000000

/* ==================================================================== */
/*             Register "SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT"             */
/* ==================================================================== */

#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT        0x0000000150030320
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_MASK   0x7f7f007f7f00bfbf
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_INIT   0x0000000000000000

/*   SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC0_WITHHOLD                     */
/*   Description:  vc0 withhold                                         */
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC0_FORCE_CRED                   */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC2_WITHHOLD                     */
/*   Description:  vc2 withhold                                         */
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC2_FORCE_CRED                   */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC0_DYN                          */
/*   Description:  vc0 debit dynamic value                              */
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC0_DYN_SHFT 24
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC0_DYN_MASK 0x000000007f000000

/*   SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC0_CAP                          */
/*   Description:  vc0 debit captured value                             */
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC0_CAP_SHFT 32
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC0_CAP_MASK 0x0000007f00000000

/*   SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC2_DYN                          */
/*   Description:  vc2 debit dynamic value                              */
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC2_DYN_SHFT 48
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC2_DYN_MASK 0x007f000000000000

/*   SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC2_CAP                          */
/*   Description:  vc2 debit captured value                             */
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC2_CAP_SHFT 56
#define SH_XNNI0_TO_IILB_INTRA_FLOW_DEBIT_VC2_CAP_MASK 0x7f00000000000000

/* ==================================================================== */
/*             Register "SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT"              */
/* ==================================================================== */

#define SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT         0x0000000150030330
#define SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_MASK    0x00007f7f7f7f7f7f
#define SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_INIT    0x000000000c00000c

/*   SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC0_TEST                          */
/*   Description:  vc0 credit_test                                      */
#define SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC0_TEST_SHFT 0
#define SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC0_TEST_MASK 0x000000000000007f

/*   SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC0_DYN                           */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC0_DYN_SHFT 8
#define SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC0_DYN_MASK 0x0000000000007f00

/*   SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC0_CAP                           */
/*   Description:  vc0 credit captured value                            */
#define SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC0_CAP_SHFT 16
#define SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC0_CAP_MASK 0x00000000007f0000

/*   SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC2_TEST                          */
/*   Description:  vc2 credit_test                                      */
#define SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC2_TEST_SHFT 24
#define SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC2_TEST_MASK 0x000000007f000000

/*   SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC2_DYN                           */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC2_DYN_SHFT 32
#define SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC2_DYN_MASK 0x0000007f00000000

/*   SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC2_CAP                           */
/*   Description:  vc2 credit captured value                            */
#define SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC2_CAP_SHFT 40
#define SH_XNNI0_FR_PI_INTRA_FLOW_CREDIT_VC2_CAP_MASK 0x00007f0000000000

/* ==================================================================== */
/*             Register "SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT"              */
/* ==================================================================== */

#define SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT         0x0000000150030340
#define SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_MASK    0x00007f7f7f7f7f7f
#define SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_INIT    0x000000000c00000c

/*   SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC0_TEST                          */
/*   Description:  vc0 credit_test                                      */
#define SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC0_TEST_SHFT 0
#define SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC0_TEST_MASK 0x000000000000007f

/*   SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC0_DYN                           */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC0_DYN_SHFT 8
#define SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC0_DYN_MASK 0x0000000000007f00

/*   SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC0_CAP                           */
/*   Description:  vc0 credit captured value                            */
#define SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC0_CAP_SHFT 16
#define SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC0_CAP_MASK 0x00000000007f0000

/*   SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC2_TEST                          */
/*   Description:  vc2 credit_test                                      */
#define SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC2_TEST_SHFT 24
#define SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC2_TEST_MASK 0x000000007f000000

/*   SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC2_DYN                           */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC2_DYN_SHFT 32
#define SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC2_DYN_MASK 0x0000007f00000000

/*   SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC2_CAP                           */
/*   Description:  vc2 credit captured value                            */
#define SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC2_CAP_SHFT 40
#define SH_XNNI0_FR_MD_INTRA_FLOW_CREDIT_VC2_CAP_MASK 0x00007f0000000000

/* ==================================================================== */
/*            Register "SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT"             */
/* ==================================================================== */

#define SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT       0x0000000150030350
#define SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_MASK  0x00007f7f7f7f7f7f
#define SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_INIT  0x000000000c00000c

/*   SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC0_TEST                        */
/*   Description:  vc0 credit_test                                      */
#define SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC0_TEST_SHFT 0
#define SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC0_TEST_MASK 0x000000000000007f

/*   SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC0_DYN                         */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC0_DYN_SHFT 8
#define SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC0_DYN_MASK 0x0000000000007f00

/*   SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC0_CAP                         */
/*   Description:  vc0 credit captured value                            */
#define SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC0_CAP_SHFT 16
#define SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC0_CAP_MASK 0x00000000007f0000

/*   SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC2_TEST                        */
/*   Description:  vc2 credit_test                                      */
#define SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC2_TEST_SHFT 24
#define SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC2_TEST_MASK 0x000000007f000000

/*   SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC2_DYN                         */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC2_DYN_SHFT 32
#define SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC2_DYN_MASK 0x0000007f00000000

/*   SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC2_CAP                         */
/*   Description:  vc2 credit captured value                            */
#define SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC2_CAP_SHFT 40
#define SH_XNNI0_FR_IILB_INTRA_FLOW_CREDIT_VC2_CAP_MASK 0x00007f0000000000

/* ==================================================================== */
/*                  Register "SH_XNNI0_0_INTRANI_FLOW"                  */
/* ==================================================================== */

#define SH_XNNI0_0_INTRANI_FLOW                  0x0000000150030360
#define SH_XNNI0_0_INTRANI_FLOW_MASK             0x00000000000000bf
#define SH_XNNI0_0_INTRANI_FLOW_INIT             0x0000000000000000

/*   SH_XNNI0_0_INTRANI_FLOW_DEBIT_VC0_WITHHOLD                         */
/*   Description:  vc0 withhold                                         */
#define SH_XNNI0_0_INTRANI_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNNI0_0_INTRANI_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI0_0_INTRANI_FLOW_DEBIT_VC0_FORCE_CRED                       */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNNI0_0_INTRANI_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNNI0_0_INTRANI_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/* ==================================================================== */
/*                  Register "SH_XNNI0_1_INTRANI_FLOW"                  */
/* ==================================================================== */

#define SH_XNNI0_1_INTRANI_FLOW                  0x0000000150030370
#define SH_XNNI0_1_INTRANI_FLOW_MASK             0x00000000000000bf
#define SH_XNNI0_1_INTRANI_FLOW_INIT             0x0000000000000000

/*   SH_XNNI0_1_INTRANI_FLOW_DEBIT_VC1_WITHHOLD                         */
/*   Description:  vc1 withhold                                         */
#define SH_XNNI0_1_INTRANI_FLOW_DEBIT_VC1_WITHHOLD_SHFT 0
#define SH_XNNI0_1_INTRANI_FLOW_DEBIT_VC1_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI0_1_INTRANI_FLOW_DEBIT_VC1_FORCE_CRED                       */
/*   Description:  Force Credit on VC1 from debit cntr                  */
#define SH_XNNI0_1_INTRANI_FLOW_DEBIT_VC1_FORCE_CRED_SHFT 7
#define SH_XNNI0_1_INTRANI_FLOW_DEBIT_VC1_FORCE_CRED_MASK 0x0000000000000080

/* ==================================================================== */
/*                  Register "SH_XNNI0_2_INTRANI_FLOW"                  */
/* ==================================================================== */

#define SH_XNNI0_2_INTRANI_FLOW                  0x0000000150030380
#define SH_XNNI0_2_INTRANI_FLOW_MASK             0x00000000000000bf
#define SH_XNNI0_2_INTRANI_FLOW_INIT             0x0000000000000000

/*   SH_XNNI0_2_INTRANI_FLOW_DEBIT_VC2_WITHHOLD                         */
/*   Description:  vc2 withhold                                         */
#define SH_XNNI0_2_INTRANI_FLOW_DEBIT_VC2_WITHHOLD_SHFT 0
#define SH_XNNI0_2_INTRANI_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI0_2_INTRANI_FLOW_DEBIT_VC2_FORCE_CRED                       */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNNI0_2_INTRANI_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 7
#define SH_XNNI0_2_INTRANI_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000000080

/* ==================================================================== */
/*                  Register "SH_XNNI0_3_INTRANI_FLOW"                  */
/* ==================================================================== */

#define SH_XNNI0_3_INTRANI_FLOW                  0x0000000150030390
#define SH_XNNI0_3_INTRANI_FLOW_MASK             0x00000000000000bf
#define SH_XNNI0_3_INTRANI_FLOW_INIT             0x0000000000000000

/*   SH_XNNI0_3_INTRANI_FLOW_DEBIT_VC3_WITHHOLD                         */
/*   Description:  vc3 withhold                                         */
#define SH_XNNI0_3_INTRANI_FLOW_DEBIT_VC3_WITHHOLD_SHFT 0
#define SH_XNNI0_3_INTRANI_FLOW_DEBIT_VC3_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI0_3_INTRANI_FLOW_DEBIT_VC3_FORCE_CRED                       */
/*   Description:  Force Credit on VC3 from debit cntr                  */
#define SH_XNNI0_3_INTRANI_FLOW_DEBIT_VC3_FORCE_CRED_SHFT 7
#define SH_XNNI0_3_INTRANI_FLOW_DEBIT_VC3_FORCE_CRED_MASK 0x0000000000000080

/* ==================================================================== */
/*                  Register "SH_XNNI0_VCSWITCH_FLOW"                   */
/* ==================================================================== */

#define SH_XNNI0_VCSWITCH_FLOW                   0x00000001500303a0
#define SH_XNNI0_VCSWITCH_FLOW_MASK              0x0000000701010101
#define SH_XNNI0_VCSWITCH_FLOW_INIT              0x0000000000000000

/*   SH_XNNI0_VCSWITCH_FLOW_NI_VCFIFO_DATELINE_SWITCH                   */
/*   Description:  Swap VC0/2 with VC1/3                                */
#define SH_XNNI0_VCSWITCH_FLOW_NI_VCFIFO_DATELINE_SWITCH_SHFT 0
#define SH_XNNI0_VCSWITCH_FLOW_NI_VCFIFO_DATELINE_SWITCH_MASK 0x0000000000000001

/*   SH_XNNI0_VCSWITCH_FLOW_PI_VCFIFO_SWITCH                            */
/*   Description:  Swap VC0/2 with VC1/3                                */
#define SH_XNNI0_VCSWITCH_FLOW_PI_VCFIFO_SWITCH_SHFT 8
#define SH_XNNI0_VCSWITCH_FLOW_PI_VCFIFO_SWITCH_MASK 0x0000000000000100

/*   SH_XNNI0_VCSWITCH_FLOW_MD_VCFIFO_SWITCH                            */
/*   Description:  Swap VC0/2 with VC1/3                                */
#define SH_XNNI0_VCSWITCH_FLOW_MD_VCFIFO_SWITCH_SHFT 16
#define SH_XNNI0_VCSWITCH_FLOW_MD_VCFIFO_SWITCH_MASK 0x0000000000010000

/*   SH_XNNI0_VCSWITCH_FLOW_IILB_VCFIFO_SWITCH                          */
/*   Description:  Swap VC0/2 with VC1/3                                */
#define SH_XNNI0_VCSWITCH_FLOW_IILB_VCFIFO_SWITCH_SHFT 24
#define SH_XNNI0_VCSWITCH_FLOW_IILB_VCFIFO_SWITCH_MASK 0x0000000001000000

/*   SH_XNNI0_VCSWITCH_FLOW_DISABLE_SYNC_BYPASS_IN                      */
#define SH_XNNI0_VCSWITCH_FLOW_DISABLE_SYNC_BYPASS_IN_SHFT 32
#define SH_XNNI0_VCSWITCH_FLOW_DISABLE_SYNC_BYPASS_IN_MASK 0x0000000100000000

/*   SH_XNNI0_VCSWITCH_FLOW_DISABLE_SYNC_BYPASS_OUT                     */
#define SH_XNNI0_VCSWITCH_FLOW_DISABLE_SYNC_BYPASS_OUT_SHFT 33
#define SH_XNNI0_VCSWITCH_FLOW_DISABLE_SYNC_BYPASS_OUT_MASK 0x0000000200000000

/*   SH_XNNI0_VCSWITCH_FLOW_ASYNC_FIFOES                                */
#define SH_XNNI0_VCSWITCH_FLOW_ASYNC_FIFOES_SHFT 34
#define SH_XNNI0_VCSWITCH_FLOW_ASYNC_FIFOES_MASK 0x0000000400000000

/* ==================================================================== */
/*                    Register "SH_XNNI0_TIMER_REG"                     */
/* ==================================================================== */

#define SH_XNNI0_TIMER_REG                       0x00000001500303b0
#define SH_XNNI0_TIMER_REG_MASK                  0x0000000100ffffff
#define SH_XNNI0_TIMER_REG_INIT                  0x0000000000ffffff

/*   SH_XNNI0_TIMER_REG_TIMEOUT_REG                                     */
/*   Description:  Master Timeout Counter                               */
#define SH_XNNI0_TIMER_REG_TIMEOUT_REG_SHFT      0
#define SH_XNNI0_TIMER_REG_TIMEOUT_REG_MASK      0x0000000000ffffff

/*   SH_XNNI0_TIMER_REG_LINKCLEANUP_REG                                 */
/*   Description:  Link Clean Up                                        */
#define SH_XNNI0_TIMER_REG_LINKCLEANUP_REG_SHFT  32
#define SH_XNNI0_TIMER_REG_LINKCLEANUP_REG_MASK  0x0000000100000000

/* ==================================================================== */
/*                   Register "SH_XNNI0_FIFO02_FLOW"                    */
/* ==================================================================== */

#define SH_XNNI0_FIFO02_FLOW                     0x00000001500303c0
#define SH_XNNI0_FIFO02_FLOW_MASK                0x00000f0f0f0f0f0f
#define SH_XNNI0_FIFO02_FLOW_INIT                0x0000000000000000

/*   SH_XNNI0_FIFO02_FLOW_COUNT_VC0_LIMIT                               */
/*   Description:  limit reg zero disables functionality                */
#define SH_XNNI0_FIFO02_FLOW_COUNT_VC0_LIMIT_SHFT 0
#define SH_XNNI0_FIFO02_FLOW_COUNT_VC0_LIMIT_MASK 0x000000000000000f

/*   SH_XNNI0_FIFO02_FLOW_COUNT_VC0_DYN                                 */
/*   Description:  dynamic counter value                                */
#define SH_XNNI0_FIFO02_FLOW_COUNT_VC0_DYN_SHFT  8
#define SH_XNNI0_FIFO02_FLOW_COUNT_VC0_DYN_MASK  0x0000000000000f00

/*   SH_XNNI0_FIFO02_FLOW_COUNT_VC0_CAP                                 */
/*   Description:  captured counter value                               */
#define SH_XNNI0_FIFO02_FLOW_COUNT_VC0_CAP_SHFT  16
#define SH_XNNI0_FIFO02_FLOW_COUNT_VC0_CAP_MASK  0x00000000000f0000

/*   SH_XNNI0_FIFO02_FLOW_COUNT_VC2_LIMIT                               */
/*   Description:  limit reg zero disables functionality                */
#define SH_XNNI0_FIFO02_FLOW_COUNT_VC2_LIMIT_SHFT 24
#define SH_XNNI0_FIFO02_FLOW_COUNT_VC2_LIMIT_MASK 0x000000000f000000

/*   SH_XNNI0_FIFO02_FLOW_COUNT_VC2_DYN                                 */
/*   Description:  counter dynamic value                                */
#define SH_XNNI0_FIFO02_FLOW_COUNT_VC2_DYN_SHFT  32
#define SH_XNNI0_FIFO02_FLOW_COUNT_VC2_DYN_MASK  0x0000000f00000000

/*   SH_XNNI0_FIFO02_FLOW_COUNT_VC2_CAP                                 */
/*   Description:  captured counter value                               */
#define SH_XNNI0_FIFO02_FLOW_COUNT_VC2_CAP_SHFT  40
#define SH_XNNI0_FIFO02_FLOW_COUNT_VC2_CAP_MASK  0x00000f0000000000

/* ==================================================================== */
/*                   Register "SH_XNNI0_FIFO13_FLOW"                    */
/* ==================================================================== */

#define SH_XNNI0_FIFO13_FLOW                     0x00000001500303d0
#define SH_XNNI0_FIFO13_FLOW_MASK                0x00000f0f0f0f0f0f
#define SH_XNNI0_FIFO13_FLOW_INIT                0x0000000000000000

/*   SH_XNNI0_FIFO13_FLOW_COUNT_VC1_LIMIT                               */
/*   Description:  limit reg zero disables functionality                */
#define SH_XNNI0_FIFO13_FLOW_COUNT_VC1_LIMIT_SHFT 0
#define SH_XNNI0_FIFO13_FLOW_COUNT_VC1_LIMIT_MASK 0x000000000000000f

/*   SH_XNNI0_FIFO13_FLOW_COUNT_VC1_DYN                                 */
/*   Description:  dynamic counter value                                */
#define SH_XNNI0_FIFO13_FLOW_COUNT_VC1_DYN_SHFT  8
#define SH_XNNI0_FIFO13_FLOW_COUNT_VC1_DYN_MASK  0x0000000000000f00

/*   SH_XNNI0_FIFO13_FLOW_COUNT_VC1_CAP                                 */
/*   Description:  captured counter value                               */
#define SH_XNNI0_FIFO13_FLOW_COUNT_VC1_CAP_SHFT  16
#define SH_XNNI0_FIFO13_FLOW_COUNT_VC1_CAP_MASK  0x00000000000f0000

/*   SH_XNNI0_FIFO13_FLOW_COUNT_VC3_LIMIT                               */
/*   Description:  limit reg zero disables functionality                */
#define SH_XNNI0_FIFO13_FLOW_COUNT_VC3_LIMIT_SHFT 24
#define SH_XNNI0_FIFO13_FLOW_COUNT_VC3_LIMIT_MASK 0x000000000f000000

/*   SH_XNNI0_FIFO13_FLOW_COUNT_VC3_DYN                                 */
/*   Description:  counter dynamic value                                */
#define SH_XNNI0_FIFO13_FLOW_COUNT_VC3_DYN_SHFT  32
#define SH_XNNI0_FIFO13_FLOW_COUNT_VC3_DYN_MASK  0x0000000f00000000

/*   SH_XNNI0_FIFO13_FLOW_COUNT_VC3_CAP                                 */
/*   Description:  captured counter value                               */
#define SH_XNNI0_FIFO13_FLOW_COUNT_VC3_CAP_SHFT  40
#define SH_XNNI0_FIFO13_FLOW_COUNT_VC3_CAP_MASK  0x00000f0000000000

/* ==================================================================== */
/*                     Register "SH_XNNI0_NI_FLOW"                      */
/* ==================================================================== */

#define SH_XNNI0_NI_FLOW                         0x00000001500303e0
#define SH_XNNI0_NI_FLOW_MASK                    0xff0fff0fff0fff0f
#define SH_XNNI0_NI_FLOW_INIT                    0x0000000000000000

/*   SH_XNNI0_NI_FLOW_VC0_LIMIT                                         */
/*   Description:  vc0 limit reg, zero disables functionality           */
#define SH_XNNI0_NI_FLOW_VC0_LIMIT_SHFT          0
#define SH_XNNI0_NI_FLOW_VC0_LIMIT_MASK          0x000000000000000f

/*   SH_XNNI0_NI_FLOW_VC0_DYN                                           */
/*   Description:  vc0 counter dynamic value                            */
#define SH_XNNI0_NI_FLOW_VC0_DYN_SHFT            8
#define SH_XNNI0_NI_FLOW_VC0_DYN_MASK            0x0000000000000f00

/*   SH_XNNI0_NI_FLOW_VC0_CAP                                           */
/*   Description:  vc0 counter captured value                           */
#define SH_XNNI0_NI_FLOW_VC0_CAP_SHFT            12
#define SH_XNNI0_NI_FLOW_VC0_CAP_MASK            0x000000000000f000

/*   SH_XNNI0_NI_FLOW_VC1_LIMIT                                         */
/*   Description:  vc1 limit reg, zero disables functionality           */
#define SH_XNNI0_NI_FLOW_VC1_LIMIT_SHFT          16
#define SH_XNNI0_NI_FLOW_VC1_LIMIT_MASK          0x00000000000f0000

/*   SH_XNNI0_NI_FLOW_VC1_DYN                                           */
/*   Description:  vc1 counter dynamic value                            */
#define SH_XNNI0_NI_FLOW_VC1_DYN_SHFT            24
#define SH_XNNI0_NI_FLOW_VC1_DYN_MASK            0x000000000f000000

/*   SH_XNNI0_NI_FLOW_VC1_CAP                                           */
/*   Description:  vc1 counter captured value                           */
#define SH_XNNI0_NI_FLOW_VC1_CAP_SHFT            28
#define SH_XNNI0_NI_FLOW_VC1_CAP_MASK            0x00000000f0000000

/*   SH_XNNI0_NI_FLOW_VC2_LIMIT                                         */
/*   Description:  vc2 limit reg, zero disables functionality           */
#define SH_XNNI0_NI_FLOW_VC2_LIMIT_SHFT          32
#define SH_XNNI0_NI_FLOW_VC2_LIMIT_MASK          0x0000000f00000000

/*   SH_XNNI0_NI_FLOW_VC2_DYN                                           */
/*   Description:  vc2 counter dynamic value                            */
#define SH_XNNI0_NI_FLOW_VC2_DYN_SHFT            40
#define SH_XNNI0_NI_FLOW_VC2_DYN_MASK            0x00000f0000000000

/*   SH_XNNI0_NI_FLOW_VC2_CAP                                           */
/*   Description:  vc2 counter captured value                           */
#define SH_XNNI0_NI_FLOW_VC2_CAP_SHFT            44
#define SH_XNNI0_NI_FLOW_VC2_CAP_MASK            0x0000f00000000000

/*   SH_XNNI0_NI_FLOW_VC3_LIMIT                                         */
/*   Description:  vc3 limit reg, zero disables functionality           */
#define SH_XNNI0_NI_FLOW_VC3_LIMIT_SHFT          48
#define SH_XNNI0_NI_FLOW_VC3_LIMIT_MASK          0x000f000000000000

/*   SH_XNNI0_NI_FLOW_VC3_DYN                                           */
/*   Description:  vc3 counter dynamic value                            */
#define SH_XNNI0_NI_FLOW_VC3_DYN_SHFT            56
#define SH_XNNI0_NI_FLOW_VC3_DYN_MASK            0x0f00000000000000

/*   SH_XNNI0_NI_FLOW_VC3_CAP                                           */
/*   Description:  vc3 counter captured value                           */
#define SH_XNNI0_NI_FLOW_VC3_CAP_SHFT            60
#define SH_XNNI0_NI_FLOW_VC3_CAP_MASK            0xf000000000000000

/* ==================================================================== */
/*                    Register "SH_XNNI0_DEAD_FLOW"                     */
/* ==================================================================== */

#define SH_XNNI0_DEAD_FLOW                       0x00000001500303f0
#define SH_XNNI0_DEAD_FLOW_MASK                  0xff0fff0fff0fff0f
#define SH_XNNI0_DEAD_FLOW_INIT                  0x0000000000000000

/*   SH_XNNI0_DEAD_FLOW_VC0_LIMIT                                       */
/*   Description:  vc0 limit reg, zero disables functionality           */
#define SH_XNNI0_DEAD_FLOW_VC0_LIMIT_SHFT        0
#define SH_XNNI0_DEAD_FLOW_VC0_LIMIT_MASK        0x000000000000000f

/*   SH_XNNI0_DEAD_FLOW_VC0_DYN                                         */
/*   Description:  vc0 counter dynamic value                            */
#define SH_XNNI0_DEAD_FLOW_VC0_DYN_SHFT          8
#define SH_XNNI0_DEAD_FLOW_VC0_DYN_MASK          0x0000000000000f00

/*   SH_XNNI0_DEAD_FLOW_VC0_CAP                                         */
/*   Description:  vc0 counter captured value                           */
#define SH_XNNI0_DEAD_FLOW_VC0_CAP_SHFT          12
#define SH_XNNI0_DEAD_FLOW_VC0_CAP_MASK          0x000000000000f000

/*   SH_XNNI0_DEAD_FLOW_VC1_LIMIT                                       */
/*   Description:  vc1 limit reg, zero disables functionality           */
#define SH_XNNI0_DEAD_FLOW_VC1_LIMIT_SHFT        16
#define SH_XNNI0_DEAD_FLOW_VC1_LIMIT_MASK        0x00000000000f0000

/*   SH_XNNI0_DEAD_FLOW_VC1_DYN                                         */
/*   Description:  vc1 counter dynamic value                            */
#define SH_XNNI0_DEAD_FLOW_VC1_DYN_SHFT          24
#define SH_XNNI0_DEAD_FLOW_VC1_DYN_MASK          0x000000000f000000

/*   SH_XNNI0_DEAD_FLOW_VC1_CAP                                         */
/*   Description:  vc1 counter captured value                           */
#define SH_XNNI0_DEAD_FLOW_VC1_CAP_SHFT          28
#define SH_XNNI0_DEAD_FLOW_VC1_CAP_MASK          0x00000000f0000000

/*   SH_XNNI0_DEAD_FLOW_VC2_LIMIT                                       */
/*   Description:  vc2 limit reg, zero disables functionality           */
#define SH_XNNI0_DEAD_FLOW_VC2_LIMIT_SHFT        32
#define SH_XNNI0_DEAD_FLOW_VC2_LIMIT_MASK        0x0000000f00000000

/*   SH_XNNI0_DEAD_FLOW_VC2_DYN                                         */
/*   Description:  vc2 counter dynamic value                            */
#define SH_XNNI0_DEAD_FLOW_VC2_DYN_SHFT          40
#define SH_XNNI0_DEAD_FLOW_VC2_DYN_MASK          0x00000f0000000000

/*   SH_XNNI0_DEAD_FLOW_VC2_CAP                                         */
/*   Description:  vc2 counter captured value                           */
#define SH_XNNI0_DEAD_FLOW_VC2_CAP_SHFT          44
#define SH_XNNI0_DEAD_FLOW_VC2_CAP_MASK          0x0000f00000000000

/*   SH_XNNI0_DEAD_FLOW_VC3_LIMIT                                       */
/*   Description:  vc3 limit reg, zero disables functionality           */
#define SH_XNNI0_DEAD_FLOW_VC3_LIMIT_SHFT        48
#define SH_XNNI0_DEAD_FLOW_VC3_LIMIT_MASK        0x000f000000000000

/*   SH_XNNI0_DEAD_FLOW_VC3_DYN                                         */
/*   Description:  vc3 counter dynamic value                            */
#define SH_XNNI0_DEAD_FLOW_VC3_DYN_SHFT          56
#define SH_XNNI0_DEAD_FLOW_VC3_DYN_MASK          0x0f00000000000000

/*   SH_XNNI0_DEAD_FLOW_VC3_CAP                                         */
/*   Description:  vc3 counter captured value                           */
#define SH_XNNI0_DEAD_FLOW_VC3_CAP_SHFT          60
#define SH_XNNI0_DEAD_FLOW_VC3_CAP_MASK          0xf000000000000000

/* ==================================================================== */
/*                    Register "SH_XNNI0_INJECT_AGE"                    */
/* ==================================================================== */

#define SH_XNNI0_INJECT_AGE                      0x0000000150030400
#define SH_XNNI0_INJECT_AGE_MASK                 0x000000000000ffff
#define SH_XNNI0_INJECT_AGE_INIT                 0x0000000000000000

/*   SH_XNNI0_INJECT_AGE_REQUEST_INJECT                                 */
/*   Description:  Value of AGE field for outgoing requests             */
#define SH_XNNI0_INJECT_AGE_REQUEST_INJECT_SHFT  0
#define SH_XNNI0_INJECT_AGE_REQUEST_INJECT_MASK  0x00000000000000ff

/*   SH_XNNI0_INJECT_AGE_REPLY_INJECT                                   */
/*   Description:  Value of AGE field for outgoing replies              */
#define SH_XNNI0_INJECT_AGE_REPLY_INJECT_SHFT    8
#define SH_XNNI0_INJECT_AGE_REPLY_INJECT_MASK    0x000000000000ff00

/* ==================================================================== */
/*              Register "SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT"              */
/* ==================================================================== */

#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT          0x0000000150030500
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_MASK     0x7f7f007f7f00bfbf
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_INIT     0x0000000000000000

/*   SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC0_WITHHOLD                       */
/*   Description:  vc0 withhold                                         */
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC0_FORCE_CRED                     */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC2_WITHHOLD                       */
/*   Description:  vc2 withhold                                         */
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC2_FORCE_CRED                     */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC0_DYN                            */
/*   Description:  vc0 debit dynamic value                              */
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC0_DYN_SHFT 24
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC0_DYN_MASK 0x000000007f000000

/*   SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC0_CAP                            */
/*   Description:  vc0 debit captured value                             */
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC0_CAP_SHFT 32
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC0_CAP_MASK 0x0000007f00000000

/*   SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC2_DYN                            */
/*   Description:  vc2 debit dynamic value                              */
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC2_DYN_SHFT 48
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC2_DYN_MASK 0x007f000000000000

/*   SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC2_CAP                            */
/*   Description:  vc2 debit captured value                             */
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC2_CAP_SHFT 56
#define SH_XNNI1_TO_PI_INTRA_FLOW_DEBIT_VC2_CAP_MASK 0x7f00000000000000

/* ==================================================================== */
/*              Register "SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT"              */
/* ==================================================================== */

#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT          0x0000000150030510
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_MASK     0x7f7f007f7f00bfbf
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_INIT     0x0000000000000000

/*   SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC0_WITHHOLD                       */
/*   Description:  vc0 withhold                                         */
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC0_FORCE_CRED                     */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC2_WITHHOLD                       */
/*   Description:  vc2 withhold                                         */
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC2_FORCE_CRED                     */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC0_DYN                            */
/*   Description:  vc0 debit dynamic value                              */
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC0_DYN_SHFT 24
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC0_DYN_MASK 0x000000007f000000

/*   SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC0_CAP                            */
/*   Description:  vc0 debit captured value                             */
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC0_CAP_SHFT 32
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC0_CAP_MASK 0x0000007f00000000

/*   SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC2_DYN                            */
/*   Description:  vc2 debit dynamic value                              */
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC2_DYN_SHFT 48
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC2_DYN_MASK 0x007f000000000000

/*   SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC2_CAP                            */
/*   Description:  vc2 debit captured value                             */
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC2_CAP_SHFT 56
#define SH_XNNI1_TO_MD_INTRA_FLOW_DEBIT_VC2_CAP_MASK 0x7f00000000000000

/* ==================================================================== */
/*             Register "SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT"             */
/* ==================================================================== */

#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT        0x0000000150030520
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_MASK   0x7f7f007f7f00bfbf
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_INIT   0x0000000000000000

/*   SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC0_WITHHOLD                     */
/*   Description:  vc0 withhold                                         */
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC0_FORCE_CRED                   */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/*   SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC2_WITHHOLD                     */
/*   Description:  vc2 withhold                                         */
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC2_WITHHOLD_SHFT 8
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x0000000000003f00

/*   SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC2_FORCE_CRED                   */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 15
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000008000

/*   SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC0_DYN                          */
/*   Description:  vc0 debit dynamic value                              */
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC0_DYN_SHFT 24
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC0_DYN_MASK 0x000000007f000000

/*   SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC0_CAP                          */
/*   Description:  vc0 debit captured value                             */
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC0_CAP_SHFT 32
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC0_CAP_MASK 0x0000007f00000000

/*   SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC2_DYN                          */
/*   Description:  vc2 debit dynamic value                              */
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC2_DYN_SHFT 48
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC2_DYN_MASK 0x007f000000000000

/*   SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC2_CAP                          */
/*   Description:  vc2 debit captured value                             */
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC2_CAP_SHFT 56
#define SH_XNNI1_TO_IILB_INTRA_FLOW_DEBIT_VC2_CAP_MASK 0x7f00000000000000

/* ==================================================================== */
/*             Register "SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT"              */
/* ==================================================================== */

#define SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT         0x0000000150030530
#define SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_MASK    0x00007f7f7f7f7f7f
#define SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_INIT    0x000000000c00000c

/*   SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC0_TEST                          */
/*   Description:  vc0 credit_test                                      */
#define SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC0_TEST_SHFT 0
#define SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC0_TEST_MASK 0x000000000000007f

/*   SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC0_DYN                           */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC0_DYN_SHFT 8
#define SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC0_DYN_MASK 0x0000000000007f00

/*   SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC0_CAP                           */
/*   Description:  vc0 credit captured value                            */
#define SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC0_CAP_SHFT 16
#define SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC0_CAP_MASK 0x00000000007f0000

/*   SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC2_TEST                          */
/*   Description:  vc2 credit_test                                      */
#define SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC2_TEST_SHFT 24
#define SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC2_TEST_MASK 0x000000007f000000

/*   SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC2_DYN                           */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC2_DYN_SHFT 32
#define SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC2_DYN_MASK 0x0000007f00000000

/*   SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC2_CAP                           */
/*   Description:  vc2 credit captured value                            */
#define SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC2_CAP_SHFT 40
#define SH_XNNI1_FR_PI_INTRA_FLOW_CREDIT_VC2_CAP_MASK 0x00007f0000000000

/* ==================================================================== */
/*             Register "SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT"              */
/* ==================================================================== */

#define SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT         0x0000000150030540
#define SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_MASK    0x00007f7f7f7f7f7f
#define SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_INIT    0x000000000c00000c

/*   SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC0_TEST                          */
/*   Description:  vc0 credit_test                                      */
#define SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC0_TEST_SHFT 0
#define SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC0_TEST_MASK 0x000000000000007f

/*   SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC0_DYN                           */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC0_DYN_SHFT 8
#define SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC0_DYN_MASK 0x0000000000007f00

/*   SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC0_CAP                           */
/*   Description:  vc0 credit captured value                            */
#define SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC0_CAP_SHFT 16
#define SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC0_CAP_MASK 0x00000000007f0000

/*   SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC2_TEST                          */
/*   Description:  vc2 credit_test                                      */
#define SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC2_TEST_SHFT 24
#define SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC2_TEST_MASK 0x000000007f000000

/*   SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC2_DYN                           */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC2_DYN_SHFT 32
#define SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC2_DYN_MASK 0x0000007f00000000

/*   SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC2_CAP                           */
/*   Description:  vc2 credit captured value                            */
#define SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC2_CAP_SHFT 40
#define SH_XNNI1_FR_MD_INTRA_FLOW_CREDIT_VC2_CAP_MASK 0x00007f0000000000

/* ==================================================================== */
/*            Register "SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT"             */
/* ==================================================================== */

#define SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT       0x0000000150030550
#define SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_MASK  0x00007f7f7f7f7f7f
#define SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_INIT  0x000000000c00000c

/*   SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC0_TEST                        */
/*   Description:  vc0 credit_test                                      */
#define SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC0_TEST_SHFT 0
#define SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC0_TEST_MASK 0x000000000000007f

/*   SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC0_DYN                         */
/*   Description:  vc0 credit dynamic value                             */
#define SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC0_DYN_SHFT 8
#define SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC0_DYN_MASK 0x0000000000007f00

/*   SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC0_CAP                         */
/*   Description:  vc0 credit captured value                            */
#define SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC0_CAP_SHFT 16
#define SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC0_CAP_MASK 0x00000000007f0000

/*   SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC2_TEST                        */
/*   Description:  vc2 credit_test                                      */
#define SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC2_TEST_SHFT 24
#define SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC2_TEST_MASK 0x000000007f000000

/*   SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC2_DYN                         */
/*   Description:  vc2 credit dynamic value                             */
#define SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC2_DYN_SHFT 32
#define SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC2_DYN_MASK 0x0000007f00000000

/*   SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC2_CAP                         */
/*   Description:  vc2 credit captured value                            */
#define SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC2_CAP_SHFT 40
#define SH_XNNI1_FR_IILB_INTRA_FLOW_CREDIT_VC2_CAP_MASK 0x00007f0000000000

/* ==================================================================== */
/*                  Register "SH_XNNI1_0_INTRANI_FLOW"                  */
/* ==================================================================== */

#define SH_XNNI1_0_INTRANI_FLOW                  0x0000000150030560
#define SH_XNNI1_0_INTRANI_FLOW_MASK             0x00000000000000bf
#define SH_XNNI1_0_INTRANI_FLOW_INIT             0x0000000000000000

/*   SH_XNNI1_0_INTRANI_FLOW_DEBIT_VC0_WITHHOLD                         */
/*   Description:  vc0 withhold                                         */
#define SH_XNNI1_0_INTRANI_FLOW_DEBIT_VC0_WITHHOLD_SHFT 0
#define SH_XNNI1_0_INTRANI_FLOW_DEBIT_VC0_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI1_0_INTRANI_FLOW_DEBIT_VC0_FORCE_CRED                       */
/*   Description:  Force Credit on VC0 from debit cntr                  */
#define SH_XNNI1_0_INTRANI_FLOW_DEBIT_VC0_FORCE_CRED_SHFT 7
#define SH_XNNI1_0_INTRANI_FLOW_DEBIT_VC0_FORCE_CRED_MASK 0x0000000000000080

/* ==================================================================== */
/*                  Register "SH_XNNI1_1_INTRANI_FLOW"                  */
/* ==================================================================== */

#define SH_XNNI1_1_INTRANI_FLOW                  0x0000000150030570
#define SH_XNNI1_1_INTRANI_FLOW_MASK             0x00000000000000bf
#define SH_XNNI1_1_INTRANI_FLOW_INIT             0x0000000000000000

/*   SH_XNNI1_1_INTRANI_FLOW_DEBIT_VC1_WITHHOLD                         */
/*   Description:  vc1 withhold                                         */
#define SH_XNNI1_1_INTRANI_FLOW_DEBIT_VC1_WITHHOLD_SHFT 0
#define SH_XNNI1_1_INTRANI_FLOW_DEBIT_VC1_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI1_1_INTRANI_FLOW_DEBIT_VC1_FORCE_CRED                       */
/*   Description:  Force Credit on VC1 from debit cntr                  */
#define SH_XNNI1_1_INTRANI_FLOW_DEBIT_VC1_FORCE_CRED_SHFT 7
#define SH_XNNI1_1_INTRANI_FLOW_DEBIT_VC1_FORCE_CRED_MASK 0x0000000000000080

/* ==================================================================== */
/*                  Register "SH_XNNI1_2_INTRANI_FLOW"                  */
/* ==================================================================== */

#define SH_XNNI1_2_INTRANI_FLOW                  0x0000000150030580
#define SH_XNNI1_2_INTRANI_FLOW_MASK             0x00000000000000bf
#define SH_XNNI1_2_INTRANI_FLOW_INIT             0x0000000000000000

/*   SH_XNNI1_2_INTRANI_FLOW_DEBIT_VC2_WITHHOLD                         */
/*   Description:  vc2 withhold                                         */
#define SH_XNNI1_2_INTRANI_FLOW_DEBIT_VC2_WITHHOLD_SHFT 0
#define SH_XNNI1_2_INTRANI_FLOW_DEBIT_VC2_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI1_2_INTRANI_FLOW_DEBIT_VC2_FORCE_CRED                       */
/*   Description:  Force Credit on VC2 from debit cntr                  */
#define SH_XNNI1_2_INTRANI_FLOW_DEBIT_VC2_FORCE_CRED_SHFT 7
#define SH_XNNI1_2_INTRANI_FLOW_DEBIT_VC2_FORCE_CRED_MASK 0x0000000000000080

/* ==================================================================== */
/*                  Register "SH_XNNI1_3_INTRANI_FLOW"                  */
/* ==================================================================== */

#define SH_XNNI1_3_INTRANI_FLOW                  0x0000000150030590
#define SH_XNNI1_3_INTRANI_FLOW_MASK             0x00000000000000bf
#define SH_XNNI1_3_INTRANI_FLOW_INIT             0x0000000000000000

/*   SH_XNNI1_3_INTRANI_FLOW_DEBIT_VC3_WITHHOLD                         */
/*   Description:  vc3 withhold                                         */
#define SH_XNNI1_3_INTRANI_FLOW_DEBIT_VC3_WITHHOLD_SHFT 0
#define SH_XNNI1_3_INTRANI_FLOW_DEBIT_VC3_WITHHOLD_MASK 0x000000000000003f

/*   SH_XNNI1_3_INTRANI_FLOW_DEBIT_VC3_FORCE_CRED                       */
/*   Description:  Force Credit on VC3 from debit cntr                  */
#define SH_XNNI1_3_INTRANI_FLOW_DEBIT_VC3_FORCE_CRED_SHFT 7
#define SH_XNNI1_3_INTRANI_FLOW_DEBIT_VC3_FORCE_CRED_MASK 0x0000000000000080

/* ==================================================================== */
/*                  Register "SH_XNNI1_VCSWITCH_FLOW"                   */
/* ==================================================================== */

#define SH_XNNI1_VCSWITCH_FLOW                   0x00000001500305a0
#define SH_XNNI1_VCSWITCH_FLOW_MASK              0x0000000701010101
#define SH_XNNI1_VCSWITCH_FLOW_INIT              0x0000000000000000

/*   SH_XNNI1_VCSWITCH_FLOW_NI_VCFIFO_DATELINE_SWITCH                   */
/*   Description:  Swap VC0/2 with VC1/3                                */
#define SH_XNNI1_VCSWITCH_FLOW_NI_VCFIFO_DATELINE_SWITCH_SHFT 0
#define SH_XNNI1_VCSWITCH_FLOW_NI_VCFIFO_DATELINE_SWITCH_MASK 0x0000000000000001

/*   SH_XNNI1_VCSWITCH_FLOW_PI_VCFIFO_SWITCH                            */
/*   Description:  Swap VC0/2 with VC1/3                                */
#define SH_XNNI1_VCSWITCH_FLOW_PI_VCFIFO_SWITCH_SHFT 8
#define SH_XNNI1_VCSWITCH_FLOW_PI_VCFIFO_SWITCH_MASK 0x0000000000000100

/*   SH_XNNI1_VCSWITCH_FLOW_MD_VCFIFO_SWITCH                            */
/*   Description:  Swap VC0/2 with VC1/3                                */
#define SH_XNNI1_VCSWITCH_FLOW_MD_VCFIFO_SWITCH_SHFT 16
#define SH_XNNI1_VCSWITCH_FLOW_MD_VCFIFO_SWITCH_MASK 0x0000000000010000

/*   SH_XNNI1_VCSWITCH_FLOW_IILB_VCFIFO_SWITCH                          */
/*   Description:  Swap VC0/2 with VC1/3                                */
#define SH_XNNI1_VCSWITCH_FLOW_IILB_VCFIFO_SWITCH_SHFT 24
#define SH_XNNI1_VCSWITCH_FLOW_IILB_VCFIFO_SWITCH_MASK 0x0000000001000000

/*   SH_XNNI1_VCSWITCH_FLOW_DISABLE_SYNC_BYPASS_IN                      */
#define SH_XNNI1_VCSWITCH_FLOW_DISABLE_SYNC_BYPASS_IN_SHFT 32
#define SH_XNNI1_VCSWITCH_FLOW_DISABLE_SYNC_BYPASS_IN_MASK 0x0000000100000000

/*   SH_XNNI1_VCSWITCH_FLOW_DISABLE_SYNC_BYPASS_OUT                     */
#define SH_XNNI1_VCSWITCH_FLOW_DISABLE_SYNC_BYPASS_OUT_SHFT 33
#define SH_XNNI1_VCSWITCH_FLOW_DISABLE_SYNC_BYPASS_OUT_MASK 0x0000000200000000

/*   SH_XNNI1_VCSWITCH_FLOW_ASYNC_FIFOES                                */
#define SH_XNNI1_VCSWITCH_FLOW_ASYNC_FIFOES_SHFT 34
#define SH_XNNI1_VCSWITCH_FLOW_ASYNC_FIFOES_MASK 0x0000000400000000

/* ==================================================================== */
/*                    Register "SH_XNNI1_TIMER_REG"                     */
/* ==================================================================== */

#define SH_XNNI1_TIMER_REG                       0x00000001500305b0
#define SH_XNNI1_TIMER_REG_MASK                  0x0000000100ffffff
#define SH_XNNI1_TIMER_REG_INIT                  0x0000000000ffffff

/*   SH_XNNI1_TIMER_REG_TIMEOUT_REG                                     */
/*   Description:  Master Timeout Counter                               */
#define SH_XNNI1_TIMER_REG_TIMEOUT_REG_SHFT      0
#define SH_XNNI1_TIMER_REG_TIMEOUT_REG_MASK      0x0000000000ffffff

/*   SH_XNNI1_TIMER_REG_LINKCLEANUP_REG                                 */
/*   Description:  Link Clean Up                                        */
#define SH_XNNI1_TIMER_REG_LINKCLEANUP_REG_SHFT  32
#define SH_XNNI1_TIMER_REG_LINKCLEANUP_REG_MASK  0x0000000100000000

/* ==================================================================== */
/*                   Register "SH_XNNI1_FIFO02_FLOW"                    */
/* ==================================================================== */

#define SH_XNNI1_FIFO02_FLOW                     0x00000001500305c0
#define SH_XNNI1_FIFO02_FLOW_MASK                0x00000f0f0f0f0f0f
#define SH_XNNI1_FIFO02_FLOW_INIT                0x0000000000000000

/*   SH_XNNI1_FIFO02_FLOW_COUNT_VC0_LIMIT                               */
/*   Description:  limit reg zero disables functionality                */
#define SH_XNNI1_FIFO02_FLOW_COUNT_VC0_LIMIT_SHFT 0
#define SH_XNNI1_FIFO02_FLOW_COUNT_VC0_LIMIT_MASK 0x000000000000000f

/*   SH_XNNI1_FIFO02_FLOW_COUNT_VC0_DYN                                 */
/*   Description:  dynamic counter value                                */
#define SH_XNNI1_FIFO02_FLOW_COUNT_VC0_DYN_SHFT  8
#define SH_XNNI1_FIFO02_FLOW_COUNT_VC0_DYN_MASK  0x0000000000000f00

/*   SH_XNNI1_FIFO02_FLOW_COUNT_VC0_CAP                                 */
/*   Description:  captured counter value                               */
#define SH_XNNI1_FIFO02_FLOW_COUNT_VC0_CAP_SHFT  16
#define SH_XNNI1_FIFO02_FLOW_COUNT_VC0_CAP_MASK  0x00000000000f0000

/*   SH_XNNI1_FIFO02_FLOW_COUNT_VC2_LIMIT                               */
/*   Description:  limit reg zero disables functionality                */
#define SH_XNNI1_FIFO02_FLOW_COUNT_VC2_LIMIT_SHFT 24
#define SH_XNNI1_FIFO02_FLOW_COUNT_VC2_LIMIT_MASK 0x000000000f000000

/*   SH_XNNI1_FIFO02_FLOW_COUNT_VC2_DYN                                 */
/*   Description:  counter dynamic value                                */
#define SH_XNNI1_FIFO02_FLOW_COUNT_VC2_DYN_SHFT  32
#define SH_XNNI1_FIFO02_FLOW_COUNT_VC2_DYN_MASK  0x0000000f00000000

/*   SH_XNNI1_FIFO02_FLOW_COUNT_VC2_CAP                                 */
/*   Description:  captured counter value                               */
#define SH_XNNI1_FIFO02_FLOW_COUNT_VC2_CAP_SHFT  40
#define SH_XNNI1_FIFO02_FLOW_COUNT_VC2_CAP_MASK  0x00000f0000000000

/* ==================================================================== */
/*                   Register "SH_XNNI1_FIFO13_FLOW"                    */
/* ==================================================================== */

#define SH_XNNI1_FIFO13_FLOW                     0x00000001500305d0
#define SH_XNNI1_FIFO13_FLOW_MASK                0x00000f0f0f0f0f0f
#define SH_XNNI1_FIFO13_FLOW_INIT                0x0000000000000000

/*   SH_XNNI1_FIFO13_FLOW_COUNT_VC1_LIMIT                               */
/*   Description:  limit reg zero disables functionality                */
#define SH_XNNI1_FIFO13_FLOW_COUNT_VC1_LIMIT_SHFT 0
#define SH_XNNI1_FIFO13_FLOW_COUNT_VC1_LIMIT_MASK 0x000000000000000f

/*   SH_XNNI1_FIFO13_FLOW_COUNT_VC1_DYN                                 */
/*   Description:  dynamic counter value                                */
#define SH_XNNI1_FIFO13_FLOW_COUNT_VC1_DYN_SHFT  8
#define SH_XNNI1_FIFO13_FLOW_COUNT_VC1_DYN_MASK  0x0000000000000f00

/*   SH_XNNI1_FIFO13_FLOW_COUNT_VC1_CAP                                 */
/*   Description:  captured counter value                               */
#define SH_XNNI1_FIFO13_FLOW_COUNT_VC1_CAP_SHFT  16
#define SH_XNNI1_FIFO13_FLOW_COUNT_VC1_CAP_MASK  0x00000000000f0000

/*   SH_XNNI1_FIFO13_FLOW_COUNT_VC3_LIMIT                               */
/*   Description:  limit reg zero disables functionality                */
#define SH_XNNI1_FIFO13_FLOW_COUNT_VC3_LIMIT_SHFT 24
#define SH_XNNI1_FIFO13_FLOW_COUNT_VC3_LIMIT_MASK 0x000000000f000000

/*   SH_XNNI1_FIFO13_FLOW_COUNT_VC3_DYN                                 */
/*   Description:  counter dynamic value                                */
#define SH_XNNI1_FIFO13_FLOW_COUNT_VC3_DYN_SHFT  32
#define SH_XNNI1_FIFO13_FLOW_COUNT_VC3_DYN_MASK  0x0000000f00000000

/*   SH_XNNI1_FIFO13_FLOW_COUNT_VC3_CAP                                 */
/*   Description:  captured counter value                               */
#define SH_XNNI1_FIFO13_FLOW_COUNT_VC3_CAP_SHFT  40
#define SH_XNNI1_FIFO13_FLOW_COUNT_VC3_CAP_MASK  0x00000f0000000000

/* ==================================================================== */
/*                     Register "SH_XNNI1_NI_FLOW"                      */
/* ==================================================================== */

#define SH_XNNI1_NI_FLOW                         0x00000001500305e0
#define SH_XNNI1_NI_FLOW_MASK                    0xff0fff0fff0fff0f
#define SH_XNNI1_NI_FLOW_INIT                    0x0000000000000000

/*   SH_XNNI1_NI_FLOW_VC0_LIMIT                                         */
/*   Description:  vc0 limit reg, zero disables functionality           */
#define SH_XNNI1_NI_FLOW_VC0_LIMIT_SHFT          0
#define SH_XNNI1_NI_FLOW_VC0_LIMIT_MASK          0x000000000000000f

/*   SH_XNNI1_NI_FLOW_VC0_DYN                                           */
/*   Description:  vc0 counter dynamic value                            */
#define SH_XNNI1_NI_FLOW_VC0_DYN_SHFT            8
#define SH_XNNI1_NI_FLOW_VC0_DYN_MASK            0x0000000000000f00

/*   SH_XNNI1_NI_FLOW_VC0_CAP                                           */
/*   Description:  vc0 counter captured value                           */
#define SH_XNNI1_NI_FLOW_VC0_CAP_SHFT            12
#define SH_XNNI1_NI_FLOW_VC0_CAP_MASK            0x000000000000f000

/*   SH_XNNI1_NI_FLOW_VC1_LIMIT                                         */
/*   Description:  vc1 limit reg, zero disables functionality           */
#define SH_XNNI1_NI_FLOW_VC1_LIMIT_SHFT          16
#define SH_XNNI1_NI_FLOW_VC1_LIMIT_MASK          0x00000000000f0000

/*   SH_XNNI1_NI_FLOW_VC1_DYN                                           */
/*   Description:  vc1 counter dynamic value                            */
#define SH_XNNI1_NI_FLOW_VC1_DYN_SHFT            24
#define SH_XNNI1_NI_FLOW_VC1_DYN_MASK            0x000000000f000000

/*   SH_XNNI1_NI_FLOW_VC1_CAP                                           */
/*   Description:  vc1 counter captured value                           */
#define SH_XNNI1_NI_FLOW_VC1_CAP_SHFT            28
#define SH_XNNI1_NI_FLOW_VC1_CAP_MASK            0x00000000f0000000

/*   SH_XNNI1_NI_FLOW_VC2_LIMIT                                         */
/*   Description:  vc2 limit reg, zero disables functionality           */
#define SH_XNNI1_NI_FLOW_VC2_LIMIT_SHFT          32
#define SH_XNNI1_NI_FLOW_VC2_LIMIT_MASK          0x0000000f00000000

/*   SH_XNNI1_NI_FLOW_VC2_DYN                                           */
/*   Description:  vc2 counter dynamic value                            */
#define SH_XNNI1_NI_FLOW_VC2_DYN_SHFT            40
#define SH_XNNI1_NI_FLOW_VC2_DYN_MASK            0x00000f0000000000

/*   SH_XNNI1_NI_FLOW_VC2_CAP                                           */
/*   Description:  vc2 counter captured value                           */
#define SH_XNNI1_NI_FLOW_VC2_CAP_SHFT            44
#define SH_XNNI1_NI_FLOW_VC2_CAP_MASK            0x0000f00000000000

/*   SH_XNNI1_NI_FLOW_VC3_LIMIT                                         */
/*   Description:  vc3 limit reg, zero disables functionality           */
#define SH_XNNI1_NI_FLOW_VC3_LIMIT_SHFT          48
#define SH_XNNI1_NI_FLOW_VC3_LIMIT_MASK          0x000f000000000000

/*   SH_XNNI1_NI_FLOW_VC3_DYN                                           */
/*   Description:  vc3 counter dynamic value                            */
#define SH_XNNI1_NI_FLOW_VC3_DYN_SHFT            56
#define SH_XNNI1_NI_FLOW_VC3_DYN_MASK            0x0f00000000000000

/*   SH_XNNI1_NI_FLOW_VC3_CAP                                           */
/*   Description:  vc3 counter captured value                           */
#define SH_XNNI1_NI_FLOW_VC3_CAP_SHFT            60
#define SH_XNNI1_NI_FLOW_VC3_CAP_MASK            0xf000000000000000

/* ==================================================================== */
/*                    Register "SH_XNNI1_DEAD_FLOW"                     */
/* ==================================================================== */

#define SH_XNNI1_DEAD_FLOW                       0x00000001500305f0
#define SH_XNNI1_DEAD_FLOW_MASK                  0xff0fff0fff0fff0f
#define SH_XNNI1_DEAD_FLOW_INIT                  0x0000000000000000

/*   SH_XNNI1_DEAD_FLOW_VC0_LIMIT                                       */
/*   Description:  vc0 limit reg, zero disables functionality           */
#define SH_XNNI1_DEAD_FLOW_VC0_LIMIT_SHFT        0
#define SH_XNNI1_DEAD_FLOW_VC0_LIMIT_MASK        0x000000000000000f

/*   SH_XNNI1_DEAD_FLOW_VC0_DYN                                         */
/*   Description:  vc0 counter dynamic value                            */
#define SH_XNNI1_DEAD_FLOW_VC0_DYN_SHFT          8
#define SH_XNNI1_DEAD_FLOW_VC0_DYN_MASK          0x0000000000000f00

/*   SH_XNNI1_DEAD_FLOW_VC0_CAP                                         */
/*   Description:  vc0 counter captured value                           */
#define SH_XNNI1_DEAD_FLOW_VC0_CAP_SHFT          12
#define SH_XNNI1_DEAD_FLOW_VC0_CAP_MASK          0x000000000000f000

/*   SH_XNNI1_DEAD_FLOW_VC1_LIMIT                                       */
/*   Description:  vc1 limit reg, zero disables functionality           */
#define SH_XNNI1_DEAD_FLOW_VC1_LIMIT_SHFT        16
#define SH_XNNI1_DEAD_FLOW_VC1_LIMIT_MASK        0x00000000000f0000

/*   SH_XNNI1_DEAD_FLOW_VC1_DYN                                         */
/*   Description:  vc1 counter dynamic value                            */
#define SH_XNNI1_DEAD_FLOW_VC1_DYN_SHFT          24
#define SH_XNNI1_DEAD_FLOW_VC1_DYN_MASK          0x000000000f000000

/*   SH_XNNI1_DEAD_FLOW_VC1_CAP                                         */
/*   Description:  vc1 counter captured value                           */
#define SH_XNNI1_DEAD_FLOW_VC1_CAP_SHFT          28
#define SH_XNNI1_DEAD_FLOW_VC1_CAP_MASK          0x00000000f0000000

/*   SH_XNNI1_DEAD_FLOW_VC2_LIMIT                                       */
/*   Description:  vc2 limit reg, zero disables functionality           */
#define SH_XNNI1_DEAD_FLOW_VC2_LIMIT_SHFT        32
#define SH_XNNI1_DEAD_FLOW_VC2_LIMIT_MASK        0x0000000f00000000

/*   SH_XNNI1_DEAD_FLOW_VC2_DYN                                         */
/*   Description:  vc2 counter dynamic value                            */
#define SH_XNNI1_DEAD_FLOW_VC2_DYN_SHFT          40
#define SH_XNNI1_DEAD_FLOW_VC2_DYN_MASK          0x00000f0000000000

/*   SH_XNNI1_DEAD_FLOW_VC2_CAP                                         */
/*   Description:  vc2 counter captured value                           */
#define SH_XNNI1_DEAD_FLOW_VC2_CAP_SHFT          44
#define SH_XNNI1_DEAD_FLOW_VC2_CAP_MASK          0x0000f00000000000

/*   SH_XNNI1_DEAD_FLOW_VC3_LIMIT                                       */
/*   Description:  vc3 limit reg, zero disables functionality           */
#define SH_XNNI1_DEAD_FLOW_VC3_LIMIT_SHFT        48
#define SH_XNNI1_DEAD_FLOW_VC3_LIMIT_MASK        0x000f000000000000

/*   SH_XNNI1_DEAD_FLOW_VC3_DYN                                         */
/*   Description:  vc3 counter dynamic value                            */
#define SH_XNNI1_DEAD_FLOW_VC3_DYN_SHFT          56
#define SH_XNNI1_DEAD_FLOW_VC3_DYN_MASK          0x0f00000000000000

/*   SH_XNNI1_DEAD_FLOW_VC3_CAP                                         */
/*   Description:  vc3 counter captured value                           */
#define SH_XNNI1_DEAD_FLOW_VC3_CAP_SHFT          60
#define SH_XNNI1_DEAD_FLOW_VC3_CAP_MASK          0xf000000000000000

/* ==================================================================== */
/*                    Register "SH_XNNI1_INJECT_AGE"                    */
/* ==================================================================== */

#define SH_XNNI1_INJECT_AGE                      0x0000000150030600
#define SH_XNNI1_INJECT_AGE_MASK                 0x000000000000ffff
#define SH_XNNI1_INJECT_AGE_INIT                 0x0000000000000000

/*   SH_XNNI1_INJECT_AGE_REQUEST_INJECT                                 */
/*   Description:  Value of AGE field for outgoing requests             */
#define SH_XNNI1_INJECT_AGE_REQUEST_INJECT_SHFT  0
#define SH_XNNI1_INJECT_AGE_REQUEST_INJECT_MASK  0x00000000000000ff

/*   SH_XNNI1_INJECT_AGE_REPLY_INJECT                                   */
/*   Description:  Value of AGE field for outgoing replies              */
#define SH_XNNI1_INJECT_AGE_REPLY_INJECT_SHFT    8
#define SH_XNNI1_INJECT_AGE_REPLY_INJECT_MASK    0x000000000000ff00

/* ==================================================================== */
/*                      Register "SH_XN_DEBUG_SEL"                      */
/*                         XN Debug Port Select                         */
/* ==================================================================== */

#define SH_XN_DEBUG_SEL                          0x0000000150031000
#define SH_XN_DEBUG_SEL_MASK                     0xf777777777777777
#define SH_XN_DEBUG_SEL_INIT                     0x0000000000000000

/*   SH_XN_DEBUG_SEL_NIBBLE0_RLM_SEL                                    */
/*   Description:  Nibble 0 RLM select                                  */
#define SH_XN_DEBUG_SEL_NIBBLE0_RLM_SEL_SHFT     0
#define SH_XN_DEBUG_SEL_NIBBLE0_RLM_SEL_MASK     0x0000000000000007

/*   SH_XN_DEBUG_SEL_NIBBLE0_NIBBLE_SEL                                 */
/*   Description:  Nibble 0 Nibble select                               */
#define SH_XN_DEBUG_SEL_NIBBLE0_NIBBLE_SEL_SHFT  4
#define SH_XN_DEBUG_SEL_NIBBLE0_NIBBLE_SEL_MASK  0x0000000000000070

/*   SH_XN_DEBUG_SEL_NIBBLE1_RLM_SEL                                    */
/*   Description:  Nibble 1 RLM select                                  */
#define SH_XN_DEBUG_SEL_NIBBLE1_RLM_SEL_SHFT     8
#define SH_XN_DEBUG_SEL_NIBBLE1_RLM_SEL_MASK     0x0000000000000700

/*   SH_XN_DEBUG_SEL_NIBBLE1_NIBBLE_SEL                                 */
/*   Description:  Nibble 1 Nibble select                               */
#define SH_XN_DEBUG_SEL_NIBBLE1_NIBBLE_SEL_SHFT  12
#define SH_XN_DEBUG_SEL_NIBBLE1_NIBBLE_SEL_MASK  0x0000000000007000

/*   SH_XN_DEBUG_SEL_NIBBLE2_RLM_SEL                                    */
/*   Description:  Nibble 2 RLM select                                  */
#define SH_XN_DEBUG_SEL_NIBBLE2_RLM_SEL_SHFT     16
#define SH_XN_DEBUG_SEL_NIBBLE2_RLM_SEL_MASK     0x0000000000070000

/*   SH_XN_DEBUG_SEL_NIBBLE2_NIBBLE_SEL                                 */
/*   Description:  Nibble 2 Nibble select                               */
#define SH_XN_DEBUG_SEL_NIBBLE2_NIBBLE_SEL_SHFT  20
#define SH_XN_DEBUG_SEL_NIBBLE2_NIBBLE_SEL_MASK  0x0000000000700000

/*   SH_XN_DEBUG_SEL_NIBBLE3_RLM_SEL                                    */
/*   Description:  Nibble 3 RLM select                                  */
#define SH_XN_DEBUG_SEL_NIBBLE3_RLM_SEL_SHFT     24
#define SH_XN_DEBUG_SEL_NIBBLE3_RLM_SEL_MASK     0x0000000007000000

/*   SH_XN_DEBUG_SEL_NIBBLE3_NIBBLE_SEL                                 */
/*   Description:  Nibble 3 Nibble select                               */
#define SH_XN_DEBUG_SEL_NIBBLE3_NIBBLE_SEL_SHFT  28
#define SH_XN_DEBUG_SEL_NIBBLE3_NIBBLE_SEL_MASK  0x0000000070000000

/*   SH_XN_DEBUG_SEL_NIBBLE4_RLM_SEL                                    */
/*   Description:  Nibble 4 RLM select                                  */
#define SH_XN_DEBUG_SEL_NIBBLE4_RLM_SEL_SHFT     32
#define SH_XN_DEBUG_SEL_NIBBLE4_RLM_SEL_MASK     0x0000000700000000

/*   SH_XN_DEBUG_SEL_NIBBLE4_NIBBLE_SEL                                 */
/*   Description:  Nibble 4 Nibble select                               */
#define SH_XN_DEBUG_SEL_NIBBLE4_NIBBLE_SEL_SHFT  36
#define SH_XN_DEBUG_SEL_NIBBLE4_NIBBLE_SEL_MASK  0x0000007000000000

/*   SH_XN_DEBUG_SEL_NIBBLE5_RLM_SEL                                    */
/*   Description:  Nibble 5 RLM select                                  */
#define SH_XN_DEBUG_SEL_NIBBLE5_RLM_SEL_SHFT     40
#define SH_XN_DEBUG_SEL_NIBBLE5_RLM_SEL_MASK     0x0000070000000000

/*   SH_XN_DEBUG_SEL_NIBBLE5_NIBBLE_SEL                                 */
/*   Description:  Nibble 5 Nibble select                               */
#define SH_XN_DEBUG_SEL_NIBBLE5_NIBBLE_SEL_SHFT  44
#define SH_XN_DEBUG_SEL_NIBBLE5_NIBBLE_SEL_MASK  0x0000700000000000

/*   SH_XN_DEBUG_SEL_NIBBLE6_RLM_SEL                                    */
/*   Description:  Nibble 6 RLM select                                  */
#define SH_XN_DEBUG_SEL_NIBBLE6_RLM_SEL_SHFT     48
#define SH_XN_DEBUG_SEL_NIBBLE6_RLM_SEL_MASK     0x0007000000000000

/*   SH_XN_DEBUG_SEL_NIBBLE6_NIBBLE_SEL                                 */
/*   Description:  Nibble 6 Nibble select                               */
#define SH_XN_DEBUG_SEL_NIBBLE6_NIBBLE_SEL_SHFT  52
#define SH_XN_DEBUG_SEL_NIBBLE6_NIBBLE_SEL_MASK  0x0070000000000000

/*   SH_XN_DEBUG_SEL_NIBBLE7_RLM_SEL                                    */
/*   Description:  Nibble 7 RLM select                                  */
#define SH_XN_DEBUG_SEL_NIBBLE7_RLM_SEL_SHFT     56
#define SH_XN_DEBUG_SEL_NIBBLE7_RLM_SEL_MASK     0x0700000000000000

/*   SH_XN_DEBUG_SEL_NIBBLE7_NIBBLE_SEL                                 */
/*   Description:  Nibble 7 Nibble select                               */
#define SH_XN_DEBUG_SEL_NIBBLE7_NIBBLE_SEL_SHFT  60
#define SH_XN_DEBUG_SEL_NIBBLE7_NIBBLE_SEL_MASK  0x7000000000000000

/*   SH_XN_DEBUG_SEL_TRIGGER_ENABLE                                     */
/*   Description:  Enable trigger on bit 32 of Analyzer data            */
#define SH_XN_DEBUG_SEL_TRIGGER_ENABLE_SHFT      63
#define SH_XN_DEBUG_SEL_TRIGGER_ENABLE_MASK      0x8000000000000000

/* ==================================================================== */
/*                   Register "SH_XN_DEBUG_TRIG_SEL"                    */
/*                       XN Debug trigger Select                        */
/* ==================================================================== */

#define SH_XN_DEBUG_TRIG_SEL                     0x0000000150031020
#define SH_XN_DEBUG_TRIG_SEL_MASK                0x7777777777777777
#define SH_XN_DEBUG_TRIG_SEL_INIT                0x0000000000000000

/*   SH_XN_DEBUG_TRIG_SEL_TRIGGER0_RLM_SEL                              */
/*   Description:  Nibble 0 RLM select                                  */
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER0_RLM_SEL_SHFT 0
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER0_RLM_SEL_MASK 0x0000000000000007

/*   SH_XN_DEBUG_TRIG_SEL_TRIGGER0_NIBBLE_SEL                           */
/*   Description:  Nibble 0 Nibble select                               */
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER0_NIBBLE_SEL_SHFT 4
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER0_NIBBLE_SEL_MASK 0x0000000000000070

/*   SH_XN_DEBUG_TRIG_SEL_TRIGGER1_RLM_SEL                              */
/*   Description:  Nibble 1 RLM select                                  */
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER1_RLM_SEL_SHFT 8
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER1_RLM_SEL_MASK 0x0000000000000700

/*   SH_XN_DEBUG_TRIG_SEL_TRIGGER1_NIBBLE_SEL                           */
/*   Description:  Nibble 1 Nibble select                               */
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER1_NIBBLE_SEL_SHFT 12
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER1_NIBBLE_SEL_MASK 0x0000000000007000

/*   SH_XN_DEBUG_TRIG_SEL_TRIGGER2_RLM_SEL                              */
/*   Description:  Nibble 2 RLM select                                  */
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER2_RLM_SEL_SHFT 16
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER2_RLM_SEL_MASK 0x0000000000070000

/*   SH_XN_DEBUG_TRIG_SEL_TRIGGER2_NIBBLE_SEL                           */
/*   Description:  Nibble 2 Nibble select                               */
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER2_NIBBLE_SEL_SHFT 20
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER2_NIBBLE_SEL_MASK 0x0000000000700000

/*   SH_XN_DEBUG_TRIG_SEL_TRIGGER3_RLM_SEL                              */
/*   Description:  Nibble 3 RLM select                                  */
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER3_RLM_SEL_SHFT 24
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER3_RLM_SEL_MASK 0x0000000007000000

/*   SH_XN_DEBUG_TRIG_SEL_TRIGGER3_NIBBLE_SEL                           */
/*   Description:  Nibble 3 Nibble select                               */
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER3_NIBBLE_SEL_SHFT 28
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER3_NIBBLE_SEL_MASK 0x0000000070000000

/*   SH_XN_DEBUG_TRIG_SEL_TRIGGER4_RLM_SEL                              */
/*   Description:  Nibble 4 RLM select                                  */
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER4_RLM_SEL_SHFT 32
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER4_RLM_SEL_MASK 0x0000000700000000

/*   SH_XN_DEBUG_TRIG_SEL_TRIGGER4_NIBBLE_SEL                           */
/*   Description:  Nibble 4 Nibble select                               */
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER4_NIBBLE_SEL_SHFT 36
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER4_NIBBLE_SEL_MASK 0x0000007000000000

/*   SH_XN_DEBUG_TRIG_SEL_TRIGGER5_RLM_SEL                              */
/*   Description:  Nibble 5 RLM select                                  */
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER5_RLM_SEL_SHFT 40
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER5_RLM_SEL_MASK 0x0000070000000000

/*   SH_XN_DEBUG_TRIG_SEL_TRIGGER5_NIBBLE_SEL                           */
/*   Description:  Nibble 5 Nibble select                               */
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER5_NIBBLE_SEL_SHFT 44
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER5_NIBBLE_SEL_MASK 0x0000700000000000

/*   SH_XN_DEBUG_TRIG_SEL_TRIGGER6_RLM_SEL                              */
/*   Description:  Nibble 6 RLM select                                  */
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER6_RLM_SEL_SHFT 48
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER6_RLM_SEL_MASK 0x0007000000000000

/*   SH_XN_DEBUG_TRIG_SEL_TRIGGER6_NIBBLE_SEL                           */
/*   Description:  Nibble 6 Nibble select                               */
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER6_NIBBLE_SEL_SHFT 52
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER6_NIBBLE_SEL_MASK 0x0070000000000000

/*   SH_XN_DEBUG_TRIG_SEL_TRIGGER7_RLM_SEL                              */
/*   Description:  Nibble 7 RLM select                                  */
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER7_RLM_SEL_SHFT 56
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER7_RLM_SEL_MASK 0x0700000000000000

/*   SH_XN_DEBUG_TRIG_SEL_TRIGGER7_NIBBLE_SEL                           */
/*   Description:  Nibble 7 Nibble select                               */
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER7_NIBBLE_SEL_SHFT 60
#define SH_XN_DEBUG_TRIG_SEL_TRIGGER7_NIBBLE_SEL_MASK 0x7000000000000000

/* ==================================================================== */
/*                   Register "SH_XN_TRIGGER_COMPARE"                   */
/*                           XN Debug Compare                           */
/* ==================================================================== */

#define SH_XN_TRIGGER_COMPARE                    0x0000000150031040
#define SH_XN_TRIGGER_COMPARE_MASK               0x00000000ffffffff
#define SH_XN_TRIGGER_COMPARE_INIT               0x0000000000000000

/*   SH_XN_TRIGGER_COMPARE_MASK                                         */
/*   Description:  Mask to select Debug bits for trigger generation     */
#define SH_XN_TRIGGER_COMPARE_MASK_SHFT          0
#define SH_XN_TRIGGER_COMPARE_MASK_MASK          0x00000000ffffffff

/* ==================================================================== */
/*                    Register "SH_XN_TRIGGER_DATA"                     */
/*                        XN Debug Compare Data                         */
/* ==================================================================== */

#define SH_XN_TRIGGER_DATA                       0x0000000150031050
#define SH_XN_TRIGGER_DATA_MASK                  0x00000000ffffffff
#define SH_XN_TRIGGER_DATA_INIT                  0x00000000ffffffff

/*   SH_XN_TRIGGER_DATA_COMPARE_PATTERN                                 */
/*   Description:  debug bit pattern for trigger generation             */
#define SH_XN_TRIGGER_DATA_COMPARE_PATTERN_SHFT  0
#define SH_XN_TRIGGER_DATA_COMPARE_PATTERN_MASK  0x00000000ffffffff

/* ==================================================================== */
/*                   Register "SH_XN_IILB_DEBUG_SEL"                    */
/*                      XN IILB Debug Port Select                       */
/* ==================================================================== */

#define SH_XN_IILB_DEBUG_SEL                     0x0000000150031060
#define SH_XN_IILB_DEBUG_SEL_MASK                0x7777777777777777
#define SH_XN_IILB_DEBUG_SEL_INIT                0x0000000000000000

/*   SH_XN_IILB_DEBUG_SEL_NIBBLE0_INPUT_SEL                             */
/*   Description:  Nibble 0 input select                                */
#define SH_XN_IILB_DEBUG_SEL_NIBBLE0_INPUT_SEL_SHFT 0
#define SH_XN_IILB_DEBUG_SEL_NIBBLE0_INPUT_SEL_MASK 0x0000000000000007

/*   SH_XN_IILB_DEBUG_SEL_NIBBLE0_NIBBLE_SEL                            */
/*   Description:  Nibble 0 Nibble select                               */
#define SH_XN_IILB_DEBUG_SEL_NIBBLE0_NIBBLE_SEL_SHFT 4
#define SH_XN_IILB_DEBUG_SEL_NIBBLE0_NIBBLE_SEL_MASK 0x0000000000000070

/*   SH_XN_IILB_DEBUG_SEL_NIBBLE1_INPUT_SEL                             */
/*   Description:  Nibble 1 input select                                */
#define SH_XN_IILB_DEBUG_SEL_NIBBLE1_INPUT_SEL_SHFT 8
#define SH_XN_IILB_DEBUG_SEL_NIBBLE1_INPUT_SEL_MASK 0x0000000000000700

/*   SH_XN_IILB_DEBUG_SEL_NIBBLE1_NIBBLE_SEL                            */
/*   Description:  Nibble 1 Nibble select                               */
#define SH_XN_IILB_DEBUG_SEL_NIBBLE1_NIBBLE_SEL_SHFT 12
#define SH_XN_IILB_DEBUG_SEL_NIBBLE1_NIBBLE_SEL_MASK 0x0000000000007000

/*   SH_XN_IILB_DEBUG_SEL_NIBBLE2_INPUT_SEL                             */
/*   Description:  Nibble 2 input select                                */
#define SH_XN_IILB_DEBUG_SEL_NIBBLE2_INPUT_SEL_SHFT 16
#define SH_XN_IILB_DEBUG_SEL_NIBBLE2_INPUT_SEL_MASK 0x0000000000070000

/*   SH_XN_IILB_DEBUG_SEL_NIBBLE2_NIBBLE_SEL                            */
/*   Description:  Nibble 2 Nibble select                               */
#define SH_XN_IILB_DEBUG_SEL_NIBBLE2_NIBBLE_SEL_SHFT 20
#define SH_XN_IILB_DEBUG_SEL_NIBBLE2_NIBBLE_SEL_MASK 0x0000000000700000

/*   SH_XN_IILB_DEBUG_SEL_NIBBLE3_INPUT_SEL                             */
/*   Description:  Nibble 3 input select                                */
#define SH_XN_IILB_DEBUG_SEL_NIBBLE3_INPUT_SEL_SHFT 24
#define SH_XN_IILB_DEBUG_SEL_NIBBLE3_INPUT_SEL_MASK 0x0000000007000000

/*   SH_XN_IILB_DEBUG_SEL_NIBBLE3_NIBBLE_SEL                            */
/*   Description:  Nibble 3 Nibble select                               */
#define SH_XN_IILB_DEBUG_SEL_NIBBLE3_NIBBLE_SEL_SHFT 28
#define SH_XN_IILB_DEBUG_SEL_NIBBLE3_NIBBLE_SEL_MASK 0x0000000070000000

/*   SH_XN_IILB_DEBUG_SEL_NIBBLE4_INPUT_SEL                             */
/*   Description:  Nibble 4 input select                                */
#define SH_XN_IILB_DEBUG_SEL_NIBBLE4_INPUT_SEL_SHFT 32
#define SH_XN_IILB_DEBUG_SEL_NIBBLE4_INPUT_SEL_MASK 0x0000000700000000

/*   SH_XN_IILB_DEBUG_SEL_NIBBLE4_NIBBLE_SEL                            */
/*   Description:  Nibble 4 Nibble select                               */
#define SH_XN_IILB_DEBUG_SEL_NIBBLE4_NIBBLE_SEL_SHFT 36
#define SH_XN_IILB_DEBUG_SEL_NIBBLE4_NIBBLE_SEL_MASK 0x0000007000000000

/*   SH_XN_IILB_DEBUG_SEL_NIBBLE5_INPUT_SEL                             */
/*   Description:  Nibble 5 input select                                */
#define SH_XN_IILB_DEBUG_SEL_NIBBLE5_INPUT_SEL_SHFT 40
#define SH_XN_IILB_DEBUG_SEL_NIBBLE5_INPUT_SEL_MASK 0x0000070000000000

/*   SH_XN_IILB_DEBUG_SEL_NIBBLE5_NIBBLE_SEL                            */
/*   Description:  Nibble 5 Nibble select                               */
#define SH_XN_IILB_DEBUG_SEL_NIBBLE5_NIBBLE_SEL_SHFT 44
#define SH_XN_IILB_DEBUG_SEL_NIBBLE5_NIBBLE_SEL_MASK 0x0000700000000000

/*   SH_XN_IILB_DEBUG_SEL_NIBBLE6_INPUT_SEL                             */
/*   Description:  Nibble 6 input select                                */
#define SH_XN_IILB_DEBUG_SEL_NIBBLE6_INPUT_SEL_SHFT 48
#define SH_XN_IILB_DEBUG_SEL_NIBBLE6_INPUT_SEL_MASK 0x0007000000000000

/*   SH_XN_IILB_DEBUG_SEL_NIBBLE6_NIBBLE_SEL                            */
/*   Description:  Nibble 6 Nibble select                               */
#define SH_XN_IILB_DEBUG_SEL_NIBBLE6_NIBBLE_SEL_SHFT 52
#define SH_XN_IILB_DEBUG_SEL_NIBBLE6_NIBBLE_SEL_MASK 0x0070000000000000

/*   SH_XN_IILB_DEBUG_SEL_NIBBLE7_INPUT_SEL                             */
/*   Description:  Nibble 7 input select                                */
#define SH_XN_IILB_DEBUG_SEL_NIBBLE7_INPUT_SEL_SHFT 56
#define SH_XN_IILB_DEBUG_SEL_NIBBLE7_INPUT_SEL_MASK 0x0700000000000000

/*   SH_XN_IILB_DEBUG_SEL_NIBBLE7_NIBBLE_SEL                            */
/*   Description:  Nibble 7 Nibble select                               */
#define SH_XN_IILB_DEBUG_SEL_NIBBLE7_NIBBLE_SEL_SHFT 60
#define SH_XN_IILB_DEBUG_SEL_NIBBLE7_NIBBLE_SEL_MASK 0x7000000000000000

/* ==================================================================== */
/*                    Register "SH_XN_PI_DEBUG_SEL"                     */
/*                       XN PI Debug Port Select                        */
/* ==================================================================== */

#define SH_XN_PI_DEBUG_SEL                       0x00000001500310a0
#define SH_XN_PI_DEBUG_SEL_MASK                  0x7777777777777777
#define SH_XN_PI_DEBUG_SEL_INIT                  0x0000000000000000

/*   SH_XN_PI_DEBUG_SEL_NIBBLE0_INPUT_SEL                               */
/*   Description:  Nibble 0 input select                                */
#define SH_XN_PI_DEBUG_SEL_NIBBLE0_INPUT_SEL_SHFT 0
#define SH_XN_PI_DEBUG_SEL_NIBBLE0_INPUT_SEL_MASK 0x0000000000000007

/*   SH_XN_PI_DEBUG_SEL_NIBBLE0_NIBBLE_SEL                              */
/*   Description:  Nibble 0 Nibble select                               */
#define SH_XN_PI_DEBUG_SEL_NIBBLE0_NIBBLE_SEL_SHFT 4
#define SH_XN_PI_DEBUG_SEL_NIBBLE0_NIBBLE_SEL_MASK 0x0000000000000070

/*   SH_XN_PI_DEBUG_SEL_NIBBLE1_INPUT_SEL                               */
/*   Description:  Nibble 1 input select                                */
#define SH_XN_PI_DEBUG_SEL_NIBBLE1_INPUT_SEL_SHFT 8
#define SH_XN_PI_DEBUG_SEL_NIBBLE1_INPUT_SEL_MASK 0x0000000000000700

/*   SH_XN_PI_DEBUG_SEL_NIBBLE1_NIBBLE_SEL                              */
/*   Description:  Nibble 1 Nibble select                               */
#define SH_XN_PI_DEBUG_SEL_NIBBLE1_NIBBLE_SEL_SHFT 12
#define SH_XN_PI_DEBUG_SEL_NIBBLE1_NIBBLE_SEL_MASK 0x0000000000007000

/*   SH_XN_PI_DEBUG_SEL_NIBBLE2_INPUT_SEL                               */
/*   Description:  Nibble 2 input select                                */
#define SH_XN_PI_DEBUG_SEL_NIBBLE2_INPUT_SEL_SHFT 16
#define SH_XN_PI_DEBUG_SEL_NIBBLE2_INPUT_SEL_MASK 0x0000000000070000

/*   SH_XN_PI_DEBUG_SEL_NIBBLE2_NIBBLE_SEL                              */
/*   Description:  Nibble 2 Nibble select                               */
#define SH_XN_PI_DEBUG_SEL_NIBBLE2_NIBBLE_SEL_SHFT 20
#define SH_XN_PI_DEBUG_SEL_NIBBLE2_NIBBLE_SEL_MASK 0x0000000000700000

/*   SH_XN_PI_DEBUG_SEL_NIBBLE3_INPUT_SEL                               */
/*   Description:  Nibble 3 input select                                */
#define SH_XN_PI_DEBUG_SEL_NIBBLE3_INPUT_SEL_SHFT 24
#define SH_XN_PI_DEBUG_SEL_NIBBLE3_INPUT_SEL_MASK 0x0000000007000000

/*   SH_XN_PI_DEBUG_SEL_NIBBLE3_NIBBLE_SEL                              */
/*   Description:  Nibble 3 Nibble select                               */
#define SH_XN_PI_DEBUG_SEL_NIBBLE3_NIBBLE_SEL_SHFT 28
#define SH_XN_PI_DEBUG_SEL_NIBBLE3_NIBBLE_SEL_MASK 0x0000000070000000

/*   SH_XN_PI_DEBUG_SEL_NIBBLE4_INPUT_SEL                               */
/*   Description:  Nibble 4 input select                                */
#define SH_XN_PI_DEBUG_SEL_NIBBLE4_INPUT_SEL_SHFT 32
#define SH_XN_PI_DEBUG_SEL_NIBBLE4_INPUT_SEL_MASK 0x0000000700000000

/*   SH_XN_PI_DEBUG_SEL_NIBBLE4_NIBBLE_SEL                              */
/*   Description:  Nibble 4 Nibble select                               */
#define SH_XN_PI_DEBUG_SEL_NIBBLE4_NIBBLE_SEL_SHFT 36
#define SH_XN_PI_DEBUG_SEL_NIBBLE4_NIBBLE_SEL_MASK 0x0000007000000000

/*   SH_XN_PI_DEBUG_SEL_NIBBLE5_INPUT_SEL                               */
/*   Description:  Nibble 5 input select                                */
#define SH_XN_PI_DEBUG_SEL_NIBBLE5_INPUT_SEL_SHFT 40
#define SH_XN_PI_DEBUG_SEL_NIBBLE5_INPUT_SEL_MASK 0x0000070000000000

/*   SH_XN_PI_DEBUG_SEL_NIBBLE5_NIBBLE_SEL                              */
/*   Description:  Nibble 5 Nibble select                               */
#define SH_XN_PI_DEBUG_SEL_NIBBLE5_NIBBLE_SEL_SHFT 44
#define SH_XN_PI_DEBUG_SEL_NIBBLE5_NIBBLE_SEL_MASK 0x0000700000000000

/*   SH_XN_PI_DEBUG_SEL_NIBBLE6_INPUT_SEL                               */
/*   Description:  Nibble 6 input select                                */
#define SH_XN_PI_DEBUG_SEL_NIBBLE6_INPUT_SEL_SHFT 48
#define SH_XN_PI_DEBUG_SEL_NIBBLE6_INPUT_SEL_MASK 0x0007000000000000

/*   SH_XN_PI_DEBUG_SEL_NIBBLE6_NIBBLE_SEL                              */
/*   Description:  Nibble 6 Nibble select                               */
#define SH_XN_PI_DEBUG_SEL_NIBBLE6_NIBBLE_SEL_SHFT 52
#define SH_XN_PI_DEBUG_SEL_NIBBLE6_NIBBLE_SEL_MASK 0x0070000000000000

/*   SH_XN_PI_DEBUG_SEL_NIBBLE7_INPUT_SEL                               */
/*   Description:  Nibble 7 input select                                */
#define SH_XN_PI_DEBUG_SEL_NIBBLE7_INPUT_SEL_SHFT 56
#define SH_XN_PI_DEBUG_SEL_NIBBLE7_INPUT_SEL_MASK 0x0700000000000000

/*   SH_XN_PI_DEBUG_SEL_NIBBLE7_NIBBLE_SEL                              */
/*   Description:  Nibble 7 Nibble select                               */
#define SH_XN_PI_DEBUG_SEL_NIBBLE7_NIBBLE_SEL_SHFT 60
#define SH_XN_PI_DEBUG_SEL_NIBBLE7_NIBBLE_SEL_MASK 0x7000000000000000

/* ==================================================================== */
/*                    Register "SH_XN_MD_DEBUG_SEL"                     */
/*                       XN MD Debug Port Select                        */
/* ==================================================================== */

#define SH_XN_MD_DEBUG_SEL                       0x0000000150031080
#define SH_XN_MD_DEBUG_SEL_MASK                  0x7777777777777777
#define SH_XN_MD_DEBUG_SEL_INIT                  0x0000000000000000

/*   SH_XN_MD_DEBUG_SEL_NIBBLE0_INPUT_SEL                               */
/*   Description:  Nibble 0 input select                                */
#define SH_XN_MD_DEBUG_SEL_NIBBLE0_INPUT_SEL_SHFT 0
#define SH_XN_MD_DEBUG_SEL_NIBBLE0_INPUT_SEL_MASK 0x0000000000000007

/*   SH_XN_MD_DEBUG_SEL_NIBBLE0_NIBBLE_SEL                              */
/*   Description:  Nibble 0 Nibble select                               */
#define SH_XN_MD_DEBUG_SEL_NIBBLE0_NIBBLE_SEL_SHFT 4
#define SH_XN_MD_DEBUG_SEL_NIBBLE0_NIBBLE_SEL_MASK 0x0000000000000070

/*   SH_XN_MD_DEBUG_SEL_NIBBLE1_INPUT_SEL                               */
/*   Description:  Nibble 1 input select                                */
#define SH_XN_MD_DEBUG_SEL_NIBBLE1_INPUT_SEL_SHFT 8
#define SH_XN_MD_DEBUG_SEL_NIBBLE1_INPUT_SEL_MASK 0x0000000000000700

/*   SH_XN_MD_DEBUG_SEL_NIBBLE1_NIBBLE_SEL                              */
/*   Description:  Nibble 1 Nibble select                               */
#define SH_XN_MD_DEBUG_SEL_NIBBLE1_NIBBLE_SEL_SHFT 12
#define SH_XN_MD_DEBUG_SEL_NIBBLE1_NIBBLE_SEL_MASK 0x0000000000007000

/*   SH_XN_MD_DEBUG_SEL_NIBBLE2_INPUT_SEL                               */
/*   Description:  Nibble 2 input select                                */
#define SH_XN_MD_DEBUG_SEL_NIBBLE2_INPUT_SEL_SHFT 16
#define SH_XN_MD_DEBUG_SEL_NIBBLE2_INPUT_SEL_MASK 0x0000000000070000

/*   SH_XN_MD_DEBUG_SEL_NIBBLE2_NIBBLE_SEL                              */
/*   Description:  Nibble 2 Nibble select                               */
#define SH_XN_MD_DEBUG_SEL_NIBBLE2_NIBBLE_SEL_SHFT 20
#define SH_XN_MD_DEBUG_SEL_NIBBLE2_NIBBLE_SEL_MASK 0x0000000000700000

/*   SH_XN_MD_DEBUG_SEL_NIBBLE3_INPUT_SEL                               */
/*   Description:  Nibble 3 input select                                */
#define SH_XN_MD_DEBUG_SEL_NIBBLE3_INPUT_SEL_SHFT 24
#define SH_XN_MD_DEBUG_SEL_NIBBLE3_INPUT_SEL_MASK 0x0000000007000000

/*   SH_XN_MD_DEBUG_SEL_NIBBLE3_NIBBLE_SEL                              */
/*   Description:  Nibble 3 Nibble select                               */
#define SH_XN_MD_DEBUG_SEL_NIBBLE3_NIBBLE_SEL_SHFT 28
#define SH_XN_MD_DEBUG_SEL_NIBBLE3_NIBBLE_SEL_MASK 0x0000000070000000

/*   SH_XN_MD_DEBUG_SEL_NIBBLE4_INPUT_SEL                               */
/*   Description:  Nibble 4 input select                                */
#define SH_XN_MD_DEBUG_SEL_NIBBLE4_INPUT_SEL_SHFT 32
#define SH_XN_MD_DEBUG_SEL_NIBBLE4_INPUT_SEL_MASK 0x0000000700000000

/*   SH_XN_MD_DEBUG_SEL_NIBBLE4_NIBBLE_SEL                              */
/*   Description:  Nibble 4 Nibble select                               */
#define SH_XN_MD_DEBUG_SEL_NIBBLE4_NIBBLE_SEL_SHFT 36
#define SH_XN_MD_DEBUG_SEL_NIBBLE4_NIBBLE_SEL_MASK 0x0000007000000000

/*   SH_XN_MD_DEBUG_SEL_NIBBLE5_INPUT_SEL                               */
/*   Description:  Nibble 5 input select                                */
#define SH_XN_MD_DEBUG_SEL_NIBBLE5_INPUT_SEL_SHFT 40
#define SH_XN_MD_DEBUG_SEL_NIBBLE5_INPUT_SEL_MASK 0x0000070000000000

/*   SH_XN_MD_DEBUG_SEL_NIBBLE5_NIBBLE_SEL                              */
/*   Description:  Nibble 5 Nibble select                               */
#define SH_XN_MD_DEBUG_SEL_NIBBLE5_NIBBLE_SEL_SHFT 44
#define SH_XN_MD_DEBUG_SEL_NIBBLE5_NIBBLE_SEL_MASK 0x0000700000000000

/*   SH_XN_MD_DEBUG_SEL_NIBBLE6_INPUT_SEL                               */
/*   Description:  Nibble 6 input select                                */
#define SH_XN_MD_DEBUG_SEL_NIBBLE6_INPUT_SEL_SHFT 48
#define SH_XN_MD_DEBUG_SEL_NIBBLE6_INPUT_SEL_MASK 0x0007000000000000

/*   SH_XN_MD_DEBUG_SEL_NIBBLE6_NIBBLE_SEL                              */
/*   Description:  Nibble 6 Nibble select                               */
#define SH_XN_MD_DEBUG_SEL_NIBBLE6_NIBBLE_SEL_SHFT 52
#define SH_XN_MD_DEBUG_SEL_NIBBLE6_NIBBLE_SEL_MASK 0x0070000000000000

/*   SH_XN_MD_DEBUG_SEL_NIBBLE7_INPUT_SEL                               */
/*   Description:  Nibble 7 input select                                */
#define SH_XN_MD_DEBUG_SEL_NIBBLE7_INPUT_SEL_SHFT 56
#define SH_XN_MD_DEBUG_SEL_NIBBLE7_INPUT_SEL_MASK 0x0700000000000000

/*   SH_XN_MD_DEBUG_SEL_NIBBLE7_NIBBLE_SEL                              */
/*   Description:  Nibble 7 Nibble select                               */
#define SH_XN_MD_DEBUG_SEL_NIBBLE7_NIBBLE_SEL_SHFT 60
#define SH_XN_MD_DEBUG_SEL_NIBBLE7_NIBBLE_SEL_MASK 0x7000000000000000

/* ==================================================================== */
/*                    Register "SH_XN_NI0_DEBUG_SEL"                    */
/*                       XN NI0 Debug Port Select                       */
/* ==================================================================== */

#define SH_XN_NI0_DEBUG_SEL                      0x00000001500310c0
#define SH_XN_NI0_DEBUG_SEL_MASK                 0x7777777777777777
#define SH_XN_NI0_DEBUG_SEL_INIT                 0x0000000000000000

/*   SH_XN_NI0_DEBUG_SEL_NIBBLE0_INPUT_SEL                              */
/*   Description:  Nibble 0 input select                                */
#define SH_XN_NI0_DEBUG_SEL_NIBBLE0_INPUT_SEL_SHFT 0
#define SH_XN_NI0_DEBUG_SEL_NIBBLE0_INPUT_SEL_MASK 0x0000000000000007

/*   SH_XN_NI0_DEBUG_SEL_NIBBLE0_NIBBLE_SEL                             */
/*   Description:  Nibble 0 Nibble select                               */
#define SH_XN_NI0_DEBUG_SEL_NIBBLE0_NIBBLE_SEL_SHFT 4
#define SH_XN_NI0_DEBUG_SEL_NIBBLE0_NIBBLE_SEL_MASK 0x0000000000000070

/*   SH_XN_NI0_DEBUG_SEL_NIBBLE1_INPUT_SEL                              */
/*   Description:  Nibble 1 input select                                */
#define SH_XN_NI0_DEBUG_SEL_NIBBLE1_INPUT_SEL_SHFT 8
#define SH_XN_NI0_DEBUG_SEL_NIBBLE1_INPUT_SEL_MASK 0x0000000000000700

/*   SH_XN_NI0_DEBUG_SEL_NIBBLE1_NIBBLE_SEL                             */
/*   Description:  Nibble 1 Nibble select                               */
#define SH_XN_NI0_DEBUG_SEL_NIBBLE1_NIBBLE_SEL_SHFT 12
#define SH_XN_NI0_DEBUG_SEL_NIBBLE1_NIBBLE_SEL_MASK 0x0000000000007000

/*   SH_XN_NI0_DEBUG_SEL_NIBBLE2_INPUT_SEL                              */
/*   Description:  Nibble 2 input select                                */
#define SH_XN_NI0_DEBUG_SEL_NIBBLE2_INPUT_SEL_SHFT 16
#define SH_XN_NI0_DEBUG_SEL_NIBBLE2_INPUT_SEL_MASK 0x0000000000070000

/*   SH_XN_NI0_DEBUG_SEL_NIBBLE2_NIBBLE_SEL                             */
/*   Description:  Nibble 2 Nibble select                               */
#define SH_XN_NI0_DEBUG_SEL_NIBBLE2_NIBBLE_SEL_SHFT 20
#define SH_XN_NI0_DEBUG_SEL_NIBBLE2_NIBBLE_SEL_MASK 0x0000000000700000

/*   SH_XN_NI0_DEBUG_SEL_NIBBLE3_INPUT_SEL                              */
/*   Description:  Nibble 3 input select                                */
#define SH_XN_NI0_DEBUG_SEL_NIBBLE3_INPUT_SEL_SHFT 24
#define SH_XN_NI0_DEBUG_SEL_NIBBLE3_INPUT_SEL_MASK 0x0000000007000000

/*   SH_XN_NI0_DEBUG_SEL_NIBBLE3_NIBBLE_SEL                             */
/*   Description:  Nibble 3 Nibble select                               */
#define SH_XN_NI0_DEBUG_SEL_NIBBLE3_NIBBLE_SEL_SHFT 28
#define SH_XN_NI0_DEBUG_SEL_NIBBLE3_NIBBLE_SEL_MASK 0x0000000070000000

/*   SH_XN_NI0_DEBUG_SEL_NIBBLE4_INPUT_SEL                              */
/*   Description:  Nibble 4 input select                                */
#define SH_XN_NI0_DEBUG_SEL_NIBBLE4_INPUT_SEL_SHFT 32
#define SH_XN_NI0_DEBUG_SEL_NIBBLE4_INPUT_SEL_MASK 0x0000000700000000

/*   SH_XN_NI0_DEBUG_SEL_NIBBLE4_NIBBLE_SEL                             */
/*   Description:  Nibble 4 Nibble select                               */
#define SH_XN_NI0_DEBUG_SEL_NIBBLE4_NIBBLE_SEL_SHFT 36
#define SH_XN_NI0_DEBUG_SEL_NIBBLE4_NIBBLE_SEL_MASK 0x0000007000000000

/*   SH_XN_NI0_DEBUG_SEL_NIBBLE5_INPUT_SEL                              */
/*   Description:  Nibble 5 input select                                */
#define SH_XN_NI0_DEBUG_SEL_NIBBLE5_INPUT_SEL_SHFT 40
#define SH_XN_NI0_DEBUG_SEL_NIBBLE5_INPUT_SEL_MASK 0x0000070000000000

/*   SH_XN_NI0_DEBUG_SEL_NIBBLE5_NIBBLE_SEL                             */
/*   Description:  Nibble 5 Nibble select                               */
#define SH_XN_NI0_DEBUG_SEL_NIBBLE5_NIBBLE_SEL_SHFT 44
#define SH_XN_NI0_DEBUG_SEL_NIBBLE5_NIBBLE_SEL_MASK 0x0000700000000000

/*   SH_XN_NI0_DEBUG_SEL_NIBBLE6_INPUT_SEL                              */
/*   Description:  Nibble 6 input select                                */
#define SH_XN_NI0_DEBUG_SEL_NIBBLE6_INPUT_SEL_SHFT 48
#define SH_XN_NI0_DEBUG_SEL_NIBBLE6_INPUT_SEL_MASK 0x0007000000000000

/*   SH_XN_NI0_DEBUG_SEL_NIBBLE6_NIBBLE_SEL                             */
/*   Description:  Nibble 6 Nibble select                               */
#define SH_XN_NI0_DEBUG_SEL_NIBBLE6_NIBBLE_SEL_SHFT 52
#define SH_XN_NI0_DEBUG_SEL_NIBBLE6_NIBBLE_SEL_MASK 0x0070000000000000

/*   SH_XN_NI0_DEBUG_SEL_NIBBLE7_INPUT_SEL                              */
/*   Description:  Nibble 7 input select                                */
#define SH_XN_NI0_DEBUG_SEL_NIBBLE7_INPUT_SEL_SHFT 56
#define SH_XN_NI0_DEBUG_SEL_NIBBLE7_INPUT_SEL_MASK 0x0700000000000000

/*   SH_XN_NI0_DEBUG_SEL_NIBBLE7_NIBBLE_SEL                             */
/*   Description:  Nibble 7 Nibble select                               */
#define SH_XN_NI0_DEBUG_SEL_NIBBLE7_NIBBLE_SEL_SHFT 60
#define SH_XN_NI0_DEBUG_SEL_NIBBLE7_NIBBLE_SEL_MASK 0x7000000000000000

/* ==================================================================== */
/*                    Register "SH_XN_NI1_DEBUG_SEL"                    */
/*                       XN NI1 Debug Port Select                       */
/* ==================================================================== */

#define SH_XN_NI1_DEBUG_SEL                      0x00000001500310e0
#define SH_XN_NI1_DEBUG_SEL_MASK                 0x7777777777777777
#define SH_XN_NI1_DEBUG_SEL_INIT                 0x0000000000000000

/*   SH_XN_NI1_DEBUG_SEL_NIBBLE0_INPUT_SEL                              */
/*   Description:  Nibble 0 input select                                */
#define SH_XN_NI1_DEBUG_SEL_NIBBLE0_INPUT_SEL_SHFT 0
#define SH_XN_NI1_DEBUG_SEL_NIBBLE0_INPUT_SEL_MASK 0x0000000000000007

/*   SH_XN_NI1_DEBUG_SEL_NIBBLE0_NIBBLE_SEL                             */
/*   Description:  Nibble 0 Nibble select                               */
#define SH_XN_NI1_DEBUG_SEL_NIBBLE0_NIBBLE_SEL_SHFT 4
#define SH_XN_NI1_DEBUG_SEL_NIBBLE0_NIBBLE_SEL_MASK 0x0000000000000070

/*   SH_XN_NI1_DEBUG_SEL_NIBBLE1_INPUT_SEL                              */
/*   Description:  Nibble 1 input select                                */
#define SH_XN_NI1_DEBUG_SEL_NIBBLE1_INPUT_SEL_SHFT 8
#define SH_XN_NI1_DEBUG_SEL_NIBBLE1_INPUT_SEL_MASK 0x0000000000000700

/*   SH_XN_NI1_DEBUG_SEL_NIBBLE1_NIBBLE_SEL                             */
/*   Description:  Nibble 1 Nibble select                               */
#define SH_XN_NI1_DEBUG_SEL_NIBBLE1_NIBBLE_SEL_SHFT 12
#define SH_XN_NI1_DEBUG_SEL_NIBBLE1_NIBBLE_SEL_MASK 0x0000000000007000

/*   SH_XN_NI1_DEBUG_SEL_NIBBLE2_INPUT_SEL                              */
/*   Description:  Nibble 2 input select                                */
#define SH_XN_NI1_DEBUG_SEL_NIBBLE2_INPUT_SEL_SHFT 16
#define SH_XN_NI1_DEBUG_SEL_NIBBLE2_INPUT_SEL_MASK 0x0000000000070000

/*   SH_XN_NI1_DEBUG_SEL_NIBBLE2_NIBBLE_SEL                             */
/*   Description:  Nibble 2 Nibble select                               */
#define SH_XN_NI1_DEBUG_SEL_NIBBLE2_NIBBLE_SEL_SHFT 20
#define SH_XN_NI1_DEBUG_SEL_NIBBLE2_NIBBLE_SEL_MASK 0x0000000000700000

/*   SH_XN_NI1_DEBUG_SEL_NIBBLE3_INPUT_SEL                              */
/*   Description:  Nibble 3 input select                                */
#define SH_XN_NI1_DEBUG_SEL_NIBBLE3_INPUT_SEL_SHFT 24
#define SH_XN_NI1_DEBUG_SEL_NIBBLE3_INPUT_SEL_MASK 0x0000000007000000

/*   SH_XN_NI1_DEBUG_SEL_NIBBLE3_NIBBLE_SEL                             */
/*   Description:  Nibble 3 Nibble select                               */
#define SH_XN_NI1_DEBUG_SEL_NIBBLE3_NIBBLE_SEL_SHFT 28
#define SH_XN_NI1_DEBUG_SEL_NIBBLE3_NIBBLE_SEL_MASK 0x0000000070000000

/*   SH_XN_NI1_DEBUG_SEL_NIBBLE4_INPUT_SEL                              */
/*   Description:  Nibble 4 input select                                */
#define SH_XN_NI1_DEBUG_SEL_NIBBLE4_INPUT_SEL_SHFT 32
#define SH_XN_NI1_DEBUG_SEL_NIBBLE4_INPUT_SEL_MASK 0x0000000700000000

/*   SH_XN_NI1_DEBUG_SEL_NIBBLE4_NIBBLE_SEL                             */
/*   Description:  Nibble 4 Nibble select                               */
#define SH_XN_NI1_DEBUG_SEL_NIBBLE4_NIBBLE_SEL_SHFT 36
#define SH_XN_NI1_DEBUG_SEL_NIBBLE4_NIBBLE_SEL_MASK 0x0000007000000000

/*   SH_XN_NI1_DEBUG_SEL_NIBBLE5_INPUT_SEL                              */
/*   Description:  Nibble 5 input select                                */
#define SH_XN_NI1_DEBUG_SEL_NIBBLE5_INPUT_SEL_SHFT 40
#define SH_XN_NI1_DEBUG_SEL_NIBBLE5_INPUT_SEL_MASK 0x0000070000000000

/*   SH_XN_NI1_DEBUG_SEL_NIBBLE5_NIBBLE_SEL                             */
/*   Description:  Nibble 5 Nibble select                               */
#define SH_XN_NI1_DEBUG_SEL_NIBBLE5_NIBBLE_SEL_SHFT 44
#define SH_XN_NI1_DEBUG_SEL_NIBBLE5_NIBBLE_SEL_MASK 0x0000700000000000

/*   SH_XN_NI1_DEBUG_SEL_NIBBLE6_INPUT_SEL                              */
/*   Description:  Nibble 6 input select                                */
#define SH_XN_NI1_DEBUG_SEL_NIBBLE6_INPUT_SEL_SHFT 48
#define SH_XN_NI1_DEBUG_SEL_NIBBLE6_INPUT_SEL_MASK 0x0007000000000000

/*   SH_XN_NI1_DEBUG_SEL_NIBBLE6_NIBBLE_SEL                             */
/*   Description:  Nibble 6 Nibble select                               */
#define SH_XN_NI1_DEBUG_SEL_NIBBLE6_NIBBLE_SEL_SHFT 52
#define SH_XN_NI1_DEBUG_SEL_NIBBLE6_NIBBLE_SEL_MASK 0x0070000000000000

/*   SH_XN_NI1_DEBUG_SEL_NIBBLE7_INPUT_SEL                              */
/*   Description:  Nibble 7 input select                                */
#define SH_XN_NI1_DEBUG_SEL_NIBBLE7_INPUT_SEL_SHFT 56
#define SH_XN_NI1_DEBUG_SEL_NIBBLE7_INPUT_SEL_MASK 0x0700000000000000

/*   SH_XN_NI1_DEBUG_SEL_NIBBLE7_NIBBLE_SEL                             */
/*   Description:  Nibble 7 Nibble select                               */
#define SH_XN_NI1_DEBUG_SEL_NIBBLE7_NIBBLE_SEL_SHFT 60
#define SH_XN_NI1_DEBUG_SEL_NIBBLE7_NIBBLE_SEL_MASK 0x7000000000000000

/* ==================================================================== */
/*                Register "SH_XN_IILB_LB_CMP_EXP_DATA0"                */
/*                 IILB compare LB input expected data0                 */
/* ==================================================================== */

#define SH_XN_IILB_LB_CMP_EXP_DATA0              0x0000000150031100
#define SH_XN_IILB_LB_CMP_EXP_DATA0_MASK         0xffffffffffffffff
#define SH_XN_IILB_LB_CMP_EXP_DATA0_INIT         0x0000000000000000

/*   SH_XN_IILB_LB_CMP_EXP_DATA0_DATA                                   */
/*   Description:  Expected data 0                                      */
#define SH_XN_IILB_LB_CMP_EXP_DATA0_DATA_SHFT    0
#define SH_XN_IILB_LB_CMP_EXP_DATA0_DATA_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_IILB_LB_CMP_EXP_DATA1"                */
/*                 IILB compare LB input expected data1                 */
/* ==================================================================== */

#define SH_XN_IILB_LB_CMP_EXP_DATA1              0x0000000150031110
#define SH_XN_IILB_LB_CMP_EXP_DATA1_MASK         0xffffffffffffffff
#define SH_XN_IILB_LB_CMP_EXP_DATA1_INIT         0x0000000000000000

/*   SH_XN_IILB_LB_CMP_EXP_DATA1_DATA                                   */
/*   Description:  Expected data 1                                      */
#define SH_XN_IILB_LB_CMP_EXP_DATA1_DATA_SHFT    0
#define SH_XN_IILB_LB_CMP_EXP_DATA1_DATA_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_IILB_LB_CMP_ENABLE0"                 */
/*                    IILB compare LB input enable0                     */
/* ==================================================================== */

#define SH_XN_IILB_LB_CMP_ENABLE0                0x0000000150031120
#define SH_XN_IILB_LB_CMP_ENABLE0_MASK           0xffffffffffffffff
#define SH_XN_IILB_LB_CMP_ENABLE0_INIT           0x0000000000000000

/*   SH_XN_IILB_LB_CMP_ENABLE0_ENABLE                                   */
/*   Description:  Enable0                                              */
#define SH_XN_IILB_LB_CMP_ENABLE0_ENABLE_SHFT    0
#define SH_XN_IILB_LB_CMP_ENABLE0_ENABLE_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_IILB_LB_CMP_ENABLE1"                 */
/*                    IILB compare LB input enable1                     */
/* ==================================================================== */

#define SH_XN_IILB_LB_CMP_ENABLE1                0x0000000150031130
#define SH_XN_IILB_LB_CMP_ENABLE1_MASK           0xffffffffffffffff
#define SH_XN_IILB_LB_CMP_ENABLE1_INIT           0x0000000000000000

/*   SH_XN_IILB_LB_CMP_ENABLE1_ENABLE                                   */
/*   Description:  Enable1                                              */
#define SH_XN_IILB_LB_CMP_ENABLE1_ENABLE_SHFT    0
#define SH_XN_IILB_LB_CMP_ENABLE1_ENABLE_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_IILB_II_CMP_EXP_DATA0"                */
/*                 IILB compare II input expected data0                 */
/* ==================================================================== */

#define SH_XN_IILB_II_CMP_EXP_DATA0              0x0000000150031140
#define SH_XN_IILB_II_CMP_EXP_DATA0_MASK         0xffffffffffffffff
#define SH_XN_IILB_II_CMP_EXP_DATA0_INIT         0x0000000000000000

/*   SH_XN_IILB_II_CMP_EXP_DATA0_DATA                                   */
/*   Description:  Expected data 0                                      */
#define SH_XN_IILB_II_CMP_EXP_DATA0_DATA_SHFT    0
#define SH_XN_IILB_II_CMP_EXP_DATA0_DATA_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_IILB_II_CMP_EXP_DATA1"                */
/*                 IILB compare II input expected data1                 */
/* ==================================================================== */

#define SH_XN_IILB_II_CMP_EXP_DATA1              0x0000000150031150
#define SH_XN_IILB_II_CMP_EXP_DATA1_MASK         0xffffffffffffffff
#define SH_XN_IILB_II_CMP_EXP_DATA1_INIT         0x0000000000000000

/*   SH_XN_IILB_II_CMP_EXP_DATA1_DATA                                   */
/*   Description:  Expected data 1                                      */
#define SH_XN_IILB_II_CMP_EXP_DATA1_DATA_SHFT    0
#define SH_XN_IILB_II_CMP_EXP_DATA1_DATA_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_IILB_II_CMP_ENABLE0"                 */
/*                    IILB compare II input enable0                     */
/* ==================================================================== */

#define SH_XN_IILB_II_CMP_ENABLE0                0x0000000150031160
#define SH_XN_IILB_II_CMP_ENABLE0_MASK           0xffffffffffffffff
#define SH_XN_IILB_II_CMP_ENABLE0_INIT           0x0000000000000000

/*   SH_XN_IILB_II_CMP_ENABLE0_ENABLE                                   */
/*   Description:  Enable0                                              */
#define SH_XN_IILB_II_CMP_ENABLE0_ENABLE_SHFT    0
#define SH_XN_IILB_II_CMP_ENABLE0_ENABLE_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_IILB_II_CMP_ENABLE1"                 */
/*                    IILB compare II input enable1                     */
/* ==================================================================== */

#define SH_XN_IILB_II_CMP_ENABLE1                0x0000000150031170
#define SH_XN_IILB_II_CMP_ENABLE1_MASK           0xffffffffffffffff
#define SH_XN_IILB_II_CMP_ENABLE1_INIT           0x0000000000000000

/*   SH_XN_IILB_II_CMP_ENABLE1_ENABLE                                   */
/*   Description:  Enable1                                              */
#define SH_XN_IILB_II_CMP_ENABLE1_ENABLE_SHFT    0
#define SH_XN_IILB_II_CMP_ENABLE1_ENABLE_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_IILB_MD_CMP_EXP_DATA0"                */
/*                 IILB compare MD input expected data0                 */
/* ==================================================================== */

#define SH_XN_IILB_MD_CMP_EXP_DATA0              0x0000000150031180
#define SH_XN_IILB_MD_CMP_EXP_DATA0_MASK         0xffffffffffffffff
#define SH_XN_IILB_MD_CMP_EXP_DATA0_INIT         0x0000000000000000

/*   SH_XN_IILB_MD_CMP_EXP_DATA0_DATA                                   */
/*   Description:  Expected data 0                                      */
#define SH_XN_IILB_MD_CMP_EXP_DATA0_DATA_SHFT    0
#define SH_XN_IILB_MD_CMP_EXP_DATA0_DATA_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_IILB_MD_CMP_EXP_DATA1"                */
/*                 IILB compare MD input expected data1                 */
/* ==================================================================== */

#define SH_XN_IILB_MD_CMP_EXP_DATA1              0x0000000150031190
#define SH_XN_IILB_MD_CMP_EXP_DATA1_MASK         0xffffffffffffffff
#define SH_XN_IILB_MD_CMP_EXP_DATA1_INIT         0x0000000000000000

/*   SH_XN_IILB_MD_CMP_EXP_DATA1_DATA                                   */
/*   Description:  Expected data 1                                      */
#define SH_XN_IILB_MD_CMP_EXP_DATA1_DATA_SHFT    0
#define SH_XN_IILB_MD_CMP_EXP_DATA1_DATA_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_IILB_MD_CMP_ENABLE0"                 */
/*                    IILB compare MD input enable0                     */
/* ==================================================================== */

#define SH_XN_IILB_MD_CMP_ENABLE0                0x00000001500311a0
#define SH_XN_IILB_MD_CMP_ENABLE0_MASK           0xffffffffffffffff
#define SH_XN_IILB_MD_CMP_ENABLE0_INIT           0x0000000000000000

/*   SH_XN_IILB_MD_CMP_ENABLE0_ENABLE                                   */
/*   Description:  Enable0                                              */
#define SH_XN_IILB_MD_CMP_ENABLE0_ENABLE_SHFT    0
#define SH_XN_IILB_MD_CMP_ENABLE0_ENABLE_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_IILB_MD_CMP_ENABLE1"                 */
/*                    IILB compare MD input enable1                     */
/* ==================================================================== */

#define SH_XN_IILB_MD_CMP_ENABLE1                0x00000001500311b0
#define SH_XN_IILB_MD_CMP_ENABLE1_MASK           0xffffffffffffffff
#define SH_XN_IILB_MD_CMP_ENABLE1_INIT           0x0000000000000000

/*   SH_XN_IILB_MD_CMP_ENABLE1_ENABLE                                   */
/*   Description:  Enable1                                              */
#define SH_XN_IILB_MD_CMP_ENABLE1_ENABLE_SHFT    0
#define SH_XN_IILB_MD_CMP_ENABLE1_ENABLE_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_IILB_PI_CMP_EXP_DATA0"                */
/*                 IILB compare PI input expected data0                 */
/* ==================================================================== */

#define SH_XN_IILB_PI_CMP_EXP_DATA0              0x00000001500311c0
#define SH_XN_IILB_PI_CMP_EXP_DATA0_MASK         0xffffffffffffffff
#define SH_XN_IILB_PI_CMP_EXP_DATA0_INIT         0x0000000000000000

/*   SH_XN_IILB_PI_CMP_EXP_DATA0_DATA                                   */
/*   Description:  Expected data 0                                      */
#define SH_XN_IILB_PI_CMP_EXP_DATA0_DATA_SHFT    0
#define SH_XN_IILB_PI_CMP_EXP_DATA0_DATA_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_IILB_PI_CMP_EXP_DATA1"                */
/*                 IILB compare PI input expected data1                 */
/* ==================================================================== */

#define SH_XN_IILB_PI_CMP_EXP_DATA1              0x00000001500311d0
#define SH_XN_IILB_PI_CMP_EXP_DATA1_MASK         0xffffffffffffffff
#define SH_XN_IILB_PI_CMP_EXP_DATA1_INIT         0x0000000000000000

/*   SH_XN_IILB_PI_CMP_EXP_DATA1_DATA                                   */
/*   Description:  Expected data 1                                      */
#define SH_XN_IILB_PI_CMP_EXP_DATA1_DATA_SHFT    0
#define SH_XN_IILB_PI_CMP_EXP_DATA1_DATA_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_IILB_PI_CMP_ENABLE0"                 */
/*                    IILB compare PI input enable0                     */
/* ==================================================================== */

#define SH_XN_IILB_PI_CMP_ENABLE0                0x00000001500311e0
#define SH_XN_IILB_PI_CMP_ENABLE0_MASK           0xffffffffffffffff
#define SH_XN_IILB_PI_CMP_ENABLE0_INIT           0x0000000000000000

/*   SH_XN_IILB_PI_CMP_ENABLE0_ENABLE                                   */
/*   Description:  Enable0                                              */
#define SH_XN_IILB_PI_CMP_ENABLE0_ENABLE_SHFT    0
#define SH_XN_IILB_PI_CMP_ENABLE0_ENABLE_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_IILB_PI_CMP_ENABLE1"                 */
/*                    IILB compare PI input enable1                     */
/* ==================================================================== */

#define SH_XN_IILB_PI_CMP_ENABLE1                0x00000001500311f0
#define SH_XN_IILB_PI_CMP_ENABLE1_MASK           0xffffffffffffffff
#define SH_XN_IILB_PI_CMP_ENABLE1_INIT           0x0000000000000000

/*   SH_XN_IILB_PI_CMP_ENABLE1_ENABLE                                   */
/*   Description:  Enable1                                              */
#define SH_XN_IILB_PI_CMP_ENABLE1_ENABLE_SHFT    0
#define SH_XN_IILB_PI_CMP_ENABLE1_ENABLE_MASK    0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_IILB_NI0_CMP_EXP_DATA0"                */
/*                IILB compare NI0 input expected data0                 */
/* ==================================================================== */

#define SH_XN_IILB_NI0_CMP_EXP_DATA0             0x0000000150031200
#define SH_XN_IILB_NI0_CMP_EXP_DATA0_MASK        0xffffffffffffffff
#define SH_XN_IILB_NI0_CMP_EXP_DATA0_INIT        0x0000000000000000

/*   SH_XN_IILB_NI0_CMP_EXP_DATA0_DATA                                  */
/*   Description:  Expected data 0                                      */
#define SH_XN_IILB_NI0_CMP_EXP_DATA0_DATA_SHFT   0
#define SH_XN_IILB_NI0_CMP_EXP_DATA0_DATA_MASK   0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_IILB_NI0_CMP_EXP_DATA1"                */
/*                IILB compare NI0 input expected data1                 */
/* ==================================================================== */

#define SH_XN_IILB_NI0_CMP_EXP_DATA1             0x0000000150031210
#define SH_XN_IILB_NI0_CMP_EXP_DATA1_MASK        0xffffffffffffffff
#define SH_XN_IILB_NI0_CMP_EXP_DATA1_INIT        0x0000000000000000

/*   SH_XN_IILB_NI0_CMP_EXP_DATA1_DATA                                  */
/*   Description:  Expected data 1                                      */
#define SH_XN_IILB_NI0_CMP_EXP_DATA1_DATA_SHFT   0
#define SH_XN_IILB_NI0_CMP_EXP_DATA1_DATA_MASK   0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_IILB_NI0_CMP_ENABLE0"                 */
/*                    IILB compare NI0 input enable0                    */
/* ==================================================================== */

#define SH_XN_IILB_NI0_CMP_ENABLE0               0x0000000150031220
#define SH_XN_IILB_NI0_CMP_ENABLE0_MASK          0xffffffffffffffff
#define SH_XN_IILB_NI0_CMP_ENABLE0_INIT          0x0000000000000000

/*   SH_XN_IILB_NI0_CMP_ENABLE0_ENABLE                                  */
/*   Description:  Enable0                                              */
#define SH_XN_IILB_NI0_CMP_ENABLE0_ENABLE_SHFT   0
#define SH_XN_IILB_NI0_CMP_ENABLE0_ENABLE_MASK   0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_IILB_NI0_CMP_ENABLE1"                 */
/*                    IILB compare NI0 input enable1                    */
/* ==================================================================== */

#define SH_XN_IILB_NI0_CMP_ENABLE1               0x0000000150031230
#define SH_XN_IILB_NI0_CMP_ENABLE1_MASK          0xffffffffffffffff
#define SH_XN_IILB_NI0_CMP_ENABLE1_INIT          0x0000000000000000

/*   SH_XN_IILB_NI0_CMP_ENABLE1_ENABLE                                  */
/*   Description:  Enable1                                              */
#define SH_XN_IILB_NI0_CMP_ENABLE1_ENABLE_SHFT   0
#define SH_XN_IILB_NI0_CMP_ENABLE1_ENABLE_MASK   0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_IILB_NI1_CMP_EXP_DATA0"                */
/*                IILB compare NI1 input expected data0                 */
/* ==================================================================== */

#define SH_XN_IILB_NI1_CMP_EXP_DATA0             0x0000000150031240
#define SH_XN_IILB_NI1_CMP_EXP_DATA0_MASK        0xffffffffffffffff
#define SH_XN_IILB_NI1_CMP_EXP_DATA0_INIT        0x0000000000000000

/*   SH_XN_IILB_NI1_CMP_EXP_DATA0_DATA                                  */
/*   Description:  Expected data 0                                      */
#define SH_XN_IILB_NI1_CMP_EXP_DATA0_DATA_SHFT   0
#define SH_XN_IILB_NI1_CMP_EXP_DATA0_DATA_MASK   0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_IILB_NI1_CMP_EXP_DATA1"                */
/*                IILB compare NI1 input expected data1                 */
/* ==================================================================== */

#define SH_XN_IILB_NI1_CMP_EXP_DATA1             0x0000000150031250
#define SH_XN_IILB_NI1_CMP_EXP_DATA1_MASK        0xffffffffffffffff
#define SH_XN_IILB_NI1_CMP_EXP_DATA1_INIT        0x0000000000000000

/*   SH_XN_IILB_NI1_CMP_EXP_DATA1_DATA                                  */
/*   Description:  Expected data 1                                      */
#define SH_XN_IILB_NI1_CMP_EXP_DATA1_DATA_SHFT   0
#define SH_XN_IILB_NI1_CMP_EXP_DATA1_DATA_MASK   0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_IILB_NI1_CMP_ENABLE0"                 */
/*                    IILB compare NI1 input enable0                    */
/* ==================================================================== */

#define SH_XN_IILB_NI1_CMP_ENABLE0               0x0000000150031260
#define SH_XN_IILB_NI1_CMP_ENABLE0_MASK          0xffffffffffffffff
#define SH_XN_IILB_NI1_CMP_ENABLE0_INIT          0x0000000000000000

/*   SH_XN_IILB_NI1_CMP_ENABLE0_ENABLE                                  */
/*   Description:  Enable0                                              */
#define SH_XN_IILB_NI1_CMP_ENABLE0_ENABLE_SHFT   0
#define SH_XN_IILB_NI1_CMP_ENABLE0_ENABLE_MASK   0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_IILB_NI1_CMP_ENABLE1"                 */
/*                    IILB compare NI1 input enable1                    */
/* ==================================================================== */

#define SH_XN_IILB_NI1_CMP_ENABLE1               0x0000000150031270
#define SH_XN_IILB_NI1_CMP_ENABLE1_MASK          0xffffffffffffffff
#define SH_XN_IILB_NI1_CMP_ENABLE1_INIT          0x0000000000000000

/*   SH_XN_IILB_NI1_CMP_ENABLE1_ENABLE                                  */
/*   Description:  Enable1                                              */
#define SH_XN_IILB_NI1_CMP_ENABLE1_ENABLE_SHFT   0
#define SH_XN_IILB_NI1_CMP_ENABLE1_ENABLE_MASK   0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_MD_IILB_CMP_EXP_DATA0"                */
/*                 MD compare IILB input expected data0                 */
/* ==================================================================== */

#define SH_XN_MD_IILB_CMP_EXP_DATA0              0x0000000150031500
#define SH_XN_MD_IILB_CMP_EXP_DATA0_MASK         0xffffffffffffffff
#define SH_XN_MD_IILB_CMP_EXP_DATA0_INIT         0x0000000000000000

/*   SH_XN_MD_IILB_CMP_EXP_DATA0_DATA                                   */
/*   Description:  Expected data 0                                      */
#define SH_XN_MD_IILB_CMP_EXP_DATA0_DATA_SHFT    0
#define SH_XN_MD_IILB_CMP_EXP_DATA0_DATA_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_MD_IILB_CMP_EXP_DATA1"                */
/*                 MD compare IILB input expected data1                 */
/* ==================================================================== */

#define SH_XN_MD_IILB_CMP_EXP_DATA1              0x0000000150031510
#define SH_XN_MD_IILB_CMP_EXP_DATA1_MASK         0xffffffffffffffff
#define SH_XN_MD_IILB_CMP_EXP_DATA1_INIT         0x0000000000000000

/*   SH_XN_MD_IILB_CMP_EXP_DATA1_DATA                                   */
/*   Description:  Expected data 1                                      */
#define SH_XN_MD_IILB_CMP_EXP_DATA1_DATA_SHFT    0
#define SH_XN_MD_IILB_CMP_EXP_DATA1_DATA_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_MD_IILB_CMP_ENABLE0"                 */
/*                    MD compare IILB input enable0                     */
/* ==================================================================== */

#define SH_XN_MD_IILB_CMP_ENABLE0                0x0000000150031520
#define SH_XN_MD_IILB_CMP_ENABLE0_MASK           0xffffffffffffffff
#define SH_XN_MD_IILB_CMP_ENABLE0_INIT           0x0000000000000000

/*   SH_XN_MD_IILB_CMP_ENABLE0_ENABLE                                   */
/*   Description:  Enable0                                              */
#define SH_XN_MD_IILB_CMP_ENABLE0_ENABLE_SHFT    0
#define SH_XN_MD_IILB_CMP_ENABLE0_ENABLE_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_MD_IILB_CMP_ENABLE1"                 */
/*                    MD compare IILB input enable1                     */
/* ==================================================================== */

#define SH_XN_MD_IILB_CMP_ENABLE1                0x0000000150031530
#define SH_XN_MD_IILB_CMP_ENABLE1_MASK           0xffffffffffffffff
#define SH_XN_MD_IILB_CMP_ENABLE1_INIT           0x0000000000000000

/*   SH_XN_MD_IILB_CMP_ENABLE1_ENABLE                                   */
/*   Description:  Enable1                                              */
#define SH_XN_MD_IILB_CMP_ENABLE1_ENABLE_SHFT    0
#define SH_XN_MD_IILB_CMP_ENABLE1_ENABLE_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_MD_NI0_CMP_EXP_DATA0"                 */
/*                 MD compare NI0 input expected data0                  */
/* ==================================================================== */

#define SH_XN_MD_NI0_CMP_EXP_DATA0               0x0000000150031540
#define SH_XN_MD_NI0_CMP_EXP_DATA0_MASK          0xffffffffffffffff
#define SH_XN_MD_NI0_CMP_EXP_DATA0_INIT          0x0000000000000000

/*   SH_XN_MD_NI0_CMP_EXP_DATA0_DATA                                    */
/*   Description:  Expected data 0                                      */
#define SH_XN_MD_NI0_CMP_EXP_DATA0_DATA_SHFT     0
#define SH_XN_MD_NI0_CMP_EXP_DATA0_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_MD_NI0_CMP_EXP_DATA1"                 */
/*                 MD compare NI0 input expected data1                  */
/* ==================================================================== */

#define SH_XN_MD_NI0_CMP_EXP_DATA1               0x0000000150031550
#define SH_XN_MD_NI0_CMP_EXP_DATA1_MASK          0xffffffffffffffff
#define SH_XN_MD_NI0_CMP_EXP_DATA1_INIT          0x0000000000000000

/*   SH_XN_MD_NI0_CMP_EXP_DATA1_DATA                                    */
/*   Description:  Expected data 1                                      */
#define SH_XN_MD_NI0_CMP_EXP_DATA1_DATA_SHFT     0
#define SH_XN_MD_NI0_CMP_EXP_DATA1_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_MD_NI0_CMP_ENABLE0"                  */
/*                     MD compare NI0 input enable0                     */
/* ==================================================================== */

#define SH_XN_MD_NI0_CMP_ENABLE0                 0x0000000150031560
#define SH_XN_MD_NI0_CMP_ENABLE0_MASK            0xffffffffffffffff
#define SH_XN_MD_NI0_CMP_ENABLE0_INIT            0x0000000000000000

/*   SH_XN_MD_NI0_CMP_ENABLE0_ENABLE                                    */
/*   Description:  Enable0                                              */
#define SH_XN_MD_NI0_CMP_ENABLE0_ENABLE_SHFT     0
#define SH_XN_MD_NI0_CMP_ENABLE0_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_MD_NI0_CMP_ENABLE1"                  */
/*                     MD compare NI0 input enable1                     */
/* ==================================================================== */

#define SH_XN_MD_NI0_CMP_ENABLE1                 0x0000000150031570
#define SH_XN_MD_NI0_CMP_ENABLE1_MASK            0xffffffffffffffff
#define SH_XN_MD_NI0_CMP_ENABLE1_INIT            0x0000000000000000

/*   SH_XN_MD_NI0_CMP_ENABLE1_ENABLE                                    */
/*   Description:  Enable1                                              */
#define SH_XN_MD_NI0_CMP_ENABLE1_ENABLE_SHFT     0
#define SH_XN_MD_NI0_CMP_ENABLE1_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_MD_NI1_CMP_EXP_DATA0"                 */
/*                 MD compare NI1 input expected data0                  */
/* ==================================================================== */

#define SH_XN_MD_NI1_CMP_EXP_DATA0               0x0000000150031580
#define SH_XN_MD_NI1_CMP_EXP_DATA0_MASK          0xffffffffffffffff
#define SH_XN_MD_NI1_CMP_EXP_DATA0_INIT          0x0000000000000000

/*   SH_XN_MD_NI1_CMP_EXP_DATA0_DATA                                    */
/*   Description:  Expected data 0                                      */
#define SH_XN_MD_NI1_CMP_EXP_DATA0_DATA_SHFT     0
#define SH_XN_MD_NI1_CMP_EXP_DATA0_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_MD_NI1_CMP_EXP_DATA1"                 */
/*                 MD compare NI1 input expected data1                  */
/* ==================================================================== */

#define SH_XN_MD_NI1_CMP_EXP_DATA1               0x0000000150031590
#define SH_XN_MD_NI1_CMP_EXP_DATA1_MASK          0xffffffffffffffff
#define SH_XN_MD_NI1_CMP_EXP_DATA1_INIT          0x0000000000000000

/*   SH_XN_MD_NI1_CMP_EXP_DATA1_DATA                                    */
/*   Description:  Expected data 1                                      */
#define SH_XN_MD_NI1_CMP_EXP_DATA1_DATA_SHFT     0
#define SH_XN_MD_NI1_CMP_EXP_DATA1_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_MD_NI1_CMP_ENABLE0"                  */
/*                     MD compare NI1 input enable0                     */
/* ==================================================================== */

#define SH_XN_MD_NI1_CMP_ENABLE0                 0x00000001500315a0
#define SH_XN_MD_NI1_CMP_ENABLE0_MASK            0xffffffffffffffff
#define SH_XN_MD_NI1_CMP_ENABLE0_INIT            0x0000000000000000

/*   SH_XN_MD_NI1_CMP_ENABLE0_ENABLE                                    */
/*   Description:  Enable0                                              */
#define SH_XN_MD_NI1_CMP_ENABLE0_ENABLE_SHFT     0
#define SH_XN_MD_NI1_CMP_ENABLE0_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_MD_NI1_CMP_ENABLE1"                  */
/*                     MD compare NI1 input enable1                     */
/* ==================================================================== */

#define SH_XN_MD_NI1_CMP_ENABLE1                 0x00000001500315b0
#define SH_XN_MD_NI1_CMP_ENABLE1_MASK            0xffffffffffffffff
#define SH_XN_MD_NI1_CMP_ENABLE1_INIT            0x0000000000000000

/*   SH_XN_MD_NI1_CMP_ENABLE1_ENABLE                                    */
/*   Description:  Enable1                                              */
#define SH_XN_MD_NI1_CMP_ENABLE1_ENABLE_SHFT     0
#define SH_XN_MD_NI1_CMP_ENABLE1_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_MD_SIC_CMP_EXP_HDR0"                 */
/*                MD compare SIC input expected header0                 */
/* ==================================================================== */

#define SH_XN_MD_SIC_CMP_EXP_HDR0                0x00000001500315c0
#define SH_XN_MD_SIC_CMP_EXP_HDR0_MASK           0xffffffffffffffff
#define SH_XN_MD_SIC_CMP_EXP_HDR0_INIT           0x0000000000000000

/*   SH_XN_MD_SIC_CMP_EXP_HDR0_DATA                                     */
/*   Description:  Expected data 0                                      */
#define SH_XN_MD_SIC_CMP_EXP_HDR0_DATA_SHFT      0
#define SH_XN_MD_SIC_CMP_EXP_HDR0_DATA_MASK      0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_MD_SIC_CMP_EXP_HDR1"                 */
/*                MD compare SIC input expected header1                 */
/* ==================================================================== */

#define SH_XN_MD_SIC_CMP_EXP_HDR1                0x00000001500315d0
#define SH_XN_MD_SIC_CMP_EXP_HDR1_MASK           0x000003ffffffffff
#define SH_XN_MD_SIC_CMP_EXP_HDR1_INIT           0x0000000000000000

/*   SH_XN_MD_SIC_CMP_EXP_HDR1_DATA                                     */
/*   Description:  Expected data 1                                      */
#define SH_XN_MD_SIC_CMP_EXP_HDR1_DATA_SHFT      0
#define SH_XN_MD_SIC_CMP_EXP_HDR1_DATA_MASK      0x000003ffffffffff

/* ==================================================================== */
/*               Register "SH_XN_MD_SIC_CMP_HDR_ENABLE0"                */
/*                    MD compare SIC header enable0                     */
/* ==================================================================== */

#define SH_XN_MD_SIC_CMP_HDR_ENABLE0             0x00000001500315e0
#define SH_XN_MD_SIC_CMP_HDR_ENABLE0_MASK        0xffffffffffffffff
#define SH_XN_MD_SIC_CMP_HDR_ENABLE0_INIT        0x0000000000000000

/*   SH_XN_MD_SIC_CMP_HDR_ENABLE0_ENABLE                                */
/*   Description:  Enable0                                              */
#define SH_XN_MD_SIC_CMP_HDR_ENABLE0_ENABLE_SHFT 0
#define SH_XN_MD_SIC_CMP_HDR_ENABLE0_ENABLE_MASK 0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_MD_SIC_CMP_HDR_ENABLE1"                */
/*                    MD compare SIC header enable1                     */
/* ==================================================================== */

#define SH_XN_MD_SIC_CMP_HDR_ENABLE1             0x00000001500315f0
#define SH_XN_MD_SIC_CMP_HDR_ENABLE1_MASK        0x000003ffffffffff
#define SH_XN_MD_SIC_CMP_HDR_ENABLE1_INIT        0x0000000000000000

/*   SH_XN_MD_SIC_CMP_HDR_ENABLE1_ENABLE                                */
/*   Description:  Enable1                                              */
#define SH_XN_MD_SIC_CMP_HDR_ENABLE1_ENABLE_SHFT 0
#define SH_XN_MD_SIC_CMP_HDR_ENABLE1_ENABLE_MASK 0x000003ffffffffff

/* ==================================================================== */
/*                  Register "SH_XN_MD_SIC_CMP_DATA0"                   */
/*                         MD compare SIC data0                         */
/* ==================================================================== */

#define SH_XN_MD_SIC_CMP_DATA0                   0x0000000150031600
#define SH_XN_MD_SIC_CMP_DATA0_MASK              0xffffffffffffffff
#define SH_XN_MD_SIC_CMP_DATA0_INIT              0x0000000000000000

/*   SH_XN_MD_SIC_CMP_DATA0_DATA0                                       */
/*   Description:  Data0                                                */
#define SH_XN_MD_SIC_CMP_DATA0_DATA0_SHFT        0
#define SH_XN_MD_SIC_CMP_DATA0_DATA0_MASK        0xffffffffffffffff

/* ==================================================================== */
/*                  Register "SH_XN_MD_SIC_CMP_DATA1"                   */
/*                         MD compare SIC data1                         */
/* ==================================================================== */

#define SH_XN_MD_SIC_CMP_DATA1                   0x0000000150031610
#define SH_XN_MD_SIC_CMP_DATA1_MASK              0xffffffffffffffff
#define SH_XN_MD_SIC_CMP_DATA1_INIT              0x0000000000000000

/*   SH_XN_MD_SIC_CMP_DATA1_DATA1                                       */
/*   Description:  Data1                                                */
#define SH_XN_MD_SIC_CMP_DATA1_DATA1_SHFT        0
#define SH_XN_MD_SIC_CMP_DATA1_DATA1_MASK        0xffffffffffffffff

/* ==================================================================== */
/*                  Register "SH_XN_MD_SIC_CMP_DATA2"                   */
/*                         MD compare SIC data2                         */
/* ==================================================================== */

#define SH_XN_MD_SIC_CMP_DATA2                   0x0000000150031620
#define SH_XN_MD_SIC_CMP_DATA2_MASK              0xffffffffffffffff
#define SH_XN_MD_SIC_CMP_DATA2_INIT              0x0000000000000000

/*   SH_XN_MD_SIC_CMP_DATA2_DATA2                                       */
/*   Description:  Data2                                                */
#define SH_XN_MD_SIC_CMP_DATA2_DATA2_SHFT        0
#define SH_XN_MD_SIC_CMP_DATA2_DATA2_MASK        0xffffffffffffffff

/* ==================================================================== */
/*                  Register "SH_XN_MD_SIC_CMP_DATA3"                   */
/*                         MD compare SIC data3                         */
/* ==================================================================== */

#define SH_XN_MD_SIC_CMP_DATA3                   0x0000000150031630
#define SH_XN_MD_SIC_CMP_DATA3_MASK              0xffffffffffffffff
#define SH_XN_MD_SIC_CMP_DATA3_INIT              0x0000000000000000

/*   SH_XN_MD_SIC_CMP_DATA3_DATA3                                       */
/*   Description:  Data3                                                */
#define SH_XN_MD_SIC_CMP_DATA3_DATA3_SHFT        0
#define SH_XN_MD_SIC_CMP_DATA3_DATA3_MASK        0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_MD_SIC_CMP_DATA_ENABLE0"               */
/*                     MD enable compare SIC data0                      */
/* ==================================================================== */

#define SH_XN_MD_SIC_CMP_DATA_ENABLE0            0x0000000150031640
#define SH_XN_MD_SIC_CMP_DATA_ENABLE0_MASK       0xffffffffffffffff
#define SH_XN_MD_SIC_CMP_DATA_ENABLE0_INIT       0x0000000000000000

/*   SH_XN_MD_SIC_CMP_DATA_ENABLE0_DATA_ENABLE0                         */
/*   Description:  Data0                                                */
#define SH_XN_MD_SIC_CMP_DATA_ENABLE0_DATA_ENABLE0_SHFT 0
#define SH_XN_MD_SIC_CMP_DATA_ENABLE0_DATA_ENABLE0_MASK 0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_MD_SIC_CMP_DATA_ENABLE1"               */
/*                     MD enable compare SIC data1                      */
/* ==================================================================== */

#define SH_XN_MD_SIC_CMP_DATA_ENABLE1            0x0000000150031650
#define SH_XN_MD_SIC_CMP_DATA_ENABLE1_MASK       0xffffffffffffffff
#define SH_XN_MD_SIC_CMP_DATA_ENABLE1_INIT       0x0000000000000000

/*   SH_XN_MD_SIC_CMP_DATA_ENABLE1_DATA_ENABLE1                         */
/*   Description:  Data1                                                */
#define SH_XN_MD_SIC_CMP_DATA_ENABLE1_DATA_ENABLE1_SHFT 0
#define SH_XN_MD_SIC_CMP_DATA_ENABLE1_DATA_ENABLE1_MASK 0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_MD_SIC_CMP_DATA_ENABLE2"               */
/*                     MD enable compare SIC data2                      */
/* ==================================================================== */

#define SH_XN_MD_SIC_CMP_DATA_ENABLE2            0x0000000150031660
#define SH_XN_MD_SIC_CMP_DATA_ENABLE2_MASK       0xffffffffffffffff
#define SH_XN_MD_SIC_CMP_DATA_ENABLE2_INIT       0x0000000000000000

/*   SH_XN_MD_SIC_CMP_DATA_ENABLE2_DATA_ENABLE2                         */
/*   Description:  Data2                                                */
#define SH_XN_MD_SIC_CMP_DATA_ENABLE2_DATA_ENABLE2_SHFT 0
#define SH_XN_MD_SIC_CMP_DATA_ENABLE2_DATA_ENABLE2_MASK 0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_MD_SIC_CMP_DATA_ENABLE3"               */
/*                     MD enable compare SIC data3                      */
/* ==================================================================== */

#define SH_XN_MD_SIC_CMP_DATA_ENABLE3            0x0000000150031670
#define SH_XN_MD_SIC_CMP_DATA_ENABLE3_MASK       0xffffffffffffffff
#define SH_XN_MD_SIC_CMP_DATA_ENABLE3_INIT       0x0000000000000000

/*   SH_XN_MD_SIC_CMP_DATA_ENABLE3_DATA_ENABLE3                         */
/*   Description:  Data3                                                */
#define SH_XN_MD_SIC_CMP_DATA_ENABLE3_DATA_ENABLE3_SHFT 0
#define SH_XN_MD_SIC_CMP_DATA_ENABLE3_DATA_ENABLE3_MASK 0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_PI_IILB_CMP_EXP_DATA0"                */
/*                 PI compare IILB input expected data0                 */
/* ==================================================================== */

#define SH_XN_PI_IILB_CMP_EXP_DATA0              0x0000000150031300
#define SH_XN_PI_IILB_CMP_EXP_DATA0_MASK         0xffffffffffffffff
#define SH_XN_PI_IILB_CMP_EXP_DATA0_INIT         0x0000000000000000

/*   SH_XN_PI_IILB_CMP_EXP_DATA0_DATA                                   */
/*   Description:  Expected data 0                                      */
#define SH_XN_PI_IILB_CMP_EXP_DATA0_DATA_SHFT    0
#define SH_XN_PI_IILB_CMP_EXP_DATA0_DATA_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_PI_IILB_CMP_EXP_DATA1"                */
/*                 PI compare IILB input expected data1                 */
/* ==================================================================== */

#define SH_XN_PI_IILB_CMP_EXP_DATA1              0x0000000150031310
#define SH_XN_PI_IILB_CMP_EXP_DATA1_MASK         0xffffffffffffffff
#define SH_XN_PI_IILB_CMP_EXP_DATA1_INIT         0x0000000000000000

/*   SH_XN_PI_IILB_CMP_EXP_DATA1_DATA                                   */
/*   Description:  Expected data 1                                      */
#define SH_XN_PI_IILB_CMP_EXP_DATA1_DATA_SHFT    0
#define SH_XN_PI_IILB_CMP_EXP_DATA1_DATA_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_PI_IILB_CMP_ENABLE0"                 */
/*                    PI compare IILB input enable0                     */
/* ==================================================================== */

#define SH_XN_PI_IILB_CMP_ENABLE0                0x0000000150031320
#define SH_XN_PI_IILB_CMP_ENABLE0_MASK           0xffffffffffffffff
#define SH_XN_PI_IILB_CMP_ENABLE0_INIT           0x0000000000000000

/*   SH_XN_PI_IILB_CMP_ENABLE0_ENABLE                                   */
/*   Description:  Enable0                                              */
#define SH_XN_PI_IILB_CMP_ENABLE0_ENABLE_SHFT    0
#define SH_XN_PI_IILB_CMP_ENABLE0_ENABLE_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_PI_IILB_CMP_ENABLE1"                 */
/*                    PI compare IILB input enable1                     */
/* ==================================================================== */

#define SH_XN_PI_IILB_CMP_ENABLE1                0x0000000150031330
#define SH_XN_PI_IILB_CMP_ENABLE1_MASK           0xffffffffffffffff
#define SH_XN_PI_IILB_CMP_ENABLE1_INIT           0x0000000000000000

/*   SH_XN_PI_IILB_CMP_ENABLE1_ENABLE                                   */
/*   Description:  Enable1                                              */
#define SH_XN_PI_IILB_CMP_ENABLE1_ENABLE_SHFT    0
#define SH_XN_PI_IILB_CMP_ENABLE1_ENABLE_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_PI_NI0_CMP_EXP_DATA0"                 */
/*                 PI compare NI0 input expected data0                  */
/* ==================================================================== */

#define SH_XN_PI_NI0_CMP_EXP_DATA0               0x0000000150031340
#define SH_XN_PI_NI0_CMP_EXP_DATA0_MASK          0xffffffffffffffff
#define SH_XN_PI_NI0_CMP_EXP_DATA0_INIT          0x0000000000000000

/*   SH_XN_PI_NI0_CMP_EXP_DATA0_DATA                                    */
/*   Description:  Expected data 0                                      */
#define SH_XN_PI_NI0_CMP_EXP_DATA0_DATA_SHFT     0
#define SH_XN_PI_NI0_CMP_EXP_DATA0_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_PI_NI0_CMP_EXP_DATA1"                 */
/*                 PI compare NI0 input expected data1                  */
/* ==================================================================== */

#define SH_XN_PI_NI0_CMP_EXP_DATA1               0x0000000150031350
#define SH_XN_PI_NI0_CMP_EXP_DATA1_MASK          0xffffffffffffffff
#define SH_XN_PI_NI0_CMP_EXP_DATA1_INIT          0x0000000000000000

/*   SH_XN_PI_NI0_CMP_EXP_DATA1_DATA                                    */
/*   Description:  Expected data 1                                      */
#define SH_XN_PI_NI0_CMP_EXP_DATA1_DATA_SHFT     0
#define SH_XN_PI_NI0_CMP_EXP_DATA1_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_PI_NI0_CMP_ENABLE0"                  */
/*                     PI compare NI0 input enable0                     */
/* ==================================================================== */

#define SH_XN_PI_NI0_CMP_ENABLE0                 0x0000000150031360
#define SH_XN_PI_NI0_CMP_ENABLE0_MASK            0xffffffffffffffff
#define SH_XN_PI_NI0_CMP_ENABLE0_INIT            0x0000000000000000

/*   SH_XN_PI_NI0_CMP_ENABLE0_ENABLE                                    */
/*   Description:  Enable0                                              */
#define SH_XN_PI_NI0_CMP_ENABLE0_ENABLE_SHFT     0
#define SH_XN_PI_NI0_CMP_ENABLE0_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_PI_NI0_CMP_ENABLE1"                  */
/*                     PI compare NI0 input enable1                     */
/* ==================================================================== */

#define SH_XN_PI_NI0_CMP_ENABLE1                 0x0000000150031370
#define SH_XN_PI_NI0_CMP_ENABLE1_MASK            0xffffffffffffffff
#define SH_XN_PI_NI0_CMP_ENABLE1_INIT            0x0000000000000000

/*   SH_XN_PI_NI0_CMP_ENABLE1_ENABLE                                    */
/*   Description:  Enable1                                              */
#define SH_XN_PI_NI0_CMP_ENABLE1_ENABLE_SHFT     0
#define SH_XN_PI_NI0_CMP_ENABLE1_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_PI_NI1_CMP_EXP_DATA0"                 */
/*                 PI compare NI1 input expected data0                  */
/* ==================================================================== */

#define SH_XN_PI_NI1_CMP_EXP_DATA0               0x0000000150031380
#define SH_XN_PI_NI1_CMP_EXP_DATA0_MASK          0xffffffffffffffff
#define SH_XN_PI_NI1_CMP_EXP_DATA0_INIT          0x0000000000000000

/*   SH_XN_PI_NI1_CMP_EXP_DATA0_DATA                                    */
/*   Description:  Expected data 0                                      */
#define SH_XN_PI_NI1_CMP_EXP_DATA0_DATA_SHFT     0
#define SH_XN_PI_NI1_CMP_EXP_DATA0_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_PI_NI1_CMP_EXP_DATA1"                 */
/*                 PI compare NI1 input expected data1                  */
/* ==================================================================== */

#define SH_XN_PI_NI1_CMP_EXP_DATA1               0x0000000150031390
#define SH_XN_PI_NI1_CMP_EXP_DATA1_MASK          0xffffffffffffffff
#define SH_XN_PI_NI1_CMP_EXP_DATA1_INIT          0x0000000000000000

/*   SH_XN_PI_NI1_CMP_EXP_DATA1_DATA                                    */
/*   Description:  Expected data 1                                      */
#define SH_XN_PI_NI1_CMP_EXP_DATA1_DATA_SHFT     0
#define SH_XN_PI_NI1_CMP_EXP_DATA1_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_PI_NI1_CMP_ENABLE0"                  */
/*                     PI compare NI1 input enable0                     */
/* ==================================================================== */

#define SH_XN_PI_NI1_CMP_ENABLE0                 0x00000001500313a0
#define SH_XN_PI_NI1_CMP_ENABLE0_MASK            0xffffffffffffffff
#define SH_XN_PI_NI1_CMP_ENABLE0_INIT            0x0000000000000000

/*   SH_XN_PI_NI1_CMP_ENABLE0_ENABLE                                    */
/*   Description:  Enable0                                              */
#define SH_XN_PI_NI1_CMP_ENABLE0_ENABLE_SHFT     0
#define SH_XN_PI_NI1_CMP_ENABLE0_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_PI_NI1_CMP_ENABLE1"                  */
/*                     PI compare NI1 input enable1                     */
/* ==================================================================== */

#define SH_XN_PI_NI1_CMP_ENABLE1                 0x00000001500313b0
#define SH_XN_PI_NI1_CMP_ENABLE1_MASK            0xffffffffffffffff
#define SH_XN_PI_NI1_CMP_ENABLE1_INIT            0x0000000000000000

/*   SH_XN_PI_NI1_CMP_ENABLE1_ENABLE                                    */
/*   Description:  Enable1                                              */
#define SH_XN_PI_NI1_CMP_ENABLE1_ENABLE_SHFT     0
#define SH_XN_PI_NI1_CMP_ENABLE1_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_PI_SIC_CMP_EXP_HDR0"                 */
/*                PI compare SIC input expected header0                 */
/* ==================================================================== */

#define SH_XN_PI_SIC_CMP_EXP_HDR0                0x00000001500313c0
#define SH_XN_PI_SIC_CMP_EXP_HDR0_MASK           0xffffffffffffffff
#define SH_XN_PI_SIC_CMP_EXP_HDR0_INIT           0x0000000000000000

/*   SH_XN_PI_SIC_CMP_EXP_HDR0_DATA                                     */
/*   Description:  Expected data 0                                      */
#define SH_XN_PI_SIC_CMP_EXP_HDR0_DATA_SHFT      0
#define SH_XN_PI_SIC_CMP_EXP_HDR0_DATA_MASK      0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_PI_SIC_CMP_EXP_HDR1"                 */
/*                PI compare SIC input expected header1                 */
/* ==================================================================== */

#define SH_XN_PI_SIC_CMP_EXP_HDR1                0x00000001500313d0
#define SH_XN_PI_SIC_CMP_EXP_HDR1_MASK           0x000003ffffffffff
#define SH_XN_PI_SIC_CMP_EXP_HDR1_INIT           0x0000000000000000

/*   SH_XN_PI_SIC_CMP_EXP_HDR1_DATA                                     */
/*   Description:  Expected data 1                                      */
#define SH_XN_PI_SIC_CMP_EXP_HDR1_DATA_SHFT      0
#define SH_XN_PI_SIC_CMP_EXP_HDR1_DATA_MASK      0x000003ffffffffff

/* ==================================================================== */
/*               Register "SH_XN_PI_SIC_CMP_HDR_ENABLE0"                */
/*                    PI compare SIC header enable0                     */
/* ==================================================================== */

#define SH_XN_PI_SIC_CMP_HDR_ENABLE0             0x00000001500313e0
#define SH_XN_PI_SIC_CMP_HDR_ENABLE0_MASK        0xffffffffffffffff
#define SH_XN_PI_SIC_CMP_HDR_ENABLE0_INIT        0x0000000000000000

/*   SH_XN_PI_SIC_CMP_HDR_ENABLE0_ENABLE                                */
/*   Description:  Enable0                                              */
#define SH_XN_PI_SIC_CMP_HDR_ENABLE0_ENABLE_SHFT 0
#define SH_XN_PI_SIC_CMP_HDR_ENABLE0_ENABLE_MASK 0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_PI_SIC_CMP_HDR_ENABLE1"                */
/*                    PI compare SIC header enable1                     */
/* ==================================================================== */

#define SH_XN_PI_SIC_CMP_HDR_ENABLE1             0x00000001500313f0
#define SH_XN_PI_SIC_CMP_HDR_ENABLE1_MASK        0x000003ffffffffff
#define SH_XN_PI_SIC_CMP_HDR_ENABLE1_INIT        0x0000000000000000

/*   SH_XN_PI_SIC_CMP_HDR_ENABLE1_ENABLE                                */
/*   Description:  Enable1                                              */
#define SH_XN_PI_SIC_CMP_HDR_ENABLE1_ENABLE_SHFT 0
#define SH_XN_PI_SIC_CMP_HDR_ENABLE1_ENABLE_MASK 0x000003ffffffffff

/* ==================================================================== */
/*                  Register "SH_XN_PI_SIC_CMP_DATA0"                   */
/*                         PI compare SIC data0                         */
/* ==================================================================== */

#define SH_XN_PI_SIC_CMP_DATA0                   0x0000000150031400
#define SH_XN_PI_SIC_CMP_DATA0_MASK              0xffffffffffffffff
#define SH_XN_PI_SIC_CMP_DATA0_INIT              0x0000000000000000

/*   SH_XN_PI_SIC_CMP_DATA0_DATA0                                       */
/*   Description:  Data0                                                */
#define SH_XN_PI_SIC_CMP_DATA0_DATA0_SHFT        0
#define SH_XN_PI_SIC_CMP_DATA0_DATA0_MASK        0xffffffffffffffff

/* ==================================================================== */
/*                  Register "SH_XN_PI_SIC_CMP_DATA1"                   */
/*                         PI compare SIC data1                         */
/* ==================================================================== */

#define SH_XN_PI_SIC_CMP_DATA1                   0x0000000150031410
#define SH_XN_PI_SIC_CMP_DATA1_MASK              0xffffffffffffffff
#define SH_XN_PI_SIC_CMP_DATA1_INIT              0x0000000000000000

/*   SH_XN_PI_SIC_CMP_DATA1_DATA1                                       */
/*   Description:  Data1                                                */
#define SH_XN_PI_SIC_CMP_DATA1_DATA1_SHFT        0
#define SH_XN_PI_SIC_CMP_DATA1_DATA1_MASK        0xffffffffffffffff

/* ==================================================================== */
/*                  Register "SH_XN_PI_SIC_CMP_DATA2"                   */
/*                         PI compare SIC data2                         */
/* ==================================================================== */

#define SH_XN_PI_SIC_CMP_DATA2                   0x0000000150031420
#define SH_XN_PI_SIC_CMP_DATA2_MASK              0xffffffffffffffff
#define SH_XN_PI_SIC_CMP_DATA2_INIT              0x0000000000000000

/*   SH_XN_PI_SIC_CMP_DATA2_DATA2                                       */
/*   Description:  Data2                                                */
#define SH_XN_PI_SIC_CMP_DATA2_DATA2_SHFT        0
#define SH_XN_PI_SIC_CMP_DATA2_DATA2_MASK        0xffffffffffffffff

/* ==================================================================== */
/*                  Register "SH_XN_PI_SIC_CMP_DATA3"                   */
/*                         PI compare SIC data3                         */
/* ==================================================================== */

#define SH_XN_PI_SIC_CMP_DATA3                   0x0000000150031430
#define SH_XN_PI_SIC_CMP_DATA3_MASK              0xffffffffffffffff
#define SH_XN_PI_SIC_CMP_DATA3_INIT              0x0000000000000000

/*   SH_XN_PI_SIC_CMP_DATA3_DATA3                                       */
/*   Description:  Data3                                                */
#define SH_XN_PI_SIC_CMP_DATA3_DATA3_SHFT        0
#define SH_XN_PI_SIC_CMP_DATA3_DATA3_MASK        0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_PI_SIC_CMP_DATA_ENABLE0"               */
/*                     PI enable compare SIC data0                      */
/* ==================================================================== */

#define SH_XN_PI_SIC_CMP_DATA_ENABLE0            0x0000000150031440
#define SH_XN_PI_SIC_CMP_DATA_ENABLE0_MASK       0xffffffffffffffff
#define SH_XN_PI_SIC_CMP_DATA_ENABLE0_INIT       0x0000000000000000

/*   SH_XN_PI_SIC_CMP_DATA_ENABLE0_DATA_ENABLE0                         */
/*   Description:  Data0                                                */
#define SH_XN_PI_SIC_CMP_DATA_ENABLE0_DATA_ENABLE0_SHFT 0
#define SH_XN_PI_SIC_CMP_DATA_ENABLE0_DATA_ENABLE0_MASK 0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_PI_SIC_CMP_DATA_ENABLE1"               */
/*                     PI enable compare SIC data1                      */
/* ==================================================================== */

#define SH_XN_PI_SIC_CMP_DATA_ENABLE1            0x0000000150031450
#define SH_XN_PI_SIC_CMP_DATA_ENABLE1_MASK       0xffffffffffffffff
#define SH_XN_PI_SIC_CMP_DATA_ENABLE1_INIT       0x0000000000000000

/*   SH_XN_PI_SIC_CMP_DATA_ENABLE1_DATA_ENABLE1                         */
/*   Description:  Data1                                                */
#define SH_XN_PI_SIC_CMP_DATA_ENABLE1_DATA_ENABLE1_SHFT 0
#define SH_XN_PI_SIC_CMP_DATA_ENABLE1_DATA_ENABLE1_MASK 0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_PI_SIC_CMP_DATA_ENABLE2"               */
/*                     PI enable compare SIC data2                      */
/* ==================================================================== */

#define SH_XN_PI_SIC_CMP_DATA_ENABLE2            0x0000000150031460
#define SH_XN_PI_SIC_CMP_DATA_ENABLE2_MASK       0xffffffffffffffff
#define SH_XN_PI_SIC_CMP_DATA_ENABLE2_INIT       0x0000000000000000

/*   SH_XN_PI_SIC_CMP_DATA_ENABLE2_DATA_ENABLE2                         */
/*   Description:  Data2                                                */
#define SH_XN_PI_SIC_CMP_DATA_ENABLE2_DATA_ENABLE2_SHFT 0
#define SH_XN_PI_SIC_CMP_DATA_ENABLE2_DATA_ENABLE2_MASK 0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_PI_SIC_CMP_DATA_ENABLE3"               */
/*                     PI enable compare SIC data3                      */
/* ==================================================================== */

#define SH_XN_PI_SIC_CMP_DATA_ENABLE3            0x0000000150031470
#define SH_XN_PI_SIC_CMP_DATA_ENABLE3_MASK       0xffffffffffffffff
#define SH_XN_PI_SIC_CMP_DATA_ENABLE3_INIT       0x0000000000000000

/*   SH_XN_PI_SIC_CMP_DATA_ENABLE3_DATA_ENABLE3                         */
/*   Description:  Data3                                                */
#define SH_XN_PI_SIC_CMP_DATA_ENABLE3_DATA_ENABLE3_SHFT 0
#define SH_XN_PI_SIC_CMP_DATA_ENABLE3_DATA_ENABLE3_MASK 0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_NI0_IILB_CMP_EXP_DATA0"                */
/*                NI0 compare IILB input expected data0                 */
/* ==================================================================== */

#define SH_XN_NI0_IILB_CMP_EXP_DATA0             0x0000000150031700
#define SH_XN_NI0_IILB_CMP_EXP_DATA0_MASK        0xffffffffffffffff
#define SH_XN_NI0_IILB_CMP_EXP_DATA0_INIT        0x0000000000000000

/*   SH_XN_NI0_IILB_CMP_EXP_DATA0_DATA                                  */
/*   Description:  Expected data 0                                      */
#define SH_XN_NI0_IILB_CMP_EXP_DATA0_DATA_SHFT   0
#define SH_XN_NI0_IILB_CMP_EXP_DATA0_DATA_MASK   0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_NI0_IILB_CMP_EXP_DATA1"                */
/*                NI0 compare IILB input expected data1                 */
/* ==================================================================== */

#define SH_XN_NI0_IILB_CMP_EXP_DATA1             0x0000000150031710
#define SH_XN_NI0_IILB_CMP_EXP_DATA1_MASK        0xffffffffffffffff
#define SH_XN_NI0_IILB_CMP_EXP_DATA1_INIT        0x0000000000000000

/*   SH_XN_NI0_IILB_CMP_EXP_DATA1_DATA                                  */
/*   Description:  Expected data 1                                      */
#define SH_XN_NI0_IILB_CMP_EXP_DATA1_DATA_SHFT   0
#define SH_XN_NI0_IILB_CMP_EXP_DATA1_DATA_MASK   0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI0_IILB_CMP_ENABLE0"                 */
/*                    NI0 compare IILB input enable0                    */
/* ==================================================================== */

#define SH_XN_NI0_IILB_CMP_ENABLE0               0x0000000150031720
#define SH_XN_NI0_IILB_CMP_ENABLE0_MASK          0xffffffffffffffff
#define SH_XN_NI0_IILB_CMP_ENABLE0_INIT          0x0000000000000000

/*   SH_XN_NI0_IILB_CMP_ENABLE0_ENABLE                                  */
/*   Description:  Enable0                                              */
#define SH_XN_NI0_IILB_CMP_ENABLE0_ENABLE_SHFT   0
#define SH_XN_NI0_IILB_CMP_ENABLE0_ENABLE_MASK   0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI0_IILB_CMP_ENABLE1"                 */
/*                    NI0 compare IILB input enable1                    */
/* ==================================================================== */

#define SH_XN_NI0_IILB_CMP_ENABLE1               0x0000000150031730
#define SH_XN_NI0_IILB_CMP_ENABLE1_MASK          0xffffffffffffffff
#define SH_XN_NI0_IILB_CMP_ENABLE1_INIT          0x0000000000000000

/*   SH_XN_NI0_IILB_CMP_ENABLE1_ENABLE                                  */
/*   Description:  Enable1                                              */
#define SH_XN_NI0_IILB_CMP_ENABLE1_ENABLE_SHFT   0
#define SH_XN_NI0_IILB_CMP_ENABLE1_ENABLE_MASK   0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI0_PI_CMP_EXP_DATA0"                 */
/*                 NI0 compare PI input expected data0                  */
/* ==================================================================== */

#define SH_XN_NI0_PI_CMP_EXP_DATA0               0x0000000150031740
#define SH_XN_NI0_PI_CMP_EXP_DATA0_MASK          0xffffffffffffffff
#define SH_XN_NI0_PI_CMP_EXP_DATA0_INIT          0x0000000000000000

/*   SH_XN_NI0_PI_CMP_EXP_DATA0_DATA                                    */
/*   Description:  Expected data 0                                      */
#define SH_XN_NI0_PI_CMP_EXP_DATA0_DATA_SHFT     0
#define SH_XN_NI0_PI_CMP_EXP_DATA0_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI0_PI_CMP_EXP_DATA1"                 */
/*                 NI0 compare PI input expected data1                  */
/* ==================================================================== */

#define SH_XN_NI0_PI_CMP_EXP_DATA1               0x0000000150031750
#define SH_XN_NI0_PI_CMP_EXP_DATA1_MASK          0xffffffffffffffff
#define SH_XN_NI0_PI_CMP_EXP_DATA1_INIT          0x0000000000000000

/*   SH_XN_NI0_PI_CMP_EXP_DATA1_DATA                                    */
/*   Description:  Expected data 1                                      */
#define SH_XN_NI0_PI_CMP_EXP_DATA1_DATA_SHFT     0
#define SH_XN_NI0_PI_CMP_EXP_DATA1_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_NI0_PI_CMP_ENABLE0"                  */
/*                     NI0 compare PI input enable0                     */
/* ==================================================================== */

#define SH_XN_NI0_PI_CMP_ENABLE0                 0x0000000150031760
#define SH_XN_NI0_PI_CMP_ENABLE0_MASK            0xffffffffffffffff
#define SH_XN_NI0_PI_CMP_ENABLE0_INIT            0x0000000000000000

/*   SH_XN_NI0_PI_CMP_ENABLE0_ENABLE                                    */
/*   Description:  Enable0                                              */
#define SH_XN_NI0_PI_CMP_ENABLE0_ENABLE_SHFT     0
#define SH_XN_NI0_PI_CMP_ENABLE0_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_NI0_PI_CMP_ENABLE1"                  */
/*                     NI0 compare PI input enable1                     */
/* ==================================================================== */

#define SH_XN_NI0_PI_CMP_ENABLE1                 0x0000000150031770
#define SH_XN_NI0_PI_CMP_ENABLE1_MASK            0xffffffffffffffff
#define SH_XN_NI0_PI_CMP_ENABLE1_INIT            0x0000000000000000

/*   SH_XN_NI0_PI_CMP_ENABLE1_ENABLE                                    */
/*   Description:  Enable1                                              */
#define SH_XN_NI0_PI_CMP_ENABLE1_ENABLE_SHFT     0
#define SH_XN_NI0_PI_CMP_ENABLE1_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI0_MD_CMP_EXP_DATA0"                 */
/*                 NI0 compare MD input expected data0                  */
/* ==================================================================== */

#define SH_XN_NI0_MD_CMP_EXP_DATA0               0x0000000150031780
#define SH_XN_NI0_MD_CMP_EXP_DATA0_MASK          0xffffffffffffffff
#define SH_XN_NI0_MD_CMP_EXP_DATA0_INIT          0x0000000000000000

/*   SH_XN_NI0_MD_CMP_EXP_DATA0_DATA                                    */
/*   Description:  Expected data 0                                      */
#define SH_XN_NI0_MD_CMP_EXP_DATA0_DATA_SHFT     0
#define SH_XN_NI0_MD_CMP_EXP_DATA0_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI0_MD_CMP_EXP_DATA1"                 */
/*                 NI0 compare MD input expected data1                  */
/* ==================================================================== */

#define SH_XN_NI0_MD_CMP_EXP_DATA1               0x0000000150031790
#define SH_XN_NI0_MD_CMP_EXP_DATA1_MASK          0xffffffffffffffff
#define SH_XN_NI0_MD_CMP_EXP_DATA1_INIT          0x0000000000000000

/*   SH_XN_NI0_MD_CMP_EXP_DATA1_DATA                                    */
/*   Description:  Expected data 1                                      */
#define SH_XN_NI0_MD_CMP_EXP_DATA1_DATA_SHFT     0
#define SH_XN_NI0_MD_CMP_EXP_DATA1_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_NI0_MD_CMP_ENABLE0"                  */
/*                     NI0 compare MD input enable0                     */
/* ==================================================================== */

#define SH_XN_NI0_MD_CMP_ENABLE0                 0x00000001500317a0
#define SH_XN_NI0_MD_CMP_ENABLE0_MASK            0xffffffffffffffff
#define SH_XN_NI0_MD_CMP_ENABLE0_INIT            0x0000000000000000

/*   SH_XN_NI0_MD_CMP_ENABLE0_ENABLE                                    */
/*   Description:  Enable0                                              */
#define SH_XN_NI0_MD_CMP_ENABLE0_ENABLE_SHFT     0
#define SH_XN_NI0_MD_CMP_ENABLE0_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_NI0_MD_CMP_ENABLE1"                  */
/*                     NI0 compare MD input enable1                     */
/* ==================================================================== */

#define SH_XN_NI0_MD_CMP_ENABLE1                 0x00000001500317b0
#define SH_XN_NI0_MD_CMP_ENABLE1_MASK            0xffffffffffffffff
#define SH_XN_NI0_MD_CMP_ENABLE1_INIT            0x0000000000000000

/*   SH_XN_NI0_MD_CMP_ENABLE1_ENABLE                                    */
/*   Description:  Enable1                                              */
#define SH_XN_NI0_MD_CMP_ENABLE1_ENABLE_SHFT     0
#define SH_XN_NI0_MD_CMP_ENABLE1_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI0_NI_CMP_EXP_DATA0"                 */
/*                 NI0 compare NI input expected data0                  */
/* ==================================================================== */

#define SH_XN_NI0_NI_CMP_EXP_DATA0               0x00000001500317c0
#define SH_XN_NI0_NI_CMP_EXP_DATA0_MASK          0xffffffffffffffff
#define SH_XN_NI0_NI_CMP_EXP_DATA0_INIT          0x0000000000000000

/*   SH_XN_NI0_NI_CMP_EXP_DATA0_DATA                                    */
/*   Description:  Expected data 0                                      */
#define SH_XN_NI0_NI_CMP_EXP_DATA0_DATA_SHFT     0
#define SH_XN_NI0_NI_CMP_EXP_DATA0_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI0_NI_CMP_EXP_DATA1"                 */
/*                 NI0 compare NI input expected data1                  */
/* ==================================================================== */

#define SH_XN_NI0_NI_CMP_EXP_DATA1               0x00000001500317d0
#define SH_XN_NI0_NI_CMP_EXP_DATA1_MASK          0xffffffffffffffff
#define SH_XN_NI0_NI_CMP_EXP_DATA1_INIT          0x0000000000000000

/*   SH_XN_NI0_NI_CMP_EXP_DATA1_DATA                                    */
/*   Description:  Expected data 1                                      */
#define SH_XN_NI0_NI_CMP_EXP_DATA1_DATA_SHFT     0
#define SH_XN_NI0_NI_CMP_EXP_DATA1_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_NI0_NI_CMP_ENABLE0"                  */
/*                     NI0 compare NI input enable0                     */
/* ==================================================================== */

#define SH_XN_NI0_NI_CMP_ENABLE0                 0x00000001500317e0
#define SH_XN_NI0_NI_CMP_ENABLE0_MASK            0xffffffffffffffff
#define SH_XN_NI0_NI_CMP_ENABLE0_INIT            0x0000000000000000

/*   SH_XN_NI0_NI_CMP_ENABLE0_ENABLE                                    */
/*   Description:  Enable0                                              */
#define SH_XN_NI0_NI_CMP_ENABLE0_ENABLE_SHFT     0
#define SH_XN_NI0_NI_CMP_ENABLE0_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_NI0_NI_CMP_ENABLE1"                  */
/*                     NI0 compare NI input enable1                     */
/* ==================================================================== */

#define SH_XN_NI0_NI_CMP_ENABLE1                 0x00000001500317f0
#define SH_XN_NI0_NI_CMP_ENABLE1_MASK            0xffffffffffffffff
#define SH_XN_NI0_NI_CMP_ENABLE1_INIT            0x0000000000000000

/*   SH_XN_NI0_NI_CMP_ENABLE1_ENABLE                                    */
/*   Description:  Enable1                                              */
#define SH_XN_NI0_NI_CMP_ENABLE1_ENABLE_SHFT     0
#define SH_XN_NI0_NI_CMP_ENABLE1_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI0_LLP_CMP_EXP_DATA0"                */
/*                 NI0 compare LLP input expected data0                 */
/* ==================================================================== */

#define SH_XN_NI0_LLP_CMP_EXP_DATA0              0x0000000150031800
#define SH_XN_NI0_LLP_CMP_EXP_DATA0_MASK         0xffffffffffffffff
#define SH_XN_NI0_LLP_CMP_EXP_DATA0_INIT         0x0000000000000000

/*   SH_XN_NI0_LLP_CMP_EXP_DATA0_DATA                                   */
/*   Description:  Expected data 0                                      */
#define SH_XN_NI0_LLP_CMP_EXP_DATA0_DATA_SHFT    0
#define SH_XN_NI0_LLP_CMP_EXP_DATA0_DATA_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI0_LLP_CMP_EXP_DATA1"                */
/*                 NI0 compare LLP input expected data1                 */
/* ==================================================================== */

#define SH_XN_NI0_LLP_CMP_EXP_DATA1              0x0000000150031810
#define SH_XN_NI0_LLP_CMP_EXP_DATA1_MASK         0xffffffffffffffff
#define SH_XN_NI0_LLP_CMP_EXP_DATA1_INIT         0x0000000000000000

/*   SH_XN_NI0_LLP_CMP_EXP_DATA1_DATA                                   */
/*   Description:  Expected data 1                                      */
#define SH_XN_NI0_LLP_CMP_EXP_DATA1_DATA_SHFT    0
#define SH_XN_NI0_LLP_CMP_EXP_DATA1_DATA_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_NI0_LLP_CMP_ENABLE0"                 */
/*                    NI0 compare LLP input enable0                     */
/* ==================================================================== */

#define SH_XN_NI0_LLP_CMP_ENABLE0                0x0000000150031820
#define SH_XN_NI0_LLP_CMP_ENABLE0_MASK           0xffffffffffffffff
#define SH_XN_NI0_LLP_CMP_ENABLE0_INIT           0x0000000000000000

/*   SH_XN_NI0_LLP_CMP_ENABLE0_ENABLE                                   */
/*   Description:  Enable0                                              */
#define SH_XN_NI0_LLP_CMP_ENABLE0_ENABLE_SHFT    0
#define SH_XN_NI0_LLP_CMP_ENABLE0_ENABLE_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_NI0_LLP_CMP_ENABLE1"                 */
/*                    NI0 compare LLP input enable1                     */
/* ==================================================================== */

#define SH_XN_NI0_LLP_CMP_ENABLE1                0x0000000150031830
#define SH_XN_NI0_LLP_CMP_ENABLE1_MASK           0xffffffffffffffff
#define SH_XN_NI0_LLP_CMP_ENABLE1_INIT           0x0000000000000000

/*   SH_XN_NI0_LLP_CMP_ENABLE1_ENABLE                                   */
/*   Description:  Enable1                                              */
#define SH_XN_NI0_LLP_CMP_ENABLE1_ENABLE_SHFT    0
#define SH_XN_NI0_LLP_CMP_ENABLE1_ENABLE_MASK    0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_NI1_IILB_CMP_EXP_DATA0"                */
/*                NI1 compare IILB input expected data0                 */
/* ==================================================================== */

#define SH_XN_NI1_IILB_CMP_EXP_DATA0             0x0000000150031900
#define SH_XN_NI1_IILB_CMP_EXP_DATA0_MASK        0xffffffffffffffff
#define SH_XN_NI1_IILB_CMP_EXP_DATA0_INIT        0x0000000000000000

/*   SH_XN_NI1_IILB_CMP_EXP_DATA0_DATA                                  */
/*   Description:  Expected data 0                                      */
#define SH_XN_NI1_IILB_CMP_EXP_DATA0_DATA_SHFT   0
#define SH_XN_NI1_IILB_CMP_EXP_DATA0_DATA_MASK   0xffffffffffffffff

/* ==================================================================== */
/*               Register "SH_XN_NI1_IILB_CMP_EXP_DATA1"                */
/*                NI1 compare IILB input expected data1                 */
/* ==================================================================== */

#define SH_XN_NI1_IILB_CMP_EXP_DATA1             0x0000000150031910
#define SH_XN_NI1_IILB_CMP_EXP_DATA1_MASK        0xffffffffffffffff
#define SH_XN_NI1_IILB_CMP_EXP_DATA1_INIT        0x0000000000000000

/*   SH_XN_NI1_IILB_CMP_EXP_DATA1_DATA                                  */
/*   Description:  Expected data 1                                      */
#define SH_XN_NI1_IILB_CMP_EXP_DATA1_DATA_SHFT   0
#define SH_XN_NI1_IILB_CMP_EXP_DATA1_DATA_MASK   0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI1_IILB_CMP_ENABLE0"                 */
/*                    NI1 compare IILB input enable0                    */
/* ==================================================================== */

#define SH_XN_NI1_IILB_CMP_ENABLE0               0x0000000150031920
#define SH_XN_NI1_IILB_CMP_ENABLE0_MASK          0xffffffffffffffff
#define SH_XN_NI1_IILB_CMP_ENABLE0_INIT          0x0000000000000000

/*   SH_XN_NI1_IILB_CMP_ENABLE0_ENABLE                                  */
/*   Description:  Enable0                                              */
#define SH_XN_NI1_IILB_CMP_ENABLE0_ENABLE_SHFT   0
#define SH_XN_NI1_IILB_CMP_ENABLE0_ENABLE_MASK   0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI1_IILB_CMP_ENABLE1"                 */
/*                    NI1 compare IILB input enable1                    */
/* ==================================================================== */

#define SH_XN_NI1_IILB_CMP_ENABLE1               0x0000000150031930
#define SH_XN_NI1_IILB_CMP_ENABLE1_MASK          0xffffffffffffffff
#define SH_XN_NI1_IILB_CMP_ENABLE1_INIT          0x0000000000000000

/*   SH_XN_NI1_IILB_CMP_ENABLE1_ENABLE                                  */
/*   Description:  Enable1                                              */
#define SH_XN_NI1_IILB_CMP_ENABLE1_ENABLE_SHFT   0
#define SH_XN_NI1_IILB_CMP_ENABLE1_ENABLE_MASK   0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI1_PI_CMP_EXP_DATA0"                 */
/*                 NI1 compare PI input expected data0                  */
/* ==================================================================== */

#define SH_XN_NI1_PI_CMP_EXP_DATA0               0x0000000150031940
#define SH_XN_NI1_PI_CMP_EXP_DATA0_MASK          0xffffffffffffffff
#define SH_XN_NI1_PI_CMP_EXP_DATA0_INIT          0x0000000000000000

/*   SH_XN_NI1_PI_CMP_EXP_DATA0_DATA                                    */
/*   Description:  Expected data 0                                      */
#define SH_XN_NI1_PI_CMP_EXP_DATA0_DATA_SHFT     0
#define SH_XN_NI1_PI_CMP_EXP_DATA0_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI1_PI_CMP_EXP_DATA1"                 */
/*                 NI1 compare PI input expected data1                  */
/* ==================================================================== */

#define SH_XN_NI1_PI_CMP_EXP_DATA1               0x0000000150031950
#define SH_XN_NI1_PI_CMP_EXP_DATA1_MASK          0xffffffffffffffff
#define SH_XN_NI1_PI_CMP_EXP_DATA1_INIT          0x0000000000000000

/*   SH_XN_NI1_PI_CMP_EXP_DATA1_DATA                                    */
/*   Description:  Expected data 1                                      */
#define SH_XN_NI1_PI_CMP_EXP_DATA1_DATA_SHFT     0
#define SH_XN_NI1_PI_CMP_EXP_DATA1_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_NI1_PI_CMP_ENABLE0"                  */
/*                     NI1 compare PI input enable0                     */
/* ==================================================================== */

#define SH_XN_NI1_PI_CMP_ENABLE0                 0x0000000150031960
#define SH_XN_NI1_PI_CMP_ENABLE0_MASK            0xffffffffffffffff
#define SH_XN_NI1_PI_CMP_ENABLE0_INIT            0x0000000000000000

/*   SH_XN_NI1_PI_CMP_ENABLE0_ENABLE                                    */
/*   Description:  Enable0                                              */
#define SH_XN_NI1_PI_CMP_ENABLE0_ENABLE_SHFT     0
#define SH_XN_NI1_PI_CMP_ENABLE0_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_NI1_PI_CMP_ENABLE1"                  */
/*                     NI1 compare PI input enable1                     */
/* ==================================================================== */

#define SH_XN_NI1_PI_CMP_ENABLE1                 0x0000000150031970
#define SH_XN_NI1_PI_CMP_ENABLE1_MASK            0xffffffffffffffff
#define SH_XN_NI1_PI_CMP_ENABLE1_INIT            0x0000000000000000

/*   SH_XN_NI1_PI_CMP_ENABLE1_ENABLE                                    */
/*   Description:  Enable1                                              */
#define SH_XN_NI1_PI_CMP_ENABLE1_ENABLE_SHFT     0
#define SH_XN_NI1_PI_CMP_ENABLE1_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI1_MD_CMP_EXP_DATA0"                 */
/*                 NI1 compare MD input expected data0                  */
/* ==================================================================== */

#define SH_XN_NI1_MD_CMP_EXP_DATA0               0x0000000150031980
#define SH_XN_NI1_MD_CMP_EXP_DATA0_MASK          0xffffffffffffffff
#define SH_XN_NI1_MD_CMP_EXP_DATA0_INIT          0x0000000000000000

/*   SH_XN_NI1_MD_CMP_EXP_DATA0_DATA                                    */
/*   Description:  Expected data 0                                      */
#define SH_XN_NI1_MD_CMP_EXP_DATA0_DATA_SHFT     0
#define SH_XN_NI1_MD_CMP_EXP_DATA0_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI1_MD_CMP_EXP_DATA1"                 */
/*                 NI1 compare MD input expected data1                  */
/* ==================================================================== */

#define SH_XN_NI1_MD_CMP_EXP_DATA1               0x0000000150031990
#define SH_XN_NI1_MD_CMP_EXP_DATA1_MASK          0xffffffffffffffff
#define SH_XN_NI1_MD_CMP_EXP_DATA1_INIT          0x0000000000000000

/*   SH_XN_NI1_MD_CMP_EXP_DATA1_DATA                                    */
/*   Description:  Expected data 1                                      */
#define SH_XN_NI1_MD_CMP_EXP_DATA1_DATA_SHFT     0
#define SH_XN_NI1_MD_CMP_EXP_DATA1_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_NI1_MD_CMP_ENABLE0"                  */
/*                     NI1 compare MD input enable0                     */
/* ==================================================================== */

#define SH_XN_NI1_MD_CMP_ENABLE0                 0x00000001500319a0
#define SH_XN_NI1_MD_CMP_ENABLE0_MASK            0xffffffffffffffff
#define SH_XN_NI1_MD_CMP_ENABLE0_INIT            0x0000000000000000

/*   SH_XN_NI1_MD_CMP_ENABLE0_ENABLE                                    */
/*   Description:  Enable0                                              */
#define SH_XN_NI1_MD_CMP_ENABLE0_ENABLE_SHFT     0
#define SH_XN_NI1_MD_CMP_ENABLE0_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_NI1_MD_CMP_ENABLE1"                  */
/*                     NI1 compare MD input enable1                     */
/* ==================================================================== */

#define SH_XN_NI1_MD_CMP_ENABLE1                 0x00000001500319b0
#define SH_XN_NI1_MD_CMP_ENABLE1_MASK            0xffffffffffffffff
#define SH_XN_NI1_MD_CMP_ENABLE1_INIT            0x0000000000000000

/*   SH_XN_NI1_MD_CMP_ENABLE1_ENABLE                                    */
/*   Description:  Enable1                                              */
#define SH_XN_NI1_MD_CMP_ENABLE1_ENABLE_SHFT     0
#define SH_XN_NI1_MD_CMP_ENABLE1_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI1_NI_CMP_EXP_DATA0"                 */
/*                 NI1 compare NI input expected data0                  */
/* ==================================================================== */

#define SH_XN_NI1_NI_CMP_EXP_DATA0               0x00000001500319c0
#define SH_XN_NI1_NI_CMP_EXP_DATA0_MASK          0xffffffffffffffff
#define SH_XN_NI1_NI_CMP_EXP_DATA0_INIT          0x0000000000000000

/*   SH_XN_NI1_NI_CMP_EXP_DATA0_DATA                                    */
/*   Description:  Expected data 0                                      */
#define SH_XN_NI1_NI_CMP_EXP_DATA0_DATA_SHFT     0
#define SH_XN_NI1_NI_CMP_EXP_DATA0_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI1_NI_CMP_EXP_DATA1"                 */
/*                 NI1 compare NI input expected data1                  */
/* ==================================================================== */

#define SH_XN_NI1_NI_CMP_EXP_DATA1               0x00000001500319d0
#define SH_XN_NI1_NI_CMP_EXP_DATA1_MASK          0xffffffffffffffff
#define SH_XN_NI1_NI_CMP_EXP_DATA1_INIT          0x0000000000000000

/*   SH_XN_NI1_NI_CMP_EXP_DATA1_DATA                                    */
/*   Description:  Expected data 1                                      */
#define SH_XN_NI1_NI_CMP_EXP_DATA1_DATA_SHFT     0
#define SH_XN_NI1_NI_CMP_EXP_DATA1_DATA_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_NI1_NI_CMP_ENABLE0"                  */
/*                     NI1 compare NI input enable0                     */
/* ==================================================================== */

#define SH_XN_NI1_NI_CMP_ENABLE0                 0x00000001500319e0
#define SH_XN_NI1_NI_CMP_ENABLE0_MASK            0xffffffffffffffff
#define SH_XN_NI1_NI_CMP_ENABLE0_INIT            0x0000000000000000

/*   SH_XN_NI1_NI_CMP_ENABLE0_ENABLE                                    */
/*   Description:  Enable0                                              */
#define SH_XN_NI1_NI_CMP_ENABLE0_ENABLE_SHFT     0
#define SH_XN_NI1_NI_CMP_ENABLE0_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_NI1_NI_CMP_ENABLE1"                  */
/*                     NI1 compare NI input enable1                     */
/* ==================================================================== */

#define SH_XN_NI1_NI_CMP_ENABLE1                 0x00000001500319f0
#define SH_XN_NI1_NI_CMP_ENABLE1_MASK            0xffffffffffffffff
#define SH_XN_NI1_NI_CMP_ENABLE1_INIT            0x0000000000000000

/*   SH_XN_NI1_NI_CMP_ENABLE1_ENABLE                                    */
/*   Description:  Enable1                                              */
#define SH_XN_NI1_NI_CMP_ENABLE1_ENABLE_SHFT     0
#define SH_XN_NI1_NI_CMP_ENABLE1_ENABLE_MASK     0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI1_LLP_CMP_EXP_DATA0"                */
/*                 NI1 compare LLP input expected data0                 */
/* ==================================================================== */

#define SH_XN_NI1_LLP_CMP_EXP_DATA0              0x0000000150031a00
#define SH_XN_NI1_LLP_CMP_EXP_DATA0_MASK         0xffffffffffffffff
#define SH_XN_NI1_LLP_CMP_EXP_DATA0_INIT         0x0000000000000000

/*   SH_XN_NI1_LLP_CMP_EXP_DATA0_DATA                                   */
/*   Description:  Expected data 0                                      */
#define SH_XN_NI1_LLP_CMP_EXP_DATA0_DATA_SHFT    0
#define SH_XN_NI1_LLP_CMP_EXP_DATA0_DATA_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                Register "SH_XN_NI1_LLP_CMP_EXP_DATA1"                */
/*                 NI1 compare LLP input expected data1                 */
/* ==================================================================== */

#define SH_XN_NI1_LLP_CMP_EXP_DATA1              0x0000000150031a10
#define SH_XN_NI1_LLP_CMP_EXP_DATA1_MASK         0xffffffffffffffff
#define SH_XN_NI1_LLP_CMP_EXP_DATA1_INIT         0x0000000000000000

/*   SH_XN_NI1_LLP_CMP_EXP_DATA1_DATA                                   */
/*   Description:  Expected data 1                                      */
#define SH_XN_NI1_LLP_CMP_EXP_DATA1_DATA_SHFT    0
#define SH_XN_NI1_LLP_CMP_EXP_DATA1_DATA_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_NI1_LLP_CMP_ENABLE0"                 */
/*                    NI1 compare LLP input enable0                     */
/* ==================================================================== */

#define SH_XN_NI1_LLP_CMP_ENABLE0                0x0000000150031a20
#define SH_XN_NI1_LLP_CMP_ENABLE0_MASK           0xffffffffffffffff
#define SH_XN_NI1_LLP_CMP_ENABLE0_INIT           0x0000000000000000

/*   SH_XN_NI1_LLP_CMP_ENABLE0_ENABLE                                   */
/*   Description:  Enable0                                              */
#define SH_XN_NI1_LLP_CMP_ENABLE0_ENABLE_SHFT    0
#define SH_XN_NI1_LLP_CMP_ENABLE0_ENABLE_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XN_NI1_LLP_CMP_ENABLE1"                 */
/*                    NI1 compare LLP input enable1                     */
/* ==================================================================== */

#define SH_XN_NI1_LLP_CMP_ENABLE1                0x0000000150031a30
#define SH_XN_NI1_LLP_CMP_ENABLE1_MASK           0xffffffffffffffff
#define SH_XN_NI1_LLP_CMP_ENABLE1_INIT           0x0000000000000000

/*   SH_XN_NI1_LLP_CMP_ENABLE1_ENABLE                                   */
/*   Description:  Enable1                                              */
#define SH_XN_NI1_LLP_CMP_ENABLE1_ENABLE_SHFT    0
#define SH_XN_NI1_LLP_CMP_ENABLE1_ENABLE_MASK    0xffffffffffffffff

/* ==================================================================== */
/*                    Register "SH_XNPI_ECC_INJ_REG"                    */
/* ==================================================================== */

#define SH_XNPI_ECC_INJ_REG                      0x0000000150032000
#define SH_XNPI_ECC_INJ_REG_MASK                 0xf0fff0fff0fff0ff
#define SH_XNPI_ECC_INJ_REG_INIT                 0x0000000000000000

/*   SH_XNPI_ECC_INJ_REG_BYTE0                                          */
/*   Description:  Replacement Checkbyte                                */
#define SH_XNPI_ECC_INJ_REG_BYTE0_SHFT           0
#define SH_XNPI_ECC_INJ_REG_BYTE0_MASK           0x00000000000000ff

/*   SH_XNPI_ECC_INJ_REG_DATA_1SHOT0                                    */
/*   Description:  1 shot mask data                                     */
#define SH_XNPI_ECC_INJ_REG_DATA_1SHOT0_SHFT     12
#define SH_XNPI_ECC_INJ_REG_DATA_1SHOT0_MASK     0x0000000000001000

/*   SH_XNPI_ECC_INJ_REG_DATA_CONT0                                     */
/*   Description:  toggle mask data                                     */
#define SH_XNPI_ECC_INJ_REG_DATA_CONT0_SHFT      13
#define SH_XNPI_ECC_INJ_REG_DATA_CONT0_MASK      0x0000000000002000

/*   SH_XNPI_ECC_INJ_REG_DATA_CB_1SHOT0                                 */
/*   Description:  Replace Checkbyte One Shot                           */
#define SH_XNPI_ECC_INJ_REG_DATA_CB_1SHOT0_SHFT  14
#define SH_XNPI_ECC_INJ_REG_DATA_CB_1SHOT0_MASK  0x0000000000004000

/*   SH_XNPI_ECC_INJ_REG_DATA_CB_CONT0                                  */
/*   Description:  Replace Checkbyte Continuous                         */
#define SH_XNPI_ECC_INJ_REG_DATA_CB_CONT0_SHFT   15
#define SH_XNPI_ECC_INJ_REG_DATA_CB_CONT0_MASK   0x0000000000008000

/*   SH_XNPI_ECC_INJ_REG_BYTE1                                          */
/*   Description:  Replacement Checkbyte                                */
#define SH_XNPI_ECC_INJ_REG_BYTE1_SHFT           16
#define SH_XNPI_ECC_INJ_REG_BYTE1_MASK           0x0000000000ff0000

/*   SH_XNPI_ECC_INJ_REG_DATA_1SHOT1                                    */
/*   Description:  1 shot mask data                                     */
#define SH_XNPI_ECC_INJ_REG_DATA_1SHOT1_SHFT     28
#define SH_XNPI_ECC_INJ_REG_DATA_1SHOT1_MASK     0x0000000010000000

/*   SH_XNPI_ECC_INJ_REG_DATA_CONT1                                     */
/*   Description:  toggle mask data                                     */
#define SH_XNPI_ECC_INJ_REG_DATA_CONT1_SHFT      29
#define SH_XNPI_ECC_INJ_REG_DATA_CONT1_MASK      0x0000000020000000

/*   SH_XNPI_ECC_INJ_REG_DATA_CB_1SHOT1                                 */
/*   Description:  Replace Checkbyte One Shot                           */
#define SH_XNPI_ECC_INJ_REG_DATA_CB_1SHOT1_SHFT  30
#define SH_XNPI_ECC_INJ_REG_DATA_CB_1SHOT1_MASK  0x0000000040000000

/*   SH_XNPI_ECC_INJ_REG_DATA_CB_CONT1                                  */
/*   Description:  Replace Checkbyte Continous                          */
#define SH_XNPI_ECC_INJ_REG_DATA_CB_CONT1_SHFT   31
#define SH_XNPI_ECC_INJ_REG_DATA_CB_CONT1_MASK   0x0000000080000000

/*   SH_XNPI_ECC_INJ_REG_BYTE2                                          */
/*   Description:  Replacement Checkbyte                                */
#define SH_XNPI_ECC_INJ_REG_BYTE2_SHFT           32
#define SH_XNPI_ECC_INJ_REG_BYTE2_MASK           0x000000ff00000000

/*   SH_XNPI_ECC_INJ_REG_DATA_1SHOT2                                    */
/*   Description:  1 shot mask data                                     */
#define SH_XNPI_ECC_INJ_REG_DATA_1SHOT2_SHFT     44
#define SH_XNPI_ECC_INJ_REG_DATA_1SHOT2_MASK     0x0000100000000000

/*   SH_XNPI_ECC_INJ_REG_DATA_CONT2                                     */
/*   Description:  toggle mask data                                     */
#define SH_XNPI_ECC_INJ_REG_DATA_CONT2_SHFT      45
#define SH_XNPI_ECC_INJ_REG_DATA_CONT2_MASK      0x0000200000000000

/*   SH_XNPI_ECC_INJ_REG_DATA_CB_1SHOT2                                 */
/*   Description:  Replace Checkbyte OneShot                            */
#define SH_XNPI_ECC_INJ_REG_DATA_CB_1SHOT2_SHFT  46
#define SH_XNPI_ECC_INJ_REG_DATA_CB_1SHOT2_MASK  0x0000400000000000

/*   SH_XNPI_ECC_INJ_REG_DATA_CB_CONT2                                  */
/*   Description:  Replace Checkbyte Continous                          */
#define SH_XNPI_ECC_INJ_REG_DATA_CB_CONT2_SHFT   47
#define SH_XNPI_ECC_INJ_REG_DATA_CB_CONT2_MASK   0x0000800000000000

/*   SH_XNPI_ECC_INJ_REG_BYTE3                                          */
/*   Description:  Replacement Checkbyte                                */
#define SH_XNPI_ECC_INJ_REG_BYTE3_SHFT           48
#define SH_XNPI_ECC_INJ_REG_BYTE3_MASK           0x00ff000000000000

/*   SH_XNPI_ECC_INJ_REG_DATA_1SHOT3                                    */
/*   Description:  1 shot mask data                                     */
#define SH_XNPI_ECC_INJ_REG_DATA_1SHOT3_SHFT     60
#define SH_XNPI_ECC_INJ_REG_DATA_1SHOT3_MASK     0x1000000000000000

/*   SH_XNPI_ECC_INJ_REG_DATA_CONT3                                     */
/*   Description:  toggle mask data                                     */
#define SH_XNPI_ECC_INJ_REG_DATA_CONT3_SHFT      61
#define SH_XNPI_ECC_INJ_REG_DATA_CONT3_MASK      0x2000000000000000

/*   SH_XNPI_ECC_INJ_REG_DATA_CB_1SHOT3                                 */
/*   Description:  Replace Checkbyte One-Shot                           */
#define SH_XNPI_ECC_INJ_REG_DATA_CB_1SHOT3_SHFT  62
#define SH_XNPI_ECC_INJ_REG_DATA_CB_1SHOT3_MASK  0x4000000000000000

/*   SH_XNPI_ECC_INJ_REG_DATA_CB_CONT3                                  */
/*   Description:  Replace Checkbyte Continous                          */
#define SH_XNPI_ECC_INJ_REG_DATA_CB_CONT3_SHFT   63
#define SH_XNPI_ECC_INJ_REG_DATA_CB_CONT3_MASK   0x8000000000000000

/* ==================================================================== */
/*                 Register "SH_XNPI_ECC0_INJ_MASK_REG"                 */
/* ==================================================================== */

#define SH_XNPI_ECC0_INJ_MASK_REG                0x0000000150032008
#define SH_XNPI_ECC0_INJ_MASK_REG_MASK           0xffffffffffffffff
#define SH_XNPI_ECC0_INJ_MASK_REG_INIT           0x0000000000000000

/*   SH_XNPI_ECC0_INJ_MASK_REG_MASK_ECC0                                */
/*   Description:  Replacement Data                                     */
#define SH_XNPI_ECC0_INJ_MASK_REG_MASK_ECC0_SHFT 0
#define SH_XNPI_ECC0_INJ_MASK_REG_MASK_ECC0_MASK 0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XNPI_ECC1_INJ_MASK_REG"                 */
/* ==================================================================== */

#define SH_XNPI_ECC1_INJ_MASK_REG                0x0000000150032010
#define SH_XNPI_ECC1_INJ_MASK_REG_MASK           0xffffffffffffffff
#define SH_XNPI_ECC1_INJ_MASK_REG_INIT           0x0000000000000000

/*   SH_XNPI_ECC1_INJ_MASK_REG_MASK_ECC1                                */
/*   Description:  Replacement Data                                     */
#define SH_XNPI_ECC1_INJ_MASK_REG_MASK_ECC1_SHFT 0
#define SH_XNPI_ECC1_INJ_MASK_REG_MASK_ECC1_MASK 0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XNPI_ECC2_INJ_MASK_REG"                 */
/* ==================================================================== */

#define SH_XNPI_ECC2_INJ_MASK_REG                0x0000000150032018
#define SH_XNPI_ECC2_INJ_MASK_REG_MASK           0xffffffffffffffff
#define SH_XNPI_ECC2_INJ_MASK_REG_INIT           0x0000000000000000

/*   SH_XNPI_ECC2_INJ_MASK_REG_MASK_ECC2                                */
/*   Description:  Replacement Data                                     */
#define SH_XNPI_ECC2_INJ_MASK_REG_MASK_ECC2_SHFT 0
#define SH_XNPI_ECC2_INJ_MASK_REG_MASK_ECC2_MASK 0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XNPI_ECC3_INJ_MASK_REG"                 */
/* ==================================================================== */

#define SH_XNPI_ECC3_INJ_MASK_REG                0x0000000150032020
#define SH_XNPI_ECC3_INJ_MASK_REG_MASK           0xffffffffffffffff
#define SH_XNPI_ECC3_INJ_MASK_REG_INIT           0x0000000000000000

/*   SH_XNPI_ECC3_INJ_MASK_REG_MASK_ECC3                                */
/*   Description:  Replacement Data                                     */
#define SH_XNPI_ECC3_INJ_MASK_REG_MASK_ECC3_SHFT 0
#define SH_XNPI_ECC3_INJ_MASK_REG_MASK_ECC3_MASK 0xffffffffffffffff

/* ==================================================================== */
/*                    Register "SH_XNMD_ECC_INJ_REG"                    */
/* ==================================================================== */

#define SH_XNMD_ECC_INJ_REG                      0x0000000150032030
#define SH_XNMD_ECC_INJ_REG_MASK                 0xf0fff0fff0fff0ff
#define SH_XNMD_ECC_INJ_REG_INIT                 0x0000000000000000

/*   SH_XNMD_ECC_INJ_REG_BYTE0                                          */
/*   Description:  Replacement Checkbyte                                */
#define SH_XNMD_ECC_INJ_REG_BYTE0_SHFT           0
#define SH_XNMD_ECC_INJ_REG_BYTE0_MASK           0x00000000000000ff

/*   SH_XNMD_ECC_INJ_REG_DATA_1SHOT0                                    */
/*   Description:  1 shot mask data                                     */
#define SH_XNMD_ECC_INJ_REG_DATA_1SHOT0_SHFT     12
#define SH_XNMD_ECC_INJ_REG_DATA_1SHOT0_MASK     0x0000000000001000

/*   SH_XNMD_ECC_INJ_REG_DATA_CONT0                                     */
/*   Description:  toggle mask data                                     */
#define SH_XNMD_ECC_INJ_REG_DATA_CONT0_SHFT      13
#define SH_XNMD_ECC_INJ_REG_DATA_CONT0_MASK      0x0000000000002000

/*   SH_XNMD_ECC_INJ_REG_DATA_CB_1SHOT0                                 */
/*   Description:  Replace Checkbyte One Shot                           */
#define SH_XNMD_ECC_INJ_REG_DATA_CB_1SHOT0_SHFT  14
#define SH_XNMD_ECC_INJ_REG_DATA_CB_1SHOT0_MASK  0x0000000000004000

/*   SH_XNMD_ECC_INJ_REG_DATA_CB_CONT0                                  */
/*   Description:  Replace Checkbyte Continuous                         */
#define SH_XNMD_ECC_INJ_REG_DATA_CB_CONT0_SHFT   15
#define SH_XNMD_ECC_INJ_REG_DATA_CB_CONT0_MASK   0x0000000000008000

/*   SH_XNMD_ECC_INJ_REG_BYTE1                                          */
/*   Description:  Replacement Checkbyte                                */
#define SH_XNMD_ECC_INJ_REG_BYTE1_SHFT           16
#define SH_XNMD_ECC_INJ_REG_BYTE1_MASK           0x0000000000ff0000

/*   SH_XNMD_ECC_INJ_REG_DATA_1SHOT1                                    */
/*   Description:  1 shot mask data                                     */
#define SH_XNMD_ECC_INJ_REG_DATA_1SHOT1_SHFT     28
#define SH_XNMD_ECC_INJ_REG_DATA_1SHOT1_MASK     0x0000000010000000

/*   SH_XNMD_ECC_INJ_REG_DATA_CONT1                                     */
/*   Description:  toggle mask data                                     */
#define SH_XNMD_ECC_INJ_REG_DATA_CONT1_SHFT      29
#define SH_XNMD_ECC_INJ_REG_DATA_CONT1_MASK      0x0000000020000000

/*   SH_XNMD_ECC_INJ_REG_DATA_CB_1SHOT1                                 */
/*   Description:  Replace Checkbyte One Shot                           */
#define SH_XNMD_ECC_INJ_REG_DATA_CB_1SHOT1_SHFT  30
#define SH_XNMD_ECC_INJ_REG_DATA_CB_1SHOT1_MASK  0x0000000040000000

/*   SH_XNMD_ECC_INJ_REG_DATA_CB_CONT1                                  */
/*   Description:  Replace Checkbyte Continous                          */
#define SH_XNMD_ECC_INJ_REG_DATA_CB_CONT1_SHFT   31
#define SH_XNMD_ECC_INJ_REG_DATA_CB_CONT1_MASK   0x0000000080000000

/*   SH_XNMD_ECC_INJ_REG_BYTE2                                          */
/*   Description:  Replacement Checkbyte                                */
#define SH_XNMD_ECC_INJ_REG_BYTE2_SHFT           32
#define SH_XNMD_ECC_INJ_REG_BYTE2_MASK           0x000000ff00000000

/*   SH_XNMD_ECC_INJ_REG_DATA_1SHOT2                                    */
/*   Description:  1 shot mask data                                     */
#define SH_XNMD_ECC_INJ_REG_DATA_1SHOT2_SHFT     44
#define SH_XNMD_ECC_INJ_REG_DATA_1SHOT2_MASK     0x0000100000000000

/*   SH_XNMD_ECC_INJ_REG_DATA_CONT2                                     */
/*   Description:  toggle mask data                                     */
#define SH_XNMD_ECC_INJ_REG_DATA_CONT2_SHFT      45
#define SH_XNMD_ECC_INJ_REG_DATA_CONT2_MASK      0x0000200000000000

/*   SH_XNMD_ECC_INJ_REG_DATA_CB_1SHOT2                                 */
/*   Description:  Replace Checkbyte OneShot                            */
#define SH_XNMD_ECC_INJ_REG_DATA_CB_1SHOT2_SHFT  46
#define SH_XNMD_ECC_INJ_REG_DATA_CB_1SHOT2_MASK  0x0000400000000000

/*   SH_XNMD_ECC_INJ_REG_DATA_CB_CONT2                                  */
/*   Description:  Replace Checkbyte Continous                          */
#define SH_XNMD_ECC_INJ_REG_DATA_CB_CONT2_SHFT   47
#define SH_XNMD_ECC_INJ_REG_DATA_CB_CONT2_MASK   0x0000800000000000

/*   SH_XNMD_ECC_INJ_REG_BYTE3                                          */
/*   Description:  Replacement Checkbyte                                */
#define SH_XNMD_ECC_INJ_REG_BYTE3_SHFT           48
#define SH_XNMD_ECC_INJ_REG_BYTE3_MASK           0x00ff000000000000

/*   SH_XNMD_ECC_INJ_REG_DATA_1SHOT3                                    */
/*   Description:  1 shot mask data                                     */
#define SH_XNMD_ECC_INJ_REG_DATA_1SHOT3_SHFT     60
#define SH_XNMD_ECC_INJ_REG_DATA_1SHOT3_MASK     0x1000000000000000

/*   SH_XNMD_ECC_INJ_REG_DATA_CONT3                                     */
/*   Description:  toggle mask data                                     */
#define SH_XNMD_ECC_INJ_REG_DATA_CONT3_SHFT      61
#define SH_XNMD_ECC_INJ_REG_DATA_CONT3_MASK      0x2000000000000000

/*   SH_XNMD_ECC_INJ_REG_DATA_CB_1SHOT3                                 */
/*   Description:  Replace Checkbyte One-Shot                           */
#define SH_XNMD_ECC_INJ_REG_DATA_CB_1SHOT3_SHFT  62
#define SH_XNMD_ECC_INJ_REG_DATA_CB_1SHOT3_MASK  0x4000000000000000

/*   SH_XNMD_ECC_INJ_REG_DATA_CB_CONT3                                  */
/*   Description:  Replace Checkbyte Continous                          */
#define SH_XNMD_ECC_INJ_REG_DATA_CB_CONT3_SHFT   63
#define SH_XNMD_ECC_INJ_REG_DATA_CB_CONT3_MASK   0x8000000000000000

/* ==================================================================== */
/*                 Register "SH_XNMD_ECC0_INJ_MASK_REG"                 */
/* ==================================================================== */

#define SH_XNMD_ECC0_INJ_MASK_REG                0x0000000150032038
#define SH_XNMD_ECC0_INJ_MASK_REG_MASK           0xffffffffffffffff
#define SH_XNMD_ECC0_INJ_MASK_REG_INIT           0x0000000000000000

/*   SH_XNMD_ECC0_INJ_MASK_REG_MASK_ECC0                                */
/*   Description:  Replacement Data                                     */
#define SH_XNMD_ECC0_INJ_MASK_REG_MASK_ECC0_SHFT 0
#define SH_XNMD_ECC0_INJ_MASK_REG_MASK_ECC0_MASK 0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XNMD_ECC1_INJ_MASK_REG"                 */
/* ==================================================================== */

#define SH_XNMD_ECC1_INJ_MASK_REG                0x0000000150032040
#define SH_XNMD_ECC1_INJ_MASK_REG_MASK           0xffffffffffffffff
#define SH_XNMD_ECC1_INJ_MASK_REG_INIT           0x0000000000000000

/*   SH_XNMD_ECC1_INJ_MASK_REG_MASK_ECC1                                */
/*   Description:  Replacement Data                                     */
#define SH_XNMD_ECC1_INJ_MASK_REG_MASK_ECC1_SHFT 0
#define SH_XNMD_ECC1_INJ_MASK_REG_MASK_ECC1_MASK 0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XNMD_ECC2_INJ_MASK_REG"                 */
/* ==================================================================== */

#define SH_XNMD_ECC2_INJ_MASK_REG                0x0000000150032048
#define SH_XNMD_ECC2_INJ_MASK_REG_MASK           0xffffffffffffffff
#define SH_XNMD_ECC2_INJ_MASK_REG_INIT           0x0000000000000000

/*   SH_XNMD_ECC2_INJ_MASK_REG_MASK_ECC2                                */
/*   Description:  Replacement Data                                     */
#define SH_XNMD_ECC2_INJ_MASK_REG_MASK_ECC2_SHFT 0
#define SH_XNMD_ECC2_INJ_MASK_REG_MASK_ECC2_MASK 0xffffffffffffffff

/* ==================================================================== */
/*                 Register "SH_XNMD_ECC3_INJ_MASK_REG"                 */
/* ==================================================================== */

#define SH_XNMD_ECC3_INJ_MASK_REG                0x0000000150032050
#define SH_XNMD_ECC3_INJ_MASK_REG_MASK           0xffffffffffffffff
#define SH_XNMD_ECC3_INJ_MASK_REG_INIT           0x0000000000000000

/*   SH_XNMD_ECC3_INJ_MASK_REG_MASK_ECC3                                */
/*   Description:  Replacement Data                                     */
#define SH_XNMD_ECC3_INJ_MASK_REG_MASK_ECC3_SHFT 0
#define SH_XNMD_ECC3_INJ_MASK_REG_MASK_ECC3_MASK 0xffffffffffffffff

/* ==================================================================== */
/*                  Register "SH_XNMD_ECC_ERR_REPORT"                   */
/* ==================================================================== */

#define SH_XNMD_ECC_ERR_REPORT                   0x0000000150032058
#define SH_XNMD_ECC_ERR_REPORT_MASK              0x0001000100010001
#define SH_XNMD_ECC_ERR_REPORT_INIT              0x0000000000000000

/*   SH_XNMD_ECC_ERR_REPORT_ECC_DISABLE0                                */
/*   Description:  Disable Error Correction                             */
#define SH_XNMD_ECC_ERR_REPORT_ECC_DISABLE0_SHFT 0
#define SH_XNMD_ECC_ERR_REPORT_ECC_DISABLE0_MASK 0x0000000000000001

/*   SH_XNMD_ECC_ERR_REPORT_ECC_DISABLE1                                */
/*   Description:  Disable Error Correction                             */
#define SH_XNMD_ECC_ERR_REPORT_ECC_DISABLE1_SHFT 16
#define SH_XNMD_ECC_ERR_REPORT_ECC_DISABLE1_MASK 0x0000000000010000

/*   SH_XNMD_ECC_ERR_REPORT_ECC_DISABLE2                                */
/*   Description:  Disable Error Correction                             */
#define SH_XNMD_ECC_ERR_REPORT_ECC_DISABLE2_SHFT 32
#define SH_XNMD_ECC_ERR_REPORT_ECC_DISABLE2_MASK 0x0000000100000000

/*   SH_XNMD_ECC_ERR_REPORT_ECC_DISABLE3                                */
/*   Description:  Disable Error Correction                             */
#define SH_XNMD_ECC_ERR_REPORT_ECC_DISABLE3_SHFT 48
#define SH_XNMD_ECC_ERR_REPORT_ECC_DISABLE3_MASK 0x0001000000000000

/* ==================================================================== */
/*                  Register "SH_NI0_ERROR_SUMMARY_1"                   */
/*                       ni0  Error Summary Bits                        */
/* ==================================================================== */

#define SH_NI0_ERROR_SUMMARY_1                   0x0000000150040500
#define SH_NI0_ERROR_SUMMARY_1_MASK              0xffffffffffffffff
#define SH_NI0_ERROR_SUMMARY_1_INIT              0xffffffffffffffff

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_DEBIT0                      */
/*   Description:  Fifo 02 debit0 overflow                              */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_DEBIT0_SHFT 0
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_DEBIT0_MASK 0x0000000000000001

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_DEBIT2                      */
/*   Description:  Fifo 02 debit2 overflow                              */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_DEBIT2_SHFT 1
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_DEBIT2_MASK 0x0000000000000002

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_DEBIT0                      */
/*   Description:  Fifo 13 debit0 overflow                              */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_DEBIT0_SHFT 2
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_DEBIT0_MASK 0x0000000000000004

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_DEBIT2                      */
/*   Description:  Fifo 13 debit2 overflow                              */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_DEBIT2_SHFT 3
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_DEBIT2_MASK 0x0000000000000008

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_POP                     */
/*   Description:  Fifo 02 vc0 pop overflow                             */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_POP_SHFT 4
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_POP_MASK 0x0000000000000010

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_POP                     */
/*   Description:  Fifo 02 vc2 pop overflow                             */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_POP_SHFT 5
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_POP_MASK 0x0000000000000020

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC1_POP                     */
/*   Description:  Fifo 13 vc1 pop overflow                             */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC1_POP_SHFT 6
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC1_POP_MASK 0x0000000000000040

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC3_POP                     */
/*   Description:  Fifo 13 vc3 pop overflow                             */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC3_POP_SHFT 7
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC3_POP_MASK 0x0000000000000080

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_PUSH                    */
/*   Description:  Fifo 02 vc0 push overflow                            */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_PUSH_SHFT 8
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_PUSH_MASK 0x0000000000000100

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_PUSH                    */
/*   Description:  Fifo 02 vc2 push overflow                            */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_PUSH_SHFT 9
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_PUSH_MASK 0x0000000000000200

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC1_PUSH                    */
/*   Description:  Fifo 13 vc1 push overflow                            */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC1_PUSH_SHFT 10
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC1_PUSH_MASK 0x0000000000000400

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC3_PUSH                    */
/*   Description:  Fifo 13 vc3 push overflow                            */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC3_PUSH_SHFT 11
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC3_PUSH_MASK 0x0000000000000800

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_CREDIT                  */
/*   Description:  Fifo 02 vc0 credit overflow                          */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_CREDIT_SHFT 12
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_CREDIT_MASK 0x0000000000001000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_CREDIT                  */
/*   Description:  Fifo 02 vc2 credit overflow                          */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_CREDIT_SHFT 13
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_CREDIT_MASK 0x0000000000002000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC0_CREDIT                  */
/*   Description:  Fifo 13 vc0 credit overflow                          */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC0_CREDIT_SHFT 14
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC0_CREDIT_MASK 0x0000000000004000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC2_CREDIT                  */
/*   Description:  Fifo 13 vc2 credit overflow                          */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC2_CREDIT_SHFT 15
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC2_CREDIT_MASK 0x0000000000008000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW0_VC0_CREDIT                        */
/*   Description:  VC0 credit overflow 0                                */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW0_VC0_CREDIT_SHFT 16
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW0_VC0_CREDIT_MASK 0x0000000000010000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW1_VC0_CREDIT                        */
/*   Description:  VC0 credit overflow 1                                */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW1_VC0_CREDIT_SHFT 17
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW1_VC0_CREDIT_MASK 0x0000000000020000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW2_VC0_CREDIT                        */
/*   Description:  VC0 credit overflow 2                                */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW2_VC0_CREDIT_SHFT 18
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW2_VC0_CREDIT_MASK 0x0000000000040000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW0_VC2_CREDIT                        */
/*   Description:  VC2 credit overflow 0                                */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW0_VC2_CREDIT_SHFT 19
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW0_VC2_CREDIT_MASK 0x0000000000080000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW1_VC2_CREDIT                        */
/*   Description:  VC2 credit overflow 1                                */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW1_VC2_CREDIT_SHFT 20
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW1_VC2_CREDIT_MASK 0x0000000000100000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW2_VC2_CREDIT                        */
/*   Description:  VC2 credit overflow 2                                */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW2_VC2_CREDIT_SHFT 21
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW2_VC2_CREDIT_MASK 0x0000000000200000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_DEBIT0                     */
/*   Description:  PI Fifo debit0 overflow                              */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_DEBIT0_SHFT 22
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_DEBIT0_MASK 0x0000000000400000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_DEBIT2                     */
/*   Description:  PI Fifo debit2 overflow                              */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_DEBIT2_SHFT 23
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_DEBIT2_MASK 0x0000000000800000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_DEBIT0                   */
/*   Description:  IILB Fifo debit0 overflow                            */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_DEBIT0_SHFT 24
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_DEBIT0_MASK 0x0000000001000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_DEBIT2                   */
/*   Description:  IILB Fifo debit2 overflow                            */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_DEBIT2_SHFT 25
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_DEBIT2_MASK 0x0000000002000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_DEBIT0                     */
/*   Description:  MD Fifo debit0 overflow                              */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_DEBIT0_SHFT 26
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_DEBIT0_MASK 0x0000000004000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_DEBIT2                     */
/*   Description:  MD Fifo debit2 overflow                              */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_DEBIT2_SHFT 27
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_DEBIT2_MASK 0x0000000008000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT0                     */
/*   Description:  NI Fifo debit0 overflow                              */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT0_SHFT 28
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT0_MASK 0x0000000010000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT1                     */
/*   Description:  NI Fifo debit1 overflow                              */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT1_SHFT 29
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT1_MASK 0x0000000020000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT2                     */
/*   Description:  NI Fifo debit2 overflow                              */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT2_SHFT 30
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT2_MASK 0x0000000040000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT3                     */
/*   Description:  NI Fifo debit3 overflow                              */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT3_SHFT 31
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT3_MASK 0x0000000080000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_POP                    */
/*   Description:  PI Fifo vc0 pop overflow                             */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_POP_SHFT 32
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_POP_MASK 0x0000000100000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_POP                    */
/*   Description:  PI Fifo vc2 pop overflow                             */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_POP_SHFT 33
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_POP_MASK 0x0000000200000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_POP                  */
/*   Description:  IILB Fifo vc0 pop overflow                           */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_POP_SHFT 34
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_POP_MASK 0x0000000400000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_POP                  */
/*   Description:  IILB Fifo vc2 pop overflow                           */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_POP_SHFT 35
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_POP_MASK 0x0000000800000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_POP                    */
/*   Description:  MD Fifo vc0 pop overflow                             */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_POP_SHFT 36
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_POP_MASK 0x0000001000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_POP                    */
/*   Description:  MD Fifo vc2 pop overflow                             */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_POP_SHFT 37
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_POP_MASK 0x0000002000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC0_POP                    */
/*   Description:  NI Fifo vc0 pop overflow                             */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC0_POP_SHFT 38
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC0_POP_MASK 0x0000004000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC2_POP                    */
/*   Description:  NI Fifo vc2 pop overflow                             */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC2_POP_SHFT 39
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC2_POP_MASK 0x0000008000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_PUSH                   */
/*   Description:  PI Fifo vc0 push overflow                            */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_PUSH_SHFT 40
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_PUSH_MASK 0x0000010000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_PUSH                   */
/*   Description:  PI Fifo vc2 push overflow                            */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_PUSH_SHFT 41
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_PUSH_MASK 0x0000020000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_PUSH                 */
/*   Description:  IILB Fifo vc0 push overflow                          */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_PUSH_SHFT 42
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_PUSH_MASK 0x0000040000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_PUSH                 */
/*   Description:  IILB Fifo vc2 push overflow                          */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_PUSH_SHFT 43
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_PUSH_MASK 0x0000080000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_PUSH                   */
/*   Description:  MD Fifo vc0 push overflow                            */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_PUSH_SHFT 44
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_PUSH_MASK 0x0000100000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_PUSH                   */
/*   Description:  MD Fifo vc2 push overflow                            */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_PUSH_SHFT 45
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_PUSH_MASK 0x0000200000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_CREDIT                 */
/*   Description:  PI Fifo vc0 credit overflow                          */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_CREDIT_SHFT 46
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_CREDIT_MASK 0x0000400000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_CREDIT                 */
/*   Description:  PI Fifo vc2 credit overflow                          */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_CREDIT_SHFT 47
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_CREDIT_MASK 0x0000800000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_CREDIT               */
/*   Description:  IILB Fifo vc0 credit overflow                        */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_CREDIT_SHFT 48
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_CREDIT_MASK 0x0001000000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_CREDIT               */
/*   Description:  IILB Fifo vc2 credit overflow                        */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_CREDIT_SHFT 49
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_CREDIT_MASK 0x0002000000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_CREDIT                 */
/*   Description:  MD Fifo vc0 credit overflow                          */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_CREDIT_SHFT 50
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_CREDIT_MASK 0x0004000000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_CREDIT                 */
/*   Description:  MD Fifo vc2 credit overflow                          */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_CREDIT_SHFT 51
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_CREDIT_MASK 0x0008000000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC0_CREDIT                 */
/*   Description:  NI Fifo vc0 credit overflow                          */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC0_CREDIT_SHFT 52
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC0_CREDIT_MASK 0x0010000000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC1_CREDIT                 */
/*   Description:  NI Fifo vc1 credit overflow                          */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC1_CREDIT_SHFT 53
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC1_CREDIT_MASK 0x0020000000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC2_CREDIT                 */
/*   Description:  NI Fifo vc2 credit overflow                          */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC2_CREDIT_SHFT 54
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC2_CREDIT_MASK 0x0040000000000000

/*   SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC3_CREDIT                 */
/*   Description:  NI Fifo vc3 credit overflow                          */
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC3_CREDIT_SHFT 55
#define SH_NI0_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC3_CREDIT_MASK 0x0080000000000000

/*   SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO02_VC0                     */
/*   Description:  Fifo02 vc0 tail timeout                              */
#define SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO02_VC0_SHFT 56
#define SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO02_VC0_MASK 0x0100000000000000

/*   SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO02_VC2                     */
/*   Description:  Fifo02 vc2 tail timeout                              */
#define SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO02_VC2_SHFT 57
#define SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO02_VC2_MASK 0x0200000000000000

/*   SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO13_VC1                     */
/*   Description:  Fifo13 vc1 tail timeout                              */
#define SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO13_VC1_SHFT 58
#define SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO13_VC1_MASK 0x0400000000000000

/*   SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO13_VC3                     */
/*   Description:  Fifo13 vc3 tail timeout                              */
#define SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO13_VC3_SHFT 59
#define SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO13_VC3_MASK 0x0800000000000000

/*   SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC0                         */
/*   Description:  NI vc0 tail timeout                                  */
#define SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC0_SHFT 60
#define SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC0_MASK 0x1000000000000000

/*   SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC1                         */
/*   Description:  NI vc1 tail timeout                                  */
#define SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC1_SHFT 61
#define SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC1_MASK 0x2000000000000000

/*   SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC2                         */
/*   Description:  NI vc2 tail timeout                                  */
#define SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC2_SHFT 62
#define SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC2_MASK 0x4000000000000000

/*   SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC3                         */
/*   Description:  NI vc3 tail timeout                                  */
#define SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC3_SHFT 63
#define SH_NI0_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC3_MASK 0x8000000000000000

/* ==================================================================== */
/*               Register "SH_NI0_ERROR_SUMMARY_1_ALIAS"                */
/*                     ni0 Error Summary Bits Alias                     */
/* ==================================================================== */

#define SH_NI0_ERROR_SUMMARY_1_ALIAS             0x0000000150040508

/* ==================================================================== */
/*                  Register "SH_NI0_ERROR_SUMMARY_2"                   */
/*                       ni0  Error Summary Bits                        */
/* ==================================================================== */

#define SH_NI0_ERROR_SUMMARY_2                   0x0000000150040510
#define SH_NI0_ERROR_SUMMARY_2_MASK              0x7fffffff003fffff
#define SH_NI0_ERROR_SUMMARY_2_INIT              0x7fffffff003fffff

/*   SH_NI0_ERROR_SUMMARY_2_ILLEGAL_VCNI                                */
/*   Description:  Illegal VC NI                                        */
#define SH_NI0_ERROR_SUMMARY_2_ILLEGAL_VCNI_SHFT 0
#define SH_NI0_ERROR_SUMMARY_2_ILLEGAL_VCNI_MASK 0x0000000000000001

/*   SH_NI0_ERROR_SUMMARY_2_ILLEGAL_VCPI                                */
/*   Description:  Illegal VC PI                                        */
#define SH_NI0_ERROR_SUMMARY_2_ILLEGAL_VCPI_SHFT 1
#define SH_NI0_ERROR_SUMMARY_2_ILLEGAL_VCPI_MASK 0x0000000000000002

/*   SH_NI0_ERROR_SUMMARY_2_ILLEGAL_VCMD                                */
/*   Description:  Illegal VC MD                                        */
#define SH_NI0_ERROR_SUMMARY_2_ILLEGAL_VCMD_SHFT 2
#define SH_NI0_ERROR_SUMMARY_2_ILLEGAL_VCMD_MASK 0x0000000000000004

/*   SH_NI0_ERROR_SUMMARY_2_ILLEGAL_VCIILB                              */
/*   Description:  Illegal VC IILB                                      */
#define SH_NI0_ERROR_SUMMARY_2_ILLEGAL_VCIILB_SHFT 3
#define SH_NI0_ERROR_SUMMARY_2_ILLEGAL_VCIILB_MASK 0x0000000000000008

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_POP                    */
/*   Description:  Fifo 02 vc0 pop underflow                            */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_POP_SHFT 4
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_POP_MASK 0x0000000000000010

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_POP                    */
/*   Description:  Fifo 02 vc2 pop underflow                            */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_POP_SHFT 5
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_POP_MASK 0x0000000000000020

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC1_POP                    */
/*   Description:  Fifo 13 vc1 pop underflow                            */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC1_POP_SHFT 6
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC1_POP_MASK 0x0000000000000040

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC3_POP                    */
/*   Description:  Fifo 13 vc3 pop underflow                            */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC3_POP_SHFT 7
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC3_POP_MASK 0x0000000000000080

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_PUSH                   */
/*   Description:  Fifo 02 vc0 push underflow                           */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_PUSH_SHFT 8
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_PUSH_MASK 0x0000000000000100

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_PUSH                   */
/*   Description:  Fifo 02 vc2 push underflow                           */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_PUSH_SHFT 9
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_PUSH_MASK 0x0000000000000200

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC1_PUSH                   */
/*   Description:  Fifo 13 vc1 push underflow                           */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC1_PUSH_SHFT 10
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC1_PUSH_MASK 0x0000000000000400

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC3_PUSH                   */
/*   Description:  Fifo 13 vc3 push underflow                           */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC3_PUSH_SHFT 11
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC3_PUSH_MASK 0x0000000000000800

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_CREDIT                 */
/*   Description:  Fifo 02 vc0 credit underflow                         */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_CREDIT_SHFT 12
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_CREDIT_MASK 0x0000000000001000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_CREDIT                 */
/*   Description:  Fifo 02 vc2 credit underflow                         */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_CREDIT_SHFT 13
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_CREDIT_MASK 0x0000000000002000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC0_CREDIT                 */
/*   Description:  Fifo 13 vc0 credit underflow                         */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC0_CREDIT_SHFT 14
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC0_CREDIT_MASK 0x0000000000004000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC2_CREDIT                 */
/*   Description:  Fifo 13 vc2 credit underflow                         */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC2_CREDIT_SHFT 15
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC2_CREDIT_MASK 0x0000000000008000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW0_VC0_CREDIT                       */
/*   Description:  VC0 credit underflow 0                               */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW0_VC0_CREDIT_SHFT 16
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW0_VC0_CREDIT_MASK 0x0000000000010000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW1_VC0_CREDIT                       */
/*   Description:  VC0 credit underflow 1                               */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW1_VC0_CREDIT_SHFT 17
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW1_VC0_CREDIT_MASK 0x0000000000020000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW2_VC0_CREDIT                       */
/*   Description:  VC0 credit underflow 2                               */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW2_VC0_CREDIT_SHFT 18
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW2_VC0_CREDIT_MASK 0x0000000000040000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW0_VC2_CREDIT                       */
/*   Description:  VC2 credit underflow 0                               */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW0_VC2_CREDIT_SHFT 19
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW0_VC2_CREDIT_MASK 0x0000000000080000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW1_VC2_CREDIT                       */
/*   Description:  VC2 credit underflow 1                               */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW1_VC2_CREDIT_SHFT 20
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW1_VC2_CREDIT_MASK 0x0000000000100000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW2_VC2_CREDIT                       */
/*   Description:  VC2 credit underflow 2                               */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW2_VC2_CREDIT_SHFT 21
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW2_VC2_CREDIT_MASK 0x0000000000200000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_POP                   */
/*   Description:  PI Fifo vc0 pop underflow                            */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_POP_SHFT 32
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_POP_MASK 0x0000000100000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_POP                   */
/*   Description:  PI Fifo vc2 pop underflow                            */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_POP_SHFT 33
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_POP_MASK 0x0000000200000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_POP                 */
/*   Description:  IILB Fifo vc0 pop underflow                          */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_POP_SHFT 34
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_POP_MASK 0x0000000400000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_POP                 */
/*   Description:  IILB Fifo vc2 pop underflow                          */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_POP_SHFT 35
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_POP_MASK 0x0000000800000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_POP                   */
/*   Description:  MD Fifo vc0 pop underflow                            */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_POP_SHFT 36
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_POP_MASK 0x0000001000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_POP                   */
/*   Description:  MD Fifo vc2 pop underflow                            */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_POP_SHFT 37
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_POP_MASK 0x0000002000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC0_POP                   */
/*   Description:  NI Fifo vc0 pop underflow                            */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC0_POP_SHFT 38
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC0_POP_MASK 0x0000004000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC2_POP                   */
/*   Description:  NI Fifo vc2 pop underflow                            */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC2_POP_SHFT 39
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC2_POP_MASK 0x0000008000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_PUSH                  */
/*   Description:  PI Fifo vc0 push underflow                           */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_PUSH_SHFT 40
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_PUSH_MASK 0x0000010000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_PUSH                  */
/*   Description:  PI Fifo vc2 push underflow                           */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_PUSH_SHFT 41
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_PUSH_MASK 0x0000020000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_PUSH                */
/*   Description:  IILB Fifo vc0 push underflow                         */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_PUSH_SHFT 42
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_PUSH_MASK 0x0000040000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_PUSH                */
/*   Description:  IILB Fifo vc2 push underflow                         */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_PUSH_SHFT 43
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_PUSH_MASK 0x0000080000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_PUSH                  */
/*   Description:  MD Fifo vc0 push underflow                           */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_PUSH_SHFT 44
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_PUSH_MASK 0x0000100000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_PUSH                  */
/*   Description:  MD Fifo vc2 push underflow                           */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_PUSH_SHFT 45
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_PUSH_MASK 0x0000200000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_CREDIT                */
/*   Description:  PI Fifo vc0 credit underflow                         */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_CREDIT_SHFT 46
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_CREDIT_MASK 0x0000400000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_CREDIT                */
/*   Description:  PI Fifo vc2 credit underflow                         */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_CREDIT_SHFT 47
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_CREDIT_MASK 0x0000800000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT              */
/*   Description:  IILB Fifo vc0 credit underflow                       */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT_SHFT 48
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT_MASK 0x0001000000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT              */
/*   Description:  IILB Fifo vc2 credit underflow                       */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT_SHFT 49
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT_MASK 0x0002000000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_CREDIT                */
/*   Description:  MD Fifo vc0 credit underflow                         */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_CREDIT_SHFT 50
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_CREDIT_MASK 0x0004000000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_CREDIT                */
/*   Description:  MD Fifo vc2 credit underflow                         */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_CREDIT_SHFT 51
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_CREDIT_MASK 0x0008000000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC0_CREDIT                */
/*   Description:  NI Fifo vc0 credit underflow                         */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC0_CREDIT_SHFT 52
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC0_CREDIT_MASK 0x0010000000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC1_CREDIT                */
/*   Description:  NI Fifo vc1 credit underflow                         */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC1_CREDIT_SHFT 53
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC1_CREDIT_MASK 0x0020000000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC2_CREDIT                */
/*   Description:  NI Fifo vc2 credit underflow                         */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC2_CREDIT_SHFT 54
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC2_CREDIT_MASK 0x0040000000000000

/*   SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC3_CREDIT                */
/*   Description:  NI Fifo vc3 credit underflow                         */
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC3_CREDIT_SHFT 55
#define SH_NI0_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC3_CREDIT_MASK 0x0080000000000000

/*   SH_NI0_ERROR_SUMMARY_2_LLP_DEADLOCK_VC0                            */
/*   Description:  llp deadlock vc0                                     */
#define SH_NI0_ERROR_SUMMARY_2_LLP_DEADLOCK_VC0_SHFT 56
#define SH_NI0_ERROR_SUMMARY_2_LLP_DEADLOCK_VC0_MASK 0x0100000000000000

/*   SH_NI0_ERROR_SUMMARY_2_LLP_DEADLOCK_VC1                            */
/*   Description:  llp deadlock vc1                                     */
#define SH_NI0_ERROR_SUMMARY_2_LLP_DEADLOCK_VC1_SHFT 57
#define SH_NI0_ERROR_SUMMARY_2_LLP_DEADLOCK_VC1_MASK 0x0200000000000000

/*   SH_NI0_ERROR_SUMMARY_2_LLP_DEADLOCK_VC2                            */
/*   Description:  llp deadlock vc2                                     */
#define SH_NI0_ERROR_SUMMARY_2_LLP_DEADLOCK_VC2_SHFT 58
#define SH_NI0_ERROR_SUMMARY_2_LLP_DEADLOCK_VC2_MASK 0x0400000000000000

/*   SH_NI0_ERROR_SUMMARY_2_LLP_DEADLOCK_VC3                            */
/*   Description:  llp deadlock vc3                                     */
#define SH_NI0_ERROR_SUMMARY_2_LLP_DEADLOCK_VC3_SHFT 59
#define SH_NI0_ERROR_SUMMARY_2_LLP_DEADLOCK_VC3_MASK 0x0800000000000000

/*   SH_NI0_ERROR_SUMMARY_2_CHIPLET_NOMATCH                             */
/*   Description:  chiplet nomatch                                      */
#define SH_NI0_ERROR_SUMMARY_2_CHIPLET_NOMATCH_SHFT 60
#define SH_NI0_ERROR_SUMMARY_2_CHIPLET_NOMATCH_MASK 0x1000000000000000

/*   SH_NI0_ERROR_SUMMARY_2_LUT_READ_ERROR                              */
/*   Description:  LUT Read Error                                       */
#define SH_NI0_ERROR_SUMMARY_2_LUT_READ_ERROR_SHFT 61
#define SH_NI0_ERROR_SUMMARY_2_LUT_READ_ERROR_MASK 0x2000000000000000

/*   SH_NI0_ERROR_SUMMARY_2_RETRY_TIMEOUT_ERROR                         */
/*   Description:  Retry Timeout Error                                  */
#define SH_NI0_ERROR_SUMMARY_2_RETRY_TIMEOUT_ERROR_SHFT 62
#define SH_NI0_ERROR_SUMMARY_2_RETRY_TIMEOUT_ERROR_MASK 0x4000000000000000

/* ==================================================================== */
/*               Register "SH_NI0_ERROR_SUMMARY_2_ALIAS"                */
/*                     ni0 Error Summary Bits Alias                     */
/* ==================================================================== */

#define SH_NI0_ERROR_SUMMARY_2_ALIAS             0x0000000150040518

/* ==================================================================== */
/*                  Register "SH_NI0_ERROR_OVERFLOW_1"                  */
/*                       ni0  Error Overflow Bits                       */
/* ==================================================================== */

#define SH_NI0_ERROR_OVERFLOW_1                  0x0000000150040520
#define SH_NI0_ERROR_OVERFLOW_1_MASK             0xffffffffffffffff
#define SH_NI0_ERROR_OVERFLOW_1_INIT             0xffffffffffffffff

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_DEBIT0                     */
/*   Description:  Fifo 02 debit0 overflow                              */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_DEBIT0_SHFT 0
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_DEBIT0_MASK 0x0000000000000001

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_DEBIT2                     */
/*   Description:  Fifo 02 debit2 overflow                              */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_DEBIT2_SHFT 1
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_DEBIT2_MASK 0x0000000000000002

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_DEBIT0                     */
/*   Description:  Fifo 13 debit0 overflow                              */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_DEBIT0_SHFT 2
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_DEBIT0_MASK 0x0000000000000004

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_DEBIT2                     */
/*   Description:  Fifo 13 debit2 overflow                              */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_DEBIT2_SHFT 3
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_DEBIT2_MASK 0x0000000000000008

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_POP                    */
/*   Description:  Fifo 02 vc0 pop overflow                             */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_POP_SHFT 4
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_POP_MASK 0x0000000000000010

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_POP                    */
/*   Description:  Fifo 02 vc2 pop overflow                             */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_POP_SHFT 5
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_POP_MASK 0x0000000000000020

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC1_POP                    */
/*   Description:  Fifo 13 vc1 pop overflow                             */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC1_POP_SHFT 6
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC1_POP_MASK 0x0000000000000040

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC3_POP                    */
/*   Description:  Fifo 13 vc3 pop overflow                             */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC3_POP_SHFT 7
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC3_POP_MASK 0x0000000000000080

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_PUSH                   */
/*   Description:  Fifo 02 vc0 push overflow                            */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_PUSH_SHFT 8
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_PUSH_MASK 0x0000000000000100

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_PUSH                   */
/*   Description:  Fifo 02 vc2 push overflow                            */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_PUSH_SHFT 9
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_PUSH_MASK 0x0000000000000200

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC1_PUSH                   */
/*   Description:  Fifo 13 vc1 push overflow                            */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC1_PUSH_SHFT 10
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC1_PUSH_MASK 0x0000000000000400

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC3_PUSH                   */
/*   Description:  Fifo 13 vc3 push overflow                            */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC3_PUSH_SHFT 11
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC3_PUSH_MASK 0x0000000000000800

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_CREDIT                 */
/*   Description:  Fifo 02 vc0 credit overflow                          */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_CREDIT_SHFT 12
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_CREDIT_MASK 0x0000000000001000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_CREDIT                 */
/*   Description:  Fifo 02 vc2 credit overflow                          */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_CREDIT_SHFT 13
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_CREDIT_MASK 0x0000000000002000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC0_CREDIT                 */
/*   Description:  Fifo 13 vc0 credit overflow                          */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC0_CREDIT_SHFT 14
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC0_CREDIT_MASK 0x0000000000004000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC2_CREDIT                 */
/*   Description:  Fifo 13 vc2 credit overflow                          */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC2_CREDIT_SHFT 15
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC2_CREDIT_MASK 0x0000000000008000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW0_VC0_CREDIT                       */
/*   Description:  VC0 credit overflow 0                                */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW0_VC0_CREDIT_SHFT 16
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW0_VC0_CREDIT_MASK 0x0000000000010000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW1_VC0_CREDIT                       */
/*   Description:  VC0 credit overflow 1                                */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW1_VC0_CREDIT_SHFT 17
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW1_VC0_CREDIT_MASK 0x0000000000020000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW2_VC0_CREDIT                       */
/*   Description:  VC0 credit overflow 2                                */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW2_VC0_CREDIT_SHFT 18
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW2_VC0_CREDIT_MASK 0x0000000000040000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW0_VC2_CREDIT                       */
/*   Description:  VC2 credit overflow 0                                */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW0_VC2_CREDIT_SHFT 19
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW0_VC2_CREDIT_MASK 0x0000000000080000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW1_VC2_CREDIT                       */
/*   Description:  VC2 credit overflow 1                                */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW1_VC2_CREDIT_SHFT 20
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW1_VC2_CREDIT_MASK 0x0000000000100000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW2_VC2_CREDIT                       */
/*   Description:  VC2 credit overflow 2                                */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW2_VC2_CREDIT_SHFT 21
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW2_VC2_CREDIT_MASK 0x0000000000200000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_DEBIT0                    */
/*   Description:  PI Fifo debit0 overflow                              */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_DEBIT0_SHFT 22
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_DEBIT0_MASK 0x0000000000400000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_DEBIT2                    */
/*   Description:  PI Fifo debit2 overflow                              */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_DEBIT2_SHFT 23
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_DEBIT2_MASK 0x0000000000800000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_DEBIT0                  */
/*   Description:  IILB Fifo debit0 overflow                            */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_DEBIT0_SHFT 24
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_DEBIT0_MASK 0x0000000001000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_DEBIT2                  */
/*   Description:  IILB Fifo debit2 overflow                            */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_DEBIT2_SHFT 25
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_DEBIT2_MASK 0x0000000002000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_DEBIT0                    */
/*   Description:  MD Fifo debit0 overflow                              */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_DEBIT0_SHFT 26
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_DEBIT0_MASK 0x0000000004000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_DEBIT2                    */
/*   Description:  MD Fifo debit2 overflow                              */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_DEBIT2_SHFT 27
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_DEBIT2_MASK 0x0000000008000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT0                    */
/*   Description:  NI Fifo debit0 overflow                              */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT0_SHFT 28
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT0_MASK 0x0000000010000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT1                    */
/*   Description:  NI Fifo debit1 overflow                              */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT1_SHFT 29
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT1_MASK 0x0000000020000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT2                    */
/*   Description:  NI Fifo debit2 overflow                              */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT2_SHFT 30
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT2_MASK 0x0000000040000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT3                    */
/*   Description:  NI Fifo debit3 overflow                              */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT3_SHFT 31
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT3_MASK 0x0000000080000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_POP                   */
/*   Description:  PI Fifo vc0 pop overflow                             */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_POP_SHFT 32
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_POP_MASK 0x0000000100000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_POP                   */
/*   Description:  PI Fifo vc2 pop overflow                             */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_POP_SHFT 33
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_POP_MASK 0x0000000200000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_POP                 */
/*   Description:  IILB Fifo vc0 pop overflow                           */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_POP_SHFT 34
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_POP_MASK 0x0000000400000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_POP                 */
/*   Description:  IILB Fifo vc2 pop overflow                           */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_POP_SHFT 35
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_POP_MASK 0x0000000800000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_POP                   */
/*   Description:  MD Fifo vc0 pop overflow                             */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_POP_SHFT 36
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_POP_MASK 0x0000001000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_POP                   */
/*   Description:  MD Fifo vc2 pop overflow                             */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_POP_SHFT 37
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_POP_MASK 0x0000002000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC0_POP                   */
/*   Description:  NI Fifo vc0 pop overflow                             */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC0_POP_SHFT 38
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC0_POP_MASK 0x0000004000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC2_POP                   */
/*   Description:  NI Fifo vc2 pop overflow                             */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC2_POP_SHFT 39
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC2_POP_MASK 0x0000008000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_PUSH                  */
/*   Description:  PI Fifo vc0 push overflow                            */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_PUSH_SHFT 40
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_PUSH_MASK 0x0000010000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_PUSH                  */
/*   Description:  PI Fifo vc2 push overflow                            */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_PUSH_SHFT 41
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_PUSH_MASK 0x0000020000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_PUSH                */
/*   Description:  IILB Fifo vc0 push overflow                          */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_PUSH_SHFT 42
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_PUSH_MASK 0x0000040000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_PUSH                */
/*   Description:  IILB Fifo vc2 push overflow                          */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_PUSH_SHFT 43
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_PUSH_MASK 0x0000080000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_PUSH                  */
/*   Description:  MD Fifo vc0 push overflow                            */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_PUSH_SHFT 44
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_PUSH_MASK 0x0000100000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_PUSH                  */
/*   Description:  MD Fifo vc2 push overflow                            */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_PUSH_SHFT 45
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_PUSH_MASK 0x0000200000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_CREDIT                */
/*   Description:  PI Fifo vc0 credit overflow                          */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_CREDIT_SHFT 46
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_CREDIT_MASK 0x0000400000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_CREDIT                */
/*   Description:  PI Fifo vc2 credit overflow                          */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_CREDIT_SHFT 47
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_CREDIT_MASK 0x0000800000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_CREDIT              */
/*   Description:  IILB Fifo vc0 credit overflow                        */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_CREDIT_SHFT 48
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_CREDIT_MASK 0x0001000000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_CREDIT              */
/*   Description:  IILB Fifo vc2 credit overflow                        */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_CREDIT_SHFT 49
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_CREDIT_MASK 0x0002000000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_CREDIT                */
/*   Description:  MD Fifo vc0 credit overflow                          */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_CREDIT_SHFT 50
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_CREDIT_MASK 0x0004000000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_CREDIT                */
/*   Description:  MD Fifo vc2 credit overflow                          */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_CREDIT_SHFT 51
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_CREDIT_MASK 0x0008000000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC0_CREDIT                */
/*   Description:  NI Fifo vc0 credit overflow                          */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC0_CREDIT_SHFT 52
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC0_CREDIT_MASK 0x0010000000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC1_CREDIT                */
/*   Description:  NI Fifo vc1 credit overflow                          */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC1_CREDIT_SHFT 53
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC1_CREDIT_MASK 0x0020000000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC2_CREDIT                */
/*   Description:  NI Fifo vc2 credit overflow                          */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC2_CREDIT_SHFT 54
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC2_CREDIT_MASK 0x0040000000000000

/*   SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC3_CREDIT                */
/*   Description:  NI Fifo vc3 credit overflow                          */
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC3_CREDIT_SHFT 55
#define SH_NI0_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC3_CREDIT_MASK 0x0080000000000000

/*   SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO02_VC0                    */
/*   Description:  Fifo02 vc0 tail timeout                              */
#define SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO02_VC0_SHFT 56
#define SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO02_VC0_MASK 0x0100000000000000

/*   SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO02_VC2                    */
/*   Description:  Fifo02 vc2 tail timeout                              */
#define SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO02_VC2_SHFT 57
#define SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO02_VC2_MASK 0x0200000000000000

/*   SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO13_VC1                    */
/*   Description:  Fifo13 vc1 tail timeout                              */
#define SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO13_VC1_SHFT 58
#define SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO13_VC1_MASK 0x0400000000000000

/*   SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO13_VC3                    */
/*   Description:  Fifo13 vc3 tail timeout                              */
#define SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO13_VC3_SHFT 59
#define SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO13_VC3_MASK 0x0800000000000000

/*   SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC0                        */
/*   Description:  NI vc0 tail timeout                                  */
#define SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC0_SHFT 60
#define SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC0_MASK 0x1000000000000000

/*   SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC1                        */
/*   Description:  NI vc1 tail timeout                                  */
#define SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC1_SHFT 61
#define SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC1_MASK 0x2000000000000000

/*   SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC2                        */
/*   Description:  NI vc2 tail timeout                                  */
#define SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC2_SHFT 62
#define SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC2_MASK 0x4000000000000000

/*   SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC3                        */
/*   Description:  NI vc3 tail timeout                                  */
#define SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC3_SHFT 63
#define SH_NI0_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC3_MASK 0x8000000000000000

/* ==================================================================== */
/*               Register "SH_NI0_ERROR_OVERFLOW_1_ALIAS"               */
/*                    ni0 Error Overflow Bits Alias                     */
/* ==================================================================== */

#define SH_NI0_ERROR_OVERFLOW_1_ALIAS            0x0000000150040528

/* ==================================================================== */
/*                  Register "SH_NI0_ERROR_OVERFLOW_2"                  */
/*                       ni0  Error Overflow Bits                       */
/* ==================================================================== */

#define SH_NI0_ERROR_OVERFLOW_2                  0x0000000150040530
#define SH_NI0_ERROR_OVERFLOW_2_MASK             0x7fffffff003fffff
#define SH_NI0_ERROR_OVERFLOW_2_INIT             0x7fffffff003fffff

/*   SH_NI0_ERROR_OVERFLOW_2_ILLEGAL_VCNI                               */
/*   Description:  Illegal VC NI                                        */
#define SH_NI0_ERROR_OVERFLOW_2_ILLEGAL_VCNI_SHFT 0
#define SH_NI0_ERROR_OVERFLOW_2_ILLEGAL_VCNI_MASK 0x0000000000000001

/*   SH_NI0_ERROR_OVERFLOW_2_ILLEGAL_VCPI                               */
/*   Description:  Illegal VC PI                                        */
#define SH_NI0_ERROR_OVERFLOW_2_ILLEGAL_VCPI_SHFT 1
#define SH_NI0_ERROR_OVERFLOW_2_ILLEGAL_VCPI_MASK 0x0000000000000002

/*   SH_NI0_ERROR_OVERFLOW_2_ILLEGAL_VCMD                               */
/*   Description:  Illegal VC MD                                        */
#define SH_NI0_ERROR_OVERFLOW_2_ILLEGAL_VCMD_SHFT 2
#define SH_NI0_ERROR_OVERFLOW_2_ILLEGAL_VCMD_MASK 0x0000000000000004

/*   SH_NI0_ERROR_OVERFLOW_2_ILLEGAL_VCIILB                             */
/*   Description:  Illegal VC IILB                                      */
#define SH_NI0_ERROR_OVERFLOW_2_ILLEGAL_VCIILB_SHFT 3
#define SH_NI0_ERROR_OVERFLOW_2_ILLEGAL_VCIILB_MASK 0x0000000000000008

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_POP                   */
/*   Description:  Fifo 02 vc0 pop underflow                            */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_POP_SHFT 4
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_POP_MASK 0x0000000000000010

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_POP                   */
/*   Description:  Fifo 02 vc2 pop underflow                            */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_POP_SHFT 5
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_POP_MASK 0x0000000000000020

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC1_POP                   */
/*   Description:  Fifo 13 vc1 pop underflow                            */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC1_POP_SHFT 6
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC1_POP_MASK 0x0000000000000040

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC3_POP                   */
/*   Description:  Fifo 13 vc3 pop underflow                            */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC3_POP_SHFT 7
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC3_POP_MASK 0x0000000000000080

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_PUSH                  */
/*   Description:  Fifo 02 vc0 push underflow                           */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_PUSH_SHFT 8
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_PUSH_MASK 0x0000000000000100

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_PUSH                  */
/*   Description:  Fifo 02 vc2 push underflow                           */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_PUSH_SHFT 9
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_PUSH_MASK 0x0000000000000200

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC1_PUSH                  */
/*   Description:  Fifo 13 vc1 push underflow                           */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC1_PUSH_SHFT 10
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC1_PUSH_MASK 0x0000000000000400

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC3_PUSH                  */
/*   Description:  Fifo 13 vc3 push underflow                           */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC3_PUSH_SHFT 11
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC3_PUSH_MASK 0x0000000000000800

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_CREDIT                */
/*   Description:  Fifo 02 vc0 credit underflow                         */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_CREDIT_SHFT 12
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_CREDIT_MASK 0x0000000000001000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_CREDIT                */
/*   Description:  Fifo 02 vc2 credit underflow                         */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_CREDIT_SHFT 13
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_CREDIT_MASK 0x0000000000002000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC0_CREDIT                */
/*   Description:  Fifo 13 vc0 credit underflow                         */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC0_CREDIT_SHFT 14
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC0_CREDIT_MASK 0x0000000000004000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC2_CREDIT                */
/*   Description:  Fifo 13 vc2 credit underflow                         */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC2_CREDIT_SHFT 15
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC2_CREDIT_MASK 0x0000000000008000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW0_VC0_CREDIT                      */
/*   Description:  VC0 credit underflow 0                               */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW0_VC0_CREDIT_SHFT 16
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW0_VC0_CREDIT_MASK 0x0000000000010000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW1_VC0_CREDIT                      */
/*   Description:  VC0 credit underflow 1                               */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW1_VC0_CREDIT_SHFT 17
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW1_VC0_CREDIT_MASK 0x0000000000020000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW2_VC0_CREDIT                      */
/*   Description:  VC0 credit underflow 2                               */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW2_VC0_CREDIT_SHFT 18
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW2_VC0_CREDIT_MASK 0x0000000000040000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW0_VC2_CREDIT                      */
/*   Description:  VC2 credit underflow 0                               */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW0_VC2_CREDIT_SHFT 19
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW0_VC2_CREDIT_MASK 0x0000000000080000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW1_VC2_CREDIT                      */
/*   Description:  VC2 credit underflow 1                               */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW1_VC2_CREDIT_SHFT 20
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW1_VC2_CREDIT_MASK 0x0000000000100000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW2_VC2_CREDIT                      */
/*   Description:  VC2 credit underflow 2                               */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW2_VC2_CREDIT_SHFT 21
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW2_VC2_CREDIT_MASK 0x0000000000200000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_POP                  */
/*   Description:  PI Fifo vc0 pop underflow                            */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_POP_SHFT 32
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_POP_MASK 0x0000000100000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_POP                  */
/*   Description:  PI Fifo vc2 pop underflow                            */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_POP_SHFT 33
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_POP_MASK 0x0000000200000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_POP                */
/*   Description:  IILB Fifo vc0 pop underflow                          */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_POP_SHFT 34
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_POP_MASK 0x0000000400000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_POP                */
/*   Description:  IILB Fifo vc2 pop underflow                          */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_POP_SHFT 35
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_POP_MASK 0x0000000800000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_POP                  */
/*   Description:  MD Fifo vc0 pop underflow                            */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_POP_SHFT 36
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_POP_MASK 0x0000001000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_POP                  */
/*   Description:  MD Fifo vc2 pop underflow                            */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_POP_SHFT 37
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_POP_MASK 0x0000002000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC0_POP                  */
/*   Description:  NI Fifo vc0 pop underflow                            */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC0_POP_SHFT 38
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC0_POP_MASK 0x0000004000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC2_POP                  */
/*   Description:  NI Fifo vc2 pop underflow                            */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC2_POP_SHFT 39
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC2_POP_MASK 0x0000008000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_PUSH                 */
/*   Description:  PI Fifo vc0 push underflow                           */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_PUSH_SHFT 40
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_PUSH_MASK 0x0000010000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_PUSH                 */
/*   Description:  PI Fifo vc2 push underflow                           */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_PUSH_SHFT 41
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_PUSH_MASK 0x0000020000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_PUSH               */
/*   Description:  IILB Fifo vc0 push underflow                         */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_PUSH_SHFT 42
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_PUSH_MASK 0x0000040000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_PUSH               */
/*   Description:  IILB Fifo vc2 push underflow                         */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_PUSH_SHFT 43
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_PUSH_MASK 0x0000080000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_PUSH                 */
/*   Description:  MD Fifo vc0 push underflow                           */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_PUSH_SHFT 44
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_PUSH_MASK 0x0000100000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_PUSH                 */
/*   Description:  MD Fifo vc2 push underflow                           */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_PUSH_SHFT 45
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_PUSH_MASK 0x0000200000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_CREDIT               */
/*   Description:  PI Fifo vc0 credit underflow                         */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_CREDIT_SHFT 46
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_CREDIT_MASK 0x0000400000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_CREDIT               */
/*   Description:  PI Fifo vc2 credit underflow                         */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_CREDIT_SHFT 47
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_CREDIT_MASK 0x0000800000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT             */
/*   Description:  IILB Fifo vc0 credit underflow                       */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT_SHFT 48
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT_MASK 0x0001000000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT             */
/*   Description:  IILB Fifo vc2 credit underflow                       */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT_SHFT 49
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT_MASK 0x0002000000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_CREDIT               */
/*   Description:  MD Fifo vc0 credit underflow                         */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_CREDIT_SHFT 50
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_CREDIT_MASK 0x0004000000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_CREDIT               */
/*   Description:  MD Fifo vc2 credit underflow                         */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_CREDIT_SHFT 51
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_CREDIT_MASK 0x0008000000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC0_CREDIT               */
/*   Description:  NI Fifo vc0 credit underflow                         */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC0_CREDIT_SHFT 52
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC0_CREDIT_MASK 0x0010000000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC1_CREDIT               */
/*   Description:  NI Fifo vc1 credit underflow                         */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC1_CREDIT_SHFT 53
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC1_CREDIT_MASK 0x0020000000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC2_CREDIT               */
/*   Description:  NI Fifo vc2 credit underflow                         */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC2_CREDIT_SHFT 54
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC2_CREDIT_MASK 0x0040000000000000

/*   SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC3_CREDIT               */
/*   Description:  NI Fifo vc3 credit underflow                         */
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC3_CREDIT_SHFT 55
#define SH_NI0_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC3_CREDIT_MASK 0x0080000000000000

/*   SH_NI0_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC0                           */
/*   Description:  llp deadlock vc0                                     */
#define SH_NI0_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC0_SHFT 56
#define SH_NI0_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC0_MASK 0x0100000000000000

/*   SH_NI0_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC1                           */
/*   Description:  llp deadlock vc1                                     */
#define SH_NI0_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC1_SHFT 57
#define SH_NI0_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC1_MASK 0x0200000000000000

/*   SH_NI0_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC2                           */
/*   Description:  llp deadlock vc2                                     */
#define SH_NI0_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC2_SHFT 58
#define SH_NI0_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC2_MASK 0x0400000000000000

/*   SH_NI0_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC3                           */
/*   Description:  llp deadlock vc3                                     */
#define SH_NI0_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC3_SHFT 59
#define SH_NI0_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC3_MASK 0x0800000000000000

/*   SH_NI0_ERROR_OVERFLOW_2_CHIPLET_NOMATCH                            */
/*   Description:  chiplet nomatch                                      */
#define SH_NI0_ERROR_OVERFLOW_2_CHIPLET_NOMATCH_SHFT 60
#define SH_NI0_ERROR_OVERFLOW_2_CHIPLET_NOMATCH_MASK 0x1000000000000000

/*   SH_NI0_ERROR_OVERFLOW_2_LUT_READ_ERROR                             */
/*   Description:  LUT Read Error                                       */
#define SH_NI0_ERROR_OVERFLOW_2_LUT_READ_ERROR_SHFT 61
#define SH_NI0_ERROR_OVERFLOW_2_LUT_READ_ERROR_MASK 0x2000000000000000

/*   SH_NI0_ERROR_OVERFLOW_2_RETRY_TIMEOUT_ERROR                        */
/*   Description:  Retry Timeout Error                                  */
#define SH_NI0_ERROR_OVERFLOW_2_RETRY_TIMEOUT_ERROR_SHFT 62
#define SH_NI0_ERROR_OVERFLOW_2_RETRY_TIMEOUT_ERROR_MASK 0x4000000000000000

/* ==================================================================== */
/*               Register "SH_NI0_ERROR_OVERFLOW_2_ALIAS"               */
/*                    ni0 Error Overflow Bits Alias                     */
/* ==================================================================== */

#define SH_NI0_ERROR_OVERFLOW_2_ALIAS            0x0000000150040538

/* ==================================================================== */
/*                    Register "SH_NI0_ERROR_MASK_1"                    */
/*                         ni0  Error Mask Bits                         */
/* ==================================================================== */

#define SH_NI0_ERROR_MASK_1                      0x0000000150040540
#define SH_NI0_ERROR_MASK_1_MASK                 0xffffffffffffffff
#define SH_NI0_ERROR_MASK_1_INIT                 0xffffffffffffffff

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_DEBIT0                         */
/*   Description:  Fifo 02 debit0 overflow                              */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_DEBIT0_SHFT 0
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_DEBIT0_MASK 0x0000000000000001

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_DEBIT2                         */
/*   Description:  Fifo 02 debit2 overflow                              */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_DEBIT2_SHFT 1
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_DEBIT2_MASK 0x0000000000000002

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_DEBIT0                         */
/*   Description:  Fifo 13 debit0 overflow                              */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_DEBIT0_SHFT 2
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_DEBIT0_MASK 0x0000000000000004

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_DEBIT2                         */
/*   Description:  Fifo 13 debit2 overflow                              */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_DEBIT2_SHFT 3
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_DEBIT2_MASK 0x0000000000000008

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_POP                        */
/*   Description:  Fifo 02 vc0 pop overflow                             */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_POP_SHFT 4
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_POP_MASK 0x0000000000000010

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_POP                        */
/*   Description:  Fifo 02 vc2 pop overflow                             */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_POP_SHFT 5
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_POP_MASK 0x0000000000000020

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC1_POP                        */
/*   Description:  Fifo 13 vc1 pop overflow                             */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC1_POP_SHFT 6
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC1_POP_MASK 0x0000000000000040

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC3_POP                        */
/*   Description:  Fifo 13 vc3 pop overflow                             */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC3_POP_SHFT 7
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC3_POP_MASK 0x0000000000000080

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_PUSH                       */
/*   Description:  Fifo 02 vc0 push overflow                            */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_PUSH_SHFT 8
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_PUSH_MASK 0x0000000000000100

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_PUSH                       */
/*   Description:  Fifo 02 vc2 push overflow                            */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_PUSH_SHFT 9
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_PUSH_MASK 0x0000000000000200

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC1_PUSH                       */
/*   Description:  Fifo 13 vc1 push overflow                            */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC1_PUSH_SHFT 10
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC1_PUSH_MASK 0x0000000000000400

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC3_PUSH                       */
/*   Description:  Fifo 13 vc3 push overflow                            */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC3_PUSH_SHFT 11
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC3_PUSH_MASK 0x0000000000000800

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_CREDIT                     */
/*   Description:  Fifo 02 vc0 credit overflow                          */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_CREDIT_SHFT 12
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_CREDIT_MASK 0x0000000000001000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_CREDIT                     */
/*   Description:  Fifo 02 vc2 credit overflow                          */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_CREDIT_SHFT 13
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_CREDIT_MASK 0x0000000000002000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC0_CREDIT                     */
/*   Description:  Fifo 13 vc0 credit overflow                          */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC0_CREDIT_SHFT 14
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC0_CREDIT_MASK 0x0000000000004000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC2_CREDIT                     */
/*   Description:  Fifo 13 vc2 credit overflow                          */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC2_CREDIT_SHFT 15
#define SH_NI0_ERROR_MASK_1_OVERFLOW_FIFO13_VC2_CREDIT_MASK 0x0000000000008000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW0_VC0_CREDIT                           */
/*   Description:  VC0 credit overflow 0                                */
#define SH_NI0_ERROR_MASK_1_OVERFLOW0_VC0_CREDIT_SHFT 16
#define SH_NI0_ERROR_MASK_1_OVERFLOW0_VC0_CREDIT_MASK 0x0000000000010000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW1_VC0_CREDIT                           */
/*   Description:  VC0 credit overflow 1                                */
#define SH_NI0_ERROR_MASK_1_OVERFLOW1_VC0_CREDIT_SHFT 17
#define SH_NI0_ERROR_MASK_1_OVERFLOW1_VC0_CREDIT_MASK 0x0000000000020000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW2_VC0_CREDIT                           */
/*   Description:  VC0 credit overflow 2                                */
#define SH_NI0_ERROR_MASK_1_OVERFLOW2_VC0_CREDIT_SHFT 18
#define SH_NI0_ERROR_MASK_1_OVERFLOW2_VC0_CREDIT_MASK 0x0000000000040000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW0_VC2_CREDIT                           */
/*   Description:  VC2 credit overflow 0                                */
#define SH_NI0_ERROR_MASK_1_OVERFLOW0_VC2_CREDIT_SHFT 19
#define SH_NI0_ERROR_MASK_1_OVERFLOW0_VC2_CREDIT_MASK 0x0000000000080000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW1_VC2_CREDIT                           */
/*   Description:  VC2 credit overflow 1                                */
#define SH_NI0_ERROR_MASK_1_OVERFLOW1_VC2_CREDIT_SHFT 20
#define SH_NI0_ERROR_MASK_1_OVERFLOW1_VC2_CREDIT_MASK 0x0000000000100000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW2_VC2_CREDIT                           */
/*   Description:  VC2 credit overflow 2                                */
#define SH_NI0_ERROR_MASK_1_OVERFLOW2_VC2_CREDIT_SHFT 21
#define SH_NI0_ERROR_MASK_1_OVERFLOW2_VC2_CREDIT_MASK 0x0000000000200000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_DEBIT0                        */
/*   Description:  PI Fifo debit0 overflow                              */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_DEBIT0_SHFT 22
#define SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_DEBIT0_MASK 0x0000000000400000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_DEBIT2                        */
/*   Description:  PI Fifo debit2 overflow                              */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_DEBIT2_SHFT 23
#define SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_DEBIT2_MASK 0x0000000000800000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_DEBIT0                      */
/*   Description:  IILB Fifo debit0 overflow                            */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_DEBIT0_SHFT 24
#define SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_DEBIT0_MASK 0x0000000001000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_DEBIT2                      */
/*   Description:  IILB Fifo debit2 overflow                            */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_DEBIT2_SHFT 25
#define SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_DEBIT2_MASK 0x0000000002000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_DEBIT0                        */
/*   Description:  MD Fifo debit0 overflow                              */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_DEBIT0_SHFT 26
#define SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_DEBIT0_MASK 0x0000000004000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_DEBIT2                        */
/*   Description:  MD Fifo debit2 overflow                              */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_DEBIT2_SHFT 27
#define SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_DEBIT2_MASK 0x0000000008000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT0                        */
/*   Description:  NI Fifo debit0 overflow                              */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT0_SHFT 28
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT0_MASK 0x0000000010000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT1                        */
/*   Description:  NI Fifo debit1 overflow                              */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT1_SHFT 29
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT1_MASK 0x0000000020000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT2                        */
/*   Description:  NI Fifo debit2 overflow                              */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT2_SHFT 30
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT2_MASK 0x0000000040000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT3                        */
/*   Description:  NI Fifo debit3 overflow                              */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT3_SHFT 31
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT3_MASK 0x0000000080000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_POP                       */
/*   Description:  PI Fifo vc0 pop overflow                             */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_POP_SHFT 32
#define SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_POP_MASK 0x0000000100000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_POP                       */
/*   Description:  PI Fifo vc2 pop overflow                             */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_POP_SHFT 33
#define SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_POP_MASK 0x0000000200000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_POP                     */
/*   Description:  IILB Fifo vc0 pop overflow                           */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_POP_SHFT 34
#define SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_POP_MASK 0x0000000400000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_POP                     */
/*   Description:  IILB Fifo vc2 pop overflow                           */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_POP_SHFT 35
#define SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_POP_MASK 0x0000000800000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_POP                       */
/*   Description:  MD Fifo vc0 pop overflow                             */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_POP_SHFT 36
#define SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_POP_MASK 0x0000001000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_POP                       */
/*   Description:  MD Fifo vc2 pop overflow                             */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_POP_SHFT 37
#define SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_POP_MASK 0x0000002000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC0_POP                       */
/*   Description:  NI Fifo vc0 pop overflow                             */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC0_POP_SHFT 38
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC0_POP_MASK 0x0000004000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC2_POP                       */
/*   Description:  NI Fifo vc2 pop overflow                             */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC2_POP_SHFT 39
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC2_POP_MASK 0x0000008000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_PUSH                      */
/*   Description:  PI Fifo vc0 push overflow                            */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_PUSH_SHFT 40
#define SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_PUSH_MASK 0x0000010000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_PUSH                      */
/*   Description:  PI Fifo vc2 push overflow                            */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_PUSH_SHFT 41
#define SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_PUSH_MASK 0x0000020000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_PUSH                    */
/*   Description:  IILB Fifo vc0 push overflow                          */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_PUSH_SHFT 42
#define SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_PUSH_MASK 0x0000040000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_PUSH                    */
/*   Description:  IILB Fifo vc2 push overflow                          */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_PUSH_SHFT 43
#define SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_PUSH_MASK 0x0000080000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_PUSH                      */
/*   Description:  MD Fifo vc0 push overflow                            */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_PUSH_SHFT 44
#define SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_PUSH_MASK 0x0000100000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_PUSH                      */
/*   Description:  MD Fifo vc2 push overflow                            */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_PUSH_SHFT 45
#define SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_PUSH_MASK 0x0000200000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_CREDIT                    */
/*   Description:  PI Fifo vc0 credit overflow                          */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_CREDIT_SHFT 46
#define SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_CREDIT_MASK 0x0000400000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_CREDIT                    */
/*   Description:  PI Fifo vc2 credit overflow                          */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_CREDIT_SHFT 47
#define SH_NI0_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_CREDIT_MASK 0x0000800000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_CREDIT                  */
/*   Description:  IILB Fifo vc0 credit overflow                        */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_CREDIT_SHFT 48
#define SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_CREDIT_MASK 0x0001000000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_CREDIT                  */
/*   Description:  IILB Fifo vc2 credit overflow                        */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_CREDIT_SHFT 49
#define SH_NI0_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_CREDIT_MASK 0x0002000000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_CREDIT                    */
/*   Description:  MD Fifo vc0 credit overflow                          */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_CREDIT_SHFT 50
#define SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_CREDIT_MASK 0x0004000000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_CREDIT                    */
/*   Description:  MD Fifo vc2 credit overflow                          */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_CREDIT_SHFT 51
#define SH_NI0_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_CREDIT_MASK 0x0008000000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC0_CREDIT                    */
/*   Description:  NI Fifo vc0 credit overflow                          */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC0_CREDIT_SHFT 52
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC0_CREDIT_MASK 0x0010000000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC1_CREDIT                    */
/*   Description:  NI Fifo vc1 credit overflow                          */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC1_CREDIT_SHFT 53
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC1_CREDIT_MASK 0x0020000000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC2_CREDIT                    */
/*   Description:  NI Fifo vc2 credit overflow                          */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC2_CREDIT_SHFT 54
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC2_CREDIT_MASK 0x0040000000000000

/*   SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC3_CREDIT                    */
/*   Description:  NI Fifo vc3 credit overflow                          */
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC3_CREDIT_SHFT 55
#define SH_NI0_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC3_CREDIT_MASK 0x0080000000000000

/*   SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_FIFO02_VC0                        */
/*   Description:  Fifo02 vc0 tail timeout                              */
#define SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_FIFO02_VC0_SHFT 56
#define SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_FIFO02_VC0_MASK 0x0100000000000000

/*   SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_FIFO02_VC2                        */
/*   Description:  Fifo02 vc2 tail timeout                              */
#define SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_FIFO02_VC2_SHFT 57
#define SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_FIFO02_VC2_MASK 0x0200000000000000

/*   SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_FIFO13_VC1                        */
/*   Description:  Fifo13 vc1 tail timeout                              */
#define SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_FIFO13_VC1_SHFT 58
#define SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_FIFO13_VC1_MASK 0x0400000000000000

/*   SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_FIFO13_VC3                        */
/*   Description:  Fifo13 vc3 tail timeout                              */
#define SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_FIFO13_VC3_SHFT 59
#define SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_FIFO13_VC3_MASK 0x0800000000000000

/*   SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC0                            */
/*   Description:  NI vc0 tail timeout                                  */
#define SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC0_SHFT 60
#define SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC0_MASK 0x1000000000000000

/*   SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC1                            */
/*   Description:  NI vc1 tail timeout                                  */
#define SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC1_SHFT 61
#define SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC1_MASK 0x2000000000000000

/*   SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC2                            */
/*   Description:  NI vc2 tail timeout                                  */
#define SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC2_SHFT 62
#define SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC2_MASK 0x4000000000000000

/*   SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC3                            */
/*   Description:  NI vc3 tail timeout                                  */
#define SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC3_SHFT 63
#define SH_NI0_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC3_MASK 0x8000000000000000

/* ==================================================================== */
/*                    Register "SH_NI0_ERROR_MASK_2"                    */
/*                         ni0  Error Mask Bits                         */
/* ==================================================================== */

#define SH_NI0_ERROR_MASK_2                      0x0000000150040550
#define SH_NI0_ERROR_MASK_2_MASK                 0x7fffffff003fffff
#define SH_NI0_ERROR_MASK_2_INIT                 0x7fffffff003fffff

/*   SH_NI0_ERROR_MASK_2_ILLEGAL_VCNI                                   */
/*   Description:  Illegal VC NI                                        */
#define SH_NI0_ERROR_MASK_2_ILLEGAL_VCNI_SHFT    0
#define SH_NI0_ERROR_MASK_2_ILLEGAL_VCNI_MASK    0x0000000000000001

/*   SH_NI0_ERROR_MASK_2_ILLEGAL_VCPI                                   */
/*   Description:  Illegal VC PI                                        */
#define SH_NI0_ERROR_MASK_2_ILLEGAL_VCPI_SHFT    1
#define SH_NI0_ERROR_MASK_2_ILLEGAL_VCPI_MASK    0x0000000000000002

/*   SH_NI0_ERROR_MASK_2_ILLEGAL_VCMD                                   */
/*   Description:  Illegal VC MD                                        */
#define SH_NI0_ERROR_MASK_2_ILLEGAL_VCMD_SHFT    2
#define SH_NI0_ERROR_MASK_2_ILLEGAL_VCMD_MASK    0x0000000000000004

/*   SH_NI0_ERROR_MASK_2_ILLEGAL_VCIILB                                 */
/*   Description:  Illegal VC IILB                                      */
#define SH_NI0_ERROR_MASK_2_ILLEGAL_VCIILB_SHFT  3
#define SH_NI0_ERROR_MASK_2_ILLEGAL_VCIILB_MASK  0x0000000000000008

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_POP                       */
/*   Description:  Fifo 02 vc0 pop underflow                            */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_POP_SHFT 4
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_POP_MASK 0x0000000000000010

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_POP                       */
/*   Description:  Fifo 02 vc2 pop underflow                            */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_POP_SHFT 5
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_POP_MASK 0x0000000000000020

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC1_POP                       */
/*   Description:  Fifo 13 vc1 pop underflow                            */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC1_POP_SHFT 6
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC1_POP_MASK 0x0000000000000040

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC3_POP                       */
/*   Description:  Fifo 13 vc3 pop underflow                            */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC3_POP_SHFT 7
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC3_POP_MASK 0x0000000000000080

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_PUSH                      */
/*   Description:  Fifo 02 vc0 push underflow                           */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_PUSH_SHFT 8
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_PUSH_MASK 0x0000000000000100

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_PUSH                      */
/*   Description:  Fifo 02 vc2 push underflow                           */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_PUSH_SHFT 9
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_PUSH_MASK 0x0000000000000200

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC1_PUSH                      */
/*   Description:  Fifo 13 vc1 push underflow                           */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC1_PUSH_SHFT 10
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC1_PUSH_MASK 0x0000000000000400

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC3_PUSH                      */
/*   Description:  Fifo 13 vc3 push underflow                           */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC3_PUSH_SHFT 11
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC3_PUSH_MASK 0x0000000000000800

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_CREDIT                    */
/*   Description:  Fifo 02 vc0 credit underflow                         */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_CREDIT_SHFT 12
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_CREDIT_MASK 0x0000000000001000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_CREDIT                    */
/*   Description:  Fifo 02 vc2 credit underflow                         */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_CREDIT_SHFT 13
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_CREDIT_MASK 0x0000000000002000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC0_CREDIT                    */
/*   Description:  Fifo 13 vc0 credit underflow                         */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC0_CREDIT_SHFT 14
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC0_CREDIT_MASK 0x0000000000004000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC2_CREDIT                    */
/*   Description:  Fifo 13 vc2 credit underflow                         */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC2_CREDIT_SHFT 15
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_FIFO13_VC2_CREDIT_MASK 0x0000000000008000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW0_VC0_CREDIT                          */
/*   Description:  VC0 credit underflow 0                               */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW0_VC0_CREDIT_SHFT 16
#define SH_NI0_ERROR_MASK_2_UNDERFLOW0_VC0_CREDIT_MASK 0x0000000000010000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW1_VC0_CREDIT                          */
/*   Description:  VC0 credit underflow 1                               */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW1_VC0_CREDIT_SHFT 17
#define SH_NI0_ERROR_MASK_2_UNDERFLOW1_VC0_CREDIT_MASK 0x0000000000020000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW2_VC0_CREDIT                          */
/*   Description:  VC0 credit underflow 2                               */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW2_VC0_CREDIT_SHFT 18
#define SH_NI0_ERROR_MASK_2_UNDERFLOW2_VC0_CREDIT_MASK 0x0000000000040000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW0_VC2_CREDIT                          */
/*   Description:  VC2 credit underflow 0                               */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW0_VC2_CREDIT_SHFT 19
#define SH_NI0_ERROR_MASK_2_UNDERFLOW0_VC2_CREDIT_MASK 0x0000000000080000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW1_VC2_CREDIT                          */
/*   Description:  VC2 credit underflow 1                               */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW1_VC2_CREDIT_SHFT 20
#define SH_NI0_ERROR_MASK_2_UNDERFLOW1_VC2_CREDIT_MASK 0x0000000000100000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW2_VC2_CREDIT                          */
/*   Description:  VC2 credit underflow 2                               */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW2_VC2_CREDIT_SHFT 21
#define SH_NI0_ERROR_MASK_2_UNDERFLOW2_VC2_CREDIT_MASK 0x0000000000200000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_POP                      */
/*   Description:  PI Fifo vc0 pop underflow                            */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_POP_SHFT 32
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_POP_MASK 0x0000000100000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_POP                      */
/*   Description:  PI Fifo vc2 pop underflow                            */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_POP_SHFT 33
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_POP_MASK 0x0000000200000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_POP                    */
/*   Description:  IILB Fifo vc0 pop underflow                          */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_POP_SHFT 34
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_POP_MASK 0x0000000400000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_POP                    */
/*   Description:  IILB Fifo vc2 pop underflow                          */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_POP_SHFT 35
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_POP_MASK 0x0000000800000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_POP                      */
/*   Description:  MD Fifo vc0 pop underflow                            */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_POP_SHFT 36
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_POP_MASK 0x0000001000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_POP                      */
/*   Description:  MD Fifo vc2 pop underflow                            */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_POP_SHFT 37
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_POP_MASK 0x0000002000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC0_POP                      */
/*   Description:  NI Fifo vc0 pop underflow                            */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC0_POP_SHFT 38
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC0_POP_MASK 0x0000004000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC2_POP                      */
/*   Description:  NI Fifo vc2 pop underflow                            */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC2_POP_SHFT 39
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC2_POP_MASK 0x0000008000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_PUSH                     */
/*   Description:  PI Fifo vc0 push underflow                           */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_PUSH_SHFT 40
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_PUSH_MASK 0x0000010000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_PUSH                     */
/*   Description:  PI Fifo vc2 push underflow                           */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_PUSH_SHFT 41
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_PUSH_MASK 0x0000020000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_PUSH                   */
/*   Description:  IILB Fifo vc0 push underflow                         */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_PUSH_SHFT 42
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_PUSH_MASK 0x0000040000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_PUSH                   */
/*   Description:  IILB Fifo vc2 push underflow                         */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_PUSH_SHFT 43
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_PUSH_MASK 0x0000080000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_PUSH                     */
/*   Description:  MD Fifo vc0 push underflow                           */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_PUSH_SHFT 44
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_PUSH_MASK 0x0000100000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_PUSH                     */
/*   Description:  MD Fifo vc2 push underflow                           */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_PUSH_SHFT 45
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_PUSH_MASK 0x0000200000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_CREDIT                   */
/*   Description:  PI Fifo vc0 credit underflow                         */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_CREDIT_SHFT 46
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_CREDIT_MASK 0x0000400000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_CREDIT                   */
/*   Description:  PI Fifo vc2 credit underflow                         */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_CREDIT_SHFT 47
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_CREDIT_MASK 0x0000800000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT                 */
/*   Description:  IILB Fifo vc0 credit underflow                       */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT_SHFT 48
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT_MASK 0x0001000000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT                 */
/*   Description:  IILB Fifo vc2 credit underflow                       */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT_SHFT 49
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT_MASK 0x0002000000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_CREDIT                   */
/*   Description:  MD Fifo vc0 credit underflow                         */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_CREDIT_SHFT 50
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_CREDIT_MASK 0x0004000000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_CREDIT                   */
/*   Description:  MD Fifo vc2 credit underflow                         */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_CREDIT_SHFT 51
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_CREDIT_MASK 0x0008000000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC0_CREDIT                   */
/*   Description:  NI Fifo vc0 credit underflow                         */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC0_CREDIT_SHFT 52
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC0_CREDIT_MASK 0x0010000000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC1_CREDIT                   */
/*   Description:  NI Fifo vc1 credit underflow                         */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC1_CREDIT_SHFT 53
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC1_CREDIT_MASK 0x0020000000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC2_CREDIT                   */
/*   Description:  NI Fifo vc2 credit underflow                         */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC2_CREDIT_SHFT 54
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC2_CREDIT_MASK 0x0040000000000000

/*   SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC3_CREDIT                   */
/*   Description:  NI Fifo vc3 credit underflow                         */
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC3_CREDIT_SHFT 55
#define SH_NI0_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC3_CREDIT_MASK 0x0080000000000000

/*   SH_NI0_ERROR_MASK_2_LLP_DEADLOCK_VC0                               */
/*   Description:  llp deadlock vc0                                     */
#define SH_NI0_ERROR_MASK_2_LLP_DEADLOCK_VC0_SHFT 56
#define SH_NI0_ERROR_MASK_2_LLP_DEADLOCK_VC0_MASK 0x0100000000000000

/*   SH_NI0_ERROR_MASK_2_LLP_DEADLOCK_VC1                               */
/*   Description:  llp deadlock vc1                                     */
#define SH_NI0_ERROR_MASK_2_LLP_DEADLOCK_VC1_SHFT 57
#define SH_NI0_ERROR_MASK_2_LLP_DEADLOCK_VC1_MASK 0x0200000000000000

/*   SH_NI0_ERROR_MASK_2_LLP_DEADLOCK_VC2                               */
/*   Description:  llp deadlock vc2                                     */
#define SH_NI0_ERROR_MASK_2_LLP_DEADLOCK_VC2_SHFT 58
#define SH_NI0_ERROR_MASK_2_LLP_DEADLOCK_VC2_MASK 0x0400000000000000

/*   SH_NI0_ERROR_MASK_2_LLP_DEADLOCK_VC3                               */
/*   Description:  llp deadlock vc3                                     */
#define SH_NI0_ERROR_MASK_2_LLP_DEADLOCK_VC3_SHFT 59
#define SH_NI0_ERROR_MASK_2_LLP_DEADLOCK_VC3_MASK 0x0800000000000000

/*   SH_NI0_ERROR_MASK_2_CHIPLET_NOMATCH                                */
/*   Description:  chiplet nomatch                                      */
#define SH_NI0_ERROR_MASK_2_CHIPLET_NOMATCH_SHFT 60
#define SH_NI0_ERROR_MASK_2_CHIPLET_NOMATCH_MASK 0x1000000000000000

/*   SH_NI0_ERROR_MASK_2_LUT_READ_ERROR                                 */
/*   Description:  LUT Read Error                                       */
#define SH_NI0_ERROR_MASK_2_LUT_READ_ERROR_SHFT  61
#define SH_NI0_ERROR_MASK_2_LUT_READ_ERROR_MASK  0x2000000000000000

/*   SH_NI0_ERROR_MASK_2_RETRY_TIMEOUT_ERROR                            */
/*   Description:  Retry Timeout Error                                  */
#define SH_NI0_ERROR_MASK_2_RETRY_TIMEOUT_ERROR_SHFT 62
#define SH_NI0_ERROR_MASK_2_RETRY_TIMEOUT_ERROR_MASK 0x4000000000000000

/* ==================================================================== */
/*                   Register "SH_NI0_FIRST_ERROR_1"                    */
/*                        ni0  First Error Bits                         */
/* ==================================================================== */

#define SH_NI0_FIRST_ERROR_1                     0x0000000150040560
#define SH_NI0_FIRST_ERROR_1_MASK                0xffffffffffffffff
#define SH_NI0_FIRST_ERROR_1_INIT                0xffffffffffffffff

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_DEBIT0                        */
/*   Description:  Fifo 02 debit0 overflow                              */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_DEBIT0_SHFT 0
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_DEBIT0_MASK 0x0000000000000001

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_DEBIT2                        */
/*   Description:  Fifo 02 debit2 overflow                              */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_DEBIT2_SHFT 1
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_DEBIT2_MASK 0x0000000000000002

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_DEBIT0                        */
/*   Description:  Fifo 13 debit0 overflow                              */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_DEBIT0_SHFT 2
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_DEBIT0_MASK 0x0000000000000004

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_DEBIT2                        */
/*   Description:  Fifo 13 debit2 overflow                              */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_DEBIT2_SHFT 3
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_DEBIT2_MASK 0x0000000000000008

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_POP                       */
/*   Description:  Fifo 02 vc0 pop overflow                             */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_POP_SHFT 4
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_POP_MASK 0x0000000000000010

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_POP                       */
/*   Description:  Fifo 02 vc2 pop overflow                             */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_POP_SHFT 5
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_POP_MASK 0x0000000000000020

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC1_POP                       */
/*   Description:  Fifo 13 vc1 pop overflow                             */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC1_POP_SHFT 6
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC1_POP_MASK 0x0000000000000040

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC3_POP                       */
/*   Description:  Fifo 13 vc3 pop overflow                             */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC3_POP_SHFT 7
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC3_POP_MASK 0x0000000000000080

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_PUSH                      */
/*   Description:  Fifo 02 vc0 push overflow                            */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_PUSH_SHFT 8
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_PUSH_MASK 0x0000000000000100

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_PUSH                      */
/*   Description:  Fifo 02 vc2 push overflow                            */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_PUSH_SHFT 9
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_PUSH_MASK 0x0000000000000200

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC1_PUSH                      */
/*   Description:  Fifo 13 vc1 push overflow                            */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC1_PUSH_SHFT 10
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC1_PUSH_MASK 0x0000000000000400

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC3_PUSH                      */
/*   Description:  Fifo 13 vc3 push overflow                            */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC3_PUSH_SHFT 11
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC3_PUSH_MASK 0x0000000000000800

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_CREDIT                    */
/*   Description:  Fifo 02 vc0 credit overflow                          */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_CREDIT_SHFT 12
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_CREDIT_MASK 0x0000000000001000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_CREDIT                    */
/*   Description:  Fifo 02 vc2 credit overflow                          */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_CREDIT_SHFT 13
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_CREDIT_MASK 0x0000000000002000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC0_CREDIT                    */
/*   Description:  Fifo 13 vc0 credit overflow                          */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC0_CREDIT_SHFT 14
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC0_CREDIT_MASK 0x0000000000004000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC2_CREDIT                    */
/*   Description:  Fifo 13 vc2 credit overflow                          */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC2_CREDIT_SHFT 15
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_FIFO13_VC2_CREDIT_MASK 0x0000000000008000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW0_VC0_CREDIT                          */
/*   Description:  VC0 credit overflow 0                                */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW0_VC0_CREDIT_SHFT 16
#define SH_NI0_FIRST_ERROR_1_OVERFLOW0_VC0_CREDIT_MASK 0x0000000000010000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW1_VC0_CREDIT                          */
/*   Description:  VC0 credit overflow 1                                */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW1_VC0_CREDIT_SHFT 17
#define SH_NI0_FIRST_ERROR_1_OVERFLOW1_VC0_CREDIT_MASK 0x0000000000020000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW2_VC0_CREDIT                          */
/*   Description:  VC0 credit overflow 2                                */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW2_VC0_CREDIT_SHFT 18
#define SH_NI0_FIRST_ERROR_1_OVERFLOW2_VC0_CREDIT_MASK 0x0000000000040000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW0_VC2_CREDIT                          */
/*   Description:  VC2 credit overflow 0                                */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW0_VC2_CREDIT_SHFT 19
#define SH_NI0_FIRST_ERROR_1_OVERFLOW0_VC2_CREDIT_MASK 0x0000000000080000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW1_VC2_CREDIT                          */
/*   Description:  VC2 credit overflow 1                                */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW1_VC2_CREDIT_SHFT 20
#define SH_NI0_FIRST_ERROR_1_OVERFLOW1_VC2_CREDIT_MASK 0x0000000000100000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW2_VC2_CREDIT                          */
/*   Description:  VC2 credit overflow 2                                */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW2_VC2_CREDIT_SHFT 21
#define SH_NI0_FIRST_ERROR_1_OVERFLOW2_VC2_CREDIT_MASK 0x0000000000200000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_DEBIT0                       */
/*   Description:  PI Fifo debit0 overflow                              */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_DEBIT0_SHFT 22
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_DEBIT0_MASK 0x0000000000400000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_DEBIT2                       */
/*   Description:  PI Fifo debit2 overflow                              */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_DEBIT2_SHFT 23
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_DEBIT2_MASK 0x0000000000800000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_DEBIT0                     */
/*   Description:  IILB Fifo debit0 overflow                            */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_DEBIT0_SHFT 24
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_DEBIT0_MASK 0x0000000001000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_DEBIT2                     */
/*   Description:  IILB Fifo debit2 overflow                            */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_DEBIT2_SHFT 25
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_DEBIT2_MASK 0x0000000002000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_DEBIT0                       */
/*   Description:  MD Fifo debit0 overflow                              */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_DEBIT0_SHFT 26
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_DEBIT0_MASK 0x0000000004000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_DEBIT2                       */
/*   Description:  MD Fifo debit2 overflow                              */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_DEBIT2_SHFT 27
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_DEBIT2_MASK 0x0000000008000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT0                       */
/*   Description:  NI Fifo debit0 overflow                              */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT0_SHFT 28
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT0_MASK 0x0000000010000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT1                       */
/*   Description:  NI Fifo debit1 overflow                              */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT1_SHFT 29
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT1_MASK 0x0000000020000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT2                       */
/*   Description:  NI Fifo debit2 overflow                              */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT2_SHFT 30
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT2_MASK 0x0000000040000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT3                       */
/*   Description:  NI Fifo debit3 overflow                              */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT3_SHFT 31
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT3_MASK 0x0000000080000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC0_POP                      */
/*   Description:  PI Fifo vc0 pop overflow                             */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC0_POP_SHFT 32
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC0_POP_MASK 0x0000000100000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC2_POP                      */
/*   Description:  PI Fifo vc2 pop overflow                             */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC2_POP_SHFT 33
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC2_POP_MASK 0x0000000200000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC0_POP                    */
/*   Description:  IILB Fifo vc0 pop overflow                           */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC0_POP_SHFT 34
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC0_POP_MASK 0x0000000400000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC2_POP                    */
/*   Description:  IILB Fifo vc2 pop overflow                           */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC2_POP_SHFT 35
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC2_POP_MASK 0x0000000800000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC0_POP                      */
/*   Description:  MD Fifo vc0 pop overflow                             */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC0_POP_SHFT 36
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC0_POP_MASK 0x0000001000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC2_POP                      */
/*   Description:  MD Fifo vc2 pop overflow                             */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC2_POP_SHFT 37
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC2_POP_MASK 0x0000002000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC0_POP                      */
/*   Description:  NI Fifo vc0 pop overflow                             */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC0_POP_SHFT 38
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC0_POP_MASK 0x0000004000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC2_POP                      */
/*   Description:  NI Fifo vc2 pop overflow                             */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC2_POP_SHFT 39
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC2_POP_MASK 0x0000008000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC0_PUSH                     */
/*   Description:  PI Fifo vc0 push overflow                            */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC0_PUSH_SHFT 40
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC0_PUSH_MASK 0x0000010000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC2_PUSH                     */
/*   Description:  PI Fifo vc2 push overflow                            */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC2_PUSH_SHFT 41
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC2_PUSH_MASK 0x0000020000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC0_PUSH                   */
/*   Description:  IILB Fifo vc0 push overflow                          */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC0_PUSH_SHFT 42
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC0_PUSH_MASK 0x0000040000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC2_PUSH                   */
/*   Description:  IILB Fifo vc2 push overflow                          */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC2_PUSH_SHFT 43
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC2_PUSH_MASK 0x0000080000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC0_PUSH                     */
/*   Description:  MD Fifo vc0 push overflow                            */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC0_PUSH_SHFT 44
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC0_PUSH_MASK 0x0000100000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC2_PUSH                     */
/*   Description:  MD Fifo vc2 push overflow                            */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC2_PUSH_SHFT 45
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC2_PUSH_MASK 0x0000200000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC0_CREDIT                   */
/*   Description:  PI Fifo vc0 credit overflow                          */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC0_CREDIT_SHFT 46
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC0_CREDIT_MASK 0x0000400000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC2_CREDIT                   */
/*   Description:  PI Fifo vc2 credit overflow                          */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC2_CREDIT_SHFT 47
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC2_CREDIT_MASK 0x0000800000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC0_CREDIT                 */
/*   Description:  IILB Fifo vc0 credit overflow                        */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC0_CREDIT_SHFT 48
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC0_CREDIT_MASK 0x0001000000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC2_CREDIT                 */
/*   Description:  IILB Fifo vc2 credit overflow                        */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC2_CREDIT_SHFT 49
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC2_CREDIT_MASK 0x0002000000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC0_CREDIT                   */
/*   Description:  MD Fifo vc0 credit overflow                          */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC0_CREDIT_SHFT 50
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC0_CREDIT_MASK 0x0004000000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC2_CREDIT                   */
/*   Description:  MD Fifo vc2 credit overflow                          */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC2_CREDIT_SHFT 51
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC2_CREDIT_MASK 0x0008000000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC0_CREDIT                   */
/*   Description:  NI Fifo vc0 credit overflow                          */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC0_CREDIT_SHFT 52
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC0_CREDIT_MASK 0x0010000000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC1_CREDIT                   */
/*   Description:  NI Fifo vc1 credit overflow                          */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC1_CREDIT_SHFT 53
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC1_CREDIT_MASK 0x0020000000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC2_CREDIT                   */
/*   Description:  NI Fifo vc2 credit overflow                          */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC2_CREDIT_SHFT 54
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC2_CREDIT_MASK 0x0040000000000000

/*   SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC3_CREDIT                   */
/*   Description:  NI Fifo vc3 credit overflow                          */
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC3_CREDIT_SHFT 55
#define SH_NI0_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC3_CREDIT_MASK 0x0080000000000000

/*   SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_FIFO02_VC0                       */
/*   Description:  Fifo02 vc0 tail timeout                              */
#define SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_FIFO02_VC0_SHFT 56
#define SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_FIFO02_VC0_MASK 0x0100000000000000

/*   SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_FIFO02_VC2                       */
/*   Description:  Fifo02 vc2 tail timeout                              */
#define SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_FIFO02_VC2_SHFT 57
#define SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_FIFO02_VC2_MASK 0x0200000000000000

/*   SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_FIFO13_VC1                       */
/*   Description:  Fifo13 vc1 tail timeout                              */
#define SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_FIFO13_VC1_SHFT 58
#define SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_FIFO13_VC1_MASK 0x0400000000000000

/*   SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_FIFO13_VC3                       */
/*   Description:  Fifo13 vc3 tail timeout                              */
#define SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_FIFO13_VC3_SHFT 59
#define SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_FIFO13_VC3_MASK 0x0800000000000000

/*   SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_NI_VC0                           */
/*   Description:  NI vc0 tail timeout                                  */
#define SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_NI_VC0_SHFT 60
#define SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_NI_VC0_MASK 0x1000000000000000

/*   SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_NI_VC1                           */
/*   Description:  NI vc1 tail timeout                                  */
#define SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_NI_VC1_SHFT 61
#define SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_NI_VC1_MASK 0x2000000000000000

/*   SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_NI_VC2                           */
/*   Description:  NI vc2 tail timeout                                  */
#define SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_NI_VC2_SHFT 62
#define SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_NI_VC2_MASK 0x4000000000000000

/*   SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_NI_VC3                           */
/*   Description:  NI vc3 tail timeout                                  */
#define SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_NI_VC3_SHFT 63
#define SH_NI0_FIRST_ERROR_1_TAIL_TIMEOUT_NI_VC3_MASK 0x8000000000000000

/* ==================================================================== */
/*                   Register "SH_NI0_FIRST_ERROR_2"                    */
/*                         ni0 First Error Bits                         */
/* ==================================================================== */

#define SH_NI0_FIRST_ERROR_2                     0x0000000150040570
#define SH_NI0_FIRST_ERROR_2_MASK                0x7fffffff003fffff
#define SH_NI0_FIRST_ERROR_2_INIT                0x7fffffff003fffff

/*   SH_NI0_FIRST_ERROR_2_ILLEGAL_VCNI                                  */
/*   Description:  Illegal VC NI                                        */
#define SH_NI0_FIRST_ERROR_2_ILLEGAL_VCNI_SHFT   0
#define SH_NI0_FIRST_ERROR_2_ILLEGAL_VCNI_MASK   0x0000000000000001

/*   SH_NI0_FIRST_ERROR_2_ILLEGAL_VCPI                                  */
/*   Description:  Illegal VC PI                                        */
#define SH_NI0_FIRST_ERROR_2_ILLEGAL_VCPI_SHFT   1
#define SH_NI0_FIRST_ERROR_2_ILLEGAL_VCPI_MASK   0x0000000000000002

/*   SH_NI0_FIRST_ERROR_2_ILLEGAL_VCMD                                  */
/*   Description:  Illegal VC MD                                        */
#define SH_NI0_FIRST_ERROR_2_ILLEGAL_VCMD_SHFT   2
#define SH_NI0_FIRST_ERROR_2_ILLEGAL_VCMD_MASK   0x0000000000000004

/*   SH_NI0_FIRST_ERROR_2_ILLEGAL_VCIILB                                */
/*   Description:  Illegal VC IILB                                      */
#define SH_NI0_FIRST_ERROR_2_ILLEGAL_VCIILB_SHFT 3
#define SH_NI0_FIRST_ERROR_2_ILLEGAL_VCIILB_MASK 0x0000000000000008

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC0_POP                      */
/*   Description:  Fifo 02 vc0 pop underflow                            */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC0_POP_SHFT 4
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC0_POP_MASK 0x0000000000000010

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC2_POP                      */
/*   Description:  Fifo 02 vc2 pop underflow                            */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC2_POP_SHFT 5
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC2_POP_MASK 0x0000000000000020

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC1_POP                      */
/*   Description:  Fifo 13 vc1 pop underflow                            */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC1_POP_SHFT 6
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC1_POP_MASK 0x0000000000000040

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC3_POP                      */
/*   Description:  Fifo 13 vc3 pop underflow                            */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC3_POP_SHFT 7
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC3_POP_MASK 0x0000000000000080

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC0_PUSH                     */
/*   Description:  Fifo 02 vc0 push underflow                           */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC0_PUSH_SHFT 8
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC0_PUSH_MASK 0x0000000000000100

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC2_PUSH                     */
/*   Description:  Fifo 02 vc2 push underflow                           */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC2_PUSH_SHFT 9
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC2_PUSH_MASK 0x0000000000000200

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC1_PUSH                     */
/*   Description:  Fifo 13 vc1 push underflow                           */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC1_PUSH_SHFT 10
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC1_PUSH_MASK 0x0000000000000400

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC3_PUSH                     */
/*   Description:  Fifo 13 vc3 push underflow                           */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC3_PUSH_SHFT 11
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC3_PUSH_MASK 0x0000000000000800

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC0_CREDIT                   */
/*   Description:  Fifo 02 vc0 credit underflow                         */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC0_CREDIT_SHFT 12
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC0_CREDIT_MASK 0x0000000000001000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC2_CREDIT                   */
/*   Description:  Fifo 02 vc2 credit underflow                         */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC2_CREDIT_SHFT 13
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO02_VC2_CREDIT_MASK 0x0000000000002000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC0_CREDIT                   */
/*   Description:  Fifo 13 vc0 credit underflow                         */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC0_CREDIT_SHFT 14
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC0_CREDIT_MASK 0x0000000000004000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC2_CREDIT                   */
/*   Description:  Fifo 13 vc2 credit underflow                         */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC2_CREDIT_SHFT 15
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_FIFO13_VC2_CREDIT_MASK 0x0000000000008000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW0_VC0_CREDIT                         */
/*   Description:  VC0 credit underflow 0                               */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW0_VC0_CREDIT_SHFT 16
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW0_VC0_CREDIT_MASK 0x0000000000010000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW1_VC0_CREDIT                         */
/*   Description:  VC0 credit underflow 1                               */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW1_VC0_CREDIT_SHFT 17
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW1_VC0_CREDIT_MASK 0x0000000000020000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW2_VC0_CREDIT                         */
/*   Description:  VC0 credit underflow 2                               */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW2_VC0_CREDIT_SHFT 18
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW2_VC0_CREDIT_MASK 0x0000000000040000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW0_VC2_CREDIT                         */
/*   Description:  VC2 credit underflow 0                               */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW0_VC2_CREDIT_SHFT 19
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW0_VC2_CREDIT_MASK 0x0000000000080000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW1_VC2_CREDIT                         */
/*   Description:  VC2 credit underflow 1                               */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW1_VC2_CREDIT_SHFT 20
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW1_VC2_CREDIT_MASK 0x0000000000100000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW2_VC2_CREDIT                         */
/*   Description:  VC2 credit underflow 2                               */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW2_VC2_CREDIT_SHFT 21
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW2_VC2_CREDIT_MASK 0x0000000000200000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC0_POP                     */
/*   Description:  PI Fifo vc0 pop underflow                            */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC0_POP_SHFT 32
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC0_POP_MASK 0x0000000100000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC2_POP                     */
/*   Description:  PI Fifo vc2 pop underflow                            */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC2_POP_SHFT 33
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC2_POP_MASK 0x0000000200000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC0_POP                   */
/*   Description:  IILB Fifo vc0 pop underflow                          */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC0_POP_SHFT 34
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC0_POP_MASK 0x0000000400000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC2_POP                   */
/*   Description:  IILB Fifo vc2 pop underflow                          */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC2_POP_SHFT 35
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC2_POP_MASK 0x0000000800000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC0_POP                     */
/*   Description:  MD Fifo vc0 pop underflow                            */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC0_POP_SHFT 36
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC0_POP_MASK 0x0000001000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC2_POP                     */
/*   Description:  MD Fifo vc2 pop underflow                            */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC2_POP_SHFT 37
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC2_POP_MASK 0x0000002000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC0_POP                     */
/*   Description:  NI Fifo vc0 pop underflow                            */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC0_POP_SHFT 38
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC0_POP_MASK 0x0000004000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC2_POP                     */
/*   Description:  NI Fifo vc2 pop underflow                            */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC2_POP_SHFT 39
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC2_POP_MASK 0x0000008000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC0_PUSH                    */
/*   Description:  PI Fifo vc0 push underflow                           */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC0_PUSH_SHFT 40
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC0_PUSH_MASK 0x0000010000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC2_PUSH                    */
/*   Description:  PI Fifo vc2 push underflow                           */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC2_PUSH_SHFT 41
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC2_PUSH_MASK 0x0000020000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC0_PUSH                  */
/*   Description:  IILB Fifo vc0 push underflow                         */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC0_PUSH_SHFT 42
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC0_PUSH_MASK 0x0000040000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC2_PUSH                  */
/*   Description:  IILB Fifo vc2 push underflow                         */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC2_PUSH_SHFT 43
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC2_PUSH_MASK 0x0000080000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC0_PUSH                    */
/*   Description:  MD Fifo vc0 push underflow                           */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC0_PUSH_SHFT 44
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC0_PUSH_MASK 0x0000100000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC2_PUSH                    */
/*   Description:  MD Fifo vc2 push underflow                           */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC2_PUSH_SHFT 45
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC2_PUSH_MASK 0x0000200000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC0_CREDIT                  */
/*   Description:  PI Fifo vc0 credit underflow                         */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC0_CREDIT_SHFT 46
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC0_CREDIT_MASK 0x0000400000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC2_CREDIT                  */
/*   Description:  PI Fifo vc2 credit underflow                         */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC2_CREDIT_SHFT 47
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_PI_FIFO_VC2_CREDIT_MASK 0x0000800000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT                */
/*   Description:  IILB Fifo vc0 credit underflow                       */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT_SHFT 48
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT_MASK 0x0001000000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT                */
/*   Description:  IILB Fifo vc2 credit underflow                       */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT_SHFT 49
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT_MASK 0x0002000000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC0_CREDIT                  */
/*   Description:  MD Fifo vc0 credit underflow                         */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC0_CREDIT_SHFT 50
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC0_CREDIT_MASK 0x0004000000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC2_CREDIT                  */
/*   Description:  MD Fifo vc2 credit underflow                         */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC2_CREDIT_SHFT 51
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_MD_FIFO_VC2_CREDIT_MASK 0x0008000000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC0_CREDIT                  */
/*   Description:  NI Fifo vc0 credit underflow                         */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC0_CREDIT_SHFT 52
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC0_CREDIT_MASK 0x0010000000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC1_CREDIT                  */
/*   Description:  NI Fifo vc1 credit underflow                         */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC1_CREDIT_SHFT 53
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC1_CREDIT_MASK 0x0020000000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC2_CREDIT                  */
/*   Description:  NI Fifo vc2 credit underflow                         */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC2_CREDIT_SHFT 54
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC2_CREDIT_MASK 0x0040000000000000

/*   SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC3_CREDIT                  */
/*   Description:  NI Fifo vc3 credit underflow                         */
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC3_CREDIT_SHFT 55
#define SH_NI0_FIRST_ERROR_2_UNDERFLOW_NI_FIFO_VC3_CREDIT_MASK 0x0080000000000000

/*   SH_NI0_FIRST_ERROR_2_LLP_DEADLOCK_VC0                              */
/*   Description:  llp deadlock vc0                                     */
#define SH_NI0_FIRST_ERROR_2_LLP_DEADLOCK_VC0_SHFT 56
#define SH_NI0_FIRST_ERROR_2_LLP_DEADLOCK_VC0_MASK 0x0100000000000000

/*   SH_NI0_FIRST_ERROR_2_LLP_DEADLOCK_VC1                              */
/*   Description:  llp deadlock vc1                                     */
#define SH_NI0_FIRST_ERROR_2_LLP_DEADLOCK_VC1_SHFT 57
#define SH_NI0_FIRST_ERROR_2_LLP_DEADLOCK_VC1_MASK 0x0200000000000000

/*   SH_NI0_FIRST_ERROR_2_LLP_DEADLOCK_VC2                              */
/*   Description:  llp deadlock vc2                                     */
#define SH_NI0_FIRST_ERROR_2_LLP_DEADLOCK_VC2_SHFT 58
#define SH_NI0_FIRST_ERROR_2_LLP_DEADLOCK_VC2_MASK 0x0400000000000000

/*   SH_NI0_FIRST_ERROR_2_LLP_DEADLOCK_VC3                              */
/*   Description:  llp deadlock vc3                                     */
#define SH_NI0_FIRST_ERROR_2_LLP_DEADLOCK_VC3_SHFT 59
#define SH_NI0_FIRST_ERROR_2_LLP_DEADLOCK_VC3_MASK 0x0800000000000000

/*   SH_NI0_FIRST_ERROR_2_CHIPLET_NOMATCH                               */
/*   Description:  chiplet nomatch                                      */
#define SH_NI0_FIRST_ERROR_2_CHIPLET_NOMATCH_SHFT 60
#define SH_NI0_FIRST_ERROR_2_CHIPLET_NOMATCH_MASK 0x1000000000000000

/*   SH_NI0_FIRST_ERROR_2_LUT_READ_ERROR                                */
/*   Description:  LUT Read Error                                       */
#define SH_NI0_FIRST_ERROR_2_LUT_READ_ERROR_SHFT 61
#define SH_NI0_FIRST_ERROR_2_LUT_READ_ERROR_MASK 0x2000000000000000

/*   SH_NI0_FIRST_ERROR_2_RETRY_TIMEOUT_ERROR                           */
/*   Description:  Retry Timeout Error                                  */
#define SH_NI0_FIRST_ERROR_2_RETRY_TIMEOUT_ERROR_SHFT 62
#define SH_NI0_FIRST_ERROR_2_RETRY_TIMEOUT_ERROR_MASK 0x4000000000000000

/* ==================================================================== */
/*                   Register "SH_NI0_ERROR_DETAIL_1"                   */
/*                ni0 Chiplet no match header bits 63:0                 */
/* ==================================================================== */

#define SH_NI0_ERROR_DETAIL_1                    0x0000000150040580
#define SH_NI0_ERROR_DETAIL_1_MASK               0xffffffffffffffff
#define SH_NI0_ERROR_DETAIL_1_INIT               0x0000000000000000

/*   SH_NI0_ERROR_DETAIL_1_HEADER                                       */
/*   Description:  Header bits 63:0                                     */
#define SH_NI0_ERROR_DETAIL_1_HEADER_SHFT        0
#define SH_NI0_ERROR_DETAIL_1_HEADER_MASK        0xffffffffffffffff

/* ==================================================================== */
/*                   Register "SH_NI0_ERROR_DETAIL_2"                   */
/*               ni0 Chiplet no match header bits 127:64                */
/* ==================================================================== */

#define SH_NI0_ERROR_DETAIL_2                    0x0000000150040590
#define SH_NI0_ERROR_DETAIL_2_MASK               0xffffffffffffffff
#define SH_NI0_ERROR_DETAIL_2_INIT               0x0000000000000000

/*   SH_NI0_ERROR_DETAIL_2_HEADER                                       */
/*   Description:  Header bits 127:64                                   */
#define SH_NI0_ERROR_DETAIL_2_HEADER_SHFT        0
#define SH_NI0_ERROR_DETAIL_2_HEADER_MASK        0xffffffffffffffff

/* ==================================================================== */
/*                  Register "SH_NI1_ERROR_SUMMARY_1"                   */
/*                       ni1  Error Summary Bits                        */
/* ==================================================================== */

#define SH_NI1_ERROR_SUMMARY_1                   0x0000000150040600
#define SH_NI1_ERROR_SUMMARY_1_MASK              0xffffffffffffffff
#define SH_NI1_ERROR_SUMMARY_1_INIT              0xffffffffffffffff

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_DEBIT0                      */
/*   Description:  Fifo 02 debit0 overflow                              */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_DEBIT0_SHFT 0
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_DEBIT0_MASK 0x0000000000000001

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_DEBIT2                      */
/*   Description:  Fifo 02 debit2 overflow                              */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_DEBIT2_SHFT 1
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_DEBIT2_MASK 0x0000000000000002

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_DEBIT0                      */
/*   Description:  Fifo 13 debit0 overflow                              */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_DEBIT0_SHFT 2
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_DEBIT0_MASK 0x0000000000000004

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_DEBIT2                      */
/*   Description:  Fifo 13 debit2 overflow                              */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_DEBIT2_SHFT 3
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_DEBIT2_MASK 0x0000000000000008

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_POP                     */
/*   Description:  Fifo 02 vc0 pop overflow                             */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_POP_SHFT 4
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_POP_MASK 0x0000000000000010

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_POP                     */
/*   Description:  Fifo 02 vc2 pop overflow                             */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_POP_SHFT 5
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_POP_MASK 0x0000000000000020

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC1_POP                     */
/*   Description:  Fifo 13 vc1 pop overflow                             */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC1_POP_SHFT 6
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC1_POP_MASK 0x0000000000000040

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC3_POP                     */
/*   Description:  Fifo 13 vc3 pop overflow                             */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC3_POP_SHFT 7
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC3_POP_MASK 0x0000000000000080

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_PUSH                    */
/*   Description:  Fifo 02 vc0 push overflow                            */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_PUSH_SHFT 8
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_PUSH_MASK 0x0000000000000100

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_PUSH                    */
/*   Description:  Fifo 02 vc2 push overflow                            */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_PUSH_SHFT 9
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_PUSH_MASK 0x0000000000000200

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC1_PUSH                    */
/*   Description:  Fifo 13 vc1 push overflow                            */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC1_PUSH_SHFT 10
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC1_PUSH_MASK 0x0000000000000400

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC3_PUSH                    */
/*   Description:  Fifo 13 vc3 push overflow                            */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC3_PUSH_SHFT 11
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC3_PUSH_MASK 0x0000000000000800

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_CREDIT                  */
/*   Description:  Fifo 02 vc0 credit overflow                          */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_CREDIT_SHFT 12
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC0_CREDIT_MASK 0x0000000000001000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_CREDIT                  */
/*   Description:  Fifo 02 vc2 credit overflow                          */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_CREDIT_SHFT 13
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO02_VC2_CREDIT_MASK 0x0000000000002000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC0_CREDIT                  */
/*   Description:  Fifo 13 vc0 credit overflow                          */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC0_CREDIT_SHFT 14
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC0_CREDIT_MASK 0x0000000000004000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC2_CREDIT                  */
/*   Description:  Fifo 13 vc2 credit overflow                          */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC2_CREDIT_SHFT 15
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_FIFO13_VC2_CREDIT_MASK 0x0000000000008000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW0_VC0_CREDIT                        */
/*   Description:  VC0 credit overflow 0                                */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW0_VC0_CREDIT_SHFT 16
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW0_VC0_CREDIT_MASK 0x0000000000010000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW1_VC0_CREDIT                        */
/*   Description:  VC0 credit overflow 1                                */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW1_VC0_CREDIT_SHFT 17
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW1_VC0_CREDIT_MASK 0x0000000000020000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW2_VC0_CREDIT                        */
/*   Description:  VC0 credit overflow 2                                */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW2_VC0_CREDIT_SHFT 18
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW2_VC0_CREDIT_MASK 0x0000000000040000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW0_VC2_CREDIT                        */
/*   Description:  VC2 credit overflow 0                                */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW0_VC2_CREDIT_SHFT 19
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW0_VC2_CREDIT_MASK 0x0000000000080000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW1_VC2_CREDIT                        */
/*   Description:  VC2 credit overflow 1                                */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW1_VC2_CREDIT_SHFT 20
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW1_VC2_CREDIT_MASK 0x0000000000100000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW2_VC2_CREDIT                        */
/*   Description:  VC2 credit overflow 2                                */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW2_VC2_CREDIT_SHFT 21
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW2_VC2_CREDIT_MASK 0x0000000000200000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_DEBIT0                     */
/*   Description:  PI Fifo debit0 overflow                              */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_DEBIT0_SHFT 22
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_DEBIT0_MASK 0x0000000000400000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_DEBIT2                     */
/*   Description:  PI Fifo debit2 overflow                              */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_DEBIT2_SHFT 23
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_DEBIT2_MASK 0x0000000000800000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_DEBIT0                   */
/*   Description:  IILB Fifo debit0 overflow                            */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_DEBIT0_SHFT 24
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_DEBIT0_MASK 0x0000000001000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_DEBIT2                   */
/*   Description:  IILB Fifo debit2 overflow                            */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_DEBIT2_SHFT 25
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_DEBIT2_MASK 0x0000000002000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_DEBIT0                     */
/*   Description:  MD Fifo debit0 overflow                              */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_DEBIT0_SHFT 26
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_DEBIT0_MASK 0x0000000004000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_DEBIT2                     */
/*   Description:  MD Fifo debit2 overflow                              */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_DEBIT2_SHFT 27
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_DEBIT2_MASK 0x0000000008000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT0                     */
/*   Description:  NI Fifo debit0 overflow                              */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT0_SHFT 28
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT0_MASK 0x0000000010000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT1                     */
/*   Description:  NI Fifo debit1 overflow                              */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT1_SHFT 29
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT1_MASK 0x0000000020000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT2                     */
/*   Description:  NI Fifo debit2 overflow                              */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT2_SHFT 30
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT2_MASK 0x0000000040000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT3                     */
/*   Description:  NI Fifo debit3 overflow                              */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT3_SHFT 31
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_DEBIT3_MASK 0x0000000080000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_POP                    */
/*   Description:  PI Fifo vc0 pop overflow                             */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_POP_SHFT 32
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_POP_MASK 0x0000000100000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_POP                    */
/*   Description:  PI Fifo vc2 pop overflow                             */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_POP_SHFT 33
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_POP_MASK 0x0000000200000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_POP                  */
/*   Description:  IILB Fifo vc0 pop overflow                           */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_POP_SHFT 34
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_POP_MASK 0x0000000400000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_POP                  */
/*   Description:  IILB Fifo vc2 pop overflow                           */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_POP_SHFT 35
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_POP_MASK 0x0000000800000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_POP                    */
/*   Description:  MD Fifo vc0 pop overflow                             */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_POP_SHFT 36
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_POP_MASK 0x0000001000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_POP                    */
/*   Description:  MD Fifo vc2 pop overflow                             */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_POP_SHFT 37
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_POP_MASK 0x0000002000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC0_POP                    */
/*   Description:  NI Fifo vc0 pop overflow                             */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC0_POP_SHFT 38
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC0_POP_MASK 0x0000004000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC2_POP                    */
/*   Description:  NI Fifo vc2 pop overflow                             */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC2_POP_SHFT 39
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC2_POP_MASK 0x0000008000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_PUSH                   */
/*   Description:  PI Fifo vc0 push overflow                            */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_PUSH_SHFT 40
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_PUSH_MASK 0x0000010000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_PUSH                   */
/*   Description:  PI Fifo vc2 push overflow                            */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_PUSH_SHFT 41
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_PUSH_MASK 0x0000020000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_PUSH                 */
/*   Description:  IILB Fifo vc0 push overflow                          */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_PUSH_SHFT 42
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_PUSH_MASK 0x0000040000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_PUSH                 */
/*   Description:  IILB Fifo vc2 push overflow                          */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_PUSH_SHFT 43
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_PUSH_MASK 0x0000080000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_PUSH                   */
/*   Description:  MD Fifo vc0 push overflow                            */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_PUSH_SHFT 44
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_PUSH_MASK 0x0000100000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_PUSH                   */
/*   Description:  MD Fifo vc2 push overflow                            */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_PUSH_SHFT 45
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_PUSH_MASK 0x0000200000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_CREDIT                 */
/*   Description:  PI Fifo vc0 credit overflow                          */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_CREDIT_SHFT 46
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC0_CREDIT_MASK 0x0000400000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_CREDIT                 */
/*   Description:  PI Fifo vc2 credit overflow                          */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_CREDIT_SHFT 47
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_PI_FIFO_VC2_CREDIT_MASK 0x0000800000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_CREDIT               */
/*   Description:  IILB Fifo vc0 credit overflow                        */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_CREDIT_SHFT 48
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC0_CREDIT_MASK 0x0001000000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_CREDIT               */
/*   Description:  IILB Fifo vc2 credit overflow                        */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_CREDIT_SHFT 49
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_IILB_FIFO_VC2_CREDIT_MASK 0x0002000000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_CREDIT                 */
/*   Description:  MD Fifo vc0 credit overflow                          */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_CREDIT_SHFT 50
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC0_CREDIT_MASK 0x0004000000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_CREDIT                 */
/*   Description:  MD Fifo vc2 credit overflow                          */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_CREDIT_SHFT 51
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_MD_FIFO_VC2_CREDIT_MASK 0x0008000000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC0_CREDIT                 */
/*   Description:  NI Fifo vc0 credit overflow                          */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC0_CREDIT_SHFT 52
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC0_CREDIT_MASK 0x0010000000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC1_CREDIT                 */
/*   Description:  NI Fifo vc1 credit overflow                          */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC1_CREDIT_SHFT 53
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC1_CREDIT_MASK 0x0020000000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC2_CREDIT                 */
/*   Description:  NI Fifo vc2 credit overflow                          */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC2_CREDIT_SHFT 54
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC2_CREDIT_MASK 0x0040000000000000

/*   SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC3_CREDIT                 */
/*   Description:  NI Fifo vc3 credit overflow                          */
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC3_CREDIT_SHFT 55
#define SH_NI1_ERROR_SUMMARY_1_OVERFLOW_NI_FIFO_VC3_CREDIT_MASK 0x0080000000000000

/*   SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO02_VC0                     */
/*   Description:  Fifo02 vc0 tail timeout                              */
#define SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO02_VC0_SHFT 56
#define SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO02_VC0_MASK 0x0100000000000000

/*   SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO02_VC2                     */
/*   Description:  Fifo02 vc2 tail timeout                              */
#define SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO02_VC2_SHFT 57
#define SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO02_VC2_MASK 0x0200000000000000

/*   SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO13_VC1                     */
/*   Description:  Fifo13 vc1 tail timeout                              */
#define SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO13_VC1_SHFT 58
#define SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO13_VC1_MASK 0x0400000000000000

/*   SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO13_VC3                     */
/*   Description:  Fifo13 vc3 tail timeout                              */
#define SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO13_VC3_SHFT 59
#define SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_FIFO13_VC3_MASK 0x0800000000000000

/*   SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC0                         */
/*   Description:  NI vc0 tail timeout                                  */
#define SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC0_SHFT 60
#define SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC0_MASK 0x1000000000000000

/*   SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC1                         */
/*   Description:  NI vc1 tail timeout                                  */
#define SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC1_SHFT 61
#define SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC1_MASK 0x2000000000000000

/*   SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC2                         */
/*   Description:  NI vc2 tail timeout                                  */
#define SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC2_SHFT 62
#define SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC2_MASK 0x4000000000000000

/*   SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC3                         */
/*   Description:  NI vc3 tail timeout                                  */
#define SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC3_SHFT 63
#define SH_NI1_ERROR_SUMMARY_1_TAIL_TIMEOUT_NI_VC3_MASK 0x8000000000000000

/* ==================================================================== */
/*               Register "SH_NI1_ERROR_SUMMARY_1_ALIAS"                */
/*                     ni1 Error Summary Bits Alias                     */
/* ==================================================================== */

#define SH_NI1_ERROR_SUMMARY_1_ALIAS             0x0000000150040608

/* ==================================================================== */
/*                  Register "SH_NI1_ERROR_SUMMARY_2"                   */
/*                       ni1  Error Summary Bits                        */
/* ==================================================================== */

#define SH_NI1_ERROR_SUMMARY_2                   0x0000000150040610
#define SH_NI1_ERROR_SUMMARY_2_MASK              0x7fffffff003fffff
#define SH_NI1_ERROR_SUMMARY_2_INIT              0x7fffffff003fffff

/*   SH_NI1_ERROR_SUMMARY_2_ILLEGAL_VCNI                                */
/*   Description:  Illegal VC NI                                        */
#define SH_NI1_ERROR_SUMMARY_2_ILLEGAL_VCNI_SHFT 0
#define SH_NI1_ERROR_SUMMARY_2_ILLEGAL_VCNI_MASK 0x0000000000000001

/*   SH_NI1_ERROR_SUMMARY_2_ILLEGAL_VCPI                                */
/*   Description:  Illegal VC PI                                        */
#define SH_NI1_ERROR_SUMMARY_2_ILLEGAL_VCPI_SHFT 1
#define SH_NI1_ERROR_SUMMARY_2_ILLEGAL_VCPI_MASK 0x0000000000000002

/*   SH_NI1_ERROR_SUMMARY_2_ILLEGAL_VCMD                                */
/*   Description:  Illegal VC MD                                        */
#define SH_NI1_ERROR_SUMMARY_2_ILLEGAL_VCMD_SHFT 2
#define SH_NI1_ERROR_SUMMARY_2_ILLEGAL_VCMD_MASK 0x0000000000000004

/*   SH_NI1_ERROR_SUMMARY_2_ILLEGAL_VCIILB                              */
/*   Description:  Illegal VC IILB                                      */
#define SH_NI1_ERROR_SUMMARY_2_ILLEGAL_VCIILB_SHFT 3
#define SH_NI1_ERROR_SUMMARY_2_ILLEGAL_VCIILB_MASK 0x0000000000000008

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_POP                    */
/*   Description:  Fifo 02 vc0 pop underflow                            */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_POP_SHFT 4
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_POP_MASK 0x0000000000000010

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_POP                    */
/*   Description:  Fifo 02 vc2 pop underflow                            */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_POP_SHFT 5
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_POP_MASK 0x0000000000000020

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC1_POP                    */
/*   Description:  Fifo 13 vc1 pop underflow                            */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC1_POP_SHFT 6
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC1_POP_MASK 0x0000000000000040

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC3_POP                    */
/*   Description:  Fifo 13 vc3 pop underflow                            */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC3_POP_SHFT 7
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC3_POP_MASK 0x0000000000000080

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_PUSH                   */
/*   Description:  Fifo 02 vc0 push underflow                           */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_PUSH_SHFT 8
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_PUSH_MASK 0x0000000000000100

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_PUSH                   */
/*   Description:  Fifo 02 vc2 push underflow                           */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_PUSH_SHFT 9
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_PUSH_MASK 0x0000000000000200

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC1_PUSH                   */
/*   Description:  Fifo 13 vc1 push underflow                           */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC1_PUSH_SHFT 10
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC1_PUSH_MASK 0x0000000000000400

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC3_PUSH                   */
/*   Description:  Fifo 13 vc3 push underflow                           */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC3_PUSH_SHFT 11
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC3_PUSH_MASK 0x0000000000000800

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_CREDIT                 */
/*   Description:  Fifo 02 vc0 credit underflow                         */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_CREDIT_SHFT 12
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC0_CREDIT_MASK 0x0000000000001000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_CREDIT                 */
/*   Description:  Fifo 02 vc2 credit underflow                         */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_CREDIT_SHFT 13
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO02_VC2_CREDIT_MASK 0x0000000000002000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC0_CREDIT                 */
/*   Description:  Fifo 13 vc0 credit underflow                         */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC0_CREDIT_SHFT 14
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC0_CREDIT_MASK 0x0000000000004000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC2_CREDIT                 */
/*   Description:  Fifo 13 vc2 credit underflow                         */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC2_CREDIT_SHFT 15
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_FIFO13_VC2_CREDIT_MASK 0x0000000000008000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW0_VC0_CREDIT                       */
/*   Description:  VC0 credit underflow 0                               */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW0_VC0_CREDIT_SHFT 16
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW0_VC0_CREDIT_MASK 0x0000000000010000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW1_VC0_CREDIT                       */
/*   Description:  VC0 credit underflow 1                               */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW1_VC0_CREDIT_SHFT 17
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW1_VC0_CREDIT_MASK 0x0000000000020000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW2_VC0_CREDIT                       */
/*   Description:  VC0 credit underflow 2                               */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW2_VC0_CREDIT_SHFT 18
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW2_VC0_CREDIT_MASK 0x0000000000040000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW0_VC2_CREDIT                       */
/*   Description:  VC2 credit underflow 0                               */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW0_VC2_CREDIT_SHFT 19
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW0_VC2_CREDIT_MASK 0x0000000000080000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW1_VC2_CREDIT                       */
/*   Description:  VC2 credit underflow 1                               */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW1_VC2_CREDIT_SHFT 20
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW1_VC2_CREDIT_MASK 0x0000000000100000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW2_VC2_CREDIT                       */
/*   Description:  VC2 credit underflow 2                               */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW2_VC2_CREDIT_SHFT 21
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW2_VC2_CREDIT_MASK 0x0000000000200000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_POP                   */
/*   Description:  PI Fifo vc0 pop underflow                            */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_POP_SHFT 32
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_POP_MASK 0x0000000100000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_POP                   */
/*   Description:  PI Fifo vc2 pop underflow                            */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_POP_SHFT 33
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_POP_MASK 0x0000000200000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_POP                 */
/*   Description:  IILB Fifo vc0 pop underflow                          */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_POP_SHFT 34
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_POP_MASK 0x0000000400000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_POP                 */
/*   Description:  IILB Fifo vc2 pop underflow                          */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_POP_SHFT 35
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_POP_MASK 0x0000000800000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_POP                   */
/*   Description:  MD Fifo vc0 pop underflow                            */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_POP_SHFT 36
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_POP_MASK 0x0000001000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_POP                   */
/*   Description:  MD Fifo vc2 pop underflow                            */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_POP_SHFT 37
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_POP_MASK 0x0000002000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC0_POP                   */
/*   Description:  NI Fifo vc0 pop underflow                            */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC0_POP_SHFT 38
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC0_POP_MASK 0x0000004000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC2_POP                   */
/*   Description:  NI Fifo vc2 pop underflow                            */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC2_POP_SHFT 39
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC2_POP_MASK 0x0000008000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_PUSH                  */
/*   Description:  PI Fifo vc0 push underflow                           */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_PUSH_SHFT 40
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_PUSH_MASK 0x0000010000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_PUSH                  */
/*   Description:  PI Fifo vc2 push underflow                           */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_PUSH_SHFT 41
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_PUSH_MASK 0x0000020000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_PUSH                */
/*   Description:  IILB Fifo vc0 push underflow                         */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_PUSH_SHFT 42
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_PUSH_MASK 0x0000040000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_PUSH                */
/*   Description:  IILB Fifo vc2 push underflow                         */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_PUSH_SHFT 43
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_PUSH_MASK 0x0000080000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_PUSH                  */
/*   Description:  MD Fifo vc0 push underflow                           */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_PUSH_SHFT 44
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_PUSH_MASK 0x0000100000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_PUSH                  */
/*   Description:  MD Fifo vc2 push underflow                           */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_PUSH_SHFT 45
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_PUSH_MASK 0x0000200000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_CREDIT                */
/*   Description:  PI Fifo vc0 credit underflow                         */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_CREDIT_SHFT 46
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC0_CREDIT_MASK 0x0000400000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_CREDIT                */
/*   Description:  PI Fifo vc2 credit underflow                         */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_CREDIT_SHFT 47
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_PI_FIFO_VC2_CREDIT_MASK 0x0000800000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT              */
/*   Description:  IILB Fifo vc0 credit underflow                       */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT_SHFT 48
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT_MASK 0x0001000000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT              */
/*   Description:  IILB Fifo vc2 credit underflow                       */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT_SHFT 49
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT_MASK 0x0002000000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_CREDIT                */
/*   Description:  MD Fifo vc0 credit underflow                         */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_CREDIT_SHFT 50
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC0_CREDIT_MASK 0x0004000000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_CREDIT                */
/*   Description:  MD Fifo vc2 credit underflow                         */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_CREDIT_SHFT 51
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_MD_FIFO_VC2_CREDIT_MASK 0x0008000000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC0_CREDIT                */
/*   Description:  NI Fifo vc0 credit underflow                         */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC0_CREDIT_SHFT 52
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC0_CREDIT_MASK 0x0010000000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC1_CREDIT                */
/*   Description:  NI Fifo vc1 credit underflow                         */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC1_CREDIT_SHFT 53
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC1_CREDIT_MASK 0x0020000000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC2_CREDIT                */
/*   Description:  NI Fifo vc2 credit underflow                         */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC2_CREDIT_SHFT 54
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC2_CREDIT_MASK 0x0040000000000000

/*   SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC3_CREDIT                */
/*   Description:  NI Fifo vc3 credit underflow                         */
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC3_CREDIT_SHFT 55
#define SH_NI1_ERROR_SUMMARY_2_UNDERFLOW_NI_FIFO_VC3_CREDIT_MASK 0x0080000000000000

/*   SH_NI1_ERROR_SUMMARY_2_LLP_DEADLOCK_VC0                            */
/*   Description:  llp deadlock vc0                                     */
#define SH_NI1_ERROR_SUMMARY_2_LLP_DEADLOCK_VC0_SHFT 56
#define SH_NI1_ERROR_SUMMARY_2_LLP_DEADLOCK_VC0_MASK 0x0100000000000000

/*   SH_NI1_ERROR_SUMMARY_2_LLP_DEADLOCK_VC1                            */
/*   Description:  llp deadlock vc1                                     */
#define SH_NI1_ERROR_SUMMARY_2_LLP_DEADLOCK_VC1_SHFT 57
#define SH_NI1_ERROR_SUMMARY_2_LLP_DEADLOCK_VC1_MASK 0x0200000000000000

/*   SH_NI1_ERROR_SUMMARY_2_LLP_DEADLOCK_VC2                            */
/*   Description:  llp deadlock vc2                                     */
#define SH_NI1_ERROR_SUMMARY_2_LLP_DEADLOCK_VC2_SHFT 58
#define SH_NI1_ERROR_SUMMARY_2_LLP_DEADLOCK_VC2_MASK 0x0400000000000000

/*   SH_NI1_ERROR_SUMMARY_2_LLP_DEADLOCK_VC3                            */
/*   Description:  llp deadlock vc3                                     */
#define SH_NI1_ERROR_SUMMARY_2_LLP_DEADLOCK_VC3_SHFT 59
#define SH_NI1_ERROR_SUMMARY_2_LLP_DEADLOCK_VC3_MASK 0x0800000000000000

/*   SH_NI1_ERROR_SUMMARY_2_CHIPLET_NOMATCH                             */
/*   Description:  chiplet nomatch                                      */
#define SH_NI1_ERROR_SUMMARY_2_CHIPLET_NOMATCH_SHFT 60
#define SH_NI1_ERROR_SUMMARY_2_CHIPLET_NOMATCH_MASK 0x1000000000000000

/*   SH_NI1_ERROR_SUMMARY_2_LUT_READ_ERROR                              */
/*   Description:  LUT Read Error                                       */
#define SH_NI1_ERROR_SUMMARY_2_LUT_READ_ERROR_SHFT 61
#define SH_NI1_ERROR_SUMMARY_2_LUT_READ_ERROR_MASK 0x2000000000000000

/*   SH_NI1_ERROR_SUMMARY_2_RETRY_TIMEOUT_ERROR                         */
/*   Description:  Retry Timeout Error                                  */
#define SH_NI1_ERROR_SUMMARY_2_RETRY_TIMEOUT_ERROR_SHFT 62
#define SH_NI1_ERROR_SUMMARY_2_RETRY_TIMEOUT_ERROR_MASK 0x4000000000000000

/* ==================================================================== */
/*               Register "SH_NI1_ERROR_SUMMARY_2_ALIAS"                */
/*                     ni1 Error Summary Bits Alias                     */
/* ==================================================================== */

#define SH_NI1_ERROR_SUMMARY_2_ALIAS             0x0000000150040618

/* ==================================================================== */
/*                  Register "SH_NI1_ERROR_OVERFLOW_1"                  */
/*                       ni1  Error Overflow Bits                       */
/* ==================================================================== */

#define SH_NI1_ERROR_OVERFLOW_1                  0x0000000150040620
#define SH_NI1_ERROR_OVERFLOW_1_MASK             0xffffffffffffffff
#define SH_NI1_ERROR_OVERFLOW_1_INIT             0xffffffffffffffff

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_DEBIT0                     */
/*   Description:  Fifo 02 debit0 overflow                              */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_DEBIT0_SHFT 0
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_DEBIT0_MASK 0x0000000000000001

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_DEBIT2                     */
/*   Description:  Fifo 02 debit2 overflow                              */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_DEBIT2_SHFT 1
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_DEBIT2_MASK 0x0000000000000002

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_DEBIT0                     */
/*   Description:  Fifo 13 debit0 overflow                              */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_DEBIT0_SHFT 2
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_DEBIT0_MASK 0x0000000000000004

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_DEBIT2                     */
/*   Description:  Fifo 13 debit2 overflow                              */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_DEBIT2_SHFT 3
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_DEBIT2_MASK 0x0000000000000008

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_POP                    */
/*   Description:  Fifo 02 vc0 pop overflow                             */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_POP_SHFT 4
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_POP_MASK 0x0000000000000010

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_POP                    */
/*   Description:  Fifo 02 vc2 pop overflow                             */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_POP_SHFT 5
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_POP_MASK 0x0000000000000020

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC1_POP                    */
/*   Description:  Fifo 13 vc1 pop overflow                             */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC1_POP_SHFT 6
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC1_POP_MASK 0x0000000000000040

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC3_POP                    */
/*   Description:  Fifo 13 vc3 pop overflow                             */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC3_POP_SHFT 7
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC3_POP_MASK 0x0000000000000080

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_PUSH                   */
/*   Description:  Fifo 02 vc0 push overflow                            */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_PUSH_SHFT 8
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_PUSH_MASK 0x0000000000000100

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_PUSH                   */
/*   Description:  Fifo 02 vc2 push overflow                            */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_PUSH_SHFT 9
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_PUSH_MASK 0x0000000000000200

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC1_PUSH                   */
/*   Description:  Fifo 13 vc1 push overflow                            */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC1_PUSH_SHFT 10
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC1_PUSH_MASK 0x0000000000000400

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC3_PUSH                   */
/*   Description:  Fifo 13 vc3 push overflow                            */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC3_PUSH_SHFT 11
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC3_PUSH_MASK 0x0000000000000800

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_CREDIT                 */
/*   Description:  Fifo 02 vc0 credit overflow                          */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_CREDIT_SHFT 12
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC0_CREDIT_MASK 0x0000000000001000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_CREDIT                 */
/*   Description:  Fifo 02 vc2 credit overflow                          */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_CREDIT_SHFT 13
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO02_VC2_CREDIT_MASK 0x0000000000002000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC0_CREDIT                 */
/*   Description:  Fifo 13 vc0 credit overflow                          */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC0_CREDIT_SHFT 14
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC0_CREDIT_MASK 0x0000000000004000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC2_CREDIT                 */
/*   Description:  Fifo 13 vc2 credit overflow                          */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC2_CREDIT_SHFT 15
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_FIFO13_VC2_CREDIT_MASK 0x0000000000008000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW0_VC0_CREDIT                       */
/*   Description:  VC0 credit overflow 0                                */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW0_VC0_CREDIT_SHFT 16
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW0_VC0_CREDIT_MASK 0x0000000000010000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW1_VC0_CREDIT                       */
/*   Description:  VC0 credit overflow 1                                */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW1_VC0_CREDIT_SHFT 17
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW1_VC0_CREDIT_MASK 0x0000000000020000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW2_VC0_CREDIT                       */
/*   Description:  VC0 credit overflow 2                                */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW2_VC0_CREDIT_SHFT 18
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW2_VC0_CREDIT_MASK 0x0000000000040000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW0_VC2_CREDIT                       */
/*   Description:  VC2 credit overflow 0                                */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW0_VC2_CREDIT_SHFT 19
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW0_VC2_CREDIT_MASK 0x0000000000080000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW1_VC2_CREDIT                       */
/*   Description:  VC2 credit overflow 1                                */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW1_VC2_CREDIT_SHFT 20
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW1_VC2_CREDIT_MASK 0x0000000000100000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW2_VC2_CREDIT                       */
/*   Description:  VC2 credit overflow 2                                */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW2_VC2_CREDIT_SHFT 21
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW2_VC2_CREDIT_MASK 0x0000000000200000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_DEBIT0                    */
/*   Description:  PI Fifo debit0 overflow                              */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_DEBIT0_SHFT 22
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_DEBIT0_MASK 0x0000000000400000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_DEBIT2                    */
/*   Description:  PI Fifo debit2 overflow                              */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_DEBIT2_SHFT 23
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_DEBIT2_MASK 0x0000000000800000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_DEBIT0                  */
/*   Description:  IILB Fifo debit0 overflow                            */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_DEBIT0_SHFT 24
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_DEBIT0_MASK 0x0000000001000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_DEBIT2                  */
/*   Description:  IILB Fifo debit2 overflow                            */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_DEBIT2_SHFT 25
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_DEBIT2_MASK 0x0000000002000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_DEBIT0                    */
/*   Description:  MD Fifo debit0 overflow                              */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_DEBIT0_SHFT 26
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_DEBIT0_MASK 0x0000000004000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_DEBIT2                    */
/*   Description:  MD Fifo debit2 overflow                              */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_DEBIT2_SHFT 27
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_DEBIT2_MASK 0x0000000008000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT0                    */
/*   Description:  NI Fifo debit0 overflow                              */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT0_SHFT 28
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT0_MASK 0x0000000010000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT1                    */
/*   Description:  NI Fifo debit1 overflow                              */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT1_SHFT 29
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT1_MASK 0x0000000020000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT2                    */
/*   Description:  NI Fifo debit2 overflow                              */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT2_SHFT 30
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT2_MASK 0x0000000040000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT3                    */
/*   Description:  NI Fifo debit3 overflow                              */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT3_SHFT 31
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_DEBIT3_MASK 0x0000000080000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_POP                   */
/*   Description:  PI Fifo vc0 pop overflow                             */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_POP_SHFT 32
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_POP_MASK 0x0000000100000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_POP                   */
/*   Description:  PI Fifo vc2 pop overflow                             */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_POP_SHFT 33
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_POP_MASK 0x0000000200000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_POP                 */
/*   Description:  IILB Fifo vc0 pop overflow                           */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_POP_SHFT 34
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_POP_MASK 0x0000000400000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_POP                 */
/*   Description:  IILB Fifo vc2 pop overflow                           */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_POP_SHFT 35
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_POP_MASK 0x0000000800000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_POP                   */
/*   Description:  MD Fifo vc0 pop overflow                             */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_POP_SHFT 36
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_POP_MASK 0x0000001000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_POP                   */
/*   Description:  MD Fifo vc2 pop overflow                             */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_POP_SHFT 37
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_POP_MASK 0x0000002000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC0_POP                   */
/*   Description:  NI Fifo vc0 pop overflow                             */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC0_POP_SHFT 38
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC0_POP_MASK 0x0000004000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC2_POP                   */
/*   Description:  NI Fifo vc2 pop overflow                             */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC2_POP_SHFT 39
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC2_POP_MASK 0x0000008000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_PUSH                  */
/*   Description:  PI Fifo vc0 push overflow                            */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_PUSH_SHFT 40
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_PUSH_MASK 0x0000010000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_PUSH                  */
/*   Description:  PI Fifo vc2 push overflow                            */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_PUSH_SHFT 41
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_PUSH_MASK 0x0000020000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_PUSH                */
/*   Description:  IILB Fifo vc0 push overflow                          */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_PUSH_SHFT 42
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_PUSH_MASK 0x0000040000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_PUSH                */
/*   Description:  IILB Fifo vc2 push overflow                          */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_PUSH_SHFT 43
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_PUSH_MASK 0x0000080000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_PUSH                  */
/*   Description:  MD Fifo vc0 push overflow                            */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_PUSH_SHFT 44
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_PUSH_MASK 0x0000100000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_PUSH                  */
/*   Description:  MD Fifo vc2 push overflow                            */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_PUSH_SHFT 45
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_PUSH_MASK 0x0000200000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_CREDIT                */
/*   Description:  PI Fifo vc0 credit overflow                          */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_CREDIT_SHFT 46
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC0_CREDIT_MASK 0x0000400000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_CREDIT                */
/*   Description:  PI Fifo vc2 credit overflow                          */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_CREDIT_SHFT 47
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_PI_FIFO_VC2_CREDIT_MASK 0x0000800000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_CREDIT              */
/*   Description:  IILB Fifo vc0 credit overflow                        */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_CREDIT_SHFT 48
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC0_CREDIT_MASK 0x0001000000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_CREDIT              */
/*   Description:  IILB Fifo vc2 credit overflow                        */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_CREDIT_SHFT 49
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_IILB_FIFO_VC2_CREDIT_MASK 0x0002000000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_CREDIT                */
/*   Description:  MD Fifo vc0 credit overflow                          */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_CREDIT_SHFT 50
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC0_CREDIT_MASK 0x0004000000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_CREDIT                */
/*   Description:  MD Fifo vc2 credit overflow                          */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_CREDIT_SHFT 51
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_MD_FIFO_VC2_CREDIT_MASK 0x0008000000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC0_CREDIT                */
/*   Description:  NI Fifo vc0 credit overflow                          */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC0_CREDIT_SHFT 52
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC0_CREDIT_MASK 0x0010000000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC1_CREDIT                */
/*   Description:  NI Fifo vc1 credit overflow                          */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC1_CREDIT_SHFT 53
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC1_CREDIT_MASK 0x0020000000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC2_CREDIT                */
/*   Description:  NI Fifo vc2 credit overflow                          */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC2_CREDIT_SHFT 54
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC2_CREDIT_MASK 0x0040000000000000

/*   SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC3_CREDIT                */
/*   Description:  NI Fifo vc3 credit overflow                          */
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC3_CREDIT_SHFT 55
#define SH_NI1_ERROR_OVERFLOW_1_OVERFLOW_NI_FIFO_VC3_CREDIT_MASK 0x0080000000000000

/*   SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO02_VC0                    */
/*   Description:  Fifo02 vc0 tail timeout                              */
#define SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO02_VC0_SHFT 56
#define SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO02_VC0_MASK 0x0100000000000000

/*   SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO02_VC2                    */
/*   Description:  Fifo02 vc2 tail timeout                              */
#define SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO02_VC2_SHFT 57
#define SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO02_VC2_MASK 0x0200000000000000

/*   SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO13_VC1                    */
/*   Description:  Fifo13 vc1 tail timeout                              */
#define SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO13_VC1_SHFT 58
#define SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO13_VC1_MASK 0x0400000000000000

/*   SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO13_VC3                    */
/*   Description:  Fifo13 vc3 tail timeout                              */
#define SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO13_VC3_SHFT 59
#define SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_FIFO13_VC3_MASK 0x0800000000000000

/*   SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC0                        */
/*   Description:  NI vc0 tail timeout                                  */
#define SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC0_SHFT 60
#define SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC0_MASK 0x1000000000000000

/*   SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC1                        */
/*   Description:  NI vc1 tail timeout                                  */
#define SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC1_SHFT 61
#define SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC1_MASK 0x2000000000000000

/*   SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC2                        */
/*   Description:  NI vc2 tail timeout                                  */
#define SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC2_SHFT 62
#define SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC2_MASK 0x4000000000000000

/*   SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC3                        */
/*   Description:  NI vc3 tail timeout                                  */
#define SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC3_SHFT 63
#define SH_NI1_ERROR_OVERFLOW_1_TAIL_TIMEOUT_NI_VC3_MASK 0x8000000000000000

/* ==================================================================== */
/*               Register "SH_NI1_ERROR_OVERFLOW_1_ALIAS"               */
/*                    ni1 Error Overflow Bits Alias                     */
/* ==================================================================== */

#define SH_NI1_ERROR_OVERFLOW_1_ALIAS            0x0000000150040628

/* ==================================================================== */
/*                  Register "SH_NI1_ERROR_OVERFLOW_2"                  */
/*                       ni1  Error Overflow Bits                       */
/* ==================================================================== */

#define SH_NI1_ERROR_OVERFLOW_2                  0x0000000150040630
#define SH_NI1_ERROR_OVERFLOW_2_MASK             0x7fffffff003fffff
#define SH_NI1_ERROR_OVERFLOW_2_INIT             0x7fffffff003fffff

/*   SH_NI1_ERROR_OVERFLOW_2_ILLEGAL_VCNI                               */
/*   Description:  Illegal VC NI                                        */
#define SH_NI1_ERROR_OVERFLOW_2_ILLEGAL_VCNI_SHFT 0
#define SH_NI1_ERROR_OVERFLOW_2_ILLEGAL_VCNI_MASK 0x0000000000000001

/*   SH_NI1_ERROR_OVERFLOW_2_ILLEGAL_VCPI                               */
/*   Description:  Illegal VC PI                                        */
#define SH_NI1_ERROR_OVERFLOW_2_ILLEGAL_VCPI_SHFT 1
#define SH_NI1_ERROR_OVERFLOW_2_ILLEGAL_VCPI_MASK 0x0000000000000002

/*   SH_NI1_ERROR_OVERFLOW_2_ILLEGAL_VCMD                               */
/*   Description:  Illegal VC MD                                        */
#define SH_NI1_ERROR_OVERFLOW_2_ILLEGAL_VCMD_SHFT 2
#define SH_NI1_ERROR_OVERFLOW_2_ILLEGAL_VCMD_MASK 0x0000000000000004

/*   SH_NI1_ERROR_OVERFLOW_2_ILLEGAL_VCIILB                             */
/*   Description:  Illegal VC IILB                                      */
#define SH_NI1_ERROR_OVERFLOW_2_ILLEGAL_VCIILB_SHFT 3
#define SH_NI1_ERROR_OVERFLOW_2_ILLEGAL_VCIILB_MASK 0x0000000000000008

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_POP                   */
/*   Description:  Fifo 02 vc0 pop underflow                            */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_POP_SHFT 4
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_POP_MASK 0x0000000000000010

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_POP                   */
/*   Description:  Fifo 02 vc2 pop underflow                            */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_POP_SHFT 5
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_POP_MASK 0x0000000000000020

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC1_POP                   */
/*   Description:  Fifo 13 vc1 pop underflow                            */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC1_POP_SHFT 6
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC1_POP_MASK 0x0000000000000040

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC3_POP                   */
/*   Description:  Fifo 13 vc3 pop underflow                            */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC3_POP_SHFT 7
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC3_POP_MASK 0x0000000000000080

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_PUSH                  */
/*   Description:  Fifo 02 vc0 push underflow                           */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_PUSH_SHFT 8
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_PUSH_MASK 0x0000000000000100

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_PUSH                  */
/*   Description:  Fifo 02 vc2 push underflow                           */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_PUSH_SHFT 9
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_PUSH_MASK 0x0000000000000200

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC1_PUSH                  */
/*   Description:  Fifo 13 vc1 push underflow                           */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC1_PUSH_SHFT 10
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC1_PUSH_MASK 0x0000000000000400

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC3_PUSH                  */
/*   Description:  Fifo 13 vc3 push underflow                           */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC3_PUSH_SHFT 11
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC3_PUSH_MASK 0x0000000000000800

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_CREDIT                */
/*   Description:  Fifo 02 vc0 credit underflow                         */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_CREDIT_SHFT 12
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC0_CREDIT_MASK 0x0000000000001000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_CREDIT                */
/*   Description:  Fifo 02 vc2 credit underflow                         */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_CREDIT_SHFT 13
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO02_VC2_CREDIT_MASK 0x0000000000002000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC0_CREDIT                */
/*   Description:  Fifo 13 vc0 credit underflow                         */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC0_CREDIT_SHFT 14
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC0_CREDIT_MASK 0x0000000000004000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC2_CREDIT                */
/*   Description:  Fifo 13 vc2 credit underflow                         */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC2_CREDIT_SHFT 15
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_FIFO13_VC2_CREDIT_MASK 0x0000000000008000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW0_VC0_CREDIT                      */
/*   Description:  VC0 credit underflow 0                               */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW0_VC0_CREDIT_SHFT 16
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW0_VC0_CREDIT_MASK 0x0000000000010000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW1_VC0_CREDIT                      */
/*   Description:  VC0 credit underflow 1                               */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW1_VC0_CREDIT_SHFT 17
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW1_VC0_CREDIT_MASK 0x0000000000020000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW2_VC0_CREDIT                      */
/*   Description:  VC0 credit underflow 2                               */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW2_VC0_CREDIT_SHFT 18
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW2_VC0_CREDIT_MASK 0x0000000000040000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW0_VC2_CREDIT                      */
/*   Description:  VC2 credit underflow 0                               */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW0_VC2_CREDIT_SHFT 19
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW0_VC2_CREDIT_MASK 0x0000000000080000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW1_VC2_CREDIT                      */
/*   Description:  VC2 credit underflow 1                               */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW1_VC2_CREDIT_SHFT 20
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW1_VC2_CREDIT_MASK 0x0000000000100000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW2_VC2_CREDIT                      */
/*   Description:  VC2 credit underflow 2                               */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW2_VC2_CREDIT_SHFT 21
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW2_VC2_CREDIT_MASK 0x0000000000200000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_POP                  */
/*   Description:  PI Fifo vc0 pop underflow                            */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_POP_SHFT 32
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_POP_MASK 0x0000000100000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_POP                  */
/*   Description:  PI Fifo vc2 pop underflow                            */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_POP_SHFT 33
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_POP_MASK 0x0000000200000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_POP                */
/*   Description:  IILB Fifo vc0 pop underflow                          */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_POP_SHFT 34
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_POP_MASK 0x0000000400000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_POP                */
/*   Description:  IILB Fifo vc2 pop underflow                          */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_POP_SHFT 35
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_POP_MASK 0x0000000800000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_POP                  */
/*   Description:  MD Fifo vc0 pop underflow                            */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_POP_SHFT 36
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_POP_MASK 0x0000001000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_POP                  */
/*   Description:  MD Fifo vc2 pop underflow                            */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_POP_SHFT 37
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_POP_MASK 0x0000002000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC0_POP                  */
/*   Description:  NI Fifo vc0 pop underflow                            */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC0_POP_SHFT 38
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC0_POP_MASK 0x0000004000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC2_POP                  */
/*   Description:  NI Fifo vc2 pop underflow                            */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC2_POP_SHFT 39
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC2_POP_MASK 0x0000008000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_PUSH                 */
/*   Description:  PI Fifo vc0 push underflow                           */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_PUSH_SHFT 40
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_PUSH_MASK 0x0000010000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_PUSH                 */
/*   Description:  PI Fifo vc2 push underflow                           */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_PUSH_SHFT 41
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_PUSH_MASK 0x0000020000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_PUSH               */
/*   Description:  IILB Fifo vc0 push underflow                         */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_PUSH_SHFT 42
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_PUSH_MASK 0x0000040000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_PUSH               */
/*   Description:  IILB Fifo vc2 push underflow                         */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_PUSH_SHFT 43
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_PUSH_MASK 0x0000080000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_PUSH                 */
/*   Description:  MD Fifo vc0 push underflow                           */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_PUSH_SHFT 44
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_PUSH_MASK 0x0000100000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_PUSH                 */
/*   Description:  MD Fifo vc2 push underflow                           */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_PUSH_SHFT 45
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_PUSH_MASK 0x0000200000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_CREDIT               */
/*   Description:  PI Fifo vc0 credit underflow                         */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_CREDIT_SHFT 46
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC0_CREDIT_MASK 0x0000400000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_CREDIT               */
/*   Description:  PI Fifo vc2 credit underflow                         */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_CREDIT_SHFT 47
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_PI_FIFO_VC2_CREDIT_MASK 0x0000800000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT             */
/*   Description:  IILB Fifo vc0 credit underflow                       */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT_SHFT 48
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT_MASK 0x0001000000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT             */
/*   Description:  IILB Fifo vc2 credit underflow                       */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT_SHFT 49
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT_MASK 0x0002000000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_CREDIT               */
/*   Description:  MD Fifo vc0 credit underflow                         */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_CREDIT_SHFT 50
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC0_CREDIT_MASK 0x0004000000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_CREDIT               */
/*   Description:  MD Fifo vc2 credit underflow                         */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_CREDIT_SHFT 51
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_MD_FIFO_VC2_CREDIT_MASK 0x0008000000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC0_CREDIT               */
/*   Description:  NI Fifo vc0 credit underflow                         */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC0_CREDIT_SHFT 52
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC0_CREDIT_MASK 0x0010000000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC1_CREDIT               */
/*   Description:  NI Fifo vc1 credit underflow                         */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC1_CREDIT_SHFT 53
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC1_CREDIT_MASK 0x0020000000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC2_CREDIT               */
/*   Description:  NI Fifo vc2 credit underflow                         */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC2_CREDIT_SHFT 54
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC2_CREDIT_MASK 0x0040000000000000

/*   SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC3_CREDIT               */
/*   Description:  NI Fifo vc3 credit underflow                         */
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC3_CREDIT_SHFT 55
#define SH_NI1_ERROR_OVERFLOW_2_UNDERFLOW_NI_FIFO_VC3_CREDIT_MASK 0x0080000000000000

/*   SH_NI1_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC0                           */
/*   Description:  llp deadlock vc0                                     */
#define SH_NI1_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC0_SHFT 56
#define SH_NI1_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC0_MASK 0x0100000000000000

/*   SH_NI1_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC1                           */
/*   Description:  llp deadlock vc1                                     */
#define SH_NI1_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC1_SHFT 57
#define SH_NI1_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC1_MASK 0x0200000000000000

/*   SH_NI1_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC2                           */
/*   Description:  llp deadlock vc2                                     */
#define SH_NI1_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC2_SHFT 58
#define SH_NI1_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC2_MASK 0x0400000000000000

/*   SH_NI1_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC3                           */
/*   Description:  llp deadlock vc3                                     */
#define SH_NI1_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC3_SHFT 59
#define SH_NI1_ERROR_OVERFLOW_2_LLP_DEADLOCK_VC3_MASK 0x0800000000000000

/*   SH_NI1_ERROR_OVERFLOW_2_CHIPLET_NOMATCH                            */
/*   Description:  chiplet nomatch                                      */
#define SH_NI1_ERROR_OVERFLOW_2_CHIPLET_NOMATCH_SHFT 60
#define SH_NI1_ERROR_OVERFLOW_2_CHIPLET_NOMATCH_MASK 0x1000000000000000

/*   SH_NI1_ERROR_OVERFLOW_2_LUT_READ_ERROR                             */
/*   Description:  LUT Read Error                                       */
#define SH_NI1_ERROR_OVERFLOW_2_LUT_READ_ERROR_SHFT 61
#define SH_NI1_ERROR_OVERFLOW_2_LUT_READ_ERROR_MASK 0x2000000000000000

/*   SH_NI1_ERROR_OVERFLOW_2_RETRY_TIMEOUT_ERROR                        */
/*   Description:  Retry Timeout Error                                  */
#define SH_NI1_ERROR_OVERFLOW_2_RETRY_TIMEOUT_ERROR_SHFT 62
#define SH_NI1_ERROR_OVERFLOW_2_RETRY_TIMEOUT_ERROR_MASK 0x4000000000000000

/* ==================================================================== */
/*               Register "SH_NI1_ERROR_OVERFLOW_2_ALIAS"               */
/*                    ni1 Error Overflow Bits Alias                     */
/* ==================================================================== */

#define SH_NI1_ERROR_OVERFLOW_2_ALIAS            0x0000000150040638

/* ==================================================================== */
/*                    Register "SH_NI1_ERROR_MASK_1"                    */
/*                         ni1  Error Mask Bits                         */
/* ==================================================================== */

#define SH_NI1_ERROR_MASK_1                      0x0000000150040640
#define SH_NI1_ERROR_MASK_1_MASK                 0xffffffffffffffff
#define SH_NI1_ERROR_MASK_1_INIT                 0xffffffffffffffff

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_DEBIT0                         */
/*   Description:  Fifo 02 debit0 overflow                              */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_DEBIT0_SHFT 0
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_DEBIT0_MASK 0x0000000000000001

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_DEBIT2                         */
/*   Description:  Fifo 02 debit2 overflow                              */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_DEBIT2_SHFT 1
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_DEBIT2_MASK 0x0000000000000002

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_DEBIT0                         */
/*   Description:  Fifo 13 debit0 overflow                              */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_DEBIT0_SHFT 2
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_DEBIT0_MASK 0x0000000000000004

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_DEBIT2                         */
/*   Description:  Fifo 13 debit2 overflow                              */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_DEBIT2_SHFT 3
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_DEBIT2_MASK 0x0000000000000008

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_POP                        */
/*   Description:  Fifo 02 vc0 pop overflow                             */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_POP_SHFT 4
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_POP_MASK 0x0000000000000010

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_POP                        */
/*   Description:  Fifo 02 vc2 pop overflow                             */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_POP_SHFT 5
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_POP_MASK 0x0000000000000020

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC1_POP                        */
/*   Description:  Fifo 13 vc1 pop overflow                             */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC1_POP_SHFT 6
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC1_POP_MASK 0x0000000000000040

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC3_POP                        */
/*   Description:  Fifo 13 vc3 pop overflow                             */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC3_POP_SHFT 7
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC3_POP_MASK 0x0000000000000080

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_PUSH                       */
/*   Description:  Fifo 02 vc0 push overflow                            */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_PUSH_SHFT 8
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_PUSH_MASK 0x0000000000000100

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_PUSH                       */
/*   Description:  Fifo 02 vc2 push overflow                            */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_PUSH_SHFT 9
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_PUSH_MASK 0x0000000000000200

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC1_PUSH                       */
/*   Description:  Fifo 13 vc1 push overflow                            */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC1_PUSH_SHFT 10
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC1_PUSH_MASK 0x0000000000000400

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC3_PUSH                       */
/*   Description:  Fifo 13 vc3 push overflow                            */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC3_PUSH_SHFT 11
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC3_PUSH_MASK 0x0000000000000800

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_CREDIT                     */
/*   Description:  Fifo 02 vc0 credit overflow                          */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_CREDIT_SHFT 12
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC0_CREDIT_MASK 0x0000000000001000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_CREDIT                     */
/*   Description:  Fifo 02 vc2 credit overflow                          */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_CREDIT_SHFT 13
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO02_VC2_CREDIT_MASK 0x0000000000002000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC0_CREDIT                     */
/*   Description:  Fifo 13 vc0 credit overflow                          */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC0_CREDIT_SHFT 14
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC0_CREDIT_MASK 0x0000000000004000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC2_CREDIT                     */
/*   Description:  Fifo 13 vc2 credit overflow                          */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC2_CREDIT_SHFT 15
#define SH_NI1_ERROR_MASK_1_OVERFLOW_FIFO13_VC2_CREDIT_MASK 0x0000000000008000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW0_VC0_CREDIT                           */
/*   Description:  VC0 credit overflow 0                                */
#define SH_NI1_ERROR_MASK_1_OVERFLOW0_VC0_CREDIT_SHFT 16
#define SH_NI1_ERROR_MASK_1_OVERFLOW0_VC0_CREDIT_MASK 0x0000000000010000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW1_VC0_CREDIT                           */
/*   Description:  VC0 credit overflow 1                                */
#define SH_NI1_ERROR_MASK_1_OVERFLOW1_VC0_CREDIT_SHFT 17
#define SH_NI1_ERROR_MASK_1_OVERFLOW1_VC0_CREDIT_MASK 0x0000000000020000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW2_VC0_CREDIT                           */
/*   Description:  VC0 credit overflow 2                                */
#define SH_NI1_ERROR_MASK_1_OVERFLOW2_VC0_CREDIT_SHFT 18
#define SH_NI1_ERROR_MASK_1_OVERFLOW2_VC0_CREDIT_MASK 0x0000000000040000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW0_VC2_CREDIT                           */
/*   Description:  VC2 credit overflow 0                                */
#define SH_NI1_ERROR_MASK_1_OVERFLOW0_VC2_CREDIT_SHFT 19
#define SH_NI1_ERROR_MASK_1_OVERFLOW0_VC2_CREDIT_MASK 0x0000000000080000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW1_VC2_CREDIT                           */
/*   Description:  VC2 credit overflow 1                                */
#define SH_NI1_ERROR_MASK_1_OVERFLOW1_VC2_CREDIT_SHFT 20
#define SH_NI1_ERROR_MASK_1_OVERFLOW1_VC2_CREDIT_MASK 0x0000000000100000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW2_VC2_CREDIT                           */
/*   Description:  VC2 credit overflow 2                                */
#define SH_NI1_ERROR_MASK_1_OVERFLOW2_VC2_CREDIT_SHFT 21
#define SH_NI1_ERROR_MASK_1_OVERFLOW2_VC2_CREDIT_MASK 0x0000000000200000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_DEBIT0                        */
/*   Description:  PI Fifo debit0 overflow                              */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_DEBIT0_SHFT 22
#define SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_DEBIT0_MASK 0x0000000000400000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_DEBIT2                        */
/*   Description:  PI Fifo debit2 overflow                              */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_DEBIT2_SHFT 23
#define SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_DEBIT2_MASK 0x0000000000800000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_DEBIT0                      */
/*   Description:  IILB Fifo debit0 overflow                            */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_DEBIT0_SHFT 24
#define SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_DEBIT0_MASK 0x0000000001000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_DEBIT2                      */
/*   Description:  IILB Fifo debit2 overflow                            */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_DEBIT2_SHFT 25
#define SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_DEBIT2_MASK 0x0000000002000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_DEBIT0                        */
/*   Description:  MD Fifo debit0 overflow                              */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_DEBIT0_SHFT 26
#define SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_DEBIT0_MASK 0x0000000004000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_DEBIT2                        */
/*   Description:  MD Fifo debit2 overflow                              */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_DEBIT2_SHFT 27
#define SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_DEBIT2_MASK 0x0000000008000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT0                        */
/*   Description:  NI Fifo debit0 overflow                              */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT0_SHFT 28
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT0_MASK 0x0000000010000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT1                        */
/*   Description:  NI Fifo debit1 overflow                              */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT1_SHFT 29
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT1_MASK 0x0000000020000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT2                        */
/*   Description:  NI Fifo debit2 overflow                              */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT2_SHFT 30
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT2_MASK 0x0000000040000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT3                        */
/*   Description:  NI Fifo debit3 overflow                              */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT3_SHFT 31
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_DEBIT3_MASK 0x0000000080000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_POP                       */
/*   Description:  PI Fifo vc0 pop overflow                             */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_POP_SHFT 32
#define SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_POP_MASK 0x0000000100000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_POP                       */
/*   Description:  PI Fifo vc2 pop overflow                             */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_POP_SHFT 33
#define SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_POP_MASK 0x0000000200000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_POP                     */
/*   Description:  IILB Fifo vc0 pop overflow                           */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_POP_SHFT 34
#define SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_POP_MASK 0x0000000400000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_POP                     */
/*   Description:  IILB Fifo vc2 pop overflow                           */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_POP_SHFT 35
#define SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_POP_MASK 0x0000000800000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_POP                       */
/*   Description:  MD Fifo vc0 pop overflow                             */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_POP_SHFT 36
#define SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_POP_MASK 0x0000001000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_POP                       */
/*   Description:  MD Fifo vc2 pop overflow                             */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_POP_SHFT 37
#define SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_POP_MASK 0x0000002000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC0_POP                       */
/*   Description:  NI Fifo vc0 pop overflow                             */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC0_POP_SHFT 38
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC0_POP_MASK 0x0000004000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC2_POP                       */
/*   Description:  NI Fifo vc2 pop overflow                             */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC2_POP_SHFT 39
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC2_POP_MASK 0x0000008000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_PUSH                      */
/*   Description:  PI Fifo vc0 push overflow                            */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_PUSH_SHFT 40
#define SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_PUSH_MASK 0x0000010000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_PUSH                      */
/*   Description:  PI Fifo vc2 push overflow                            */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_PUSH_SHFT 41
#define SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_PUSH_MASK 0x0000020000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_PUSH                    */
/*   Description:  IILB Fifo vc0 push overflow                          */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_PUSH_SHFT 42
#define SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_PUSH_MASK 0x0000040000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_PUSH                    */
/*   Description:  IILB Fifo vc2 push overflow                          */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_PUSH_SHFT 43
#define SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_PUSH_MASK 0x0000080000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_PUSH                      */
/*   Description:  MD Fifo vc0 push overflow                            */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_PUSH_SHFT 44
#define SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_PUSH_MASK 0x0000100000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_PUSH                      */
/*   Description:  MD Fifo vc2 push overflow                            */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_PUSH_SHFT 45
#define SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_PUSH_MASK 0x0000200000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_CREDIT                    */
/*   Description:  PI Fifo vc0 credit overflow                          */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_CREDIT_SHFT 46
#define SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC0_CREDIT_MASK 0x0000400000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_CREDIT                    */
/*   Description:  PI Fifo vc2 credit overflow                          */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_CREDIT_SHFT 47
#define SH_NI1_ERROR_MASK_1_OVERFLOW_PI_FIFO_VC2_CREDIT_MASK 0x0000800000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_CREDIT                  */
/*   Description:  IILB Fifo vc0 credit overflow                        */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_CREDIT_SHFT 48
#define SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC0_CREDIT_MASK 0x0001000000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_CREDIT                  */
/*   Description:  IILB Fifo vc2 credit overflow                        */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_CREDIT_SHFT 49
#define SH_NI1_ERROR_MASK_1_OVERFLOW_IILB_FIFO_VC2_CREDIT_MASK 0x0002000000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_CREDIT                    */
/*   Description:  MD Fifo vc0 credit overflow                          */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_CREDIT_SHFT 50
#define SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC0_CREDIT_MASK 0x0004000000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_CREDIT                    */
/*   Description:  MD Fifo vc2 credit overflow                          */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_CREDIT_SHFT 51
#define SH_NI1_ERROR_MASK_1_OVERFLOW_MD_FIFO_VC2_CREDIT_MASK 0x0008000000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC0_CREDIT                    */
/*   Description:  NI Fifo vc0 credit overflow                          */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC0_CREDIT_SHFT 52
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC0_CREDIT_MASK 0x0010000000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC1_CREDIT                    */
/*   Description:  NI Fifo vc1 credit overflow                          */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC1_CREDIT_SHFT 53
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC1_CREDIT_MASK 0x0020000000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC2_CREDIT                    */
/*   Description:  NI Fifo vc2 credit overflow                          */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC2_CREDIT_SHFT 54
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC2_CREDIT_MASK 0x0040000000000000

/*   SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC3_CREDIT                    */
/*   Description:  NI Fifo vc3 credit overflow                          */
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC3_CREDIT_SHFT 55
#define SH_NI1_ERROR_MASK_1_OVERFLOW_NI_FIFO_VC3_CREDIT_MASK 0x0080000000000000

/*   SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_FIFO02_VC0                        */
/*   Description:  Fifo02 vc0 tail timeout                              */
#define SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_FIFO02_VC0_SHFT 56
#define SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_FIFO02_VC0_MASK 0x0100000000000000

/*   SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_FIFO02_VC2                        */
/*   Description:  Fifo02 vc2 tail timeout                              */
#define SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_FIFO02_VC2_SHFT 57
#define SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_FIFO02_VC2_MASK 0x0200000000000000

/*   SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_FIFO13_VC1                        */
/*   Description:  Fifo13 vc1 tail timeout                              */
#define SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_FIFO13_VC1_SHFT 58
#define SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_FIFO13_VC1_MASK 0x0400000000000000

/*   SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_FIFO13_VC3                        */
/*   Description:  Fifo13 vc3 tail timeout                              */
#define SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_FIFO13_VC3_SHFT 59
#define SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_FIFO13_VC3_MASK 0x0800000000000000

/*   SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC0                            */
/*   Description:  NI vc0 tail timeout                                  */
#define SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC0_SHFT 60
#define SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC0_MASK 0x1000000000000000

/*   SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC1                            */
/*   Description:  NI vc1 tail timeout                                  */
#define SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC1_SHFT 61
#define SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC1_MASK 0x2000000000000000

/*   SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC2                            */
/*   Description:  NI vc2 tail timeout                                  */
#define SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC2_SHFT 62
#define SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC2_MASK 0x4000000000000000

/*   SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC3                            */
/*   Description:  NI vc3 tail timeout                                  */
#define SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC3_SHFT 63
#define SH_NI1_ERROR_MASK_1_TAIL_TIMEOUT_NI_VC3_MASK 0x8000000000000000

/* ==================================================================== */
/*                    Register "SH_NI1_ERROR_MASK_2"                    */
/*                         ni1  Error Mask Bits                         */
/* ==================================================================== */

#define SH_NI1_ERROR_MASK_2                      0x0000000150040650
#define SH_NI1_ERROR_MASK_2_MASK                 0x7fffffff003fffff
#define SH_NI1_ERROR_MASK_2_INIT                 0x7fffffff003fffff

/*   SH_NI1_ERROR_MASK_2_ILLEGAL_VCNI                                   */
/*   Description:  Illegal VC NI                                        */
#define SH_NI1_ERROR_MASK_2_ILLEGAL_VCNI_SHFT    0
#define SH_NI1_ERROR_MASK_2_ILLEGAL_VCNI_MASK    0x0000000000000001

/*   SH_NI1_ERROR_MASK_2_ILLEGAL_VCPI                                   */
/*   Description:  Illegal VC PI                                        */
#define SH_NI1_ERROR_MASK_2_ILLEGAL_VCPI_SHFT    1
#define SH_NI1_ERROR_MASK_2_ILLEGAL_VCPI_MASK    0x0000000000000002

/*   SH_NI1_ERROR_MASK_2_ILLEGAL_VCMD                                   */
/*   Description:  Illegal VC MD                                        */
#define SH_NI1_ERROR_MASK_2_ILLEGAL_VCMD_SHFT    2
#define SH_NI1_ERROR_MASK_2_ILLEGAL_VCMD_MASK    0x0000000000000004

/*   SH_NI1_ERROR_MASK_2_ILLEGAL_VCIILB                                 */
/*   Description:  Illegal VC IILB                                      */
#define SH_NI1_ERROR_MASK_2_ILLEGAL_VCIILB_SHFT  3
#define SH_NI1_ERROR_MASK_2_ILLEGAL_VCIILB_MASK  0x0000000000000008

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_POP                       */
/*   Description:  Fifo 02 vc0 pop underflow                            */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_POP_SHFT 4
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_POP_MASK 0x0000000000000010

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_POP                       */
/*   Description:  Fifo 02 vc2 pop underflow                            */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_POP_SHFT 5
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_POP_MASK 0x0000000000000020

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC1_POP                       */
/*   Description:  Fifo 13 vc1 pop underflow                            */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC1_POP_SHFT 6
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC1_POP_MASK 0x0000000000000040

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC3_POP                       */
/*   Description:  Fifo 13 vc3 pop underflow                            */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC3_POP_SHFT 7
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC3_POP_MASK 0x0000000000000080

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_PUSH                      */
/*   Description:  Fifo 02 vc0 push underflow                           */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_PUSH_SHFT 8
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_PUSH_MASK 0x0000000000000100

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_PUSH                      */
/*   Description:  Fifo 02 vc2 push underflow                           */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_PUSH_SHFT 9
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_PUSH_MASK 0x0000000000000200

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC1_PUSH                      */
/*   Description:  Fifo 13 vc1 push underflow                           */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC1_PUSH_SHFT 10
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC1_PUSH_MASK 0x0000000000000400

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC3_PUSH                      */
/*   Description:  Fifo 13 vc3 push underflow                           */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC3_PUSH_SHFT 11
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC3_PUSH_MASK 0x0000000000000800

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_CREDIT                    */
/*   Description:  Fifo 02 vc0 credit underflow                         */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_CREDIT_SHFT 12
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC0_CREDIT_MASK 0x0000000000001000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_CREDIT                    */
/*   Description:  Fifo 02 vc2 credit underflow                         */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_CREDIT_SHFT 13
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO02_VC2_CREDIT_MASK 0x0000000000002000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC0_CREDIT                    */
/*   Description:  Fifo 13 vc0 credit underflow                         */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC0_CREDIT_SHFT 14
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC0_CREDIT_MASK 0x0000000000004000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC2_CREDIT                    */
/*   Description:  Fifo 13 vc2 credit underflow                         */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC2_CREDIT_SHFT 15
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_FIFO13_VC2_CREDIT_MASK 0x0000000000008000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW0_VC0_CREDIT                          */
/*   Description:  VC0 credit underflow 0                               */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW0_VC0_CREDIT_SHFT 16
#define SH_NI1_ERROR_MASK_2_UNDERFLOW0_VC0_CREDIT_MASK 0x0000000000010000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW1_VC0_CREDIT                          */
/*   Description:  VC0 credit underflow 1                               */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW1_VC0_CREDIT_SHFT 17
#define SH_NI1_ERROR_MASK_2_UNDERFLOW1_VC0_CREDIT_MASK 0x0000000000020000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW2_VC0_CREDIT                          */
/*   Description:  VC0 credit underflow 2                               */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW2_VC0_CREDIT_SHFT 18
#define SH_NI1_ERROR_MASK_2_UNDERFLOW2_VC0_CREDIT_MASK 0x0000000000040000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW0_VC2_CREDIT                          */
/*   Description:  VC2 credit underflow 0                               */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW0_VC2_CREDIT_SHFT 19
#define SH_NI1_ERROR_MASK_2_UNDERFLOW0_VC2_CREDIT_MASK 0x0000000000080000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW1_VC2_CREDIT                          */
/*   Description:  VC2 credit underflow 1                               */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW1_VC2_CREDIT_SHFT 20
#define SH_NI1_ERROR_MASK_2_UNDERFLOW1_VC2_CREDIT_MASK 0x0000000000100000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW2_VC2_CREDIT                          */
/*   Description:  VC2 credit underflow 2                               */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW2_VC2_CREDIT_SHFT 21
#define SH_NI1_ERROR_MASK_2_UNDERFLOW2_VC2_CREDIT_MASK 0x0000000000200000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_POP                      */
/*   Description:  PI Fifo vc0 pop underflow                            */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_POP_SHFT 32
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_POP_MASK 0x0000000100000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_POP                      */
/*   Description:  PI Fifo vc2 pop underflow                            */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_POP_SHFT 33
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_POP_MASK 0x0000000200000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_POP                    */
/*   Description:  IILB Fifo vc0 pop underflow                          */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_POP_SHFT 34
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_POP_MASK 0x0000000400000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_POP                    */
/*   Description:  IILB Fifo vc2 pop underflow                          */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_POP_SHFT 35
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_POP_MASK 0x0000000800000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_POP                      */
/*   Description:  MD Fifo vc0 pop underflow                            */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_POP_SHFT 36
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_POP_MASK 0x0000001000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_POP                      */
/*   Description:  MD Fifo vc2 pop underflow                            */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_POP_SHFT 37
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_POP_MASK 0x0000002000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC0_POP                      */
/*   Description:  NI Fifo vc0 pop underflow                            */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC0_POP_SHFT 38
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC0_POP_MASK 0x0000004000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC2_POP                      */
/*   Description:  NI Fifo vc2 pop underflow                            */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC2_POP_SHFT 39
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC2_POP_MASK 0x0000008000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_PUSH                     */
/*   Description:  PI Fifo vc0 push underflow                           */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_PUSH_SHFT 40
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_PUSH_MASK 0x0000010000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_PUSH                     */
/*   Description:  PI Fifo vc2 push underflow                           */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_PUSH_SHFT 41
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_PUSH_MASK 0x0000020000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_PUSH                   */
/*   Description:  IILB Fifo vc0 push underflow                         */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_PUSH_SHFT 42
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_PUSH_MASK 0x0000040000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_PUSH                   */
/*   Description:  IILB Fifo vc2 push underflow                         */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_PUSH_SHFT 43
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_PUSH_MASK 0x0000080000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_PUSH                     */
/*   Description:  MD Fifo vc0 push underflow                           */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_PUSH_SHFT 44
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_PUSH_MASK 0x0000100000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_PUSH                     */
/*   Description:  MD Fifo vc2 push underflow                           */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_PUSH_SHFT 45
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_PUSH_MASK 0x0000200000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_CREDIT                   */
/*   Description:  PI Fifo vc0 credit underflow                         */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_CREDIT_SHFT 46
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC0_CREDIT_MASK 0x0000400000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_CREDIT                   */
/*   Description:  PI Fifo vc2 credit underflow                         */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_CREDIT_SHFT 47
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_PI_FIFO_VC2_CREDIT_MASK 0x0000800000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT                 */
/*   Description:  IILB Fifo vc0 credit underflow                       */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT_SHFT 48
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC0_CREDIT_MASK 0x0001000000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT                 */
/*   Description:  IILB Fifo vc2 credit underflow                       */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT_SHFT 49
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_IILB_FIFO_VC2_CREDIT_MASK 0x0002000000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_CREDIT                   */
/*   Description:  MD Fifo vc0 credit underflow                         */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_CREDIT_SHFT 50
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC0_CREDIT_MASK 0x0004000000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_CREDIT                   */
/*   Description:  MD Fifo vc2 credit underflow                         */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_CREDIT_SHFT 51
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_MD_FIFO_VC2_CREDIT_MASK 0x0008000000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC0_CREDIT                   */
/*   Description:  NI Fifo vc0 credit underflow                         */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC0_CREDIT_SHFT 52
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC0_CREDIT_MASK 0x0010000000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC1_CREDIT                   */
/*   Description:  NI Fifo vc1 credit underflow                         */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC1_CREDIT_SHFT 53
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC1_CREDIT_MASK 0x0020000000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC2_CREDIT                   */
/*   Description:  NI Fifo vc2 credit underflow                         */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC2_CREDIT_SHFT 54
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC2_CREDIT_MASK 0x0040000000000000

/*   SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC3_CREDIT                   */
/*   Description:  NI Fifo vc3 credit underflow                         */
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC3_CREDIT_SHFT 55
#define SH_NI1_ERROR_MASK_2_UNDERFLOW_NI_FIFO_VC3_CREDIT_MASK 0x0080000000000000

/*   SH_NI1_ERROR_MASK_2_LLP_DEADLOCK_VC0                               */
/*   Description:  llp deadlock vc0                                     */
#define SH_NI1_ERROR_MASK_2_LLP_DEADLOCK_VC0_SHFT 56
#define SH_NI1_ERROR_MASK_2_LLP_DEADLOCK_VC0_MASK 0x0100000000000000

/*   SH_NI1_ERROR_MASK_2_LLP_DEADLOCK_VC1                               */
/*   Description:  llp deadlock vc1                                     */
#define SH_NI1_ERROR_MASK_2_LLP_DEADLOCK_VC1_SHFT 57
#define SH_NI1_ERROR_MASK_2_LLP_DEADLOCK_VC1_MASK 0x0200000000000000

/*   SH_NI1_ERROR_MASK_2_LLP_DEADLOCK_VC2                               */
/*   Description:  llp deadlock vc2                                     */
#define SH_NI1_ERROR_MASK_2_LLP_DEADLOCK_VC2_SHFT 58
#define SH_NI1_ERROR_MASK_2_LLP_DEADLOCK_VC2_MASK 0x0400000000000000

/*   SH_NI1_ERROR_MASK_2_LLP_DEADLOCK_VC3                               */
/*   Description:  llp deadlock vc3                                     */
#define SH_NI1_ERROR_MASK_2_LLP_DEADLOCK_VC3_SHFT 59
#define SH_NI1_ERROR_MASK_2_LLP_DEADLOCK_VC3_MASK 0x0800000000000000

/*   SH_NI1_ERROR_MASK_2_CHIPLET_NOMATCH                                */
/*   Description:  chiplet nomatch                                      */
#define SH_NI1_ERROR_MASK_2_CHIPLET_NOMATCH_SHFT 60
#define SH_NI1_ERROR_MASK_2_CHIPLET_NOMATCH_MASK 0x1000000000000000

/*   SH_NI1_ERROR_MASK_2_LUT_READ_ERROR                                 */
/*   Description:  LUT Read Error                                       */
#define SH_NI1_ERROR_MASK_2_LUT_READ_ERROR_SHFT  61
#define SH_NI1_ERROR_MASK_2_LUT_READ_ERROR_MASK  0x2000000000000000

/*   SH_NI1_ERROR_MASK_2_RETRY_TIMEOUT_ERROR                            */
/*   Description:  Retry Timeout Error                                  */
#define SH_NI1_ERROR_MASK_2_RETRY_TIMEOUT_ERROR_SHFT 62
#define SH_NI1_ERROR_MASK_2_RETRY_TIMEOUT_ERROR_MASK 0x4000000000000000

/* ==================================================================== */
/*                   Register "SH_NI1_FIRST_ERROR_1"                    */
/*                        ni1  First Error Bits                         */
/* ==================================================================== */

#define SH_NI1_FIRST_ERROR_1                     0x0000000150040660
#define SH_NI1_FIRST_ERROR_1_MASK                0xffffffffffffffff
#define SH_NI1_FIRST_ERROR_1_INIT                0xffffffffffffffff

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_DEBIT0                        */
/*   Description:  Fifo 02 debit0 overflow                              */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_DEBIT0_SHFT 0
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_DEBIT0_MASK 0x0000000000000001

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_DEBIT2                        */
/*   Description:  Fifo 02 debit2 overflow                              */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_DEBIT2_SHFT 1
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_DEBIT2_MASK 0x0000000000000002

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_DEBIT0                        */
/*   Description:  Fifo 13 debit0 overflow                              */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_DEBIT0_SHFT 2
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_DEBIT0_MASK 0x0000000000000004

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_DEBIT2                        */
/*   Description:  Fifo 13 debit2 overflow                              */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_DEBIT2_SHFT 3
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_DEBIT2_MASK 0x0000000000000008

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_POP                       */
/*   Description:  Fifo 02 vc0 pop overflow                             */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_POP_SHFT 4
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_POP_MASK 0x0000000000000010

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_POP                       */
/*   Description:  Fifo 02 vc2 pop overflow                             */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_POP_SHFT 5
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_POP_MASK 0x0000000000000020

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC1_POP                       */
/*   Description:  Fifo 13 vc1 pop overflow                             */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC1_POP_SHFT 6
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC1_POP_MASK 0x0000000000000040

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC3_POP                       */
/*   Description:  Fifo 13 vc3 pop overflow                             */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC3_POP_SHFT 7
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC3_POP_MASK 0x0000000000000080

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_PUSH                      */
/*   Description:  Fifo 02 vc0 push overflow                            */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_PUSH_SHFT 8
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_PUSH_MASK 0x0000000000000100

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_PUSH                      */
/*   Description:  Fifo 02 vc2 push overflow                            */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_PUSH_SHFT 9
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_PUSH_MASK 0x0000000000000200

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC1_PUSH                      */
/*   Description:  Fifo 13 vc1 push overflow                            */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC1_PUSH_SHFT 10
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC1_PUSH_MASK 0x0000000000000400

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC3_PUSH                      */
/*   Description:  Fifo 13 vc3 push overflow                            */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC3_PUSH_SHFT 11
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC3_PUSH_MASK 0x0000000000000800

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_CREDIT                    */
/*   Description:  Fifo 02 vc0 credit overflow                          */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_CREDIT_SHFT 12
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC0_CREDIT_MASK 0x0000000000001000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_CREDIT                    */
/*   Description:  Fifo 02 vc2 credit overflow                          */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_CREDIT_SHFT 13
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO02_VC2_CREDIT_MASK 0x0000000000002000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC0_CREDIT                    */
/*   Description:  Fifo 13 vc0 credit overflow                          */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC0_CREDIT_SHFT 14
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC0_CREDIT_MASK 0x0000000000004000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC2_CREDIT                    */
/*   Description:  Fifo 13 vc2 credit overflow                          */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC2_CREDIT_SHFT 15
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_FIFO13_VC2_CREDIT_MASK 0x0000000000008000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW0_VC0_CREDIT                          */
/*   Description:  VC0 credit overflow 0                                */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW0_VC0_CREDIT_SHFT 16
#define SH_NI1_FIRST_ERROR_1_OVERFLOW0_VC0_CREDIT_MASK 0x0000000000010000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW1_VC0_CREDIT                          */
/*   Description:  VC0 credit overflow 1                                */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW1_VC0_CREDIT_SHFT 17
#define SH_NI1_FIRST_ERROR_1_OVERFLOW1_VC0_CREDIT_MASK 0x0000000000020000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW2_VC0_CREDIT                          */
/*   Description:  VC0 credit overflow 2                                */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW2_VC0_CREDIT_SHFT 18
#define SH_NI1_FIRST_ERROR_1_OVERFLOW2_VC0_CREDIT_MASK 0x0000000000040000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW0_VC2_CREDIT                          */
/*   Description:  VC2 credit overflow 0                                */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW0_VC2_CREDIT_SHFT 19
#define SH_NI1_FIRST_ERROR_1_OVERFLOW0_VC2_CREDIT_MASK 0x0000000000080000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW1_VC2_CREDIT                          */
/*   Description:  VC2 credit overflow 1                                */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW1_VC2_CREDIT_SHFT 20
#define SH_NI1_FIRST_ERROR_1_OVERFLOW1_VC2_CREDIT_MASK 0x0000000000100000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW2_VC2_CREDIT                          */
/*   Description:  VC2 credit overflow 2                                */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW2_VC2_CREDIT_SHFT 21
#define SH_NI1_FIRST_ERROR_1_OVERFLOW2_VC2_CREDIT_MASK 0x0000000000200000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_DEBIT0                       */
/*   Description:  PI Fifo debit0 overflow                              */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_DEBIT0_SHFT 22
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_DEBIT0_MASK 0x0000000000400000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_DEBIT2                       */
/*   Description:  PI Fifo debit2 overflow                              */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_DEBIT2_SHFT 23
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_DEBIT2_MASK 0x0000000000800000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_DEBIT0                     */
/*   Description:  IILB Fifo debit0 overflow                            */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_DEBIT0_SHFT 24
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_DEBIT0_MASK 0x0000000001000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_DEBIT2                     */
/*   Description:  IILB Fifo debit2 overflow                            */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_DEBIT2_SHFT 25
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_DEBIT2_MASK 0x0000000002000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_MD_FIFO_DEBIT0                       */
/*   Description:  MD Fifo debit0 overflow                              */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_MD_FIFO_DEBIT0_SHFT 26
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_MD_FIFO_DEBIT0_MASK 0x0000000004000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_MD_FIFO_DEBIT2                       */
/*   Description:  MD Fifo debit2 overflow                              */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_MD_FIFO_DEBIT2_SHFT 27
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_MD_FIFO_DEBIT2_MASK 0x0000000008000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT0                       */
/*   Description:  NI Fifo debit0 overflow                              */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT0_SHFT 28
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT0_MASK 0x0000000010000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT1                       */
/*   Description:  NI Fifo debit1 overflow                              */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT1_SHFT 29
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT1_MASK 0x0000000020000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT2                       */
/*   Description:  NI Fifo debit2 overflow                              */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT2_SHFT 30
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT2_MASK 0x0000000040000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT3                       */
/*   Description:  NI Fifo debit3 overflow                              */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT3_SHFT 31
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_DEBIT3_MASK 0x0000000080000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC0_POP                      */
/*   Description:  PI Fifo vc0 pop overflow                             */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC0_POP_SHFT 32
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC0_POP_MASK 0x0000000100000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC2_POP                      */
/*   Description:  PI Fifo vc2 pop overflow                             */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC2_POP_SHFT 33
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC2_POP_MASK 0x0000000200000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC0_POP                    */
/*   Description:  IILB Fifo vc0 pop overflow                           */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC0_POP_SHFT 34
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC0_POP_MASK 0x0000000400000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC2_POP                    */
/*   Description:  IILB Fifo vc2 pop overflow                           */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC2_POP_SHFT 35
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC2_POP_MASK 0x0000000800000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC0_POP                      */
/*   Description:  MD Fifo vc0 pop overflow                             */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC0_POP_SHFT 36
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC0_POP_MASK 0x0000001000000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC2_POP                      */
/*   Description:  MD Fifo vc2 pop overflow                             */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC2_POP_SHFT 37
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_MD_FIFO_VC2_POP_MASK 0x0000002000000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC0_POP                      */
/*   Description:  NI Fifo vc0 pop overflow                             */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC0_POP_SHFT 38
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC0_POP_MASK 0x0000004000000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC2_POP                      */
/*   Description:  NI Fifo vc2 pop overflow                             */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC2_POP_SHFT 39
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_NI_FIFO_VC2_POP_MASK 0x0000008000000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC0_PUSH                     */
/*   Description:  PI Fifo vc0 push overflow                            */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC0_PUSH_SHFT 40
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC0_PUSH_MASK 0x0000010000000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC2_PUSH                     */
/*   Description:  PI Fifo vc2 push overflow                            */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC2_PUSH_SHFT 41
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_PI_FIFO_VC2_PUSH_MASK 0x0000020000000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC0_PUSH                   */
/*   Description:  IILB Fifo vc0 push overflow                          */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC0_PUSH_SHFT 42
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC0_PUSH_MASK 0x0000040000000000

/*   SH_NI1_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_VC2_PUSH                   */
/*   Description:  IILB Fifo vc2 push overflow                          */
#define SH_NI1_FIRST_ERROR_1_OVERFLOW_IILB_FIFO_