#ifndef _ARCH_ARM_MFTB2_h_
#define _ARCH_ARM_MFTB2_h_

// Defines for arch/arm/mm/mm-sa1100.h
#define TRIZEPS_PHYS_VIRT_MAP_SIZE   0x00800000l

// physical address (only for mm-sa1100.h)
#define TRIZEPS_PHYS_IO_BASE         0x30000000l
#define TRIZEPS_PHYS_MEM_BASE        0x38000000l

// virtual
#define TRIZEPS_IO_BASE		     0xF0000000l
#define TRIZEPS_MEM_BASE             0xF2000000l

// Offsets for phys and virtual
#define TRIZEPS_OFFSET_REG0          0x00300000l
#define TRIZEPS_OFFSET_REG1          0x00380000l
#define TRIZEPS_OFFSET_IDE_CS0       0x00000000l
#define TRIZEPS_OFFSET_IDE_CS1       0x00080000l
#define TRIZEPS_OFFSET_UART5         0x00100000l
#define TRIZEPS_OFFSET_UART6         0x00180000l
#define TRIZEPS_PHYS_REG0            (TRIZEPS_PHYS_IO_BASE + TRIZEPS_OFFSET_REG0)
#define TRIZEPS_PHYS_REG1            (TRIZEPS_PHYS_IO_BASE + TRIZEPS_OFFSET_REG1)
#define TRIZEPS_PHYS_IDE_CS0         (TRIZEPS_PHYS_IO_BASE + TRIZEPS_OFFSET_IDE_CS0)
#define TRIZEPS_PHYS_IDE_CS1         (TRIZEPS_PHYS_IO_BASE + TRIZEPS_OFFSET_IDE_CS1)
#define TRIZEPS_PHYS_UART5           (TRIZEPS_PHYS_IO_BASE + TRIZEPS_OFFSET_UART5)
#define TRIZEPS_PHYS_UART6           (TRIZEPS_PHYS_IO_BASE + TRIZEPS_OFFSET_UART6)

// Use follow defines in devices
// virtual address
#define TRIZEPS_REG0    (TRIZEPS_IO_BASE + TRIZEPS_OFFSET_REG0)
#define TRIZEPS_REG1    (TRIZEPS_IO_BASE + TRIZEPS_OFFSET_REG1)
#define TRIZEPS_IDE_CS0 (TRIZEPS_IO_BASE + TRIZEPS_OFFSET_IDE_CS0)
#define TRIZEPS_IDE_CS1 (TRIZEPS_IO_BASE + TRIZEPS_OFFSET_IDE_CS1)
#define TRIZEPS_UART5   (TRIZEPS_IO_BASE + TRIZEPS_OFFSET_UART5)
#define TRIZEPS_UART6   (TRIZEPS_IO_BASE + TRIZEPS_OFFSET_UART6)

#define TRIZEPS_BAUD_BASE 1500000

//#if 0 //temporarily disabled
#ifndef __ASSEMBLY__
struct tri_uart_cts_data_t {
    int cts_gpio;
    int cts_prev_state;
    struct uart_info *info;
    struct uart_port *port;
    const char *name;
};
#endif /* __ASSEMBLY__ */

/* Defines for MFTB2 serial_sa1100.c hardware handshaking lines */
#define SERIAL_FULL
#define NOT_CONNECTED	0
#ifdef SERIAL_FULL
#define TRIZEPS_GPIO_UART1_RTS	GPIO_GPIO14
#define TRIZEPS_GPIO_UART1_DTR	NOT_CONNECTED //GPIO_GPIO9
#define TRIZEPS_GPIO_UART1_CTS	GPIO_GPIO15
#define TRIZEPS_GPIO_UART1_DCD	NOT_CONNECTED //GPIO_GPIO2
#define TRIZEPS_GPIO_UART1_DSR	NOT_CONNECTED //GPIO_GPIO3
#define TRIZEPS_GPIO_UART3_RTS	NOT_CONNECTED //GPIO_GPIO7
#define TRIZEPS_GPIO_UART3_DTR	NOT_CONNECTED //GPIO_GPIO8
#define TRIZEPS_GPIO_UART3_CTS	NOT_CONNECTED //GPIO_GPIO4
#define TRIZEPS_GPIO_UART3_DCD	NOT_CONNECTED //GPIO_GPIO5
#define TRIZEPS_GPIO_UART3_DSR	NOT_CONNECTED //GPIO_GPIO6

#define TRIZEPS_GPIO_UART2_RTS	NOT_CONNECTED //GPIO_GPIO7
#define TRIZEPS_GPIO_UART2_DTR	NOT_CONNECTED //GPIO_GPIO8
#define TRIZEPS_GPIO_UART2_CTS	NOT_CONNECTED //GPIO_GPIO4
#define TRIZEPS_GPIO_UART2_DCD	NOT_CONNECTED //GPIO_GPIO5
#define TRIZEPS_GPIO_UART2_DSR	NOT_CONNECTED //GPIO_GPIO6

#define TRIZEPS_IRQ_UART1_CTS	IRQ_GPIO15
#define TRIZEPS_IRQ_UART1_DCD	NO_IRQ //IRQ_GPIO2
#define TRIZEPS_IRQ_UART1_DSR	NO_IRQ //IRQ_GPIO3
#define TRIZEPS_IRQ_UART3_CTS	NO_IRQ //IRQ_GPIO4
#define TRIZEPS_IRQ_UART3_DCD	NO_IRQ //IRQ_GPIO5
#define TRIZEPS_IRQ_UART3_DSR	NO_IRQ //IRQ_GPIO6

#define TRIZEPS_IRQ_UART2_CTS	NO_IRQ //IRQ_GPIO4
#define TRIZEPS_IRQ_UART2_DCD	NO_IRQ //IRQ_GPIO5
#define TRIZEPS_IRQ_UART2_DSR	NO_IRQ //IRQ_GPIO6

#endif /* SERIAL_FULL */
//#endif //0

/*
 * This section contains the defines for the MFTB2 implementation
 * of drivers/ide/hd.c. HD_IOBASE_0 and HD_IOBASE_1 have to be
 * adjusted if hardware changes.
 */
#define TRIZEPS_IRQ_IDE 10		/* MFTB2 specific */

/*---   ROOT   ---*/
#define TRIZEPS_GPIO_ROOT_NFS       0
#define TRIZEPS_GPIO_ROOT_HD        21
/*---  PCMCIA  ---*/
#define TRIZEPS_GPIO_PCMCIA_IRQ0 1
#define TRIZEPS_GPIO_PCMCIA_CD0  24
#define TRIZEPS_IRQ_PCMCIA_IRQ0  TRIZEPS_GPIO_PCMCIA_IRQ0
#define TRIZEPS_IRQ_PCMCIA_CD0   TRIZEPS_GPIO_PCMCIA_CD0 + 32 - 11

// REGISTER 0 -> 0x0XXXX (16bit access)
// read only
#define TRIZEPS_A_STAT             0x8000l
#define TRIZEPS_F_STAT             0x4000l
#define TRIZEPS_BATT_FAULT_EN      0x2000l
#define TRIZEPS_nDQ                0x1000l
#define TRIZEPS_MFT_OFF            0x0800l
#define TRIZEPS_D_APWOFF           0x0400l
#define TRIZEPS_F_CTRL             0x0200l
#define TRIZEPS_F_STOP             0x0100l

// read / write
#define TRIZEPS_KP_IR_EN           0x0080l
#define TRIZEPS_FIR                0x0040l
#define TRIZEPS_BAR_ON             0x0020l
#define TRIZEPS_VCI_ON             0x0010l
#define TRIZEPS_LED4               0x0008l
#define TRIZEPS_LED3               0x0004l
#define TRIZEPS_LED2               0x0002l
#define TRIZEPS_LED1               0x0001l

// REGISTER 1 -> 0x1XXXX (16bit access)
// read only
#define TRIZEPS_nVCI2              0x8000l
#define TRIZEPS_nAB_LOW            0x4000l
#define TRIZEPS_nMB_DEAD           0x2000l
#define TRIZEPS_nMB_LOW            0x1000l
#define TRIZEPS_nPCM_VS2           0x0800l
#define TRIZEPS_nPCM_VS1           0x0400l
#define TRIZEPS_PCM_BVD2           0x0200l
#define TRIZEPS_PCM_BVD1           0x0100l

// read / write
#define TRIZEPS_nROOT_NFS          0x0080l
#define TRIZEPS_nROOT_HD           0x0040l
#define TRIZEPS_nPCM_ENA_REG       0x0020l
#define TRIZEPS_nPCM_RESET_DISABLE 0x0010l
#define TRIZEPS_PCM_EN0_REG        0x0008l
#define TRIZEPS_PCM_EN1_REG        0x0004l
#define TRIZEPS_PCM_V3_EN_REG      0x0002l
#define TRIZEPS_PCM_V5_EN_REG      0x0001l

/* Access to Board Control Register */
#define TRIZEPS_BCR0 (*(volatile unsigned short *)(TRIZEPS_REG0))
#define TRIZEPS_BCR1 (*(volatile unsigned short *)(TRIZEPS_REG1))

#define TRIZEPS_BCR_set( reg, x ) do { \
	unsigned long flags; \
	local_irq_save(flags); \
	(reg) |= (x); \
	local_irq_restore(flags); \
} while (0)

#define TRIZEPS_BCR_clear( reg, x ) do { \
	unsigned long flags; \
	local_irq_save(flags); \
	(reg) &= ~(x); \
	local_irq_restore(flags); \
} while (0)

#define TRIZEPS_OFFSET_KP_REG      0x00200000l
#define TRIZEPS_OFFSET_VCI2        0x00280000l
#define TRIZEPS_OFFSET_VCI4        0x00400000l

#define TRIZEPS_OFFSET_VCI2_1_DPR  (TRIZEPS_OFFSET_VCI2 + 0x00010000l)
#define TRIZEPS_OFFSET_VCI2_2_DPR  (TRIZEPS_OFFSET_VCI2 + 0x00018000l)
#define TRIZEPS_OFFSET_VCI2_1_SEMA (TRIZEPS_OFFSET_VCI2 + 0x00020000l)
#define TRIZEPS_OFFSET_VCI2_2_SEMA (TRIZEPS_OFFSET_VCI2 + 0x00028000l)

#define TRIZEPS_OFFSET_VCI4_1_DPR  (TRIZEPS_OFFSET_VCI4 + 0x00000000l)
#define TRIZEPS_OFFSET_VCI4_2_DPR  (TRIZEPS_OFFSET_VCI4 + 0x00008000l)
#define TRIZEPS_OFFSET_VCI4_1_SEMA (TRIZEPS_OFFSET_VCI4 + 0x00000380l)
#define TRIZEPS_OFFSET_VCI4_2_SEMA (TRIZEPS_OFFSET_VCI4 + 0x00000388l)
#define TRIZEPS_OFFSET_VCI4_1_CNTR (TRIZEPS_OFFSET_VCI4 + 0x00000390l)
#define TRIZEPS_OFFSET_VCI4_2_CNTR (TRIZEPS_OFFSET_VCI4 + 0x00000392l)

#define TRIZEPS_PHYS_KP_REG        (PHYS_TRIZEPS_IO_BASE + TRIZEPS_OFFSET_KP_REG)

// VCI address
#define TRIZEPS_PHYS_VCI2_1_DPR    (TRIZEPS_PHYS_MEM_BASE + TRIZEPS_OFFSET_VCI2_1_DPR)
#define TRIZEPS_PHYS_VCI2_2_DPR    (TRIZEPS_PHYS_MEM_BASE + TRIZEPS_OFFSET_VCI2_2_DPR)
#define TRIZEPS_PHYS_VCI2_1_SEMA   (TRIZEPS_PHYS_MEM_BASE + TRIZEPS_OFFSET_VCI2_1_SEMA)
#define TRIZEPS_PHYS_VCI2_2_SEMA   (TRIZEPS_PHYS_MEM_BASE + TRIZEPS_OFFSET_VCI2_2_SEMA)

// VCI4 address
#define TRIZEPS_PHYS_VCI4_1_DPR    (TRIZEPS_PHYS_MEM_BASE + TRIZEPS_OFFSET_VCI4_1_DPR)
#define TRIZEPS_PHYS_VCI4_2_DPR    (TRIZEPS_PHYS_MEM_BASE + TRIZEPS_OFFSET_VCI4_2_DPR)
#define TRIZEPS_PHYS_VCI4_1_SEMA   (TRIZEPS_PHYS_IO_BASE  + TRIZEPS_OFFSET_VCI4_1_SEMA)
#define TRIZEPS_PHYS_VCI4_2_SEMA   (TRIZEPS_PHYS_IO_BASE  + TRIZEPS_OFFSET_VCI4_2_SEMA)
#define TRIZEPS_PHYS_VCI4_1_CNTR   (TRIZEPS_PHYS_IO_BASE  + TRIZEPS_OFFSET_VCI4_1_CNTR)
#define TRIZEPS_PHYS_VCI4_2_CNTR   (TRIZEPS_PHYS_IO_BASE  + TRIZEPS_OFFSET_VCI4_2_CNTR)

#define TRIZEPS_KP_REG               (TRIZEPS_IO_BASE  + TRIZEPS_OFFSET_KP_REG)

// VCI address
#define TRIZEPS_VCI2_1_DPR           (TRIZEPS_MEM_BASE + TRIZEPS_OFFSET_VCI2_1_DPR)
#define TRIZEPS_VCI2_2_DPR           (TRIZEPS_MEM_BASE + TRIZEPS_OFFSET_VCI2_2_DPR)
#define TRIZEPS_VCI2_1_SEMA          (TRIZEPS_MEM_BASE + TRIZEPS_OFFSET_VCI2_1_SEMA)
#define TRIZEPS_VCI2_2_SEMA          (TRIZEPS_MEM_BASE + TRIZEPS_OFFSET_VCI2_2_SEMA)

// VCI4 address
#define TRIZEPS_VCI4_1_DPR           (TRIZEPS_MEM_BASE + TRIZEPS_OFFSET_VCI4_1_DPR)
#define TRIZEPS_VCI4_2_DPR           (TRIZEPS_MEM_BASE + TRIZEPS_OFFSET_VCI4_2_DPR)
#define TRIZEPS_VCI4_1_SEMA          (TRIZEPS_IO_BASE  + TRIZEPS_OFFSET_VCI4_1_SEMA)
#define TRIZEPS_VCI4_2_SEMA          (TRIZEPS_IO_BASE  + TRIZEPS_OFFSET_VCI4_2_SEMA)
#define TRIZEPS_VCI4_1_CNTR          (TRIZEPS_IO_BASE  + TRIZEPS_OFFSET_VCI4_1_CNTR)
#define TRIZEPS_VCI4_2_CNTR          (TRIZEPS_IO_BASE  + TRIZEPS_OFFSET_VCI4_2_CNTR)

#endif
