/* errtbls.c: Error number conversion tables.
 *
 * Copyright (C) 1995, 2007 David S. Miller (davem@davemloft.net)
 *
 * Based upon preliminary work which is:
 *
 * Copyright (C) 1995 Adrian M. Rodriguez (adrian@remus.rutgers.edu)
 */

#include <asm/solerrno.h>        /* Solaris errnos */

/* Here is the table which converts between Linux error number values
 * to the equivalent under Solaris.  Note that since the Linux ones
 * have been set up to match exactly those of SunOS, no translation
 * table is needed for that OS.
 */

int solaris_errno[] = {
	0,
	SOL_EPERM,
	SOL_ENOENT,
	SOL_ESRCH,
	SOL_EINTR,
	SOL_EIO,
	SOL_ENXIO,
	SOL_E2BIG,
	SOL_ENOEXEC,
	SOL_EBADF,
	SOL_ECHILD,
	SOL_EAGAIN,
	SOL_ENOMEM,
	SOL_EACCES,
	SOL_EFAULT,
	SOL_NOTBLK,
	SOL_EBUSY,
	SOL_EEXIST,
	SOL_EXDEV,
	SOL_ENODEV,
	SOL_ENOTDIR,
	SOL_EISDIR,
	SOL_EINVAL,
	SOL_ENFILE,
	SOL_EMFILE,
	SOL_ENOTTY,
	SOL_ETXTBSY,
	SOL_EFBIG,
	SOL_ENOSPC,
	SOL_ESPIPE,
	SOL_EROFS,
	SOL_EMLINK,
	SOL_EPIPE,
	SOL_EDOM,
	SOL_ERANGE,
	SOL_EWOULDBLOCK,
	SOL_EINPROGRESS,
	SOL_EALREADY,
	SOL_ENOTSOCK,
	SOL_EDESTADDRREQ,
	SOL_EMSGSIZE,
	SOL_EPROTOTYPE,
	SOL_ENOPROTOOPT,
	SOL_EPROTONOSUPPORT,
	SOL_ESOCKTNOSUPPORT,
	SOL_EOPNOTSUPP,
	SOL_EPFNOSUPPORT,
	SOL_EAFNOSUPPORT,
	SOL_EADDRINUSE,
	SOL_EADDRNOTAVAIL,
	SOL_ENETDOWN,
	SOL_ENETUNREACH,
	SOL_ENETRESET,
	SOL_ECONNABORTED,
	SOL_ECONNRESET,
	SOL_ENOBUFS,
	SOL_EISCONN,
	SOL_ENOTONN,
	SOL_ESHUTDOWN,
	SOL_ETOOMANYREFS,
	SOL_ETIMEDOUT,
	SOL_ECONNREFUSED,
	SOL_ELOOP,
	SOL_ENAMETOOLONG,
	SOL_EHOSTDOWN,
	SOL_EHOSTUNREACH,
	SOL_ENOTEMPTY,
	SOL_EPROCLIM,
	SOL_EUSERS,
	SOL_EDQUOT,
	SOL_ESTALE,
	SOL_EREMOTE,
	SOL_ENOSTR,
	SOL_ETIME,
	SOL_ENOSR,
	SOL_ENOMSG,
	SOL_EBADMSG,
	SOL_IDRM,
	SOL_EDEADLK,
	SOL_ENOLCK,
	SOL_ENONET,
	SOL_ERREMOTE,
	SOL_ENOLINK,
	SOL_EADV,
	SOL_ESRMNT,
	SOL_ECOMM,
	SOL_EPROTO,
	SOL_EMULTIHOP,
	SOL_EINVAL,    /* EDOTDOT XXX??? */
	SOL_REMCHG,
	SOL_NOSYS,
	SOL_STRPIPE,
	SOL_EOVERFLOW,
	SOL_EBADFD,
	SOL_ECHRNG,
	SOL_EL2NSYNC,
	SOL_EL3HLT,
	SOL_EL3RST,
	SOL_NRNG,
	SOL_EUNATCH,
	SOL_ENOCSI,
	SOL_EL2HLT,
	SOL_EBADE,
	SOL_EBADR,
	SOL_EXFULL,
	SOL_ENOANO,
	SOL_EBADRQC,
	SOL_EBADSLT,
	SOL_EDEADLOCK,
	SOL_EBFONT,
	SOL_ELIBEXEC,
	SOL_ENODATA,
	SOL_ELIBBAD,
	SOL_ENOPKG,
	SOL_ELIBACC,
	SOL_ENOTUNIQ,
	SOL_ERESTART,
	SOL_EUCLEAN,
	SOL_ENOTNAM,
	SOL_ENAVAIL,
	SOL_EISNAM,
	SOL_EREMOTEIO,
	SOL_EILSEQ,
	SOL_ELIBMAX,
	SOL_ELIBSCN,
};
