/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _XEN_MMU_H

#include <linux/linkage.h>
#include <asm/page.h>

enum pt_level {
	PT_PGD,
	PT_P4D,
	PT_PUD,
	PT_PMD,
	PT_PTE
};


bool __set_phys_to_machine(unsigned long pfn, unsigned long mfn);

void set_pte_mfn(unsigned long vaddr, unsigned long pfn, pgprot_t flags);

unsigned long xen_read_cr2_direct(void);

extern void xen_init_mmu_ops(void);
extern void xen_hvm_init_mmu_ops(void);
#endif	/* _XEN_MMU_H */
