# hinawa-sys crate

Rust FFI bindings and wrappers for
[hinawa library](https://git.kernel.org/pub/scm/libs/ieee1394/libhinawa.git/) to operate OHCI 1394
hardware via Linux FireWire character device for asynchronous communication in IEEE 1394 bus.

The hinawa library version 2.6 is the minimum supported version for underlying library.

The hinawa-sys crate is automatically generated by [gir tool](https://gtk-rs.org/gir/book/) provided
by [gtk-rs project](https://gtk-rs.org/). Hinawa-3.0 file from hinawa library is used for the
generation.

## License

The hinawa-sys crate is released under [MIT license](https://spdx.org/licenses/MIT.html).

## Dependency

The hinawa-sys crate depends on FFI crates provided by [gtk-rs project](https://gtk-rs.org/) for
type/object system, event loop, and dispacher.

## Features

* dox

   * Suppress detection of installed hinawa library. It's automatically enabled when generating
     documentation in docs.rs.

## Repository

The hinawa-sys crate is maintained by Takashi Sakamoto for upstream of Linux FireWire subsystem.
The remote repository locates in <https://git.kernel.org/pub/scm/libs/ieee1394/hinawa-rs.git/>.

## Support

If finding issue, please file it in <https://github.com/alsa-project/hinawa-rs> which is the mirror
of upstream for user support and continuous integration.
