// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::FwIsoCtx;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;
use std::ptr;

glib::wrapper! {
    /// An object to receive isochronous packet for single channel.
    ///
    /// [`FwIsoIrSingle`][crate::FwIsoIrSingle] receives isochronous packets for single channel by packet-per-buffer
    /// mode of IR context in 1394 OHCI. The content of packet is split to two parts; context header and
    /// context payload in a manner of Linux FireWire subsystem.
    ///
    /// # Implements
    ///
    /// [`FwIsoIrSingleExt`][trait@crate::prelude::FwIsoIrSingleExt], [`FwIsoCtxExt`][trait@crate::prelude::FwIsoCtxExt], [`FwIsoIrSingleExtManual`][trait@crate::prelude::FwIsoIrSingleExtManual], [`FwIsoCtxExtManual`][trait@crate::prelude::FwIsoCtxExtManual]
    #[doc(alias = "HinokoFwIsoIrSingle")]
    pub struct FwIsoIrSingle(Object<ffi::HinokoFwIsoIrSingle, ffi::HinokoFwIsoIrSingleClass>) @implements FwIsoCtx;

    match fn {
        type_ => || ffi::hinoko_fw_iso_ir_single_get_type(),
    }
}

impl FwIsoIrSingle {
    pub const NONE: Option<&'static FwIsoIrSingle> = None;

    /// Instantiate [`FwIsoIrSingle`][crate::FwIsoIrSingle] object and return the instance.
    ///
    /// # Returns
    ///
    /// an instance of [`FwIsoIrSingle`][crate::FwIsoIrSingle].
    #[doc(alias = "hinoko_fw_iso_ir_single_new")]
    pub fn new() -> FwIsoIrSingle {
        unsafe { from_glib_full(ffi::hinoko_fw_iso_ir_single_new()) }
    }
}

impl Default for FwIsoIrSingle {
    fn default() -> Self {
        Self::new()
    }
}

/// Trait containing the part of [`struct@FwIsoIrSingle`] methods.
///
/// # Implementors
///
/// [`FwIsoIrSingle`][struct@crate::FwIsoIrSingle]
pub trait FwIsoIrSingleExt: 'static {
    /// Allocate an IR context to 1394 OHCI hardware for packet-per-buffer mode. A local node of the
    /// node corresponding to the given path is used as the hardware, thus any path is accepted as
    /// long as process has enough permission for the path.
    ///
    /// The header_size parameter has an effect for the content of header parameter in
    /// `signal::FwIsoIrSingle::interrupted`. When it's greater than 8, header includes the series of two
    /// quadlets for isochronous packet header and timestamp per isochronous packet. When it's greater
    /// than 12, header includes the part of isochronous packet data per packet.
    /// ## `path`
    /// A path to any Linux FireWire character device.
    /// ## `channel`
    /// An isochronous channel to listen, up to 63.
    /// ## `header_size`
    /// The number of bytes for header of IR context, greater than 4 at least to include
    ///      isochronous packet header in header parameter of `signal::FwIsoIrSingle::interrupted`.
    ///
    /// # Returns
    ///
    /// TRUE if the overall operation finishes successfully, otherwise FALSE.
    #[doc(alias = "hinoko_fw_iso_ir_single_allocate")]
    fn allocate(&self, path: &str, channel: u32, header_size: u32) -> Result<(), glib::Error>;

    /// Map intermediate buffer to share payload of IR context with 1394 OHCI hardware.
    /// ## `maximum_bytes_per_payload`
    /// The maximum number of bytes per payload of IR context.
    /// ## `payloads_per_buffer`
    /// The number of payload in buffer.
    ///
    /// # Returns
    ///
    /// TRUE if the overall operation finishes successfully, otherwise FALSE.
    #[doc(alias = "hinoko_fw_iso_ir_single_map_buffer")]
    fn map_buffer(
        &self,
        maximum_bytes_per_payload: u32,
        payloads_per_buffer: u32,
    ) -> Result<(), glib::Error>;

    /// Register chunk of buffer to process packet for future isochronous cycle. The caller can schedule
    /// hardware interrupt to generate interrupt event. In detail, please refer to documentation about
    /// `signal::FwIsoIrSingle::interrupted` signal.
    /// ## `schedule_interrupt`
    /// Whether to schedule hardware interrupt at isochronous cycle for the packet.
    ///
    /// # Returns
    ///
    /// TRUE if the overall operation finishes successfully, otherwise FALSE.
    #[doc(alias = "hinoko_fw_iso_ir_single_register_packet")]
    fn register_packet(&self, schedule_interrupt: bool) -> Result<(), glib::Error>;
}

impl<O: IsA<FwIsoIrSingle>> FwIsoIrSingleExt for O {
    fn allocate(&self, path: &str, channel: u32, header_size: u32) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::hinoko_fw_iso_ir_single_allocate(
                self.as_ref().to_glib_none().0,
                path.to_glib_none().0,
                channel,
                header_size,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn map_buffer(
        &self,
        maximum_bytes_per_payload: u32,
        payloads_per_buffer: u32,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::hinoko_fw_iso_ir_single_map_buffer(
                self.as_ref().to_glib_none().0,
                maximum_bytes_per_payload,
                payloads_per_buffer,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn register_packet(&self, schedule_interrupt: bool) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::hinoko_fw_iso_ir_single_register_packet(
                self.as_ref().to_glib_none().0,
                schedule_interrupt.into_glib(),
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }
}

impl fmt::Display for FwIsoIrSingle {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("FwIsoIrSingle")
    }
}
