////////////////////////////////////////////////////////////////////
// Error Codes used in the BioMouse toolkit
// ID:  $Id: dbierrno.h,v 1.35 1999/05/18 19:17:48 bob Exp $
////////////////////////////////////////////////////////////////////

#ifndef __DBIERRNO_H__
#define __DBIERRNO_H__

#include "unixdefs.h"

// Macros for encoding error codes
// The major number is written to the lower 2 bytes so
// that we have backwards compatibility
#define MAKE_ERROR(Major, Minor) ((DWORD)((((DWORD)(Minor)) << 16) | (((DWORD)Major) & 0xFFFF)))

// Macros for decoding error codes
#define MAJOR_ERROR(Error) ((int)((short)(Error & 0xFFFF)))
#define MINOR_ERROR(Error) ((int)((short)(Error >> 16)))

// Major codes
#define DBI_FAST_OK                              0   /* Everything normal */
#define DBI_FAST_REJECT                         -1   /* Early out from fingerprint comparison algorithm */
#define DBI_FAST_NO_FEAT1                       -2   /* Rejection from fingerprint comparison algorithm due to missing feature */
#define DBI_FAST_NO_FEAT2                       -3   /* Rejection from fingerprint comparison algorithm due to missing feature */
#define DBI_FAST_NULL_POINTER                   -4   /* A null pointer was passed. */
#define DBI_FAST_NOT_AVAILABLE                  -5   /* Requested option was not avaliable */
#define DBI_FAST_DRV_FAILURE                    -6   /* Failure to successfully initialize frame grabber driver */
#define DBI_FAST_NO_MEM                         -7   /* Memory allocation failure */
#define DBI_FAST_IO_FAILURE                     -8   /* Frame grabber driver failure  */
#define DBI_FAST_BADARG                         -9   /* Invalid argument */
#define DBI_FAST_LOCKED                         -10  /* Driver is locked, try again */
#define DBI_FAST_CANCELLED                      -11  /* User cancelled operation */
#define DBI_FAST_BUFFER_TOO_SMALL               -12  /* buffer for Squished dits is not large enough */
#define DBI_FAST_INCOMPATIBLE_DIT               -13  /* Dit has incompatible data version */
#define DBI_FAST_DATA_OVERFLOW                  -14  /* Data greater than 64K */
#define DBI_FAST_ARRAY_TOO_SMALL                -15  /* Need more array elements */
#define DBI_FAST_TIMEOUT                        -16  /* Operation timed out. */
#define DBI_FAST_INIT_ERROR                     -17  /* General initialization error */
#define DBI_FAST_COMMS_FAULT                    -18  /* communications fault with bmp */
#define DBI_FAST_CARD_NOT_RESET                 -19  /* Card not reset (not activated) */
#define DBI_FAST_CARD_REMOVED                   -20  /* Card not inserted into slot */
#define DBI_FAST_CARD_REJECTED                  -21  /* Card rejected command */
#define DBI_FAST_INTERFACE_FAULT                -22  /* Lowest level protocol fault */
#define DBI_FAST_BAD_ATR                        -23  /* Answer to reset not consistent with ISO 7816-3 */
#define DBI_FAST_CHANNEL_FAULT                  -24  /* Failed to open channel with BioMouse */
#define DBI_FAST_INVALID_CMD                    -25  /* Invalid style of smartcard cmd (internal fault) */
#define DBI_FAST_COMMS_OVERFLOW                 -26  /* BioMouse buffer overflow (host too slow) */
#define DBI_FAST_FRAME_BAD                      -27  /* Frame received from scanner is invalid */
#define DBI_FAST_CLIENT_UNAVAIL                 -28  /* Client is unavailable */
#define DBI_FAST_SERVER_UNAVAIL                 -29  /* Server is unavailable */
#define DBI_FAST_CHANNEL_NOT_INIT               -30  /* Channel not initialized */
#define DBI_FAST_BAD_CRC                        -31  /* bad CRC or LRC */
#define DBI_DB_OK                       DBI_FAST_OK  /* Database operation completed properly */
#define DBI_DB_NO_USER                          -32  /* User doesn't exist in database */
#define DBI_DESTRUCT_ERROR                      -33  /* Error performing destruction */
#define DBI_DB_USER_EXISTS                      -34  /* User exists in database */
#define DBI_DB_NO_DIT                           -35  /* No DIT was found in database */
#define DBI_DB_CORRUPT                          -36  /* Database is corrupt */
#define DBI_DB_READ_ERROR                       -37  /* Error reading database */
#define DBI_DB_WRITE_ERROR                      -38  /* Error writing database */
#define DBI_DB_NO_DATABASE                      -39  /* No Database was found */
#define DBI_DB_NO_MEMORY            DBI_FAST_NO_MEM  /* Could not allocate memory */
#define DBI_DB_NULL_POINTER   DBI_FAST_NULL_POINTER  /* A NULL pointer was passed */
#define DBI_DB_MORE_ENTRIES                     -40  /* More entries exist */
#define DBI_SERV_NOT_VERIFIED                   -41  /* User not verified by server */
#define DBI_SERV_DB_OPEN_FAILURE                -42  /* Failed to open the database */
#define DBI_FAST_CARD_UNKNOWN                   -43  /* Unknown smartcard type */
#define DBI_SC_STATUS_WORD                      -44  /* Smartcard command failed - bad status word returned */
#define DBI_LIB_ACCESS_ERROR                    -45  /* Failed to access library */
#define DBI_LIB_ALREADY_LOADED                  -46  /* Library already loaded */
#define DBI_LIB_NOT_LOADED                      -47  /* Library not loaded */
#define DBI_INVALID_SLOTID                      -48  /* Slot id is invalid */
#define DBI_WIN32_ERROR                         -49  /* Use GetLastError */
#define DBI_INCOMPATIBLE_DATA                   -50  /* Data is incompatible */
#define DBI_NO_CACHE                            -51  /* Cached information is not available */
#define DBI_SOCKET_FAILURE                      -52  /* Failure using socket. */
#define DBI_FAST_NOT_PRIVILEGED                 -53  /* User doesn't have privileges */
#define DBI_BAD_MESSAGE                         -54  /* A poorly formed message was received */
#define DBI_INVALID_TICKET                      -55  /* The ticket is invalid */
#define DBI_NO_NETWORK                          -56  /* The network is not available */

/////////////////////////////////////
// Minor codes
// 0xFFFF and 0x0000 are reserved
// for backwords compatibility
/////////////////////////////////////

// 1 - 100 for dbipic.c 
#define ERROR_1         1
#define ERROR_2         2
#define ERROR_3         3
#define ERROR_4         4
#define ERROR_5         5
#define ERROR_6         6
#define ERROR_7         7
#define ERROR_8         8
#define ERROR_9         9
#define ERROR_10       10
#define ERROR_11       11
#define ERROR_12       12
#define ERROR_13       13
#define ERROR_14       14
#define ERROR_15       15
#define ERROR_16       16
#define ERROR_17       17
#define ERROR_18       18
#define ERROR_19       19
#define ERROR_20       20
#define ERROR_21       21
#define ERROR_22       22
#define ERROR_23       23

// 101 - 300 for iso.c
#define ERROR_101     101
#define ERROR_102     102
#define ERROR_103     103
#define ERROR_104     104
#define ERROR_105     105
#define ERROR_106     106
#define ERROR_107     107
#define ERROR_108     108
#define ERROR_109     109
#define ERROR_110     110
#define ERROR_111     111
#define ERROR_112     112
#define ERROR_113     113
#define ERROR_114     114
#define ERROR_115     115
#define ERROR_116     116
#define ERROR_117     117
#define ERROR_118     118
#define ERROR_119     119
#define ERROR_120     120
#define ERROR_121     121
#define ERROR_122     122
#define ERROR_123     123
#define ERROR_124     124
#define ERROR_125     125
#define ERROR_126     126
#define ERROR_127     127
#define ERROR_128     128
#define ERROR_129     129
#define ERROR_130     130
#define ERROR_131     131
#define ERROR_132     132
#define ERROR_133     133
#define ERROR_134     134
#define ERROR_135     135
#define ERROR_136     136
#define ERROR_137     137
#define ERROR_138     138
#define ERROR_139     139
#define ERROR_140     140
#define ERROR_141     141
#define ERROR_142     142

// 301-350 for scanner.c
#define ERROR_301     301
#define ERROR_302     302
#define ERROR_303     303
#define ERROR_304     304
#define ERROR_305     305
#define ERROR_306     306
#define ERROR_307     307
#define ERROR_308     308

// 351-400  for fpgrab.c
#define ERROR_351     351
#define ERROR_352     352
#define ERROR_353     353
#define ERROR_354     354
#define ERROR_355     355
#define ERROR_356     356

// 401-500     for cflex.c
#define ERROR_401     401
#define ERROR_402     402
#define ERROR_403     403
#define ERROR_404     404
#define ERROR_405     405
#define ERROR_406     406
#define ERROR_407     407
#define ERROR_408     408
#define ERROR_409     409
#define ERROR_410     410
#define ERROR_411     411
#define ERROR_412     412
#define ERROR_413     413
#define ERROR_414     414
#define ERROR_415     415
#define ERROR_416     416
#define ERROR_417     417
#define ERROR_418     418
#define ERROR_419     419
#define ERROR_420     420
#define ERROR_421     421
#define ERROR_422     422
#define ERROR_423     423
#define ERROR_424     424
#define ERROR_425     425
#define ERROR_426     426
#define ERROR_427     427
#define ERROR_428     428
#define ERROR_429     429
#define ERROR_430     430
#define ERROR_431     431
#define ERROR_432     432
#define ERROR_433     433
#define ERROR_434     434
#define ERROR_435     435
#define ERROR_436     436
#define ERROR_437     437
#define ERROR_438     438
#define ERROR_439     439
#define ERROR_440     440
#define ERROR_441     441
#define ERROR_442     442
#define ERROR_443     443
#define ERROR_444     444
#define ERROR_445     445
#define ERROR_446     446
#define ERROR_447     447

// 476-500     for mflex3.c
#define ERROR_476     476

// 501-550  for dbiscr.c 
#define ERROR_501     501
#define ERROR_502     502
#define ERROR_503     503
#define ERROR_504     504
#define ERROR_505     505
#define ERROR_506     506
#define ERROR_507     507
#define ERROR_508     508
#define ERROR_509     509
#define ERROR_510     510
#define ERROR_511     511
#define ERROR_512     512
#define ERROR_513     513
#define ERROR_514     514
#define ERROR_515     515
#define ERROR_516     516
#define ERROR_517     517
#define ERROR_518     518
#define ERROR_519     519
#define ERROR_520     520
#define ERROR_521     521
#define ERROR_522     522
#define ERROR_523     523
#define ERROR_524     524
#define ERROR_525     525
#define ERROR_526     526
#define ERROR_527     527
#define ERROR_528     528
#define ERROR_529     529

// 551-600 for dbiisohi.c 
#define ERROR_551     551
#define ERROR_552     552
#define ERROR_553     553
#define ERROR_554     554
#define ERROR_555     555
#define ERROR_556     556
#define ERROR_557     557
#define ERROR_558     558
#define ERROR_559     559
#define ERROR_560     560
#define ERROR_561     561
#define ERROR_562     562
#define ERROR_563     563
#define ERROR_564     564
#define ERROR_565     565
#define ERROR_566     566
#define ERROR_567     567
#define ERROR_568     568
#define ERROR_569     569
#define ERROR_570     570
#define ERROR_571     571
#define ERROR_572     572
#define ERROR_573     573
#define ERROR_574     574
#define ERROR_575     575
#define ERROR_576     576
#define ERROR_577     577
#define ERROR_578     578
#define ERROR_579     579
#define ERROR_580     580

// 601-  for dbismart.c
#define ERROR_601     601
#define ERROR_602     602
#define ERROR_603     603
#define ERROR_604     604
#define ERROR_605     605
#define ERROR_606     606
#define ERROR_607     607
#define ERROR_608     608
#define ERROR_609     609
#define ERROR_610     610
#define ERROR_611     611
#define ERROR_612     612
#define ERROR_613     613
#define ERROR_614     614

// 701 - 800 for newcode.c
#define ERROR_701     701
#define ERROR_702     702
#define ERROR_703     703
#define ERROR_704     704
#define ERROR_705     705
#define ERROR_706     706
#define ERROR_707     707
#define ERROR_708     708

// 801 - 850 for some.c 
#define ERROR_801     801
#define ERROR_802     802
#define ERROR_803     803
#define ERROR_804     804
#define ERROR_805     805
#define ERROR_806     806
#define ERROR_807     807

// 1001-2000 for smart card reader vendors
#define ERROR_1001    1001
#define ERROR_1002    1002
#define ERROR_1003    1003
#define ERROR_1004    1004
#define ERROR_1005    1005
#define ERROR_1006    1006
#define ERROR_1007    1007
#define ERROR_1008    1008
#define ERROR_1009    1009
#define ERROR_1010    1010
#define ERROR_1011    1011
#define ERROR_1012    1012
#define ERROR_1013    1013
#define ERROR_1014    1014
#define ERROR_1015    1015
#define ERROR_1016    1016
#define ERROR_1017    1017
#define ERROR_1018    1018
#define ERROR_1019    1019
#define ERROR_1020    1020
#define ERROR_1021    1021
#define ERROR_1022    1022
#define ERROR_1023    1023
#define ERROR_1024    1024
#define ERROR_1025    1025
#define ERROR_1026    1026
#define ERROR_1027    1027
#define ERROR_1028    1028
#define ERROR_1029    1029
#define ERROR_1030    1030
#define ERROR_1031    1031
#define ERROR_1032    1032
#define ERROR_1033    1033
#define ERROR_1034    1034
#define ERROR_1035    1035
#define ERROR_1036    1036
#define ERROR_1037    1037

// 2001-2050 for dbisc.c
#define ERROR_2001    2001

// 2051-2100 for loadbmp.c 
#define ERROR_2051    2051
#define ERROR_2052    2052
#define ERROR_2053    2053
#define ERROR_2054    2054
#define ERROR_2055    2055
#define ERROR_2056    2056
#define ERROR_2057    2057
#define ERROR_2058    2058
#define ERROR_2059    2059
#define ERROR_2060    2060
#define ERROR_2061    2061
#define ERROR_2062    2062
#define ERROR_2063    2063

// 2101-2150 for dbierror.c
#define ERROR_2101    2101

// 2151-2200 for smart card gina
#define ERROR_2151    2151

// 2201 - 2250 for selcache.c
#define ERROR_2201    2201
#define ERROR_2202    2202

// 2251 - 2300 for bigint.c
#define ERROR_2251    2251
#define ERROR_2252    2252
#define ERROR_2253    2253
#define ERROR_2254    2254

// 2401 - 2450 for imageio.c
#define ERROR_2401    2401
#define ERROR_2402    2402
#define ERROR_2403    2403

// 2451 - 2500 for CK_Cache.c
#define ERROR_2451    2451
#define ERROR_2452    2452
#define ERROR_2453    2453
#define ERROR_2454    2454
#define ERROR_2455    2455
#define ERROR_2456    2456

// 2501 - 2550 for trie.c
#define ERROR_2501    2501
#define ERROR_2502    2502
#define ERROR_2503    2503
#define ERROR_2504    2504
#define ERROR_2505    2505
#define ERROR_2506    2506
#define ERROR_2507    2507
#define ERROR_2508    2508
#define ERROR_2509    2509
#define ERROR_2510    2510
#define ERROR_2511    2511
#define ERROR_2512    2512
#define ERROR_2513    2513
#define ERROR_2514    2514
#define ERROR_2515    2515
#define ERROR_2516    2516
#define ERROR_2517    2517
#define ERROR_2518    2518
#define ERROR_2519    2519
#define ERROR_2520    2520
#define ERROR_2521    2521
#define ERROR_2522    2522

// 2551 - 2600 for messencdec.c
#define ERROR_2551    2551
#define ERROR_2552    2552
#define ERROR_2553    2553
#define ERROR_2554    2554
#define ERROR_2555    2555
#define ERROR_2556    2556
#define ERROR_2557    2557
#define ERROR_2558    2558
#define ERROR_2559    2559
#define ERROR_2560    2560
#define ERROR_2561    2561
#define ERROR_2562    2562
#define ERROR_2563    2563
#define ERROR_2564    2564
#define ERROR_2565    2565
#define ERROR_2566    2566
#define ERROR_2567    2567
#define ERROR_2568    2568
#define ERROR_2569    2569
#define ERROR_2570    2570
#define ERROR_2571    2571
#define ERROR_2572    2572
#define ERROR_2573    2573
#define ERROR_2574    2574
#define ERROR_2575    2575

// 2601 - 2650 for clntmsg.c
#define ERROR_2601    2601
#define ERROR_2602    2602
#define ERROR_2603    2603
#define ERROR_2604    2604
#define ERROR_2605    2605   // Unused
#define ERROR_2606    2606
#define ERROR_2607    2607
#define ERROR_2608    2608
#define ERROR_2609    2609
#define ERROR_2610    2610
#define ERROR_2611    2611
#define ERROR_2612    2612
#define ERROR_2613    2613
#define ERROR_2614    2614
#define ERROR_2615    2615
#define ERROR_2616    2616
#define ERROR_2617    2617
#define ERROR_2618    2618
#define ERROR_2619    2619
#define ERROR_2620    2620
#define ERROR_2621    2621
#define ERROR_2622    2622
#define ERROR_2623    2623
#define ERROR_2624    2624
#define ERROR_2625    2625
#define ERROR_2626    2626
#define ERROR_2627    2627
#define ERROR_2628    2628
#define ERROR_2629    2629
#define ERROR_2630    2630
#define ERROR_2631    2631
#define ERROR_2632    2632
#define ERROR_2633    2633
#define ERROR_2634    2634
#define ERROR_2635    2635
#define ERROR_2636    2636

// 2651 - 2700 for srvmsg.c
#define ERROR_2651    2651
#define ERROR_2652    2652
#define ERROR_2653    2653
#define ERROR_2654    2654
#define ERROR_2655    2655
#define ERROR_2656    2656
#define ERROR_2657    2657
#define ERROR_2658    2658
#define ERROR_2659    2659
#define ERROR_2660    2660
#define ERROR_2661    2661
#define ERROR_2662    2662
#define ERROR_2663    2663
#define ERROR_2664    2664
#define ERROR_2665    2665
#define ERROR_2666    2666
#define ERROR_2667    2667
#define ERROR_2668    2668
#define ERROR_2669    2669
#define ERROR_2670    2670
#define ERROR_2671    2671
#define ERROR_2672    2672
#define ERROR_2673    2673
#define ERROR_2674    2674
#define ERROR_2675    2675
#define ERROR_2676    2676
#define ERROR_2677    2677
#define ERROR_2678    2678
#define ERROR_2679    2679
#define ERROR_2680    2680
#define ERROR_2681    2681
#define ERROR_2682    2682
#define ERROR_2683    2683
#define ERROR_2684    2684
#define ERROR_2685    2685
#define ERROR_2686    2686
#define ERROR_2687    2687
#define ERROR_2688    2688
#define ERROR_2689    2689
#define ERROR_2690    2690
#define ERROR_2691    2691
#define ERROR_2692    2692
#define ERROR_2693    2693
#define ERROR_2694    2694
#define ERROR_2695    2695

// 2701 - 2800 for srvfncs.c
#define ERROR_2701    2701
#define ERROR_2702    2702
#define ERROR_2703    2703
#define ERROR_2704    2704
#define ERROR_2705    2705
#define ERROR_2706    2706
#define ERROR_2707    2707
#define ERROR_2708    2708
#define ERROR_2709    2709
#define ERROR_2710    2710
#define ERROR_2711    2711
#define ERROR_2712    2712
#define ERROR_2713    2713
#define ERROR_2714    2714
#define ERROR_2715    2715
#define ERROR_2716    2716
#define ERROR_2717    2717
#define ERROR_2718    2718
#define ERROR_2719    2719
#define ERROR_2720    2720
#define ERROR_2721    2721
#define ERROR_2722    2722
#define ERROR_2723    2723

// 2801 - 2900 for authent.c 
#define ERROR_2801    2801
#define ERROR_2802    2802
#define ERROR_2803    2803
#define ERROR_2804    2804
#define ERROR_2805    2805
#define ERROR_2806    2806
#define ERROR_2807    2807
#define ERROR_2808    2808
#define ERROR_2809    2809
#define ERROR_2810    2810
#define ERROR_2811    2811
#define ERROR_2812    2812
#define ERROR_2813    2813
#define ERROR_2814    2814
#define ERROR_2815    2815
#define ERROR_2816    2816
#define ERROR_2817    2817
#define ERROR_2818    2818
#define ERROR_2819    2819

// 2901 - 2950 for dbidbcmp.c
#define ERROR_2901    2901
#define ERROR_2902    2902
#define ERROR_2903    2903
#define ERROR_2904    2904
#define ERROR_2905    2905

// 2951 - 3050 for newcode.c
#define ERROR_2951    2951

// 3051 - 3150 for clntcalls.c
#define ERROR_3051    3051
#define ERROR_3052    3052
#define ERROR_3053    3053
#define ERROR_3054    3054
#define ERROR_3055    3055
#define ERROR_3056    3056
#define ERROR_3057    3057
#define ERROR_3058    3058
#define ERROR_3059    3059
#define ERROR_3060    3060
#define ERROR_3061    3061
#define ERROR_3062    3062
#define ERROR_3063    3063
#define ERROR_3064    3064
#define ERROR_3065    3065
#define ERROR_3066    3066
#define ERROR_3067    3067
#define ERROR_3068    3068
#define ERROR_3069    3069
#define ERROR_3070    3070
#define ERROR_3071    3071
#define ERROR_3072    3072
#define ERROR_3073    3073
#define ERROR_3074    3074
#define ERROR_3075    3075
#define ERROR_3076    3076
#define ERROR_3077    3077
#define ERROR_3078    3078
#define ERROR_3079    3079
#define ERROR_3080    3080
#define ERROR_3081    3081
#define ERROR_3082    3082
#define ERROR_3083    3083
#define ERROR_3084    3084
#define ERROR_3085    3085

// 3151 - 3250 for srvcalls.c
#define ERROR_3151    3151
#define ERROR_3152    3152
#define ERROR_3153    3153
#define ERROR_3154    3154

// 3251 - 3350 for dbase2.c
#define ERROR_3251    3251

// 3351 - 3400 for thread.c
#define ERROR_3351    3351
#define ERROR_3352    3352
#define ERROR_3353    3353
#define ERROR_3354    3354
#define ERROR_3355    3355
#define ERROR_3356    3356
#define ERROR_3357    3357
#define ERROR_3358    3358
#define ERROR_3359    3359
#define ERROR_3360    3360
#define ERROR_3361    3361
#define ERROR_3362    3362
#define ERROR_3363    3363
#define ERROR_3364    3364
#define ERROR_3365    3365
#define ERROR_3366    3366
#define ERROR_3367    3367
#define ERROR_3368    3368
#define ERROR_3369    3369
#define ERROR_3370    3370
#define ERROR_3371    3371
#define ERROR_3372    3372

// 4001-5000 for interface dll
#define ERROR_4001    4001
#define ERROR_4002    4002
#define ERROR_4003    4003
#define ERROR_4004    4004
#define ERROR_4005    4005
#define ERROR_4006    4006
#define ERROR_4007    4007
#define ERROR_4008    4008
#define ERROR_4009    4009
#define ERROR_4010    4010
#define ERROR_4011    4011
#define ERROR_4012    4012
#define ERROR_4013    4013
#define ERROR_4014    4014
#define ERROR_4015    4015
#define ERROR_4016    4016
#define ERROR_4017    4017
#define ERROR_4018    4018
#define ERROR_4019    4019
#define ERROR_4020    4020
#define ERROR_4021    4021
#define ERROR_4022    4022
#define ERROR_4023    4023
#define ERROR_4024    4024
#define ERROR_4025    4025
#define ERROR_4026    4026
#define ERROR_4027    4027
#define ERROR_4028    4028
#define ERROR_4029    4029
#define ERROR_4030    4030
#define ERROR_4031    4031
#define ERROR_4032    4032
#define ERROR_4033    4033
#define ERROR_4034    4034
#define ERROR_4035    4035
#define ERROR_4036    4036
#define ERROR_4037    4037
#define ERROR_4038    4038

#endif
