/*
 * hotplug.c
 *
 * A version of /sbin/hotplug that is not a script.
 *
 * Why?  Think initrd :)
 *
 * Copyright (C) 2001 Greg Kroah-Hartman <greg@kroah.com>
 *
 *	This program is free software; you can redistribute it and/or modify it
 *	under the terms of the GNU General Public License as published by the
 *	Free Software Foundation version 2 of the License.
 * 
 *	This program is distributed in the hope that it will be useful, but
 *	WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	General Public License for more details.
 * 
 *	You should have received a copy of the GNU General Public License along
 *	with this program; if not, write to the Free Software Foundation, Inc.,
 *	675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: hotplug.c,v 1.3 2001/08/29 18:10:45 kroah Exp $
 * 
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "hotplug.h"


int pci_handler (void)
{
	return 0;
}

int cpu_handler (void)
{
	return 0;
}

int net_handler (void)
{
	return 0;
}

int dock_handler (void)
{
	return 0;
}

static struct subsystem main_subsystem[] = {
	{ "pci", pci_handler },
	{ "usb", usb_handler },
	{ "cpu", cpu_handler },
	{ "net", net_handler },
	{ "dock", dock_handler },
	{ NULL, NULL }
};
	

int main(int argc, char *argv[])
{
	if (argc != 2) {
		dbg ("unknown number of arguments");
		return 1;
	}
	/* 
	 * We pass off control to the subsystem that is specified by argv[1].
	 */
	return subsystem (argv[1], main_subsystem);
}

