/* Copyright (c) 1999 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#define _GNU_SOURCE

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "nis_db.h"
#include "db_private.h"

db_status
db_checkpoint (const char *table_name)
{
  table_t *tobj;
  entry_t *eobj;
  FILE *fp;
  XDR xdrs;
  char *filename, *cp;

  if (table_name == NULL || strlen (table_name) == 0)
    return DB_BADTABLE;

  tobj = __get_table (table_name);
  if (tobj == NULL)
    return DB_BADTABLE;

  filename = alloca (strlen (tobj->path) + 5);
  cp = stpcpy (filename, tobj->path);
  strcpy (cp, ".tmp");
  unlink (filename);
  fp = fopen (filename, "w");
  if (fp == NULL)
    return DB_INTERNAL_ERROR;
  __close_on_exit (&fp);

  tobj->header.type = XDB_FILE;
  tobj->header.log_present = FALSE;
  tobj->header.header_size = xdr_sizeof ((xdrproc_t) xdr_xdb_header,
					 &tobj->header);

  xdrstdio_create (&xdrs, fp, XDR_ENCODE);
  if (!xdr_xdb_header (&xdrs, &tobj->header))
    {
      xdr_destroy (&xdrs);
      fclose (fp);
      unlink (filename);
      return DB_INTERNAL_ERROR;
    }

  eobj = tobj->entry;
  while (eobj != NULL)
    {
      if (!__nisdb_xdr_entry_obj (&xdrs, eobj->object))
	{
	  xdr_destroy (&xdrs);
	  fclose (fp);
	  unlink (filename);
	  return DB_INTERNAL_ERROR;
	}
      eobj = eobj->next;
    }
  xdr_destroy (&xdrs);

  fclose (fp);

  if (rename (filename, tobj->path) != 0)
    {
      unlink (filename);
      tobj->header.log_present = TRUE;
      return DB_INTERNAL_ERROR;
    }

  /* If a log file is open, close it */
  if (tobj->fp_log)
    {
      fclose (tobj->fp_log);
      tobj->fp_log = NULL;
    }
  unlink (tobj->path_log);

  return __catalog_checkpoint ();
}
