/* Copyright (c) 1999 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>
#include <rpcsvc/nis.h>
#include "nis_db.h"
#include "db_private.h"

void
db_free_result (db_result *res)
{
  if (res == NULL)
    return;

  if (res->nextinfo.db_next_desc_len)
    free (res->nextinfo.db_next_desc_val);

  if (res->objects.objects_len)
    {
      u_int i;
      for (i = 0; i < res->objects.objects_len; ++i)
	{
	  if (res->objects.objects_val[i] != NULL)
	    {
	      xdr_free ((xdrproc_t) __nisdb_xdr_entry_obj,
			(caddr_t) res->objects.objects_val[i]);
	      free (res->objects.objects_val[i]);
	    }
	}
      free (res->objects.objects_val);
    }

  free (res);

  return;
}
