/* Copyright (C) 1998, 1999 Thorsten Kukuk

   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <locale.h>
#include <libintl.h>
#include <rpcsvc/nis.h>

#include "nis_xdr.h"
#include "nisd.h"

#ifndef _
#define _(String) gettext (String)
#endif

void
nis_prog_3 (struct svc_req *rqstp, register SVCXPRT * transp)
{
  union
    {
      ns_request nis_lookup_3_arg;
      ns_request nis_add_3_arg;
      ns_request nis_modify_3_arg;
      ns_request nis_remove_3_arg;
      ib_request nis_iblist_3_arg;
      ib_request nis_ibadd_3_arg;
      ib_request nis_ibmodify_3_arg;
      ib_request nis_ibremove_3_arg;
      ib_request nis_ibfirst_3_arg;
      ib_request nis_ibnext_3_arg;
      fd_args nis_finddirectory_3_arg;
      nis_taglist nis_status_3_arg;
      dump_args nis_dumplog_3_arg;
      dump_args nis_dump_3_arg;
      netobj nis_callback_3_arg;
      nis_name nis_cptime_3_arg;
      nis_name nis_checkpoint_3_arg;
      ping_args nis_ping_3_arg;
      nis_taglist nis_servstate_3_arg;
      nis_name nis_mkdir_3_arg;
      nis_name nis_rmdir_3_arg;
      nis_name nis_updkeys_3_arg;
    }
  argument;
  union
    {
      nis_result nis_lookup_3_res;
      nis_result nis_add_3_res;
      nis_result nis_modify_3_res;
      nis_result nis_remove_3_res;
      nis_result nis_iblist_3_res;
      nis_result nis_ibadd_3_res;
      nis_result nis_ibmodify_3_res;
      nis_result nis_ibremove_3_res;
      nis_result nis_ibfirst_3_res;
      nis_result nis_ibnext_3_res;
      fd_result nis_finddirectory_3_res;
      nis_taglist nis_status_3_res;
      log_result nis_dumplog_3_res;
      log_result nis_dump_3_res;
      bool_t nis_callback_3_res;
      uint32_t nis_cptime_3_res;
      cp_result nis_checkpoint_3_res;
      nis_taglist nis_servstate_3_res;
      nis_error nis_mkdir_3_res;
      nis_error nis_rmdir_3_res;
      nis_error nis_updkeys_3_res;
    }
  result;
  bool_t retval;
  xdrproc_t xdr_argument, xdr_result;
  bool_t (*local) (char *, void *, struct svc_req *);

  switch (rqstp->rq_proc)
    {
    case NULLPROC:
      (void) svc_sendreply (transp, (xdrproc_t) xdr_void, (char *) NULL);
      return;

    case NIS_LOOKUP:
      xdr_argument = (xdrproc_t) xdr_ns_request;
      xdr_result = (xdrproc_t) xdr_nis_result;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_lookup_3_r;
      break;

    case NIS_ADD:
      xdr_argument = (xdrproc_t) xdr_ns_request;
      xdr_result = (xdrproc_t) xdr_nis_result;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_add_3_r;
      break;

    case NIS_MODIFY:
      xdr_argument = (xdrproc_t) xdr_ns_request;
      xdr_result = (xdrproc_t) xdr_nis_result;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_modify_3_r;
      break;

    case NIS_REMOVE:
      xdr_argument = (xdrproc_t) xdr_ns_request;
      xdr_result = (xdrproc_t) xdr_nis_result;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_remove_3_r;
      break;

    case NIS_IBLIST:
      xdr_argument = (xdrproc_t) xdr_ib_request;
      xdr_result = (xdrproc_t) xdr_nis_result;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_iblist_3_r;
      break;

    case NIS_IBADD:
      xdr_argument = (xdrproc_t) xdr_ib_request;
      xdr_result = (xdrproc_t) xdr_nis_result;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_ibadd_3_r;
      break;

    case NIS_IBMODIFY:
      xdr_argument = (xdrproc_t) xdr_ib_request;
      xdr_result = (xdrproc_t) xdr_nis_result;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_ibmodify_3_r;
      break;

    case NIS_IBREMOVE:
      xdr_argument = (xdrproc_t) xdr_ib_request;
      xdr_result = (xdrproc_t) xdr_nis_result;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_ibremove_3_r;
      break;

    case NIS_IBFIRST:
      xdr_argument = (xdrproc_t) xdr_ib_request;
      xdr_result = (xdrproc_t) xdr_nis_result;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_ibfirst_3_r;
      break;

    case NIS_IBNEXT:
      xdr_argument = (xdrproc_t) xdr_ib_request;
      xdr_result = (xdrproc_t) xdr_nis_result;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_ibnext_3_r;
      break;

    case NIS_FINDDIRECTORY:
      xdr_argument = (xdrproc_t) xdr_fd_args;
      xdr_result = (xdrproc_t) xdr_fd_result;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_finddirectory_3_r;
      break;

    case NIS_STATUS:
      xdr_argument = (xdrproc_t) xdr_nis_taglist;
      xdr_result = (xdrproc_t) xdr_nis_taglist;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_status_3_r;
      break;

    case NIS_DUMPLOG:
      xdr_argument = (xdrproc_t) xdr_dump_args;
      xdr_result = (xdrproc_t) xdr_log_result;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_dumplog_3_r;
      break;

    case NIS_DUMP:
      xdr_argument = (xdrproc_t) xdr_dump_args;
      xdr_result = (xdrproc_t) xdr_log_result;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_dump_3_r;
      break;

    case NIS_CALLBACK:
      xdr_argument = (xdrproc_t) xdr_netobj;
      xdr_result = (xdrproc_t) xdr_bool;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_callback_3_r;
      break;

    case NIS_CPTIME:
      xdr_argument = (xdrproc_t) xdr_nis_name;
      xdr_result = (xdrproc_t) xdr_uint32_t;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_cptime_3_r;
      break;

    case NIS_CHECKPOINT:
      xdr_argument = (xdrproc_t) xdr_nis_name;
      xdr_result = (xdrproc_t) xdr_cp_result;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_checkpoint_3_r;
      break;

    case NIS_PING:
      xdr_argument = (xdrproc_t) xdr_ping_args;
      xdr_result = (xdrproc_t) xdr_void;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_ping_3_r;
      break;

    case NIS_SERVSTATE:
      xdr_argument = (xdrproc_t) xdr_nis_taglist;
      xdr_result = (xdrproc_t) xdr_nis_taglist;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_servstate_3_r;
      break;

    case NIS_MKDIR:
      xdr_argument = (xdrproc_t) xdr_nis_name;
      xdr_result = (xdrproc_t) xdr_nis_error;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_mkdir_3_r;
      break;

    case NIS_RMDIR:
      xdr_argument = (xdrproc_t) xdr_nis_name;
      xdr_result = (xdrproc_t) xdr_nis_error;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_rmdir_3_r;
      break;

    case NIS_UPDKEYS:
      xdr_argument = (xdrproc_t) xdr_nis_name;
      xdr_result = (xdrproc_t) xdr_nis_error;
      local = (bool_t (*)(char *, void *, struct svc_req *)) nis_updkeys_3_r;
      break;

    default:
      svcerr_noproc (transp);
      return;
    }
  memset ((char *) &argument, 0, sizeof (argument));
  if (!svc_getargs (transp, xdr_argument, (caddr_t) & argument))
    {
      svcerr_decode (transp);
      return;
    }
  retval = (bool_t) (*local) ((char *) &argument, (void *) &result, rqstp);
  if (retval > 0 && !svc_sendreply (transp, xdr_result, (char *) &result))
    {
      svcerr_systemerr (transp);
    }
  if (!svc_freeargs (transp, xdr_argument, (caddr_t) & argument))
    {
      fputs (_("unable to free arguments\n"), stderr);
      exit (1);
    }
  if (!nis_prog_3_freeresult (transp, xdr_result, (caddr_t) & result))
    {
      fputs (_("unable to free results"), stderr);
      exit (1);
    }

  return;
}
