.TH lspci 8 "@TODAY@" "@VERSION@" "The PCI Utilities"
.IX lspci
.SH NAME
lspci \- list all PCI devices
.SH SYNOPSIS
.B lspci
.RB [ options ]
.SH DESCRIPTION
.B lspci
is a utility for displaying information about all PCI buses in the system and
all devices connected to them.

By default, it shows a brief list of devices. Use the options described
below to request either a more verbose output or output intended for
parsing by other programs.

If you are going to report bugs in PCI device drivers or in
.I lspci
itself, please include output of "lspci -vvx" or even better "lspci -vvxxx"
(however, see below for possible caveats).

Some parts of the output, especially in the highly verbose modes, is probably
intelligible only to experienced PCI hackers. For the exact definitions of
the fields, please consult either the PCI specifications or the
.B header.h
and
.B /usr/include/linux/pci.h
include files.

Access to some parts of the PCI configuration space is restricted to root
on many operating systems, so the features of
.I lspci
available to normal users are limited. However,
.I lspci
tries its best to display as much as available and mark all other
information with
.I <access denied>
text.

.SH OPTIONS
.TP
.B -v
Be verbose and display detailed information about all devices.
.TP
.B -vv
Be very verbose and display more details. This level includes everything deemed
useful.
.TP
.B -vvv
Be even more verbose and display everything we are able to parse,
even if it doesn't look interesting at all (e.g., undefined memory regions).
.TP
.B -n
Show PCI vendor and device codes as numbers instead of looking them up in the
PCI ID list.
.TP
.B -x
Show hexadecimal dump of the standard part of the configuration space (the first
64 bytes or 128 bytes for CardBus bridges).
.TP
.B -xxx
Show hexadecimal dump of the whole PCI configuration space. It is available only to root
as several PCI devices
.B crash
when you try to read some parts of the config space (this behavior probably
doesn't violate the PCI standard, but it's at least very stupid). However, such
devices are rare, so you needn't worry much.
.TP
.B -xxxx
Show hexadecimal dump of the extended (4096-byte) PCI configuration space available
on PCI-X 2.0 and PCI Express buses.
.TP
.B -b
Bus-centric view. Show all IRQ numbers and addresses as seen by the cards on the
PCI bus instead of as seen by the kernel.
.TP
.B -t
Show a tree-like diagram containing all buses, bridges, devices and connections
between them.
.TP
.B -s [[[[<domain>]:]<bus>]:][<slot>][.[<func>]]
Show only devices in the specified domain (in case your machine has several host bridges,
they can either share a common bus number space or each of them can address a PCI domain
of its own; domains are numbered from 0 to ffff), bus (0 to ff), slot (0 to 1f) and function (0 to 7).
Each component of the device address can be omitted or set to "*", both meaning "any value". All numbers are
hexadecimal.  E.g., "0:" means all devices on bus 0, "0" means all functions of device 0
on any bus, "0.3" selects third function of device 0 on all buses and ".4" shows only
the fourth function of each device.
.TP
.B -d [<vendor>]:[<device>]
Show only devices with specified vendor and device ID. Both ID's are given in
hexadecimal and may be omitted or given as "*", both meaning "any value".
.TP
.B -i <file>
Use
.B
<file>
as the PCI ID list instead of @IDSDIR@/pci.ids.
.TP
.B -m
Dump PCI device data in machine readable form (both normal and verbose format supported)
for easy parsing by scripts.
.TP
.B -M
Invoke bus mapping mode which performs a thorough scan of all PCI devices, including
those behind misconfigured bridges etc. This option is available only to root and it
gives meaningful results only if combined with direct hardware access mode (otherwise
the results are identical to normal listing modes, modulo bugs in lspci). Please note
that the bus mapper doesn't support PCI domains and scans only domain 0.
.TP
.B --version
Shows 
.I lspci
version. This option should be used stand-alone.

.SH PCILIB AND ITS OPTIONS
The PCI utilities use PCILIB (a portable library providing platform-independent
functions for PCI configuration space access) to talk to the PCI cards. It supports
the following access methods:

.TP
.B linux_sysfs
The
.B /sys
filesystem on Linux 2.6 and newer. The standard header of the config space is available
to all users, the rest only to root. Supports extended configuration space and PCI domains.
.TP
.B linux_proc
The
.B /proc/bus/pci
interface supported by Linux 2.1 and newer. The standard header of the config space is available
to all users, the rest only to root.
.TP
.B intel_conf1
Direct hardware access via Intel configuration mechanism 1. Available on i386 and compatibles
on Linux, Solaris/x86, GNU Hurd and Windows. Requires root privileges.
.TP
.B intel_conf2
Direct hardware access via Intel configuration mechanism 2. Available on i386 and compatibles
on Linux, Solaris/x86 and GNU Hurd. Requires root privileges. Warning: This method
is able to address only first 16 devices on any bus and it seems to be very
unreliable in many cases.
.TP
.B fbsd_device
The
.B /dev/pci
device on FreeBSD. Requires root privileges.
.TP
.B aix_device
Access method used on AIX. Requires root privileges.
.TP
.B nbsd_libpci
The
.B /dev/pci0
device on NetBSD accessed using the local libpci library.

.P
By default, PCILIB uses the first available access method and displays no debugging
messages, but you can use the following switches to control its behavior:

.TP
.B -P <dir>
Force use of the linux_proc access method, using
.B <dir>
instead of /proc/bus/pci.
.TP
.B -H1
Use direct hardware access via Intel configuration mechanism 1.
.TP
.B -H2
Use direct hardware access via Intel configuration mechanism 2.
.TP
.B -F <file>
Extract all information from given file containing output of lspci -x. This is very
useful for analysis of user-supplied bug reports, because you can display the
hardware configuration in any way you want without disturbing the user with
requests for more dumps.
.TP
.B -G
Increase debug level of the library.

.SH FILES
.TP
.B @IDSDIR@/pci.ids
A list of all known PCI ID's (vendors, devices, classes and subclasses). Maintained
at http://pciids.sourceforge.net/, use the
.B update-pciids
utility to download the most recent version.
.TP
.B /proc/bus/pci
An interface to PCI bus configuration space provided by the post-2.1.82 Linux
kernels. Contains per-bus subdirectories with per-card config space files and a
.I devices
file containing a list of all PCI devices.

.SH SEE ALSO
.BR setpci (8),
.BR update-pciids (8)

.SH AUTHOR
The PCI Utilities are maintained by Martin Mares <mj@ucw.cz>.
