<?php

function bitset_compare($bit1,$bit2,$admin) {

	$auth = null;

	if ( (int)$bit1 & (int)$bit2 ) $auth = 1;

	if ($admin) {

		if ( (int)$bit1 & (int)$admin ) $auth = 1;

	}

	if (!$auth) return false;
	else return true;

}

//dummy function for backwards compatibility
function bitset_section($bit1,$bit2,$admin) {

	$auth = null;

	if ( (int)$bit1 & (int)$bit2 ) $auth = 1;

	if ($admin) {

		if ( (int)$bit1 & (int)$admin ) $auth = 1;

	}

	if (!$auth) return false;
	else return true;

}

/*
  returns the type of browser the user is using.
  this function must be passed $HTTP_USER_AGENT.
*/

function browser_check($var) {

	if (eregi("MSIE",$var)) {
		$browser_type="ie";
	}
	else {
		$browser_type="mozilla";
	}
	echo strpos($HTTP_USER_AGENT,"MSIE");
	return $browser_type;
}


function username_return($conn,$id) {

	$sql = "SELECT login FROM auth_accounts WHERE id='$id'";
	$query_return = report_query($conn,$sql);
	if ($query_return[1]!=0) {
		$query_myrow = single_myrow_result($query_return[0],0);
		return $query_myrow["login"];
	}
}

function returnPageOwner($totalArray,$page,$ownerArray) {

	if (!$ownerArray) $ownerArray = array();

	//get this files owner
	$key = array_search($page,$totalArray["id"]);
	$owner = $totalArray["owner"][$key];


	if ($owner!="0") {
		$ownerArray[] = $owner;
		$ownerArray = returnPageOwner($totalArray,$owner,$ownerArray);
	}

	return $ownerArray;

}

function prepareDirPath($pathArray) {

	$newArray = array();

	foreach ($pathArray AS $value) {

		$value = strip_tags($value);
		$newArray[] = strtolower(eregi_replace("[^a-z0-9]","",$value));
	}

	$path = "files/pages/".implode("/",$newArray)."/";

	return $path;
}

function pageNavMenu($optionArray) {

	$conn = $optionArray["conn"];
	$page = $optionArray["page"];
	$articleId = $optionArray["articleId"];
	$calendarId = $optionArray["calendarId"];
	$componentModArray = $optionArray["componentModArray"];
	$module = $optionArray["module"];
	$adminArray = $optionArray["adminArray"];

	if (in_array($module,$adminArray)) {

		$siteModSettings = $_SESSION["siteModSettings"];

		//find the key for the Main admin
		$key = array_search(ADMIN_MOD,$siteModSettings["modId"]);
		$returnArray[0] = "<a href=\"index.php?module=".$siteModSettings["modId"][$key]."\" class=\"navBarLink\">".$siteModSettings["modName"][$key]."</a>";

		if ($module!=ADMIN_MOD) {
			$key = array_search($module,$siteModSettings["modId"]);
			$returnArray[1] = "<a href=\"index.php?module=".$siteModSettings["modId"][$key]."\" class=\"navBarLink\">".$siteModSettings["modName"][$key]."</a>";
		}

	} else {

		if ($calendarId) $sql = "SELECT header FROM in_calendar WHERE id='$calendarId'";
		elseif ($articleId) $sql = "SELECT header FROM in_news WHERE id='$articleId'";

		if ($articleId || $calendarId) {
			$extraInfo = single_result($conn,$sql);
		}

		$sql = "SELECT 	id,
						header,
						owner,
						component_type
						FROM in_pages
					";

		$result = total_result($conn,$sql);

		$tempArray = returnPageOwner($result,$page,null);

		array_reverse($tempArray);
		$tempArray[] = $page;

		//echo implode("-",$result["addHeader"]);

		for ($row=0;$row<count($tempArray);$row++) {

			$key = array_search($tempArray[$row],$result["id"]);
			$modKey = $result["component_type"][$key];
			$module = $componentModArray[$modKey];

			$string = "<a href=\"index.php?module=".$module."&page=".$result["id"][$key]."\" ";
			$string .= "class=\"navBarLink\">".$result["header"][$key]."</a>";

			$returnArray[] = $string;

		}

		if ($extraInfo) $returnArray[] = $extraInfo["header"];

	}

	return $returnArray;
}


function date_view($date,$format) {

	if ($format=="slash" && $date) {

		$dateArray = explode("-",$date);

		$date = date("m/d/Y",mktime(0,0,0,$dateArray[1],$dateArray[2],$dateArray[0]));

	}
	else if ($format=="space" && $date) {

		$dateArray = explode("-",$date);

		$date = date("M d, Y",mktime(0,0,0,$dateArray[1],$dateArray[2],$dateArray[0]));

	}

	return $date;
}

function delcheck ($string) {

/*  This function checks to see if the string has anything bad that could
erase more than it is supposed to */

	if (stristr ($string,"*")) return false;
	else if (stristr ($string,"?")) return false;
	else if (stristr ($string,"%")) return false;
	else if (stristr ($string,"!")) return false;
	else if (stristr ($string,"#")) return false;
	else if (stristr ($string,"@")) return false;
	else return true;
}

function time_format($time_entry,$period_value) {

	$hour_value  	=   substr ($time_entry,0,2);
	$minute_value	=	substr ($time_entry,3,2);
	//$period_value	=	substr ($time_entry,7,4);

	//06:25 a.m.

	if ($period_value) {

		if ($period_value=="P.M." && $hour_value!="12") {

			$hour_value=12+$hour_value;

		}

	}

	$time_enter=$hour_value;
	$time_enter.=":";
	$time_enter.=$minute_value;
	$time_enter.=":";
	$time_enter.="00";

	return $time_enter;


}

function time_view($time_entry,$format) {

	$hour_value  	=   substr ($time_entry,0,2);
	$minute_value	=	substr ($time_entry,3,2);
	$second_value	=	substr ($time_entry,6,2);

	//06:25 a.m.

	if ($format=="standard") {

		if ($hour_value>="12") {

			$period_value="P.M.";
			if ($hour_value!=12) $hour_value=$hour_value-12;

		} else {
			$period_value="A.M.";
		}

	}

	$time_show=$hour_value;
	$time_show.=":";
	$time_show.=$minute_value;

	$return_time=array($time_show,$period_value);

	return $return_time;


}

function time_format_fix($start_hour,$start_min,$starttime_period,$dur_hour,$dur_min) {

	if ($starttime_period=="P.M.") 	$start_hour=$start_hour+12;

			if ($start_hour=="24") $start_hour = "0";

			$start_time=$start_hour.":".$start_min;

			$end_hour=$start_hour+$dur_hour;
			$end_min=$start_min+$dur_min;

			if ($end_min=="0") $end_min="00";

			if ($end_min>=60) {
				$end_hour=$end_hour+1;
				$end_min=$end_min-60;
			}

			if ($end_min=="60") {
					if ($end_hour=="12") $end_hour=="01";
					else $end_hour=$end_hour+1;
					$end_min="00";
			}

			if ($end_hour>=24) $end_hour=$end_hour - 24;

			$end_time=$end_hour.":".$end_min;

			$time_array=array();
		$time_array[0]=$start_time;
		$time_array[1]=$end_time;
		return $time_array;

}


//this function returns the hours and minutes difference between tw times
function time_diff($start_time,$end_time) {

	//subtract our times to get the difference
	$calcStArray = explode(":",$start_time);
	$calcEtArray = explode(":",$end_time);

	$start_hour = $calcStArray[0];
	$start_min = $calcStArray[1];

	$end_hour = $calcEtArray[0];
	$end_min = $calcEtArray[1];

	//reduce our dates to timestamps.  We use a random date here, since it does not matter
	$ts1 = mktime($start_hour,$start_min,"0",1,1,2000);
	$ts2 = mktime($end_hour,$end_min,"0",1,1,2000);

	//get the number of seconds
	$diff = $ts2 - $ts1;

	$temp = $diff/3600;

	//get the place of the decimal point
	$pos = strpos($temp,".");

	//if we have pos, there is a decimal point
	if ($pos) {

		$dur_hour = intval($temp);
		$min = substr($temp,$pos);

		//convert to clock nums
		if ($min==".5") $dur_min = "30";
		elseif ($min==".25") $dur_min = "15";
		elseif ($min==".75") $dur_min = "45";

	}
	else {
		$dur_hour = $temp;
		$dur_min = "00";
	}

	return array($dur_hour,$dur_min);

}

function date_diff($firstDate,$lastDate) {

	$fdArray = explode("-",$firstDate);
	$ldArray = explode("-",$lastDate);

	//get how many days the difference is
	$diff = mktime(0,0,0,$fdArray[1],$fdArray[2],$fdArray[0]) - mktime(0,0,0,$ldArray[1],$ldArray[2],$ldArray[0]);
	$diff = abs($diff / 86400);

	return $diff;
}

function date_time_view($datetime,$altDateFormat) {

	$len=strlen($datetime);

	//divide up our string into date and time
	$date_value=substr($datetime,0,10);

	$month_value = substr ($date_value,5,2);
	$day_value   = substr ($date_value,8,2);
	$year_value  = substr ($date_value,0,4);

	if ($altDateFormat) $date_value=$day_value."-".$month_value."-".$year_value;

	else $date_value=$month_value."-".$day_value."-".$year_value;

	$time_value=substr($datetime,11);
	if (strlen($time_value)>=9) {
		$time_value=substr($time_value,0,8);
	}

	$datetime=array($date_value,$time_value);
	return $datetime;
}


function cs_in_array($string,$object) {

	$string = strtolower($string);

	$returnValue = null;

	for ($row=0;$row<count($object);$row++) {

		$tempValue = strtolower($object[$row]);

		if ($tempValue == $string) $returnValue = $tempValue;  break;
	}

	if ($returnValue) return $returnValue;
	else return false;

}


function multi_array_unique($array1,$array2) {

	$newArray1 = array();
	$newArray2 = array();

	for ($row=0;$row<count($array1);$row++) {

		if (!in_array($array1[$row],$newArray1)) {

			$newArray1[] = $array1[$row];
			$newArray2[] = $array2[$row];

		}

	}

	return array($newArray1,$newArray2);

}




function intPercent($num,$total) {

	if ($total != 0) {

		$percent = ($num/$total) * 100;
		$temp = intval($percent) + ".5";

		//round up if necessary
		if ($percent >= $temp) {
			$value = intval($percent) + 1;
		}
		else {
			$value = intval($percent);
		}

	}
	else $value = "0";

	return $value;

}

function intValue($num) {

	$temp = intval($num) + ".5";

	//round up if necessary
	if ($num >= $temp) {
		$value = intval($num) + 1;
	}
	else {
		$value = intval($num);
	}

	return $value;

}





//This function compares two arrays, and returns an array w/ the differences
function array_difference($array1,$array2) {
	$newrow=0;
	$final_array = array();
	for ($row=0;$row<count($array1);$row++) {
			if (!in_array($array1[$row],$array2))  {
				$final_array[$newrow]=$array1[$row];
				$newrow++;
			}
	}
	return $final_array;
}

//this function takes a date and puts it into a format that
//the database will accept
function dateFormat($date,$altDateFormat) {

	if (strpos($date,"-")==4) {
		return $date;
	}
	elseif (strpos($date,"/")==4) {
		$date=eregi_replace("/","-",$date);
		return $date;
	}
	else {

		if (strpos($date,"-")) $date=eregi_replace("-","/",$date);

		//swap the year and date if we arere using alternate format
		if ($altDateFormat && strpos($date,"/")) {

			$temp1 = strpos($date,"/");
			$temp2 = strrpos($date,"/");
			$len = $temp2-$temp1-1;
			$day = substr($date,0,$temp1);
			$month = substr($date,$temp1+1,$len);
			$year = substr($date,$temp2+1);

			$date = $month."/".$day."/".$year;
		}

		$date = date("Y-m-d",strtotime("$date"));
		return $date;
	}

}

function factorial($limit) {

	$num = 1;

	for ($row=0;$row<$limit;$row++) {
		if ($limit!=0) $num = $num * 2;
	}

	return $num;
}



function dateSpan($begin,$end,$period) {

	//split into arrays
	$beginArray = explode("-",$begin);
	$endArray = explode("-",$end);

	$dateArray = array();
	$working = null;

	if ($period=="week") $add="7";
	else $add = "1";

	while ($working<$end) {

		if ($working) {

			$workArray = explode("-",$working);

			if ($period=="month") {
				$year = $workArray[0];
				$month = $workArray[1] + $add;
				$day = $workArray[2];

			} else {
				$year = $workArray[0];
				$month = $workArray[1];
				$day = $workArray[2] + $add;
			}
		}
		else {
			$year = $beginArray[0];
			$month = $beginArray[1];
			$day = $beginArray[2];
		}

		$working = date("Y-m-d",mktime(0,0,0,$month,$day,$year));

		if ($working <= $end) $dateArray[] = $working;

	}

	return $dateArray;


}

function getPath($modArray,$id,$path) {

	//do a search for our id to get the key
	$key = array_search($id,$modArray["modId"]);

	$path = $modArray["modDirectory"][$key]."/".$path;

	//is their an owner
	if ($modArray["modOwner"][$key]!="0") {

		$id = $modArray["modOwner"][$key];

		$path = getPath($modArray,$id,$path);

	}

	return $path;

}


function getGroupPath($conn,$id,$path) {

	//get all groups and store them in an array
	$sql = "SELECT owner,path FROM in_groups WHERE id='$id'";

	$query_return = report_query($conn,$sql);
	if ($query_return[1]!=0) {
		$query_myrow = single_myrow_result($query_return[0],0);
		$owner = $query_myrow["owner"];
		$newPath = $query_myrow["path"];

		$path = $newPath."/".$path;

		if ($owner!="0") {

			$path = getGroupPath($conn,$owner,$path);

		}

	}

	return $path;

}


function getOwner($bitpos,$ownerArray,$bitposArray,$string) {

	$string .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td><td>";

	$key = array_search($bitpos,$bitposArray);

	if ($ownerArray[$key]!="0") $string = getOwner($bitpos,$ownerArray,$bitposArray,$string);
	else return $string;

}


/************************************************************************************
	This function displays a permissions list for an object, and checks
	any boxes the user belongs to
************************************************************************************/

function groupPerm($conn,$optionArray) {

	$table = $optionArray["table"];
	$filter = $optionArray["filter"];
	$filterValue = $optionArray["filterValue"];
	$permArray = $optionArray["permArray"];
	$prefix = $optionArray["prefix"];
	$bitValue = $optionArray["bitValue"];

	//display all permissions that belong to this app
	$sql = "SELECT * FROM $table";

	if ($filter) $sql .= " WHERE $filter='$filterValue'";

	$sql .= " ORDER BY bitpos";

	$query_return = report_query($conn,$sql);

	$perm_id_array 		= 	array_result("id",$query_return[0],$query_return[1]);
	$perm_name_array 	= 	array_result("name",$query_return[0],$query_return[1]);
	$perm_bitpos_array 	= 	array_result("bitpos",$query_return[0],$query_return[1]);
	$perm_owner_array 	= 	array_result("owner",$query_return[0],$query_return[1]);

	$string = "<table border=0 cellpadding=0 cellspacing=0>";

	//display an error message if no perms exist for this app
	if (count($perm_id_array)==0) $string .= "<tr><td>No permissions are defined.</td></tr>";
	else {

		for ($num=0;$num<count($perm_id_array);$num++) {

			$bitSet = factorial($perm_bitpos_array[$num]);

			$hideCheckbox = null;

			//if ($bitSet == $bitAdmin) if (!(bitset_section(BITSET,ADMIN,null))) $hideCheckbox = 1;

			if (!$hideCheckbox) {

				if ($bitValue & $bitSet) $checked = " CHECKED ";
				else $checked = null;

				$string .= "<tr><td valign=top >";
				$string .= "<table cellpadding=0 cellspacing=0><tr><td>";

				//add extra cells if this is a subPerm
				if ($perm_owner_array[$num]!="0") $string .= getOwner(	$bitpos,
											$perm_owner_array,
											$perm_bitpos_array,
											null);

				//create id of checkbox
				$idValue = $prefix."Perm".$perm_bitpos_array[$num];

				//get id of checkbox owner if there is one
				if ($perm_owner_array[$num]!=0) $passId = $prefix."Perm".$perm_owner_array[$num];
				else $passId="0";

				//print out the checkbox
				$string .= "<input type=checkbox
					id=\"".$idValue."\"
					name=\"".$prefix."Permission[]\"
					".$checked."
					value=\"".$bitSet."\">&nbsp;";

				$string .= "</td><td colspan=5>";

				$string .= $perm_name_array[$num];

				$string .= "</td></tr></table>";
				$string .= "</td></tr>";
			}
		}
	}
	$string .= "</table>";

	return $string;

}


function fileExtension($file) {

	$pos = strrpos($file,".");
	if ($pos == "0") return false;
	else {

		$ext = strtolower(substr($file,$pos));

		return $ext;

	}
}

function fileIncludeType($ext) {

	$imageArray = array(	".jpg",
							".png",
							".bmp",
							".gif",
							".tif",
							".tiff",
							".jpeg"
							);

	$embedArray = array(	".avi",
							".pdf",
							".mov",
							".doc"
							);



	if (in_array($ext,$embedArray)) return "embed";
	elseif (in_array($ext,$imageArray)) return "image";
	else return "include";

}

function login_return($conn,$id) {

	//return anonymous if there is no id
	if ($id=="0" || !$id) return "Anonymous";

	$sql = "SELECT login FROM auth_accounts WHERE id='$id'";

	if ($value = single_result($conn,$sql)) return $value["login"];
	else return false;

}

function getSiteSettings($conn) {

	//run a query to get all modules for this application
	$sql = "SELECT * FROM site_properties ORDER BY sort_order";
	$siteArray = total_result($conn,$sql);

	if ($siteArray) {

		$siteModSettings = array(
							"modId" 		=> 	$siteArray["id"],
							"modName" 		=> 	$siteArray["module_name"],
							"modType" 		=> 	$siteArray["module_type"],
							"modDirectory" 	=> 	$siteArray["module_directory"],
							"modHidden" 	=> 	$siteArray["hidden"],
							"modPerm"		=>	$siteArray["perm_name"],
							"modPermError" 	=>	$siteArray["perm_message"],
							"modOwner"		=>	$siteArray["owner"],
							"modAuth"		=>	$siteArray["auth_only"],
							"modDefine"		=>	$siteArray["define_name"]
							);

	}
	else {
		die("<h4 align=center>Error!  No modules are configured in this system</h4>");
	}

	return $siteModSettings;

}

function functionMenu($tableName,$nameList,$functionList) {


	$string = "<table id=\"".$tableName."\" style=\"visibility:hidden\" class=\"functionMenu\" onMouseLeave=\"hideFunctionMenu('".$tableName."');\" cellpadding=0 cellspacing=0>";

	for ($row=0;$row<count($nameList);$row++) {

		$id = $tableName."Cell".$row;

		$string .= "
			<tr><td id=\"".$id."\" class=\"functionMenuCell\"
					onMouseOver=\"changeStyle('".$id."','highlight');\"
					onMouseOut=\"changeStyle('".$id."','normal');\"
					unselectable=\"on\"
					onClick=\"".$functionList[$row].";\"
					>
				".$nameList[$row]."
			</td></tr>
			";
	}

	$string .= "</table>";

	return $string;

}

function createDropdown($optionArray) {

	$table = $optionArray["table"];				//the table we are querieing
	$fieldName = $optionArray["fieldName"];		//the field name which is display in the dropdown
	$fieldValue = $optionArray["fieldValue"];	//the value of the dropdown option if diff from fieldName
	$limitField = $optionArray["limitField"];	//record limiter for teh query
	$limitValue = $optionArray["limitValue"];	//value we limit records to
	$value = $optionArray["value"];				//value of existing entry
	$name = $optionArray["name"];				//name of the form
	$conn = $optionArray["conn"];				//sql conn resource id
	$size = $optionArray["size"];				//size of the dropdown
	$nullValue = $optionArray["nullValue"];		//0 entry for dd
	$order = $optionArray["order"];				//order by
	$change = $optionArray["change"];			//dropdown change value

	if ($change) $changeValue = "onChange=\"".$change.";\"";

	//the fields we are looking for
	$query = $fieldName;
	if ($fieldValue) $query .= ",".$fieldValue;

	if (!$fieldValue) $fieldValue = $fieldName;

	$sql = "SELECT $query FROM $table";
	if ($limitField) $sql .= " WHERE $limitField = $limitValue ";
	if ($order) $sql .= " ORDER BY $order";

	$ddInfo = total_result($conn,$sql);

	$string = "<select name=\"".$name."\" id=\"".$name."\" size=\"".$size."\" ".$changeValue.">";

	if ($nullValue) $string .= "<option value=\"0\">".$nullValue;

	for ($row=0;$row<count($ddInfo[$fieldName]);$row++) {

		if ($value==$ddInfo[$fieldValue][$row]) $selected = " SELECTED ";
		else $selected = null;

		$string .= "<option value=\"".$ddInfo[$fieldValue][$row]."\" ".$selected.">".$ddInfo[$fieldName][$row];

	}

	$string .= "</select>";

	return $string;

}

function pageIdReturn($option) {

	if ($option["calendarId"]) $sql = "SELECT page_id FROM in_calendar WHERE id='".$option["calendarId"]."'";
	elseif ($option["articleId"]) $sql = "SELECT page_id FROM in_news WHERE id='".$option["articleId"]."'";

	if ($sql) {

		$pageInfo = single_result($option["conn"],$sql);
		if ($pageInfo) return $pageInfo["page_id"];

	}

	return false;

}


/****************************************************************************************************

	Function:   dropdown_generate
	Purpose:  Queries the table and generates a dropdown form on the entry form

****************************************************************************************************/

function dropdown_generate($table,$field,$name,$size,$order,$value_field,$current_value,
				$value,$filter_field,$filter,$null_field,$dd_jscript,$conn) {



  /*************** Run the query to display data for the standard drop down boxes ***************/

  /* This determines what field will be shown on a news edit window */

  if ($current_value) {

    /*  This determines the id of the selected club and returns it as $dropdown_id */

    $sql="SELECT id FROM $table WHERE $value_field='$current_value'";

    $query_return=report_query($conn,$sql);

    if ($query_return[1]!=0) {

      $query_myrow=single_myrow_result($query_return[0],0);

      $dropdown_id=$query_myrow["id"];


    }

  }

/********************* Display a dropdown box for an entry form *****************************/

  /*  Figure out what clubs we have and list them in a dropdown */

	$sql = "SELECT * FROM $table";

	if ($filter) $sql .= " WHERE $filter_field='$filter'";

	$sql .= " ORDER BY $order";

  	$query_return=report_query($conn,$sql);

	if (!defined("READONLY")) {

	    	echo "<SELECT NAME=".$name." SIZE=".$size." class=\"dropdown\"";

		if ($dd_jscript) echo " ".$dd_jscript." ";

 	  	echo ">";

	}

	if ($query_return[1]!=0) {

		$id_array = array_result("id",$query_return[0],$query_return[1]);
		$name_array = array_result($field,$query_return[0],$query_return[1]);

		if (defined("READONLY")) {

			echo "<div class=\"readSelect\">";
			for ($row=0;$row<count($id_array);$row++) {

				if ($current_value == $id_array[$row]) echo $name_array[$row];

			}
			echo "</div>";

		}
		else {

			$dd_array = array($dropdown_id,$field);

			if ($null_field) echo "<OPTION value=0>".$null_field;

			for ($row=0;$row<count($id_array);$row++) {

				echo "<option ";

				if ($current_value==$id_array[$row]) echo " SELECTED ";

				echo " VALUE='".$id_array[$row]."'> ".$name_array[$row];

				}

		}
	}

	if (!defined("READONLY")) echo "</SELECT>";

}


function name_return($conn,$table,$field,$id) {

	$sql="SELECT $field FROM $table WHERE id='$id'";

	$query_return=report_query($conn,$sql);

	if ($query_return[1]!=0) {
		$query_myrow=single_myrow_result($query_return[0],0);
		$name=$query_myrow[$field];
		return $name;
	}
}

