<?php
session_start();

include("header/header.inc.php");

//get our module information for our file includes

if ($_POST["module"]) $module = $_POST["module"];
elseif ($_GET["module"]) $module = $_GET["module"];

//here we will call the default module
if (!$module) $module = DEFAULT_MOD;

$key = array_search($module,$siteModSettings["modId"]);

/*********************************************************************
	set the constant from the value given in the database.  We can
	reference different modules with those define names
*********************************************************************/
for ($row=0;$row<count($siteModSettings["modDefine"]);$row++) {

	$defineName = $siteModSettings["modDefine"][$row];
	$defineValue = $siteModSettings["modId"][$row];

	define($defineName,"$defineValue");

}

//permissions time.  Check to see if we defined a permission limit for this page,
//and if the user qualifies.  We only do this if the user is logged in

function modOwnerRetrieve($id,$siteModSettings,$ownerArray) {

	$key = array_search($id,$siteModSettings["modId"]);

	$owner = $siteModSettings["modOwner"][$key];

	//if 0, we have reached the top.  Just return the array as is.
	if ($owner=="0") return $ownerArray;
	else {

		//this one also is owned by another module.  Add to the array and check again
		$ownerArray[] = $owner;

		$ownerArray = modOwnerRetrieve($owner,$siteModSettings,$ownerArray);

		//return the new ownerArray
		return $ownerArray;

	}

}

/****************************************************************************************
	make sure this user can access this module
*****************************************************************************************/

if (defined("USER_ID")) {

	//we need to get the key of any owners of this module.  This should be recursive.

	$modArray = array($module);

	if ($siteModSettings["modOwner"][$key]!="0") {

		//get the id of the owner
		$owner = $siteModSettings["modOwner"][$key];

		//start our our array
		$modArray[] = $owner;

		//recurse through and store all owners in an array
		$modArray = modOwnerRetrieve($owner,$siteModSettings,$modArray);

	}

	/**********************************************************************************
		now loop through our Mod array and do a perm check for each module.
		the user has to be cleared through a parent module and the current module
		before the current page can be displayed
	**********************************************************************************/

	for ($row=0;$row<count($modArray);$row++) {

		//get the key for the current id
		$permKey = array_search($modArray[$row],$siteModSettings["modId"]);

		//get the perm name
		$permCheck = $siteModSettings["modPerm"][$permKey];

		//is an error check defined?  If it is, get the value
		if (defined("$permCheck")) {

			$checkValue = constant("$permCheck");

			//get our error message
			$errorPermMessage = $siteModSettings["modPermError"][$permKey];

			//run our permissions check
			if (!bitset_compare(BITSET,$checkValue,ADMIN)) $permError = 1;

		}

	}

}

//only show if we are not displaying a login
if (!$show_login_form) {

	$modPath = getPath($siteModSettings,$module,null);

	//determine our process file and our display file
	$process_path = "modules/".$modPath."process.php";
	$display_path = "modules/".$modPath."display.php";

	//define our current module constants
	define("CUR_MOD_NAME",$siteModSettings["modName"][$key]);
	define("CUR_MOD_USE",$siteModSettings["modUse"][$key]);
	define("CUR_MOD_ID",$siteModSettings["modId"][$key]);

	//call our process module if necessary, only if the user is logged in, and only if the permissions are right
	if (file_exists("$process_path") && !$permError) include("$process_path");

	//define our display module if there is one
	if (file_exists("$display_path")) define("DISPLAY_MODULE","$display_path");

}

//create our navigation bar and toolbar
include("header/navbar.inc.php");

//call our templated header
if (!include("header/".HEADER)) echo "<h4 align=center>The template ".HEADER." does not exist</h4>";

//call the bottom header only if there is not a permissions error
if (!$permError) include("header/bottom_header.inc.php");
else die("<h4 align=center>You are not allowed to $errorPermMessage </h4>");


