/*
 * $Source: /usr/local/cvsroot/erserver/erserver/java/src/com/postgres/replic/util/struct/SnapshotDataRow.java,v $
 * $Author: ronz $ $Revision: 1.2 $ $Date: 2004/03/09 17:13:44 $
 *
 */

package com.postgres.replic.util.struct;

import java.util.*;

public class SnapshotDataRow implements DataConst {

	// Key uniquely identifying the row (for deletes - this is the only
	// parameter necessary):
	private String key;
	private long lastsid;
	private boolean useoid;

	// Possible values of lastsid:
	public static final int THIS = -999;
	public static final int ANY = -9999;

	// Array list of Strings containing data for update or insert:
	private ArrayList dataArray = new ArrayList();

	public SnapshotDataRow(String key, long lastsid, boolean useoid) throws Exception {
		this.key = key;
		this.lastsid = lastsid;
		this.useoid = useoid; //RONZ: This was forgotten...so useOid() always returned false;
	}

	public boolean useOid() {
		return this.useoid;
	}

	public void setUseOid(boolean useoid) {
		this.useoid = useoid;
	}

	public void setLastSid(long lastsid) {
		this.lastsid = lastsid;
	}

	public long getLastSid() {
		return lastsid;
	}

	public void add(String data) {
		dataArray.add(data);
	}

	public String get(int i) {
		return (String) dataArray.get(i);
	}

	public long getLong(int i) {
		return (new Long((String) dataArray.get(i))).longValue();
	}

	public void remove(int i) {
		dataArray.remove(i);
	}

	public int size() {
		return dataArray.size();
	}

	public String getKey() {
		return key;
	}

	public long getKeyLong() {
		return key == null ? 0 : new Long(key).longValue();
	}

	public int getKeyInt() {
		return key == null ? 0 : new Integer(key).intValue();
	}
}
