/*
 * TableIndex.java
 *
 * Created on 31 de julio de 2002, 10:09
 */

package pgclibrary.objects;
import pgclibrary.dataaccess.*;
import pgclibrary.utilities.*;
import java.sql.*;
import java.util.*;

/**
 *
 * @author  nestor
 */
public class TableIndex extends DBObject {
    private boolean clustered = false;
    private boolean keytype = false;
    private boolean unique = false;
    private boolean primary = false;
    private Vector columns = null;
    
    /** Creates a new instance of TableIndex */
    public TableIndex(DBObject owner, long oid) {
        super(owner);
        search(oid);
    }
    
    /** Retrieve the SQL string that eliminate this object from
     * the database.
     * @return SQL DML string.
     */
    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer(50);
        retorno.append(" DROP INDEX ");
        retorno.append(getName()).append(";\n");
        return retorno.toString();
    }
    
    /** Returns the SQL string that
     * generate this object.
     * @return SQL DML instruction for generation.
     */
    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer();
        if(isPrimary()){
            retorno.append("CONSTRAINT ");
            retorno.append(getName());
            retorno.append(" PRIMARY KEY (");
            retorno.append(getColumnsText());
            retorno.append(" ) \n");
        } else {
            retorno.append("CREATE ");
            if(isUnique()){
                retorno.append("UNIQUE ");
            }
            retorno.append("INDEX ");
            retorno.append(getName());
            retorno.append(" ON ");
            retorno.append(getOwner().getName());
            retorno.append(" ( ");
            retorno.append(getColumnsText());
            retorno.append(" ); \n");
        }
        return retorno.toString();
    }
    
    /** Retrieve the SQL String that implements this
     * object modifications.
     * @return SQL DML String.
     */
    public String getUpdateSQL() {
        return new String();
    }
    
    /** Find the object asociated with the OID.
     * @param _oid OID to search.
     * @return true if the object was found
     */
    public boolean search(long _oid) {
        boolean retorno = false;
        try{
            PreparedStatement prep = getConnection().prepareStatement("select "
            + " indexrelid as oid, RELNAME as INDNAME, "
            + " INDISCLUSTERED, INDHASKEYTYPE, "
            + " INDISUNIQUE, INDISPRIMARY "
            + " from pg_index, pg_class "
            + " where pg_class.oid = indexrelid and indexrelid = ? ");
            prep.setLong(1, _oid);
            ResultSet rs = prep.executeQuery();
            if((rs != null) && (rs.next())){
                setOID(rs.getLong("OID"));
                setName(rs.getString("INDNAME"));
                setClustered(rs.getBoolean("INDISCLUSTERED"));
                setHasKeyType(rs.getBoolean("INDHASKEYTYPE"));
                setUnique(rs.getBoolean("INDISUNIQUE"));
                setPrimary(rs.getBoolean("INDISPRIMARY"));
                retorno = true;
            }
            rs.close();
            prep.close();
        } catch (SQLException e){}
        return retorno;
    }
    
    public void initialize(){
        super.initialize();
        clustered = false;
        keytype = false;
        unique = false;
        primary = false;
        columns = null;
    }
    
    
    // -----SET AND GET-------
    public Vector getColumns(){
        if(columns == null){
            columns = new Vector();
            try{
                PreparedStatement prep = getConnection().prepareStatement(
                "select *  from pg_attribute "
                + "     where attrelid=? AND ATTNUM > 0");
                prep.setLong(1, getOID());
                
                ResultSet rs = prep.executeQuery();
                while(rs.next()){
                    TableColumn tc = new TableColumn(this, rs.getLong("ATTNUM"));
                    columns.add(tc);
                }
                rs.close();
                prep.close();
            } catch (SQLException e){
            }
        }
        return columns;
    }
    public String getColumnsText(){
        StringBuffer retorno = new StringBuffer();
        for(int i=0; i<getColumns().size(); i++){
            TableColumn tc = (TableColumn) columns.get(i);
            retorno.append(tc.getName());
            if(i<columns.size()-1){
                retorno.append(", ");
            }
        }
        return retorno.toString();
    }
    
    public boolean isClustered(){
        return clustered;
    }
    public void setClustered(boolean _clustered){
        clustered = _clustered;
    }
    private void setHasKeyType(boolean _keytype){
        keytype = _keytype;
    }
    public boolean hasKeyType(){
        return keytype;
    }
    public boolean isUnique(){
        return unique;
    }
    public void setUnique(boolean _unique){
        unique = _unique;
    }
    
    public boolean isPrimary(){
        return primary;
    }
    public void setPrimary(boolean _primary){
        primary = _primary;
    }
    
}

