/*
 * Decompiled with CFR 0.152.
 */
package frames;

import frames.PrincipalFrameComponent;
import frames.PrincipalFrameListener;
import frames.PrincipalFrameMenu;
import frames.PrincipalFrameToolbar;
import frames.SQLExecutionFrame;
import frames.closeAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.sql.SQLException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import pgclibrary.dataaccess.MainConnection;
import pgclibrary.objects.Database;
import pgclibrary.treeObjects.TreeInfo;
import pgclibrary.utilities.SystemProps;

public class PrincipalFrame
extends JFrame {
    private PrincipalFrameListener listener = null;
    private Database current_database = new Database(null, 0L);
    private SystemProps systemProperties = new SystemProps();
    private PrincipalFrameToolbar toolbar = null;
    private PrincipalFrameComponent component = null;
    private PrincipalFrameMenu menu = null;

    public PrincipalFrame() {
        super("PGCup - Postgress Administration Tool");
        this.listener = new PrincipalFrameListener(this);
        this.menu = new PrincipalFrameMenu(this);
        this.toolbar = new PrincipalFrameToolbar(this);
        this.component = new PrincipalFrameComponent(this);
        this.setJMenuBar(this.menu);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.getContentPane().add((Component)this.component, "Center");
        try {
            ((Component)this).setLocation(Integer.parseInt(this.systemProperties.getProperty("MAIN_WINDOW_POSX")), Integer.parseInt(this.systemProperties.getProperty("MAIN_WINDOW_POSY")));
            this.component.setPreferredSize(new Dimension(Integer.parseInt(this.systemProperties.getProperty("MAIN_WINDOW_WIDTH")), Integer.parseInt(this.systemProperties.getProperty("MAIN_WINDOW_HEIGHT"))));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addWindowListener(new closeAdapter(this));
        this.refreshValidation();
    }

    public void updateSelectedObject(TreeInfo _obj) {
        this.component.updateSelectedObject(_obj);
    }

    public void openNewSQLWindow() {
        SQLExecutionFrame tmp = new SQLExecutionFrame(this);
        tmp.show();
    }

    public void disconnect() {
        this.current_database = new Database(null, 0L);
        this.refreshData();
        this.refreshValidation();
    }

    public void refreshData() {
        this.component.refreshTree();
        this.refreshValidation();
        this.repaint();
    }

    public void refreshValidation() {
        this.toolbar.refreshValidation();
        this.menu.refreshValidation();
        this.component.refreshValidation();
    }

    public void vacuum() {
        if (this.current_database != null && this.current_database.validate()) {
            try {
                this.current_database.getConnection().executeUpdate("VACUUM");
            }
            catch (SQLException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Command Error", 0);
            }
        }
    }

    public Database getDatabase() {
        return this.current_database;
    }

    public void setDatabase(MainConnection _connection) {
        this.current_database = new Database(_connection);
    }

    public SystemProps getSystemProperties() {
        return this.systemProperties;
    }

    public PrincipalFrameListener getListener() {
        return this.listener;
    }

    public void close() {
        this.systemProperties.setProperty("MAIN_WINDOW_POSX", String.valueOf((int)this.getLocation().getX()));
        this.systemProperties.setProperty("MAIN_WINDOW_POSY", String.valueOf((int)this.getLocation().getY()));
        this.systemProperties.setProperty("MAIN_WINDOW_HEIGHT", String.valueOf((int)this.component.getSize().getHeight()));
        this.systemProperties.setProperty("MAIN_WINDOW_WIDTH", String.valueOf((int)this.component.getSize().getWidth()));
        this.systemProperties.writeProperties();
        System.exit(0);
    }
}

