/*
 * DataPanel.java
 *
 * Created on 31 de julio de 2002, 16:53
 */

package components.table;
import components.*;
import javax.swing.*;
import java.awt.*;
import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;
import java.util.*;
import java.sql.*;

/**
 *
 * @author  nestor
 */
public class DataPanel extends JPanel{
    private Table table = null;
    private SQLTable data_table = new SQLTable();
    private DataPanelListener listener = null;
    private Hashtable tales_order = new Hashtable(100);
    
    /** Creates a new instance of DataPanel */
    public DataPanel() {
        data_table = new SQLTable();
        listener = new DataPanelListener(this);
        initPanel();
    }
    private void initPanel(){
        setLayout(new BorderLayout());
        setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        
        SQLTableModel sql_tm = new SQLTableModel(data_table);
        data_table.setModel(sql_tm);
        
        add(new DataPanelToolbar(this), BorderLayout.NORTH);
        add(new JScrollPane(data_table), BorderLayout.CENTER);
    }
    
    public void refresh(){
        data_table.getTableModel().setDataSource(new dataSourceResultSet(table.getConnection(), generateSQL()));
        repaint();
    }
    public void refresh(Table table_object){
        table = table_object;
        refresh();
    }
    
    private String generateSQL(){
        StringBuffer retorno = new StringBuffer();
        if(table != null){
            retorno.append("SELECT * FROM ").append(table.getName());
            Vector order = getOrder();
            if(order.size() > 0){
                retorno.append(" ORDER BY ");
                for(int i= 0; i<order.size(); i++){
                    retorno.append(order.get(i));
                    if(i < (order.size() - 1)){
                        retorno.append(", ");
                    } else {
                        retorno.append(" ");
                    }
                }
            }
        }
        return retorno.toString();
    }
    
    public void addOrder(String _column){
        if ((_column != null) && (getOrderPos(_column) < 0)){
            getOrder().add(_column);
        }
    }
    public void clearOrder(){
        getOrder().removeAllElements();
    }
    public int getOrderPos(String _column){
        int retorno = -1;
        Vector order = getOrder();
        for(int i=0 ; (i<order.size()) && (retorno < 0); i++){
            if (((String) order.get(i)).equals(_column)){
                retorno = i;
            }
        }
        return retorno;
    }
    
    public Vector getOrder(){
        Vector retorno = (Vector) tales_order.get(table.getName());
        if(retorno == null){
            retorno = new Vector();
            tales_order.put(table.getName(), retorno);
        }
        return retorno;
    }
    
    public Table getTable(){
        return table;
    }
    
    public DataPanelListener getListener(){
        return listener;
    }
    
    public void showOrderDialog(){
        (new DataPanelOrderDialog(this)).show();
    }
    public void newRecord(){
        new TableAddRecordDialog(getTable()).show();
        refresh();
    }
    public void editRecord(){
        int selected = data_table.getSelectedRow();
        if(table.getPrimaryKeys().size() > 0){
            Vector index_data = new Vector();
            for(int i= 0; i<data_table.getColumnCount(); i++){
                index_data.add(data_table.getValueAt(selected, i));
            }
            new TableEditRecordDialog(getTable(), index_data).show();
        } else {
            JOptionPane.showMessageDialog(this, "Table has no primary keys defined." , "Error", JOptionPane.INFORMATION_MESSAGE);
        }
        refresh();
    }
    public void deleteRecord(){
        if(JOptionPane.showConfirmDialog(this, "Delete selected records ?" , "Error.", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION) {
            if(table.getPrimaryKeys().size() > 0){
                Vector columns = ((TableIndex) table.getPrimaryKeys().get(0)).getColumns();
                int[] columnsidx = new int[columns.size()];
                for(int i= 0; i<columns.size(); i++){
                    columnsidx[i] = table.getColumnIndex(((TableColumn) columns.get(i)).getName());
                }
                
                int[] selected = data_table.getSelectedRows();
                for(int i=0; i<selected.length; i++){
                    for(int j =0; j<columnsidx.length; j++){
                        Vector temp = new Vector();
                        temp.add(data_table.getValueAt(selected[i], columnsidx[j]+1));
                        try {
                            table.deleteRecord(temp);
                        } catch (SQLException e) {
                            JOptionPane.showMessageDialog(this, e.getMessage() , "Error.", JOptionPane.INFORMATION_MESSAGE);
                        }
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this, "Table has no primary keys defined." , "Error", JOptionPane.INFORMATION_MESSAGE);
            }
        }
        refresh();
    }
}
