/*
 * DBObject.java
 *
 * Created on 30 de julio de 2002, 15:27
 */

package pgclibrary.objects;
import pgclibrary.dataaccess.*;
import java.sql.*;

/** This class implements the interface for all
 * database objects that interacts with the database.
 * @author nestor
 */
public abstract class DBObject {
    private DBObject owner = null;
    
    private User creator = null;
    private String name = new String();
    private long oid = -1;
    private String description = null;
    
    /** Creates a new instance of DBObject
     * @param _owner The owner DBObject for this object.
     */
    public DBObject(DBObject _owner) {
        setOwner(_owner);
    }
    
    /** Returns the SQL string that
     * generate this object.
     * @return SQL DML instruction for generation.
     */
    public abstract String getInsertSQL();
    
    /** Retrieve the SQL string that eliminate this object from
     * the database.
     * @return SQL DML string.
     */
    public abstract String getDeleteSQL();
    
    /** Retrieve the SQL String that implements this
     * object modifications.
     * @return SQL DML String.
     */
    public abstract String getUpdateSQL();
    
    /** Find the object asociated with the OID.
     * @param _oid OID to search.
     * @return true if the object was found
     */
    public abstract boolean search(long _oid);
    
    /** Initialize all properties
     */
    protected void initialize(){
        name = new String();
        oid = -1;
        description = null;
    }
    
    /** refresh the data from database.
     * if oid>0. Elsewere no action.
     */
    public void refresh(){
        if(oid > 0){
            search(oid);
        }
    }
    
    public DBObject getOwner(){
        return owner;
    }
    protected void setOwner(DBObject _owner){
        owner = _owner;
    }
    
    protected void setCreator(User _creator){
        creator = _creator;
    }
    public User getCreator(){
        return creator;
    }
    
    protected void setOID(long _oid){
        oid = _oid;
    }
    public long getOID(){
        return oid;
    }
    
    public String getName(){
        return name;
    }
    public void setName(String _name){
        if(_name != null){
            name = _name;
        } else {
            name = new String();
        }
    }
    public String getDescription(){
        if(description == null){
            try{
                PreparedStatement prep = getConnection().prepareStatement("select * from pg_description where OBJOID = ?");
                prep.setLong(1, getOID());
                ResultSet rs = prep.executeQuery();
                if(rs.next()){
                    setDescription(rs.getString("DESCRIPTION"));
                } else {
                    setDescription(new String());
                }
                rs.close();
                prep.close();
            } catch (SQLException e){}
        }
        return description;
    }
    public void setDescription(String _description){
        if(_description != null){
            description = _description;
        } else {
            description = new String();
        }
    }
    
    /** Retrieve the MainConnection for database communications.
     * @return MainConnection to inteact.
     */
    public MainConnection getConnection(){
        return getOwner().getConnection();
    }
}
