/*
 * Database.java
 *
 * Created on 30 de julio de 2002, 15:49
 */

package pgclibrary.objects;
import pgclibrary.dataaccess.*;
import java.sql.*;
import java.util.*;

/**
 *
 * @author  nestor
 */
public class Database extends DBObject {
    protected static MainConnection connection = null;
    
    private String encoding = new String();
    private String template = new String();
    private String location = new String();
    private boolean isTemplate = false;
    private boolean allowConnections = false;
    
    /** Creates a new instance of Database */
    public Database(MainConnection _connection) {
        super(null);
        setConnection(_connection);
        if(validate()) {
             search( getConnection().getDatabaseName());
        }
    }
    
    public Database(MainConnection _connection, String _name) {
        super(null);
        setConnection(_connection);
        search(_name);
    }
    
    /** Retrieve the SQL string that eliminate this object from
     * the database.
     * @return SQL DML string.
     */
    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("DROP DATABASE ");
        retorno.append(getName());
        retorno.append(";\n ");
        return retorno.toString();
    }
    
    /** Returns the SQL string that
     * generate this object.
     * @return SQL DML instruction for generation.
     */
    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("CREATE DATABASE ");
        retorno.append(getName()).append(" ");
        
        if ((getLocation().length() > 0)
        || (getTemplate().length() > 0)
        || (getEncoding().length() > 0)){
            retorno.append("WITH ");
            if(getLocation().length() > 0){
                retorno.append("LOCATION='").append(getLocation()).append("' ");
            }
            if(getTemplate().length() > 0){
                retorno.append("TEMPLATE=").append(getTemplate()).append(" ");
            }
            if(getEncoding().length() > 0){
                retorno.append("ENCODING=").append(getEncoding()).append(" ");
            }
        }
        
        retorno.append(";\n ");
        
        return retorno.toString();
    }
    
    /** Retrieve the SQL String that implements this
     * object modifications.
     * @return SQL DML String.
     */
    public String getUpdateSQL() {
        return new String();
    }
    
    /** Find the object asociated with the name.
     * @param _name name to search.
     * @return true if the object was found
     */
    public boolean search(String _name) {
        boolean retorno = false;
        if(validate()){
            try{
                initialize();
                ResultSet rs = getConnection().getQueryGenerator().getDatabases(_name);
                if ((rs != null) && (rs.next())){
                    setName(rs.getString("DATABASE_NAME"));
                    setDBA(rs.getString("DATABASE_DBA"));
                    setTemplate(rs.getBoolean("DATABASE_TEMPLATE"));
                    setAllowConnections(rs.getBoolean("DATABASE_ALLOWCONN"));
                    retorno = true;
                }
                rs.close();
                rs.getStatement().close();
            } catch (SQLException e){
                e.printStackTrace();
            }
        }
        return retorno;
    }
    
    protected void initialize() {
        super.initialize();
        isTemplate = false;
        allowConnections = false;
    }
    
    // ------------ SET AND GET  ---------
    public boolean isTemplate(){
        return isTemplate;
    }
    public void setTemplate(boolean _isTemplate){
        isTemplate = _isTemplate;
    }
    
    public boolean allowConnections(){
        return allowConnections;
    }
    public void setAllowConnections(boolean _allowConnections){
        allowConnections = _allowConnections;
    }
    
    private void setDBA(User _user){
        setCreator(_user);
    }
    private void setDBA(String _user){
        setCreator(new User(this, _user));
    }
    public User getDBA(){
        return getCreator();
    }
    
    public void setEncoding(String _encoding){
        if(_encoding != null){
            encoding = _encoding;
        } else {
            encoding = new String();
        }
    }
    public String getEncoding(){
        return encoding;
    }
    
    public void setTemplate(String _template){
        if(_template != null){
            template = _template;
        } else {
            template = new String();
        }
    }
    public String getTemplate(){
        return template;
    }
    
    public void setLocation(String _location){
        if(_location != null){
            location = _location;
        } else {
            location = new String();
        }
    }
    public String getLocation(){
        return location;
    }
    
    private static void setConnection(MainConnection _connection){
        connection = _connection;
    }
    public MainConnection getConnection(){
        return connection;
    }
    public static MainConnection getMainConnection(){
        return connection;
    }
    
    public boolean validate(){
        return connection != null;
    }
    
    /** refresh the data from database.
    */
    public void refresh() {
        search(getName());
    }
    
}
