/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.treeObjects.RootElement;
import components.treeObjects.TreeInfo;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeControlModel
implements TreeModel {
    private RootElement rootDatabase;
    private Vector treeModelListeners = new Vector();

    public TreeControlModel(RootElement rootElement) {
        this.rootDatabase = rootElement;
    }

    public void setNewRoot(RootElement rootElement) {
        this.rootDatabase = rootElement;
        this.fireTreeStructureChanged();
    }

    public void fireTreeStructureChanged() {
        int n = this.treeModelListeners.size();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.rootDatabase});
        int n2 = 0;
        while (n2 < n) {
            ((TreeModelListener)this.treeModelListeners.elementAt(n2)).treeStructureChanged(treeModelEvent);
            ++n2;
        }
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListeners.addElement(treeModelListener);
    }

    public Object getChild(Object object, int n) {
        TreeInfo treeInfo = (TreeInfo)object;
        Object var4_4 = null;
        if (n >= 0 && n < treeInfo.getSize()) {
            var4_4 = treeInfo.getProperties().get(n);
        }
        return var4_4;
    }

    public int getChildCount(Object object) {
        TreeInfo treeInfo = (TreeInfo)object;
        return treeInfo.getSize();
    }

    public int getIndexOfChild(Object object, Object object2) {
        TreeInfo treeInfo = (TreeInfo)object;
        return treeInfo.getPropertyIndex((TreeInfo)object2);
    }

    public Object getRoot() {
        return this.rootDatabase;
    }

    public boolean isLeaf(Object object) {
        TreeInfo treeInfo = (TreeInfo)object;
        if (!treeInfo.isInitialized()) {
            return false;
        }
        return treeInfo.getSize() == 0;
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListeners.removeElement(treeModelListener);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }
}

