/*
 * Decompiled with CFR 0.152.
 */
package components.table;

import components.SQLTable;
import components.SQLTableModel;
import components.table.ColumnPanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pgclibrary.dataaccess.dataSource;
import pgclibrary.dataaccess.dataSourceVector;
import pgclibrary.objects.Table;
import pgclibrary.objects.TableColumn;
import pgclibrary.utilities.Utilities;

public class ColumnPanel
extends JPanel {
    private Table table = null;
    private SQLTable data_table = new SQLTable();
    private ColumnPanelListener listener = new ColumnPanelListener(this);

    public ColumnPanel() {
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        SQLTableModel sQLTableModel = new SQLTableModel(this.data_table);
        this.data_table.setModel(sQLTableModel);
        this.add((Component)new JScrollPane(this.data_table), "Center");
    }

    public void refresh() {
        ((SQLTableModel)this.data_table.getModel()).setDataSource(this.getColumnsTable());
        this.repaint();
    }

    public void refresh(Table table) {
        this.table = table;
        this.refresh();
    }

    public Table getTable() {
        return this.table;
    }

    public ColumnPanelListener getListener() {
        return this.listener;
    }

    public void newColumn() {
    }

    public void editColumn() {
    }

    public void deleteColumn() {
    }

    public dataSource getColumnsTable() {
        dataSourceVector dataSourceVector2 = new dataSourceVector();
        dataSourceVector2.addColumnName("Col #");
        dataSourceVector2.addColumnName("Name");
        dataSourceVector2.addColumnName("Type");
        dataSourceVector2.addColumnName("Size");
        dataSourceVector2.addColumnName("Nulls");
        dataSourceVector2.addColumnName("Default");
        dataSourceVector2.addColumnName("Description");
        dataSourceVector2.addColumnSize(10);
        dataSourceVector2.addColumnSize(20);
        dataSourceVector2.addColumnSize(15);
        dataSourceVector2.addColumnSize(5);
        dataSourceVector2.addColumnSize(5);
        dataSourceVector2.addColumnSize(30);
        dataSourceVector2.addColumnSize(30);
        if (this.table != null) {
            Vector vector = this.table.getColumns();
            int n = 0;
            while (n < vector.size()) {
                TableColumn tableColumn = (TableColumn)vector.get(n);
                Vector<String> vector2 = new Vector<String>();
                vector2.add(String.valueOf(tableColumn.getColumnNumber()));
                vector2.add(tableColumn.getName());
                vector2.add(tableColumn.getColumnType().getName());
                vector2.add(String.valueOf(tableColumn.getSize()));
                vector2.add(Utilities.formatBoolean(tableColumn.allowNulls()));
                vector2.add(tableColumn.getDefaultValue());
                vector2.add(tableColumn.getDescription());
                dataSourceVector2.addElement(vector2);
                ++n;
            }
        }
        return dataSourceVector2;
    }
}

