/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JOptionPane;
import pgclibrary.objects.DBObject;
import pgclibrary.objects.User;

public class Group
extends DBObject {
    int[] user_list = null;
    Vector users = null;

    public Group(DBObject dBObject, String string) {
        super(dBObject);
        this.search(string);
    }

    public Group(DBObject dBObject) {
        super(dBObject);
    }

    public boolean Drop() {
        boolean bl = false;
        try {
            bl = this.getConnection().executeUpdate("DROP GROUP " + this.getName()) > 0;
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(null, sQLException.getMessage(), "Can't drop object", 0);
        }
        return bl;
    }

    public String getDeleteSQL() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("DROP GROUP ");
        stringBuffer.append(this.getName());
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }

    public String getInsertSQL() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("CREATE GROUP ");
        stringBuffer.append(this.getName());
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }

    public boolean search(String string) {
        boolean bl = false;
        try {
            this.initialize();
            ResultSet resultSet = this.getConnection().getQueryGenerator().getGroups(string);
            if (resultSet != null && resultSet.next()) {
                this.setName(resultSet.getString("group_name"));
                this.setUsers(resultSet.getArray("user_list"));
                bl = true;
            }
            resultSet.close();
            resultSet.getStatement().close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return bl;
    }

    public void initialize() {
        super.initialize();
        this.user_list = null;
        this.users = null;
    }

    private int getUserIndex(User user) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.users.size() && n == -1) {
            if (user.getName().equals(((User)this.users.get(n2)).getName())) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    private void verifyUsers() {
        if (this.users == null && this.user_list != null) {
            this.users = new Vector();
            int n = 0;
            while (n < this.user_list.length) {
                long l = this.user_list[n];
                this.users.add(new User((DBObject)this, l));
                ++n;
            }
        } else if (this.users == null) {
            this.users = new Vector();
        }
    }

    public Vector getUsers() {
        this.verifyUsers();
        return this.users;
    }

    public void addUser(User user) {
        this.verifyUsers();
        if (user != null && this.getUserIndex(user) < 0) {
            this.users.add(user);
        }
    }

    public void removeUser(User user) {
        int n;
        this.verifyUsers();
        if (user != null && (n = this.getUserIndex(user)) >= 0) {
            this.users.remove(n);
        }
    }

    public void refresh() {
        this.search(this.getName());
    }

    private void setUsers(Array array) {
        try {
            this.user_list = (int[])array.getArray();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.user_list = null;
        }
    }
}

